const path = require('path');
const webpack = require('webpack');

module.exports = {
  entry: './src/taproot-signer-pure.js',
  output: {
    filename: 'taproot-signer-pure.bundle.js',
    path: path.resolve(__dirname, 'popup'),
    library: 'TaprootSignerPure',
    libraryTarget: 'umd',
    globalObject: '(typeof self !== "undefined" ? self : this)'
  },
  mode: 'production',
  target: 'web',
  // NO WASM!
  experiments: {
    asyncWebAssembly: false
  },
  resolve: {
    fallback: {
      "crypto": false, // Use SubtleCrypto instead
      "stream": require.resolve("stream-browserify"),
      "buffer": require.resolve("buffer/")
    }
  },
  plugins: [
    new webpack.ProvidePlugin({
      Buffer: ['buffer', 'Buffer'],
      process: 'process/browser'
    })
  ]
};






