#!/bin/bash
# 🛡️ PROTEÇÃO CONTRA CORRUPÇÃO DO popup.js
# Execute antes de qualquer commit na extension!

echo "🔍 Verificando popup.js..."

POPUP_FILE="popup/popup.js"
MIN_LINES=14000
EXPECTED_LINES=15783

# Verificar se arquivo existe
if [ ! -f "$POPUP_FILE" ]; then
    echo "❌ ERRO: $POPUP_FILE não encontrado!"
    exit 1
fi

# Contar linhas
LINES=$(wc -l < "$POPUP_FILE" | tr -d ' ')
echo "📊 Linhas atuais: $LINES (esperado: ~$EXPECTED_LINES)"

# Verificar mínimo de linhas
if [ "$LINES" -lt "$MIN_LINES" ]; then
    echo ""
    echo "❌ ═══════════════════════════════════════════════════════════════"
    echo "   CRITICAL: popup.js está CORROMPIDO!"
    echo "   Arquivo tem $LINES linhas, deveria ter $EXPECTED_LINES+"
    echo "═══════════════════════════════════════════════════════════════"
    echo ""
    echo "🔧 Para restaurar, execute:"
    echo "   git checkout 3d4e3f5 -- popup/popup.js"
    echo ""
    exit 1
fi

# Verificar funções críticas
echo ""
echo "🔍 Verificando funções críticas..."

CRITICAL_FUNCS=(
    "loadMarketData"
    "loadInscriptionsMarket"
    "loadRunesMarket"
    "sendRuneTransaction"
    "loadWalletData"
    "switchTab"
    "showSeparateAssetsScreen"
    "showSplitRunesScreen"
    "showBulkRuneSenderScreen"
    "handleMultiSend"
)

MISSING=0
for func in "${CRITICAL_FUNCS[@]}"; do
    if grep -q "$func" "$POPUP_FILE"; then
        echo "   ✅ $func"
    else
        echo "   ❌ MISSING: $func"
        MISSING=1
    fi
done

echo ""

if [ $MISSING -eq 1 ]; then
    echo "❌ ═══════════════════════════════════════════════════════════════"
    echo "   CRITICAL: Funções importantes estão FALTANDO!"
    echo "═══════════════════════════════════════════════════════════════"
    echo ""
    echo "🔧 Para restaurar, execute:"
    echo "   git checkout 3d4e3f5 -- popup/popup.js"
    echo ""
    exit 1
fi

echo "✅ ═══════════════════════════════════════════════════════════════"
echo "   popup.js está SAUDÁVEL! ($LINES linhas, todas funções presentes)"
echo "═══════════════════════════════════════════════════════════════"
echo ""











