// 🔧 CRITICAL: Polyfills for browser compatibility (Node.js libs need these)
// Moved from inline script to external file for CSP compliance

// Process polyfill
if (typeof globalThis !== 'undefined' && typeof globalThis.process === 'undefined') {
  globalThis.process = { version: 'v18.0.0', env: {}, browser: true };
}
if (typeof window !== 'undefined' && typeof window.process === 'undefined') {
  window.process = { version: 'v18.0.0', env: {}, browser: true };
}

// Complete Buffer polyfill with all methods needed by bitcoinjs-lib
(function() {
  if (typeof window !== 'undefined' && typeof window.Buffer !== 'undefined') return;
  
  class BufferPolyfill extends Uint8Array {
    static from(data, encoding) {
      if (data instanceof BufferPolyfill) return data;
      if (data instanceof Uint8Array) return new BufferPolyfill(data);
      if (typeof data === 'string') {
        if (encoding === 'hex') {
          const bytes = new Uint8Array(data.length / 2);
          for (let i = 0; i < data.length; i += 2) {
            bytes[i / 2] = parseInt(data.substr(i, 2), 16);
          }
          return new BufferPolyfill(bytes);
        }
        return new BufferPolyfill(new TextEncoder().encode(data));
      }
      if (Array.isArray(data)) return new BufferPolyfill(data);
      return new BufferPolyfill(data);
    }
    static alloc(size, fill) { const buf = new BufferPolyfill(size); if (fill !== undefined) buf.fill(fill); return buf; }
    static allocUnsafe(size) { return new BufferPolyfill(size); }
    static isBuffer(obj) { return obj instanceof BufferPolyfill || obj instanceof Uint8Array; }
    static concat(list, totalLength) {
      if (!totalLength) totalLength = list.reduce((acc, buf) => acc + buf.length, 0);
      const result = new BufferPolyfill(totalLength);
      let offset = 0;
      for (const buf of list) { result.set(buf, offset); offset += buf.length; }
      return result;
    }
    equals(other) { if (this.length !== other.length) return false; for (let i = 0; i < this.length; i++) { if (this[i] !== other[i]) return false; } return true; }
    compare(other) { const len = Math.min(this.length, other.length); for (let i = 0; i < len; i++) { if (this[i] < other[i]) return -1; if (this[i] > other[i]) return 1; } if (this.length < other.length) return -1; if (this.length > other.length) return 1; return 0; }
    toString(encoding) { if (encoding === 'hex') { return Array.from(this).map(b => b.toString(16).padStart(2, '0')).join(''); } return new TextDecoder().decode(this); }
    slice(start, end) { return new BufferPolyfill(super.slice(start, end)); }
    subarray(start, end) { return new BufferPolyfill(super.subarray(start, end)); }
    copy(target, targetStart, sourceStart, sourceEnd) { targetStart = targetStart || 0; sourceStart = sourceStart || 0; sourceEnd = sourceEnd || this.length; for (let i = sourceStart; i < sourceEnd; i++) { target[targetStart++] = this[i]; } return sourceEnd - sourceStart; }
    writeUInt8(value, offset) { this[offset] = value & 0xff; return offset + 1; }
    writeUInt16LE(value, offset) { this[offset] = value & 0xff; this[offset + 1] = (value >> 8) & 0xff; return offset + 2; }
    writeUInt32LE(value, offset) { for (let i = 0; i < 4; i++) this[offset + i] = (value >> (i * 8)) & 0xff; return offset + 4; }
    writeUInt16BE(value, offset) { this[offset] = (value >> 8) & 0xff; this[offset + 1] = value & 0xff; return offset + 2; }
    writeUInt32BE(value, offset) { for (let i = 0; i < 4; i++) this[offset + 3 - i] = (value >> (i * 8)) & 0xff; return offset + 4; }
    readUInt8(offset) { return this[offset]; }
    readUInt16LE(offset) { return this[offset] | (this[offset + 1] << 8); }
    readUInt32LE(offset) { return this[offset] | (this[offset + 1] << 8) | (this[offset + 2] << 16) | (this[offset + 3] << 24) >>> 0; }
    readUInt16BE(offset) { return (this[offset] << 8) | this[offset + 1]; }
    readUInt32BE(offset) { return ((this[offset] << 24) | (this[offset + 1] << 16) | (this[offset + 2] << 8) | this[offset + 3]) >>> 0; }
  }
  if (typeof window !== 'undefined') window.Buffer = BufferPolyfill;
  if (typeof globalThis !== 'undefined') globalThis.Buffer = BufferPolyfill;
})();

console.log('✅ Polyfills loaded (Buffer + process)');
