#!/bin/bash
# 🔍 KRAY Extension Integrity Check
# Run this to verify your extension files are intact

echo "🔍 Checking KrayWallet Extension Integrity..."
echo ""

# Check popup.js line count (should be ~15783)
POPUP_LINES=$(wc -l < popup/popup.js 2>/dev/null | tr -d ' ')
EXPECTED_MIN=15000

if [ -z "$POPUP_LINES" ]; then
    echo "❌ ERROR: popup/popup.js not found!"
    exit 1
elif [ "$POPUP_LINES" -lt "$EXPECTED_MIN" ]; then
    echo "⚠️  WARNING: popup.js has only $POPUP_LINES lines (expected ~15783)"
    echo "   This may indicate data loss from iCloud sync issues!"
    echo ""
    echo "   To restore, run:"
    echo "   git checkout HEAD -- extension-prod/popup/popup.js"
    exit 1
else
    echo "✅ popup.js: $POPUP_LINES lines (OK)"
fi

# Check for critical functions
echo ""
echo "🔍 Checking critical features..."

# Check marketplace
if grep -q "marketplace\|Marketplace" popup/popup.js 2>/dev/null; then
    echo "✅ Marketplace: Present"
else
    echo "❌ Marketplace: MISSING"
fi

# Check L2 integration
if grep -q "KRAY L2\|kray-l2" popup/popup.js 2>/dev/null; then
    echo "✅ KRAY L2: Present"
else
    echo "❌ KRAY L2: MISSING"
fi

# Check security features
if grep -q "clearAllPasswordFields" popup/popup.js 2>/dev/null; then
    echo "✅ Security Features: Present"
else
    echo "❌ Security Features: MISSING"
fi

echo ""
echo "✅ Integrity check complete!"

