/*! For license information please see taproot-signer.bundle.js.LICENSE.txt */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.TaprootSigner=t():e.TaprootSigner=t()}(this,()=>(()=>{var e={7235:(e,t,r)=>{"use strict";var n=r(3497),o=r(6351),i=r(219);function a(e){var t=Object.create(null);return e&&Object.keys(e).forEach(function(r){if("default"!==r){var n=Object.getOwnPropertyDescriptor(e,r);Object.defineProperty(t,r,n.get?n:{enumerable:!0,get:function(){return e[r]}})}}),t.default=e,Object.freeze(t)}var s=a(o),c=a(i);const u=n.secp256k1.ProjectivePoint,l="Expected Private",f="Expected Point",h="Expected Tweak",d="Expected Signature",p="Expected Extra Data (32 bytes)",b="Expected Scalar",g=new Uint8Array([255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,186,174,220,230,175,72,160,59,191,210,94,140,208,54,65,65]),y=new Uint8Array(32),m=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,69,81,35,25,80,183,95,196,64,45,161,114,47,201,186,238]),v=BigInt(1);function w(e,t){for(let r=0;r<32;++r)if(e[r]!==t[r])return e[r]<t[r]?-1:1;return 0}function _(e){return 0===w(e,y)}function S(e){return e instanceof Uint8Array&&32===e.length&&!(w(e,g)>=0)}function E(e){return e instanceof Uint8Array&&64===e.length&&w(e.subarray(0,32),g)<0&&w(e.subarray(32,64),g)<0}function k(e){return e instanceof Uint8Array&&32===e.length}function A(e){return void 0===e||e instanceof Uint8Array&&32===e.length}function x(e){let t;if("bigint"==typeof e)t=e;else if("number"==typeof e&&Number.isSafeInteger(e)&&e>=0)t=BigInt(e);else if("string"==typeof e){if(64!==e.length)throw new Error("Expected 32 bytes of private scalar");t=c.hexToNumber(e)}else{if(!(e instanceof Uint8Array))throw new TypeError("Expected valid private scalar");if(32!==e.length)throw new Error("Expected 32 bytes of private scalar");t=c.bytesToNumberBE(e)}if(t<0)throw new Error("Expected private scalar >= 0");return t}function I(e){return n.secp256k1.utils.normPrivateKeyToScalar(e)}function B(e,t,r){const n=P(e),o=x(t),i=u.BASE.multiplyAndAddUnsafe(n,o,v);if(!i)throw new Error("Tweaked point at infinity");return i.toRawBytes(r)}function T(e,t){return void 0===e?void 0===t||j(t):!!e}function H(e){try{return e()}catch(e){return null}}function O(e){return n.schnorr.utils.lift_x(c.bytesToNumberBE(e))}function P(e){return 32===e.length?O(e):u.fromHex(e)}function L(e,t){if(32===e.length!==t)return!1;try{return t?!!O(e):!!u.fromHex(e)}catch(e){return!1}}function U(e){return L(e,!1)}function j(e){return L(e,!1)&&33===e.length}function C(e){return n.secp256k1.utils.isValidPrivateKey(e)}function R(e){return L(e,!0)}function z(e){if(!U(e))throw new Error(f);return e.slice(1,33)}function N(e,t){if(!C(e))throw new Error(l);return H(()=>n.secp256k1.getPublicKey(e,T(t)))}t.isPoint=U,t.isPointCompressed=j,t.isPrivate=C,t.isXOnlyPoint=R,t.pointAdd=function(e,t,r){if(!U(e)||!U(t))throw new Error(f);return H(()=>{const n=P(e),o=P(t);return n.equals(o.negate())?null:n.add(o).toRawBytes(T(r,e))})},t.pointAddScalar=function(e,t,r){if(!U(e))throw new Error(f);if(!S(t))throw new Error(h);return H(()=>B(e,t,T(r,e)))},t.pointCompress=function(e,t){if(!U(e))throw new Error(f);return P(e).toRawBytes(T(t,e))},t.pointFromScalar=N,t.pointMultiply=function(e,t,r){if(!U(e))throw new Error(f);if(!S(t))throw new Error(h);return H(()=>function(e,t,r){const n=P(e),o="string"==typeof t?t:c.bytesToHex(t),i=c.hexToNumber(o);return n.multiply(i).toRawBytes(r)}(e,t,T(r,e)))},t.privateAdd=function(e,t){if(!C(e))throw new Error(l);if(!S(t))throw new Error(h);return H(()=>function(e,t){const r=I(e),o=x(t),i=c.numberToBytesBE(s.mod(r+o,n.secp256k1.CURVE.n),32);return n.secp256k1.utils.isValidPrivateKey(i)?i:null}(e,t))},t.privateNegate=function(e){if(!C(e))throw new Error(l);return function(e){const t=I(e),r=c.numberToBytesBE(n.secp256k1.CURVE.n-t,32);return n.secp256k1.utils.isValidPrivateKey(r)?r:null}(e)},t.privateSub=function(e,t){if(!C(e))throw new Error(l);if(!S(t))throw new Error(h);return H(()=>function(e,t){const r=I(e),o=x(t),i=c.numberToBytesBE(s.mod(r-o,n.secp256k1.CURVE.n),32);return n.secp256k1.utils.isValidPrivateKey(i)?i:null}(e,t))},t.recover=function(e,t,r,o){if(!k(e))throw new Error("Expected Hash");if(!E(t)||!function(e){return!(_(e.subarray(0,32))||_(e.subarray(32,64)))}(t))throw new Error(d);if(2&r&&!function(e){return e instanceof Uint8Array&&64===e.length&&w(e.subarray(0,32),m)<0}(t))throw new Error("Bad Recovery Id");if(!R(t.subarray(0,32)))throw new Error(d);const i=n.secp256k1.Signature.fromCompact(t).addRecoveryBit(r).recoverPublicKey(e);if(!i)throw new Error(d);return i.toRawBytes(T(o))},t.sign=function(e,t,r){if(!C(t))throw new Error(l);if(!k(e))throw new Error(b);if(!A(r))throw new Error(p);return n.secp256k1.sign(e,t,{extraEntropy:r}).toCompactRawBytes()},t.signRecoverable=function(e,t,r){if(!C(t))throw new Error(l);if(!k(e))throw new Error(b);if(!A(r))throw new Error(p);const o=n.secp256k1.sign(e,t,{extraEntropy:r});return{signature:o.toCompactRawBytes(),recoveryId:o.recovery}},t.signSchnorr=function(e,t,r){if(!C(t))throw new Error(l);if(!k(e))throw new Error(b);if(!A(r))throw new Error(p);return n.schnorr.sign(e,t,r)},t.verify=function(e,t,r,o){if(!U(t))throw new Error(f);if(!E(r))throw new Error(d);if(!k(e))throw new Error(b);return n.secp256k1.verify(r,e,t,{lowS:o})},t.verifySchnorr=function(e,t,r){if(!R(t))throw new Error(f);if(!E(r))throw new Error(d);if(!k(e))throw new Error(b);return n.schnorr.verify(r,e,t)},t.xOnlyPointAddTweak=function(e,t){if(!R(e))throw new Error(f);if(!S(t))throw new Error(h);return H(()=>{const r=B(e,t,!0);return{parity:r[0]%2==1?1:0,xOnlyPubkey:r.slice(1)}})},t.xOnlyPointFromPoint=z,t.xOnlyPointFromScalar=function(e){if(!C(e))throw new Error(l);return z(N(e))}},9082:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getHash=function(e){return{hash:e}},t.createCurve=function(e,t){const r=t=>(0,n.weierstrass)({...e,hash:t});return{...r(t),create:r}};const n=r(6551)},1525:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.wNAF=void 0,t.negateCt=s,t.normalizeZ=function(e,t){const r=(0,o.FpInvertBatch)(e.Fp,t.map(e=>e.Z));return t.map((t,n)=>e.fromAffine(t.toAffine(r[n])))},t.mulEndoUnsafe=function(e,t,r,n){let o=t,s=e.ZERO,c=e.ZERO;for(;r>i||n>i;)r&a&&(s=s.add(o)),n&a&&(c=c.add(o)),o=o.double(),r>>=a,n>>=a;return{p1:s,p2:c}},t.pippenger=function(e,t,r,o){f(r,e),h(o,t);const i=r.length,a=o.length;if(i!==a)throw new Error("arrays of points and scalars must have equal length");const s=e.ZERO,c=(0,n.bitLen)(BigInt(i));let u=1;c>12?u=c-3:c>4?u=c-2:c>0&&(u=2);const l=(0,n.bitMask)(u),d=new Array(Number(l)+1).fill(s);let p=s;for(let e=Math.floor((t.BITS-1)/u)*u;e>=0;e-=u){d.fill(s);for(let t=0;t<a;t++){const n=o[t],i=Number(n>>BigInt(e)&l);d[i]=d[i].add(r[t])}let t=s;for(let e=d.length-1,r=s;e>0;e--)r=r.add(d[e]),t=t.add(r);if(p=p.add(t),0!==e)for(let e=0;e<u;e++)p=p.double()}return p},t.precomputeMSMUnsafe=function(e,t,r,o){c(o,t.BITS),f(r,e);const i=e.ZERO,a=2**o-1,s=Math.ceil(t.BITS/o),u=(0,n.bitMask)(o),l=r.map(e=>{const t=[];for(let r=0,n=e;r<a;r++)t.push(n),n=n.add(e);return t});return e=>{if(h(e,t),e.length>r.length)throw new Error("array of scalars must be smaller than array of points");let n=i;for(let t=0;t<s;t++){if(n!==i)for(let e=0;e<o;e++)n=n.double();const r=BigInt(s*o-(t+1)*o);for(let t=0;t<e.length;t++){const o=e[t],i=Number(o>>r&u);i&&(n=n.add(l[t][i-1]))}}return n}},t.validateBasic=function(e){return(0,o.validateField)(e.Fp),(0,n.validateObject)(e,{n:"bigint",h:"bigint",Gx:"field",Gy:"field"},{nBitLength:"isSafeInteger",nByteLength:"isSafeInteger"}),Object.freeze({...(0,o.nLength)(e.n,e.nBitLength),...e,p:e.Fp.ORDER})},t._createCurveFields=function(e,t,r={},n){if(void 0===n&&(n="edwards"===e),!t||"object"!=typeof t)throw new Error(`expected valid ${e} CURVE object`);for(const e of["p","n","h"]){const r=t[e];if(!("bigint"==typeof r&&r>i))throw new Error(`CURVE.${e} must be positive bigint`)}const o=y(t.p,r.Fp,n),a=y(t.n,r.Fn,n),s=["Gx","Gy","a","weierstrass"===e?"b":"d"];for(const e of s)if(!o.isValid(t[e]))throw new Error(`CURVE.${e} must be valid field element of CURVE.Fp`);return{CURVE:t=Object.freeze(Object.assign({},t)),Fp:o,Fn:a}};const n=r(3409),o=r(6351),i=BigInt(0),a=BigInt(1);function s(e,t){const r=t.negate();return e?r:t}function c(e,t){if(!Number.isSafeInteger(e)||e<=0||e>t)throw new Error("invalid window size, expected [1.."+t+"], got W="+e)}function u(e,t){c(e,t);const r=2**e;return{windows:Math.ceil(t/e)+1,windowSize:2**(e-1),mask:(0,n.bitMask)(e),maxNumber:r,shiftBy:BigInt(e)}}function l(e,t,r){const{windowSize:n,mask:o,maxNumber:i,shiftBy:s}=r;let c=Number(e&o),u=e>>s;c>n&&(c-=i,u+=a);const l=t*n;return{nextN:u,offset:l+Math.abs(c)-1,isZero:0===c,isNeg:c<0,isNegF:t%2!=0,offsetF:l}}function f(e,t){if(!Array.isArray(e))throw new Error("array expected");e.forEach((e,r)=>{if(!(e instanceof t))throw new Error("invalid point at index "+r)})}function h(e,t){if(!Array.isArray(e))throw new Error("array of scalars expected");e.forEach((e,r)=>{if(!t.isValid(e))throw new Error("invalid scalar at index "+r)})}const d=new WeakMap,p=new WeakMap;function b(e){return p.get(e)||1}function g(e){if(e!==i)throw new Error("invalid wNAF")}function y(e,t,r){if(t){if(t.ORDER!==e)throw new Error("Field.ORDER must match order: Fp == p, Fn == n");return(0,o.validateField)(t),t}return(0,o.Field)(e,{isLE:r})}t.wNAF=class{constructor(e,t){this.BASE=e.BASE,this.ZERO=e.ZERO,this.Fn=e.Fn,this.bits=t}_unsafeLadder(e,t,r=this.ZERO){let n=e;for(;t>i;)t&a&&(r=r.add(n)),n=n.double(),t>>=a;return r}precomputeWindow(e,t){const{windows:r,windowSize:n}=u(t,this.bits),o=[];let i=e,a=i;for(let e=0;e<r;e++){a=i,o.push(a);for(let e=1;e<n;e++)a=a.add(i),o.push(a);i=a.double()}return o}wNAF(e,t,r){if(!this.Fn.isValid(r))throw new Error("invalid scalar");let n=this.ZERO,o=this.BASE;const i=u(e,this.bits);for(let e=0;e<i.windows;e++){const{nextN:a,offset:c,isZero:u,isNeg:f,isNegF:h,offsetF:d}=l(r,e,i);r=a,u?o=o.add(s(h,t[d])):n=n.add(s(f,t[c]))}return g(r),{p:n,f:o}}wNAFUnsafe(e,t,r,n=this.ZERO){const o=u(e,this.bits);for(let e=0;e<o.windows&&r!==i;e++){const{nextN:i,offset:a,isZero:s,isNeg:c}=l(r,e,o);if(r=i,!s){const e=t[a];n=n.add(c?e.negate():e)}}return g(r),n}getPrecomputes(e,t,r){let n=d.get(t);return n||(n=this.precomputeWindow(t,e),1!==e&&("function"==typeof r&&(n=r(n)),d.set(t,n))),n}cached(e,t,r){const n=b(e);return this.wNAF(n,this.getPrecomputes(n,e,r),t)}unsafe(e,t,r,n){const o=b(e);return 1===o?this._unsafeLadder(e,t,n):this.wNAFUnsafe(o,this.getPrecomputes(o,e,r),t,n)}createCache(e,t){c(t,this.bits),p.set(e,t),d.delete(e)}hasCache(e){return 1!==b(e)}}},5134:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t._DST_scalar=void 0,t.expand_message_xmd=l,t.expand_message_xof=f,t.hash_to_field=h,t.isogenyMap=function(e,t){const r=t.map(e=>Array.from(e).reverse());return(t,n)=>{const[i,a,s,c]=r.map(r=>r.reduce((r,n)=>e.add(e.mul(r,t),n))),[u,l]=(0,o.FpInvertBatch)(e,[a,c],!0);return t=e.mul(i,u),n=e.mul(n,e.mul(s,l)),{x:t,y:n}}},t.createHasher=function(e,r,n){if("function"!=typeof r)throw new Error("mapToCurve() must be defined");function o(t){return e.fromAffine(r(t))}function i(t){const r=t.clearCofactor();return r.equals(e.ZERO)?e.ZERO:(r.assertValidity(),r)}return{defaults:n,hashToCurve(e,t){const r=h(e,2,Object.assign({},n,t)),a=o(r[0]),s=o(r[1]);return i(a.add(s))},encodeToCurve(e,t){const r=n.encodeDST?{DST:n.encodeDST}:{};return i(o(h(e,1,Object.assign({},n,r,t))[0]))},mapToCurve(e){if(!Array.isArray(e))throw new Error("expected array of bigints");for(const t of e)if("bigint"!=typeof t)throw new Error("expected array of bigints");return i(o(e))},hashToScalar(r,o){const i=e.Fn.ORDER;return h(r,1,Object.assign({},n,{p:i,m:1,DST:t._DST_scalar},o))[0][0]}}};const n=r(3409),o=r(6351),i=n.bytesToNumberBE;function a(e,t){if(c(e),c(t),e<0||e>=1<<8*t)throw new Error("invalid I2OSP input: "+e);const r=Array.from({length:t}).fill(0);for(let n=t-1;n>=0;n--)r[n]=255&e,e>>>=8;return new Uint8Array(r)}function s(e,t){const r=new Uint8Array(e.length);for(let n=0;n<e.length;n++)r[n]=e[n]^t[n];return r}function c(e){if(!Number.isSafeInteger(e))throw new Error("number expected")}function u(e){if(!(0,n.isBytes)(e)&&"string"!=typeof e)throw new Error("DST must be Uint8Array or string");return"string"==typeof e?(0,n.utf8ToBytes)(e):e}function l(e,t,r,o){(0,n.abytes)(e),c(r),(t=u(t)).length>255&&(t=o((0,n.concatBytes)((0,n.utf8ToBytes)("H2C-OVERSIZE-DST-"),t)));const{outputLen:i,blockLen:l}=o,f=Math.ceil(r/i);if(r>65535||f>255)throw new Error("expand_message_xmd: invalid lenInBytes");const h=(0,n.concatBytes)(t,a(t.length,1)),d=a(0,l),p=a(r,2),b=new Array(f),g=o((0,n.concatBytes)(d,e,p,a(0,1),h));b[0]=o((0,n.concatBytes)(g,a(1,1),h));for(let e=1;e<=f;e++){const t=[s(g,b[e-1]),a(e+1,1),h];b[e]=o((0,n.concatBytes)(...t))}return(0,n.concatBytes)(...b).slice(0,r)}function f(e,t,r,o,i){if((0,n.abytes)(e),c(r),(t=u(t)).length>255){const e=Math.ceil(2*o/8);t=i.create({dkLen:e}).update((0,n.utf8ToBytes)("H2C-OVERSIZE-DST-")).update(t).digest()}if(r>65535||t.length>255)throw new Error("expand_message_xof: invalid lenInBytes");return i.create({dkLen:r}).update(e).update(a(r,2)).update(t).update(a(t.length,1)).digest()}function h(e,t,r){(0,n._validateObject)(r,{p:"bigint",m:"number",k:"number",hash:"function"});const{p:a,k:s,m:u,hash:h,expand:d,DST:p}=r;if(!(0,n.isHash)(r.hash))throw new Error("expected valid hash");(0,n.abytes)(e),c(t);const b=a.toString(2).length,g=Math.ceil((b+s)/8),y=t*u*g;let m;if("xmd"===d)m=l(e,p,y,h);else if("xof"===d)m=f(e,p,y,s,h);else{if("_internal_pass"!==d)throw new Error('expand must be "xmd" or "xof"');m=e}const v=new Array(t);for(let e=0;e<t;e++){const t=new Array(u);for(let r=0;r<u;r++){const n=g*(r+e*u),s=m.subarray(n,n+g);t[r]=(0,o.mod)(i(s),a)}v[e]=t}return v}t._DST_scalar=(0,n.utf8ToBytes)("HashToScalar-")},6351:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.isNegativeLE=void 0,t.mod=p,t.pow=function(e,t,r){return S(x(r),e,t)},t.pow2=function(e,t,r){let n=e;for(;t-- >o;)n*=n,n%=r;return n},t.invert=b,t.tonelliShanks=v,t.FpSqrt=w,t.validateField=function(e){const t=_.reduce((e,t)=>(e[t]="function",e),{ORDER:"bigint",MASK:"bigint",BYTES:"number",BITS:"number"});return(0,n._validateObject)(e,t),e},t.FpPow=S,t.FpInvertBatch=E,t.FpDiv=function(e,t,r){return e.mul(t,"bigint"==typeof r?b(r,e.ORDER):e.inv(r))},t.FpLegendre=k,t.FpIsSquare=function(e,t){return 1===k(e,t)},t.nLength=A,t.Field=x,t.FpSqrtOdd=function(e,t){if(!e.isOdd)throw new Error("Field doesn't have isOdd");const r=e.sqrt(t);return e.isOdd(r)?r:e.neg(r)},t.FpSqrtEven=function(e,t){if(!e.isOdd)throw new Error("Field doesn't have isOdd");const r=e.sqrt(t);return e.isOdd(r)?e.neg(r):r},t.hashToPrivateScalar=function(e,t,r=!1){const o=(e=(0,n.ensureBytes)("privateHash",e)).length,a=A(t).nByteLength+8;if(a<24||o<a||o>1024)throw new Error("hashToPrivateScalar: expected "+a+"-1024 bytes of input, got "+o);return p(r?(0,n.bytesToNumberLE)(e):(0,n.bytesToNumberBE)(e),t-i)+i},t.getFieldBytesLength=I,t.getMinHashLength=B,t.mapHashToField=function(e,t,r=!1){const o=e.length,a=I(t),s=B(t);if(o<16||o<s||o>1024)throw new Error("expected "+s+"-1024 bytes of input, got "+o);const c=p(r?(0,n.bytesToNumberLE)(e):(0,n.bytesToNumberBE)(e),t-i)+i;return r?(0,n.numberToBytesLE)(c,a):(0,n.numberToBytesBE)(c,a)};const n=r(3409),o=BigInt(0),i=BigInt(1),a=BigInt(2),s=BigInt(3),c=BigInt(4),u=BigInt(5),l=BigInt(7),f=BigInt(8),h=BigInt(9),d=BigInt(16);function p(e,t){const r=e%t;return r>=o?r:t+r}function b(e,t){if(e===o)throw new Error("invert: expected non-zero number");if(t<=o)throw new Error("invert: expected positive modulus, got "+t);let r=p(e,t),n=t,a=o,s=i,c=i,u=o;for(;r!==o;){const e=n/r,t=n%r,o=a-c*e,i=s-u*e;n=r,r=t,a=c,s=u,c=o,u=i}if(n!==i)throw new Error("invert: does not exist");return p(a,t)}function g(e,t,r){if(!e.eql(e.sqr(t),r))throw new Error("Cannot find square root")}function y(e,t){const r=(e.ORDER+i)/c,n=e.pow(t,r);return g(e,n,t),n}function m(e,t){const r=(e.ORDER-u)/f,n=e.mul(t,a),o=e.pow(n,r),i=e.mul(t,o),s=e.mul(e.mul(i,a),o),c=e.mul(i,e.sub(s,e.ONE));return g(e,c,t),c}function v(e){if(e<s)throw new Error("sqrt is not defined for small field");let t=e-i,r=0;for(;t%a===o;)t/=a,r++;let n=a;const c=x(e);for(;1===k(c,n);)if(n++>1e3)throw new Error("Cannot find square root: probably non-prime P");if(1===r)return y;let u=c.pow(n,t);const l=(t+i)/a;return function(e,n){if(e.is0(n))return n;if(1!==k(e,n))throw new Error("Cannot find square root");let o=r,a=e.mul(e.ONE,u),s=e.pow(n,t),c=e.pow(n,l);for(;!e.eql(s,e.ONE);){if(e.is0(s))return e.ZERO;let t=1,r=e.sqr(s);for(;!e.eql(r,e.ONE);)if(t++,r=e.sqr(r),t===o)throw new Error("Cannot find square root");const n=i<<BigInt(o-t-1),u=e.pow(a,n);o=t,a=e.sqr(u),s=e.mul(s,a),c=e.mul(c,u)}return c}}function w(e){return e%c===s?y:e%f===u?m:e%d===h?function(e){const t=x(e),r=v(e),n=r(t,t.neg(t.ONE)),o=r(t,n),i=r(t,t.neg(n)),a=(e+l)/d;return(e,t)=>{let r=e.pow(t,a),s=e.mul(r,n);const c=e.mul(r,o),u=e.mul(r,i),l=e.eql(e.sqr(s),t),f=e.eql(e.sqr(c),t);r=e.cmov(r,s,l),s=e.cmov(u,c,f);const h=e.eql(e.sqr(s),t),d=e.cmov(r,s,h);return g(e,d,t),d}}(e):v(e)}t.isNegativeLE=(e,t)=>(p(e,t)&i)===i;const _=["create","isValid","is0","neg","inv","sqrt","sqr","eql","add","sub","mul","pow","div","addN","subN","mulN","sqrN"];function S(e,t,r){if(r<o)throw new Error("invalid exponent, negatives unsupported");if(r===o)return e.ONE;if(r===i)return t;let n=e.ONE,a=t;for(;r>o;)r&i&&(n=e.mul(n,a)),a=e.sqr(a),r>>=i;return n}function E(e,t,r=!1){const n=new Array(t.length).fill(r?e.ZERO:void 0),o=t.reduce((t,r,o)=>e.is0(r)?t:(n[o]=t,e.mul(t,r)),e.ONE),i=e.inv(o);return t.reduceRight((t,r,o)=>e.is0(r)?t:(n[o]=e.mul(t,n[o]),e.mul(t,r)),i),n}function k(e,t){const r=(e.ORDER-i)/a,n=e.pow(t,r),o=e.eql(n,e.ONE),s=e.eql(n,e.ZERO),c=e.eql(n,e.neg(e.ONE));if(!o&&!s&&!c)throw new Error("invalid Legendre symbol result");return o?1:s?0:-1}function A(e,t){void 0!==t&&(0,n.anumber)(t);const r=void 0!==t?t:e.toString(2).length;return{nBitLength:r,nByteLength:Math.ceil(r/8)}}function x(e,t,r=!1,a={}){if(e<=o)throw new Error("invalid field: expected ORDER > 0, got "+e);let s,c,u,l=!1;if("object"==typeof t&&null!=t){if(a.sqrt||r)throw new Error("cannot specify opts in two arguments");const e=t;e.BITS&&(s=e.BITS),e.sqrt&&(c=e.sqrt),"boolean"==typeof e.isLE&&(r=e.isLE),"boolean"==typeof e.modFromBytes&&(l=e.modFromBytes),u=e.allowedLengths}else"number"==typeof t&&(s=t),a.sqrt&&(c=a.sqrt);const{nBitLength:f,nByteLength:h}=A(e,s);if(h>2048)throw new Error("invalid field: expected ORDER of <= 2048 bytes");let d;const g=Object.freeze({ORDER:e,isLE:r,BITS:f,BYTES:h,MASK:(0,n.bitMask)(f),ZERO:o,ONE:i,allowedLengths:u,create:t=>p(t,e),isValid:t=>{if("bigint"!=typeof t)throw new Error("invalid field element: expected bigint, got "+typeof t);return o<=t&&t<e},is0:e=>e===o,isValidNot0:e=>!g.is0(e)&&g.isValid(e),isOdd:e=>(e&i)===i,neg:t=>p(-t,e),eql:(e,t)=>e===t,sqr:t=>p(t*t,e),add:(t,r)=>p(t+r,e),sub:(t,r)=>p(t-r,e),mul:(t,r)=>p(t*r,e),pow:(e,t)=>S(g,e,t),div:(t,r)=>p(t*b(r,e),e),sqrN:e=>e*e,addN:(e,t)=>e+t,subN:(e,t)=>e-t,mulN:(e,t)=>e*t,inv:t=>b(t,e),sqrt:c||(t=>(d||(d=w(e)),d(g,t))),toBytes:e=>r?(0,n.numberToBytesLE)(e,h):(0,n.numberToBytesBE)(e,h),fromBytes:(t,o=!0)=>{if(u){if(!u.includes(t.length)||t.length>h)throw new Error("Field.fromBytes: expected "+u+" bytes, got "+t.length);const e=new Uint8Array(h);e.set(t,r?0:e.length-t.length),t=e}if(t.length!==h)throw new Error("Field.fromBytes: expected "+h+" bytes, got "+t.length);let i=r?(0,n.bytesToNumberLE)(t):(0,n.bytesToNumberBE)(t);if(l&&(i=p(i,e)),!o&&!g.isValid(i))throw new Error("invalid field element: outside of range 0..ORDER");return i},invertBatch:e=>E(g,e),cmov:(e,t,r)=>r?t:e});return Object.freeze(g)}function I(e){if("bigint"!=typeof e)throw new Error("field order must be bigint");const t=e.toString(2).length;return Math.ceil(t/8)}function B(e){const t=I(e);return t+Math.ceil(t/2)}},219:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.isHash=t.validateObject=t.memoized=t.notImplemented=t.createHmacDrbg=t.bitMask=t.bitSet=t.bitGet=t.bitLen=t.aInRange=t.inRange=t.asciiToBytes=t.copyBytes=t.equalBytes=t.ensureBytes=t.numberToVarBytesBE=t.numberToBytesLE=t.numberToBytesBE=t.bytesToNumberLE=t.bytesToNumberBE=t.hexToNumber=t.numberToHexUnpadded=t.abool=t.utf8ToBytes=t.randomBytes=t.isBytes=t.hexToBytes=t.concatBytes=t.bytesToUtf8=t.bytesToHex=t.anumber=t.abytes=void 0;const n=r(3409);t.abytes=n.abytes,t.anumber=n.anumber,t.bytesToHex=n.bytesToHex,t.bytesToUtf8=n.bytesToUtf8,t.concatBytes=n.concatBytes,t.hexToBytes=n.hexToBytes,t.isBytes=n.isBytes,t.randomBytes=n.randomBytes,t.utf8ToBytes=n.utf8ToBytes,t.abool=n.abool,t.numberToHexUnpadded=n.numberToHexUnpadded,t.hexToNumber=n.hexToNumber,t.bytesToNumberBE=n.bytesToNumberBE,t.bytesToNumberLE=n.bytesToNumberLE,t.numberToBytesBE=n.numberToBytesBE,t.numberToBytesLE=n.numberToBytesLE,t.numberToVarBytesBE=n.numberToVarBytesBE,t.ensureBytes=n.ensureBytes,t.equalBytes=n.equalBytes,t.copyBytes=n.copyBytes,t.asciiToBytes=n.asciiToBytes,t.inRange=n.inRange,t.aInRange=n.aInRange,t.bitLen=n.bitLen,t.bitGet=n.bitGet,t.bitSet=n.bitSet,t.bitMask=n.bitMask,t.createHmacDrbg=n.createHmacDrbg,t.notImplemented=n.notImplemented,t.memoized=n.memoized,t.validateObject=n.validateObject,t.isHash=n.isHash},6551:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.DER=t.DERErr=void 0,t._splitEndoScalar=u,t._normFnElement=m,t.weierstrassN=v,t.SWUFpSqrtRatio=_,t.mapToCurveSimpleSWU=function(e,t){(0,s.validateField)(e);const{A:r,B:n,Z:o}=t;if(!e.isValid(r)||!e.isValid(n)||!e.isValid(o))throw new Error("mapToCurveSimpleSWU: invalid opts");const i=_(e,o);if(!e.isOdd)throw new Error("Field does not have .isOdd()");return t=>{let a,c,u,l,f,h,d,p;a=e.sqr(t),a=e.mul(a,o),c=e.sqr(a),c=e.add(c,a),u=e.add(c,e.ONE),u=e.mul(u,n),l=e.cmov(o,e.neg(c),!e.eql(c,e.ZERO)),l=e.mul(l,r),c=e.sqr(u),h=e.sqr(l),f=e.mul(h,r),c=e.add(c,f),c=e.mul(c,u),h=e.mul(h,l),f=e.mul(h,n),c=e.add(c,f),d=e.mul(a,u);const{isValid:b,value:g}=i(c,h);p=e.mul(a,t),p=e.mul(p,g),d=e.cmov(d,u,b),p=e.cmov(p,g,b);const y=e.isOdd(t)===e.isOdd(p);p=e.cmov(e.neg(p),p,y);const m=(0,s.FpInvertBatch)(e,[l],!0)[0];return d=e.mul(d,m),{x:d,y:p}}},t.ecdh=E,t.ecdsa=k,t.weierstrassPoints=function(e){const{CURVE:t,curveOpts:r}=A(e);return function(e,t){const{Fp:r,Fn:n}=t;const o=x(r,e.a,e.b);return Object.assign({},{CURVE:e,Point:t,ProjectivePoint:t,normPrivateKeyToScalar:e=>m(n,e),weierstrassEquation:o,isWithinCurveOrder:function(e){return(0,i.inRange)(e,p,n.ORDER)}})}(e,v(t,r))},t._legacyHelperEquat=x,t.weierstrass=function(e){const{CURVE:t,curveOpts:r,hash:n,ecdsaOpts:o}=function(e){const{CURVE:t,curveOpts:r}=A(e),n={hmac:e.hmac,randomBytes:e.randomBytes,lowS:e.lowS,bits2int:e.bits2int,bits2int_modN:e.bits2int_modN};return{CURVE:t,curveOpts:r,hash:e.hash,ecdsaOpts:n}}(e);return function(e,t){const r=t.Point;return Object.assign({},t,{ProjectivePoint:r,CURVE:Object.assign({},e,(0,s.nLength)(r.Fn.ORDER,r.Fn.BITS))})}(e,k(v(t,r),n,o))};const n=r(1128),o=r(1717),i=r(3409),a=r(1525),s=r(6351),c=(e,t)=>(e+(e>=0?t:-t)/b)/t;function u(e,t,r){const[[n,o],[a,s]]=t,u=c(s*e,r),l=c(-o*e,r);let f=e-u*n-l*a,h=-u*o-l*s;const b=f<d,g=h<d;b&&(f=-f),g&&(h=-h);const y=(0,i.bitMask)(Math.ceil((0,i.bitLen)(r)/2))+p;if(f<d||f>=y||h<d||h>=y)throw new Error("splitScalar (endomorphism): failed, k="+e);return{k1neg:b,k1:f,k2neg:g,k2:h}}function l(e){if(!["compact","recovered","der"].includes(e))throw new Error('Signature format must be "compact", "recovered", or "der"');return e}function f(e,t){const r={};for(let n of Object.keys(t))r[n]=void 0===e[n]?t[n]:e[n];return(0,i._abool2)(r.lowS,"lowS"),(0,i._abool2)(r.prehash,"prehash"),void 0!==r.format&&l(r.format),r}class h extends Error{constructor(e=""){super(e)}}t.DERErr=h,t.DER={Err:h,_tlv:{encode:(e,r)=>{const{Err:n}=t.DER;if(e<0||e>256)throw new n("tlv.encode: wrong tag");if(1&r.length)throw new n("tlv.encode: unpadded data");const o=r.length/2,a=(0,i.numberToHexUnpadded)(o);if(a.length/2&128)throw new n("tlv.encode: long form length too big");const s=o>127?(0,i.numberToHexUnpadded)(a.length/2|128):"";return(0,i.numberToHexUnpadded)(e)+s+a+r},decode(e,r){const{Err:n}=t.DER;let o=0;if(e<0||e>256)throw new n("tlv.encode: wrong tag");if(r.length<2||r[o++]!==e)throw new n("tlv.decode: wrong tlv");const i=r[o++];let a=0;if(128&i){const e=127&i;if(!e)throw new n("tlv.decode(long): indefinite length not supported");if(e>4)throw new n("tlv.decode(long): byte length is too big");const t=r.subarray(o,o+e);if(t.length!==e)throw new n("tlv.decode: length bytes not complete");if(0===t[0])throw new n("tlv.decode(long): zero leftmost byte");for(const e of t)a=a<<8|e;if(o+=e,a<128)throw new n("tlv.decode(long): not minimal encoding")}else a=i;const s=r.subarray(o,o+a);if(s.length!==a)throw new n("tlv.decode: wrong value length");return{v:s,l:r.subarray(o+a)}}},_int:{encode(e){const{Err:r}=t.DER;if(e<d)throw new r("integer: negative integers are not allowed");let n=(0,i.numberToHexUnpadded)(e);if(8&Number.parseInt(n[0],16)&&(n="00"+n),1&n.length)throw new r("unexpected DER parsing assertion: unpadded hex");return n},decode(e){const{Err:r}=t.DER;if(128&e[0])throw new r("invalid signature integer: negative");if(0===e[0]&&!(128&e[1]))throw new r("invalid signature integer: unnecessary leading zero");return(0,i.bytesToNumberBE)(e)}},toSig(e){const{Err:r,_int:n,_tlv:o}=t.DER,a=(0,i.ensureBytes)("signature",e),{v:s,l:c}=o.decode(48,a);if(c.length)throw new r("invalid signature: left bytes after parsing");const{v:u,l}=o.decode(2,s),{v:f,l:h}=o.decode(2,l);if(h.length)throw new r("invalid signature: left bytes after parsing");return{r:n.decode(u),s:n.decode(f)}},hexFromSig(e){const{_tlv:r,_int:n}=t.DER,o=r.encode(2,n.encode(e.r))+r.encode(2,n.encode(e.s));return r.encode(48,o)}};const d=BigInt(0),p=BigInt(1),b=BigInt(2),g=BigInt(3),y=BigInt(4);function m(e,t){const{BYTES:r}=e;let n;if("bigint"==typeof t)n=t;else{let o=(0,i.ensureBytes)("private key",t);try{n=e.fromBytes(o)}catch(e){throw new Error(`invalid private key: expected ui8a of size ${r}, got ${typeof t}`)}}if(!e.isValidNot0(n))throw new Error("invalid private key: out of range [1..N-1]");return n}function v(e,t={}){const r=(0,a._createCurveFields)("weierstrass",e,t),{Fp:n,Fn:o}=r;let s=r.CURVE;const{h:c,n:l}=s;(0,i._validateObject)(t,{},{allowInfinityPoint:"boolean",clearCofactor:"function",isTorsionFree:"function",fromBytes:"function",toBytes:"function",endo:"object",wrapPrivateKey:"boolean"});const{endo:f}=t;if(f&&(!n.is0(s.a)||"bigint"!=typeof f.beta||!Array.isArray(f.basises)))throw new Error('invalid endo: expected "beta": bigint and "basises": array');const h=S(n,o);function b(){if(!n.isOdd)throw new Error("compression is not supported: Field does not have .isOdd()")}const v=t.toBytes||function(e,t,r){const{x:o,y:a}=t.toAffine(),s=n.toBytes(o);if((0,i._abool2)(r,"isCompressed"),r){b();const e=!n.isOdd(a);return(0,i.concatBytes)(w(e),s)}return(0,i.concatBytes)(Uint8Array.of(4),s,n.toBytes(a))},_=t.fromBytes||function(e){(0,i._abytes2)(e,void 0,"Point");const{publicKey:t,publicKeyUncompressed:r}=h,o=e.length,a=e[0],s=e.subarray(1);if(o!==t||2!==a&&3!==a){if(o===r&&4===a){const e=n.BYTES,t=n.fromBytes(s.subarray(0,e)),r=n.fromBytes(s.subarray(e,2*e));if(!k(t,r))throw new Error("bad point: is not on curve");return{x:t,y:r}}throw new Error(`bad point: got length ${o}, expected compressed=${t} or uncompressed=${r}`)}{const e=n.fromBytes(s);if(!n.isValid(e))throw new Error("bad point: is not on curve, wrong x");const t=E(e);let r;try{r=n.sqrt(t)}catch(e){const t=e instanceof Error?": "+e.message:"";throw new Error("bad point: is not on curve, sqrt error"+t)}return b(),!(1&~a)!==n.isOdd(r)&&(r=n.neg(r)),{x:e,y:r}}};function E(e){const t=n.sqr(e),r=n.mul(t,e);return n.add(n.add(r,n.mul(e,s.a)),s.b)}function k(e,t){const r=n.sqr(t),o=E(e);return n.eql(r,o)}if(!k(s.Gx,s.Gy))throw new Error("bad curve params: generator point");const A=n.mul(n.pow(s.a,g),y),x=n.mul(n.sqr(s.b),BigInt(27));if(n.is0(n.add(A,x)))throw new Error("bad curve params: a or b");function I(e,t,r=!1){if(!n.isValid(t)||r&&n.is0(t))throw new Error(`bad point coordinate ${e}`);return t}function B(e){if(!(e instanceof L))throw new Error("ProjectivePoint expected")}function T(e){if(!f||!f.basises)throw new Error("no endo");return u(e,f.basises,o.ORDER)}const H=(0,i.memoized)((e,t)=>{const{X:r,Y:o,Z:i}=e;if(n.eql(i,n.ONE))return{x:r,y:o};const a=e.is0();null==t&&(t=a?n.ONE:n.inv(i));const s=n.mul(r,t),c=n.mul(o,t),u=n.mul(i,t);if(a)return{x:n.ZERO,y:n.ZERO};if(!n.eql(u,n.ONE))throw new Error("invZ was invalid");return{x:s,y:c}}),O=(0,i.memoized)(e=>{if(e.is0()){if(t.allowInfinityPoint&&!n.is0(e.Y))return;throw new Error("bad point: ZERO")}const{x:r,y:o}=e.toAffine();if(!n.isValid(r)||!n.isValid(o))throw new Error("bad point: x or y not field elements");if(!k(r,o))throw new Error("bad point: equation left != right");if(!e.isTorsionFree())throw new Error("bad point: not in prime-order subgroup");return!0});function P(e,t,r,o,i){return r=new L(n.mul(r.X,e),r.Y,r.Z),t=(0,a.negateCt)(o,t),r=(0,a.negateCt)(i,r),t.add(r)}class L{constructor(e,t,r){this.X=I("x",e),this.Y=I("y",t,!0),this.Z=I("z",r),Object.freeze(this)}static CURVE(){return s}static fromAffine(e){const{x:t,y:r}=e||{};if(!e||!n.isValid(t)||!n.isValid(r))throw new Error("invalid affine point");if(e instanceof L)throw new Error("projective point not allowed");return n.is0(t)&&n.is0(r)?L.ZERO:new L(t,r,n.ONE)}static fromBytes(e){const t=L.fromAffine(_((0,i._abytes2)(e,void 0,"point")));return t.assertValidity(),t}static fromHex(e){return L.fromBytes((0,i.ensureBytes)("pointHex",e))}get x(){return this.toAffine().x}get y(){return this.toAffine().y}precompute(e=8,t=!0){return j.createCache(this,e),t||this.multiply(g),this}assertValidity(){O(this)}hasEvenY(){const{y:e}=this.toAffine();if(!n.isOdd)throw new Error("Field doesn't support isOdd");return!n.isOdd(e)}equals(e){B(e);const{X:t,Y:r,Z:o}=this,{X:i,Y:a,Z:s}=e,c=n.eql(n.mul(t,s),n.mul(i,o)),u=n.eql(n.mul(r,s),n.mul(a,o));return c&&u}negate(){return new L(this.X,n.neg(this.Y),this.Z)}double(){const{a:e,b:t}=s,r=n.mul(t,g),{X:o,Y:i,Z:a}=this;let c=n.ZERO,u=n.ZERO,l=n.ZERO,f=n.mul(o,o),h=n.mul(i,i),d=n.mul(a,a),p=n.mul(o,i);return p=n.add(p,p),l=n.mul(o,a),l=n.add(l,l),c=n.mul(e,l),u=n.mul(r,d),u=n.add(c,u),c=n.sub(h,u),u=n.add(h,u),u=n.mul(c,u),c=n.mul(p,c),l=n.mul(r,l),d=n.mul(e,d),p=n.sub(f,d),p=n.mul(e,p),p=n.add(p,l),l=n.add(f,f),f=n.add(l,f),f=n.add(f,d),f=n.mul(f,p),u=n.add(u,f),d=n.mul(i,a),d=n.add(d,d),f=n.mul(d,p),c=n.sub(c,f),l=n.mul(d,h),l=n.add(l,l),l=n.add(l,l),new L(c,u,l)}add(e){B(e);const{X:t,Y:r,Z:o}=this,{X:i,Y:a,Z:c}=e;let u=n.ZERO,l=n.ZERO,f=n.ZERO;const h=s.a,d=n.mul(s.b,g);let p=n.mul(t,i),b=n.mul(r,a),y=n.mul(o,c),m=n.add(t,r),v=n.add(i,a);m=n.mul(m,v),v=n.add(p,b),m=n.sub(m,v),v=n.add(t,o);let w=n.add(i,c);return v=n.mul(v,w),w=n.add(p,y),v=n.sub(v,w),w=n.add(r,o),u=n.add(a,c),w=n.mul(w,u),u=n.add(b,y),w=n.sub(w,u),f=n.mul(h,v),u=n.mul(d,y),f=n.add(u,f),u=n.sub(b,f),f=n.add(b,f),l=n.mul(u,f),b=n.add(p,p),b=n.add(b,p),y=n.mul(h,y),v=n.mul(d,v),b=n.add(b,y),y=n.sub(p,y),y=n.mul(h,y),v=n.add(v,y),p=n.mul(b,v),l=n.add(l,p),p=n.mul(w,v),u=n.mul(m,u),u=n.sub(u,p),p=n.mul(m,b),f=n.mul(w,f),f=n.add(f,p),new L(u,l,f)}subtract(e){return this.add(e.negate())}is0(){return this.equals(L.ZERO)}multiply(e){const{endo:r}=t;if(!o.isValidNot0(e))throw new Error("invalid scalar: out of range");let n,i;const s=e=>j.cached(this,e,e=>(0,a.normalizeZ)(L,e));if(r){const{k1neg:t,k1:o,k2neg:a,k2:c}=T(e),{p:u,f:l}=s(o),{p:f,f:h}=s(c);i=l.add(h),n=P(r.beta,u,f,t,a)}else{const{p:t,f:r}=s(e);n=t,i=r}return(0,a.normalizeZ)(L,[n,i])[0]}multiplyUnsafe(e){const{endo:r}=t,n=this;if(!o.isValid(e))throw new Error("invalid scalar: out of range");if(e===d||n.is0())return L.ZERO;if(e===p)return n;if(j.hasCache(this))return this.multiply(e);if(r){const{k1neg:t,k1:o,k2neg:i,k2:s}=T(e),{p1:c,p2:u}=(0,a.mulEndoUnsafe)(L,n,o,s);return P(r.beta,c,u,t,i)}return j.unsafe(n,e)}multiplyAndAddUnsafe(e,t,r){const n=this.multiplyUnsafe(t).add(e.multiplyUnsafe(r));return n.is0()?void 0:n}toAffine(e){return H(this,e)}isTorsionFree(){const{isTorsionFree:e}=t;return c===p||(e?e(L,this):j.unsafe(this,l).is0())}clearCofactor(){const{clearCofactor:e}=t;return c===p?this:e?e(L,this):this.multiplyUnsafe(c)}isSmallOrder(){return this.multiplyUnsafe(c).is0()}toBytes(e=!0){return(0,i._abool2)(e,"isCompressed"),this.assertValidity(),v(L,this,e)}toHex(e=!0){return(0,i.bytesToHex)(this.toBytes(e))}toString(){return`<Point ${this.is0()?"ZERO":this.toHex()}>`}get px(){return this.X}get py(){return this.X}get pz(){return this.Z}toRawBytes(e=!0){return this.toBytes(e)}_setWindowSize(e){this.precompute(e)}static normalizeZ(e){return(0,a.normalizeZ)(L,e)}static msm(e,t){return(0,a.pippenger)(L,o,e,t)}static fromPrivateKey(e){return L.BASE.multiply(m(o,e))}}L.BASE=new L(s.Gx,s.Gy,n.ONE),L.ZERO=new L(n.ZERO,n.ONE,n.ZERO),L.Fp=n,L.Fn=o;const U=o.BITS,j=new a.wNAF(L,t.endo?Math.ceil(U/2):U);return L.BASE.precompute(8),L}function w(e){return Uint8Array.of(e?2:3)}function _(e,t){const r=e.ORDER;let n=d;for(let e=r-p;e%b===d;e/=b)n+=p;const o=n,i=b<<o-p-p,a=i*b,s=(r-p)/a,c=(s-p)/b,u=a-p,l=i,f=e.pow(t,s),h=e.pow(t,(s+p)/b);let m=(t,r)=>{let n=f,i=e.pow(r,u),a=e.sqr(i);a=e.mul(a,r);let s=e.mul(t,a);s=e.pow(s,c),s=e.mul(s,i),i=e.mul(s,r),a=e.mul(s,t);let d=e.mul(a,i);s=e.pow(d,l);let g=e.eql(s,e.ONE);i=e.mul(a,h),s=e.mul(d,n),a=e.cmov(i,a,g),d=e.cmov(s,d,g);for(let t=o;t>p;t--){let r=t-b;r=b<<r-p;let o=e.pow(d,r);const s=e.eql(o,e.ONE);i=e.mul(a,n),n=e.mul(n,n),o=e.mul(d,n),a=e.cmov(i,a,s),d=e.cmov(o,d,s)}return{isValid:g,value:a}};if(e.ORDER%y===g){const r=(e.ORDER-g)/y,n=e.sqrt(e.neg(t));m=(t,o)=>{let i=e.sqr(o);const a=e.mul(t,o);i=e.mul(i,a);let s=e.pow(i,r);s=e.mul(s,a);const c=e.mul(s,n),u=e.mul(e.sqr(s),o),l=e.eql(u,t);return{isValid:l,value:e.cmov(c,s,l)}}}return m}function S(e,t){return{secretKey:t.BYTES,publicKey:1+e.BYTES,publicKeyUncompressed:1+2*e.BYTES,publicKeyHasPrefix:!0,signature:2*t.BYTES}}function E(e,t={}){const{Fn:r}=e,n=t.randomBytes||i.randomBytes,o=Object.assign(S(e.Fp,r),{seed:(0,s.getMinHashLength)(r.ORDER)});function a(e){try{return!!m(r,e)}catch(e){return!1}}function c(e=n(o.seed)){return(0,s.mapHashToField)((0,i._abytes2)(e,o.seed,"seed"),r.ORDER)}function u(t,n=!0){return e.BASE.multiply(m(r,t)).toBytes(n)}function l(t){if("bigint"==typeof t)return!1;if(t instanceof e)return!0;const{secretKey:n,publicKey:a,publicKeyUncompressed:s}=o;if(r.allowedLengths||n===a)return;const c=(0,i.ensureBytes)("key",t).length;return c===a||c===s}const f={isValidSecretKey:a,isValidPublicKey:function(t,r){const{publicKey:n,publicKeyUncompressed:i}=o;try{const o=t.length;return!(!0===r&&o!==n||!1===r&&o!==i||!e.fromBytes(t))}catch(e){return!1}},randomSecretKey:c,isValidPrivateKey:a,randomPrivateKey:c,normPrivateKeyToScalar:e=>m(r,e),precompute:(t=8,r=e.BASE)=>r.precompute(t,!1)};return Object.freeze({getPublicKey:u,getSharedSecret:function(t,n,o=!0){if(!0===l(t))throw new Error("first arg must be private key");if(!1===l(n))throw new Error("second arg must be public key");const i=m(r,t);return e.fromHex(n).multiply(i).toBytes(o)},keygen:function(e){const t=c(e);return{secretKey:t,publicKey:u(t)}},Point:e,utils:f,lengths:o})}function k(e,r,a={}){(0,o.ahash)(r),(0,i._validateObject)(a,{},{hmac:"function",lowS:"boolean",randomBytes:"function",bits2int:"function",bits2int_modN:"function"});const s=a.randomBytes||i.randomBytes,c=a.hmac||((e,...t)=>(0,n.hmac)(r,e,(0,i.concatBytes)(...t))),{Fp:u,Fn:h}=e,{ORDER:g,BITS:y}=h,{keygen:v,getPublicKey:_,getSharedSecret:S,utils:k,lengths:A}=E(e,a),x={prehash:!1,lowS:"boolean"==typeof a.lowS&&a.lowS,format:void 0,extraEntropy:!1},I="compact";function B(e){return e>g>>p}function T(e,t){if(!h.isValidNot0(t))throw new Error(`invalid signature ${e}: out of range 1..Point.Fn.ORDER`);return t}class H{constructor(e,t,r){this.r=T("r",e),this.s=T("s",t),null!=r&&(this.recovery=r),Object.freeze(this)}static fromBytes(e,r=I){let n;if(function(e,t){l(t);const r=A.signature,n="compact"===t?r:"recovered"===t?r+1:void 0;(0,i._abytes2)(e,n,`${t} signature`)}(e,r),"der"===r){const{r,s:n}=t.DER.toSig((0,i._abytes2)(e));return new H(r,n)}"recovered"===r&&(n=e[0],r="compact",e=e.subarray(1));const o=h.BYTES,a=e.subarray(0,o),s=e.subarray(o,2*o);return new H(h.fromBytes(a),h.fromBytes(s),n)}static fromHex(e,t){return this.fromBytes((0,i.hexToBytes)(e),t)}addRecoveryBit(e){return new H(this.r,this.s,e)}recoverPublicKey(t){const r=u.ORDER,{r:n,s:o,recovery:a}=this;if(null==a||![0,1,2,3].includes(a))throw new Error("recovery id invalid");if(g*b<r&&a>1)throw new Error("recovery id is ambiguous for h>1 curve");const s=2===a||3===a?n+g:n;if(!u.isValid(s))throw new Error("recovery id 2 or 3 invalid");const c=u.toBytes(s),l=e.fromBytes((0,i.concatBytes)(w(!(1&a)),c)),f=h.inv(s),d=P((0,i.ensureBytes)("msgHash",t)),p=h.create(-d*f),y=h.create(o*f),m=e.BASE.multiplyUnsafe(p).add(l.multiplyUnsafe(y));if(m.is0())throw new Error("point at infinify");return m.assertValidity(),m}hasHighS(){return B(this.s)}toBytes(e=I){if(l(e),"der"===e)return(0,i.hexToBytes)(t.DER.hexFromSig(this));const r=h.toBytes(this.r),n=h.toBytes(this.s);if("recovered"===e){if(null==this.recovery)throw new Error("recovery bit must be present");return(0,i.concatBytes)(Uint8Array.of(this.recovery),r,n)}return(0,i.concatBytes)(r,n)}toHex(e){return(0,i.bytesToHex)(this.toBytes(e))}assertValidity(){}static fromCompact(e){return H.fromBytes((0,i.ensureBytes)("sig",e),"compact")}static fromDER(e){return H.fromBytes((0,i.ensureBytes)("sig",e),"der")}normalizeS(){return this.hasHighS()?new H(this.r,h.neg(this.s),this.recovery):this}toDERRawBytes(){return this.toBytes("der")}toDERHex(){return(0,i.bytesToHex)(this.toBytes("der"))}toCompactRawBytes(){return this.toBytes("compact")}toCompactHex(){return(0,i.bytesToHex)(this.toBytes("compact"))}}const O=a.bits2int||function(e){if(e.length>8192)throw new Error("input is too large");const t=(0,i.bytesToNumberBE)(e),r=8*e.length-y;return r>0?t>>BigInt(r):t},P=a.bits2int_modN||function(e){return h.create(O(e))},L=(0,i.bitMask)(y);function U(e){return(0,i.aInRange)("num < 2^"+y,e,d,L),h.toBytes(e)}function j(e,t){return(0,i._abytes2)(e,void 0,"message"),t?(0,i._abytes2)(r(e),void 0,"prehashed message"):e}return Object.freeze({keygen:v,getPublicKey:_,getSharedSecret:S,utils:k,lengths:A,Point:e,sign:function(t,n,o={}){t=(0,i.ensureBytes)("message",t);const{seed:a,k2sig:u}=function(t,r,n){if(["recovered","canonical"].some(e=>e in n))throw new Error("sign() legacy options not supported");const{lowS:o,prehash:a,extraEntropy:c}=f(n,x);t=j(t,a);const u=P(t),l=m(h,r),b=[U(l),U(u)];if(null!=c&&!1!==c){const e=!0===c?s(A.secretKey):c;b.push((0,i.ensureBytes)("extraEntropy",e))}const g=(0,i.concatBytes)(...b),y=u;return{seed:g,k2sig:function(t){const r=O(t);if(!h.isValidNot0(r))return;const n=h.inv(r),i=e.BASE.multiply(r).toAffine(),a=h.create(i.x);if(a===d)return;const s=h.create(n*h.create(y+a*l));if(s===d)return;let c=(i.x===a?0:2)|Number(i.y&p),u=s;return o&&B(s)&&(u=h.neg(s),c^=1),new H(a,u,c)}}}(t,n,o);return(0,i.createHmacDrbg)(r.outputLen,h.BYTES,c)(a,u)},verify:function(r,n,o,a={}){const{lowS:s,prehash:c,format:u}=f(a,x);if(o=(0,i.ensureBytes)("publicKey",o),n=j((0,i.ensureBytes)("message",n),c),"strict"in a)throw new Error("options.strict was renamed to lowS");const l=void 0===u?function(e){let r;const n="string"==typeof e||(0,i.isBytes)(e),o=!n&&null!==e&&"object"==typeof e&&"bigint"==typeof e.r&&"bigint"==typeof e.s;if(!n&&!o)throw new Error("invalid signature, expected Uint8Array, hex string or Signature instance");if(o)r=new H(e.r,e.s);else if(n){try{r=H.fromBytes((0,i.ensureBytes)("sig",e),"der")}catch(e){if(!(e instanceof t.DER.Err))throw e}if(!r)try{r=H.fromBytes((0,i.ensureBytes)("sig",e),"compact")}catch(e){return!1}}return r||!1}(r):H.fromBytes((0,i.ensureBytes)("sig",r),u);if(!1===l)return!1;try{const t=e.fromBytes(o);if(s&&l.hasHighS())return!1;const{r,s:i}=l,a=P(n),c=h.inv(i),u=h.create(a*c),f=h.create(r*c),d=e.BASE.multiplyUnsafe(u).add(t.multiplyUnsafe(f));return!d.is0()&&h.create(d.x)===r}catch(e){return!1}},recoverPublicKey:function(e,t,r={}){const{prehash:n}=f(r,x);return t=j(t,n),H.fromBytes(e,"recovered").recoverPublicKey(t).toBytes()},Signature:H,hash:r})}function A(e){const t={a:e.a,b:e.b,p:e.Fp.ORDER,n:e.n,h:e.h,Gx:e.Gx,Gy:e.Gy},r=e.Fp;let n=e.allowedPrivateKeyLengths?Array.from(new Set(e.allowedPrivateKeyLengths.map(e=>Math.ceil(e/2)))):void 0;return{CURVE:t,curveOpts:{Fp:r,Fn:(0,s.Field)(t.n,{BITS:e.nBitLength,allowedLengths:n,modFromBytes:e.wrapPrivateKey}),allowInfinityPoint:e.allowInfinityPoint,endo:e.endo,isTorsionFree:e.isTorsionFree,clearCofactor:e.clearCofactor,fromBytes:e.fromBytes,toBytes:e.toBytes}}}function x(e,t,r){return function(n){const o=e.sqr(n),i=e.mul(o,n);return e.add(e.add(i,e.mul(n,t)),r)}}},6243:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SHA512_IV=t.SHA384_IV=t.SHA224_IV=t.SHA256_IV=t.HashMD=void 0,t.setBigUint64=o,t.Chi=function(e,t,r){return e&t^~e&r},t.Maj=function(e,t,r){return e&t^e&r^t&r};const n=r(1717);function o(e,t,r,n){if("function"==typeof e.setBigUint64)return e.setBigUint64(t,r,n);const o=BigInt(32),i=BigInt(4294967295),a=Number(r>>o&i),s=Number(r&i),c=n?4:0,u=n?0:4;e.setUint32(t+c,a,n),e.setUint32(t+u,s,n)}class i extends n.Hash{constructor(e,t,r,o){super(),this.finished=!1,this.length=0,this.pos=0,this.destroyed=!1,this.blockLen=e,this.outputLen=t,this.padOffset=r,this.isLE=o,this.buffer=new Uint8Array(e),this.view=(0,n.createView)(this.buffer)}update(e){(0,n.aexists)(this),e=(0,n.toBytes)(e),(0,n.abytes)(e);const{view:t,buffer:r,blockLen:o}=this,i=e.length;for(let a=0;a<i;){const s=Math.min(o-this.pos,i-a);if(s===o){const t=(0,n.createView)(e);for(;o<=i-a;a+=o)this.process(t,a);continue}r.set(e.subarray(a,a+s),this.pos),this.pos+=s,a+=s,this.pos===o&&(this.process(t,0),this.pos=0)}return this.length+=e.length,this.roundClean(),this}digestInto(e){(0,n.aexists)(this),(0,n.aoutput)(e,this),this.finished=!0;const{buffer:t,view:r,blockLen:i,isLE:a}=this;let{pos:s}=this;t[s++]=128,(0,n.clean)(this.buffer.subarray(s)),this.padOffset>i-s&&(this.process(r,0),s=0);for(let e=s;e<i;e++)t[e]=0;o(r,i-8,BigInt(8*this.length),a),this.process(r,0);const c=(0,n.createView)(e),u=this.outputLen;if(u%4)throw new Error("_sha2: outputLen should be aligned to 32bit");const l=u/4,f=this.get();if(l>f.length)throw new Error("_sha2: outputLen bigger than state");for(let e=0;e<l;e++)c.setUint32(4*e,f[e],a)}digest(){const{buffer:e,outputLen:t}=this;this.digestInto(e);const r=e.slice(0,t);return this.destroy(),r}_cloneInto(e){e||(e=new this.constructor),e.set(...this.get());const{blockLen:t,buffer:r,length:n,finished:o,destroyed:i,pos:a}=this;return e.destroyed=i,e.finished=o,e.length=n,e.pos=a,n%t&&e.buffer.set(r),e}clone(){return this._cloneInto()}}t.HashMD=i,t.SHA256_IV=Uint32Array.from([1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225]),t.SHA224_IV=Uint32Array.from([3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428]),t.SHA384_IV=Uint32Array.from([3418070365,3238371032,1654270250,914150663,2438529370,812702999,355462360,4144912697,1731405415,4290775857,2394180231,1750603025,3675008525,1694076839,1203062813,3204075428]),t.SHA512_IV=Uint32Array.from([1779033703,4089235720,3144134277,2227873595,1013904242,4271175723,2773480762,1595750129,1359893119,2917565137,2600822924,725511199,528734635,4215389547,1541459225,327033209])},8513:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.toBig=t.shrSL=t.shrSH=t.rotrSL=t.rotrSH=t.rotrBL=t.rotrBH=t.rotr32L=t.rotr32H=t.rotlSL=t.rotlSH=t.rotlBL=t.rotlBH=t.add5L=t.add5H=t.add4L=t.add4H=t.add3L=t.add3H=void 0,t.add=v,t.fromBig=o,t.split=i;const r=BigInt(2**32-1),n=BigInt(32);function o(e,t=!1){return t?{h:Number(e&r),l:Number(e>>n&r)}:{h:0|Number(e>>n&r),l:0|Number(e&r)}}function i(e,t=!1){const r=e.length;let n=new Uint32Array(r),i=new Uint32Array(r);for(let a=0;a<r;a++){const{h:r,l:s}=o(e[a],t);[n[a],i[a]]=[r,s]}return[n,i]}const a=(e,t)=>BigInt(e>>>0)<<n|BigInt(t>>>0);t.toBig=a;const s=(e,t,r)=>e>>>r;t.shrSH=s;const c=(e,t,r)=>e<<32-r|t>>>r;t.shrSL=c;const u=(e,t,r)=>e>>>r|t<<32-r;t.rotrSH=u;const l=(e,t,r)=>e<<32-r|t>>>r;t.rotrSL=l;const f=(e,t,r)=>e<<64-r|t>>>r-32;t.rotrBH=f;const h=(e,t,r)=>e>>>r-32|t<<64-r;t.rotrBL=h;const d=(e,t)=>t;t.rotr32H=d;const p=(e,t)=>e;t.rotr32L=p;const b=(e,t,r)=>e<<r|t>>>32-r;t.rotlSH=b;const g=(e,t,r)=>t<<r|e>>>32-r;t.rotlSL=g;const y=(e,t,r)=>t<<r-32|e>>>64-r;t.rotlBH=y;const m=(e,t,r)=>e<<r-32|t>>>64-r;function v(e,t,r,n){const o=(t>>>0)+(n>>>0);return{h:e+r+(o/2**32|0)|0,l:0|o}}t.rotlBL=m;const w=(e,t,r)=>(e>>>0)+(t>>>0)+(r>>>0);t.add3L=w;const _=(e,t,r,n)=>t+r+n+(e/2**32|0)|0;t.add3H=_;const S=(e,t,r,n)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0);t.add4L=S;const E=(e,t,r,n,o)=>t+r+n+o+(e/2**32|0)|0;t.add4H=E;const k=(e,t,r,n,o)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0)+(o>>>0);t.add5L=k;const A=(e,t,r,n,o,i)=>t+r+n+o+i+(e/2**32|0)|0;t.add5H=A;const x={fromBig:o,split:i,toBig:a,shrSH:s,shrSL:c,rotrSH:u,rotrSL:l,rotrBH:f,rotrBL:h,rotr32H:d,rotr32L:p,rotlSH:b,rotlSL:g,rotlBH:y,rotlBL:m,add:v,add3L:w,add3H:_,add4L:S,add4H:E,add5H:A,add5L:k};t.default=x},7564:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.crypto=void 0,t.crypto="object"==typeof globalThis&&"crypto"in globalThis?globalThis.crypto:void 0},1128:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.hmac=t.HMAC=void 0;const n=r(1717);class o extends n.Hash{constructor(e,t){super(),this.finished=!1,this.destroyed=!1,(0,n.ahash)(e);const r=(0,n.toBytes)(t);if(this.iHash=e.create(),"function"!=typeof this.iHash.update)throw new Error("Expected instance of class which extends utils.Hash");this.blockLen=this.iHash.blockLen,this.outputLen=this.iHash.outputLen;const o=this.blockLen,i=new Uint8Array(o);i.set(r.length>o?e.create().update(r).digest():r);for(let e=0;e<i.length;e++)i[e]^=54;this.iHash.update(i),this.oHash=e.create();for(let e=0;e<i.length;e++)i[e]^=106;this.oHash.update(i),(0,n.clean)(i)}update(e){return(0,n.aexists)(this),this.iHash.update(e),this}digestInto(e){(0,n.aexists)(this),(0,n.abytes)(e,this.outputLen),this.finished=!0,this.iHash.digestInto(e),this.oHash.update(e),this.oHash.digestInto(e),this.destroy()}digest(){const e=new Uint8Array(this.oHash.outputLen);return this.digestInto(e),e}_cloneInto(e){e||(e=Object.create(Object.getPrototypeOf(this),{}));const{oHash:t,iHash:r,finished:n,destroyed:o,blockLen:i,outputLen:a}=this;return e.finished=n,e.destroyed=o,e.blockLen=i,e.outputLen=a,e.oHash=t._cloneInto(e.oHash),e.iHash=r._cloneInto(e.iHash),e}clone(){return this._cloneInto()}destroy(){this.destroyed=!0,this.oHash.destroy(),this.iHash.destroy()}}t.HMAC=o,t.hmac=(e,t,r)=>new o(e,t).update(r).digest(),t.hmac.create=(e,t)=>new o(e,t)},4941:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha512_224=t.sha512_256=t.sha384=t.sha512=t.sha224=t.sha256=t.SHA512_256=t.SHA512_224=t.SHA384=t.SHA512=t.SHA224=t.SHA256=void 0;const n=r(6243),o=r(8513),i=r(1717),a=Uint32Array.from([1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298]),s=new Uint32Array(64);class c extends n.HashMD{constructor(e=32){super(64,e,8,!1),this.A=0|n.SHA256_IV[0],this.B=0|n.SHA256_IV[1],this.C=0|n.SHA256_IV[2],this.D=0|n.SHA256_IV[3],this.E=0|n.SHA256_IV[4],this.F=0|n.SHA256_IV[5],this.G=0|n.SHA256_IV[6],this.H=0|n.SHA256_IV[7]}get(){const{A:e,B:t,C:r,D:n,E:o,F:i,G:a,H:s}=this;return[e,t,r,n,o,i,a,s]}set(e,t,r,n,o,i,a,s){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n,this.E=0|o,this.F=0|i,this.G=0|a,this.H=0|s}process(e,t){for(let r=0;r<16;r++,t+=4)s[r]=e.getUint32(t,!1);for(let e=16;e<64;e++){const t=s[e-15],r=s[e-2],n=(0,i.rotr)(t,7)^(0,i.rotr)(t,18)^t>>>3,o=(0,i.rotr)(r,17)^(0,i.rotr)(r,19)^r>>>10;s[e]=o+s[e-7]+n+s[e-16]|0}let{A:r,B:o,C:c,D:u,E:l,F:f,G:h,H:d}=this;for(let e=0;e<64;e++){const t=d+((0,i.rotr)(l,6)^(0,i.rotr)(l,11)^(0,i.rotr)(l,25))+(0,n.Chi)(l,f,h)+a[e]+s[e]|0,p=((0,i.rotr)(r,2)^(0,i.rotr)(r,13)^(0,i.rotr)(r,22))+(0,n.Maj)(r,o,c)|0;d=h,h=f,f=l,l=u+t|0,u=c,c=o,o=r,r=t+p|0}r=r+this.A|0,o=o+this.B|0,c=c+this.C|0,u=u+this.D|0,l=l+this.E|0,f=f+this.F|0,h=h+this.G|0,d=d+this.H|0,this.set(r,o,c,u,l,f,h,d)}roundClean(){(0,i.clean)(s)}destroy(){this.set(0,0,0,0,0,0,0,0),(0,i.clean)(this.buffer)}}t.SHA256=c;class u extends c{constructor(){super(28),this.A=0|n.SHA224_IV[0],this.B=0|n.SHA224_IV[1],this.C=0|n.SHA224_IV[2],this.D=0|n.SHA224_IV[3],this.E=0|n.SHA224_IV[4],this.F=0|n.SHA224_IV[5],this.G=0|n.SHA224_IV[6],this.H=0|n.SHA224_IV[7]}}t.SHA224=u;const l=(()=>o.split(["0x428a2f98d728ae22","0x7137449123ef65cd","0xb5c0fbcfec4d3b2f","0xe9b5dba58189dbbc","0x3956c25bf348b538","0x59f111f1b605d019","0x923f82a4af194f9b","0xab1c5ed5da6d8118","0xd807aa98a3030242","0x12835b0145706fbe","0x243185be4ee4b28c","0x550c7dc3d5ffb4e2","0x72be5d74f27b896f","0x80deb1fe3b1696b1","0x9bdc06a725c71235","0xc19bf174cf692694","0xe49b69c19ef14ad2","0xefbe4786384f25e3","0x0fc19dc68b8cd5b5","0x240ca1cc77ac9c65","0x2de92c6f592b0275","0x4a7484aa6ea6e483","0x5cb0a9dcbd41fbd4","0x76f988da831153b5","0x983e5152ee66dfab","0xa831c66d2db43210","0xb00327c898fb213f","0xbf597fc7beef0ee4","0xc6e00bf33da88fc2","0xd5a79147930aa725","0x06ca6351e003826f","0x142929670a0e6e70","0x27b70a8546d22ffc","0x2e1b21385c26c926","0x4d2c6dfc5ac42aed","0x53380d139d95b3df","0x650a73548baf63de","0x766a0abb3c77b2a8","0x81c2c92e47edaee6","0x92722c851482353b","0xa2bfe8a14cf10364","0xa81a664bbc423001","0xc24b8b70d0f89791","0xc76c51a30654be30","0xd192e819d6ef5218","0xd69906245565a910","0xf40e35855771202a","0x106aa07032bbd1b8","0x19a4c116b8d2d0c8","0x1e376c085141ab53","0x2748774cdf8eeb99","0x34b0bcb5e19b48a8","0x391c0cb3c5c95a63","0x4ed8aa4ae3418acb","0x5b9cca4f7763e373","0x682e6ff3d6b2b8a3","0x748f82ee5defb2fc","0x78a5636f43172f60","0x84c87814a1f0ab72","0x8cc702081a6439ec","0x90befffa23631e28","0xa4506cebde82bde9","0xbef9a3f7b2c67915","0xc67178f2e372532b","0xca273eceea26619c","0xd186b8c721c0c207","0xeada7dd6cde0eb1e","0xf57d4f7fee6ed178","0x06f067aa72176fba","0x0a637dc5a2c898a6","0x113f9804bef90dae","0x1b710b35131c471b","0x28db77f523047d84","0x32caab7b40c72493","0x3c9ebe0a15c9bebc","0x431d67c49c100d4c","0x4cc5d4becb3e42b6","0x597f299cfc657e2a","0x5fcb6fab3ad6faec","0x6c44198c4a475817"].map(e=>BigInt(e))))(),f=(()=>l[0])(),h=(()=>l[1])(),d=new Uint32Array(80),p=new Uint32Array(80);class b extends n.HashMD{constructor(e=64){super(128,e,16,!1),this.Ah=0|n.SHA512_IV[0],this.Al=0|n.SHA512_IV[1],this.Bh=0|n.SHA512_IV[2],this.Bl=0|n.SHA512_IV[3],this.Ch=0|n.SHA512_IV[4],this.Cl=0|n.SHA512_IV[5],this.Dh=0|n.SHA512_IV[6],this.Dl=0|n.SHA512_IV[7],this.Eh=0|n.SHA512_IV[8],this.El=0|n.SHA512_IV[9],this.Fh=0|n.SHA512_IV[10],this.Fl=0|n.SHA512_IV[11],this.Gh=0|n.SHA512_IV[12],this.Gl=0|n.SHA512_IV[13],this.Hh=0|n.SHA512_IV[14],this.Hl=0|n.SHA512_IV[15]}get(){const{Ah:e,Al:t,Bh:r,Bl:n,Ch:o,Cl:i,Dh:a,Dl:s,Eh:c,El:u,Fh:l,Fl:f,Gh:h,Gl:d,Hh:p,Hl:b}=this;return[e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b]}set(e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b){this.Ah=0|e,this.Al=0|t,this.Bh=0|r,this.Bl=0|n,this.Ch=0|o,this.Cl=0|i,this.Dh=0|a,this.Dl=0|s,this.Eh=0|c,this.El=0|u,this.Fh=0|l,this.Fl=0|f,this.Gh=0|h,this.Gl=0|d,this.Hh=0|p,this.Hl=0|b}process(e,t){for(let r=0;r<16;r++,t+=4)d[r]=e.getUint32(t),p[r]=e.getUint32(t+=4);for(let e=16;e<80;e++){const t=0|d[e-15],r=0|p[e-15],n=o.rotrSH(t,r,1)^o.rotrSH(t,r,8)^o.shrSH(t,r,7),i=o.rotrSL(t,r,1)^o.rotrSL(t,r,8)^o.shrSL(t,r,7),a=0|d[e-2],s=0|p[e-2],c=o.rotrSH(a,s,19)^o.rotrBH(a,s,61)^o.shrSH(a,s,6),u=o.rotrSL(a,s,19)^o.rotrBL(a,s,61)^o.shrSL(a,s,6),l=o.add4L(i,u,p[e-7],p[e-16]),f=o.add4H(l,n,c,d[e-7],d[e-16]);d[e]=0|f,p[e]=0|l}let{Ah:r,Al:n,Bh:i,Bl:a,Ch:s,Cl:c,Dh:u,Dl:l,Eh:b,El:g,Fh:y,Fl:m,Gh:v,Gl:w,Hh:_,Hl:S}=this;for(let e=0;e<80;e++){const t=o.rotrSH(b,g,14)^o.rotrSH(b,g,18)^o.rotrBH(b,g,41),E=o.rotrSL(b,g,14)^o.rotrSL(b,g,18)^o.rotrBL(b,g,41),k=b&y^~b&v,A=g&m^~g&w,x=o.add5L(S,E,A,h[e],p[e]),I=o.add5H(x,_,t,k,f[e],d[e]),B=0|x,T=o.rotrSH(r,n,28)^o.rotrBH(r,n,34)^o.rotrBH(r,n,39),H=o.rotrSL(r,n,28)^o.rotrBL(r,n,34)^o.rotrBL(r,n,39),O=r&i^r&s^i&s,P=n&a^n&c^a&c;_=0|v,S=0|w,v=0|y,w=0|m,y=0|b,m=0|g,({h:b,l:g}=o.add(0|u,0|l,0|I,0|B)),u=0|s,l=0|c,s=0|i,c=0|a,i=0|r,a=0|n;const L=o.add3L(B,H,P);r=o.add3H(L,I,T,O),n=0|L}({h:r,l:n}=o.add(0|this.Ah,0|this.Al,0|r,0|n)),({h:i,l:a}=o.add(0|this.Bh,0|this.Bl,0|i,0|a)),({h:s,l:c}=o.add(0|this.Ch,0|this.Cl,0|s,0|c)),({h:u,l}=o.add(0|this.Dh,0|this.Dl,0|u,0|l)),({h:b,l:g}=o.add(0|this.Eh,0|this.El,0|b,0|g)),({h:y,l:m}=o.add(0|this.Fh,0|this.Fl,0|y,0|m)),({h:v,l:w}=o.add(0|this.Gh,0|this.Gl,0|v,0|w)),({h:_,l:S}=o.add(0|this.Hh,0|this.Hl,0|_,0|S)),this.set(r,n,i,a,s,c,u,l,b,g,y,m,v,w,_,S)}roundClean(){(0,i.clean)(d,p)}destroy(){(0,i.clean)(this.buffer),this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)}}t.SHA512=b;class g extends b{constructor(){super(48),this.Ah=0|n.SHA384_IV[0],this.Al=0|n.SHA384_IV[1],this.Bh=0|n.SHA384_IV[2],this.Bl=0|n.SHA384_IV[3],this.Ch=0|n.SHA384_IV[4],this.Cl=0|n.SHA384_IV[5],this.Dh=0|n.SHA384_IV[6],this.Dl=0|n.SHA384_IV[7],this.Eh=0|n.SHA384_IV[8],this.El=0|n.SHA384_IV[9],this.Fh=0|n.SHA384_IV[10],this.Fl=0|n.SHA384_IV[11],this.Gh=0|n.SHA384_IV[12],this.Gl=0|n.SHA384_IV[13],this.Hh=0|n.SHA384_IV[14],this.Hl=0|n.SHA384_IV[15]}}t.SHA384=g;const y=Uint32Array.from([2352822216,424955298,1944164710,2312950998,502970286,855612546,1738396948,1479516111,258812777,2077511080,2011393907,79989058,1067287976,1780299464,286451373,2446758561]),m=Uint32Array.from([573645204,4230739756,2673172387,3360449730,596883563,1867755857,2520282905,1497426621,2519219938,2827943907,3193839141,1401305490,721525244,746961066,246885852,2177182882]);class v extends b{constructor(){super(28),this.Ah=0|y[0],this.Al=0|y[1],this.Bh=0|y[2],this.Bl=0|y[3],this.Ch=0|y[4],this.Cl=0|y[5],this.Dh=0|y[6],this.Dl=0|y[7],this.Eh=0|y[8],this.El=0|y[9],this.Fh=0|y[10],this.Fl=0|y[11],this.Gh=0|y[12],this.Gl=0|y[13],this.Hh=0|y[14],this.Hl=0|y[15]}}t.SHA512_224=v;class w extends b{constructor(){super(32),this.Ah=0|m[0],this.Al=0|m[1],this.Bh=0|m[2],this.Bl=0|m[3],this.Ch=0|m[4],this.Cl=0|m[5],this.Dh=0|m[6],this.Dl=0|m[7],this.Eh=0|m[8],this.El=0|m[9],this.Fh=0|m[10],this.Fl=0|m[11],this.Gh=0|m[12],this.Gl=0|m[13],this.Hh=0|m[14],this.Hl=0|m[15]}}t.SHA512_256=w,t.sha256=(0,i.createHasher)(()=>new c),t.sha224=(0,i.createHasher)(()=>new u),t.sha512=(0,i.createHasher)(()=>new b),t.sha384=(0,i.createHasher)(()=>new g),t.sha512_256=(0,i.createHasher)(()=>new w),t.sha512_224=(0,i.createHasher)(()=>new v)},1717:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.wrapXOFConstructorWithOpts=t.wrapConstructorWithOpts=t.wrapConstructor=t.Hash=t.nextTick=t.swap32IfBE=t.byteSwapIfBE=t.swap8IfBE=t.isLE=void 0,t.isBytes=o,t.anumber=i,t.abytes=a,t.ahash=function(e){if("function"!=typeof e||"function"!=typeof e.create)throw new Error("Hash should be wrapped by utils.createHasher");i(e.outputLen),i(e.blockLen)},t.aexists=function(e,t=!0){if(e.destroyed)throw new Error("Hash instance has been destroyed");if(t&&e.finished)throw new Error("Hash#digest() has already been called")},t.aoutput=function(e,t){a(e);const r=t.outputLen;if(e.length<r)throw new Error("digestInto() expects output buffer of length at least "+r)},t.u8=function(e){return new Uint8Array(e.buffer,e.byteOffset,e.byteLength)},t.u32=function(e){return new Uint32Array(e.buffer,e.byteOffset,Math.floor(e.byteLength/4))},t.clean=function(...e){for(let t=0;t<e.length;t++)e[t].fill(0)},t.createView=function(e){return new DataView(e.buffer,e.byteOffset,e.byteLength)},t.rotr=function(e,t){return e<<32-t|e>>>t},t.rotl=function(e,t){return e<<t|e>>>32-t>>>0},t.byteSwap=s,t.byteSwap32=c,t.bytesToHex=function(e){if(a(e),u)return e.toHex();let t="";for(let r=0;r<e.length;r++)t+=l[e[r]];return t},t.hexToBytes=function(e){if("string"!=typeof e)throw new Error("hex string expected, got "+typeof e);if(u)return Uint8Array.fromHex(e);const t=e.length,r=t/2;if(t%2)throw new Error("hex string expected, got unpadded hex of length "+t);const n=new Uint8Array(r);for(let t=0,o=0;t<r;t++,o+=2){const r=h(e.charCodeAt(o)),i=h(e.charCodeAt(o+1));if(void 0===r||void 0===i){const t=e[o]+e[o+1];throw new Error('hex string expected, got non-hex character "'+t+'" at index '+o)}n[t]=16*r+i}return n},t.asyncLoop=async function(e,r,n){let o=Date.now();for(let i=0;i<e;i++){n(i);const e=Date.now()-o;e>=0&&e<r||(await(0,t.nextTick)(),o+=e)}},t.utf8ToBytes=d,t.bytesToUtf8=function(e){return(new TextDecoder).decode(e)},t.toBytes=p,t.kdfInputToBytes=function(e){return"string"==typeof e&&(e=d(e)),a(e),e},t.concatBytes=function(...e){let t=0;for(let r=0;r<e.length;r++){const n=e[r];a(n),t+=n.length}const r=new Uint8Array(t);for(let t=0,n=0;t<e.length;t++){const o=e[t];r.set(o,n),n+=o.length}return r},t.checkOpts=function(e,t){if(void 0!==t&&"[object Object]"!=={}.toString.call(t))throw new Error("options should be object or undefined");return Object.assign(e,t)},t.createHasher=b,t.createOptHasher=g,t.createXOFer=y,t.randomBytes=function(e=32){if(n.crypto&&"function"==typeof n.crypto.getRandomValues)return n.crypto.getRandomValues(new Uint8Array(e));if(n.crypto&&"function"==typeof n.crypto.randomBytes)return Uint8Array.from(n.crypto.randomBytes(e));throw new Error("crypto.getRandomValues must be defined")};const n=r(7564);function o(e){return e instanceof Uint8Array||ArrayBuffer.isView(e)&&"Uint8Array"===e.constructor.name}function i(e){if(!Number.isSafeInteger(e)||e<0)throw new Error("positive integer expected, got "+e)}function a(e,...t){if(!o(e))throw new Error("Uint8Array expected");if(t.length>0&&!t.includes(e.length))throw new Error("Uint8Array expected of length "+t+", got length="+e.length)}function s(e){return e<<24&4278190080|e<<8&16711680|e>>>8&65280|e>>>24&255}function c(e){for(let t=0;t<e.length;t++)e[t]=s(e[t]);return e}t.isLE=68===new Uint8Array(new Uint32Array([287454020]).buffer)[0],t.swap8IfBE=t.isLE?e=>e:e=>s(e),t.byteSwapIfBE=t.swap8IfBE,t.swap32IfBE=t.isLE?e=>e:c;const u=(()=>"function"==typeof Uint8Array.from([]).toHex&&"function"==typeof Uint8Array.fromHex)(),l=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0")),f={_0:48,_9:57,A:65,F:70,a:97,f:102};function h(e){return e>=f._0&&e<=f._9?e-f._0:e>=f.A&&e<=f.F?e-(f.A-10):e>=f.a&&e<=f.f?e-(f.a-10):void 0}function d(e){if("string"!=typeof e)throw new Error("string expected");return new Uint8Array((new TextEncoder).encode(e))}function p(e){return"string"==typeof e&&(e=d(e)),a(e),e}function b(e){const t=t=>e().update(p(t)).digest(),r=e();return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=()=>e(),t}function g(e){const t=(t,r)=>e(r).update(p(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t}function y(e){const t=(t,r)=>e(r).update(p(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t}t.nextTick=async()=>{},t.Hash=class{},t.wrapConstructor=b,t.wrapConstructorWithOpts=g,t.wrapXOFConstructorWithOpts=y},3497:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.encodeToCurve=t.hashToCurve=t.secp256k1_hasher=t.schnorr=t.secp256k1=void 0;const n=r(4941),o=r(1717),i=r(9082),a=r(5134),s=r(6351),c=r(6551),u=r(3409),l={p:BigInt("0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffefffffc2f"),n:BigInt("0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141"),h:BigInt(1),a:BigInt(0),b:BigInt(7),Gx:BigInt("0x79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798"),Gy:BigInt("0x483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8")},f={beta:BigInt("0x7ae96a2b657c07106e64479eac3434e99cf0497512f58995c1396c28719501ee"),basises:[[BigInt("0x3086d221a7d46bcde86c90e49284eb15"),-BigInt("0xe4437ed6010e88286f547fa90abfe4c3")],[BigInt("0x114ca50f7a8e2f3f657c1108d9d44cfd8"),BigInt("0x3086d221a7d46bcde86c90e49284eb15")]]},h=BigInt(0),d=BigInt(1),p=BigInt(2),b=(0,s.Field)(l.p,{sqrt:function(e){const t=l.p,r=BigInt(3),n=BigInt(6),o=BigInt(11),i=BigInt(22),a=BigInt(23),c=BigInt(44),u=BigInt(88),f=e*e*e%t,h=f*f*e%t,d=(0,s.pow2)(h,r,t)*h%t,g=(0,s.pow2)(d,r,t)*h%t,y=(0,s.pow2)(g,p,t)*f%t,m=(0,s.pow2)(y,o,t)*y%t,v=(0,s.pow2)(m,i,t)*m%t,w=(0,s.pow2)(v,c,t)*v%t,_=(0,s.pow2)(w,u,t)*w%t,S=(0,s.pow2)(_,c,t)*v%t,E=(0,s.pow2)(S,r,t)*h%t,k=(0,s.pow2)(E,a,t)*m%t,A=(0,s.pow2)(k,n,t)*f%t,x=(0,s.pow2)(A,p,t);if(!b.eql(b.sqr(x),e))throw new Error("Cannot find square root");return x}});t.secp256k1=(0,i.createCurve)({...l,Fp:b,lowS:!0,endo:f},n.sha256);const g={};function y(e,...t){let r=g[e];if(void 0===r){const t=(0,n.sha256)((0,u.utf8ToBytes)(e));r=(0,u.concatBytes)(t,t),g[e]=r}return(0,n.sha256)((0,u.concatBytes)(r,...t))}const m=e=>e.toBytes(!0).slice(1),v=(()=>t.secp256k1.Point)(),w=e=>e%p===h;function _(e){const{Fn:t,BASE:r}=v,n=(0,c._normFnElement)(t,e),o=r.multiply(n);return{scalar:w(o.y)?n:t.neg(n),bytes:m(o)}}function S(e){const t=b;if(!t.isValidNot0(e))throw new Error("invalid x: Fail if x ≥ p");const r=t.create(e*e),n=t.create(r*e+BigInt(7));let o=t.sqrt(n);w(o)||(o=t.neg(o));const i=v.fromAffine({x:e,y:o});return i.assertValidity(),i}const E=u.bytesToNumberBE;function k(...e){return v.Fn.create(E(y("BIP0340/challenge",...e)))}function A(e){return _(e).bytes}function x(e,t,r=(0,o.randomBytes)(32)){const{Fn:n}=v,i=(0,u.ensureBytes)("message",e),{bytes:a,scalar:s}=_(t),c=(0,u.ensureBytes)("auxRand",r,32),l=n.toBytes(s^E(y("BIP0340/aux",c))),f=y("BIP0340/nonce",l,a,i),{bytes:h,scalar:d}=_(f),p=k(h,a,i),b=new Uint8Array(64);if(b.set(h,0),b.set(n.toBytes(n.create(d+p*s)),32),!I(b,i,a))throw new Error("sign: Invalid signature produced");return b}function I(e,t,r){const{Fn:n,BASE:o}=v,i=(0,u.ensureBytes)("signature",e,64),a=(0,u.ensureBytes)("message",t),s=(0,u.ensureBytes)("publicKey",r,32);try{const e=S(E(s)),t=E(i.subarray(0,32));if(!(0,u.inRange)(t,d,l.p))return!1;const r=E(i.subarray(32,64));if(!(0,u.inRange)(r,d,l.n))return!1;const c=k(n.toBytes(t),m(e),a),f=o.multiplyUnsafe(r).add(e.multiplyUnsafe(n.neg(c))),{x:h,y:p}=f.toAffine();return!(f.is0()||!w(p)||h!==t)}catch(e){return!1}}t.schnorr=(()=>{const e=(e=(0,o.randomBytes)(48))=>(0,s.mapHashToField)(e,l.n);return t.secp256k1.utils.randomSecretKey,{keygen:function(t){const r=e(t);return{secretKey:r,publicKey:A(r)}},getPublicKey:A,sign:x,verify:I,Point:v,utils:{randomSecretKey:e,randomPrivateKey:e,taggedHash:y,lift_x:S,pointToBytes:m,numberToBytesBE:u.numberToBytesBE,bytesToNumberBE:u.bytesToNumberBE,mod:s.mod},lengths:{secretKey:32,publicKey:32,publicKeyHasPrefix:!1,signature:64,seed:48}}})();const B=(()=>(0,a.isogenyMap)(b,[["0x8e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38daaaaa8c7","0x7d3d4c80bc321d5b9f315cea7fd44c5d595d2fc0bf63b92dfff1044f17c6581","0x534c328d23f234e6e2a413deca25caece4506144037c40314ecbd0b53d9dd262","0x8e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38e38daaaaa88c"],["0xd35771193d94918a9ca34ccbb7b640dd86cd409542f8487d9fe6b745781eb49b","0xedadc6f64383dc1df7c4b2d51b54225406d36b641f5e41bbc52a56612a8c6d14","0x0000000000000000000000000000000000000000000000000000000000000001"],["0x4bda12f684bda12f684bda12f684bda12f684bda12f684bda12f684b8e38e23c","0xc75e0c32d5cb7c0fa9d0a54b12a0a6d5647ab046d686da6fdffc90fc201d71a3","0x29a6194691f91a73715209ef6512e576722830a201be2018a765e85a9ecee931","0x2f684bda12f684bda12f684bda12f684bda12f684bda12f684bda12f38e38d84"],["0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffefffff93b","0x7a06534bb8bdb49fd5e9e6632722c2989467c1bfc8e8d978dfb425d2685c2573","0x6484aa716545ca2cf3a70c3fa8fe337e0a3d21162f0d6299a7bf8192bfd2a76f","0x0000000000000000000000000000000000000000000000000000000000000001"]].map(e=>e.map(e=>BigInt(e)))))(),T=(()=>(0,c.mapToCurveSimpleSWU)(b,{A:BigInt("0x3f8731abdd661adca08a5558f0f5d272e953d363cb6f0e5d405447c01a444533"),B:BigInt("1771"),Z:b.create(BigInt("-11"))}))();t.secp256k1_hasher=(0,a.createHasher)(t.secp256k1.Point,e=>{const{x:t,y:r}=T(b.create(e[0]));return B(t,r)},{DST:"secp256k1_XMD:SHA-256_SSWU_RO_",encodeDST:"secp256k1_XMD:SHA-256_SSWU_NU_",p:b.ORDER,m:1,k:128,expand:"xmd",hash:n.sha256}),t.hashToCurve=t.secp256k1_hasher.hashToCurve,t.encodeToCurve=t.secp256k1_hasher.encodeToCurve},3409:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.notImplemented=t.bitMask=t.utf8ToBytes=t.randomBytes=t.isBytes=t.hexToBytes=t.concatBytes=t.bytesToUtf8=t.bytesToHex=t.anumber=t.abytes=void 0,t.abool=function(e,t){if("boolean"!=typeof t)throw new Error(e+" boolean expected, got "+t)},t._abool2=function(e,t=""){if("boolean"!=typeof e)throw new Error((t&&`"${t}"`)+"expected boolean, got type="+typeof e);return e},t._abytes2=function(e,t,r=""){const o=(0,n.isBytes)(e),i=e?.length,a=void 0!==t;if(!o||a&&i!==t)throw new Error((r&&`"${r}" `)+"expected Uint8Array"+(a?` of length ${t}`:"")+", got "+(o?`length=${i}`:"type="+typeof e));return e},t.numberToHexUnpadded=s,t.hexToNumber=c,t.bytesToNumberBE=function(e){return c((0,n.bytesToHex)(e))},t.bytesToNumberLE=function(e){return(0,n.abytes)(e),c((0,n.bytesToHex)(Uint8Array.from(e).reverse()))},t.numberToBytesBE=u,t.numberToBytesLE=function(e,t){return u(e,t).reverse()},t.numberToVarBytesBE=function(e){return(0,n.hexToBytes)(s(e))},t.ensureBytes=function(e,t,r){let o;if("string"==typeof t)try{o=(0,n.hexToBytes)(t)}catch(t){throw new Error(e+" must be hex string or Uint8Array, cause: "+t)}else{if(!(0,n.isBytes)(t))throw new Error(e+" must be hex string or Uint8Array");o=Uint8Array.from(t)}const i=o.length;if("number"==typeof r&&i!==r)throw new Error(e+" of length "+r+" expected, got "+i);return o},t.equalBytes=function(e,t){if(e.length!==t.length)return!1;let r=0;for(let n=0;n<e.length;n++)r|=e[n]^t[n];return 0===r},t.copyBytes=function(e){return Uint8Array.from(e)},t.asciiToBytes=function(e){return Uint8Array.from(e,(t,r)=>{const n=t.charCodeAt(0);if(1!==t.length||n>127)throw new Error(`string contains non-ASCII character "${e[r]}" with code ${n} at position ${r}`);return n})},t.inRange=f,t.aInRange=function(e,t,r,n){if(!f(t,r,n))throw new Error("expected valid "+e+": "+r+" <= n < "+n+", got "+t)},t.bitLen=function(e){let t;for(t=0;e>i;e>>=a,t+=1);return t},t.bitGet=function(e,t){return e>>BigInt(t)&a},t.bitSet=function(e,t,r){return e|(r?a:i)<<BigInt(t)},t.createHmacDrbg=function(e,t,r){if("number"!=typeof e||e<2)throw new Error("hashLen must be a number");if("number"!=typeof t||t<2)throw new Error("qByteLen must be a number");if("function"!=typeof r)throw new Error("hmacFn must be a function");const o=e=>new Uint8Array(e),i=e=>Uint8Array.of(e);let a=o(e),s=o(e),c=0;const u=()=>{a.fill(1),s.fill(0),c=0},l=(...e)=>r(s,a,...e),f=(e=o(0))=>{s=l(i(0),e),a=l(),0!==e.length&&(s=l(i(1),e),a=l())},h=()=>{if(c++>=1e3)throw new Error("drbg: tried 1000 values");let e=0;const r=[];for(;e<t;){a=l();const t=a.slice();r.push(t),e+=a.length}return(0,n.concatBytes)(...r)};return(e,t)=>{let r;for(u(),f(e);!(r=t(h()));)f();return u(),r}},t.validateObject=function(e,t,r={}){const n=(t,r,n)=>{const o=h[r];if("function"!=typeof o)throw new Error("invalid validator function");const i=e[t];if(!(n&&void 0===i||o(i,e)))throw new Error("param "+String(t)+" is invalid. Expected "+r+", got "+i)};for(const[e,r]of Object.entries(t))n(e,r,!1);for(const[e,t]of Object.entries(r))n(e,t,!0);return e},t.isHash=function(e){return"function"==typeof e&&Number.isSafeInteger(e.outputLen)},t._validateObject=function(e,t,r={}){if(!e||"object"!=typeof e)throw new Error("expected valid options object");function n(t,r,n){const o=e[t];if(n&&void 0===o)return;const i=typeof o;if(i!==r||null===o)throw new Error(`param "${t}" is invalid: expected ${r}, got ${i}`)}Object.entries(t).forEach(([e,t])=>n(e,t,!1)),Object.entries(r).forEach(([e,t])=>n(e,t,!0))},t.memoized=function(e){const t=new WeakMap;return(r,...n)=>{const o=t.get(r);if(void 0!==o)return o;const i=e(r,...n);return t.set(r,i),i}};const n=r(1717);var o=r(1717);Object.defineProperty(t,"abytes",{enumerable:!0,get:function(){return o.abytes}}),Object.defineProperty(t,"anumber",{enumerable:!0,get:function(){return o.anumber}}),Object.defineProperty(t,"bytesToHex",{enumerable:!0,get:function(){return o.bytesToHex}}),Object.defineProperty(t,"bytesToUtf8",{enumerable:!0,get:function(){return o.bytesToUtf8}}),Object.defineProperty(t,"concatBytes",{enumerable:!0,get:function(){return o.concatBytes}}),Object.defineProperty(t,"hexToBytes",{enumerable:!0,get:function(){return o.hexToBytes}}),Object.defineProperty(t,"isBytes",{enumerable:!0,get:function(){return o.isBytes}}),Object.defineProperty(t,"randomBytes",{enumerable:!0,get:function(){return o.randomBytes}}),Object.defineProperty(t,"utf8ToBytes",{enumerable:!0,get:function(){return o.utf8ToBytes}});const i=BigInt(0),a=BigInt(1);function s(e){const t=e.toString(16);return 1&t.length?"0"+t:t}function c(e){if("string"!=typeof e)throw new Error("hex string expected, got "+typeof e);return""===e?i:BigInt("0x"+e)}function u(e,t){return(0,n.hexToBytes)(e.toString(16).padStart(2*t,"0"))}const l=e=>"bigint"==typeof e&&i<=e;function f(e,t,r){return l(e)&&l(t)&&l(r)&&t<=e&&e<r}t.bitMask=e=>(a<<BigInt(e))-a;const h={bigint:e=>"bigint"==typeof e,function:e=>"function"==typeof e,boolean:e=>"boolean"==typeof e,string:e=>"string"==typeof e,stringOrUint8Array:e=>"string"==typeof e||(0,n.isBytes)(e),isSafeInteger:e=>Number.isSafeInteger(e),array:e=>Array.isArray(e),field:(e,t)=>t.Fp.isValid(e),hash:e=>"function"==typeof e&&Number.isSafeInteger(e.outputLen)};t.notImplemented=()=>{throw new Error("not implemented")}},9187:(e,t)=>{"use strict";function r(e){return e instanceof Uint8Array||ArrayBuffer.isView(e)&&"Uint8Array"===e.constructor.name}function n(e,...t){if(!r(e))throw new Error("Uint8Array expected");if(t.length>0&&!t.includes(e.length))throw new Error("Uint8Array expected of length "+t+", got length="+e.length)}function o(e,t){return!!Array.isArray(t)&&(0===t.length||(e?t.every(e=>"string"==typeof e):t.every(e=>Number.isSafeInteger(e))))}function i(e){if("function"!=typeof e)throw new Error("function expected");return!0}function a(e,t){if("string"!=typeof t)throw new Error(`${e}: string expected`);return!0}function s(e){if(!Number.isSafeInteger(e))throw new Error(`invalid integer: ${e}`)}function c(e){if(!Array.isArray(e))throw new Error("array expected")}function u(e,t){if(!o(!0,t))throw new Error(`${e}: array of strings expected`)}function l(e,t){if(!o(!1,t))throw new Error(`${e}: array of numbers expected`)}function f(...e){const t=e=>e,r=(e,t)=>r=>e(t(r));return{encode:e.map(e=>e.encode).reduceRight(r,t),decode:e.map(e=>e.decode).reduce(r,t)}}function h(e){const t="string"==typeof e?e.split(""):e,r=t.length;u("alphabet",t);const n=new Map(t.map((e,t)=>[e,t]));return{encode:n=>(c(n),n.map(n=>{if(!Number.isSafeInteger(n)||n<0||n>=r)throw new Error(`alphabet.encode: digit index outside alphabet "${n}". Allowed: ${e}`);return t[n]})),decode:t=>(c(t),t.map(t=>{a("alphabet.decode",t);const r=n.get(t);if(void 0===r)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return r}))}}function d(e=""){return a("join",e),{encode:t=>(u("join.decode",t),t.join(e)),decode:t=>(a("join.decode",t),t.split(e))}}function p(e,t="="){return s(e),a("padding",t),{encode(r){for(u("padding.encode",r);r.length*e%8;)r.push(t);return r},decode(r){u("padding.decode",r);let n=r.length;if(n*e%8)throw new Error("padding: invalid, string should have whole number of bytes");for(;n>0&&r[n-1]===t;n--)if((n-1)*e%8==0)throw new Error("padding: invalid, string has too much padding");return r.slice(0,n)}}}function b(e){return i(e),{encode:e=>e,decode:t=>e(t)}}function g(e,t,r){if(t<2)throw new Error(`convertRadix: invalid from=${t}, base cannot be less than 2`);if(r<2)throw new Error(`convertRadix: invalid to=${r}, base cannot be less than 2`);if(c(e),!e.length)return[];let n=0;const o=[],i=Array.from(e,e=>{if(s(e),e<0||e>=t)throw new Error(`invalid integer: ${e}`);return e}),a=i.length;for(;;){let e=0,s=!0;for(let o=n;o<a;o++){const a=i[o],c=t*e,u=c+a;if(!Number.isSafeInteger(u)||c/t!==e||u-a!==c)throw new Error("convertRadix: carry overflow");const l=u/r;e=u%r;const f=Math.floor(l);if(i[o]=f,!Number.isSafeInteger(f)||f*r+e!==u)throw new Error("convertRadix: carry overflow");s&&(f?s=!1:n=o)}if(o.push(e),s)break}for(let t=0;t<e.length-1&&0===e[t];t++)o.push(0);return o.reverse()}Object.defineProperty(t,"__esModule",{value:!0}),t.bytes=t.stringToBytes=t.str=t.bytesToString=t.hex=t.utf8=t.bech32m=t.bech32=t.base58check=t.createBase58check=t.base58xmr=t.base58xrp=t.base58flickr=t.base58=t.base64urlnopad=t.base64url=t.base64nopad=t.base64=t.base32crockford=t.base32hexnopad=t.base32hex=t.base32nopad=t.base32=t.base16=t.utils=void 0;const y=(e,t)=>0===t?e:y(t,e%t),m=(e,t)=>e+(t-y(e,t)),v=(()=>{let e=[];for(let t=0;t<40;t++)e.push(2**t);return e})();function w(e,t,r,n){if(c(e),t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(r<=0||r>32)throw new Error(`convertRadix2: wrong to=${r}`);if(m(t,r)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${r} carryBits=${m(t,r)}`);let o=0,i=0;const a=v[t],u=v[r]-1,l=[];for(const n of e){if(s(n),n>=a)throw new Error(`convertRadix2: invalid data word=${n} from=${t}`);if(o=o<<t|n,i+t>32)throw new Error(`convertRadix2: carry overflow pos=${i} from=${t}`);for(i+=t;i>=r;i-=r)l.push((o>>i-r&u)>>>0);const e=v[i];if(void 0===e)throw new Error("invalid carry");o&=e-1}if(o=o<<r-i&u,!n&&i>=t)throw new Error("Excess padding");if(!n&&o>0)throw new Error(`Non-zero padding: ${o}`);return n&&i>0&&l.push(o>>>0),l}function _(e){return s(e),{encode:t=>{if(!r(t))throw new Error("radix.encode input should be Uint8Array");return g(Array.from(t),256,e)},decode:t=>(l("radix.decode",t),Uint8Array.from(g(t,e,256)))}}function S(e,t=!1){if(s(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(m(8,e)>32||m(e,8)>32)throw new Error("radix2: carry overflow");return{encode:n=>{if(!r(n))throw new Error("radix2.encode input should be Uint8Array");return w(Array.from(n),8,e,!t)},decode:r=>(l("radix2.decode",r),Uint8Array.from(w(r,e,8,t)))}}function E(e){return i(e),function(...t){try{return e.apply(null,t)}catch(e){}}}function k(e,t){return s(e),i(t),{encode(n){if(!r(n))throw new Error("checksum.encode: input should be Uint8Array");const o=t(n).slice(0,e),i=new Uint8Array(n.length+e);return i.set(n),i.set(o,n.length),i},decode(n){if(!r(n))throw new Error("checksum.decode: input should be Uint8Array");const o=n.slice(0,-e),i=n.slice(-e),a=t(o).slice(0,e);for(let t=0;t<e;t++)if(a[t]!==i[t])throw new Error("Invalid checksum");return o}}}t.utils={alphabet:h,chain:f,checksum:k,convertRadix:g,convertRadix2:w,radix:_,radix2:S,join:d,padding:p},t.base16=f(S(4),h("0123456789ABCDEF"),d("")),t.base32=f(S(5),h("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),p(5),d("")),t.base32nopad=f(S(5),h("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),d("")),t.base32hex=f(S(5),h("0123456789ABCDEFGHIJKLMNOPQRSTUV"),p(5),d("")),t.base32hexnopad=f(S(5),h("0123456789ABCDEFGHIJKLMNOPQRSTUV"),d("")),t.base32crockford=f(S(5),h("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),d(""),b(e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1")));const A=(()=>"function"==typeof Uint8Array.from([]).toBase64&&"function"==typeof Uint8Array.fromBase64)(),x=(e,t)=>{a("base64",e);const r=t?/^[A-Za-z0-9=_-]+$/:/^[A-Za-z0-9=+/]+$/,n=t?"base64url":"base64";if(e.length>0&&!r.test(e))throw new Error("invalid base64");return Uint8Array.fromBase64(e,{alphabet:n,lastChunkHandling:"strict"})};t.base64=A?{encode:e=>(n(e),e.toBase64()),decode:e=>x(e,!1)}:f(S(6),h("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),p(6),d("")),t.base64nopad=f(S(6),h("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),d("")),t.base64url=A?{encode:e=>(n(e),e.toBase64({alphabet:"base64url"})),decode:e=>x(e,!0)}:f(S(6),h("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),p(6),d("")),t.base64urlnopad=f(S(6),h("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),d(""));const I=e=>f(_(58),h(e),d(""));t.base58=I("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),t.base58flickr=I("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),t.base58xrp=I("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const B=[0,2,3,5,6,7,9,10,11];t.base58xmr={encode(e){let r="";for(let n=0;n<e.length;n+=8){const o=e.subarray(n,n+8);r+=t.base58.encode(o).padStart(B[o.length],"1")}return r},decode(e){let r=[];for(let n=0;n<e.length;n+=11){const o=e.slice(n,n+11),i=B.indexOf(o.length),a=t.base58.decode(o);for(let e=0;e<a.length-i;e++)if(0!==a[e])throw new Error("base58xmr: wrong padding");r=r.concat(Array.from(a.slice(a.length-i)))}return Uint8Array.from(r)}},t.createBase58check=e=>f(k(4,t=>e(e(t))),t.base58),t.base58check=t.createBase58check;const T=f(h("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),d("")),H=[996825010,642813549,513874426,1027748829,705979059];function O(e){const t=e>>25;let r=(33554431&e)<<5;for(let e=0;e<H.length;e++)1==(t>>e&1)&&(r^=H[e]);return r}function P(e,t,r=1){const n=e.length;let o=1;for(let t=0;t<n;t++){const r=e.charCodeAt(t);if(r<33||r>126)throw new Error(`Invalid prefix (${e})`);o=O(o)^r>>5}o=O(o);for(let t=0;t<n;t++)o=O(o)^31&e.charCodeAt(t);for(let e of t)o=O(o)^e;for(let e=0;e<6;e++)o=O(o);return o^=r,T.encode(w([o%v[30]],30,5,!1))}function L(e){const t="bech32"===e?1:734539939,n=S(5),o=n.decode,i=n.encode,s=E(o);function c(e,n,o=90){a("bech32.encode prefix",e),r(n)&&(n=Array.from(n)),l("bech32.encode",n);const i=e.length;if(0===i)throw new TypeError(`Invalid prefix length ${i}`);const s=i+7+n.length;if(!1!==o&&s>o)throw new TypeError(`Length ${s} exceeds limit ${o}`);const c=e.toLowerCase(),u=P(c,n,t);return`${c}1${T.encode(n)}${u}`}function u(e,r=90){a("bech32.decode input",e);const n=e.length;if(n<8||!1!==r&&n>r)throw new TypeError(`invalid string length: ${n} (${e}). Expected (8..${r})`);const o=e.toLowerCase();if(e!==o&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const i=o.lastIndexOf("1");if(0===i||-1===i)throw new Error('Letter "1" must be present between prefix and data only');const s=o.slice(0,i),c=o.slice(i+1);if(c.length<6)throw new Error("Data must be at least 6 characters long");const u=T.decode(c).slice(0,-6),l=P(s,u,t);if(!c.endsWith(l))throw new Error(`Invalid checksum in ${e}: expected "${l}"`);return{prefix:s,words:u}}return{encode:c,decode:u,encodeFromBytes:function(e,t){return c(e,i(t))},decodeToBytes:function(e){const{prefix:t,words:r}=u(e,!1);return{prefix:t,words:r,bytes:o(r)}},decodeUnsafe:E(u),fromWords:o,fromWordsUnsafe:s,toWords:i}}t.bech32=L("bech32"),t.bech32m=L("bech32m"),t.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)};const U=(()=>"function"==typeof Uint8Array.from([]).toHex&&"function"==typeof Uint8Array.fromHex)(),j={encode:e=>(n(e),e.toHex()),decode:e=>(a("hex",e),Uint8Array.fromHex(e))};t.hex=U?j:f(S(4),h("0123456789abcdef"),d(""),b(e=>{if("string"!=typeof e||e.length%2!=0)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()}));const C={utf8:t.utf8,hex:t.hex,base16:t.base16,base32:t.base32,base64:t.base64,base64url:t.base64url,base58:t.base58,base58xmr:t.base58xmr},R="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";t.bytesToString=(e,t)=>{if("string"!=typeof e||!C.hasOwnProperty(e))throw new TypeError(R);if(!r(t))throw new TypeError("bytesToString() expects Uint8Array");return C[e].encode(t)},t.str=t.bytesToString,t.stringToBytes=(e,t)=>{if(!C.hasOwnProperty(e))throw new TypeError(R);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return C[e].decode(t)},t.bytes=t.stringToBytes},8162:e=>{"use strict";e.exports=function(e){if(e.length>=255)throw new TypeError("Alphabet too long");for(var t=new Uint8Array(256),r=0;r<t.length;r++)t[r]=255;for(var n=0;n<e.length;n++){var o=e.charAt(n),i=o.charCodeAt(0);if(255!==t[i])throw new TypeError(o+" is ambiguous");t[i]=n}var a=e.length,s=e.charAt(0),c=Math.log(a)/Math.log(256),u=Math.log(256)/Math.log(a);function l(e){if("string"!=typeof e)throw new TypeError("Expected String");if(0===e.length)return new Uint8Array;for(var r=0,n=0,o=0;e[r]===s;)n++,r++;for(var i=(e.length-r)*c+1>>>0,u=new Uint8Array(i);e[r];){var l=e.charCodeAt(r);if(l>255)return;var f=t[l];if(255===f)return;for(var h=0,d=i-1;(0!==f||h<o)&&-1!==d;d--,h++)f+=a*u[d]>>>0,u[d]=f%256>>>0,f=f/256>>>0;if(0!==f)throw new Error("Non-zero carry");o=h,r++}for(var p=i-o;p!==i&&0===u[p];)p++;for(var b=new Uint8Array(n+(i-p)),g=n;p!==i;)b[g++]=u[p++];return b}return{encode:function(t){if(t instanceof Uint8Array||(ArrayBuffer.isView(t)?t=new Uint8Array(t.buffer,t.byteOffset,t.byteLength):Array.isArray(t)&&(t=Uint8Array.from(t))),!(t instanceof Uint8Array))throw new TypeError("Expected Uint8Array");if(0===t.length)return"";for(var r=0,n=0,o=0,i=t.length;o!==i&&0===t[o];)o++,r++;for(var c=(i-o)*u+1>>>0,l=new Uint8Array(c);o!==i;){for(var f=t[o],h=0,d=c-1;(0!==f||h<n)&&-1!==d;d--,h++)f+=256*l[d]>>>0,l[d]=f%a>>>0,f=f/a>>>0;if(0!==f)throw new Error("Non-zero carry");n=h,o++}for(var p=c-n;p!==c&&0===l[p];)p++;for(var b=s.repeat(r);p<c;++p)b+=e.charAt(l[p]);return b},decodeUnsafe:l,decode:function(e){var t=l(e);if(t)return t;throw new Error("Non-base"+a+" character")}}}},9742:(e,t)=>{"use strict";t.byteLength=function(e){var t=s(e),r=t[0],n=t[1];return 3*(r+n)/4-n},t.toByteArray=function(e){var t,r,i=s(e),a=i[0],c=i[1],u=new o(function(e,t,r){return 3*(t+r)/4-r}(0,a,c)),l=0,f=c>0?a-4:a;for(r=0;r<f;r+=4)t=n[e.charCodeAt(r)]<<18|n[e.charCodeAt(r+1)]<<12|n[e.charCodeAt(r+2)]<<6|n[e.charCodeAt(r+3)],u[l++]=t>>16&255,u[l++]=t>>8&255,u[l++]=255&t;return 2===c&&(t=n[e.charCodeAt(r)]<<2|n[e.charCodeAt(r+1)]>>4,u[l++]=255&t),1===c&&(t=n[e.charCodeAt(r)]<<10|n[e.charCodeAt(r+1)]<<4|n[e.charCodeAt(r+2)]>>2,u[l++]=t>>8&255,u[l++]=255&t),u},t.fromByteArray=function(e){for(var t,n=e.length,o=n%3,i=[],a=16383,s=0,c=n-o;s<c;s+=a)i.push(u(e,s,s+a>c?c:s+a));return 1===o?(t=e[n-1],i.push(r[t>>2]+r[t<<4&63]+"==")):2===o&&(t=(e[n-2]<<8)+e[n-1],i.push(r[t>>10]+r[t>>4&63]+r[t<<2&63]+"=")),i.join("")};for(var r=[],n=[],o="undefined"!=typeof Uint8Array?Uint8Array:Array,i="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",a=0;a<64;++a)r[a]=i[a],n[i.charCodeAt(a)]=a;function s(e){var t=e.length;if(t%4>0)throw new Error("Invalid string. Length must be a multiple of 4");var r=e.indexOf("=");return-1===r&&(r=t),[r,r===t?0:4-r%4]}function c(e){return r[e>>18&63]+r[e>>12&63]+r[e>>6&63]+r[63&e]}function u(e,t,r){for(var n,o=[],i=t;i<r;i+=3)n=(e[i]<<16&16711680)+(e[i+1]<<8&65280)+(255&e[i+2]),o.push(c(n));return o.join("")}n["-".charCodeAt(0)]=62,n["_".charCodeAt(0)]=63},7715:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.bech32m=t.bech32=void 0;const r="qpzry9x8gf2tvdw0s3jn54khce6mua7l",n={};for(let e=0;e<32;e++){const t=r.charAt(e);n[t]=e}function o(e){const t=e>>25;return(33554431&e)<<5^996825010&-(1&t)^642813549&-(t>>1&1)^513874426&-(t>>2&1)^1027748829&-(t>>3&1)^705979059&-(t>>4&1)}function i(e){let t=1;for(let r=0;r<e.length;++r){const n=e.charCodeAt(r);if(n<33||n>126)return"Invalid prefix ("+e+")";t=o(t)^n>>5}t=o(t);for(let r=0;r<e.length;++r){const n=e.charCodeAt(r);t=o(t)^31&n}return t}function a(e,t,r,n){let o=0,i=0;const a=(1<<r)-1,s=[];for(let n=0;n<e.length;++n)for(o=o<<t|e[n],i+=t;i>=r;)i-=r,s.push(o>>i&a);if(n)i>0&&s.push(o<<r-i&a);else{if(i>=t)return"Excess padding";if(o<<r-i&a)return"Non-zero padding"}return s}function s(e){return a(e,8,5,!0)}function c(e){const t=a(e,5,8,!1);if(Array.isArray(t))return t}function u(e){const t=a(e,5,8,!1);if(Array.isArray(t))return t;throw new Error(t)}function l(e){let t;function a(e,r){if(r=r||90,e.length<8)return e+" too short";if(e.length>r)return"Exceeds length limit";const a=e.toLowerCase(),s=e.toUpperCase();if(e!==a&&e!==s)return"Mixed-case string "+e;const c=(e=a).lastIndexOf("1");if(-1===c)return"No separator character for "+e;if(0===c)return"Missing prefix for "+e;const u=e.slice(0,c),l=e.slice(c+1);if(l.length<6)return"Data too short";let f=i(u);if("string"==typeof f)return f;const h=[];for(let e=0;e<l.length;++e){const t=l.charAt(e),r=n[t];if(void 0===r)return"Unknown character "+t;f=o(f)^r,e+6>=l.length||h.push(r)}return f!==t?"Invalid checksum for "+e:{prefix:u,words:h}}return t="bech32"===e?1:734539939,{decodeUnsafe:function(e,t){const r=a(e,t);if("object"==typeof r)return r},decode:function(e,t){const r=a(e,t);if("object"==typeof r)return r;throw new Error(r)},encode:function(e,n,a){if(a=a||90,e.length+7+n.length>a)throw new TypeError("Exceeds length limit");let s=i(e=e.toLowerCase());if("string"==typeof s)throw new Error(s);let c=e+"1";for(let e=0;e<n.length;++e){const t=n[e];if(t>>5)throw new Error("Non 5-bit word");s=o(s)^t,c+=r.charAt(t)}for(let e=0;e<6;++e)s=o(s);s^=t;for(let e=0;e<6;++e)c+=r.charAt(s>>5*(5-e)&31);return c},toWords:s,fromWordsUnsafe:c,fromWords:u}}t.bech32=l("bech32"),t.bech32m=l("bech32m")},2190:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const n=r(6574);function o(e,t,r){return n=>{if(e.has(n))return;const o=r.filter(e=>e.key.toString("hex")===n)[0];t.push(o),e.add(n)}}function i(e){return e.globalMap.unsignedTx}function a(e){const t=new Set;return e.forEach(e=>{const r=e.key.toString("hex");if(t.has(r))throw new Error("Combine: KeyValue Map keys should be unique");t.add(r)}),t}t.combine=function(e){const t=e[0],r=n.psbtToKeyVals(t),s=e.slice(1);if(0===s.length)throw new Error("Combine: Nothing to combine");const c=i(t);if(void 0===c)throw new Error("Combine: Self missing transaction");const u=a(r.globalKeyVals),l=r.inputKeyVals.map(a),f=r.outputKeyVals.map(a);for(const e of s){const t=i(e);if(void 0===t||!t.toBuffer().equals(c.toBuffer()))throw new Error("Combine: One of the Psbts does not have the same transaction.");const s=n.psbtToKeyVals(e);a(s.globalKeyVals).forEach(o(u,r.globalKeyVals,s.globalKeyVals)),s.inputKeyVals.map(a).forEach((e,t)=>e.forEach(o(l[t],r.inputKeyVals[t],s.inputKeyVals[t]))),s.outputKeyVals.map(a).forEach((e,t)=>e.forEach(o(f[t],r.outputKeyVals[t],s.outputKeyVals[t])))}return n.psbtFromKeyVals(c,{globalMapKeyVals:r.globalKeyVals,inputKeyVals:r.inputKeyVals,outputKeyVals:r.outputKeyVals})}},4041:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);t.decode=function(e){if(e.key[0]!==o.GlobalTypes.GLOBAL_XPUB)throw new Error("Decode Error: could not decode globalXpub with key 0x"+e.key.toString("hex"));if(79!==e.key.length||![2,3].includes(e.key[46]))throw new Error("Decode Error: globalXpub has invalid extended pubkey in key 0x"+e.key.toString("hex"));if(e.value.length/4%1!=0)throw new Error("Decode Error: Global GLOBAL_XPUB value length should be multiple of 4");const t=e.key.slice(1),r={masterFingerprint:e.value.slice(0,4),extendedPubkey:t,path:"m"};for(const t of(n=e.value.length/4-1,[...Array(n).keys()])){const n=e.value.readUInt32LE(4*t+4),o=!!(2147483648&n),i=2147483647&n;r.path+="/"+i.toString(10)+(o?"'":"")}var n;return r},t.encode=function(e){const t=n.from([o.GlobalTypes.GLOBAL_XPUB]),r=n.concat([t,e.extendedPubkey]),i=e.path.split("/"),a=n.allocUnsafe(4*i.length);e.masterFingerprint.copy(a,0);let s=4;return i.slice(1).forEach(e=>{const t="'"===e.slice(-1);let r=2147483647&parseInt(t?e.slice(0,-1):e,10);t&&(r+=2147483648),a.writeUInt32LE(r,s),s+=4}),{key:r,value:a}},t.expected="{ masterFingerprint: Buffer; extendedPubkey: Buffer; path: string; }",t.check=function(e){const t=e.extendedPubkey,r=e.masterFingerprint,o=e.path;return n.isBuffer(t)&&78===t.length&&[2,3].indexOf(t[45])>-1&&n.isBuffer(r)&&4===r.length&&"string"==typeof o&&!!o.match(/^m(\/\d+'?)*$/)},t.canAddToArray=function(e,t,r){const n=t.extendedPubkey.toString("hex");return!r.has(n)&&(r.add(n),0===e.filter(e=>e.extendedPubkey.equals(t.extendedPubkey)).length)}},4480:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);t.encode=function(e){return{key:n.from([o.GlobalTypes.UNSIGNED_TX]),value:e.toBuffer()}}},1528:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const n=r(1847),o=r(4041),i=r(4480),a=r(859),s=r(8248),c=r(537),u=r(1511),l=r(5896),f=r(1243),h=r(3530),d=r(9265),p=r(3934),b=r(602),g=r(2954),y=r(6036),m=r(4799),v=r(9595),w=r(9705),_=r(7196),S=r(9375),E=r(6327),k={unsignedTx:i,globalXpub:o,checkPubkey:v.makeChecker([])};t.globals=k;const A={nonWitnessUtxo:c,partialSig:u,sighashType:f,finalScriptSig:a,finalScriptWitness:s,porCommitment:l,witnessUtxo:g,bip32Derivation:m.makeConverter(n.InputTypes.BIP32_DERIVATION),redeemScript:w.makeConverter(n.InputTypes.REDEEM_SCRIPT),witnessScript:E.makeConverter(n.InputTypes.WITNESS_SCRIPT),checkPubkey:v.makeChecker([n.InputTypes.PARTIAL_SIG,n.InputTypes.BIP32_DERIVATION]),tapKeySig:h,tapScriptSig:b,tapLeafScript:d,tapBip32Derivation:_.makeConverter(n.InputTypes.TAP_BIP32_DERIVATION),tapInternalKey:S.makeConverter(n.InputTypes.TAP_INTERNAL_KEY),tapMerkleRoot:p};t.inputs=A;const x={bip32Derivation:m.makeConverter(n.OutputTypes.BIP32_DERIVATION),redeemScript:w.makeConverter(n.OutputTypes.REDEEM_SCRIPT),witnessScript:E.makeConverter(n.OutputTypes.WITNESS_SCRIPT),checkPubkey:v.makeChecker([n.OutputTypes.BIP32_DERIVATION]),tapBip32Derivation:_.makeConverter(n.OutputTypes.TAP_BIP32_DERIVATION),tapTree:y,tapInternalKey:S.makeConverter(n.OutputTypes.TAP_INTERNAL_KEY)};t.outputs=x},859:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);t.decode=function(e){if(e.key[0]!==o.InputTypes.FINAL_SCRIPTSIG)throw new Error("Decode Error: could not decode finalScriptSig with key 0x"+e.key.toString("hex"));return e.value},t.encode=function(e){return{key:n.from([o.InputTypes.FINAL_SCRIPTSIG]),value:e}},t.expected="Buffer",t.check=function(e){return n.isBuffer(e)},t.canAdd=function(e,t){return!!e&&!!t&&void 0===e.finalScriptSig}},8248:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);t.decode=function(e){if(e.key[0]!==o.InputTypes.FINAL_SCRIPTWITNESS)throw new Error("Decode Error: could not decode finalScriptWitness with key 0x"+e.key.toString("hex"));return e.value},t.encode=function(e){return{key:n.from([o.InputTypes.FINAL_SCRIPTWITNESS]),value:e}},t.expected="Buffer",t.check=function(e){return n.isBuffer(e)},t.canAdd=function(e,t){return!!e&&!!t&&void 0===e.finalScriptWitness}},537:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);t.decode=function(e){if(e.key[0]!==o.InputTypes.NON_WITNESS_UTXO)throw new Error("Decode Error: could not decode nonWitnessUtxo with key 0x"+e.key.toString("hex"));return e.value},t.encode=function(e){return{key:n.from([o.InputTypes.NON_WITNESS_UTXO]),value:e}},t.expected="Buffer",t.check=function(e){return n.isBuffer(e)},t.canAdd=function(e,t){return!!e&&!!t&&void 0===e.nonWitnessUtxo}},1511:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);t.decode=function(e){if(e.key[0]!==o.InputTypes.PARTIAL_SIG)throw new Error("Decode Error: could not decode partialSig with key 0x"+e.key.toString("hex"));if(34!==e.key.length&&66!==e.key.length||![2,3,4].includes(e.key[1]))throw new Error("Decode Error: partialSig has invalid pubkey in key 0x"+e.key.toString("hex"));return{pubkey:e.key.slice(1),signature:e.value}},t.encode=function(e){const t=n.from([o.InputTypes.PARTIAL_SIG]);return{key:n.concat([t,e.pubkey]),value:e.signature}},t.expected="{ pubkey: Buffer; signature: Buffer; }",t.check=function(e){return n.isBuffer(e.pubkey)&&n.isBuffer(e.signature)&&[33,65].includes(e.pubkey.length)&&[2,3,4].includes(e.pubkey[0])&&function(e){if(!n.isBuffer(e)||e.length<9)return!1;if(48!==e[0])return!1;if(e.length!==e[1]+3)return!1;if(2!==e[2])return!1;const t=e[3];if(t>33||t<1)return!1;if(2!==e[3+t+1])return!1;const r=e[3+t+2];return!(r>33||r<1)&&e.length===3+t+2+r+2}(e.signature)},t.canAddToArray=function(e,t,r){const n=t.pubkey.toString("hex");return!r.has(n)&&(r.add(n),0===e.filter(e=>e.pubkey.equals(t.pubkey)).length)}},5896:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);t.decode=function(e){if(e.key[0]!==o.InputTypes.POR_COMMITMENT)throw new Error("Decode Error: could not decode porCommitment with key 0x"+e.key.toString("hex"));return e.value.toString("utf8")},t.encode=function(e){return{key:n.from([o.InputTypes.POR_COMMITMENT]),value:n.from(e,"utf8")}},t.expected="string",t.check=function(e){return"string"==typeof e},t.canAdd=function(e,t){return!!e&&!!t&&void 0===e.porCommitment}},1243:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);t.decode=function(e){if(e.key[0]!==o.InputTypes.SIGHASH_TYPE)throw new Error("Decode Error: could not decode sighashType with key 0x"+e.key.toString("hex"));return e.value.readUInt32LE(0)},t.encode=function(e){const t=n.from([o.InputTypes.SIGHASH_TYPE]),r=n.allocUnsafe(4);return r.writeUInt32LE(e,0),{key:t,value:r}},t.expected="number",t.check=function(e){return"number"==typeof e},t.canAdd=function(e,t){return!!e&&!!t&&void 0===e.sighashType}},3530:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);function i(e){return n.isBuffer(e)&&(64===e.length||65===e.length)}t.decode=function(e){if(e.key[0]!==o.InputTypes.TAP_KEY_SIG||1!==e.key.length)throw new Error("Decode Error: could not decode tapKeySig with key 0x"+e.key.toString("hex"));if(!i(e.value))throw new Error("Decode Error: tapKeySig not a valid 64-65-byte BIP340 signature");return e.value},t.encode=function(e){return{key:n.from([o.InputTypes.TAP_KEY_SIG]),value:e}},t.expected="Buffer",t.check=i,t.canAdd=function(e,t){return!!e&&!!t&&void 0===e.tapKeySig}},9265:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);t.decode=function(e){if(e.key[0]!==o.InputTypes.TAP_LEAF_SCRIPT)throw new Error("Decode Error: could not decode tapLeafScript with key 0x"+e.key.toString("hex"));if((e.key.length-2)%32!=0)throw new Error("Decode Error: tapLeafScript has invalid control block in key 0x"+e.key.toString("hex"));const t=e.value[e.value.length-1];if((254&e.key[1])!==t)throw new Error("Decode Error: tapLeafScript bad leaf version in key 0x"+e.key.toString("hex"));const r=e.value.slice(0,-1);return{controlBlock:e.key.slice(1),script:r,leafVersion:t}},t.encode=function(e){const t=n.from([o.InputTypes.TAP_LEAF_SCRIPT]),r=n.from([e.leafVersion]);return{key:n.concat([t,e.controlBlock]),value:n.concat([e.script,r])}},t.expected="{ controlBlock: Buffer; leafVersion: number, script: Buffer; }",t.check=function(e){return n.isBuffer(e.controlBlock)&&(e.controlBlock.length-1)%32==0&&(254&e.controlBlock[0])===e.leafVersion&&n.isBuffer(e.script)},t.canAddToArray=function(e,t,r){const n=t.controlBlock.toString("hex");return!r.has(n)&&(r.add(n),0===e.filter(e=>e.controlBlock.equals(t.controlBlock)).length)}},3934:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);function i(e){return n.isBuffer(e)&&32===e.length}t.decode=function(e){if(e.key[0]!==o.InputTypes.TAP_MERKLE_ROOT||1!==e.key.length)throw new Error("Decode Error: could not decode tapMerkleRoot with key 0x"+e.key.toString("hex"));if(!i(e.value))throw new Error("Decode Error: tapMerkleRoot not a 32-byte hash");return e.value},t.encode=function(e){return{key:n.from([o.InputTypes.TAP_MERKLE_ROOT]),value:e}},t.expected="Buffer",t.check=i,t.canAdd=function(e,t){return!!e&&!!t&&void 0===e.tapMerkleRoot}},602:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847);t.decode=function(e){if(e.key[0]!==o.InputTypes.TAP_SCRIPT_SIG)throw new Error("Decode Error: could not decode tapScriptSig with key 0x"+e.key.toString("hex"));if(65!==e.key.length)throw new Error("Decode Error: tapScriptSig has invalid key 0x"+e.key.toString("hex"));if(64!==e.value.length&&65!==e.value.length)throw new Error("Decode Error: tapScriptSig has invalid signature in key 0x"+e.key.toString("hex"));return{pubkey:e.key.slice(1,33),leafHash:e.key.slice(33),signature:e.value}},t.encode=function(e){const t=n.from([o.InputTypes.TAP_SCRIPT_SIG]);return{key:n.concat([t,e.pubkey,e.leafHash]),value:e.signature}},t.expected="{ pubkey: Buffer; leafHash: Buffer; signature: Buffer; }",t.check=function(e){return n.isBuffer(e.pubkey)&&n.isBuffer(e.leafHash)&&n.isBuffer(e.signature)&&32===e.pubkey.length&&32===e.leafHash.length&&(64===e.signature.length||65===e.signature.length)},t.canAddToArray=function(e,t,r){const n=t.pubkey.toString("hex")+t.leafHash.toString("hex");return!r.has(n)&&(r.add(n),0===e.filter(e=>e.pubkey.equals(t.pubkey)&&e.leafHash.equals(t.leafHash)).length)}},2954:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847),i=r(9254),a=r(3493);t.decode=function(e){if(e.key[0]!==o.InputTypes.WITNESS_UTXO)throw new Error("Decode Error: could not decode witnessUtxo with key 0x"+e.key.toString("hex"));const t=i.readUInt64LE(e.value,0);let r=8;const n=a.decode(e.value,r);r+=a.encodingLength(n);const s=e.value.slice(r);if(s.length!==n)throw new Error("Decode Error: WITNESS_UTXO script is not proper length");return{script:s,value:t}},t.encode=function(e){const{script:t,value:r}=e,s=a.encodingLength(t.length),c=n.allocUnsafe(8+s+t.length);return i.writeUInt64LE(c,r,0),a.encode(t.length,c,8),t.copy(c,8+s),{key:n.from([o.InputTypes.WITNESS_UTXO]),value:c}},t.expected="{ script: Buffer; value: number; }",t.check=function(e){return n.isBuffer(e.script)&&"number"==typeof e.value},t.canAdd=function(e,t){return!!e&&!!t&&void 0===e.witnessUtxo}},6036:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1847),i=r(3493);t.decode=function(e){if(e.key[0]!==o.OutputTypes.TAP_TREE||1!==e.key.length)throw new Error("Decode Error: could not decode tapTree with key 0x"+e.key.toString("hex"));let t=0;const r=[];for(;t<e.value.length;){const n=e.value[t++],o=e.value[t++],a=i.decode(e.value,t);t+=i.encodingLength(a),r.push({depth:n,leafVersion:o,script:e.value.slice(t,t+a)}),t+=a}return{leaves:r}},t.encode=function(e){const t=n.from([o.OutputTypes.TAP_TREE]),r=[].concat(...e.leaves.map(e=>[n.of(e.depth,e.leafVersion),i.encode(e.script.length),e.script]));return{key:t,value:n.concat(r)}},t.expected="{ leaves: [{ depth: number; leafVersion: number, script: Buffer; }] }",t.check=function(e){return Array.isArray(e.leaves)&&e.leaves.every(e=>e.depth>=0&&e.depth<=128&&(254&e.leafVersion)===e.leafVersion&&n.isBuffer(e.script))},t.canAdd=function(e,t){return!!e&&!!t&&void 0===e.tapTree}},4799:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=e=>33===e.length&&[2,3].includes(e[0])||65===e.length&&4===e[0];t.makeConverter=function(e,t=o){return{decode:function(r){if(r.key[0]!==e)throw new Error("Decode Error: could not decode bip32Derivation with key 0x"+r.key.toString("hex"));const n=r.key.slice(1);if(!t(n))throw new Error("Decode Error: bip32Derivation has invalid pubkey in key 0x"+r.key.toString("hex"));if(r.value.length/4%1!=0)throw new Error("Decode Error: Input BIP32_DERIVATION value length should be multiple of 4");const o={masterFingerprint:r.value.slice(0,4),pubkey:n,path:"m"};for(const e of(i=r.value.length/4-1,[...Array(i).keys()])){const t=r.value.readUInt32LE(4*e+4),n=!!(2147483648&t),i=2147483647&t;o.path+="/"+i.toString(10)+(n?"'":"")}var i;return o},encode:function(t){const r=n.from([e]),o=n.concat([r,t.pubkey]),i=t.path.split("/"),a=n.allocUnsafe(4*i.length);t.masterFingerprint.copy(a,0);let s=4;return i.slice(1).forEach(e=>{const t="'"===e.slice(-1);let r=2147483647&parseInt(t?e.slice(0,-1):e,10);t&&(r+=2147483648),a.writeUInt32LE(r,s),s+=4}),{key:o,value:a}},check:function(e){return n.isBuffer(e.pubkey)&&n.isBuffer(e.masterFingerprint)&&"string"==typeof e.path&&t(e.pubkey)&&4===e.masterFingerprint.length},expected:"{ masterFingerprint: Buffer; pubkey: Buffer; path: string; }",canAddToArray:function(e,t,r){const n=t.pubkey.toString("hex");return!r.has(n)&&(r.add(n),0===e.filter(e=>e.pubkey.equals(t.pubkey)).length)}}}},9595:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.makeChecker=function(e){return function(t){let r;if(e.includes(t.key[0])&&(r=t.key.slice(1),33!==r.length&&65!==r.length||![2,3,4].includes(r[0])))throw new Error("Format Error: invalid pubkey in key 0x"+t.key.toString("hex"));return r}}},9705:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.makeConverter=function(e){return{decode:function(t){if(t.key[0]!==e)throw new Error("Decode Error: could not decode redeemScript with key 0x"+t.key.toString("hex"));return t.value},encode:function(t){return{key:n.from([e]),value:t}},check:function(e){return n.isBuffer(e)},expected:"Buffer",canAdd:function(e,t){return!!e&&!!t&&void 0===e.redeemScript}}}},7196:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(3493),i=r(4799),a=e=>32===e.length;t.makeConverter=function(e){const t=i.makeConverter(e,a);return{decode:function(e){const r=o.decode(e.value),n=o.encodingLength(r),i=t.decode({key:e.key,value:e.value.slice(n+32*r)}),a=new Array(r);for(let t=0,o=n;t<r;t++,o+=32)a[t]=e.value.slice(o,o+32);return Object.assign({},i,{leafHashes:a})},encode:function(e){const r=t.encode(e),i=o.encodingLength(e.leafHashes.length),a=n.allocUnsafe(i);o.encode(e.leafHashes.length,a);const s=n.concat([a,...e.leafHashes,r.value]);return Object.assign({},r,{value:s})},check:function(e){return Array.isArray(e.leafHashes)&&e.leafHashes.every(e=>n.isBuffer(e)&&32===e.length)&&t.check(e)},expected:"{ masterFingerprint: Buffer; pubkey: Buffer; path: string; leafHashes: Buffer[]; }",canAddToArray:t.canAddToArray}}},9375:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.makeConverter=function(e){return{decode:function(t){if(t.key[0]!==e||1!==t.key.length)throw new Error("Decode Error: could not decode tapInternalKey with key 0x"+t.key.toString("hex"));if(32!==t.value.length)throw new Error("Decode Error: tapInternalKey not a 32-byte x-only pubkey");return t.value},encode:function(t){return{key:n.from([e]),value:t}},check:function(e){return n.isBuffer(e)&&32===e.length},expected:"Buffer",canAdd:function(e,t){return!!e&&!!t&&void 0===e.tapInternalKey}}}},6327:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.makeConverter=function(e){return{decode:function(t){if(t.key[0]!==e)throw new Error("Decode Error: could not decode witnessScript with key 0x"+t.key.toString("hex"));return t.value},encode:function(t){return{key:n.from([e]),value:t}},check:function(e){return n.isBuffer(e)},expected:"Buffer",canAdd:function(e,t){return!!e&&!!t&&void 0===e.witnessScript}}}},9254:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(3493);function i(e){const t=e.key.length,r=e.value.length,i=o.encodingLength(t),a=o.encodingLength(r),s=n.allocUnsafe(i+t+a+r);return o.encode(t,s,0),e.key.copy(s,i),o.encode(r,s,i+t),e.value.copy(s,i+t+a),s}function a(e,t){if("number"!=typeof e)throw new Error("cannot write a non-number as a number");if(e<0)throw new Error("specified a negative value for writing an unsigned value");if(e>t)throw new Error("RangeError: value out of range");if(Math.floor(e)!==e)throw new Error("value has a fractional component")}t.range=e=>[...Array(e).keys()],t.reverseBuffer=function(e){if(e.length<1)return e;let t=e.length-1,r=0;for(let n=0;n<e.length/2;n++)r=e[n],e[n]=e[t],e[t]=r,t--;return e},t.keyValsToBuffer=function(e){const t=e.map(i);return t.push(n.from([0])),n.concat(t)},t.keyValToBuffer=i,t.readUInt64LE=function(e,t){const r=e.readUInt32LE(t);let n=e.readUInt32LE(t+4);return n*=4294967296,a(n+r,9007199254740991),n+r},t.writeUInt64LE=function(e,t,r){return a(t,9007199254740991),e.writeInt32LE(-1&t,r),e.writeUInt32LE(Math.floor(t/4294967296),r+4),r+8}},3493:(e,t,r)=>{"use strict";var n=r(8764).Buffer;function o(e){if(e<0||e>9007199254740991||e%1!=0)throw new RangeError("value out of range")}function i(e){return o(e),e<253?1:e<=65535?3:e<=4294967295?5:9}Object.defineProperty(t,"__esModule",{value:!0}),t.encode=function e(t,r,a){if(o(t),r||(r=n.allocUnsafe(i(t))),!n.isBuffer(r))throw new TypeError("buffer must be a Buffer instance");return a||(a=0),t<253?(r.writeUInt8(t,a),Object.assign(e,{bytes:1})):t<=65535?(r.writeUInt8(253,a),r.writeUInt16LE(t,a+1),Object.assign(e,{bytes:3})):t<=4294967295?(r.writeUInt8(254,a),r.writeUInt32LE(t,a+1),Object.assign(e,{bytes:5})):(r.writeUInt8(255,a),r.writeUInt32LE(t>>>0,a+1),r.writeUInt32LE(t/4294967296|0,a+5),Object.assign(e,{bytes:9})),r},t.decode=function e(t,r){if(!n.isBuffer(t))throw new TypeError("buffer must be a Buffer instance");r||(r=0);const i=t.readUInt8(r);if(i<253)return Object.assign(e,{bytes:1}),i;if(253===i)return Object.assign(e,{bytes:3}),t.readUInt16LE(r+1);if(254===i)return Object.assign(e,{bytes:5}),t.readUInt32LE(r+1);{Object.assign(e,{bytes:9});const n=t.readUInt32LE(r+1),i=4294967296*t.readUInt32LE(r+5)+n;return o(i),i}},t.encodingLength=i},2974:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1528),i=r(9254),a=r(3493),s=r(1847);function c(e,t,r){if(!t.equals(n.from([r])))throw new Error(`Format Error: Invalid ${e} key: ${t.toString("hex")}`)}function u(e,{globalMapKeyVals:t,inputKeyVals:r,outputKeyVals:n}){const a={unsignedTx:e};let u=0;for(const e of t)switch(e.key[0]){case s.GlobalTypes.UNSIGNED_TX:if(c("global",e.key,s.GlobalTypes.UNSIGNED_TX),u>0)throw new Error("Format Error: GlobalMap has multiple UNSIGNED_TX");u++;break;case s.GlobalTypes.GLOBAL_XPUB:void 0===a.globalXpub&&(a.globalXpub=[]),a.globalXpub.push(o.globals.globalXpub.decode(e));break;default:a.unknownKeyVals||(a.unknownKeyVals=[]),a.unknownKeyVals.push(e)}const l=r.length,f=n.length,h=[],d=[];for(const e of i.range(l)){const t={};for(const n of r[e])switch(o.inputs.checkPubkey(n),n.key[0]){case s.InputTypes.NON_WITNESS_UTXO:if(c("input",n.key,s.InputTypes.NON_WITNESS_UTXO),void 0!==t.nonWitnessUtxo)throw new Error("Format Error: Input has multiple NON_WITNESS_UTXO");t.nonWitnessUtxo=o.inputs.nonWitnessUtxo.decode(n);break;case s.InputTypes.WITNESS_UTXO:if(c("input",n.key,s.InputTypes.WITNESS_UTXO),void 0!==t.witnessUtxo)throw new Error("Format Error: Input has multiple WITNESS_UTXO");t.witnessUtxo=o.inputs.witnessUtxo.decode(n);break;case s.InputTypes.PARTIAL_SIG:void 0===t.partialSig&&(t.partialSig=[]),t.partialSig.push(o.inputs.partialSig.decode(n));break;case s.InputTypes.SIGHASH_TYPE:if(c("input",n.key,s.InputTypes.SIGHASH_TYPE),void 0!==t.sighashType)throw new Error("Format Error: Input has multiple SIGHASH_TYPE");t.sighashType=o.inputs.sighashType.decode(n);break;case s.InputTypes.REDEEM_SCRIPT:if(c("input",n.key,s.InputTypes.REDEEM_SCRIPT),void 0!==t.redeemScript)throw new Error("Format Error: Input has multiple REDEEM_SCRIPT");t.redeemScript=o.inputs.redeemScript.decode(n);break;case s.InputTypes.WITNESS_SCRIPT:if(c("input",n.key,s.InputTypes.WITNESS_SCRIPT),void 0!==t.witnessScript)throw new Error("Format Error: Input has multiple WITNESS_SCRIPT");t.witnessScript=o.inputs.witnessScript.decode(n);break;case s.InputTypes.BIP32_DERIVATION:void 0===t.bip32Derivation&&(t.bip32Derivation=[]),t.bip32Derivation.push(o.inputs.bip32Derivation.decode(n));break;case s.InputTypes.FINAL_SCRIPTSIG:c("input",n.key,s.InputTypes.FINAL_SCRIPTSIG),t.finalScriptSig=o.inputs.finalScriptSig.decode(n);break;case s.InputTypes.FINAL_SCRIPTWITNESS:c("input",n.key,s.InputTypes.FINAL_SCRIPTWITNESS),t.finalScriptWitness=o.inputs.finalScriptWitness.decode(n);break;case s.InputTypes.POR_COMMITMENT:c("input",n.key,s.InputTypes.POR_COMMITMENT),t.porCommitment=o.inputs.porCommitment.decode(n);break;case s.InputTypes.TAP_KEY_SIG:c("input",n.key,s.InputTypes.TAP_KEY_SIG),t.tapKeySig=o.inputs.tapKeySig.decode(n);break;case s.InputTypes.TAP_SCRIPT_SIG:void 0===t.tapScriptSig&&(t.tapScriptSig=[]),t.tapScriptSig.push(o.inputs.tapScriptSig.decode(n));break;case s.InputTypes.TAP_LEAF_SCRIPT:void 0===t.tapLeafScript&&(t.tapLeafScript=[]),t.tapLeafScript.push(o.inputs.tapLeafScript.decode(n));break;case s.InputTypes.TAP_BIP32_DERIVATION:void 0===t.tapBip32Derivation&&(t.tapBip32Derivation=[]),t.tapBip32Derivation.push(o.inputs.tapBip32Derivation.decode(n));break;case s.InputTypes.TAP_INTERNAL_KEY:c("input",n.key,s.InputTypes.TAP_INTERNAL_KEY),t.tapInternalKey=o.inputs.tapInternalKey.decode(n);break;case s.InputTypes.TAP_MERKLE_ROOT:c("input",n.key,s.InputTypes.TAP_MERKLE_ROOT),t.tapMerkleRoot=o.inputs.tapMerkleRoot.decode(n);break;default:t.unknownKeyVals||(t.unknownKeyVals=[]),t.unknownKeyVals.push(n)}h.push(t)}for(const e of i.range(f)){const t={};for(const r of n[e])switch(o.outputs.checkPubkey(r),r.key[0]){case s.OutputTypes.REDEEM_SCRIPT:if(c("output",r.key,s.OutputTypes.REDEEM_SCRIPT),void 0!==t.redeemScript)throw new Error("Format Error: Output has multiple REDEEM_SCRIPT");t.redeemScript=o.outputs.redeemScript.decode(r);break;case s.OutputTypes.WITNESS_SCRIPT:if(c("output",r.key,s.OutputTypes.WITNESS_SCRIPT),void 0!==t.witnessScript)throw new Error("Format Error: Output has multiple WITNESS_SCRIPT");t.witnessScript=o.outputs.witnessScript.decode(r);break;case s.OutputTypes.BIP32_DERIVATION:void 0===t.bip32Derivation&&(t.bip32Derivation=[]),t.bip32Derivation.push(o.outputs.bip32Derivation.decode(r));break;case s.OutputTypes.TAP_INTERNAL_KEY:c("output",r.key,s.OutputTypes.TAP_INTERNAL_KEY),t.tapInternalKey=o.outputs.tapInternalKey.decode(r);break;case s.OutputTypes.TAP_TREE:c("output",r.key,s.OutputTypes.TAP_TREE),t.tapTree=o.outputs.tapTree.decode(r);break;case s.OutputTypes.TAP_BIP32_DERIVATION:void 0===t.tapBip32Derivation&&(t.tapBip32Derivation=[]),t.tapBip32Derivation.push(o.outputs.tapBip32Derivation.decode(r));break;default:t.unknownKeyVals||(t.unknownKeyVals=[]),t.unknownKeyVals.push(r)}d.push(t)}return{globalMap:a,inputs:h,outputs:d}}t.psbtFromBuffer=function(e,t){let r=0;function n(){const t=a.decode(e,r);r+=a.encodingLength(t);const n=e.slice(r,r+t);return r+=t,n}function o(){return{key:n(),value:n()}}function c(){if(r>=e.length)throw new Error("Format Error: Unexpected End of PSBT");const t=0===e.readUInt8(r);return t&&r++,t}if(1886610036!==function(){const t=e.readUInt32BE(r);return r+=4,t}())throw new Error("Format Error: Invalid Magic Number");if(255!==function(){const t=e.readUInt8(r);return r+=1,t}())throw new Error("Format Error: Magic Number must be followed by 0xff separator");const l=[],f={};for(;!c();){const e=o(),t=e.key.toString("hex");if(f[t])throw new Error("Format Error: Keys must be unique for global keymap: key "+t);f[t]=1,l.push(e)}const h=l.filter(e=>e.key[0]===s.GlobalTypes.UNSIGNED_TX);if(1!==h.length)throw new Error("Format Error: Only one UNSIGNED_TX allowed");const d=t(h[0].value),{inputCount:p,outputCount:b}=d.getInputOutputCounts(),g=[],y=[];for(const e of i.range(p)){const t={},r=[];for(;!c();){const n=o(),i=n.key.toString("hex");if(t[i])throw new Error("Format Error: Keys must be unique for each input: input index "+e+" key "+i);t[i]=1,r.push(n)}g.push(r)}for(const e of i.range(b)){const t={},r=[];for(;!c();){const n=o(),i=n.key.toString("hex");if(t[i])throw new Error("Format Error: Keys must be unique for each output: output index "+e+" key "+i);t[i]=1,r.push(n)}y.push(r)}return u(d,{globalMapKeyVals:l,inputKeyVals:g,outputKeyVals:y})},t.checkKeyBuffer=c,t.psbtFromKeyVals=u},6574:(e,t,r)=>{"use strict";function n(e){for(var r in e)t.hasOwnProperty(r)||(t[r]=e[r])}Object.defineProperty(t,"__esModule",{value:!0}),n(r(2974)),n(r(5312))},5312:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1528),i=r(9254);t.psbtToBuffer=function({globalMap:e,inputs:t,outputs:r}){const{globalKeyVals:o,inputKeyVals:a,outputKeyVals:s}=c({globalMap:e,inputs:t,outputs:r}),u=i.keyValsToBuffer(o),l=e=>0===e.length?[n.from([0])]:e.map(i.keyValsToBuffer),f=l(a),h=l(s),d=n.allocUnsafe(5);return d.writeUIntBE(482972169471,0,5),n.concat([d,u].concat(f,h))};const a=(e,t)=>e.key.compare(t.key);function s(e,t){const r=new Set,n=Object.entries(e).reduce((e,[n,o])=>{if("unknownKeyVals"===n)return e;const i=t[n];if(void 0===i)return e;const a=(Array.isArray(o)?o:[o]).map(i.encode);return a.map(e=>e.key.toString("hex")).forEach(e=>{if(r.has(e))throw new Error("Serialize Error: Duplicate key: "+e);r.add(e)}),e.concat(a)},[]),o=e.unknownKeyVals?e.unknownKeyVals.filter(e=>!r.has(e.key.toString("hex"))):[];return n.concat(o).sort(a)}function c({globalMap:e,inputs:t,outputs:r}){return{globalKeyVals:s(e,o.globals),inputKeyVals:t.map(e=>s(e,o.inputs)),outputKeyVals:r.map(e=>s(e,o.outputs))}}t.psbtToKeyVals=c},5011:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(2190),i=r(6574),a=r(1847),s=r(6403);t.Psbt=class{constructor(e){this.inputs=[],this.outputs=[],this.globalMap={unsignedTx:e}}static fromBase64(e,t){const r=n.from(e,"base64");return this.fromBuffer(r,t)}static fromHex(e,t){const r=n.from(e,"hex");return this.fromBuffer(r,t)}static fromBuffer(e,t){const r=i.psbtFromBuffer(e,t),n=new this(r.globalMap.unsignedTx);return Object.assign(n,r),n}toBase64(){return this.toBuffer().toString("base64")}toHex(){return this.toBuffer().toString("hex")}toBuffer(){return i.psbtToBuffer(this)}updateGlobal(e){return s.updateGlobal(e,this.globalMap),this}updateInput(e,t){const r=s.checkForInput(this.inputs,e);return s.updateInput(t,r),this}updateOutput(e,t){const r=s.checkForOutput(this.outputs,e);return s.updateOutput(t,r),this}addUnknownKeyValToGlobal(e){return s.checkHasKey(e,this.globalMap.unknownKeyVals,s.getEnumLength(a.GlobalTypes)),this.globalMap.unknownKeyVals||(this.globalMap.unknownKeyVals=[]),this.globalMap.unknownKeyVals.push(e),this}addUnknownKeyValToInput(e,t){const r=s.checkForInput(this.inputs,e);return s.checkHasKey(t,r.unknownKeyVals,s.getEnumLength(a.InputTypes)),r.unknownKeyVals||(r.unknownKeyVals=[]),r.unknownKeyVals.push(t),this}addUnknownKeyValToOutput(e,t){const r=s.checkForOutput(this.outputs,e);return s.checkHasKey(t,r.unknownKeyVals,s.getEnumLength(a.OutputTypes)),r.unknownKeyVals||(r.unknownKeyVals=[]),r.unknownKeyVals.push(t),this}addInput(e){this.globalMap.unsignedTx.addInput(e),this.inputs.push({unknownKeyVals:[]});const t=e.unknownKeyVals||[],r=this.inputs.length-1;if(!Array.isArray(t))throw new Error("unknownKeyVals must be an Array");return t.forEach(e=>this.addUnknownKeyValToInput(r,e)),s.addInputAttributes(this.inputs,e),this}addOutput(e){this.globalMap.unsignedTx.addOutput(e),this.outputs.push({unknownKeyVals:[]});const t=e.unknownKeyVals||[],r=this.outputs.length-1;if(!Array.isArray(t))throw new Error("unknownKeyVals must be an Array");return t.forEach(e=>this.addUnknownKeyValToOutput(r,e)),s.addOutputAttributes(this.outputs,e),this}clearFinalizedInput(e){const t=s.checkForInput(this.inputs,e);s.inputCheckUncleanFinalized(e,t);for(const e of Object.keys(t))["witnessUtxo","nonWitnessUtxo","finalScriptSig","finalScriptWitness","unknownKeyVals"].includes(e)||delete t[e];return this}combine(...e){const t=o.combine([this].concat(e));return Object.assign(this,t),this}getTransaction(){return this.globalMap.unsignedTx.toBuffer()}}},1847:(e,t)=>{"use strict";var r,n,o;Object.defineProperty(t,"__esModule",{value:!0}),(o=t.GlobalTypes||(t.GlobalTypes={}))[o.UNSIGNED_TX=0]="UNSIGNED_TX",o[o.GLOBAL_XPUB=1]="GLOBAL_XPUB",t.GLOBAL_TYPE_NAMES=["unsignedTx","globalXpub"],(n=t.InputTypes||(t.InputTypes={}))[n.NON_WITNESS_UTXO=0]="NON_WITNESS_UTXO",n[n.WITNESS_UTXO=1]="WITNESS_UTXO",n[n.PARTIAL_SIG=2]="PARTIAL_SIG",n[n.SIGHASH_TYPE=3]="SIGHASH_TYPE",n[n.REDEEM_SCRIPT=4]="REDEEM_SCRIPT",n[n.WITNESS_SCRIPT=5]="WITNESS_SCRIPT",n[n.BIP32_DERIVATION=6]="BIP32_DERIVATION",n[n.FINAL_SCRIPTSIG=7]="FINAL_SCRIPTSIG",n[n.FINAL_SCRIPTWITNESS=8]="FINAL_SCRIPTWITNESS",n[n.POR_COMMITMENT=9]="POR_COMMITMENT",n[n.TAP_KEY_SIG=19]="TAP_KEY_SIG",n[n.TAP_SCRIPT_SIG=20]="TAP_SCRIPT_SIG",n[n.TAP_LEAF_SCRIPT=21]="TAP_LEAF_SCRIPT",n[n.TAP_BIP32_DERIVATION=22]="TAP_BIP32_DERIVATION",n[n.TAP_INTERNAL_KEY=23]="TAP_INTERNAL_KEY",n[n.TAP_MERKLE_ROOT=24]="TAP_MERKLE_ROOT",t.INPUT_TYPE_NAMES=["nonWitnessUtxo","witnessUtxo","partialSig","sighashType","redeemScript","witnessScript","bip32Derivation","finalScriptSig","finalScriptWitness","porCommitment","tapKeySig","tapScriptSig","tapLeafScript","tapBip32Derivation","tapInternalKey","tapMerkleRoot"],(r=t.OutputTypes||(t.OutputTypes={}))[r.REDEEM_SCRIPT=0]="REDEEM_SCRIPT",r[r.WITNESS_SCRIPT=1]="WITNESS_SCRIPT",r[r.BIP32_DERIVATION=2]="BIP32_DERIVATION",r[r.TAP_INTERNAL_KEY=5]="TAP_INTERNAL_KEY",r[r.TAP_TREE=6]="TAP_TREE",r[r.TAP_BIP32_DERIVATION=7]="TAP_BIP32_DERIVATION",t.OUTPUT_TYPE_NAMES=["redeemScript","witnessScript","bip32Derivation","tapInternalKey","tapTree","tapBip32Derivation"]},6403:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(1528);function i(e,t){const r=e[t];if(void 0===r)throw new Error(`No input #${t}`);return r}function a(e,t){const r=e[t];if(void 0===r)throw new Error(`No output #${t}`);return r}function s(e,t,r,n){throw new Error(`Data for ${e} key ${t} is incorrect: Expected ${r} and got ${JSON.stringify(n)}`)}function c(e){return(t,r)=>{for(const n of Object.keys(t)){const i=t[n],{canAdd:a,canAddToArray:c,check:u,expected:l}=o[e+"s"][n]||{};if(u)if(c){if(!Array.isArray(i)||r[n]&&!Array.isArray(r[n]))throw new Error(`Key type ${n} must be an array`);i.every(u)||s(e,n,l,i);const t=r[n]||[],o=new Set;if(!i.every(e=>c(t,e,o)))throw new Error("Can not add duplicate data to array");r[n]=t.concat(i)}else{if(u(i)||s(e,n,l,i),!a(r,i))throw new Error(`Can not add duplicate data to ${e}`);r[n]=i}}}}t.checkForInput=i,t.checkForOutput=a,t.checkHasKey=function(e,t,r){if(e.key[0]<r)throw new Error("Use the method for your specific key instead of addUnknownKeyVal*");if(t&&0!==t.filter(t=>t.key.equals(e.key)).length)throw new Error(`Duplicate Key: ${e.key.toString("hex")}`)},t.getEnumLength=function(e){let t=0;return Object.keys(e).forEach(e=>{Number(isNaN(Number(e)))&&t++}),t},t.inputCheckUncleanFinalized=function(e,t){let r=!1;if(t.nonWitnessUtxo||t.witnessUtxo){const e=!!t.redeemScript,n=!!t.witnessScript,o=!e||!!t.finalScriptSig,i=!n||!!t.finalScriptWitness,a=!!t.finalScriptSig||!!t.finalScriptWitness;r=o&&i&&a}if(!1===r)throw new Error(`Input #${e} has too much or too little data to clean`)},t.updateGlobal=c("global"),t.updateInput=c("input"),t.updateOutput=c("output"),t.addInputAttributes=function(e,r){const n=i(e,e.length-1);t.updateInput(r,n)},t.addOutputAttributes=function(e,r){const n=a(e,e.length-1);t.updateOutput(r,n)},t.defaultVersionSetter=function(e,t){if(!n.isBuffer(t)||t.length<4)throw new Error("Set Version: Invalid Transaction");return t.writeUInt32LE(e,0),t},t.defaultLocktimeSetter=function(e,t){if(!n.isBuffer(t)||t.length<4)throw new Error("Set Locktime: Invalid Transaction");return t.writeUInt32LE(e,t.length-4),t}},2666:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SHA512_IV=t.SHA384_IV=t.SHA224_IV=t.SHA256_IV=t.HashMD=void 0,t.setBigUint64=o,t.Chi=function(e,t,r){return e&t^~e&r},t.Maj=function(e,t,r){return e&t^e&r^t&r};const n=r(2423);function o(e,t,r,n){if("function"==typeof e.setBigUint64)return e.setBigUint64(t,r,n);const o=BigInt(32),i=BigInt(4294967295),a=Number(r>>o&i),s=Number(r&i),c=n?4:0,u=n?0:4;e.setUint32(t+c,a,n),e.setUint32(t+u,s,n)}class i extends n.Hash{constructor(e,t,r,o){super(),this.finished=!1,this.length=0,this.pos=0,this.destroyed=!1,this.blockLen=e,this.outputLen=t,this.padOffset=r,this.isLE=o,this.buffer=new Uint8Array(e),this.view=(0,n.createView)(this.buffer)}update(e){(0,n.aexists)(this),e=(0,n.toBytes)(e),(0,n.abytes)(e);const{view:t,buffer:r,blockLen:o}=this,i=e.length;for(let a=0;a<i;){const s=Math.min(o-this.pos,i-a);if(s===o){const t=(0,n.createView)(e);for(;o<=i-a;a+=o)this.process(t,a);continue}r.set(e.subarray(a,a+s),this.pos),this.pos+=s,a+=s,this.pos===o&&(this.process(t,0),this.pos=0)}return this.length+=e.length,this.roundClean(),this}digestInto(e){(0,n.aexists)(this),(0,n.aoutput)(e,this),this.finished=!0;const{buffer:t,view:r,blockLen:i,isLE:a}=this;let{pos:s}=this;t[s++]=128,(0,n.clean)(this.buffer.subarray(s)),this.padOffset>i-s&&(this.process(r,0),s=0);for(let e=s;e<i;e++)t[e]=0;o(r,i-8,BigInt(8*this.length),a),this.process(r,0);const c=(0,n.createView)(e),u=this.outputLen;if(u%4)throw new Error("_sha2: outputLen should be aligned to 32bit");const l=u/4,f=this.get();if(l>f.length)throw new Error("_sha2: outputLen bigger than state");for(let e=0;e<l;e++)c.setUint32(4*e,f[e],a)}digest(){const{buffer:e,outputLen:t}=this;this.digestInto(e);const r=e.slice(0,t);return this.destroy(),r}_cloneInto(e){e||(e=new this.constructor),e.set(...this.get());const{blockLen:t,buffer:r,length:n,finished:o,destroyed:i,pos:a}=this;return e.destroyed=i,e.finished=o,e.length=n,e.pos=a,n%t&&e.buffer.set(r),e}clone(){return this._cloneInto()}}t.HashMD=i,t.SHA256_IV=Uint32Array.from([1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225]),t.SHA224_IV=Uint32Array.from([3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428]),t.SHA384_IV=Uint32Array.from([3418070365,3238371032,1654270250,914150663,2438529370,812702999,355462360,4144912697,1731405415,4290775857,2394180231,1750603025,3675008525,1694076839,1203062813,3204075428]),t.SHA512_IV=Uint32Array.from([1779033703,4089235720,3144134277,2227873595,1013904242,4271175723,2773480762,1595750129,1359893119,2917565137,2600822924,725511199,528734635,4215389547,1541459225,327033209])},8831:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.toBig=t.shrSL=t.shrSH=t.rotrSL=t.rotrSH=t.rotrBL=t.rotrBH=t.rotr32L=t.rotr32H=t.rotlSL=t.rotlSH=t.rotlBL=t.rotlBH=t.add5L=t.add5H=t.add4L=t.add4H=t.add3L=t.add3H=void 0,t.add=v,t.fromBig=o,t.split=i;const r=BigInt(2**32-1),n=BigInt(32);function o(e,t=!1){return t?{h:Number(e&r),l:Number(e>>n&r)}:{h:0|Number(e>>n&r),l:0|Number(e&r)}}function i(e,t=!1){const r=e.length;let n=new Uint32Array(r),i=new Uint32Array(r);for(let a=0;a<r;a++){const{h:r,l:s}=o(e[a],t);[n[a],i[a]]=[r,s]}return[n,i]}const a=(e,t)=>BigInt(e>>>0)<<n|BigInt(t>>>0);t.toBig=a;const s=(e,t,r)=>e>>>r;t.shrSH=s;const c=(e,t,r)=>e<<32-r|t>>>r;t.shrSL=c;const u=(e,t,r)=>e>>>r|t<<32-r;t.rotrSH=u;const l=(e,t,r)=>e<<32-r|t>>>r;t.rotrSL=l;const f=(e,t,r)=>e<<64-r|t>>>r-32;t.rotrBH=f;const h=(e,t,r)=>e>>>r-32|t<<64-r;t.rotrBL=h;const d=(e,t)=>t;t.rotr32H=d;const p=(e,t)=>e;t.rotr32L=p;const b=(e,t,r)=>e<<r|t>>>32-r;t.rotlSH=b;const g=(e,t,r)=>t<<r|e>>>32-r;t.rotlSL=g;const y=(e,t,r)=>t<<r-32|e>>>64-r;t.rotlBH=y;const m=(e,t,r)=>e<<r-32|t>>>64-r;function v(e,t,r,n){const o=(t>>>0)+(n>>>0);return{h:e+r+(o/2**32|0)|0,l:0|o}}t.rotlBL=m;const w=(e,t,r)=>(e>>>0)+(t>>>0)+(r>>>0);t.add3L=w;const _=(e,t,r,n)=>t+r+n+(e/2**32|0)|0;t.add3H=_;const S=(e,t,r,n)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0);t.add4L=S;const E=(e,t,r,n,o)=>t+r+n+o+(e/2**32|0)|0;t.add4H=E;const k=(e,t,r,n,o)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0)+(o>>>0);t.add5L=k;const A=(e,t,r,n,o,i)=>t+r+n+o+i+(e/2**32|0)|0;t.add5H=A;const x={fromBig:o,split:i,toBig:a,shrSH:s,shrSL:c,rotrSH:u,rotrSL:l,rotrBH:f,rotrBL:h,rotr32H:d,rotr32L:p,rotlSH:b,rotlSL:g,rotlBH:y,rotlBL:m,add:v,add3L:w,add3H:_,add4L:S,add4H:E,add5H:A,add5L:k};t.default=x},1137:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.crypto=void 0,t.crypto="object"==typeof globalThis&&"crypto"in globalThis?globalThis.crypto:void 0},6810:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.hmac=t.HMAC=void 0;const n=r(2423);class o extends n.Hash{constructor(e,t){super(),this.finished=!1,this.destroyed=!1,(0,n.ahash)(e);const r=(0,n.toBytes)(t);if(this.iHash=e.create(),"function"!=typeof this.iHash.update)throw new Error("Expected instance of class which extends utils.Hash");this.blockLen=this.iHash.blockLen,this.outputLen=this.iHash.outputLen;const o=this.blockLen,i=new Uint8Array(o);i.set(r.length>o?e.create().update(r).digest():r);for(let e=0;e<i.length;e++)i[e]^=54;this.iHash.update(i),this.oHash=e.create();for(let e=0;e<i.length;e++)i[e]^=106;this.oHash.update(i),(0,n.clean)(i)}update(e){return(0,n.aexists)(this),this.iHash.update(e),this}digestInto(e){(0,n.aexists)(this),(0,n.abytes)(e,this.outputLen),this.finished=!0,this.iHash.digestInto(e),this.oHash.update(e),this.oHash.digestInto(e),this.destroy()}digest(){const e=new Uint8Array(this.oHash.outputLen);return this.digestInto(e),e}_cloneInto(e){e||(e=Object.create(Object.getPrototypeOf(this),{}));const{oHash:t,iHash:r,finished:n,destroyed:o,blockLen:i,outputLen:a}=this;return e.finished=n,e.destroyed=o,e.blockLen=i,e.outputLen=a,e.oHash=t._cloneInto(e.oHash),e.iHash=r._cloneInto(e.iHash),e}clone(){return this._cloneInto()}destroy(){this.destroyed=!0,this.oHash.destroy(),this.iHash.destroy()}}t.HMAC=o,t.hmac=(e,t,r)=>new o(e,t).update(r).digest(),t.hmac.create=(e,t)=>new o(e,t)},5348:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ripemd160=t.RIPEMD160=t.md5=t.MD5=t.sha1=t.SHA1=void 0;const n=r(2666),o=r(2423),i=Uint32Array.from([1732584193,4023233417,2562383102,271733878,3285377520]),a=new Uint32Array(80);class s extends n.HashMD{constructor(){super(64,20,8,!1),this.A=0|i[0],this.B=0|i[1],this.C=0|i[2],this.D=0|i[3],this.E=0|i[4]}get(){const{A:e,B:t,C:r,D:n,E:o}=this;return[e,t,r,n,o]}set(e,t,r,n,o){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n,this.E=0|o}process(e,t){for(let r=0;r<16;r++,t+=4)a[r]=e.getUint32(t,!1);for(let e=16;e<80;e++)a[e]=(0,o.rotl)(a[e-3]^a[e-8]^a[e-14]^a[e-16],1);let{A:r,B:i,C:s,D:c,E:u}=this;for(let e=0;e<80;e++){let t,l;e<20?(t=(0,n.Chi)(i,s,c),l=1518500249):e<40?(t=i^s^c,l=1859775393):e<60?(t=(0,n.Maj)(i,s,c),l=2400959708):(t=i^s^c,l=3395469782);const f=(0,o.rotl)(r,5)+t+u+l+a[e]|0;u=c,c=s,s=(0,o.rotl)(i,30),i=r,r=f}r=r+this.A|0,i=i+this.B|0,s=s+this.C|0,c=c+this.D|0,u=u+this.E|0,this.set(r,i,s,c,u)}roundClean(){(0,o.clean)(a)}destroy(){this.set(0,0,0,0,0),(0,o.clean)(this.buffer)}}t.SHA1=s,t.sha1=(0,o.createHasher)(()=>new s);const c=Math.pow(2,32),u=Array.from({length:64},(e,t)=>Math.floor(c*Math.abs(Math.sin(t+1)))),l=i.slice(0,4),f=new Uint32Array(16);class h extends n.HashMD{constructor(){super(64,16,8,!0),this.A=0|l[0],this.B=0|l[1],this.C=0|l[2],this.D=0|l[3]}get(){const{A:e,B:t,C:r,D:n}=this;return[e,t,r,n]}set(e,t,r,n){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n}process(e,t){for(let r=0;r<16;r++,t+=4)f[r]=e.getUint32(t,!0);let{A:r,B:i,C:a,D:s}=this;for(let e=0;e<64;e++){let t,c,l;e<16?(t=(0,n.Chi)(i,a,s),c=e,l=[7,12,17,22]):e<32?(t=(0,n.Chi)(s,i,a),c=(5*e+1)%16,l=[5,9,14,20]):e<48?(t=i^a^s,c=(3*e+5)%16,l=[4,11,16,23]):(t=a^(i|~s),c=7*e%16,l=[6,10,15,21]),t=t+r+u[e]+f[c],r=s,s=a,a=i,i+=(0,o.rotl)(t,l[e%4])}r=r+this.A|0,i=i+this.B|0,a=a+this.C|0,s=s+this.D|0,this.set(r,i,a,s)}roundClean(){(0,o.clean)(f)}destroy(){this.set(0,0,0,0),(0,o.clean)(this.buffer)}}t.MD5=h,t.md5=(0,o.createHasher)(()=>new h);const d=Uint8Array.from([7,4,13,1,10,6,15,3,12,0,9,5,2,14,11,8]),p=(()=>Uint8Array.from(new Array(16).fill(0).map((e,t)=>t)))(),b=(()=>p.map(e=>(9*e+5)%16))(),g=(()=>{const e=[[p],[b]];for(let t=0;t<4;t++)for(let r of e)r.push(r[t].map(e=>d[e]));return e})(),y=(()=>g[0])(),m=(()=>g[1])(),v=[[11,14,15,12,5,8,7,9,11,13,14,15,6,7,9,8],[12,13,11,15,6,9,9,7,12,15,11,13,7,8,7,7],[13,15,14,11,7,7,6,8,13,14,13,12,5,5,6,9],[14,11,12,14,8,6,5,5,15,12,15,14,9,9,8,6],[15,12,13,13,9,5,8,6,14,11,12,11,8,6,5,5]].map(e=>Uint8Array.from(e)),w=y.map((e,t)=>e.map(e=>v[t][e])),_=m.map((e,t)=>e.map(e=>v[t][e])),S=Uint32Array.from([0,1518500249,1859775393,2400959708,2840853838]),E=Uint32Array.from([1352829926,1548603684,1836072691,2053994217,0]);function k(e,t,r,n){return 0===e?t^r^n:1===e?t&r|~t&n:2===e?(t|~r)^n:3===e?t&n|r&~n:t^(r|~n)}const A=new Uint32Array(16);class x extends n.HashMD{constructor(){super(64,20,8,!0),this.h0=1732584193,this.h1=-271733879,this.h2=-1732584194,this.h3=271733878,this.h4=-1009589776}get(){const{h0:e,h1:t,h2:r,h3:n,h4:o}=this;return[e,t,r,n,o]}set(e,t,r,n,o){this.h0=0|e,this.h1=0|t,this.h2=0|r,this.h3=0|n,this.h4=0|o}process(e,t){for(let r=0;r<16;r++,t+=4)A[r]=e.getUint32(t,!0);let r=0|this.h0,n=r,i=0|this.h1,a=i,s=0|this.h2,c=s,u=0|this.h3,l=u,f=0|this.h4,h=f;for(let e=0;e<5;e++){const t=4-e,d=S[e],p=E[e],b=y[e],g=m[e],v=w[e],x=_[e];for(let t=0;t<16;t++){const n=(0,o.rotl)(r+k(e,i,s,u)+A[b[t]]+d,v[t])+f|0;r=f,f=u,u=0|(0,o.rotl)(s,10),s=i,i=n}for(let e=0;e<16;e++){const r=(0,o.rotl)(n+k(t,a,c,l)+A[g[e]]+p,x[e])+h|0;n=h,h=l,l=0|(0,o.rotl)(c,10),c=a,a=r}}this.set(this.h1+s+l|0,this.h2+u+h|0,this.h3+f+n|0,this.h4+r+a|0,this.h0+i+c|0)}roundClean(){(0,o.clean)(A)}destroy(){this.destroyed=!0,(0,o.clean)(this.buffer),this.set(0,0,0,0,0)}}t.RIPEMD160=x,t.ripemd160=(0,o.createHasher)(()=>new x)},1192:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ripemd160=t.RIPEMD160=void 0;const n=r(5348);t.RIPEMD160=n.RIPEMD160,t.ripemd160=n.ripemd160},4506:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha512_224=t.sha512_256=t.sha384=t.sha512=t.sha224=t.sha256=t.SHA512_256=t.SHA512_224=t.SHA384=t.SHA512=t.SHA224=t.SHA256=void 0;const n=r(2666),o=r(8831),i=r(2423),a=Uint32Array.from([1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298]),s=new Uint32Array(64);class c extends n.HashMD{constructor(e=32){super(64,e,8,!1),this.A=0|n.SHA256_IV[0],this.B=0|n.SHA256_IV[1],this.C=0|n.SHA256_IV[2],this.D=0|n.SHA256_IV[3],this.E=0|n.SHA256_IV[4],this.F=0|n.SHA256_IV[5],this.G=0|n.SHA256_IV[6],this.H=0|n.SHA256_IV[7]}get(){const{A:e,B:t,C:r,D:n,E:o,F:i,G:a,H:s}=this;return[e,t,r,n,o,i,a,s]}set(e,t,r,n,o,i,a,s){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n,this.E=0|o,this.F=0|i,this.G=0|a,this.H=0|s}process(e,t){for(let r=0;r<16;r++,t+=4)s[r]=e.getUint32(t,!1);for(let e=16;e<64;e++){const t=s[e-15],r=s[e-2],n=(0,i.rotr)(t,7)^(0,i.rotr)(t,18)^t>>>3,o=(0,i.rotr)(r,17)^(0,i.rotr)(r,19)^r>>>10;s[e]=o+s[e-7]+n+s[e-16]|0}let{A:r,B:o,C:c,D:u,E:l,F:f,G:h,H:d}=this;for(let e=0;e<64;e++){const t=d+((0,i.rotr)(l,6)^(0,i.rotr)(l,11)^(0,i.rotr)(l,25))+(0,n.Chi)(l,f,h)+a[e]+s[e]|0,p=((0,i.rotr)(r,2)^(0,i.rotr)(r,13)^(0,i.rotr)(r,22))+(0,n.Maj)(r,o,c)|0;d=h,h=f,f=l,l=u+t|0,u=c,c=o,o=r,r=t+p|0}r=r+this.A|0,o=o+this.B|0,c=c+this.C|0,u=u+this.D|0,l=l+this.E|0,f=f+this.F|0,h=h+this.G|0,d=d+this.H|0,this.set(r,o,c,u,l,f,h,d)}roundClean(){(0,i.clean)(s)}destroy(){this.set(0,0,0,0,0,0,0,0),(0,i.clean)(this.buffer)}}t.SHA256=c;class u extends c{constructor(){super(28),this.A=0|n.SHA224_IV[0],this.B=0|n.SHA224_IV[1],this.C=0|n.SHA224_IV[2],this.D=0|n.SHA224_IV[3],this.E=0|n.SHA224_IV[4],this.F=0|n.SHA224_IV[5],this.G=0|n.SHA224_IV[6],this.H=0|n.SHA224_IV[7]}}t.SHA224=u;const l=(()=>o.split(["0x428a2f98d728ae22","0x7137449123ef65cd","0xb5c0fbcfec4d3b2f","0xe9b5dba58189dbbc","0x3956c25bf348b538","0x59f111f1b605d019","0x923f82a4af194f9b","0xab1c5ed5da6d8118","0xd807aa98a3030242","0x12835b0145706fbe","0x243185be4ee4b28c","0x550c7dc3d5ffb4e2","0x72be5d74f27b896f","0x80deb1fe3b1696b1","0x9bdc06a725c71235","0xc19bf174cf692694","0xe49b69c19ef14ad2","0xefbe4786384f25e3","0x0fc19dc68b8cd5b5","0x240ca1cc77ac9c65","0x2de92c6f592b0275","0x4a7484aa6ea6e483","0x5cb0a9dcbd41fbd4","0x76f988da831153b5","0x983e5152ee66dfab","0xa831c66d2db43210","0xb00327c898fb213f","0xbf597fc7beef0ee4","0xc6e00bf33da88fc2","0xd5a79147930aa725","0x06ca6351e003826f","0x142929670a0e6e70","0x27b70a8546d22ffc","0x2e1b21385c26c926","0x4d2c6dfc5ac42aed","0x53380d139d95b3df","0x650a73548baf63de","0x766a0abb3c77b2a8","0x81c2c92e47edaee6","0x92722c851482353b","0xa2bfe8a14cf10364","0xa81a664bbc423001","0xc24b8b70d0f89791","0xc76c51a30654be30","0xd192e819d6ef5218","0xd69906245565a910","0xf40e35855771202a","0x106aa07032bbd1b8","0x19a4c116b8d2d0c8","0x1e376c085141ab53","0x2748774cdf8eeb99","0x34b0bcb5e19b48a8","0x391c0cb3c5c95a63","0x4ed8aa4ae3418acb","0x5b9cca4f7763e373","0x682e6ff3d6b2b8a3","0x748f82ee5defb2fc","0x78a5636f43172f60","0x84c87814a1f0ab72","0x8cc702081a6439ec","0x90befffa23631e28","0xa4506cebde82bde9","0xbef9a3f7b2c67915","0xc67178f2e372532b","0xca273eceea26619c","0xd186b8c721c0c207","0xeada7dd6cde0eb1e","0xf57d4f7fee6ed178","0x06f067aa72176fba","0x0a637dc5a2c898a6","0x113f9804bef90dae","0x1b710b35131c471b","0x28db77f523047d84","0x32caab7b40c72493","0x3c9ebe0a15c9bebc","0x431d67c49c100d4c","0x4cc5d4becb3e42b6","0x597f299cfc657e2a","0x5fcb6fab3ad6faec","0x6c44198c4a475817"].map(e=>BigInt(e))))(),f=(()=>l[0])(),h=(()=>l[1])(),d=new Uint32Array(80),p=new Uint32Array(80);class b extends n.HashMD{constructor(e=64){super(128,e,16,!1),this.Ah=0|n.SHA512_IV[0],this.Al=0|n.SHA512_IV[1],this.Bh=0|n.SHA512_IV[2],this.Bl=0|n.SHA512_IV[3],this.Ch=0|n.SHA512_IV[4],this.Cl=0|n.SHA512_IV[5],this.Dh=0|n.SHA512_IV[6],this.Dl=0|n.SHA512_IV[7],this.Eh=0|n.SHA512_IV[8],this.El=0|n.SHA512_IV[9],this.Fh=0|n.SHA512_IV[10],this.Fl=0|n.SHA512_IV[11],this.Gh=0|n.SHA512_IV[12],this.Gl=0|n.SHA512_IV[13],this.Hh=0|n.SHA512_IV[14],this.Hl=0|n.SHA512_IV[15]}get(){const{Ah:e,Al:t,Bh:r,Bl:n,Ch:o,Cl:i,Dh:a,Dl:s,Eh:c,El:u,Fh:l,Fl:f,Gh:h,Gl:d,Hh:p,Hl:b}=this;return[e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b]}set(e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b){this.Ah=0|e,this.Al=0|t,this.Bh=0|r,this.Bl=0|n,this.Ch=0|o,this.Cl=0|i,this.Dh=0|a,this.Dl=0|s,this.Eh=0|c,this.El=0|u,this.Fh=0|l,this.Fl=0|f,this.Gh=0|h,this.Gl=0|d,this.Hh=0|p,this.Hl=0|b}process(e,t){for(let r=0;r<16;r++,t+=4)d[r]=e.getUint32(t),p[r]=e.getUint32(t+=4);for(let e=16;e<80;e++){const t=0|d[e-15],r=0|p[e-15],n=o.rotrSH(t,r,1)^o.rotrSH(t,r,8)^o.shrSH(t,r,7),i=o.rotrSL(t,r,1)^o.rotrSL(t,r,8)^o.shrSL(t,r,7),a=0|d[e-2],s=0|p[e-2],c=o.rotrSH(a,s,19)^o.rotrBH(a,s,61)^o.shrSH(a,s,6),u=o.rotrSL(a,s,19)^o.rotrBL(a,s,61)^o.shrSL(a,s,6),l=o.add4L(i,u,p[e-7],p[e-16]),f=o.add4H(l,n,c,d[e-7],d[e-16]);d[e]=0|f,p[e]=0|l}let{Ah:r,Al:n,Bh:i,Bl:a,Ch:s,Cl:c,Dh:u,Dl:l,Eh:b,El:g,Fh:y,Fl:m,Gh:v,Gl:w,Hh:_,Hl:S}=this;for(let e=0;e<80;e++){const t=o.rotrSH(b,g,14)^o.rotrSH(b,g,18)^o.rotrBH(b,g,41),E=o.rotrSL(b,g,14)^o.rotrSL(b,g,18)^o.rotrBL(b,g,41),k=b&y^~b&v,A=g&m^~g&w,x=o.add5L(S,E,A,h[e],p[e]),I=o.add5H(x,_,t,k,f[e],d[e]),B=0|x,T=o.rotrSH(r,n,28)^o.rotrBH(r,n,34)^o.rotrBH(r,n,39),H=o.rotrSL(r,n,28)^o.rotrBL(r,n,34)^o.rotrBL(r,n,39),O=r&i^r&s^i&s,P=n&a^n&c^a&c;_=0|v,S=0|w,v=0|y,w=0|m,y=0|b,m=0|g,({h:b,l:g}=o.add(0|u,0|l,0|I,0|B)),u=0|s,l=0|c,s=0|i,c=0|a,i=0|r,a=0|n;const L=o.add3L(B,H,P);r=o.add3H(L,I,T,O),n=0|L}({h:r,l:n}=o.add(0|this.Ah,0|this.Al,0|r,0|n)),({h:i,l:a}=o.add(0|this.Bh,0|this.Bl,0|i,0|a)),({h:s,l:c}=o.add(0|this.Ch,0|this.Cl,0|s,0|c)),({h:u,l}=o.add(0|this.Dh,0|this.Dl,0|u,0|l)),({h:b,l:g}=o.add(0|this.Eh,0|this.El,0|b,0|g)),({h:y,l:m}=o.add(0|this.Fh,0|this.Fl,0|y,0|m)),({h:v,l:w}=o.add(0|this.Gh,0|this.Gl,0|v,0|w)),({h:_,l:S}=o.add(0|this.Hh,0|this.Hl,0|_,0|S)),this.set(r,n,i,a,s,c,u,l,b,g,y,m,v,w,_,S)}roundClean(){(0,i.clean)(d,p)}destroy(){(0,i.clean)(this.buffer),this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)}}t.SHA512=b;class g extends b{constructor(){super(48),this.Ah=0|n.SHA384_IV[0],this.Al=0|n.SHA384_IV[1],this.Bh=0|n.SHA384_IV[2],this.Bl=0|n.SHA384_IV[3],this.Ch=0|n.SHA384_IV[4],this.Cl=0|n.SHA384_IV[5],this.Dh=0|n.SHA384_IV[6],this.Dl=0|n.SHA384_IV[7],this.Eh=0|n.SHA384_IV[8],this.El=0|n.SHA384_IV[9],this.Fh=0|n.SHA384_IV[10],this.Fl=0|n.SHA384_IV[11],this.Gh=0|n.SHA384_IV[12],this.Gl=0|n.SHA384_IV[13],this.Hh=0|n.SHA384_IV[14],this.Hl=0|n.SHA384_IV[15]}}t.SHA384=g;const y=Uint32Array.from([2352822216,424955298,1944164710,2312950998,502970286,855612546,1738396948,1479516111,258812777,2077511080,2011393907,79989058,1067287976,1780299464,286451373,2446758561]),m=Uint32Array.from([573645204,4230739756,2673172387,3360449730,596883563,1867755857,2520282905,1497426621,2519219938,2827943907,3193839141,1401305490,721525244,746961066,246885852,2177182882]);class v extends b{constructor(){super(28),this.Ah=0|y[0],this.Al=0|y[1],this.Bh=0|y[2],this.Bl=0|y[3],this.Ch=0|y[4],this.Cl=0|y[5],this.Dh=0|y[6],this.Dl=0|y[7],this.Eh=0|y[8],this.El=0|y[9],this.Fh=0|y[10],this.Fl=0|y[11],this.Gh=0|y[12],this.Gl=0|y[13],this.Hh=0|y[14],this.Hl=0|y[15]}}t.SHA512_224=v;class w extends b{constructor(){super(32),this.Ah=0|m[0],this.Al=0|m[1],this.Bh=0|m[2],this.Bl=0|m[3],this.Ch=0|m[4],this.Cl=0|m[5],this.Dh=0|m[6],this.Dl=0|m[7],this.Eh=0|m[8],this.El=0|m[9],this.Fh=0|m[10],this.Fl=0|m[11],this.Gh=0|m[12],this.Gl=0|m[13],this.Hh=0|m[14],this.Hl=0|m[15]}}t.SHA512_256=w,t.sha256=(0,i.createHasher)(()=>new c),t.sha224=(0,i.createHasher)(()=>new u),t.sha512=(0,i.createHasher)(()=>new b),t.sha384=(0,i.createHasher)(()=>new g),t.sha512_256=(0,i.createHasher)(()=>new w),t.sha512_224=(0,i.createHasher)(()=>new v)},6594:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha224=t.SHA224=t.sha256=t.SHA256=void 0;const n=r(4506);t.SHA256=n.SHA256,t.sha256=n.sha256,t.SHA224=n.SHA224,t.sha224=n.sha224},362:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha512_256=t.SHA512_256=t.sha512_224=t.SHA512_224=t.sha384=t.SHA384=t.sha512=t.SHA512=void 0;const n=r(4506);t.SHA512=n.SHA512,t.sha512=n.sha512,t.SHA384=n.SHA384,t.sha384=n.sha384,t.SHA512_224=n.SHA512_224,t.sha512_224=n.sha512_224,t.SHA512_256=n.SHA512_256,t.sha512_256=n.sha512_256},2423:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.wrapXOFConstructorWithOpts=t.wrapConstructorWithOpts=t.wrapConstructor=t.Hash=t.nextTick=t.swap32IfBE=t.byteSwapIfBE=t.swap8IfBE=t.isLE=void 0,t.isBytes=o,t.anumber=i,t.abytes=a,t.ahash=function(e){if("function"!=typeof e||"function"!=typeof e.create)throw new Error("Hash should be wrapped by utils.createHasher");i(e.outputLen),i(e.blockLen)},t.aexists=function(e,t=!0){if(e.destroyed)throw new Error("Hash instance has been destroyed");if(t&&e.finished)throw new Error("Hash#digest() has already been called")},t.aoutput=function(e,t){a(e);const r=t.outputLen;if(e.length<r)throw new Error("digestInto() expects output buffer of length at least "+r)},t.u8=function(e){return new Uint8Array(e.buffer,e.byteOffset,e.byteLength)},t.u32=function(e){return new Uint32Array(e.buffer,e.byteOffset,Math.floor(e.byteLength/4))},t.clean=function(...e){for(let t=0;t<e.length;t++)e[t].fill(0)},t.createView=function(e){return new DataView(e.buffer,e.byteOffset,e.byteLength)},t.rotr=function(e,t){return e<<32-t|e>>>t},t.rotl=function(e,t){return e<<t|e>>>32-t>>>0},t.byteSwap=s,t.byteSwap32=c,t.bytesToHex=function(e){if(a(e),u)return e.toHex();let t="";for(let r=0;r<e.length;r++)t+=l[e[r]];return t},t.hexToBytes=function(e){if("string"!=typeof e)throw new Error("hex string expected, got "+typeof e);if(u)return Uint8Array.fromHex(e);const t=e.length,r=t/2;if(t%2)throw new Error("hex string expected, got unpadded hex of length "+t);const n=new Uint8Array(r);for(let t=0,o=0;t<r;t++,o+=2){const r=h(e.charCodeAt(o)),i=h(e.charCodeAt(o+1));if(void 0===r||void 0===i){const t=e[o]+e[o+1];throw new Error('hex string expected, got non-hex character "'+t+'" at index '+o)}n[t]=16*r+i}return n},t.asyncLoop=async function(e,r,n){let o=Date.now();for(let i=0;i<e;i++){n(i);const e=Date.now()-o;e>=0&&e<r||(await(0,t.nextTick)(),o+=e)}},t.utf8ToBytes=d,t.bytesToUtf8=function(e){return(new TextDecoder).decode(e)},t.toBytes=p,t.kdfInputToBytes=function(e){return"string"==typeof e&&(e=d(e)),a(e),e},t.concatBytes=function(...e){let t=0;for(let r=0;r<e.length;r++){const n=e[r];a(n),t+=n.length}const r=new Uint8Array(t);for(let t=0,n=0;t<e.length;t++){const o=e[t];r.set(o,n),n+=o.length}return r},t.checkOpts=function(e,t){if(void 0!==t&&"[object Object]"!=={}.toString.call(t))throw new Error("options should be object or undefined");return Object.assign(e,t)},t.createHasher=b,t.createOptHasher=g,t.createXOFer=y,t.randomBytes=function(e=32){if(n.crypto&&"function"==typeof n.crypto.getRandomValues)return n.crypto.getRandomValues(new Uint8Array(e));if(n.crypto&&"function"==typeof n.crypto.randomBytes)return Uint8Array.from(n.crypto.randomBytes(e));throw new Error("crypto.getRandomValues must be defined")};const n=r(1137);function o(e){return e instanceof Uint8Array||ArrayBuffer.isView(e)&&"Uint8Array"===e.constructor.name}function i(e){if(!Number.isSafeInteger(e)||e<0)throw new Error("positive integer expected, got "+e)}function a(e,...t){if(!o(e))throw new Error("Uint8Array expected");if(t.length>0&&!t.includes(e.length))throw new Error("Uint8Array expected of length "+t+", got length="+e.length)}function s(e){return e<<24&4278190080|e<<8&16711680|e>>>8&65280|e>>>24&255}function c(e){for(let t=0;t<e.length;t++)e[t]=s(e[t]);return e}t.isLE=68===new Uint8Array(new Uint32Array([287454020]).buffer)[0],t.swap8IfBE=t.isLE?e=>e:e=>s(e),t.byteSwapIfBE=t.swap8IfBE,t.swap32IfBE=t.isLE?e=>e:c;const u=(()=>"function"==typeof Uint8Array.from([]).toHex&&"function"==typeof Uint8Array.fromHex)(),l=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0")),f={_0:48,_9:57,A:65,F:70,a:97,f:102};function h(e){return e>=f._0&&e<=f._9?e-f._0:e>=f.A&&e<=f.F?e-(f.A-10):e>=f.a&&e<=f.f?e-(f.a-10):void 0}function d(e){if("string"!=typeof e)throw new Error("string expected");return new Uint8Array((new TextEncoder).encode(e))}function p(e){return"string"==typeof e&&(e=d(e)),a(e),e}function b(e){const t=t=>e().update(p(t)).digest(),r=e();return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=()=>e(),t}function g(e){const t=(t,r)=>e(r).update(p(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t}function y(e){const t=(t,r)=>e(r).update(p(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t}t.nextTick=async()=>{},t.Hash=class{},t.wrapConstructor=b,t.wrapConstructorWithOpts=g,t.wrapXOFConstructorWithOpts=y},4090:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.BIP32Factory=void 0;const o=r(6903),i=r(2871),a=r(9187),s=r(6594),c=r(2401),u=r(7174),l=(0,a.base58check)(s.sha256);t.BIP32Factory=function(e){(0,i.testEcc)(e);const t=c.BufferN(32),r=c.compile({wif:c.UInt8,bip32:{public:c.UInt32,private:c.UInt32}}),a={messagePrefix:"Bitcoin Signed Message:\n",bech32:"bc",bip32:{public:76067358,private:76066276},pubKeyHash:0,scriptHash:5,wif:128},s=2147483648,f=Math.pow(2,31)-1;function h(e){return c.String(e)&&null!==e.match(/^(m\/)?(\d+'?\/)*\d+'?$/)}function d(e){return c.UInt32(e)&&e<=f}class p{constructor(e,t){this.__D=e,this.__Q=t,this.lowR=!1}get publicKey(){return void 0===this.__Q&&(this.__Q=n.from(e.pointFromScalar(this.__D,!0))),this.__Q}get privateKey(){return this.__D}sign(t,r){if(!this.privateKey)throw new Error("Missing private key");if(void 0===r&&(r=this.lowR),!1===r)return n.from(e.sign(t,this.privateKey));{let r=n.from(e.sign(t,this.privateKey));const o=n.alloc(32,0);let i=0;for(;r[0]>127;)i++,o.writeUIntLE(i,0,6),r=n.from(e.sign(t,this.privateKey,o));return r}}signSchnorr(t){if(!this.privateKey)throw new Error("Missing private key");if(!e.signSchnorr)throw new Error("signSchnorr not supported by ecc library");return n.from(e.signSchnorr(t,this.privateKey))}verify(t,r){return e.verify(t,this.publicKey,r)}verifySchnorr(t,r){if(!e.verifySchnorr)throw new Error("verifySchnorr not supported by ecc library");return e.verifySchnorr(t,this.publicKey.subarray(1,33),r)}}class b extends p{constructor(e,t,n,o,i=0,a=0,s=0){super(e,t),this.chainCode=n,this.network=o,this.__DEPTH=i,this.__INDEX=a,this.__PARENT_FINGERPRINT=s,c(r,o)}get depth(){return this.__DEPTH}get index(){return this.__INDEX}get parentFingerprint(){return this.__PARENT_FINGERPRINT}get identifier(){return o.hash160(this.publicKey)}get fingerprint(){return this.identifier.slice(0,4)}get compressed(){return!0}isNeutered(){return void 0===this.__D}neutered(){return m(this.publicKey,this.chainCode,this.network,this.depth,this.index,this.parentFingerprint)}toBase58(){const e=this.network,t=this.isNeutered()?e.bip32.public:e.bip32.private,r=n.allocUnsafe(78);return r.writeUInt32BE(t,0),r.writeUInt8(this.depth,4),r.writeUInt32BE(this.parentFingerprint,5),r.writeUInt32BE(this.index,9),this.chainCode.copy(r,13),this.isNeutered()?this.publicKey.copy(r,45):(r.writeUInt8(0,45),this.privateKey.copy(r,46)),o=r,l.encode(Uint8Array.from(o));var o}toWIF(){if(!this.privateKey)throw new TypeError("Missing private key");return u.encode(this.network.wif,this.privateKey,!0)}derive(t){c(c.UInt32,t);const r=t>=s,i=n.allocUnsafe(37);if(r){if(this.isNeutered())throw new TypeError("Missing private key for hardened child key");i[0]=0,this.privateKey.copy(i,1),i.writeUInt32BE(t,33)}else this.publicKey.copy(i,0),i.writeUInt32BE(t,33);const a=o.hmacSHA512(this.chainCode,i),u=a.slice(0,32),l=a.slice(32);if(!e.isPrivate(u))return this.derive(t+1);let f;if(this.isNeutered()){const r=n.from(e.pointAddScalar(this.publicKey,u,!0));if(null===r)return this.derive(t+1);f=m(r,l,this.network,this.depth+1,t,this.fingerprint.readUInt32BE(0))}else{const r=n.from(e.privateAdd(this.privateKey,u));if(null==r)return this.derive(t+1);f=y(r,l,this.network,this.depth+1,t,this.fingerprint.readUInt32BE(0))}return f}deriveHardened(e){return c(d,e),this.derive(e+s)}derivePath(e){c(h,e);let t=e.split("/");if("m"===t[0]){if(this.parentFingerprint)throw new TypeError("Expected master, got child");t=t.slice(1)}return t.reduce((e,t)=>{let r;return"'"===t.slice(-1)?(r=parseInt(t.slice(0,-1),10),e.deriveHardened(r)):(r=parseInt(t,10),e.derive(r))},this)}tweak(e){return this.privateKey?this.tweakFromPrivateKey(e):this.tweakFromPublicKey(e)}tweakFromPublicKey(t){const r=32===(o=this.publicKey).length?o:o.slice(1,33);var o;if(!e.xOnlyPointAddTweak)throw new Error("xOnlyPointAddTweak not supported by ecc library");const i=e.xOnlyPointAddTweak(r,t);if(!i||null===i.xOnlyPubkey)throw new Error("Cannot tweak public key!");const a=n.from([0===i.parity?2:3]),s=n.concat([a,i.xOnlyPubkey]);return new p(void 0,s)}tweakFromPrivateKey(t){const r=3===this.publicKey[0]||4===this.publicKey[0]&&!(1&~this.publicKey[64]),o=(()=>{if(r){if(e.privateNegate)return e.privateNegate(this.privateKey);throw new Error("privateNegate not supported by ecc library")}return this.privateKey})(),i=e.privateAdd(o,t);if(!i)throw new Error("Invalid tweaked private key!");return new p(n.from(i),void 0)}}function g(e,t,r){return y(e,t,r)}function y(r,n,o,i,s,u){if(c({privateKey:t,chainCode:t},{privateKey:r,chainCode:n}),o=o||a,!e.isPrivate(r))throw new TypeError("Private key not in range [1, n)");return new b(r,void 0,n,o,i,s,u)}function m(r,n,o,i,s,u){if(c({publicKey:c.BufferN(33),chainCode:t},{publicKey:r,chainCode:n}),o=o||a,!e.isPoint(r))throw new TypeError("Point is not on the curve");return new b(void 0,r,n,o,i,s,u)}return{fromSeed:function(e,t){if(c(c.Buffer,e),e.length<16)throw new TypeError("Seed should be at least 128 bits");if(e.length>64)throw new TypeError("Seed should be at most 512 bits");t=t||a;const r=o.hmacSHA512(n.from("Bitcoin seed","utf8"),e);return g(r.slice(0,32),r.slice(32),t)},fromBase58:function(e,t){const r=(o=e,n.from(l.decode(o)));var o;if(78!==r.length)throw new TypeError("Invalid buffer length");t=t||a;const i=r.readUInt32BE(0);if(i!==t.bip32.private&&i!==t.bip32.public)throw new TypeError("Invalid network version");const s=r[4],c=r.readUInt32BE(5);if(0===s&&0!==c)throw new TypeError("Invalid parent fingerprint");const u=r.readUInt32BE(9);if(0===s&&0!==u)throw new TypeError("Invalid index");const f=r.slice(13,45);let h;if(i===t.bip32.private){if(0!==r.readUInt8(45))throw new TypeError("Invalid private key");h=y(r.slice(46,78),f,t,s,u,c)}else h=m(r.slice(45,78),f,t,s,u,c);return h},fromPublicKey:function(e,t,r){return m(e,t,r)},fromPrivateKey:g}}},6903:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.hmacSHA512=t.hash160=void 0;const o=r(6810),i=r(1192),a=r(6594),s=r(362);t.hash160=function(e){const t=(0,a.sha256)(Uint8Array.from(e));return n.from((0,i.ripemd160)(t))},t.hmacSHA512=function(e,t){return n.from((0,o.hmac)(s.sha512,e,t))}},7786:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.BIP32Factory=t.default=void 0;var n=r(4090);Object.defineProperty(t,"default",{enumerable:!0,get:function(){return n.BIP32Factory}}),Object.defineProperty(t,"BIP32Factory",{enumerable:!0,get:function(){return n.BIP32Factory}})},2871:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.testEcc=void 0;const o=e=>n.from(e,"hex");function i(e){if(!e)throw new Error("ecc library invalid")}t.testEcc=function(e){if(i(e.isPoint(o("0279be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798"))),i(!e.isPoint(o("030000000000000000000000000000000000000000000000000000000000000005"))),i(e.isPrivate(o("79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798"))),i(e.isPrivate(o("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364140"))),i(!e.isPrivate(o("0000000000000000000000000000000000000000000000000000000000000000"))),i(!e.isPrivate(o("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141"))),i(!e.isPrivate(o("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364142"))),i(n.from(e.pointFromScalar(o("b1121e4088a66a28f5b6b0f5844943ecd9f610196d7bb83b25214b60452c09af"))).equals(o("02b07ba9dca9523b7ef4bd97703d43d20399eb698e194704791a25ce77a400df99"))),e.xOnlyPointAddTweak){i(null===e.xOnlyPointAddTweak(o("79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798"),o("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364140")));let t=e.xOnlyPointAddTweak(o("1617d38ed8d8657da4d4761e8057bc396ea9e4b9d29776d4be096016dbd2509b"),o("a8397a935f0dfceba6ba9618f6451ef4d80637abf4e6af2669fbc9de6a8fd2ac"));i(n.from(t.xOnlyPubkey).equals(o("e478f99dab91052ab39a33ea35fd5e6e4933f4d28023cd597c9a1f6760346adf"))&&1===t.parity),t=e.xOnlyPointAddTweak(o("2c0b7cf95324a07d05398b240174dc0c2be444d96b159aa6c7f7b1e668680991"),o("823c3cd2142744b075a87eade7e1b8678ba308d566226a0056ca2b7a76f86b47"))}i(n.from(e.pointAddScalar(o("0379be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798"),o("0000000000000000000000000000000000000000000000000000000000000003"))).equals(o("02c6047f9441ed7d6d3045406e95c07cd85c778e4b8cef3ca7abac09b95c709ee5"))),i(n.from(e.privateAdd(o("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd036413e"),o("0000000000000000000000000000000000000000000000000000000000000002"))).equals(o("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364140"))),e.privateNegate&&(i(n.from(e.privateNegate(o("0000000000000000000000000000000000000000000000000000000000000001"))).equals(o("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364140"))),i(n.from(e.privateNegate(o("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd036413e"))).equals(o("0000000000000000000000000000000000000000000000000000000000000003"))),i(n.from(e.privateNegate(o("b1121e4088a66a28f5b6b0f5844943ecd9f610196d7bb83b25214b60452c09af"))).equals(o("4eede1bf775995d70a494f0a7bb6bc11e0b8cccd41cce8009ab1132c8b0a3792")))),i(n.from(e.sign(o("5e9f0a0d593efdcf78ac923bc3313e4e7d408d574354ee2b3288c0da9fbba6ed"),o("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364140"))).equals(o("54c4a33c6423d689378f160a7ff8b61330444abb58fb470f96ea16d99d4a2fed07082304410efa6b2943111b6a4e0aaa7b7db55a07e9861d1fb3cb1f421044a5"))),i(e.verify(o("5e9f0a0d593efdcf78ac923bc3313e4e7d408d574354ee2b3288c0da9fbba6ed"),o("0379be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798"),o("54c4a33c6423d689378f160a7ff8b61330444abb58fb470f96ea16d99d4a2fed07082304410efa6b2943111b6a4e0aaa7b7db55a07e9861d1fb3cb1f421044a5"))),e.signSchnorr&&i(n.from(e.signSchnorr(o("7e2d58d8b3bcdf1abadec7829054f90dda9805aab56c77333024b9d0a508b75c"),o("c90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b14e5c9"),o("c87aa53824b4d7ae2eb035a2b5bbbccc080e76cdc6d1692c4b0b62d798e6d906"))).equals(o("5831aaeed7b44bb74e5eab94ba9d4294c49bcf2a60728d8b4c200f50dd313c1bab745879a5ad954a72c45a91c3a51d3c7adea98d82f8481e0e1e03674a6f3fb7"))),e.verifySchnorr&&i(e.verifySchnorr(o("7e2d58d8b3bcdf1abadec7829054f90dda9805aab56c77333024b9d0a508b75c"),o("dd308afec5777e13121fa72b9cc1b7cc0139715309b086c960e18fd969774eb8"),o("5831aaeed7b44bb74e5eab94ba9d4294c49bcf2a60728d8b4c200f50dd313c1bab745879a5ad954a72c45a91c3a51d3c7adea98d82f8481e0e1e03674a6f3fb7")))}},5343:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SHA512_IV=t.SHA384_IV=t.SHA224_IV=t.SHA256_IV=t.HashMD=void 0,t.setBigUint64=o,t.Chi=function(e,t,r){return e&t^~e&r},t.Maj=function(e,t,r){return e&t^e&r^t&r};const n=r(8412);function o(e,t,r,n){if("function"==typeof e.setBigUint64)return e.setBigUint64(t,r,n);const o=BigInt(32),i=BigInt(4294967295),a=Number(r>>o&i),s=Number(r&i),c=n?4:0,u=n?0:4;e.setUint32(t+c,a,n),e.setUint32(t+u,s,n)}class i extends n.Hash{constructor(e,t,r,o){super(),this.finished=!1,this.length=0,this.pos=0,this.destroyed=!1,this.blockLen=e,this.outputLen=t,this.padOffset=r,this.isLE=o,this.buffer=new Uint8Array(e),this.view=(0,n.createView)(this.buffer)}update(e){(0,n.aexists)(this),e=(0,n.toBytes)(e),(0,n.abytes)(e);const{view:t,buffer:r,blockLen:o}=this,i=e.length;for(let a=0;a<i;){const s=Math.min(o-this.pos,i-a);if(s===o){const t=(0,n.createView)(e);for(;o<=i-a;a+=o)this.process(t,a);continue}r.set(e.subarray(a,a+s),this.pos),this.pos+=s,a+=s,this.pos===o&&(this.process(t,0),this.pos=0)}return this.length+=e.length,this.roundClean(),this}digestInto(e){(0,n.aexists)(this),(0,n.aoutput)(e,this),this.finished=!0;const{buffer:t,view:r,blockLen:i,isLE:a}=this;let{pos:s}=this;t[s++]=128,(0,n.clean)(this.buffer.subarray(s)),this.padOffset>i-s&&(this.process(r,0),s=0);for(let e=s;e<i;e++)t[e]=0;o(r,i-8,BigInt(8*this.length),a),this.process(r,0);const c=(0,n.createView)(e),u=this.outputLen;if(u%4)throw new Error("_sha2: outputLen should be aligned to 32bit");const l=u/4,f=this.get();if(l>f.length)throw new Error("_sha2: outputLen bigger than state");for(let e=0;e<l;e++)c.setUint32(4*e,f[e],a)}digest(){const{buffer:e,outputLen:t}=this;this.digestInto(e);const r=e.slice(0,t);return this.destroy(),r}_cloneInto(e){e||(e=new this.constructor),e.set(...this.get());const{blockLen:t,buffer:r,length:n,finished:o,destroyed:i,pos:a}=this;return e.destroyed=i,e.finished=o,e.length=n,e.pos=a,n%t&&e.buffer.set(r),e}clone(){return this._cloneInto()}}t.HashMD=i,t.SHA256_IV=Uint32Array.from([1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225]),t.SHA224_IV=Uint32Array.from([3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428]),t.SHA384_IV=Uint32Array.from([3418070365,3238371032,1654270250,914150663,2438529370,812702999,355462360,4144912697,1731405415,4290775857,2394180231,1750603025,3675008525,1694076839,1203062813,3204075428]),t.SHA512_IV=Uint32Array.from([1779033703,4089235720,3144134277,2227873595,1013904242,4271175723,2773480762,1595750129,1359893119,2917565137,2600822924,725511199,528734635,4215389547,1541459225,327033209])},1306:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.toBig=t.shrSL=t.shrSH=t.rotrSL=t.rotrSH=t.rotrBL=t.rotrBH=t.rotr32L=t.rotr32H=t.rotlSL=t.rotlSH=t.rotlBL=t.rotlBH=t.add5L=t.add5H=t.add4L=t.add4H=t.add3L=t.add3H=void 0,t.add=v,t.fromBig=o,t.split=i;const r=BigInt(2**32-1),n=BigInt(32);function o(e,t=!1){return t?{h:Number(e&r),l:Number(e>>n&r)}:{h:0|Number(e>>n&r),l:0|Number(e&r)}}function i(e,t=!1){const r=e.length;let n=new Uint32Array(r),i=new Uint32Array(r);for(let a=0;a<r;a++){const{h:r,l:s}=o(e[a],t);[n[a],i[a]]=[r,s]}return[n,i]}const a=(e,t)=>BigInt(e>>>0)<<n|BigInt(t>>>0);t.toBig=a;const s=(e,t,r)=>e>>>r;t.shrSH=s;const c=(e,t,r)=>e<<32-r|t>>>r;t.shrSL=c;const u=(e,t,r)=>e>>>r|t<<32-r;t.rotrSH=u;const l=(e,t,r)=>e<<32-r|t>>>r;t.rotrSL=l;const f=(e,t,r)=>e<<64-r|t>>>r-32;t.rotrBH=f;const h=(e,t,r)=>e>>>r-32|t<<64-r;t.rotrBL=h;const d=(e,t)=>t;t.rotr32H=d;const p=(e,t)=>e;t.rotr32L=p;const b=(e,t,r)=>e<<r|t>>>32-r;t.rotlSH=b;const g=(e,t,r)=>t<<r|e>>>32-r;t.rotlSL=g;const y=(e,t,r)=>t<<r-32|e>>>64-r;t.rotlBH=y;const m=(e,t,r)=>e<<r-32|t>>>64-r;function v(e,t,r,n){const o=(t>>>0)+(n>>>0);return{h:e+r+(o/2**32|0)|0,l:0|o}}t.rotlBL=m;const w=(e,t,r)=>(e>>>0)+(t>>>0)+(r>>>0);t.add3L=w;const _=(e,t,r,n)=>t+r+n+(e/2**32|0)|0;t.add3H=_;const S=(e,t,r,n)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0);t.add4L=S;const E=(e,t,r,n,o)=>t+r+n+o+(e/2**32|0)|0;t.add4H=E;const k=(e,t,r,n,o)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0)+(o>>>0);t.add5L=k;const A=(e,t,r,n,o,i)=>t+r+n+o+i+(e/2**32|0)|0;t.add5H=A;const x={fromBig:o,split:i,toBig:a,shrSH:s,shrSL:c,rotrSH:u,rotrSL:l,rotrBH:f,rotrBL:h,rotr32H:d,rotr32L:p,rotlSH:b,rotlSL:g,rotlBH:y,rotlBL:m,add:v,add3L:w,add3H:_,add4L:S,add4H:E,add5H:A,add5L:k};t.default=x},2174:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.crypto=void 0,t.crypto="object"==typeof globalThis&&"crypto"in globalThis?globalThis.crypto:void 0},4632:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.hmac=t.HMAC=void 0;const n=r(8412);class o extends n.Hash{constructor(e,t){super(),this.finished=!1,this.destroyed=!1,(0,n.ahash)(e);const r=(0,n.toBytes)(t);if(this.iHash=e.create(),"function"!=typeof this.iHash.update)throw new Error("Expected instance of class which extends utils.Hash");this.blockLen=this.iHash.blockLen,this.outputLen=this.iHash.outputLen;const o=this.blockLen,i=new Uint8Array(o);i.set(r.length>o?e.create().update(r).digest():r);for(let e=0;e<i.length;e++)i[e]^=54;this.iHash.update(i),this.oHash=e.create();for(let e=0;e<i.length;e++)i[e]^=106;this.oHash.update(i),(0,n.clean)(i)}update(e){return(0,n.aexists)(this),this.iHash.update(e),this}digestInto(e){(0,n.aexists)(this),(0,n.abytes)(e,this.outputLen),this.finished=!0,this.iHash.digestInto(e),this.oHash.update(e),this.oHash.digestInto(e),this.destroy()}digest(){const e=new Uint8Array(this.oHash.outputLen);return this.digestInto(e),e}_cloneInto(e){e||(e=Object.create(Object.getPrototypeOf(this),{}));const{oHash:t,iHash:r,finished:n,destroyed:o,blockLen:i,outputLen:a}=this;return e.finished=n,e.destroyed=o,e.blockLen=i,e.outputLen=a,e.oHash=t._cloneInto(e.oHash),e.iHash=r._cloneInto(e.iHash),e}clone(){return this._cloneInto()}destroy(){this.destroyed=!0,this.oHash.destroy(),this.iHash.destroy()}}t.HMAC=o,t.hmac=(e,t,r)=>new o(e,t).update(r).digest(),t.hmac.create=(e,t)=>new o(e,t)},8767:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.pbkdf2=function(e,t,r,n){const{c:s,dkLen:c,DK:u,PRF:l,PRFSalt:f}=i(e,t,r,n);let h;const d=new Uint8Array(4),p=(0,o.createView)(d),b=new Uint8Array(l.outputLen);for(let e=1,t=0;t<c;e++,t+=l.outputLen){const r=u.subarray(t,t+l.outputLen);p.setInt32(0,e,!1),(h=f._cloneInto(h)).update(d).digestInto(b),r.set(b.subarray(0,r.length));for(let e=1;e<s;e++){l._cloneInto(h).update(b).digestInto(b);for(let e=0;e<r.length;e++)r[e]^=b[e]}}return a(l,f,u,h,b)},t.pbkdf2Async=async function(e,t,r,n){const{c:s,dkLen:c,asyncTick:u,DK:l,PRF:f,PRFSalt:h}=i(e,t,r,n);let d;const p=new Uint8Array(4),b=(0,o.createView)(p),g=new Uint8Array(f.outputLen);for(let e=1,t=0;t<c;e++,t+=f.outputLen){const r=l.subarray(t,t+f.outputLen);b.setInt32(0,e,!1),(d=h._cloneInto(d)).update(p).digestInto(g),r.set(g.subarray(0,r.length)),await(0,o.asyncLoop)(s-1,u,()=>{f._cloneInto(d).update(g).digestInto(g);for(let e=0;e<r.length;e++)r[e]^=g[e]})}return a(f,h,l,d,g)};const n=r(4632),o=r(8412);function i(e,t,r,i){(0,o.ahash)(e);const a=(0,o.checkOpts)({dkLen:32,asyncTick:10},i),{c:s,dkLen:c,asyncTick:u}=a;if((0,o.anumber)(s),(0,o.anumber)(c),(0,o.anumber)(u),s<1)throw new Error("iterations (c) should be >= 1");const l=(0,o.kdfInputToBytes)(t),f=(0,o.kdfInputToBytes)(r),h=new Uint8Array(c),d=n.hmac.create(e,l),p=d._cloneInto().update(f);return{c:s,dkLen:c,asyncTick:u,DK:h,PRF:d,PRFSalt:p}}function a(e,t,r,n,i){return e.destroy(),t.destroy(),n&&n.destroy(),(0,o.clean)(i),r}},3428:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha512_224=t.sha512_256=t.sha384=t.sha512=t.sha224=t.sha256=t.SHA512_256=t.SHA512_224=t.SHA384=t.SHA512=t.SHA224=t.SHA256=void 0;const n=r(5343),o=r(1306),i=r(8412),a=Uint32Array.from([1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298]),s=new Uint32Array(64);class c extends n.HashMD{constructor(e=32){super(64,e,8,!1),this.A=0|n.SHA256_IV[0],this.B=0|n.SHA256_IV[1],this.C=0|n.SHA256_IV[2],this.D=0|n.SHA256_IV[3],this.E=0|n.SHA256_IV[4],this.F=0|n.SHA256_IV[5],this.G=0|n.SHA256_IV[6],this.H=0|n.SHA256_IV[7]}get(){const{A:e,B:t,C:r,D:n,E:o,F:i,G:a,H:s}=this;return[e,t,r,n,o,i,a,s]}set(e,t,r,n,o,i,a,s){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n,this.E=0|o,this.F=0|i,this.G=0|a,this.H=0|s}process(e,t){for(let r=0;r<16;r++,t+=4)s[r]=e.getUint32(t,!1);for(let e=16;e<64;e++){const t=s[e-15],r=s[e-2],n=(0,i.rotr)(t,7)^(0,i.rotr)(t,18)^t>>>3,o=(0,i.rotr)(r,17)^(0,i.rotr)(r,19)^r>>>10;s[e]=o+s[e-7]+n+s[e-16]|0}let{A:r,B:o,C:c,D:u,E:l,F:f,G:h,H:d}=this;for(let e=0;e<64;e++){const t=d+((0,i.rotr)(l,6)^(0,i.rotr)(l,11)^(0,i.rotr)(l,25))+(0,n.Chi)(l,f,h)+a[e]+s[e]|0,p=((0,i.rotr)(r,2)^(0,i.rotr)(r,13)^(0,i.rotr)(r,22))+(0,n.Maj)(r,o,c)|0;d=h,h=f,f=l,l=u+t|0,u=c,c=o,o=r,r=t+p|0}r=r+this.A|0,o=o+this.B|0,c=c+this.C|0,u=u+this.D|0,l=l+this.E|0,f=f+this.F|0,h=h+this.G|0,d=d+this.H|0,this.set(r,o,c,u,l,f,h,d)}roundClean(){(0,i.clean)(s)}destroy(){this.set(0,0,0,0,0,0,0,0),(0,i.clean)(this.buffer)}}t.SHA256=c;class u extends c{constructor(){super(28),this.A=0|n.SHA224_IV[0],this.B=0|n.SHA224_IV[1],this.C=0|n.SHA224_IV[2],this.D=0|n.SHA224_IV[3],this.E=0|n.SHA224_IV[4],this.F=0|n.SHA224_IV[5],this.G=0|n.SHA224_IV[6],this.H=0|n.SHA224_IV[7]}}t.SHA224=u;const l=(()=>o.split(["0x428a2f98d728ae22","0x7137449123ef65cd","0xb5c0fbcfec4d3b2f","0xe9b5dba58189dbbc","0x3956c25bf348b538","0x59f111f1b605d019","0x923f82a4af194f9b","0xab1c5ed5da6d8118","0xd807aa98a3030242","0x12835b0145706fbe","0x243185be4ee4b28c","0x550c7dc3d5ffb4e2","0x72be5d74f27b896f","0x80deb1fe3b1696b1","0x9bdc06a725c71235","0xc19bf174cf692694","0xe49b69c19ef14ad2","0xefbe4786384f25e3","0x0fc19dc68b8cd5b5","0x240ca1cc77ac9c65","0x2de92c6f592b0275","0x4a7484aa6ea6e483","0x5cb0a9dcbd41fbd4","0x76f988da831153b5","0x983e5152ee66dfab","0xa831c66d2db43210","0xb00327c898fb213f","0xbf597fc7beef0ee4","0xc6e00bf33da88fc2","0xd5a79147930aa725","0x06ca6351e003826f","0x142929670a0e6e70","0x27b70a8546d22ffc","0x2e1b21385c26c926","0x4d2c6dfc5ac42aed","0x53380d139d95b3df","0x650a73548baf63de","0x766a0abb3c77b2a8","0x81c2c92e47edaee6","0x92722c851482353b","0xa2bfe8a14cf10364","0xa81a664bbc423001","0xc24b8b70d0f89791","0xc76c51a30654be30","0xd192e819d6ef5218","0xd69906245565a910","0xf40e35855771202a","0x106aa07032bbd1b8","0x19a4c116b8d2d0c8","0x1e376c085141ab53","0x2748774cdf8eeb99","0x34b0bcb5e19b48a8","0x391c0cb3c5c95a63","0x4ed8aa4ae3418acb","0x5b9cca4f7763e373","0x682e6ff3d6b2b8a3","0x748f82ee5defb2fc","0x78a5636f43172f60","0x84c87814a1f0ab72","0x8cc702081a6439ec","0x90befffa23631e28","0xa4506cebde82bde9","0xbef9a3f7b2c67915","0xc67178f2e372532b","0xca273eceea26619c","0xd186b8c721c0c207","0xeada7dd6cde0eb1e","0xf57d4f7fee6ed178","0x06f067aa72176fba","0x0a637dc5a2c898a6","0x113f9804bef90dae","0x1b710b35131c471b","0x28db77f523047d84","0x32caab7b40c72493","0x3c9ebe0a15c9bebc","0x431d67c49c100d4c","0x4cc5d4becb3e42b6","0x597f299cfc657e2a","0x5fcb6fab3ad6faec","0x6c44198c4a475817"].map(e=>BigInt(e))))(),f=(()=>l[0])(),h=(()=>l[1])(),d=new Uint32Array(80),p=new Uint32Array(80);class b extends n.HashMD{constructor(e=64){super(128,e,16,!1),this.Ah=0|n.SHA512_IV[0],this.Al=0|n.SHA512_IV[1],this.Bh=0|n.SHA512_IV[2],this.Bl=0|n.SHA512_IV[3],this.Ch=0|n.SHA512_IV[4],this.Cl=0|n.SHA512_IV[5],this.Dh=0|n.SHA512_IV[6],this.Dl=0|n.SHA512_IV[7],this.Eh=0|n.SHA512_IV[8],this.El=0|n.SHA512_IV[9],this.Fh=0|n.SHA512_IV[10],this.Fl=0|n.SHA512_IV[11],this.Gh=0|n.SHA512_IV[12],this.Gl=0|n.SHA512_IV[13],this.Hh=0|n.SHA512_IV[14],this.Hl=0|n.SHA512_IV[15]}get(){const{Ah:e,Al:t,Bh:r,Bl:n,Ch:o,Cl:i,Dh:a,Dl:s,Eh:c,El:u,Fh:l,Fl:f,Gh:h,Gl:d,Hh:p,Hl:b}=this;return[e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b]}set(e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b){this.Ah=0|e,this.Al=0|t,this.Bh=0|r,this.Bl=0|n,this.Ch=0|o,this.Cl=0|i,this.Dh=0|a,this.Dl=0|s,this.Eh=0|c,this.El=0|u,this.Fh=0|l,this.Fl=0|f,this.Gh=0|h,this.Gl=0|d,this.Hh=0|p,this.Hl=0|b}process(e,t){for(let r=0;r<16;r++,t+=4)d[r]=e.getUint32(t),p[r]=e.getUint32(t+=4);for(let e=16;e<80;e++){const t=0|d[e-15],r=0|p[e-15],n=o.rotrSH(t,r,1)^o.rotrSH(t,r,8)^o.shrSH(t,r,7),i=o.rotrSL(t,r,1)^o.rotrSL(t,r,8)^o.shrSL(t,r,7),a=0|d[e-2],s=0|p[e-2],c=o.rotrSH(a,s,19)^o.rotrBH(a,s,61)^o.shrSH(a,s,6),u=o.rotrSL(a,s,19)^o.rotrBL(a,s,61)^o.shrSL(a,s,6),l=o.add4L(i,u,p[e-7],p[e-16]),f=o.add4H(l,n,c,d[e-7],d[e-16]);d[e]=0|f,p[e]=0|l}let{Ah:r,Al:n,Bh:i,Bl:a,Ch:s,Cl:c,Dh:u,Dl:l,Eh:b,El:g,Fh:y,Fl:m,Gh:v,Gl:w,Hh:_,Hl:S}=this;for(let e=0;e<80;e++){const t=o.rotrSH(b,g,14)^o.rotrSH(b,g,18)^o.rotrBH(b,g,41),E=o.rotrSL(b,g,14)^o.rotrSL(b,g,18)^o.rotrBL(b,g,41),k=b&y^~b&v,A=g&m^~g&w,x=o.add5L(S,E,A,h[e],p[e]),I=o.add5H(x,_,t,k,f[e],d[e]),B=0|x,T=o.rotrSH(r,n,28)^o.rotrBH(r,n,34)^o.rotrBH(r,n,39),H=o.rotrSL(r,n,28)^o.rotrBL(r,n,34)^o.rotrBL(r,n,39),O=r&i^r&s^i&s,P=n&a^n&c^a&c;_=0|v,S=0|w,v=0|y,w=0|m,y=0|b,m=0|g,({h:b,l:g}=o.add(0|u,0|l,0|I,0|B)),u=0|s,l=0|c,s=0|i,c=0|a,i=0|r,a=0|n;const L=o.add3L(B,H,P);r=o.add3H(L,I,T,O),n=0|L}({h:r,l:n}=o.add(0|this.Ah,0|this.Al,0|r,0|n)),({h:i,l:a}=o.add(0|this.Bh,0|this.Bl,0|i,0|a)),({h:s,l:c}=o.add(0|this.Ch,0|this.Cl,0|s,0|c)),({h:u,l}=o.add(0|this.Dh,0|this.Dl,0|u,0|l)),({h:b,l:g}=o.add(0|this.Eh,0|this.El,0|b,0|g)),({h:y,l:m}=o.add(0|this.Fh,0|this.Fl,0|y,0|m)),({h:v,l:w}=o.add(0|this.Gh,0|this.Gl,0|v,0|w)),({h:_,l:S}=o.add(0|this.Hh,0|this.Hl,0|_,0|S)),this.set(r,n,i,a,s,c,u,l,b,g,y,m,v,w,_,S)}roundClean(){(0,i.clean)(d,p)}destroy(){(0,i.clean)(this.buffer),this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)}}t.SHA512=b;class g extends b{constructor(){super(48),this.Ah=0|n.SHA384_IV[0],this.Al=0|n.SHA384_IV[1],this.Bh=0|n.SHA384_IV[2],this.Bl=0|n.SHA384_IV[3],this.Ch=0|n.SHA384_IV[4],this.Cl=0|n.SHA384_IV[5],this.Dh=0|n.SHA384_IV[6],this.Dl=0|n.SHA384_IV[7],this.Eh=0|n.SHA384_IV[8],this.El=0|n.SHA384_IV[9],this.Fh=0|n.SHA384_IV[10],this.Fl=0|n.SHA384_IV[11],this.Gh=0|n.SHA384_IV[12],this.Gl=0|n.SHA384_IV[13],this.Hh=0|n.SHA384_IV[14],this.Hl=0|n.SHA384_IV[15]}}t.SHA384=g;const y=Uint32Array.from([2352822216,424955298,1944164710,2312950998,502970286,855612546,1738396948,1479516111,258812777,2077511080,2011393907,79989058,1067287976,1780299464,286451373,2446758561]),m=Uint32Array.from([573645204,4230739756,2673172387,3360449730,596883563,1867755857,2520282905,1497426621,2519219938,2827943907,3193839141,1401305490,721525244,746961066,246885852,2177182882]);class v extends b{constructor(){super(28),this.Ah=0|y[0],this.Al=0|y[1],this.Bh=0|y[2],this.Bl=0|y[3],this.Ch=0|y[4],this.Cl=0|y[5],this.Dh=0|y[6],this.Dl=0|y[7],this.Eh=0|y[8],this.El=0|y[9],this.Fh=0|y[10],this.Fl=0|y[11],this.Gh=0|y[12],this.Gl=0|y[13],this.Hh=0|y[14],this.Hl=0|y[15]}}t.SHA512_224=v;class w extends b{constructor(){super(32),this.Ah=0|m[0],this.Al=0|m[1],this.Bh=0|m[2],this.Bl=0|m[3],this.Ch=0|m[4],this.Cl=0|m[5],this.Dh=0|m[6],this.Dl=0|m[7],this.Eh=0|m[8],this.El=0|m[9],this.Fh=0|m[10],this.Fl=0|m[11],this.Gh=0|m[12],this.Gl=0|m[13],this.Hh=0|m[14],this.Hl=0|m[15]}}t.SHA512_256=w,t.sha256=(0,i.createHasher)(()=>new c),t.sha224=(0,i.createHasher)(()=>new u),t.sha512=(0,i.createHasher)(()=>new b),t.sha384=(0,i.createHasher)(()=>new g),t.sha512_256=(0,i.createHasher)(()=>new w),t.sha512_224=(0,i.createHasher)(()=>new v)},6624:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha224=t.SHA224=t.sha256=t.SHA256=void 0;const n=r(3428);t.SHA256=n.SHA256,t.sha256=n.sha256,t.SHA224=n.SHA224,t.sha224=n.sha224},2325:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha512_256=t.SHA512_256=t.sha512_224=t.SHA512_224=t.sha384=t.SHA384=t.sha512=t.SHA512=void 0;const n=r(3428);t.SHA512=n.SHA512,t.sha512=n.sha512,t.SHA384=n.SHA384,t.sha384=n.sha384,t.SHA512_224=n.SHA512_224,t.sha512_224=n.sha512_224,t.SHA512_256=n.SHA512_256,t.sha512_256=n.sha512_256},8412:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.wrapXOFConstructorWithOpts=t.wrapConstructorWithOpts=t.wrapConstructor=t.Hash=t.nextTick=t.swap32IfBE=t.byteSwapIfBE=t.swap8IfBE=t.isLE=void 0,t.isBytes=o,t.anumber=i,t.abytes=a,t.ahash=function(e){if("function"!=typeof e||"function"!=typeof e.create)throw new Error("Hash should be wrapped by utils.createHasher");i(e.outputLen),i(e.blockLen)},t.aexists=function(e,t=!0){if(e.destroyed)throw new Error("Hash instance has been destroyed");if(t&&e.finished)throw new Error("Hash#digest() has already been called")},t.aoutput=function(e,t){a(e);const r=t.outputLen;if(e.length<r)throw new Error("digestInto() expects output buffer of length at least "+r)},t.u8=function(e){return new Uint8Array(e.buffer,e.byteOffset,e.byteLength)},t.u32=function(e){return new Uint32Array(e.buffer,e.byteOffset,Math.floor(e.byteLength/4))},t.clean=function(...e){for(let t=0;t<e.length;t++)e[t].fill(0)},t.createView=function(e){return new DataView(e.buffer,e.byteOffset,e.byteLength)},t.rotr=function(e,t){return e<<32-t|e>>>t},t.rotl=function(e,t){return e<<t|e>>>32-t>>>0},t.byteSwap=s,t.byteSwap32=c,t.bytesToHex=function(e){if(a(e),u)return e.toHex();let t="";for(let r=0;r<e.length;r++)t+=l[e[r]];return t},t.hexToBytes=function(e){if("string"!=typeof e)throw new Error("hex string expected, got "+typeof e);if(u)return Uint8Array.fromHex(e);const t=e.length,r=t/2;if(t%2)throw new Error("hex string expected, got unpadded hex of length "+t);const n=new Uint8Array(r);for(let t=0,o=0;t<r;t++,o+=2){const r=h(e.charCodeAt(o)),i=h(e.charCodeAt(o+1));if(void 0===r||void 0===i){const t=e[o]+e[o+1];throw new Error('hex string expected, got non-hex character "'+t+'" at index '+o)}n[t]=16*r+i}return n},t.asyncLoop=async function(e,r,n){let o=Date.now();for(let i=0;i<e;i++){n(i);const e=Date.now()-o;e>=0&&e<r||(await(0,t.nextTick)(),o+=e)}},t.utf8ToBytes=d,t.bytesToUtf8=function(e){return(new TextDecoder).decode(e)},t.toBytes=p,t.kdfInputToBytes=function(e){return"string"==typeof e&&(e=d(e)),a(e),e},t.concatBytes=function(...e){let t=0;for(let r=0;r<e.length;r++){const n=e[r];a(n),t+=n.length}const r=new Uint8Array(t);for(let t=0,n=0;t<e.length;t++){const o=e[t];r.set(o,n),n+=o.length}return r},t.checkOpts=function(e,t){if(void 0!==t&&"[object Object]"!=={}.toString.call(t))throw new Error("options should be object or undefined");return Object.assign(e,t)},t.createHasher=b,t.createOptHasher=g,t.createXOFer=y,t.randomBytes=function(e=32){if(n.crypto&&"function"==typeof n.crypto.getRandomValues)return n.crypto.getRandomValues(new Uint8Array(e));if(n.crypto&&"function"==typeof n.crypto.randomBytes)return Uint8Array.from(n.crypto.randomBytes(e));throw new Error("crypto.getRandomValues must be defined")};const n=r(2174);function o(e){return e instanceof Uint8Array||ArrayBuffer.isView(e)&&"Uint8Array"===e.constructor.name}function i(e){if(!Number.isSafeInteger(e)||e<0)throw new Error("positive integer expected, got "+e)}function a(e,...t){if(!o(e))throw new Error("Uint8Array expected");if(t.length>0&&!t.includes(e.length))throw new Error("Uint8Array expected of length "+t+", got length="+e.length)}function s(e){return e<<24&4278190080|e<<8&16711680|e>>>8&65280|e>>>24&255}function c(e){for(let t=0;t<e.length;t++)e[t]=s(e[t]);return e}t.isLE=68===new Uint8Array(new Uint32Array([287454020]).buffer)[0],t.swap8IfBE=t.isLE?e=>e:e=>s(e),t.byteSwapIfBE=t.swap8IfBE,t.swap32IfBE=t.isLE?e=>e:c;const u=(()=>"function"==typeof Uint8Array.from([]).toHex&&"function"==typeof Uint8Array.fromHex)(),l=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0")),f={_0:48,_9:57,A:65,F:70,a:97,f:102};function h(e){return e>=f._0&&e<=f._9?e-f._0:e>=f.A&&e<=f.F?e-(f.A-10):e>=f.a&&e<=f.f?e-(f.a-10):void 0}function d(e){if("string"!=typeof e)throw new Error("string expected");return new Uint8Array((new TextEncoder).encode(e))}function p(e){return"string"==typeof e&&(e=d(e)),a(e),e}function b(e){const t=t=>e().update(p(t)).digest(),r=e();return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=()=>e(),t}function g(e){const t=(t,r)=>e(r).update(p(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t}function y(e){const t=(t,r)=>e(r).update(p(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t}t.nextTick=async()=>{},t.Hash=class{},t.wrapConstructor=b,t.wrapConstructorWithOpts=g,t.wrapXOFConstructorWithOpts=y},2314:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const n={};let o;t.wordlists=n,t._default=o;try{t._default=o=r(32),n.czech=o}catch(e){}try{t._default=o=r(6996),n.chinese_simplified=o}catch(e){}try{t._default=o=r(4262),n.chinese_traditional=o}catch(e){}try{t._default=o=r(8013),n.korean=o}catch(e){}try{t._default=o=r(1848),n.french=o}catch(e){}try{t._default=o=r(2841),n.italian=o}catch(e){}try{t._default=o=r(659),n.spanish=o}catch(e){}try{t._default=o=r(4472),n.japanese=o,n.JA=o}catch(e){}try{t._default=o=r(1945),n.portuguese=o}catch(e){}try{t._default=o=r(4573),n.english=o,n.EN=o}catch(e){}},2153:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0});const o=r(6624),i=r(2325),a=r(8767),s=r(8412),c=r(2314);let u=c._default;const l="Invalid mnemonic",f="Invalid entropy",h="A wordlist is required but a default could not be found.\nPlease pass a 2048 word array explicitly.";function d(e){return(e||"").normalize("NFKD")}function p(e,t,r){for(;e.length<r;)e=t+e;return e}function b(e){return parseInt(e,2)}function g(e){return e.map(e=>p(e.toString(2),"0",8)).join("")}function y(e){const t=8*e.length/32,r=o.sha256(Uint8Array.from(e));return g(Array.from(r)).slice(0,t)}function m(e){return"mnemonic"+(e||"")}function v(e,t){if(!(t=t||u))throw new Error(h);const r=d(e).split(" ");if(r.length%3!=0)throw new Error(l);const o=r.map(e=>{const r=t.indexOf(e);if(-1===r)throw new Error(l);return p(r.toString(2),"0",11)}).join(""),i=32*Math.floor(o.length/33),a=o.slice(0,i),s=o.slice(i),c=a.match(/(.{1,8})/g).map(b);if(c.length<16)throw new Error(f);if(c.length>32)throw new Error(f);if(c.length%4!=0)throw new Error(f);const g=n.from(c);if(y(g)!==s)throw new Error("Invalid mnemonic checksum");return g.toString("hex")}function w(e,t){if(n.isBuffer(e)||(e=n.from(e,"hex")),!(t=t||u))throw new Error(h);if(e.length<16)throw new TypeError(f);if(e.length>32)throw new TypeError(f);if(e.length%4!=0)throw new TypeError(f);const r=(g(Array.from(e))+y(e)).match(/(.{1,11})/g).map(e=>{const r=b(e);return t[r]});return"あいこくしん"===t[0]?r.join("　"):r.join(" ")}t.mnemonicToSeedSync=function(e,t){const r=Uint8Array.from(n.from(d(e),"utf8")),o=Uint8Array.from(n.from(m(d(t)),"utf8")),s=a.pbkdf2(i.sha512,r,o,{c:2048,dkLen:64});return n.from(s)},t.mnemonicToSeed=function(e,t){const r=Uint8Array.from(n.from(d(e),"utf8")),o=Uint8Array.from(n.from(m(d(t)),"utf8"));return a.pbkdf2Async(i.sha512,r,o,{c:2048,dkLen:64}).then(e=>n.from(e))},t.mnemonicToEntropy=v,t.entropyToMnemonic=w,t.generateMnemonic=function(e,t,r){if((e=e||128)%32!=0)throw new TypeError(f);return w((t=t||(e=>n.from(s.randomBytes(e))))(e/8),r)},t.validateMnemonic=function(e,t){try{v(e,t)}catch(e){return!1}return!0},t.setDefaultWordlist=function(e){const t=c.wordlists[e];if(!t)throw new Error('Could not find wordlist for language "'+e+'"');u=t},t.getDefaultWordlist=function(){if(!u)throw new Error("No Default Wordlist set");return Object.keys(c.wordlists).filter(e=>"JA"!==e&&"EN"!==e&&c.wordlists[e].every((e,t)=>e===u[t]))[0]};var _=r(2314);t.wordlists=_.wordlists},8580:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SHA512_IV=t.SHA384_IV=t.SHA224_IV=t.SHA256_IV=t.HashMD=void 0,t.setBigUint64=o,t.Chi=function(e,t,r){return e&t^~e&r},t.Maj=function(e,t,r){return e&t^e&r^t&r};const n=r(1194);function o(e,t,r,n){if("function"==typeof e.setBigUint64)return e.setBigUint64(t,r,n);const o=BigInt(32),i=BigInt(4294967295),a=Number(r>>o&i),s=Number(r&i),c=n?4:0,u=n?0:4;e.setUint32(t+c,a,n),e.setUint32(t+u,s,n)}class i extends n.Hash{constructor(e,t,r,o){super(),this.finished=!1,this.length=0,this.pos=0,this.destroyed=!1,this.blockLen=e,this.outputLen=t,this.padOffset=r,this.isLE=o,this.buffer=new Uint8Array(e),this.view=(0,n.createView)(this.buffer)}update(e){(0,n.aexists)(this),e=(0,n.toBytes)(e),(0,n.abytes)(e);const{view:t,buffer:r,blockLen:o}=this,i=e.length;for(let a=0;a<i;){const s=Math.min(o-this.pos,i-a);if(s===o){const t=(0,n.createView)(e);for(;o<=i-a;a+=o)this.process(t,a);continue}r.set(e.subarray(a,a+s),this.pos),this.pos+=s,a+=s,this.pos===o&&(this.process(t,0),this.pos=0)}return this.length+=e.length,this.roundClean(),this}digestInto(e){(0,n.aexists)(this),(0,n.aoutput)(e,this),this.finished=!0;const{buffer:t,view:r,blockLen:i,isLE:a}=this;let{pos:s}=this;t[s++]=128,(0,n.clean)(this.buffer.subarray(s)),this.padOffset>i-s&&(this.process(r,0),s=0);for(let e=s;e<i;e++)t[e]=0;o(r,i-8,BigInt(8*this.length),a),this.process(r,0);const c=(0,n.createView)(e),u=this.outputLen;if(u%4)throw new Error("_sha2: outputLen should be aligned to 32bit");const l=u/4,f=this.get();if(l>f.length)throw new Error("_sha2: outputLen bigger than state");for(let e=0;e<l;e++)c.setUint32(4*e,f[e],a)}digest(){const{buffer:e,outputLen:t}=this;this.digestInto(e);const r=e.slice(0,t);return this.destroy(),r}_cloneInto(e){e||(e=new this.constructor),e.set(...this.get());const{blockLen:t,buffer:r,length:n,finished:o,destroyed:i,pos:a}=this;return e.destroyed=i,e.finished=o,e.length=n,e.pos=a,n%t&&e.buffer.set(r),e}clone(){return this._cloneInto()}}t.HashMD=i,t.SHA256_IV=Uint32Array.from([1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225]),t.SHA224_IV=Uint32Array.from([3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428]),t.SHA384_IV=Uint32Array.from([3418070365,3238371032,1654270250,914150663,2438529370,812702999,355462360,4144912697,1731405415,4290775857,2394180231,1750603025,3675008525,1694076839,1203062813,3204075428]),t.SHA512_IV=Uint32Array.from([1779033703,4089235720,3144134277,2227873595,1013904242,4271175723,2773480762,1595750129,1359893119,2917565137,2600822924,725511199,528734635,4215389547,1541459225,327033209])},9794:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.toBig=t.shrSL=t.shrSH=t.rotrSL=t.rotrSH=t.rotrBL=t.rotrBH=t.rotr32L=t.rotr32H=t.rotlSL=t.rotlSH=t.rotlBL=t.rotlBH=t.add5L=t.add5H=t.add4L=t.add4H=t.add3L=t.add3H=void 0,t.add=v,t.fromBig=o,t.split=i;const r=BigInt(2**32-1),n=BigInt(32);function o(e,t=!1){return t?{h:Number(e&r),l:Number(e>>n&r)}:{h:0|Number(e>>n&r),l:0|Number(e&r)}}function i(e,t=!1){const r=e.length;let n=new Uint32Array(r),i=new Uint32Array(r);for(let a=0;a<r;a++){const{h:r,l:s}=o(e[a],t);[n[a],i[a]]=[r,s]}return[n,i]}const a=(e,t)=>BigInt(e>>>0)<<n|BigInt(t>>>0);t.toBig=a;const s=(e,t,r)=>e>>>r;t.shrSH=s;const c=(e,t,r)=>e<<32-r|t>>>r;t.shrSL=c;const u=(e,t,r)=>e>>>r|t<<32-r;t.rotrSH=u;const l=(e,t,r)=>e<<32-r|t>>>r;t.rotrSL=l;const f=(e,t,r)=>e<<64-r|t>>>r-32;t.rotrBH=f;const h=(e,t,r)=>e>>>r-32|t<<64-r;t.rotrBL=h;const d=(e,t)=>t;t.rotr32H=d;const p=(e,t)=>e;t.rotr32L=p;const b=(e,t,r)=>e<<r|t>>>32-r;t.rotlSH=b;const g=(e,t,r)=>t<<r|e>>>32-r;t.rotlSL=g;const y=(e,t,r)=>t<<r-32|e>>>64-r;t.rotlBH=y;const m=(e,t,r)=>e<<r-32|t>>>64-r;function v(e,t,r,n){const o=(t>>>0)+(n>>>0);return{h:e+r+(o/2**32|0)|0,l:0|o}}t.rotlBL=m;const w=(e,t,r)=>(e>>>0)+(t>>>0)+(r>>>0);t.add3L=w;const _=(e,t,r,n)=>t+r+n+(e/2**32|0)|0;t.add3H=_;const S=(e,t,r,n)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0);t.add4L=S;const E=(e,t,r,n,o)=>t+r+n+o+(e/2**32|0)|0;t.add4H=E;const k=(e,t,r,n,o)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0)+(o>>>0);t.add5L=k;const A=(e,t,r,n,o,i)=>t+r+n+o+i+(e/2**32|0)|0;t.add5H=A;const x={fromBig:o,split:i,toBig:a,shrSH:s,shrSL:c,rotrSH:u,rotrSL:l,rotrBH:f,rotrBL:h,rotr32H:d,rotr32L:p,rotlSH:b,rotlSL:g,rotlBH:y,rotlBL:m,add:v,add3L:w,add3H:_,add4L:S,add4H:E,add5H:A,add5L:k};t.default=x},2815:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.crypto=void 0,t.crypto="object"==typeof globalThis&&"crypto"in globalThis?globalThis.crypto:void 0},514:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ripemd160=t.RIPEMD160=t.md5=t.MD5=t.sha1=t.SHA1=void 0;const n=r(8580),o=r(1194),i=Uint32Array.from([1732584193,4023233417,2562383102,271733878,3285377520]),a=new Uint32Array(80);class s extends n.HashMD{constructor(){super(64,20,8,!1),this.A=0|i[0],this.B=0|i[1],this.C=0|i[2],this.D=0|i[3],this.E=0|i[4]}get(){const{A:e,B:t,C:r,D:n,E:o}=this;return[e,t,r,n,o]}set(e,t,r,n,o){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n,this.E=0|o}process(e,t){for(let r=0;r<16;r++,t+=4)a[r]=e.getUint32(t,!1);for(let e=16;e<80;e++)a[e]=(0,o.rotl)(a[e-3]^a[e-8]^a[e-14]^a[e-16],1);let{A:r,B:i,C:s,D:c,E:u}=this;for(let e=0;e<80;e++){let t,l;e<20?(t=(0,n.Chi)(i,s,c),l=1518500249):e<40?(t=i^s^c,l=1859775393):e<60?(t=(0,n.Maj)(i,s,c),l=2400959708):(t=i^s^c,l=3395469782);const f=(0,o.rotl)(r,5)+t+u+l+a[e]|0;u=c,c=s,s=(0,o.rotl)(i,30),i=r,r=f}r=r+this.A|0,i=i+this.B|0,s=s+this.C|0,c=c+this.D|0,u=u+this.E|0,this.set(r,i,s,c,u)}roundClean(){(0,o.clean)(a)}destroy(){this.set(0,0,0,0,0),(0,o.clean)(this.buffer)}}t.SHA1=s,t.sha1=(0,o.createHasher)(()=>new s);const c=Math.pow(2,32),u=Array.from({length:64},(e,t)=>Math.floor(c*Math.abs(Math.sin(t+1)))),l=i.slice(0,4),f=new Uint32Array(16);class h extends n.HashMD{constructor(){super(64,16,8,!0),this.A=0|l[0],this.B=0|l[1],this.C=0|l[2],this.D=0|l[3]}get(){const{A:e,B:t,C:r,D:n}=this;return[e,t,r,n]}set(e,t,r,n){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n}process(e,t){for(let r=0;r<16;r++,t+=4)f[r]=e.getUint32(t,!0);let{A:r,B:i,C:a,D:s}=this;for(let e=0;e<64;e++){let t,c,l;e<16?(t=(0,n.Chi)(i,a,s),c=e,l=[7,12,17,22]):e<32?(t=(0,n.Chi)(s,i,a),c=(5*e+1)%16,l=[5,9,14,20]):e<48?(t=i^a^s,c=(3*e+5)%16,l=[4,11,16,23]):(t=a^(i|~s),c=7*e%16,l=[6,10,15,21]),t=t+r+u[e]+f[c],r=s,s=a,a=i,i+=(0,o.rotl)(t,l[e%4])}r=r+this.A|0,i=i+this.B|0,a=a+this.C|0,s=s+this.D|0,this.set(r,i,a,s)}roundClean(){(0,o.clean)(f)}destroy(){this.set(0,0,0,0),(0,o.clean)(this.buffer)}}t.MD5=h,t.md5=(0,o.createHasher)(()=>new h);const d=Uint8Array.from([7,4,13,1,10,6,15,3,12,0,9,5,2,14,11,8]),p=(()=>Uint8Array.from(new Array(16).fill(0).map((e,t)=>t)))(),b=(()=>p.map(e=>(9*e+5)%16))(),g=(()=>{const e=[[p],[b]];for(let t=0;t<4;t++)for(let r of e)r.push(r[t].map(e=>d[e]));return e})(),y=(()=>g[0])(),m=(()=>g[1])(),v=[[11,14,15,12,5,8,7,9,11,13,14,15,6,7,9,8],[12,13,11,15,6,9,9,7,12,15,11,13,7,8,7,7],[13,15,14,11,7,7,6,8,13,14,13,12,5,5,6,9],[14,11,12,14,8,6,5,5,15,12,15,14,9,9,8,6],[15,12,13,13,9,5,8,6,14,11,12,11,8,6,5,5]].map(e=>Uint8Array.from(e)),w=y.map((e,t)=>e.map(e=>v[t][e])),_=m.map((e,t)=>e.map(e=>v[t][e])),S=Uint32Array.from([0,1518500249,1859775393,2400959708,2840853838]),E=Uint32Array.from([1352829926,1548603684,1836072691,2053994217,0]);function k(e,t,r,n){return 0===e?t^r^n:1===e?t&r|~t&n:2===e?(t|~r)^n:3===e?t&n|r&~n:t^(r|~n)}const A=new Uint32Array(16);class x extends n.HashMD{constructor(){super(64,20,8,!0),this.h0=1732584193,this.h1=-271733879,this.h2=-1732584194,this.h3=271733878,this.h4=-1009589776}get(){const{h0:e,h1:t,h2:r,h3:n,h4:o}=this;return[e,t,r,n,o]}set(e,t,r,n,o){this.h0=0|e,this.h1=0|t,this.h2=0|r,this.h3=0|n,this.h4=0|o}process(e,t){for(let r=0;r<16;r++,t+=4)A[r]=e.getUint32(t,!0);let r=0|this.h0,n=r,i=0|this.h1,a=i,s=0|this.h2,c=s,u=0|this.h3,l=u,f=0|this.h4,h=f;for(let e=0;e<5;e++){const t=4-e,d=S[e],p=E[e],b=y[e],g=m[e],v=w[e],x=_[e];for(let t=0;t<16;t++){const n=(0,o.rotl)(r+k(e,i,s,u)+A[b[t]]+d,v[t])+f|0;r=f,f=u,u=0|(0,o.rotl)(s,10),s=i,i=n}for(let e=0;e<16;e++){const r=(0,o.rotl)(n+k(t,a,c,l)+A[g[e]]+p,x[e])+h|0;n=h,h=l,l=0|(0,o.rotl)(c,10),c=a,a=r}}this.set(this.h1+s+l|0,this.h2+u+h|0,this.h3+f+n|0,this.h4+r+a|0,this.h0+i+c|0)}roundClean(){(0,o.clean)(A)}destroy(){this.destroyed=!0,(0,o.clean)(this.buffer),this.set(0,0,0,0,0)}}t.RIPEMD160=x,t.ripemd160=(0,o.createHasher)(()=>new x)},1165:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ripemd160=t.RIPEMD160=void 0;const n=r(514);t.RIPEMD160=n.RIPEMD160,t.ripemd160=n.ripemd160},6740:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha1=t.SHA1=void 0;const n=r(514);t.SHA1=n.SHA1,t.sha1=n.sha1},7760:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha512_224=t.sha512_256=t.sha384=t.sha512=t.sha224=t.sha256=t.SHA512_256=t.SHA512_224=t.SHA384=t.SHA512=t.SHA224=t.SHA256=void 0;const n=r(8580),o=r(9794),i=r(1194),a=Uint32Array.from([1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298]),s=new Uint32Array(64);class c extends n.HashMD{constructor(e=32){super(64,e,8,!1),this.A=0|n.SHA256_IV[0],this.B=0|n.SHA256_IV[1],this.C=0|n.SHA256_IV[2],this.D=0|n.SHA256_IV[3],this.E=0|n.SHA256_IV[4],this.F=0|n.SHA256_IV[5],this.G=0|n.SHA256_IV[6],this.H=0|n.SHA256_IV[7]}get(){const{A:e,B:t,C:r,D:n,E:o,F:i,G:a,H:s}=this;return[e,t,r,n,o,i,a,s]}set(e,t,r,n,o,i,a,s){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n,this.E=0|o,this.F=0|i,this.G=0|a,this.H=0|s}process(e,t){for(let r=0;r<16;r++,t+=4)s[r]=e.getUint32(t,!1);for(let e=16;e<64;e++){const t=s[e-15],r=s[e-2],n=(0,i.rotr)(t,7)^(0,i.rotr)(t,18)^t>>>3,o=(0,i.rotr)(r,17)^(0,i.rotr)(r,19)^r>>>10;s[e]=o+s[e-7]+n+s[e-16]|0}let{A:r,B:o,C:c,D:u,E:l,F:f,G:h,H:d}=this;for(let e=0;e<64;e++){const t=d+((0,i.rotr)(l,6)^(0,i.rotr)(l,11)^(0,i.rotr)(l,25))+(0,n.Chi)(l,f,h)+a[e]+s[e]|0,p=((0,i.rotr)(r,2)^(0,i.rotr)(r,13)^(0,i.rotr)(r,22))+(0,n.Maj)(r,o,c)|0;d=h,h=f,f=l,l=u+t|0,u=c,c=o,o=r,r=t+p|0}r=r+this.A|0,o=o+this.B|0,c=c+this.C|0,u=u+this.D|0,l=l+this.E|0,f=f+this.F|0,h=h+this.G|0,d=d+this.H|0,this.set(r,o,c,u,l,f,h,d)}roundClean(){(0,i.clean)(s)}destroy(){this.set(0,0,0,0,0,0,0,0),(0,i.clean)(this.buffer)}}t.SHA256=c;class u extends c{constructor(){super(28),this.A=0|n.SHA224_IV[0],this.B=0|n.SHA224_IV[1],this.C=0|n.SHA224_IV[2],this.D=0|n.SHA224_IV[3],this.E=0|n.SHA224_IV[4],this.F=0|n.SHA224_IV[5],this.G=0|n.SHA224_IV[6],this.H=0|n.SHA224_IV[7]}}t.SHA224=u;const l=(()=>o.split(["0x428a2f98d728ae22","0x7137449123ef65cd","0xb5c0fbcfec4d3b2f","0xe9b5dba58189dbbc","0x3956c25bf348b538","0x59f111f1b605d019","0x923f82a4af194f9b","0xab1c5ed5da6d8118","0xd807aa98a3030242","0x12835b0145706fbe","0x243185be4ee4b28c","0x550c7dc3d5ffb4e2","0x72be5d74f27b896f","0x80deb1fe3b1696b1","0x9bdc06a725c71235","0xc19bf174cf692694","0xe49b69c19ef14ad2","0xefbe4786384f25e3","0x0fc19dc68b8cd5b5","0x240ca1cc77ac9c65","0x2de92c6f592b0275","0x4a7484aa6ea6e483","0x5cb0a9dcbd41fbd4","0x76f988da831153b5","0x983e5152ee66dfab","0xa831c66d2db43210","0xb00327c898fb213f","0xbf597fc7beef0ee4","0xc6e00bf33da88fc2","0xd5a79147930aa725","0x06ca6351e003826f","0x142929670a0e6e70","0x27b70a8546d22ffc","0x2e1b21385c26c926","0x4d2c6dfc5ac42aed","0x53380d139d95b3df","0x650a73548baf63de","0x766a0abb3c77b2a8","0x81c2c92e47edaee6","0x92722c851482353b","0xa2bfe8a14cf10364","0xa81a664bbc423001","0xc24b8b70d0f89791","0xc76c51a30654be30","0xd192e819d6ef5218","0xd69906245565a910","0xf40e35855771202a","0x106aa07032bbd1b8","0x19a4c116b8d2d0c8","0x1e376c085141ab53","0x2748774cdf8eeb99","0x34b0bcb5e19b48a8","0x391c0cb3c5c95a63","0x4ed8aa4ae3418acb","0x5b9cca4f7763e373","0x682e6ff3d6b2b8a3","0x748f82ee5defb2fc","0x78a5636f43172f60","0x84c87814a1f0ab72","0x8cc702081a6439ec","0x90befffa23631e28","0xa4506cebde82bde9","0xbef9a3f7b2c67915","0xc67178f2e372532b","0xca273eceea26619c","0xd186b8c721c0c207","0xeada7dd6cde0eb1e","0xf57d4f7fee6ed178","0x06f067aa72176fba","0x0a637dc5a2c898a6","0x113f9804bef90dae","0x1b710b35131c471b","0x28db77f523047d84","0x32caab7b40c72493","0x3c9ebe0a15c9bebc","0x431d67c49c100d4c","0x4cc5d4becb3e42b6","0x597f299cfc657e2a","0x5fcb6fab3ad6faec","0x6c44198c4a475817"].map(e=>BigInt(e))))(),f=(()=>l[0])(),h=(()=>l[1])(),d=new Uint32Array(80),p=new Uint32Array(80);class b extends n.HashMD{constructor(e=64){super(128,e,16,!1),this.Ah=0|n.SHA512_IV[0],this.Al=0|n.SHA512_IV[1],this.Bh=0|n.SHA512_IV[2],this.Bl=0|n.SHA512_IV[3],this.Ch=0|n.SHA512_IV[4],this.Cl=0|n.SHA512_IV[5],this.Dh=0|n.SHA512_IV[6],this.Dl=0|n.SHA512_IV[7],this.Eh=0|n.SHA512_IV[8],this.El=0|n.SHA512_IV[9],this.Fh=0|n.SHA512_IV[10],this.Fl=0|n.SHA512_IV[11],this.Gh=0|n.SHA512_IV[12],this.Gl=0|n.SHA512_IV[13],this.Hh=0|n.SHA512_IV[14],this.Hl=0|n.SHA512_IV[15]}get(){const{Ah:e,Al:t,Bh:r,Bl:n,Ch:o,Cl:i,Dh:a,Dl:s,Eh:c,El:u,Fh:l,Fl:f,Gh:h,Gl:d,Hh:p,Hl:b}=this;return[e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b]}set(e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b){this.Ah=0|e,this.Al=0|t,this.Bh=0|r,this.Bl=0|n,this.Ch=0|o,this.Cl=0|i,this.Dh=0|a,this.Dl=0|s,this.Eh=0|c,this.El=0|u,this.Fh=0|l,this.Fl=0|f,this.Gh=0|h,this.Gl=0|d,this.Hh=0|p,this.Hl=0|b}process(e,t){for(let r=0;r<16;r++,t+=4)d[r]=e.getUint32(t),p[r]=e.getUint32(t+=4);for(let e=16;e<80;e++){const t=0|d[e-15],r=0|p[e-15],n=o.rotrSH(t,r,1)^o.rotrSH(t,r,8)^o.shrSH(t,r,7),i=o.rotrSL(t,r,1)^o.rotrSL(t,r,8)^o.shrSL(t,r,7),a=0|d[e-2],s=0|p[e-2],c=o.rotrSH(a,s,19)^o.rotrBH(a,s,61)^o.shrSH(a,s,6),u=o.rotrSL(a,s,19)^o.rotrBL(a,s,61)^o.shrSL(a,s,6),l=o.add4L(i,u,p[e-7],p[e-16]),f=o.add4H(l,n,c,d[e-7],d[e-16]);d[e]=0|f,p[e]=0|l}let{Ah:r,Al:n,Bh:i,Bl:a,Ch:s,Cl:c,Dh:u,Dl:l,Eh:b,El:g,Fh:y,Fl:m,Gh:v,Gl:w,Hh:_,Hl:S}=this;for(let e=0;e<80;e++){const t=o.rotrSH(b,g,14)^o.rotrSH(b,g,18)^o.rotrBH(b,g,41),E=o.rotrSL(b,g,14)^o.rotrSL(b,g,18)^o.rotrBL(b,g,41),k=b&y^~b&v,A=g&m^~g&w,x=o.add5L(S,E,A,h[e],p[e]),I=o.add5H(x,_,t,k,f[e],d[e]),B=0|x,T=o.rotrSH(r,n,28)^o.rotrBH(r,n,34)^o.rotrBH(r,n,39),H=o.rotrSL(r,n,28)^o.rotrBL(r,n,34)^o.rotrBL(r,n,39),O=r&i^r&s^i&s,P=n&a^n&c^a&c;_=0|v,S=0|w,v=0|y,w=0|m,y=0|b,m=0|g,({h:b,l:g}=o.add(0|u,0|l,0|I,0|B)),u=0|s,l=0|c,s=0|i,c=0|a,i=0|r,a=0|n;const L=o.add3L(B,H,P);r=o.add3H(L,I,T,O),n=0|L}({h:r,l:n}=o.add(0|this.Ah,0|this.Al,0|r,0|n)),({h:i,l:a}=o.add(0|this.Bh,0|this.Bl,0|i,0|a)),({h:s,l:c}=o.add(0|this.Ch,0|this.Cl,0|s,0|c)),({h:u,l}=o.add(0|this.Dh,0|this.Dl,0|u,0|l)),({h:b,l:g}=o.add(0|this.Eh,0|this.El,0|b,0|g)),({h:y,l:m}=o.add(0|this.Fh,0|this.Fl,0|y,0|m)),({h:v,l:w}=o.add(0|this.Gh,0|this.Gl,0|v,0|w)),({h:_,l:S}=o.add(0|this.Hh,0|this.Hl,0|_,0|S)),this.set(r,n,i,a,s,c,u,l,b,g,y,m,v,w,_,S)}roundClean(){(0,i.clean)(d,p)}destroy(){(0,i.clean)(this.buffer),this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)}}t.SHA512=b;class g extends b{constructor(){super(48),this.Ah=0|n.SHA384_IV[0],this.Al=0|n.SHA384_IV[1],this.Bh=0|n.SHA384_IV[2],this.Bl=0|n.SHA384_IV[3],this.Ch=0|n.SHA384_IV[4],this.Cl=0|n.SHA384_IV[5],this.Dh=0|n.SHA384_IV[6],this.Dl=0|n.SHA384_IV[7],this.Eh=0|n.SHA384_IV[8],this.El=0|n.SHA384_IV[9],this.Fh=0|n.SHA384_IV[10],this.Fl=0|n.SHA384_IV[11],this.Gh=0|n.SHA384_IV[12],this.Gl=0|n.SHA384_IV[13],this.Hh=0|n.SHA384_IV[14],this.Hl=0|n.SHA384_IV[15]}}t.SHA384=g;const y=Uint32Array.from([2352822216,424955298,1944164710,2312950998,502970286,855612546,1738396948,1479516111,258812777,2077511080,2011393907,79989058,1067287976,1780299464,286451373,2446758561]),m=Uint32Array.from([573645204,4230739756,2673172387,3360449730,596883563,1867755857,2520282905,1497426621,2519219938,2827943907,3193839141,1401305490,721525244,746961066,246885852,2177182882]);class v extends b{constructor(){super(28),this.Ah=0|y[0],this.Al=0|y[1],this.Bh=0|y[2],this.Bl=0|y[3],this.Ch=0|y[4],this.Cl=0|y[5],this.Dh=0|y[6],this.Dl=0|y[7],this.Eh=0|y[8],this.El=0|y[9],this.Fh=0|y[10],this.Fl=0|y[11],this.Gh=0|y[12],this.Gl=0|y[13],this.Hh=0|y[14],this.Hl=0|y[15]}}t.SHA512_224=v;class w extends b{constructor(){super(32),this.Ah=0|m[0],this.Al=0|m[1],this.Bh=0|m[2],this.Bl=0|m[3],this.Ch=0|m[4],this.Cl=0|m[5],this.Dh=0|m[6],this.Dl=0|m[7],this.Eh=0|m[8],this.El=0|m[9],this.Fh=0|m[10],this.Fl=0|m[11],this.Gh=0|m[12],this.Gl=0|m[13],this.Hh=0|m[14],this.Hl=0|m[15]}}t.SHA512_256=w,t.sha256=(0,i.createHasher)(()=>new c),t.sha224=(0,i.createHasher)(()=>new u),t.sha512=(0,i.createHasher)(()=>new b),t.sha384=(0,i.createHasher)(()=>new g),t.sha512_256=(0,i.createHasher)(()=>new w),t.sha512_224=(0,i.createHasher)(()=>new v)},8387:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha224=t.SHA224=t.sha256=t.SHA256=void 0;const n=r(7760);t.SHA256=n.SHA256,t.sha256=n.sha256,t.SHA224=n.SHA224,t.sha224=n.sha224},1194:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.wrapXOFConstructorWithOpts=t.wrapConstructorWithOpts=t.wrapConstructor=t.Hash=t.nextTick=t.swap32IfBE=t.byteSwapIfBE=t.swap8IfBE=t.isLE=void 0,t.isBytes=o,t.anumber=i,t.abytes=a,t.ahash=function(e){if("function"!=typeof e||"function"!=typeof e.create)throw new Error("Hash should be wrapped by utils.createHasher");i(e.outputLen),i(e.blockLen)},t.aexists=function(e,t=!0){if(e.destroyed)throw new Error("Hash instance has been destroyed");if(t&&e.finished)throw new Error("Hash#digest() has already been called")},t.aoutput=function(e,t){a(e);const r=t.outputLen;if(e.length<r)throw new Error("digestInto() expects output buffer of length at least "+r)},t.u8=function(e){return new Uint8Array(e.buffer,e.byteOffset,e.byteLength)},t.u32=function(e){return new Uint32Array(e.buffer,e.byteOffset,Math.floor(e.byteLength/4))},t.clean=function(...e){for(let t=0;t<e.length;t++)e[t].fill(0)},t.createView=function(e){return new DataView(e.buffer,e.byteOffset,e.byteLength)},t.rotr=function(e,t){return e<<32-t|e>>>t},t.rotl=function(e,t){return e<<t|e>>>32-t>>>0},t.byteSwap=s,t.byteSwap32=c,t.bytesToHex=function(e){if(a(e),u)return e.toHex();let t="";for(let r=0;r<e.length;r++)t+=l[e[r]];return t},t.hexToBytes=function(e){if("string"!=typeof e)throw new Error("hex string expected, got "+typeof e);if(u)return Uint8Array.fromHex(e);const t=e.length,r=t/2;if(t%2)throw new Error("hex string expected, got unpadded hex of length "+t);const n=new Uint8Array(r);for(let t=0,o=0;t<r;t++,o+=2){const r=h(e.charCodeAt(o)),i=h(e.charCodeAt(o+1));if(void 0===r||void 0===i){const t=e[o]+e[o+1];throw new Error('hex string expected, got non-hex character "'+t+'" at index '+o)}n[t]=16*r+i}return n},t.asyncLoop=async function(e,r,n){let o=Date.now();for(let i=0;i<e;i++){n(i);const e=Date.now()-o;e>=0&&e<r||(await(0,t.nextTick)(),o+=e)}},t.utf8ToBytes=d,t.bytesToUtf8=function(e){return(new TextDecoder).decode(e)},t.toBytes=p,t.kdfInputToBytes=function(e){return"string"==typeof e&&(e=d(e)),a(e),e},t.concatBytes=function(...e){let t=0;for(let r=0;r<e.length;r++){const n=e[r];a(n),t+=n.length}const r=new Uint8Array(t);for(let t=0,n=0;t<e.length;t++){const o=e[t];r.set(o,n),n+=o.length}return r},t.checkOpts=function(e,t){if(void 0!==t&&"[object Object]"!=={}.toString.call(t))throw new Error("options should be object or undefined");return Object.assign(e,t)},t.createHasher=b,t.createOptHasher=g,t.createXOFer=y,t.randomBytes=function(e=32){if(n.crypto&&"function"==typeof n.crypto.getRandomValues)return n.crypto.getRandomValues(new Uint8Array(e));if(n.crypto&&"function"==typeof n.crypto.randomBytes)return Uint8Array.from(n.crypto.randomBytes(e));throw new Error("crypto.getRandomValues must be defined")};const n=r(2815);function o(e){return e instanceof Uint8Array||ArrayBuffer.isView(e)&&"Uint8Array"===e.constructor.name}function i(e){if(!Number.isSafeInteger(e)||e<0)throw new Error("positive integer expected, got "+e)}function a(e,...t){if(!o(e))throw new Error("Uint8Array expected");if(t.length>0&&!t.includes(e.length))throw new Error("Uint8Array expected of length "+t+", got length="+e.length)}function s(e){return e<<24&4278190080|e<<8&16711680|e>>>8&65280|e>>>24&255}function c(e){for(let t=0;t<e.length;t++)e[t]=s(e[t]);return e}t.isLE=68===new Uint8Array(new Uint32Array([287454020]).buffer)[0],t.swap8IfBE=t.isLE?e=>e:e=>s(e),t.byteSwapIfBE=t.swap8IfBE,t.swap32IfBE=t.isLE?e=>e:c;const u=(()=>"function"==typeof Uint8Array.from([]).toHex&&"function"==typeof Uint8Array.fromHex)(),l=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0")),f={_0:48,_9:57,A:65,F:70,a:97,f:102};function h(e){return e>=f._0&&e<=f._9?e-f._0:e>=f.A&&e<=f.F?e-(f.A-10):e>=f.a&&e<=f.f?e-(f.a-10):void 0}function d(e){if("string"!=typeof e)throw new Error("string expected");return new Uint8Array((new TextEncoder).encode(e))}function p(e){return"string"==typeof e&&(e=d(e)),a(e),e}function b(e){const t=t=>e().update(p(t)).digest(),r=e();return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=()=>e(),t}function g(e){const t=(t,r)=>e(r).update(p(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t}function y(e){const t=(t,r)=>e(r).update(p(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t}t.nextTick=async()=>{},t.Hash=class{},t.wrapConstructor=b,t.wrapConstructorWithOpts=g,t.wrapXOFConstructorWithOpts=y},5488:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.toOutputScript=t.fromOutputScript=t.toBech32=t.toBase58Check=t.fromBech32=t.fromBase58Check=void 0;const o=r(4378),i=r(4972),a=r(3357),s=r(1838),c=r(7715),u=r(8334),l="WARNING: Sending to a future segwit version address can lead to loss of funds. End users MUST be warned carefully in the GUI and asked if they wish to proceed with caution. Wallets should verify the segwit version from the output of fromBech32, then decide when it is safe to use which version of segwit.";function f(e){const t=n.from(u.decode(e));if(t.length<21)throw new TypeError(e+" is too short");if(t.length>21)throw new TypeError(e+" is too long");return{version:t.readUInt8(0),hash:t.slice(1)}}function h(e){let t,r;try{t=c.bech32.decode(e)}catch(e){}if(t){if(r=t.words[0],0!==r)throw new TypeError(e+" uses wrong encoding")}else if(t=c.bech32m.decode(e),r=t.words[0],0===r)throw new TypeError(e+" uses wrong encoding");const o=c.bech32.fromWords(t.words.slice(1));return{version:r,prefix:t.prefix,data:n.from(o)}}function d(e,t,r){const n=c.bech32.toWords(e);return n.unshift(t),0===t?c.bech32.encode(r,n):c.bech32m.encode(r,n)}t.fromBase58Check=f,t.fromBech32=h,t.toBase58Check=function(e,t){(0,s.typeforce)((0,s.tuple)(s.Hash160bit,s.UInt8),arguments);const r=n.allocUnsafe(21);return r.writeUInt8(t,0),e.copy(r,1),u.encode(r)},t.toBech32=d,t.fromOutputScript=function(e,t){t=t||o.bitcoin;try{return i.p2pkh({output:e,network:t}).address}catch(e){}try{return i.p2sh({output:e,network:t}).address}catch(e){}try{return i.p2wpkh({output:e,network:t}).address}catch(e){}try{return i.p2wsh({output:e,network:t}).address}catch(e){}try{return i.p2tr({output:e,network:t}).address}catch(e){}try{return function(e,t){const r=e.slice(2);if(r.length<2||r.length>40)throw new TypeError("Invalid program length for segwit address");const n=e[0]-80;if(n<2||n>16)throw new TypeError("Invalid version for segwit address");if(e[1]!==r.length)throw new TypeError("Invalid script for segwit address");return console.warn(l),d(r,n,t.bech32)}(e,t)}catch(e){}throw new Error(a.toASM(e)+" has no matching Address")},t.toOutputScript=function(e,t){let r,n;t=t||o.bitcoin;try{r=f(e)}catch(e){}if(r){if(r.version===t.pubKeyHash)return i.p2pkh({hash:r.hash}).output;if(r.version===t.scriptHash)return i.p2sh({hash:r.hash}).output}else{try{n=h(e)}catch(e){}if(n){if(n.prefix!==t.bech32)throw new Error(e+" has an invalid prefix");if(0===n.version){if(20===n.data.length)return i.p2wpkh({hash:n.data}).output;if(32===n.data.length)return i.p2wsh({hash:n.data}).output}else if(1===n.version){if(32===n.data.length)return i.p2tr({pubkey:n.data}).output}else if(n.version>=2&&n.version<=16&&n.data.length>=2&&n.data.length<=40)return console.warn(l),a.compile([n.version+80,n.data])}}throw new Error(e+" has no matching Script")}},7617:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.encode=t.decode=t.check=void 0,t.check=function(e){if(e.length<8)return!1;if(e.length>72)return!1;if(48!==e[0])return!1;if(e[1]!==e.length-2)return!1;if(2!==e[2])return!1;const t=e[3];if(0===t)return!1;if(5+t>=e.length)return!1;if(2!==e[4+t])return!1;const r=e[5+t];return!(0===r||6+t+r!==e.length||128&e[4]||t>1&&0===e[4]&&!(128&e[5])||128&e[t+6]||r>1&&0===e[t+6]&&!(128&e[t+7]))},t.decode=function(e){if(e.length<8)throw new Error("DER sequence length is too short");if(e.length>72)throw new Error("DER sequence length is too long");if(48!==e[0])throw new Error("Expected DER sequence");if(e[1]!==e.length-2)throw new Error("DER sequence length is invalid");if(2!==e[2])throw new Error("Expected DER integer");const t=e[3];if(0===t)throw new Error("R length is zero");if(5+t>=e.length)throw new Error("R length is too long");if(2!==e[4+t])throw new Error("Expected DER integer (2)");const r=e[5+t];if(0===r)throw new Error("S length is zero");if(6+t+r!==e.length)throw new Error("S length is invalid");if(128&e[4])throw new Error("R value is negative");if(t>1&&0===e[4]&&!(128&e[5]))throw new Error("R value excessively padded");if(128&e[t+6])throw new Error("S value is negative");if(r>1&&0===e[t+6]&&!(128&e[t+7]))throw new Error("S value excessively padded");return{r:e.slice(4,4+t),s:e.slice(6+t)}},t.encode=function(e,t){const r=e.length,o=t.length;if(0===r)throw new Error("R length is zero");if(0===o)throw new Error("S length is zero");if(r>33)throw new Error("R length is too long");if(o>33)throw new Error("S length is too long");if(128&e[0])throw new Error("R value is negative");if(128&t[0])throw new Error("S value is negative");if(r>1&&0===e[0]&&!(128&e[1]))throw new Error("R value excessively padded");if(o>1&&0===t[0]&&!(128&t[1]))throw new Error("S value excessively padded");const i=n.allocUnsafe(6+r+o);return i[0]=48,i[1]=i.length-2,i[2]=2,i[3]=e.length,e.copy(i,4),i[4+r]=2,i[5+r]=t.length,t.copy(i,6+r),i}},7949:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.Block=void 0;const o=r(9357),i=r(5525),a=r(298),s=r(2737),c=r(1838),{typeforce:u}=c,l=new TypeError("Cannot compute merkle root for zero transactions"),f=new TypeError("Cannot compute witness commit for non-segwit block");class h{constructor(){this.version=1,this.prevHash=void 0,this.merkleRoot=void 0,this.timestamp=0,this.witnessCommit=void 0,this.bits=0,this.nonce=0,this.transactions=void 0}static fromBuffer(e){if(e.length<80)throw new Error("Buffer too small (< 80 bytes)");const t=new o.BufferReader(e),r=new h;if(r.version=t.readInt32(),r.prevHash=t.readSlice(32),r.merkleRoot=t.readSlice(32),r.timestamp=t.readUInt32(),r.bits=t.readUInt32(),r.nonce=t.readUInt32(),80===e.length)return r;const n=()=>{const e=s.Transaction.fromBuffer(t.buffer.slice(t.offset),!0);return t.offset+=e.byteLength(),e},i=t.readVarInt();r.transactions=[];for(let e=0;e<i;++e){const e=n();r.transactions.push(e)}const a=r.getWitnessCommit();return a&&(r.witnessCommit=a),r}static fromHex(e){return h.fromBuffer(n.from(e,"hex"))}static calculateTarget(e){const t=((4278190080&e)>>24)-3,r=8388607&e,o=n.alloc(32,0);return o.writeUIntBE(r,29-t,3),o}static calculateMerkleRoot(e,t){if(u([{getHash:c.Function}],e),0===e.length)throw l;if(t&&!d(e))throw f;const r=e.map(e=>e.getHash(t)),o=(0,a.fastMerkleRoot)(r,i.hash256);return t?i.hash256(n.concat([o,e[0].ins[0].witness[0]])):o}getWitnessCommit(){if(!d(this.transactions))return null;const e=this.transactions[0].outs.filter(e=>e.script.slice(0,6).equals(n.from("6a24aa21a9ed","hex"))).map(e=>e.script.slice(6,38));if(0===e.length)return null;const t=e[e.length-1];return t instanceof n&&32===t.length?t:null}hasWitnessCommit(){return this.witnessCommit instanceof n&&32===this.witnessCommit.length||null!==this.getWitnessCommit()}hasWitness(){return(e=this.transactions)instanceof Array&&e.some(e=>"object"==typeof e&&e.ins instanceof Array&&e.ins.some(e=>"object"==typeof e&&e.witness instanceof Array&&e.witness.length>0));var e}weight(){return 3*this.byteLength(!1,!1)+this.byteLength(!1,!0)}byteLength(e,t=!0){return e||!this.transactions?80:80+o.varuint.encodingLength(this.transactions.length)+this.transactions.reduce((e,r)=>e+r.byteLength(t),0)}getHash(){return i.hash256(this.toBuffer(!0))}getId(){return(0,o.reverseBuffer)(this.getHash()).toString("hex")}getUTCDate(){const e=new Date(0);return e.setUTCSeconds(this.timestamp),e}toBuffer(e){const t=n.allocUnsafe(this.byteLength(e)),r=new o.BufferWriter(t);return r.writeInt32(this.version),r.writeSlice(this.prevHash),r.writeSlice(this.merkleRoot),r.writeUInt32(this.timestamp),r.writeUInt32(this.bits),r.writeUInt32(this.nonce),e||!this.transactions||(o.varuint.encode(this.transactions.length,t,r.offset),r.offset+=o.varuint.encode.bytes,this.transactions.forEach(e=>{const n=e.byteLength();e.toBuffer(t,r.offset),r.offset+=n})),t}toHex(e){return this.toBuffer(e).toString("hex")}checkTxRoots(){const e=this.hasWitnessCommit();return!(!e&&this.hasWitness())&&this.__checkMerkleRoot()&&(!e||this.__checkWitnessCommit())}checkProofOfWork(){const e=(0,o.reverseBuffer)(this.getHash()),t=h.calculateTarget(this.bits);return e.compare(t)<=0}__checkMerkleRoot(){if(!this.transactions)throw l;const e=h.calculateMerkleRoot(this.transactions);return 0===this.merkleRoot.compare(e)}__checkWitnessCommit(){if(!this.transactions)throw l;if(!this.hasWitnessCommit())throw f;const e=h.calculateMerkleRoot(this.transactions,!0);return 0===this.witnessCommit.compare(e)}}function d(e){return e instanceof Array&&e[0]&&e[0].ins&&e[0].ins instanceof Array&&e[0].ins[0]&&e[0].ins[0].witness&&e[0].ins[0].witness instanceof Array&&e[0].ins[0].witness.length>0}t.Block=h},9357:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.BufferReader=t.BufferWriter=t.cloneBuffer=t.reverseBuffer=t.writeUInt64LE=t.readUInt64LE=t.varuint=void 0;const o=r(1838),{typeforce:i}=o,a=r(7795);function s(e,t){if("number"!=typeof e)throw new Error("cannot write a non-number as a number");if(e<0)throw new Error("specified a negative value for writing an unsigned value");if(e>t)throw new Error("RangeError: value out of range");if(Math.floor(e)!==e)throw new Error("value has a fractional component")}function c(e,t){const r=e.readUInt32LE(t);let n=e.readUInt32LE(t+4);return n*=4294967296,s(n+r,9007199254740991),n+r}function u(e,t,r){return s(t,9007199254740991),e.writeInt32LE(-1&t,r),e.writeUInt32LE(Math.floor(t/4294967296),r+4),r+8}t.varuint=a,t.readUInt64LE=c,t.writeUInt64LE=u,t.reverseBuffer=function(e){if(e.length<1)return e;let t=e.length-1,r=0;for(let n=0;n<e.length/2;n++)r=e[n],e[n]=e[t],e[t]=r,t--;return e},t.cloneBuffer=function(e){const t=n.allocUnsafe(e.length);return e.copy(t),t};class l{static withCapacity(e){return new l(n.alloc(e))}constructor(e,t=0){this.buffer=e,this.offset=t,i(o.tuple(o.Buffer,o.UInt32),[e,t])}writeUInt8(e){this.offset=this.buffer.writeUInt8(e,this.offset)}writeInt32(e){this.offset=this.buffer.writeInt32LE(e,this.offset)}writeUInt32(e){this.offset=this.buffer.writeUInt32LE(e,this.offset)}writeUInt64(e){this.offset=u(this.buffer,e,this.offset)}writeVarInt(e){a.encode(e,this.buffer,this.offset),this.offset+=a.encode.bytes}writeSlice(e){if(this.buffer.length<this.offset+e.length)throw new Error("Cannot write slice out of bounds");this.offset+=e.copy(this.buffer,this.offset)}writeVarSlice(e){this.writeVarInt(e.length),this.writeSlice(e)}writeVector(e){this.writeVarInt(e.length),e.forEach(e=>this.writeVarSlice(e))}end(){if(this.buffer.length===this.offset)return this.buffer;throw new Error(`buffer size ${this.buffer.length}, offset ${this.offset}`)}}t.BufferWriter=l,t.BufferReader=class{constructor(e,t=0){this.buffer=e,this.offset=t,i(o.tuple(o.Buffer,o.UInt32),[e,t])}readUInt8(){const e=this.buffer.readUInt8(this.offset);return this.offset++,e}readInt32(){const e=this.buffer.readInt32LE(this.offset);return this.offset+=4,e}readUInt32(){const e=this.buffer.readUInt32LE(this.offset);return this.offset+=4,e}readUInt64(){const e=c(this.buffer,this.offset);return this.offset+=8,e}readVarInt(){const e=a.decode(this.buffer,this.offset);return this.offset+=a.decode.bytes,e}readSlice(e){if(this.buffer.length<this.offset+e)throw new Error("Cannot read slice out of bounds");const t=this.buffer.slice(this.offset,this.offset+e);return this.offset+=e,t}readVarSlice(){return this.readSlice(this.readVarInt())}readVector(){const e=this.readVarInt(),t=[];for(let r=0;r<e;r++)t.push(this.readVarSlice());return t}}},5525:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.taggedHash=t.TAGGED_HASH_PREFIXES=t.TAGS=t.hash256=t.hash160=t.sha256=t.sha1=t.ripemd160=void 0;const o=r(1165),i=r(6740),a=r(8387);function s(e){return n.from((0,a.sha256)(Uint8Array.from(e)))}t.ripemd160=function(e){return n.from((0,o.ripemd160)(Uint8Array.from(e)))},t.sha1=function(e){return n.from((0,i.sha1)(Uint8Array.from(e)))},t.sha256=s,t.hash160=function(e){return n.from((0,o.ripemd160)((0,a.sha256)(Uint8Array.from(e))))},t.hash256=function(e){return n.from((0,a.sha256)((0,a.sha256)(Uint8Array.from(e))))},t.TAGS=["BIP0340/challenge","BIP0340/aux","BIP0340/nonce","TapLeaf","TapBranch","TapSighash","TapTweak","KeyAgg list","KeyAgg coefficient"],t.TAGGED_HASH_PREFIXES={"BIP0340/challenge":n.from([123,181,45,122,159,239,88,50,62,177,191,122,64,125,179,130,210,243,242,216,27,177,34,79,73,254,81,143,109,72,211,124,123,181,45,122,159,239,88,50,62,177,191,122,64,125,179,130,210,243,242,216,27,177,34,79,73,254,81,143,109,72,211,124]),"BIP0340/aux":n.from([241,239,78,94,192,99,202,218,109,148,202,250,157,152,126,160,105,38,88,57,236,193,31,151,45,119,165,46,216,193,204,144,241,239,78,94,192,99,202,218,109,148,202,250,157,152,126,160,105,38,88,57,236,193,31,151,45,119,165,46,216,193,204,144]),"BIP0340/nonce":n.from([7,73,119,52,167,155,203,53,91,155,140,125,3,79,18,28,244,52,215,62,247,45,218,25,135,0,97,251,82,191,235,47,7,73,119,52,167,155,203,53,91,155,140,125,3,79,18,28,244,52,215,62,247,45,218,25,135,0,97,251,82,191,235,47]),TapLeaf:n.from([174,234,143,220,66,8,152,49,5,115,75,88,8,29,30,38,56,211,95,28,181,64,8,212,211,87,202,3,190,120,233,238,174,234,143,220,66,8,152,49,5,115,75,88,8,29,30,38,56,211,95,28,181,64,8,212,211,87,202,3,190,120,233,238]),TapBranch:n.from([25,65,161,242,229,110,185,95,162,169,241,148,190,92,1,247,33,111,51,237,130,176,145,70,52,144,208,91,245,22,160,21,25,65,161,242,229,110,185,95,162,169,241,148,190,92,1,247,33,111,51,237,130,176,145,70,52,144,208,91,245,22,160,21]),TapSighash:n.from([244,10,72,223,75,42,112,200,180,146,75,242,101,70,97,237,61,149,253,102,163,19,235,135,35,117,151,198,40,228,160,49,244,10,72,223,75,42,112,200,180,146,75,242,101,70,97,237,61,149,253,102,163,19,235,135,35,117,151,198,40,228,160,49]),TapTweak:n.from([232,15,225,99,156,156,160,80,227,175,27,57,193,67,198,62,66,156,188,235,21,217,64,251,181,197,161,244,175,87,197,233,232,15,225,99,156,156,160,80,227,175,27,57,193,67,198,62,66,156,188,235,21,217,64,251,181,197,161,244,175,87,197,233]),"KeyAgg list":n.from([72,28,151,28,60,11,70,215,240,178,117,174,89,141,78,44,126,215,49,156,89,74,92,110,199,158,160,212,153,2,148,240,72,28,151,28,60,11,70,215,240,178,117,174,89,141,78,44,126,215,49,156,89,74,92,110,199,158,160,212,153,2,148,240]),"KeyAgg coefficient":n.from([191,201,4,3,77,28,136,232,200,14,34,229,61,36,86,109,100,130,78,214,66,114,129,192,145,0,249,77,205,82,201,129,191,201,4,3,77,28,136,232,200,14,34,229,61,36,86,109,100,130,78,214,66,114,129,192,145,0,249,77,205,82,201,129])},t.taggedHash=function(e,r){return s(n.concat([t.TAGGED_HASH_PREFIXES[e],r]))}},6379:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.getEccLib=t.initEccLib=void 0;const o={};t.initEccLib=function(e){var t;e?e!==o.eccLib&&(a("function"==typeof(t=e).isXOnlyPoint),a(t.isXOnlyPoint(i("79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798"))),a(t.isXOnlyPoint(i("fffffffffffffffffffffffffffffffffffffffffffffffffffffffeeffffc2e"))),a(t.isXOnlyPoint(i("f9308a019258c31049344f85f89d5229b531c845836f99b08601f113bce036f9"))),a(t.isXOnlyPoint(i("0000000000000000000000000000000000000000000000000000000000000001"))),a(!t.isXOnlyPoint(i("0000000000000000000000000000000000000000000000000000000000000000"))),a(!t.isXOnlyPoint(i("fffffffffffffffffffffffffffffffffffffffffffffffffffffffefffffc2f"))),a("function"==typeof t.xOnlyPointAddTweak),s.forEach(e=>{const r=t.xOnlyPointAddTweak(i(e.pubkey),i(e.tweak));null===e.result?a(null===r):(a(null!==r),a(r.parity===e.parity),a(n.from(r.xOnlyPubkey).equals(i(e.result))))}),o.eccLib=e):o.eccLib=e},t.getEccLib=function(){if(!o.eccLib)throw new Error("No ECC Library provided. You must call initEccLib() with a valid TinySecp256k1Interface instance");return o.eccLib};const i=e=>n.from(e,"hex");function a(e){if(!e)throw new Error("ecc library invalid")}const s=[{pubkey:"79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798",tweak:"fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364140",parity:-1,result:null},{pubkey:"1617d38ed8d8657da4d4761e8057bc396ea9e4b9d29776d4be096016dbd2509b",tweak:"a8397a935f0dfceba6ba9618f6451ef4d80637abf4e6af2669fbc9de6a8fd2ac",parity:1,result:"e478f99dab91052ab39a33ea35fd5e6e4933f4d28023cd597c9a1f6760346adf"},{pubkey:"2c0b7cf95324a07d05398b240174dc0c2be444d96b159aa6c7f7b1e668680991",tweak:"823c3cd2142744b075a87eade7e1b8678ba308d566226a0056ca2b7a76f86b47",parity:0,result:"9534f8dc8c6deda2dc007655981c78b49c5d96c778fbf363462a11ec9dfd948c"}]},7656:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.initEccLib=t.Transaction=t.opcodes=t.Psbt=t.Block=t.script=t.payments=t.networks=t.crypto=t.address=void 0;const n=r(5488);t.address=n;const o=r(5525);t.crypto=o;const i=r(4378);t.networks=i;const a=r(4972);t.payments=a;const s=r(3357);t.script=s;var c=r(7949);Object.defineProperty(t,"Block",{enumerable:!0,get:function(){return c.Block}});var u=r(9930);Object.defineProperty(t,"Psbt",{enumerable:!0,get:function(){return u.Psbt}});var l=r(7334);Object.defineProperty(t,"opcodes",{enumerable:!0,get:function(){return l.OPS}});var f=r(2737);Object.defineProperty(t,"Transaction",{enumerable:!0,get:function(){return f.Transaction}});var h=r(6379);Object.defineProperty(t,"initEccLib",{enumerable:!0,get:function(){return h.initEccLib}})},298:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.fastMerkleRoot=void 0,t.fastMerkleRoot=function(e,t){if(!Array.isArray(e))throw TypeError("Expected values Array");if("function"!=typeof t)throw TypeError("Expected digest Function");let r=e.length;const o=e.concat();for(;r>1;){let e=0;for(let i=0;i<r;i+=2,++e){const a=o[i],s=i+1===r?a:o[i+1],c=n.concat([a,s]);o[e]=t(c)}r=e}return o[0]}},4378:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.testnet=t.regtest=t.bitcoin=void 0,t.bitcoin={messagePrefix:"Bitcoin Signed Message:\n",bech32:"bc",bip32:{public:76067358,private:76066276},pubKeyHash:0,scriptHash:5,wif:128},t.regtest={messagePrefix:"Bitcoin Signed Message:\n",bech32:"bcrt",bip32:{public:70617039,private:70615956},pubKeyHash:111,scriptHash:196,wif:239},t.testnet={messagePrefix:"Bitcoin Signed Message:\n",bech32:"tb",bip32:{public:70617039,private:70615956},pubKeyHash:111,scriptHash:196,wif:239}},7334:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.REVERSE_OPS=t.OPS=void 0;const r={OP_FALSE:0,OP_0:0,OP_PUSHDATA1:76,OP_PUSHDATA2:77,OP_PUSHDATA4:78,OP_1NEGATE:79,OP_RESERVED:80,OP_TRUE:81,OP_1:81,OP_2:82,OP_3:83,OP_4:84,OP_5:85,OP_6:86,OP_7:87,OP_8:88,OP_9:89,OP_10:90,OP_11:91,OP_12:92,OP_13:93,OP_14:94,OP_15:95,OP_16:96,OP_NOP:97,OP_VER:98,OP_IF:99,OP_NOTIF:100,OP_VERIF:101,OP_VERNOTIF:102,OP_ELSE:103,OP_ENDIF:104,OP_VERIFY:105,OP_RETURN:106,OP_TOALTSTACK:107,OP_FROMALTSTACK:108,OP_2DROP:109,OP_2DUP:110,OP_3DUP:111,OP_2OVER:112,OP_2ROT:113,OP_2SWAP:114,OP_IFDUP:115,OP_DEPTH:116,OP_DROP:117,OP_DUP:118,OP_NIP:119,OP_OVER:120,OP_PICK:121,OP_ROLL:122,OP_ROT:123,OP_SWAP:124,OP_TUCK:125,OP_CAT:126,OP_SUBSTR:127,OP_LEFT:128,OP_RIGHT:129,OP_SIZE:130,OP_INVERT:131,OP_AND:132,OP_OR:133,OP_XOR:134,OP_EQUAL:135,OP_EQUALVERIFY:136,OP_RESERVED1:137,OP_RESERVED2:138,OP_1ADD:139,OP_1SUB:140,OP_2MUL:141,OP_2DIV:142,OP_NEGATE:143,OP_ABS:144,OP_NOT:145,OP_0NOTEQUAL:146,OP_ADD:147,OP_SUB:148,OP_MUL:149,OP_DIV:150,OP_MOD:151,OP_LSHIFT:152,OP_RSHIFT:153,OP_BOOLAND:154,OP_BOOLOR:155,OP_NUMEQUAL:156,OP_NUMEQUALVERIFY:157,OP_NUMNOTEQUAL:158,OP_LESSTHAN:159,OP_GREATERTHAN:160,OP_LESSTHANOREQUAL:161,OP_GREATERTHANOREQUAL:162,OP_MIN:163,OP_MAX:164,OP_WITHIN:165,OP_RIPEMD160:166,OP_SHA1:167,OP_SHA256:168,OP_HASH160:169,OP_HASH256:170,OP_CODESEPARATOR:171,OP_CHECKSIG:172,OP_CHECKSIGVERIFY:173,OP_CHECKMULTISIG:174,OP_CHECKMULTISIGVERIFY:175,OP_NOP1:176,OP_NOP2:177,OP_CHECKLOCKTIMEVERIFY:177,OP_NOP3:178,OP_CHECKSEQUENCEVERIFY:178,OP_NOP4:179,OP_NOP5:180,OP_NOP6:181,OP_NOP7:182,OP_NOP8:183,OP_NOP9:184,OP_NOP10:185,OP_CHECKSIGADD:186,OP_PUBKEYHASH:253,OP_PUBKEY:254,OP_INVALIDOPCODE:255};t.OPS=r;const n={};t.REVERSE_OPS=n;for(const e of Object.keys(r))n[r[e]]=e},2227:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.tweakKey=t.tapTweakHash=t.tapleafHash=t.findScriptPath=t.toHashTree=t.rootHashFromPath=t.MAX_TAPTREE_DEPTH=t.LEAF_VERSION_TAPSCRIPT=void 0;const n=r(8764),o=r(6379),i=r(5525),a=r(9357),s=r(1838);function c(e){const r=e.version||t.LEAF_VERSION_TAPSCRIPT;return i.taggedHash("TapLeaf",n.Buffer.concat([n.Buffer.from([r]),f(e.output)]))}function u(e,t){return i.taggedHash("TapTweak",n.Buffer.concat(t?[e,t]:[e]))}function l(e,t){return i.taggedHash("TapBranch",n.Buffer.concat([e,t]))}function f(e){const t=a.varuint.encodingLength(e.length),r=n.Buffer.allocUnsafe(t);return a.varuint.encode(e.length,r),n.Buffer.concat([r,e])}t.LEAF_VERSION_TAPSCRIPT=192,t.MAX_TAPTREE_DEPTH=128,t.rootHashFromPath=function(e,t){if(e.length<33)throw new TypeError(`The control-block length is too small. Got ${e.length}, expected min 33.`);const r=(e.length-33)/32;let n=t;for(let t=0;t<r;t++){const r=e.slice(33+32*t,65+32*t);n=n.compare(r)<0?l(n,r):l(r,n)}return n},t.toHashTree=function e(t){if((0,s.isTapleaf)(t))return{hash:c(t)};const r=[e(t[0]),e(t[1])];r.sort((e,t)=>e.hash.compare(t.hash));const[n,o]=r;return{hash:l(n.hash,o.hash),left:n,right:o}},t.findScriptPath=function e(t,r){if("left"in(n=t)&&"right"in n){const n=e(t.left,r);if(void 0!==n)return[...n,t.right.hash];const o=e(t.right,r);if(void 0!==o)return[...o,t.left.hash]}else if(t.hash.equals(r))return[];var n},t.tapleafHash=c,t.tapTweakHash=u,t.tweakKey=function(e,t){if(!n.Buffer.isBuffer(e))return null;if(32!==e.length)return null;if(t&&32!==t.length)return null;const r=u(e,t),i=(0,o.getEccLib)().xOnlyPointAddTweak(e,r);return i&&null!==i.xOnlyPubkey?{parity:i.parity,x:n.Buffer.from(i.xOnlyPubkey)}:null}},6648:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.p2data=void 0;const n=r(4378),o=r(3357),i=r(1838),a=r(2691),s=o.OPS;t.p2data=function(e,t){if(!e.data&&!e.output)throw new TypeError("Not enough data");t=Object.assign({validate:!0},t||{}),(0,i.typeforce)({network:i.typeforce.maybe(i.typeforce.Object),output:i.typeforce.maybe(i.typeforce.Buffer),data:i.typeforce.maybe(i.typeforce.arrayOf(i.typeforce.Buffer))},e);const r={name:"embed",network:e.network||n.bitcoin};if(a.prop(r,"output",()=>{if(e.data)return o.compile([s.OP_RETURN].concat(e.data))}),a.prop(r,"data",()=>{if(e.output)return o.decompile(e.output).slice(1)}),t.validate&&e.output){const t=o.decompile(e.output);if(t[0]!==s.OP_RETURN)throw new TypeError("Output is invalid");if(!t.slice(1).every(i.typeforce.Buffer))throw new TypeError("Output is invalid");if(e.data&&!function(e,t){return e.length===t.length&&e.every((e,r)=>e.equals(t[r]))}(e.data,r.data))throw new TypeError("Data mismatch")}return Object.assign(r,e)}},4972:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.p2tr=t.p2wsh=t.p2wpkh=t.p2sh=t.p2pkh=t.p2pk=t.p2ms=t.embed=void 0;const n=r(6648);Object.defineProperty(t,"embed",{enumerable:!0,get:function(){return n.p2data}});const o=r(8793);Object.defineProperty(t,"p2ms",{enumerable:!0,get:function(){return o.p2ms}});const i=r(7759);Object.defineProperty(t,"p2pk",{enumerable:!0,get:function(){return i.p2pk}});const a=r(4483);Object.defineProperty(t,"p2pkh",{enumerable:!0,get:function(){return a.p2pkh}});const s=r(1160);Object.defineProperty(t,"p2sh",{enumerable:!0,get:function(){return s.p2sh}});const c=r(8810);Object.defineProperty(t,"p2wpkh",{enumerable:!0,get:function(){return c.p2wpkh}});const u=r(6924);Object.defineProperty(t,"p2wsh",{enumerable:!0,get:function(){return u.p2wsh}});const l=r(79);Object.defineProperty(t,"p2tr",{enumerable:!0,get:function(){return l.p2tr}})},2691:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.value=t.prop=void 0,t.prop=function(e,t,r){Object.defineProperty(e,t,{configurable:!0,enumerable:!0,get(){const e=r.call(this);return this[t]=e,e},set(e){Object.defineProperty(this,t,{configurable:!0,enumerable:!0,value:e,writable:!0})}})},t.value=function(e){let t;return()=>(void 0!==t||(t=e()),t)}},8793:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.p2ms=void 0;const n=r(4378),o=r(3357),i=r(1838),a=r(2691),s=o.OPS,c=s.OP_RESERVED;function u(e,t){return e.length===t.length&&e.every((e,r)=>e.equals(t[r]))}t.p2ms=function(e,t){if(!(e.input||e.output||e.pubkeys&&void 0!==e.m||e.signatures))throw new TypeError("Not enough data");function r(e){return o.isCanonicalScriptSignature(e)||void 0!==(t.allowIncomplete&&e===s.OP_0)}t=Object.assign({validate:!0},t||{}),(0,i.typeforce)({network:i.typeforce.maybe(i.typeforce.Object),m:i.typeforce.maybe(i.typeforce.Number),n:i.typeforce.maybe(i.typeforce.Number),output:i.typeforce.maybe(i.typeforce.Buffer),pubkeys:i.typeforce.maybe(i.typeforce.arrayOf(i.isPoint)),signatures:i.typeforce.maybe(i.typeforce.arrayOf(r)),input:i.typeforce.maybe(i.typeforce.Buffer)},e);const l={network:e.network||n.bitcoin};let f=[],h=!1;function d(e){h||(h=!0,f=o.decompile(e),l.m=f[0]-c,l.n=f[f.length-2]-c,l.pubkeys=f.slice(1,-2))}if(a.prop(l,"output",()=>{if(e.m&&l.n&&e.pubkeys)return o.compile([].concat(c+e.m,e.pubkeys,c+l.n,s.OP_CHECKMULTISIG))}),a.prop(l,"m",()=>{if(l.output)return d(l.output),l.m}),a.prop(l,"n",()=>{if(l.pubkeys)return l.pubkeys.length}),a.prop(l,"pubkeys",()=>{if(e.output)return d(e.output),l.pubkeys}),a.prop(l,"signatures",()=>{if(e.input)return o.decompile(e.input).slice(1)}),a.prop(l,"input",()=>{if(e.signatures)return o.compile([s.OP_0].concat(e.signatures))}),a.prop(l,"witness",()=>{if(l.input)return[]}),a.prop(l,"name",()=>{if(l.m&&l.n)return`p2ms(${l.m} of ${l.n})`}),t.validate){if(e.output){if(d(e.output),!i.typeforce.Number(f[0]))throw new TypeError("Output is invalid");if(!i.typeforce.Number(f[f.length-2]))throw new TypeError("Output is invalid");if(f[f.length-1]!==s.OP_CHECKMULTISIG)throw new TypeError("Output is invalid");if(l.m<=0||l.n>16||l.m>l.n||l.n!==f.length-3)throw new TypeError("Output is invalid");if(!l.pubkeys.every(e=>(0,i.isPoint)(e)))throw new TypeError("Output is invalid");if(void 0!==e.m&&e.m!==l.m)throw new TypeError("m mismatch");if(void 0!==e.n&&e.n!==l.n)throw new TypeError("n mismatch");if(e.pubkeys&&!u(e.pubkeys,l.pubkeys))throw new TypeError("Pubkeys mismatch")}if(e.pubkeys){if(void 0!==e.n&&e.n!==e.pubkeys.length)throw new TypeError("Pubkey count mismatch");if(l.n=e.pubkeys.length,l.n<l.m)throw new TypeError("Pubkey count cannot be less than m")}if(e.signatures){if(e.signatures.length<l.m)throw new TypeError("Not enough signatures provided");if(e.signatures.length>l.m)throw new TypeError("Too many signatures provided")}if(e.input){if(e.input[0]!==s.OP_0)throw new TypeError("Input is invalid");if(0===l.signatures.length||!l.signatures.every(r))throw new TypeError("Input has invalid signature(s)");if(e.signatures&&!u(e.signatures,l.signatures))throw new TypeError("Signature mismatch");if(void 0!==e.m&&e.m!==e.signatures.length)throw new TypeError("Signature count mismatch")}}return Object.assign(l,e)}},7759:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.p2pk=void 0;const n=r(4378),o=r(3357),i=r(1838),a=r(2691),s=o.OPS;t.p2pk=function(e,t){if(!(e.input||e.output||e.pubkey||e.input||e.signature))throw new TypeError("Not enough data");t=Object.assign({validate:!0},t||{}),(0,i.typeforce)({network:i.typeforce.maybe(i.typeforce.Object),output:i.typeforce.maybe(i.typeforce.Buffer),pubkey:i.typeforce.maybe(i.isPoint),signature:i.typeforce.maybe(o.isCanonicalScriptSignature),input:i.typeforce.maybe(i.typeforce.Buffer)},e);const r=a.value(()=>o.decompile(e.input)),c={name:"p2pk",network:e.network||n.bitcoin};if(a.prop(c,"output",()=>{if(e.pubkey)return o.compile([e.pubkey,s.OP_CHECKSIG])}),a.prop(c,"pubkey",()=>{if(e.output)return e.output.slice(1,-1)}),a.prop(c,"signature",()=>{if(e.input)return r()[0]}),a.prop(c,"input",()=>{if(e.signature)return o.compile([e.signature])}),a.prop(c,"witness",()=>{if(c.input)return[]}),t.validate){if(e.output){if(e.output[e.output.length-1]!==s.OP_CHECKSIG)throw new TypeError("Output is invalid");if(!(0,i.isPoint)(c.pubkey))throw new TypeError("Output pubkey is invalid");if(e.pubkey&&!e.pubkey.equals(c.pubkey))throw new TypeError("Pubkey mismatch")}if(e.signature&&e.input&&!e.input.equals(c.input))throw new TypeError("Signature mismatch");if(e.input){if(1!==r().length)throw new TypeError("Input is invalid");if(!o.isCanonicalScriptSignature(c.signature))throw new TypeError("Input has invalid signature")}}return Object.assign(c,e)}},4483:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.p2pkh=void 0;const o=r(5525),i=r(4378),a=r(3357),s=r(1838),c=r(2691),u=r(8334),l=a.OPS;t.p2pkh=function(e,t){if(!(e.address||e.hash||e.output||e.pubkey||e.input))throw new TypeError("Not enough data");t=Object.assign({validate:!0},t||{}),(0,s.typeforce)({network:s.typeforce.maybe(s.typeforce.Object),address:s.typeforce.maybe(s.typeforce.String),hash:s.typeforce.maybe(s.typeforce.BufferN(20)),output:s.typeforce.maybe(s.typeforce.BufferN(25)),pubkey:s.typeforce.maybe(s.isPoint),signature:s.typeforce.maybe(a.isCanonicalScriptSignature),input:s.typeforce.maybe(s.typeforce.Buffer)},e);const r=c.value(()=>{const t=n.from(u.decode(e.address));return{version:t.readUInt8(0),hash:t.slice(1)}}),f=c.value(()=>a.decompile(e.input)),h=e.network||i.bitcoin,d={name:"p2pkh",network:h};if(c.prop(d,"address",()=>{if(!d.hash)return;const e=n.allocUnsafe(21);return e.writeUInt8(h.pubKeyHash,0),d.hash.copy(e,1),u.encode(e)}),c.prop(d,"hash",()=>e.output?e.output.slice(3,23):e.address?r().hash:e.pubkey||d.pubkey?o.hash160(e.pubkey||d.pubkey):void 0),c.prop(d,"output",()=>{if(d.hash)return a.compile([l.OP_DUP,l.OP_HASH160,d.hash,l.OP_EQUALVERIFY,l.OP_CHECKSIG])}),c.prop(d,"pubkey",()=>{if(e.input)return f()[1]}),c.prop(d,"signature",()=>{if(e.input)return f()[0]}),c.prop(d,"input",()=>{if(e.pubkey&&e.signature)return a.compile([e.signature,e.pubkey])}),c.prop(d,"witness",()=>{if(d.input)return[]}),t.validate){let t=n.from([]);if(e.address){if(r().version!==h.pubKeyHash)throw new TypeError("Invalid version or Network mismatch");if(20!==r().hash.length)throw new TypeError("Invalid address");t=r().hash}if(e.hash){if(t.length>0&&!t.equals(e.hash))throw new TypeError("Hash mismatch");t=e.hash}if(e.output){if(25!==e.output.length||e.output[0]!==l.OP_DUP||e.output[1]!==l.OP_HASH160||20!==e.output[2]||e.output[23]!==l.OP_EQUALVERIFY||e.output[24]!==l.OP_CHECKSIG)throw new TypeError("Output is invalid");const r=e.output.slice(3,23);if(t.length>0&&!t.equals(r))throw new TypeError("Hash mismatch");t=r}if(e.pubkey){const r=o.hash160(e.pubkey);if(t.length>0&&!t.equals(r))throw new TypeError("Hash mismatch");t=r}if(e.input){const r=f();if(2!==r.length)throw new TypeError("Input is invalid");if(!a.isCanonicalScriptSignature(r[0]))throw new TypeError("Input has invalid signature");if(!(0,s.isPoint)(r[1]))throw new TypeError("Input has invalid pubkey");if(e.signature&&!e.signature.equals(r[0]))throw new TypeError("Signature mismatch");if(e.pubkey&&!e.pubkey.equals(r[1]))throw new TypeError("Pubkey mismatch");const n=o.hash160(r[1]);if(t.length>0&&!t.equals(n))throw new TypeError("Hash mismatch")}}return Object.assign(d,e)}},1160:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.p2sh=void 0;const o=r(5525),i=r(4378),a=r(3357),s=r(1838),c=r(2691),u=r(8334),l=a.OPS;t.p2sh=function(e,t){if(!(e.address||e.hash||e.output||e.redeem||e.input))throw new TypeError("Not enough data");t=Object.assign({validate:!0},t||{}),(0,s.typeforce)({network:s.typeforce.maybe(s.typeforce.Object),address:s.typeforce.maybe(s.typeforce.String),hash:s.typeforce.maybe(s.typeforce.BufferN(20)),output:s.typeforce.maybe(s.typeforce.BufferN(23)),redeem:s.typeforce.maybe({network:s.typeforce.maybe(s.typeforce.Object),output:s.typeforce.maybe(s.typeforce.Buffer),input:s.typeforce.maybe(s.typeforce.Buffer),witness:s.typeforce.maybe(s.typeforce.arrayOf(s.typeforce.Buffer))}),input:s.typeforce.maybe(s.typeforce.Buffer),witness:s.typeforce.maybe(s.typeforce.arrayOf(s.typeforce.Buffer))},e);let r=e.network;r||(r=e.redeem&&e.redeem.network||i.bitcoin);const f={network:r},h=c.value(()=>{const t=n.from(u.decode(e.address));return{version:t.readUInt8(0),hash:t.slice(1)}}),d=c.value(()=>a.decompile(e.input)),p=c.value(()=>{const t=d(),o=t[t.length-1];return{network:r,output:o===l.OP_FALSE?n.from([]):o,input:a.compile(t.slice(0,-1)),witness:e.witness||[]}});if(c.prop(f,"address",()=>{if(!f.hash)return;const e=n.allocUnsafe(21);return e.writeUInt8(f.network.scriptHash,0),f.hash.copy(e,1),u.encode(e)}),c.prop(f,"hash",()=>e.output?e.output.slice(2,22):e.address?h().hash:f.redeem&&f.redeem.output?o.hash160(f.redeem.output):void 0),c.prop(f,"output",()=>{if(f.hash)return a.compile([l.OP_HASH160,f.hash,l.OP_EQUAL])}),c.prop(f,"redeem",()=>{if(e.input)return p()}),c.prop(f,"input",()=>{if(e.redeem&&e.redeem.input&&e.redeem.output)return a.compile([].concat(a.decompile(e.redeem.input),e.redeem.output))}),c.prop(f,"witness",()=>f.redeem&&f.redeem.witness?f.redeem.witness:f.input?[]:void 0),c.prop(f,"name",()=>{const e=["p2sh"];return void 0!==f.redeem&&void 0!==f.redeem.name&&e.push(f.redeem.name),e.join("-")}),t.validate){let t=n.from([]);if(e.address){if(h().version!==r.scriptHash)throw new TypeError("Invalid version or Network mismatch");if(20!==h().hash.length)throw new TypeError("Invalid address");t=h().hash}if(e.hash){if(t.length>0&&!t.equals(e.hash))throw new TypeError("Hash mismatch");t=e.hash}if(e.output){if(23!==e.output.length||e.output[0]!==l.OP_HASH160||20!==e.output[1]||e.output[22]!==l.OP_EQUAL)throw new TypeError("Output is invalid");const r=e.output.slice(2,22);if(t.length>0&&!t.equals(r))throw new TypeError("Hash mismatch");t=r}const i=e=>{if(e.output){const r=a.decompile(e.output);if(!r||r.length<1)throw new TypeError("Redeem.output too short");if(e.output.byteLength>520)throw new TypeError("Redeem.output unspendable if larger than 520 bytes");if(a.countNonPushOnlyOPs(r)>201)throw new TypeError("Redeem.output unspendable with more than 201 non-push ops");const n=o.hash160(e.output);if(t.length>0&&!t.equals(n))throw new TypeError("Hash mismatch");t=n}if(e.input){const t=e.input.length>0,r=e.witness&&e.witness.length>0;if(!t&&!r)throw new TypeError("Empty input");if(t&&r)throw new TypeError("Input and witness provided");if(t){const t=a.decompile(e.input);if(!a.isPushOnly(t))throw new TypeError("Non push-only scriptSig")}}};if(e.input){const e=d();if(!e||e.length<1)throw new TypeError("Input too short");if(!n.isBuffer(p().output))throw new TypeError("Input is invalid");i(p())}if(e.redeem){if(e.redeem.network&&e.redeem.network!==r)throw new TypeError("Network mismatch");if(e.input){const t=p();if(e.redeem.output&&!e.redeem.output.equals(t.output))throw new TypeError("Redeem.output mismatch");if(e.redeem.input&&!e.redeem.input.equals(t.input))throw new TypeError("Redeem.input mismatch")}i(e.redeem)}if(e.witness&&e.redeem&&e.redeem.witness&&!function(e,t){return e.length===t.length&&e.every((e,r)=>e.equals(t[r]))}(e.redeem.witness,e.witness))throw new TypeError("Witness and redeem.witness mismatch")}return Object.assign(f,e)}},79:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.p2tr=void 0;const n=r(8764),o=r(4378),i=r(3357),a=r(1838),s=r(6379),c=r(2227),u=r(2691),l=r(7715),f=i.OPS;t.p2tr=function(e,t){if(!(e.address||e.output||e.pubkey||e.internalPubkey||e.witness&&e.witness.length>1))throw new TypeError("Not enough data");t=Object.assign({validate:!0},t||{}),(0,a.typeforce)({address:a.typeforce.maybe(a.typeforce.String),input:a.typeforce.maybe(a.typeforce.BufferN(0)),network:a.typeforce.maybe(a.typeforce.Object),output:a.typeforce.maybe(a.typeforce.BufferN(34)),internalPubkey:a.typeforce.maybe(a.typeforce.BufferN(32)),hash:a.typeforce.maybe(a.typeforce.BufferN(32)),pubkey:a.typeforce.maybe(a.typeforce.BufferN(32)),signature:a.typeforce.maybe(a.typeforce.anyOf(a.typeforce.BufferN(64),a.typeforce.BufferN(65))),witness:a.typeforce.maybe(a.typeforce.arrayOf(a.typeforce.Buffer)),scriptTree:a.typeforce.maybe(a.isTaptree),redeem:a.typeforce.maybe({output:a.typeforce.maybe(a.typeforce.Buffer),redeemVersion:a.typeforce.maybe(a.typeforce.Number),witness:a.typeforce.maybe(a.typeforce.arrayOf(a.typeforce.Buffer))}),redeemVersion:a.typeforce.maybe(a.typeforce.Number)},e);const r=u.value(()=>{const t=l.bech32m.decode(e.address),r=t.words.shift(),o=l.bech32m.fromWords(t.words);return{version:r,prefix:t.prefix,data:n.Buffer.from(o)}}),h=u.value(()=>{if(e.witness&&e.witness.length)return e.witness.length>=2&&80===e.witness[e.witness.length-1][0]?e.witness.slice(0,-1):e.witness.slice()}),d=u.value(()=>e.scriptTree?(0,c.toHashTree)(e.scriptTree):e.hash?{hash:e.hash}:void 0),p=e.network||o.bitcoin,b={name:"p2tr",network:p};if(u.prop(b,"address",()=>{if(!b.pubkey)return;const e=l.bech32m.toWords(b.pubkey);return e.unshift(1),l.bech32m.encode(p.bech32,e)}),u.prop(b,"hash",()=>{const e=d();if(e)return e.hash;const t=h();if(t&&t.length>1){const e=t[t.length-1],r=e[0]&a.TAPLEAF_VERSION_MASK,n=t[t.length-2],o=(0,c.tapleafHash)({output:n,version:r});return(0,c.rootHashFromPath)(e,o)}return null}),u.prop(b,"output",()=>{if(b.pubkey)return i.compile([f.OP_1,b.pubkey])}),u.prop(b,"redeemVersion",()=>e.redeemVersion?e.redeemVersion:e.redeem&&void 0!==e.redeem.redeemVersion&&null!==e.redeem.redeemVersion?e.redeem.redeemVersion:c.LEAF_VERSION_TAPSCRIPT),u.prop(b,"redeem",()=>{const e=h();if(e&&!(e.length<2))return{output:e[e.length-2],witness:e.slice(0,-2),redeemVersion:e[e.length-1][0]&a.TAPLEAF_VERSION_MASK}}),u.prop(b,"pubkey",()=>{if(e.pubkey)return e.pubkey;if(e.output)return e.output.slice(2);if(e.address)return r().data;if(b.internalPubkey){const e=(0,c.tweakKey)(b.internalPubkey,b.hash);if(e)return e.x}}),u.prop(b,"internalPubkey",()=>{if(e.internalPubkey)return e.internalPubkey;const t=h();return t&&t.length>1?t[t.length-1].slice(1,33):void 0}),u.prop(b,"signature",()=>{if(e.signature)return e.signature;const t=h();return t&&1===t.length?t[0]:void 0}),u.prop(b,"witness",()=>{if(e.witness)return e.witness;const t=d();if(t&&e.redeem&&e.redeem.output&&e.internalPubkey){const r=(0,c.tapleafHash)({output:e.redeem.output,version:b.redeemVersion}),o=(0,c.findScriptPath)(t,r);if(!o)return;const i=(0,c.tweakKey)(e.internalPubkey,t.hash);if(!i)return;const a=n.Buffer.concat([n.Buffer.from([b.redeemVersion|i.parity]),e.internalPubkey].concat(o));return[e.redeem.output,a]}return e.signature?[e.signature]:void 0}),t.validate){let t=n.Buffer.from([]);if(e.address){if(p&&p.bech32!==r().prefix)throw new TypeError("Invalid prefix or Network mismatch");if(1!==r().version)throw new TypeError("Invalid address version");if(32!==r().data.length)throw new TypeError("Invalid address data");t=r().data}if(e.pubkey){if(t.length>0&&!t.equals(e.pubkey))throw new TypeError("Pubkey mismatch");t=e.pubkey}if(e.output){if(34!==e.output.length||e.output[0]!==f.OP_1||32!==e.output[1])throw new TypeError("Output is invalid");if(t.length>0&&!t.equals(e.output.slice(2)))throw new TypeError("Pubkey mismatch");t=e.output.slice(2)}if(e.internalPubkey){const r=(0,c.tweakKey)(e.internalPubkey,b.hash);if(t.length>0&&!t.equals(r.x))throw new TypeError("Pubkey mismatch");t=r.x}if(t&&t.length&&!(0,s.getEccLib)().isXOnlyPoint(t))throw new TypeError("Invalid pubkey for p2tr");const o=d();if(e.hash&&o&&!e.hash.equals(o.hash))throw new TypeError("Hash mismatch");if(e.redeem&&e.redeem.output&&o){const t=(0,c.tapleafHash)({output:e.redeem.output,version:b.redeemVersion});if(!(0,c.findScriptPath)(o,t))throw new TypeError("Redeem script not in tree")}const u=h();if(e.redeem&&b.redeem){if(e.redeem.redeemVersion&&e.redeem.redeemVersion!==b.redeem.redeemVersion)throw new TypeError("Redeem.redeemVersion and witness mismatch");if(e.redeem.output){if(0===i.decompile(e.redeem.output).length)throw new TypeError("Redeem.output is invalid");if(b.redeem.output&&!e.redeem.output.equals(b.redeem.output))throw new TypeError("Redeem.output and witness mismatch")}if(e.redeem.witness&&b.redeem.witness&&!function(e,t){return e.length===t.length&&e.every((e,r)=>e.equals(t[r]))}(e.redeem.witness,b.redeem.witness))throw new TypeError("Redeem.witness and witness mismatch")}if(u&&u.length)if(1===u.length){if(e.signature&&!e.signature.equals(u[0]))throw new TypeError("Signature mismatch")}else{const r=u[u.length-1];if(r.length<33)throw new TypeError(`The control-block length is too small. Got ${r.length}, expected min 33.`);if((r.length-33)%32!=0)throw new TypeError(`The control-block length of ${r.length} is incorrect!`);const n=(r.length-33)/32;if(n>128)throw new TypeError(`The script path is too long. Got ${n}, expected max 128.`);const o=r.slice(1,33);if(e.internalPubkey&&!e.internalPubkey.equals(o))throw new TypeError("Internal pubkey mismatch");if(!(0,s.getEccLib)().isXOnlyPoint(o))throw new TypeError("Invalid internalPubkey for p2tr witness");const i=r[0]&a.TAPLEAF_VERSION_MASK,l=u[u.length-2],f=(0,c.tapleafHash)({output:l,version:i}),h=(0,c.rootHashFromPath)(r,f),d=(0,c.tweakKey)(o,h);if(!d)throw new TypeError("Invalid outputKey for p2tr witness");if(t.length&&!t.equals(d.x))throw new TypeError("Pubkey mismatch for p2tr witness");if(d.parity!==(1&r[0]))throw new Error("Incorrect parity")}}return Object.assign(b,e)}},8810:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.p2wpkh=void 0;const o=r(5525),i=r(4378),a=r(3357),s=r(1838),c=r(2691),u=r(7715),l=a.OPS,f=n.alloc(0);t.p2wpkh=function(e,t){if(!(e.address||e.hash||e.output||e.pubkey||e.witness))throw new TypeError("Not enough data");t=Object.assign({validate:!0},t||{}),(0,s.typeforce)({address:s.typeforce.maybe(s.typeforce.String),hash:s.typeforce.maybe(s.typeforce.BufferN(20)),input:s.typeforce.maybe(s.typeforce.BufferN(0)),network:s.typeforce.maybe(s.typeforce.Object),output:s.typeforce.maybe(s.typeforce.BufferN(22)),pubkey:s.typeforce.maybe(s.isPoint),signature:s.typeforce.maybe(a.isCanonicalScriptSignature),witness:s.typeforce.maybe(s.typeforce.arrayOf(s.typeforce.Buffer))},e);const r=c.value(()=>{const t=u.bech32.decode(e.address),r=t.words.shift(),o=u.bech32.fromWords(t.words);return{version:r,prefix:t.prefix,data:n.from(o)}}),h=e.network||i.bitcoin,d={name:"p2wpkh",network:h};if(c.prop(d,"address",()=>{if(!d.hash)return;const e=u.bech32.toWords(d.hash);return e.unshift(0),u.bech32.encode(h.bech32,e)}),c.prop(d,"hash",()=>e.output?e.output.slice(2,22):e.address?r().data:e.pubkey||d.pubkey?o.hash160(e.pubkey||d.pubkey):void 0),c.prop(d,"output",()=>{if(d.hash)return a.compile([l.OP_0,d.hash])}),c.prop(d,"pubkey",()=>e.pubkey?e.pubkey:e.witness?e.witness[1]:void 0),c.prop(d,"signature",()=>{if(e.witness)return e.witness[0]}),c.prop(d,"input",()=>{if(d.witness)return f}),c.prop(d,"witness",()=>{if(e.pubkey&&e.signature)return[e.signature,e.pubkey]}),t.validate){let t=n.from([]);if(e.address){if(h&&h.bech32!==r().prefix)throw new TypeError("Invalid prefix or Network mismatch");if(0!==r().version)throw new TypeError("Invalid address version");if(20!==r().data.length)throw new TypeError("Invalid address data");t=r().data}if(e.hash){if(t.length>0&&!t.equals(e.hash))throw new TypeError("Hash mismatch");t=e.hash}if(e.output){if(22!==e.output.length||e.output[0]!==l.OP_0||20!==e.output[1])throw new TypeError("Output is invalid");if(t.length>0&&!t.equals(e.output.slice(2)))throw new TypeError("Hash mismatch");t=e.output.slice(2)}if(e.pubkey){const r=o.hash160(e.pubkey);if(t.length>0&&!t.equals(r))throw new TypeError("Hash mismatch");if(t=r,!(0,s.isPoint)(e.pubkey)||33!==e.pubkey.length)throw new TypeError("Invalid pubkey for p2wpkh")}if(e.witness){if(2!==e.witness.length)throw new TypeError("Witness is invalid");if(!a.isCanonicalScriptSignature(e.witness[0]))throw new TypeError("Witness has invalid signature");if(!(0,s.isPoint)(e.witness[1])||33!==e.witness[1].length)throw new TypeError("Witness has invalid pubkey");if(e.signature&&!e.signature.equals(e.witness[0]))throw new TypeError("Signature mismatch");if(e.pubkey&&!e.pubkey.equals(e.witness[1]))throw new TypeError("Pubkey mismatch");const r=o.hash160(e.witness[1]);if(t.length>0&&!t.equals(r))throw new TypeError("Hash mismatch")}}return Object.assign(d,e)}},6924:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.p2wsh=void 0;const o=r(5525),i=r(4378),a=r(3357),s=r(1838),c=r(2691),u=r(7715),l=a.OPS,f=n.alloc(0);function h(e){return!(!n.isBuffer(e)||65!==e.length||4!==e[0]||!(0,s.isPoint)(e))}t.p2wsh=function(e,t){if(!(e.address||e.hash||e.output||e.redeem||e.witness))throw new TypeError("Not enough data");t=Object.assign({validate:!0},t||{}),(0,s.typeforce)({network:s.typeforce.maybe(s.typeforce.Object),address:s.typeforce.maybe(s.typeforce.String),hash:s.typeforce.maybe(s.typeforce.BufferN(32)),output:s.typeforce.maybe(s.typeforce.BufferN(34)),redeem:s.typeforce.maybe({input:s.typeforce.maybe(s.typeforce.Buffer),network:s.typeforce.maybe(s.typeforce.Object),output:s.typeforce.maybe(s.typeforce.Buffer),witness:s.typeforce.maybe(s.typeforce.arrayOf(s.typeforce.Buffer))}),input:s.typeforce.maybe(s.typeforce.BufferN(0)),witness:s.typeforce.maybe(s.typeforce.arrayOf(s.typeforce.Buffer))},e);const r=c.value(()=>{const t=u.bech32.decode(e.address),r=t.words.shift(),o=u.bech32.fromWords(t.words);return{version:r,prefix:t.prefix,data:n.from(o)}}),d=c.value(()=>a.decompile(e.redeem.input));let p=e.network;p||(p=e.redeem&&e.redeem.network||i.bitcoin);const b={network:p};if(c.prop(b,"address",()=>{if(!b.hash)return;const e=u.bech32.toWords(b.hash);return e.unshift(0),u.bech32.encode(p.bech32,e)}),c.prop(b,"hash",()=>e.output?e.output.slice(2):e.address?r().data:b.redeem&&b.redeem.output?o.sha256(b.redeem.output):void 0),c.prop(b,"output",()=>{if(b.hash)return a.compile([l.OP_0,b.hash])}),c.prop(b,"redeem",()=>{if(e.witness)return{output:e.witness[e.witness.length-1],input:f,witness:e.witness.slice(0,-1)}}),c.prop(b,"input",()=>{if(b.witness)return f}),c.prop(b,"witness",()=>{if(e.redeem&&e.redeem.input&&e.redeem.input.length>0&&e.redeem.output&&e.redeem.output.length>0){const t=a.toStack(d());return b.redeem=Object.assign({witness:t},e.redeem),b.redeem.input=f,[].concat(t,e.redeem.output)}if(e.redeem&&e.redeem.output&&e.redeem.witness)return[].concat(e.redeem.witness,e.redeem.output)}),c.prop(b,"name",()=>{const e=["p2wsh"];return void 0!==b.redeem&&void 0!==b.redeem.name&&e.push(b.redeem.name),e.join("-")}),t.validate){let t=n.from([]);if(e.address){if(r().prefix!==p.bech32)throw new TypeError("Invalid prefix or Network mismatch");if(0!==r().version)throw new TypeError("Invalid address version");if(32!==r().data.length)throw new TypeError("Invalid address data");t=r().data}if(e.hash){if(t.length>0&&!t.equals(e.hash))throw new TypeError("Hash mismatch");t=e.hash}if(e.output){if(34!==e.output.length||e.output[0]!==l.OP_0||32!==e.output[1])throw new TypeError("Output is invalid");const r=e.output.slice(2);if(t.length>0&&!t.equals(r))throw new TypeError("Hash mismatch");t=r}if(e.redeem){if(e.redeem.network&&e.redeem.network!==p)throw new TypeError("Network mismatch");if(e.redeem.input&&e.redeem.input.length>0&&e.redeem.witness&&e.redeem.witness.length>0)throw new TypeError("Ambiguous witness source");if(e.redeem.output){const r=a.decompile(e.redeem.output);if(!r||r.length<1)throw new TypeError("Redeem.output is invalid");if(e.redeem.output.byteLength>3600)throw new TypeError("Redeem.output unspendable if larger than 3600 bytes");if(a.countNonPushOnlyOPs(r)>201)throw new TypeError("Redeem.output unspendable with more than 201 non-push ops");const n=o.sha256(e.redeem.output);if(t.length>0&&!t.equals(n))throw new TypeError("Hash mismatch");t=n}if(e.redeem.input&&!a.isPushOnly(d()))throw new TypeError("Non push-only scriptSig");if(e.witness&&e.redeem.witness&&!function(e,t){return e.length===t.length&&e.every((e,r)=>e.equals(t[r]))}(e.witness,e.redeem.witness))throw new TypeError("Witness and redeem.witness mismatch");if(e.redeem.input&&d().some(h)||e.redeem.output&&(a.decompile(e.redeem.output)||[]).some(h))throw new TypeError("redeem.input or redeem.output contains uncompressed pubkey")}if(e.witness&&e.witness.length>0){const t=e.witness[e.witness.length-1];if(e.redeem&&e.redeem.output&&!e.redeem.output.equals(t))throw new TypeError("Witness and redeem.output mismatch");if(e.witness.some(h)||(a.decompile(t)||[]).some(h))throw new TypeError("Witness contains uncompressed pubkey")}}return Object.assign(b,e)}},9930:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.Psbt=void 0;const o=r(5011),i=r(3493),a=r(6403),s=r(5488),c=r(9357),u=r(4378),l=r(4972),f=r(2227),h=r(3357),d=r(2737),p=r(3064),b=r(7929),g={network:u.bitcoin,maximumFeeRate:5e3};class y{static fromBase64(e,t={}){const r=n.from(e,"base64");return this.fromBuffer(r,t)}static fromHex(e,t={}){const r=n.from(e,"hex");return this.fromBuffer(r,t)}static fromBuffer(e,t={}){const r=o.Psbt.fromBuffer(e,m),n=new y(t,r);var i,a;return i=n.__CACHE.__TX,a=n.__CACHE,i.ins.forEach(e=>{I(a,e)}),n}constructor(e={},t=new o.Psbt(new v)){this.data=t,this.opts=Object.assign({},g,e),this.__CACHE={__NON_WITNESS_UTXO_TX_CACHE:[],__NON_WITNESS_UTXO_BUF_CACHE:[],__TX_IN_CACHE:{},__TX:this.data.globalMap.unsignedTx.tx,__UNSAFE_SIGN_NONSEGWIT:!1},0===this.data.inputs.length&&this.setVersion(2);const r=(e,t,r,n)=>Object.defineProperty(e,t,{enumerable:r,writable:n});r(this,"__CACHE",!1,!0),r(this,"opts",!1,!0)}get inputCount(){return this.data.inputs.length}get version(){return this.__CACHE.__TX.version}set version(e){this.setVersion(e)}get locktime(){return this.__CACHE.__TX.locktime}set locktime(e){this.setLocktime(e)}get txInputs(){return this.__CACHE.__TX.ins.map(e=>({hash:(0,c.cloneBuffer)(e.hash),index:e.index,sequence:e.sequence}))}get txOutputs(){return this.__CACHE.__TX.outs.map(e=>{let t;try{t=(0,s.fromOutputScript)(e.script,this.opts.network)}catch(e){}return{script:(0,c.cloneBuffer)(e.script),value:e.value,address:t}})}combine(...e){return this.data.combine(...e.map(e=>e.data)),this}clone(){const e=y.fromBuffer(this.data.toBuffer());return e.opts=JSON.parse(JSON.stringify(this.opts)),e}setMaximumFeeRate(e){k(e),this.opts.maximumFeeRate=e}setVersion(e){k(e),A(this.data.inputs,"setVersion");const t=this.__CACHE;return t.__TX.version=e,t.__EXTRACTED_TX=void 0,this}setLocktime(e){k(e),A(this.data.inputs,"setLocktime");const t=this.__CACHE;return t.__TX.locktime=e,t.__EXTRACTED_TX=void 0,this}setInputSequence(e,t){k(t),A(this.data.inputs,"setInputSequence");const r=this.__CACHE;if(r.__TX.ins.length<=e)throw new Error("Input index too high");return r.__TX.ins[e].sequence=t,r.__EXTRACTED_TX=void 0,this}addInputs(e){return e.forEach(e=>this.addInput(e)),this}addInput(e){if(arguments.length>1||!e||void 0===e.hash||void 0===e.index)throw new Error("Invalid arguments for Psbt.addInput. Requires single object with at least [hash] and [index]");(0,p.checkTaprootInputFields)(e,e,"addInput"),A(this.data.inputs,"addInput"),e.witnessScript&&$(e.witnessScript);const t=this.__CACHE;this.data.addInput(e),I(t,t.__TX.ins[t.__TX.ins.length-1]);const r=this.data.inputs.length-1,n=this.data.inputs[r];return n.nonWitnessUtxo&&V(this.__CACHE,n,r),t.__FEE=void 0,t.__FEE_RATE=void 0,t.__EXTRACTED_TX=void 0,this}addOutputs(e){return e.forEach(e=>this.addOutput(e)),this}addOutput(e){if(arguments.length>1||!e||void 0===e.value||void 0===e.address&&void 0===e.script)throw new Error("Invalid arguments for Psbt.addOutput. Requires single object with at least [script or address] and [value]");A(this.data.inputs,"addOutput");const{address:t}=e;if("string"==typeof t){const{network:r}=this.opts,n=(0,s.toOutputScript)(t,r);e=Object.assign(e,{script:n})}(0,p.checkTaprootOutputFields)(e,e,"addOutput");const r=this.__CACHE;return this.data.addOutput(e),r.__FEE=void 0,r.__FEE_RATE=void 0,r.__EXTRACTED_TX=void 0,this}extractTransaction(e){if(!this.data.inputs.every(S))throw new Error("Not finalized");const t=this.__CACHE;if(e||function(e,t,r){const n=t.__FEE_RATE||e.getFeeRate(),o=t.__EXTRACTED_TX.virtualSize(),i=n*o;if(n>=r.maximumFeeRate)throw new Error(`Warning: You are paying around ${(i/1e8).toFixed(8)} in fees, which is ${n} satoshi per byte for a transaction with a VSize of ${o} bytes (segwit counted as 0.25 byte per byte). Use setMaximumFeeRate method to raise your threshold, or pass true to the first arg of extractTransaction.`)}(this,t,this.opts),t.__EXTRACTED_TX)return t.__EXTRACTED_TX;const r=t.__TX.clone();return D(this.data.inputs,r,t,!0),r}getFeeRate(){return O("__FEE_RATE","fee rate",this.data.inputs,this.__CACHE)}getFee(){return O("__FEE","fee",this.data.inputs,this.__CACHE)}finalizeAllInputs(){return(0,a.checkForInput)(this.data.inputs,0),Y(this.data.inputs.length).forEach(e=>this.finalizeInput(e)),this}finalizeInput(e,t){const r=(0,a.checkForInput)(this.data.inputs,e);return(0,p.isTaprootInput)(r)?this._finalizeTaprootInput(e,r,void 0,t):this._finalizeInput(e,r,t)}finalizeTaprootInput(e,t,r=p.tapScriptFinalizer){const n=(0,a.checkForInput)(this.data.inputs,e);if((0,p.isTaprootInput)(n))return this._finalizeTaprootInput(e,n,t,r);throw new Error(`Cannot finalize input #${e}. Not Taproot.`)}_finalizeInput(e,t,r=P){const{script:n,isP2SH:o,isP2WSH:i,isSegwit:a}=function(e,t,r){const n=r.__TX,o={script:null,isSegwit:!1,isP2SH:!1,isP2WSH:!1};if(o.isP2SH=!!t.redeemScript,o.isP2WSH=!!t.witnessScript,t.witnessScript)o.script=t.witnessScript;else if(t.redeemScript)o.script=t.redeemScript;else if(t.nonWitnessUtxo){const i=F(r,t,e),a=n.ins[e].index;o.script=i.outs[a].script}else t.witnessUtxo&&(o.script=t.witnessUtxo.script);return(t.witnessScript||(0,b.isP2WPKH)(o.script))&&(o.isSegwit=!0),o}(e,t,this.__CACHE);if(!n)throw new Error(`No script found for input #${e}`);!function(e){if(!e.sighashType||!e.partialSig)return;const{partialSig:t,sighashType:r}=e;t.forEach(e=>{const{hashType:t}=h.signature.decode(e.signature);if(r!==t)throw new Error("Signature sighash does not match input sighash type")})}(t);const{finalScriptSig:s,finalScriptWitness:c}=r(e,t,n,a,o,i);if(s&&this.data.updateInput(e,{finalScriptSig:s}),c&&this.data.updateInput(e,{finalScriptWitness:c}),!s&&!c)throw new Error(`Unknown error finalizing input #${e}`);return this.data.clearFinalizedInput(e),this}_finalizeTaprootInput(e,t,r,n=p.tapScriptFinalizer){if(!t.witnessUtxo)throw new Error(`Cannot finalize input #${e}. Missing withness utxo.`);if(t.tapKeySig){const r=l.p2tr({output:t.witnessUtxo.script,signature:t.tapKeySig}),n=(0,b.witnessStackToScriptWitness)(r.witness);this.data.updateInput(e,{finalScriptWitness:n})}else{const{finalScriptWitness:o}=n(e,t,r);this.data.updateInput(e,{finalScriptWitness:o})}return this.data.clearFinalizedInput(e),this}getInputType(e){const t=(0,a.checkForInput)(this.data.inputs,e),r=W(q(e,t,this.__CACHE),e,"input",t.redeemScript||function(e){if(!e)return;const t=h.decompile(e);if(!t)return;const r=t[t.length-1];var o;if(n.isBuffer(r)&&!G(r)&&(o=r,!h.isCanonicalScriptSignature(o))&&h.decompile(r))return r}(t.finalScriptSig),t.witnessScript||function(e){if(!e)return;const t=M(e),r=t[t.length-1];return!G(r)&&h.decompile(r)?r:void 0}(t.finalScriptWitness));return("raw"===r.type?"":r.type+"-")+X(r.meaningfulScript)}inputHasPubkey(e,t){return function(e,t,r,n){const o=q(r,t,n),{meaningfulScript:i}=W(o,r,"input",t.redeemScript,t.witnessScript);return(0,b.pubkeyInScript)(e,i)}(t,(0,a.checkForInput)(this.data.inputs,e),e,this.__CACHE)}inputHasHDKey(e,t){const r=(0,a.checkForInput)(this.data.inputs,e),n=E(t);return!!r.bip32Derivation&&r.bip32Derivation.some(n)}outputHasPubkey(e,t){return function(e,t,r,n){const o=n.__TX.outs[r].script,{meaningfulScript:i}=W(o,r,"output",t.redeemScript,t.witnessScript);return(0,b.pubkeyInScript)(e,i)}(t,(0,a.checkForOutput)(this.data.outputs,e),e,this.__CACHE)}outputHasHDKey(e,t){const r=(0,a.checkForOutput)(this.data.outputs,e),n=E(t);return!!r.bip32Derivation&&r.bip32Derivation.some(n)}validateSignaturesOfAllInputs(e){return(0,a.checkForInput)(this.data.inputs,0),Y(this.data.inputs.length).map(t=>this.validateSignaturesOfInput(t,e)).reduce((e,t)=>!0===t&&e,!0)}validateSignaturesOfInput(e,t,r){const n=this.data.inputs[e];return(0,p.isTaprootInput)(n)?this.validateSignaturesOfTaprootInput(e,t,r):this._validateSignaturesOfInput(e,t,r)}_validateSignaturesOfInput(e,t,r){const n=this.data.inputs[e],o=(n||{}).partialSig;if(!n||!o||o.length<1)throw new Error("No signatures to validate");if("function"!=typeof t)throw new Error("Need validator function to validate signatures");const i=r?o.filter(e=>e.pubkey.equals(r)):o;if(i.length<1)throw new Error("No signatures for this pubkey");const a=[];let s,c,u;for(const r of i){const o=h.signature.decode(r.signature),{hash:i,script:l}=u!==o.hashType?U(e,Object.assign({},n,{sighashType:o.hashType}),this.__CACHE,!0):{hash:s,script:c};u=o.hashType,s=i,c=l,x(r.pubkey,l,"verify"),a.push(t(r.pubkey,i,o.signature))}return a.every(e=>!0===e)}validateSignaturesOfTaprootInput(e,t,r){const n=this.data.inputs[e],o=(n||{}).tapKeySig,i=(n||{}).tapScriptSig;if(!n&&!o&&(!i||i.length))throw new Error("No signatures to validate");if("function"!=typeof t)throw new Error("Need validator function to validate signatures");const a=(r=r&&(0,p.toXOnly)(r))?R(e,n,this.data.inputs,r,this.__CACHE):function(e,t,r,n){const o=[];if(t.tapInternalKey){const r=j(e,t,n);r&&o.push(r)}if(t.tapScriptSig){const e=t.tapScriptSig.map(e=>e.pubkey);o.push(...e)}return o.map(o=>R(e,t,r,o,n)).flat()}(e,n,this.data.inputs,this.__CACHE);if(!a.length)throw new Error("No signatures for this pubkey");const s=a.find(e=>!e.leafHash);let c=0;if(o&&s){if(!t(s.pubkey,s.hash,C(o)))return!1;c++}if(i)for(const e of i){const r=a.find(t=>e.pubkey.equals(t.pubkey));if(r){if(!t(e.pubkey,r.hash,C(e.signature)))return!1;c++}}return c>0}signAllInputsHD(e,t=[d.Transaction.SIGHASH_ALL]){if(!e||!e.publicKey||!e.fingerprint)throw new Error("Need HDSigner to sign input");const r=[];for(const n of Y(this.data.inputs.length))try{this.signInputHD(n,e,t),r.push(!0)}catch(e){r.push(!1)}if(r.every(e=>!1===e))throw new Error("No inputs were signed");return this}signAllInputsHDAsync(e,t=[d.Transaction.SIGHASH_ALL]){return new Promise((r,n)=>{if(!e||!e.publicKey||!e.fingerprint)return n(new Error("Need HDSigner to sign input"));const o=[],i=[];for(const r of Y(this.data.inputs.length))i.push(this.signInputHDAsync(r,e,t).then(()=>{o.push(!0)},()=>{o.push(!1)}));return Promise.all(i).then(()=>{if(o.every(e=>!1===e))return n(new Error("No inputs were signed"));r()})})}signInputHD(e,t,r=[d.Transaction.SIGHASH_ALL]){if(!t||!t.publicKey||!t.fingerprint)throw new Error("Need HDSigner to sign input");return N(e,this.data.inputs,t).forEach(t=>this.signInput(e,t,r)),this}signInputHDAsync(e,t,r=[d.Transaction.SIGHASH_ALL]){return new Promise((n,o)=>{if(!t||!t.publicKey||!t.fingerprint)return o(new Error("Need HDSigner to sign input"));const i=N(e,this.data.inputs,t).map(t=>this.signInputAsync(e,t,r));return Promise.all(i).then(()=>{n()}).catch(o)})}signAllInputs(e,t){if(!e||!e.publicKey)throw new Error("Need Signer to sign input");const r=[];for(const n of Y(this.data.inputs.length))try{this.signInput(n,e,t),r.push(!0)}catch(e){r.push(!1)}if(r.every(e=>!1===e))throw new Error("No inputs were signed");return this}signAllInputsAsync(e,t){return new Promise((r,n)=>{if(!e||!e.publicKey)return n(new Error("Need Signer to sign input"));const o=[],i=[];for(const[r]of this.data.inputs.entries())i.push(this.signInputAsync(r,e,t).then(()=>{o.push(!0)},()=>{o.push(!1)}));return Promise.all(i).then(()=>{if(o.every(e=>!1===e))return n(new Error("No inputs were signed"));r()})})}signInput(e,t,r){if(!t||!t.publicKey)throw new Error("Need Signer to sign input");const n=(0,a.checkForInput)(this.data.inputs,e);return(0,p.isTaprootInput)(n)?this._signTaprootInput(e,n,t,void 0,r):this._signInput(e,t,r)}signTaprootInput(e,t,r,n){if(!t||!t.publicKey)throw new Error("Need Signer to sign input");const o=(0,a.checkForInput)(this.data.inputs,e);if((0,p.isTaprootInput)(o))return this._signTaprootInput(e,o,t,r,n);throw new Error(`Input #${e} is not of type Taproot.`)}_signInput(e,t,r=[d.Transaction.SIGHASH_ALL]){const{hash:n,sighashType:o}=L(this.data.inputs,e,t.publicKey,this.__CACHE,r),i=[{pubkey:t.publicKey,signature:h.signature.encode(t.sign(n),o)}];return this.data.updateInput(e,{partialSig:i}),this}_signTaprootInput(e,t,r,n,o=[d.Transaction.SIGHASH_DEFAULT]){const i=this.checkTaprootHashesForSig(e,t,r,n,o),a=i.filter(e=>!e.leafHash).map(e=>(0,p.serializeTaprootSignature)(r.signSchnorr(e.hash),t.sighashType))[0],s=i.filter(e=>!!e.leafHash).map(e=>({pubkey:(0,p.toXOnly)(r.publicKey),signature:(0,p.serializeTaprootSignature)(r.signSchnorr(e.hash),t.sighashType),leafHash:e.leafHash}));return a&&this.data.updateInput(e,{tapKeySig:a}),s.length&&this.data.updateInput(e,{tapScriptSig:s}),this}signInputAsync(e,t,r){return Promise.resolve().then(()=>{if(!t||!t.publicKey)throw new Error("Need Signer to sign input");const n=(0,a.checkForInput)(this.data.inputs,e);return(0,p.isTaprootInput)(n)?this._signTaprootInputAsync(e,n,t,void 0,r):this._signInputAsync(e,t,r)})}signTaprootInputAsync(e,t,r,n){return Promise.resolve().then(()=>{if(!t||!t.publicKey)throw new Error("Need Signer to sign input");const o=(0,a.checkForInput)(this.data.inputs,e);if((0,p.isTaprootInput)(o))return this._signTaprootInputAsync(e,o,t,r,n);throw new Error(`Input #${e} is not of type Taproot.`)})}_signInputAsync(e,t,r=[d.Transaction.SIGHASH_ALL]){const{hash:n,sighashType:o}=L(this.data.inputs,e,t.publicKey,this.__CACHE,r);return Promise.resolve(t.sign(n)).then(r=>{const n=[{pubkey:t.publicKey,signature:h.signature.encode(r,o)}];this.data.updateInput(e,{partialSig:n})})}async _signTaprootInputAsync(e,t,r,n,o=[d.Transaction.SIGHASH_DEFAULT]){const i=this.checkTaprootHashesForSig(e,t,r,n,o),a=[],s=i.filter(e=>!e.leafHash)[0];if(s){const e=Promise.resolve(r.signSchnorr(s.hash)).then(e=>({tapKeySig:(0,p.serializeTaprootSignature)(e,t.sighashType)}));a.push(e)}const c=i.filter(e=>!!e.leafHash);if(c.length){const e=c.map(e=>Promise.resolve(r.signSchnorr(e.hash)).then(n=>({tapScriptSig:[{pubkey:(0,p.toXOnly)(r.publicKey),signature:(0,p.serializeTaprootSignature)(n,t.sighashType),leafHash:e.leafHash}]})));a.push(...e)}return Promise.all(a).then(t=>{t.forEach(t=>this.data.updateInput(e,t))})}checkTaprootHashesForSig(e,t,r,n,o){if("function"!=typeof r.signSchnorr)throw new Error(`Need Schnorr Signer to sign taproot input #${e}.`);const i=R(e,t,this.data.inputs,r.publicKey,this.__CACHE,n,o);if(!i||!i.length)throw new Error(`Can not sign for input #${e} with the key ${r.publicKey.toString("hex")}`);return i}toBuffer(){return w(this.__CACHE),this.data.toBuffer()}toHex(){return w(this.__CACHE),this.data.toHex()}toBase64(){return w(this.__CACHE),this.data.toBase64()}updateGlobal(e){return this.data.updateGlobal(e),this}updateInput(e,t){return t.witnessScript&&$(t.witnessScript),(0,p.checkTaprootInputFields)(this.data.inputs[e],t,"updateInput"),this.data.updateInput(e,t),t.nonWitnessUtxo&&V(this.__CACHE,this.data.inputs[e],e),this}updateOutput(e,t){const r=this.data.outputs[e];return(0,p.checkTaprootOutputFields)(r,t,"updateOutput"),this.data.updateOutput(e,t),this}addUnknownKeyValToGlobal(e){return this.data.addUnknownKeyValToGlobal(e),this}addUnknownKeyValToInput(e,t){return this.data.addUnknownKeyValToInput(e,t),this}addUnknownKeyValToOutput(e,t){return this.data.addUnknownKeyValToOutput(e,t),this}clearFinalizedInput(e){return this.data.clearFinalizedInput(e),this}}t.Psbt=y;const m=e=>new v(e);class v{constructor(e=n.from([2,0,0,0,0,0,0,0,0,0])){this.tx=d.Transaction.fromBuffer(e),function(e){if(!e.ins.every(e=>e.script&&0===e.script.length&&e.witness&&0===e.witness.length))throw new Error("Format Error: Transaction ScriptSigs are not empty")}(this.tx),Object.defineProperty(this,"tx",{enumerable:!1,writable:!0})}getInputOutputCounts(){return{inputCount:this.tx.ins.length,outputCount:this.tx.outs.length}}addInput(e){if(void 0===e.hash||void 0===e.index||!n.isBuffer(e.hash)&&"string"!=typeof e.hash||"number"!=typeof e.index)throw new Error("Error adding input.");const t="string"==typeof e.hash?(0,c.reverseBuffer)(n.from(e.hash,"hex")):e.hash;this.tx.addInput(t,e.index,e.sequence)}addOutput(e){if(void 0===e.script||void 0===e.value||!n.isBuffer(e.script)||"number"!=typeof e.value)throw new Error("Error adding output.");this.tx.addOutput(e.script,e.value)}toBuffer(){return this.tx.toBuffer()}}function w(e){if(!1!==e.__UNSAFE_SIGN_NONSEGWIT)throw new Error("Not BIP174 compliant, can not export")}function _(e,t,r){if(!t)return!1;let n;if(n=r?r.map(e=>{const r=function(e){if(65===e.length){const t=1&e[64],r=e.slice(0,33);return r[0]=2|t,r}return e.slice()}(e);return t.find(e=>e.pubkey.equals(r))}).filter(e=>!!e):t,n.length>e)throw new Error("Too many signatures");return n.length===e}function S(e){return!!e.finalScriptSig||!!e.finalScriptWitness}function E(e){return t=>!!t.masterFingerprint.equals(e.fingerprint)&&!!e.derivePath(t.path).publicKey.equals(t.pubkey)}function k(e){if("number"!=typeof e||e!==Math.floor(e)||e>4294967295||e<0)throw new Error("Invalid 32 bit integer")}function A(e,t){e.forEach(e=>{if((0,p.isTaprootInput)(e)?(0,p.checkTaprootInputForSigs)(e,t):(0,b.checkInputForSig)(e,t))throw new Error("Can not modify transaction, signatures exist.")})}function x(e,t,r){if(!(0,b.pubkeyInScript)(e,t))throw new Error(`Can not ${r} for this input with the key ${e.toString("hex")}`)}function I(e,t){const r=(0,c.reverseBuffer)(n.from(t.hash)).toString("hex")+":"+t.index;if(e.__TX_IN_CACHE[r])throw new Error("Duplicate input detected.");e.__TX_IN_CACHE[r]=1}function B(e,t){return(r,n,o,i)=>{const a=e({redeem:{output:o}}).output;if(!n.equals(a))throw new Error(`${t} for ${i} #${r} doesn't match the scriptPubKey in the prevout`)}}const T=B(l.p2sh,"Redeem script"),H=B(l.p2wsh,"Witness script");function O(e,t,r,n){if(!r.every(S))throw new Error(`PSBT must be finalized to calculate ${t}`);if("__FEE_RATE"===e&&n.__FEE_RATE)return n.__FEE_RATE;if("__FEE"===e&&n.__FEE)return n.__FEE;let o,i=!0;return n.__EXTRACTED_TX?(o=n.__EXTRACTED_TX,i=!1):o=n.__TX.clone(),D(r,o,n,i),"__FEE_RATE"===e?n.__FEE_RATE:"__FEE"===e?n.__FEE:void 0}function P(e,t,r,n,o,i){const a=X(r);if(!function(e,t,r){switch(r){case"pubkey":case"pubkeyhash":case"witnesspubkeyhash":return _(1,e.partialSig);case"multisig":const r=l.p2ms({output:t});return _(r.m,e.partialSig,r.pubkeys);default:return!1}}(t,r,a))throw new Error(`Can not finalize input #${e}`);return function(e,t,r,n,o,i){let a,s;const c=function(e,t,r){let n;switch(t){case"multisig":const t=function(e,t){return l.p2ms({output:e}).pubkeys.map(e=>(t.filter(t=>t.pubkey.equals(e))[0]||{}).signature).filter(e=>!!e)}(e,r);n=l.p2ms({output:e,signatures:t});break;case"pubkey":n=l.p2pk({output:e,signature:r[0].signature});break;case"pubkeyhash":n=l.p2pkh({output:e,pubkey:r[0].pubkey,signature:r[0].signature});break;case"witnesspubkeyhash":n=l.p2wpkh({output:e,pubkey:r[0].pubkey,signature:r[0].signature})}return n}(e,t,r),u=i?l.p2wsh({redeem:c}):null,f=o?l.p2sh({redeem:u||c}):null;return n?(s=u?(0,b.witnessStackToScriptWitness)(u.witness):(0,b.witnessStackToScriptWitness)(c.witness),f&&(a=f.input)):a=f?f.input:c.input,{finalScriptSig:a,finalScriptWitness:s}}(r,a,t.partialSig,n,o,i)}function L(e,t,r,n,o){const i=(0,a.checkForInput)(e,t),{hash:s,sighashType:c,script:u}=U(t,i,n,!1,o);return x(r,u,"sign"),{hash:s,sighashType:c}}function U(e,t,r,n,o){const i=r.__TX,a=t.sighashType||d.Transaction.SIGHASH_ALL;let s,c;if(z(a,o),t.nonWitnessUtxo){const n=F(r,t,e),o=i.ins[e].hash,a=n.getHash();if(!o.equals(a))throw new Error(`Non-witness UTXO hash for input #${e} doesn't match the hash specified in the prevout`);const s=i.ins[e].index;c=n.outs[s]}else{if(!t.witnessUtxo)throw new Error("Need a Utxo input item for signing");c=t.witnessUtxo}const{meaningfulScript:u,type:f}=W(c.script,e,"input",t.redeemScript,t.witnessScript);if(["p2sh-p2wsh","p2wsh"].indexOf(f)>=0)s=i.hashForWitnessV0(e,u,c.value,a);else if((0,b.isP2WPKH)(u)){const t=l.p2pkh({hash:u.slice(2)}).output;s=i.hashForWitnessV0(e,t,c.value,a)}else{if(void 0===t.nonWitnessUtxo&&!1===r.__UNSAFE_SIGN_NONSEGWIT)throw new Error(`Input #${e} has witnessUtxo but non-segwit script: ${u.toString("hex")}`);n||!1===r.__UNSAFE_SIGN_NONSEGWIT||console.warn("Warning: Signing non-segwit inputs without the full parent transaction means there is a chance that a miner could feed you incorrect information to trick you into paying large fees. This behavior is the same as Psbt's predecesor (TransactionBuilder - now removed) when signing non-segwit scripts. You are not able to export this Psbt with toBuffer|toBase64|toHex since it is not BIP174 compliant.\n*********************\nPROCEED WITH CAUTION!\n*********************"),s=i.hashForSignature(e,u,a)}return{script:u,sighashType:a,hash:s}}function j(e,t,r){const{script:n}=K(e,t,r);return(0,b.isP2TR)(n)?n.subarray(2,34):null}function C(e){return 64===e.length?e:e.subarray(0,64)}function R(e,t,r,o,i,a,s){const c=i.__TX,u=t.sighashType||d.Transaction.SIGHASH_DEFAULT;z(u,s);const l=r.map((e,t)=>K(t,e,i)),h=l.map(e=>e.script),g=l.map(e=>e.value),y=[];if(t.tapInternalKey&&!a){const r=j(e,t,i)||n.from([]);if((0,p.toXOnly)(o).equals(r)){const t=c.hashForWitnessV1(e,h,g,u);y.push({pubkey:o,hash:t})}}const m=(t.tapLeafScript||[]).filter(e=>(0,b.pubkeyInScript)(o,e.script)).map(e=>{const t=(0,f.tapleafHash)({output:e.script,version:e.leafVersion});return Object.assign({hash:t},e)}).filter(e=>!a||a.equals(e.hash)).map(t=>{const r=c.hashForWitnessV1(e,h,g,d.Transaction.SIGHASH_DEFAULT,t.hash);return{pubkey:o,hash:r,leafHash:t.hash}});return y.concat(m)}function z(e,t){if(t&&t.indexOf(e)<0){const t=function(e){let t=e&d.Transaction.SIGHASH_ANYONECANPAY?"SIGHASH_ANYONECANPAY | ":"";switch(31&e){case d.Transaction.SIGHASH_ALL:t+="SIGHASH_ALL";break;case d.Transaction.SIGHASH_SINGLE:t+="SIGHASH_SINGLE";break;case d.Transaction.SIGHASH_NONE:t+="SIGHASH_NONE"}return t}(e);throw new Error(`Sighash type is not allowed. Retry the sign method passing the sighashTypes array of whitelisted types. Sighash type: ${t}`)}}function N(e,t,r){const n=(0,a.checkForInput)(t,e);if(!n.bip32Derivation||0===n.bip32Derivation.length)throw new Error("Need bip32Derivation to sign with HD");const o=n.bip32Derivation.map(e=>e.masterFingerprint.equals(r.fingerprint)?e:void 0).filter(e=>!!e);if(0===o.length)throw new Error("Need one bip32Derivation masterFingerprint to match the HDSigner fingerprint");return o.map(e=>{const t=r.derivePath(e.path);if(!e.pubkey.equals(t.publicKey))throw new Error("pubkey did not match bip32Derivation");return t})}function M(e){let t=0;function r(){const r=i.decode(e,t);return t+=i.decode.bytes,r}function n(){return n=r(),t+=n,e.slice(t-n,t);var n}return function(){const e=r(),t=[];for(let r=0;r<e;r++)t.push(n());return t}()}function V(e,t,r){e.__NON_WITNESS_UTXO_BUF_CACHE[r]=t.nonWitnessUtxo;const n=d.Transaction.fromBuffer(t.nonWitnessUtxo);e.__NON_WITNESS_UTXO_TX_CACHE[r]=n;const o=e,i=r;delete t.nonWitnessUtxo,Object.defineProperty(t,"nonWitnessUtxo",{enumerable:!0,get(){const e=o.__NON_WITNESS_UTXO_BUF_CACHE[i],t=o.__NON_WITNESS_UTXO_TX_CACHE[i];if(void 0!==e)return e;{const e=t.toBuffer();return o.__NON_WITNESS_UTXO_BUF_CACHE[i]=e,e}},set(e){o.__NON_WITNESS_UTXO_BUF_CACHE[i]=e}})}function D(e,t,r,n){let o=0;e.forEach((e,i)=>{if(n&&e.finalScriptSig&&(t.ins[i].script=e.finalScriptSig),n&&e.finalScriptWitness&&(t.ins[i].witness=M(e.finalScriptWitness)),e.witnessUtxo)o+=e.witnessUtxo.value;else if(e.nonWitnessUtxo){const n=F(r,e,i),a=t.ins[i].index,s=n.outs[a];o+=s.value}});const i=t.outs.reduce((e,t)=>e+t.value,0),a=o-i;if(a<0)throw new Error("Outputs are spending more than Inputs");const s=t.virtualSize();r.__FEE=a,r.__EXTRACTED_TX=t,r.__FEE_RATE=Math.floor(a/s)}function F(e,t,r){const n=e.__NON_WITNESS_UTXO_TX_CACHE;return n[r]||V(e,t,r),n[r]}function q(e,t,r){const{script:n}=K(e,t,r);return n}function K(e,t,r){if(void 0!==t.witnessUtxo)return{script:t.witnessUtxo.script,value:t.witnessUtxo.value};if(void 0!==t.nonWitnessUtxo){const n=F(r,t,e).outs[r.__TX.ins[e].index];return{script:n.script,value:n.value}}throw new Error("Can't find pubkey in input without Utxo data")}function G(e){return 33===e.length&&h.isCanonicalPubKey(e)}function W(e,t,r,n,o){const i=(0,b.isP2SHScript)(e),a=i&&n&&(0,b.isP2WSHScript)(n),s=(0,b.isP2WSHScript)(e);if(i&&void 0===n)throw new Error("scriptPubkey is P2SH but redeemScript missing");if((s||a)&&void 0===o)throw new Error("scriptPubkey or redeemScript is P2WSH but witnessScript missing");let c;return a?(c=o,T(t,e,n,r),H(t,n,o,r),$(c)):s?(c=o,H(t,e,o,r),$(c)):i?(c=n,T(t,e,n,r)):c=e,{meaningfulScript:c,type:a?"p2sh-p2wsh":i?"p2sh":s?"p2wsh":"raw"}}function $(e){if((0,b.isP2WPKH)(e)||(0,b.isP2SHScript)(e))throw new Error("P2WPKH or P2SH can not be contained within P2WSH")}function X(e){return(0,b.isP2WPKH)(e)?"witnesspubkeyhash":(0,b.isP2PKH)(e)?"pubkeyhash":(0,b.isP2MS)(e)?"multisig":(0,b.isP2PK)(e)?"pubkey":"nonstandard"}function Y(e){return[...Array(e).keys()]}},3064:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.checkTaprootInputForSigs=t.tapTreeFromList=t.tapTreeToList=t.tweakInternalPubKey=t.checkTaprootOutputFields=t.checkTaprootInputFields=t.isTaprootOutput=t.isTaprootInput=t.serializeTaprootSignature=t.tapScriptFinalizer=t.toXOnly=void 0;const o=r(1838),i=r(2737),a=r(7929),s=r(2227),c=r(4972),u=r(7929);function l(e){return e&&!!(e.tapInternalKey||e.tapMerkleRoot||e.tapLeafScript&&e.tapLeafScript.length||e.tapBip32Derivation&&e.tapBip32Derivation.length||e.witnessUtxo&&(0,a.isP2TR)(e.witnessUtxo.script))}function f(e,t){return e&&!!(e.tapInternalKey||e.tapTree||e.tapBip32Derivation&&e.tapBip32Derivation.length||t&&(0,a.isP2TR)(t))}function h(e=[]){return 1===e.length&&0===e[0].depth?{output:e[0].script,version:e[0].leafVersion}:function(e){let t;for(const r of e)if(t=b(r,t),!t)throw new Error("No room left to insert tapleaf in tree");return t}(e)}function d(e){return{signature:e.slice(0,64),hashType:e.slice(64)[0]||i.Transaction.SIGHASH_DEFAULT}}function p(e,t=[],r=0){if(r>s.MAX_TAPTREE_DEPTH)throw new Error("Max taptree depth exceeded.");return e?(0,o.isTapleaf)(e)?(t.push({depth:r,leafVersion:e.version||s.LEAF_VERSION_TAPSCRIPT,script:e.output}),t):(e[0]&&p(e[0],t,r+1),e[1]&&p(e[1],t,r+1),t):[]}function b(e,t,r=0){if(r>s.MAX_TAPTREE_DEPTH)throw new Error("Max taptree depth exceeded.");if(e.depth===r)return t?void 0:{output:e.script,version:e.leafVersion};if((0,o.isTapleaf)(t))return;const n=b(e,t&&t[0],r+1);if(n)return[n,t&&t[1]];const i=b(e,t&&t[1],r+1);return i?[t&&t[0],i]:void 0}function g(e,t){if(!t)return!0;const r=(0,s.tapleafHash)({output:e.script,version:e.leafVersion});return(0,s.rootHashFromPath)(e.controlBlock,r).equals(t)}function y(e){return e&&!!(e.redeemScript||e.witnessScript||e.bip32Derivation&&e.bip32Derivation.length)}t.toXOnly=e=>32===e.length?e:e.slice(1,33),t.tapScriptFinalizer=function(e,t,r){const n=function(e,t,r){if(!e.tapScriptSig||!e.tapScriptSig.length)throw new Error(`Can not finalize taproot input #${t}. No tapleaf script signature provided.`);const n=(e.tapLeafScript||[]).sort((e,t)=>e.controlBlock.length-t.controlBlock.length).find(t=>function(e,t,r){const n=(0,s.tapleafHash)({output:e.script,version:e.leafVersion});return(!r||r.equals(n))&&void 0!==t.find(e=>e.leafHash.equals(n))}(t,e.tapScriptSig,r));if(!n)throw new Error(`Can not finalize taproot input #${t}. Signature for tapleaf script not found.`);return n}(t,e,r);try{const e=function(e,t){const r=(0,s.tapleafHash)({output:t.script,version:t.leafVersion});return(e.tapScriptSig||[]).filter(e=>e.leafHash.equals(r)).map(e=>function(e,t){return Object.assign({positionInScript:(0,a.pubkeyPositionInScript)(t.pubkey,e)},t)}(t.script,e)).sort((e,t)=>t.positionInScript-e.positionInScript).map(e=>e.signature)}(t,n),r=e.concat(n.script).concat(n.controlBlock);return{finalScriptWitness:(0,a.witnessStackToScriptWitness)(r)}}catch(t){throw new Error(`Can not finalize taproot input #${e}: ${t}`)}},t.serializeTaprootSignature=function(e,t){const r=t?n.from([t]):n.from([]);return n.concat([e,r])},t.isTaprootInput=l,t.isTaprootOutput=f,t.checkTaprootInputFields=function(e,t,r){!function(e,t,r){const n=l(e)&&y(t),o=y(e)&&l(t),i=e===t&&l(t)&&y(t);if(n||o||i)throw new Error(`Invalid arguments for Psbt.${r}. Cannot use both taproot and non-taproot fields.`)}(e,t,r),function(e,t,r){if(t.tapMerkleRoot){const n=(t.tapLeafScript||[]).every(e=>g(e,t.tapMerkleRoot)),o=(e.tapLeafScript||[]).every(e=>g(e,t.tapMerkleRoot));if(!n||!o)throw new Error(`Invalid arguments for Psbt.${r}. Tapleaf not part of taptree.`)}else if(e.tapMerkleRoot&&!(t.tapLeafScript||[]).every(t=>g(t,e.tapMerkleRoot)))throw new Error(`Invalid arguments for Psbt.${r}. Tapleaf not part of taptree.`)}(e,t,r)},t.checkTaprootOutputFields=function(e,t,r){!function(e,t,r){const n=f(e)&&y(t),o=y(e)&&f(t),i=e===t&&f(t)&&y(t);if(n||o||i)throw new Error(`Invalid arguments for Psbt.${r}. Cannot use both taproot and non-taproot fields.`)}(e,t,r),function(e,t){if(!t.tapTree&&!t.tapInternalKey)return;const r=t.tapInternalKey||e.tapInternalKey,n=t.tapTree||e.tapTree;if(r){const{script:t}=e,o=function(e,t){const r=t&&h(t.leaves),{output:n}=(0,c.p2tr)({internalPubkey:e,scriptTree:r});return n}(r,n);if(t&&!t.equals(o))throw new Error("Error adding output. Script or address missmatch.")}}(e,t)},t.tweakInternalPubKey=function(e,t){const r=t.tapInternalKey,n=r&&(0,s.tweakKey)(r,t.tapMerkleRoot);if(!n)throw new Error(`Cannot tweak tap internal key for input #${e}. Public key: ${r&&r.toString("hex")}`);return n.x},t.tapTreeToList=function(e){if(!(0,o.isTaptree)(e))throw new Error("Cannot convert taptree to tapleaf list. Expecting a tapree structure.");return p(e)},t.tapTreeFromList=h,t.checkTaprootInputForSigs=function(e,t){return function(e){const t=[];if(e.tapKeySig&&t.push(e.tapKeySig),e.tapScriptSig&&t.push(...e.tapScriptSig.map(e=>e.signature)),!t.length){const r=function(e){if(!e)return;const t=e.slice(2);return 64===t.length||65===t.length?t:void 0}(e.finalScriptWitness);r&&t.push(r)}return t}(e).some(e=>(0,u.signatureBlocksAction)(e,d,t))}},7929:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.signatureBlocksAction=t.checkInputForSig=t.pubkeyInScript=t.pubkeyPositionInScript=t.witnessStackToScriptWitness=t.isP2TR=t.isP2SHScript=t.isP2WSHScript=t.isP2WPKH=t.isP2PKH=t.isP2PK=t.isP2MS=void 0;const o=r(3493),i=r(3357),a=r(2737),s=r(5525),c=r(4972);function u(e){return t=>{try{return e({output:t}),!0}catch(e){return!1}}}function l(e,t){const r=(0,s.hash160)(e),n=e.slice(1,33),o=i.decompile(t);if(null===o)throw new Error("Unknown script error");return o.findIndex(t=>"number"!=typeof t&&(t.equals(e)||t.equals(r)||t.equals(n)))}function f(e,t,r){const{hashType:n}=t(e),o=[];switch(n&a.Transaction.SIGHASH_ANYONECANPAY&&o.push("addInput"),31&n){case a.Transaction.SIGHASH_ALL:break;case a.Transaction.SIGHASH_SINGLE:case a.Transaction.SIGHASH_NONE:o.push("addOutput"),o.push("setInputSequence")}return-1===o.indexOf(r)}t.isP2MS=u(c.p2ms),t.isP2PK=u(c.p2pk),t.isP2PKH=u(c.p2pkh),t.isP2WPKH=u(c.p2wpkh),t.isP2WSHScript=u(c.p2wsh),t.isP2SHScript=u(c.p2sh),t.isP2TR=u(c.p2tr),t.witnessStackToScriptWitness=function(e){let t=n.allocUnsafe(0);function r(e){const r=t.length,i=o.encodingLength(e);t=n.concat([t,n.allocUnsafe(i)]),o.encode(e,t,r)}var i;return r((i=e).length),i.forEach(function(e){r(e.length),function(e){t=n.concat([t,n.from(e)])}(e)}),t},t.pubkeyPositionInScript=l,t.pubkeyInScript=function(e,t){return-1!==l(e,t)},t.checkInputForSig=function(e,t){return function(e){let t=[];if(0===(e.partialSig||[]).length){if(!e.finalScriptSig&&!e.finalScriptWitness)return[];t=function(e){const t=e.finalScriptSig&&i.decompile(e.finalScriptSig)||[],r=e.finalScriptWitness&&i.decompile(e.finalScriptWitness)||[];return t.concat(r).filter(e=>n.isBuffer(e)&&i.isCanonicalScriptSignature(e)).map(e=>({signature:e}))}(e)}else t=e.partialSig;return t.map(e=>e.signature)}(e).some(e=>f(e,i.signature.decode,t))},t.signatureBlocksAction=f},9937:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.decode=t.encode=t.encodingLength=void 0;const n=r(7334);function o(e){return e<n.OPS.OP_PUSHDATA1?1:e<=255?2:e<=65535?3:5}t.encodingLength=o,t.encode=function(e,t,r){const i=o(t);return 1===i?e.writeUInt8(t,r):2===i?(e.writeUInt8(n.OPS.OP_PUSHDATA1,r),e.writeUInt8(t,r+1)):3===i?(e.writeUInt8(n.OPS.OP_PUSHDATA2,r),e.writeUInt16LE(t,r+1)):(e.writeUInt8(n.OPS.OP_PUSHDATA4,r),e.writeUInt32LE(t,r+1)),i},t.decode=function(e,t){const r=e.readUInt8(t);let o,i;if(r<n.OPS.OP_PUSHDATA1)o=r,i=1;else if(r===n.OPS.OP_PUSHDATA1){if(t+2>e.length)return null;o=e.readUInt8(t+1),i=2}else if(r===n.OPS.OP_PUSHDATA2){if(t+3>e.length)return null;o=e.readUInt16LE(t+1),i=3}else{if(t+5>e.length)return null;if(r!==n.OPS.OP_PUSHDATA4)throw new Error("Unexpected opcode");o=e.readUInt32LE(t+1),i=5}return{opcode:r,number:o,size:i}}},3357:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.signature=t.number=t.isCanonicalScriptSignature=t.isDefinedHashType=t.isCanonicalPubKey=t.toStack=t.fromASM=t.toASM=t.decompile=t.compile=t.countNonPushOnlyOPs=t.isPushOnly=t.OPS=void 0;const o=r(7617),i=r(7334);Object.defineProperty(t,"OPS",{enumerable:!0,get:function(){return i.OPS}});const a=r(9937),s=r(5815),c=r(4362),u=r(1838),{typeforce:l}=u,f=i.OPS.OP_RESERVED;function h(e){return u.Buffer(e)||function(e){return u.Number(e)&&(e===i.OPS.OP_0||e>=i.OPS.OP_1&&e<=i.OPS.OP_16||e===i.OPS.OP_1NEGATE)}(e)}function d(e){return u.Array(e)&&e.every(h)}function p(e){return 0===e.length?i.OPS.OP_0:1===e.length?e[0]>=1&&e[0]<=16?f+e[0]:129===e[0]?i.OPS.OP_1NEGATE:void 0:void 0}function b(e){return n.isBuffer(e)}function g(e){return n.isBuffer(e)}function y(e){if(b(e))return e;l(u.Array,e);const t=e.reduce((e,t)=>g(t)?1===t.length&&void 0!==p(t)?e+1:e+a.encodingLength(t.length)+t.length:e+1,0),r=n.allocUnsafe(t);let o=0;if(e.forEach(e=>{if(g(e)){const t=p(e);if(void 0!==t)return r.writeUInt8(t,o),void(o+=1);o+=a.encode(r,e.length,o),e.copy(r,o),o+=e.length}else r.writeUInt8(e,o),o+=1}),o!==r.length)throw new Error("Could not decode chunks");return r}function m(e){if(t=e,u.Array(t))return e;var t;l(u.Buffer,e);const r=[];let n=0;for(;n<e.length;){const t=e[n];if(t>i.OPS.OP_0&&t<=i.OPS.OP_PUSHDATA4){const t=a.decode(e,n);if(null===t)return null;if(n+=t.size,n+t.number>e.length)return null;const o=e.slice(n,n+t.number);n+=t.number;const i=p(o);void 0!==i?r.push(i):r.push(o)}else r.push(t),n+=1}return r}function v(e){const t=-129&e;return t>0&&t<4}t.isPushOnly=d,t.countNonPushOnlyOPs=function(e){return e.length-e.filter(h).length},t.compile=y,t.decompile=m,t.toASM=function(e){return b(e)&&(e=m(e)),e.map(e=>{if(g(e)){const t=p(e);if(void 0===t)return e.toString("hex");e=t}return i.REVERSE_OPS[e]}).join(" ")},t.fromASM=function(e){return l(u.String,e),y(e.split(" ").map(e=>void 0!==i.OPS[e]?i.OPS[e]:(l(u.Hex,e),n.from(e,"hex"))))},t.toStack=function(e){return e=m(e),l(d,e),e.map(e=>g(e)?e:e===i.OPS.OP_0?n.allocUnsafe(0):s.encode(e-f))},t.isCanonicalPubKey=function(e){return u.isPoint(e)},t.isDefinedHashType=v,t.isCanonicalScriptSignature=function(e){return!!n.isBuffer(e)&&!!v(e[e.length-1])&&o.check(e.slice(0,-1))},t.number=s,t.signature=c},5815:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.encode=t.decode=void 0,t.decode=function(e,t,r){t=t||4,r=void 0===r||r;const n=e.length;if(0===n)return 0;if(n>t)throw new TypeError("Script number overflow");if(r&&!(127&e[n-1]||!(n<=1)&&128&e[n-2]))throw new Error("Non-minimally encoded script number");if(5===n){const t=e.readUInt32LE(0),r=e.readUInt8(4);return 128&r?-(4294967296*(-129&r)+t):4294967296*r+t}let o=0;for(let t=0;t<n;++t)o|=e[t]<<8*t;return 128&e[n-1]?-(o&~(128<<8*(n-1))):o},t.encode=function(e){let t=Math.abs(e);const r=(o=t)>2147483647?5:o>8388607?4:o>32767?3:o>127?2:o>0?1:0;var o;const i=n.allocUnsafe(r),a=e<0;for(let e=0;e<r;++e)i.writeUInt8(255&t,e),t>>=8;return 128&i[r-1]?i.writeUInt8(a?128:0,r-1):a&&(i[r-1]|=128),i}},4362:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.encode=t.decode=void 0;const o=r(7617),i=r(1838),{typeforce:a}=i,s=n.alloc(1,0);function c(e){let t=0;for(;0===e[t];)++t;return t===e.length?s:128&(e=e.slice(t))[0]?n.concat([s,e],1+e.length):e}function u(e){0===e[0]&&(e=e.slice(1));const t=n.alloc(32,0),r=Math.max(0,32-e.length);return e.copy(t,r),t}t.decode=function(e){const t=e.readUInt8(e.length-1),r=-129&t;if(r<=0||r>=4)throw new Error("Invalid hashType "+t);const i=o.decode(e.slice(0,-1)),a=u(i.r),s=u(i.s);return{signature:n.concat([a,s],64),hashType:t}},t.encode=function(e,t){a({signature:i.BufferN(64),hashType:i.UInt8},{signature:e,hashType:t});const r=-129&t;if(r<=0||r>=4)throw new Error("Invalid hashType "+t);const s=n.allocUnsafe(1);s.writeUInt8(t,0);const u=c(e.slice(0,32)),l=c(e.slice(32,64));return n.concat([o.encode(u,l),s])}},2737:(e,t,r)=>{"use strict";var n=r(8764).Buffer;Object.defineProperty(t,"__esModule",{value:!0}),t.Transaction=void 0;const o=r(9357),i=r(5525),a=r(3357),s=r(3357),c=r(1838),{typeforce:u}=c;function l(e){const t=e.length;return o.varuint.encodingLength(t)+t}const f=n.allocUnsafe(0),h=[],d=n.from("0000000000000000000000000000000000000000000000000000000000000000","hex"),p=n.from("0000000000000000000000000000000000000000000000000000000000000001","hex"),b=n.from("ffffffffffffffff","hex"),g={script:f,valueBuffer:b};class y{constructor(){this.version=1,this.locktime=0,this.ins=[],this.outs=[]}static fromBuffer(e,t){const r=new o.BufferReader(e),n=new y;n.version=r.readInt32();const i=r.readUInt8(),a=r.readUInt8();let s=!1;i===y.ADVANCED_TRANSACTION_MARKER&&a===y.ADVANCED_TRANSACTION_FLAG?s=!0:r.offset-=2;const c=r.readVarInt();for(let e=0;e<c;++e)n.ins.push({hash:r.readSlice(32),index:r.readUInt32(),script:r.readVarSlice(),sequence:r.readUInt32(),witness:h});const u=r.readVarInt();for(let e=0;e<u;++e)n.outs.push({value:r.readUInt64(),script:r.readVarSlice()});if(s){for(let e=0;e<c;++e)n.ins[e].witness=r.readVector();if(!n.hasWitnesses())throw new Error("Transaction has superfluous witness data")}if(n.locktime=r.readUInt32(),t)return n;if(r.offset!==e.length)throw new Error("Transaction has unexpected data");return n}static fromHex(e){return y.fromBuffer(n.from(e,"hex"),!1)}static isCoinbaseHash(e){u(c.Hash256bit,e);for(let t=0;t<32;++t)if(0!==e[t])return!1;return!0}isCoinbase(){return 1===this.ins.length&&y.isCoinbaseHash(this.ins[0].hash)}addInput(e,t,r,n){return u(c.tuple(c.Hash256bit,c.UInt32,c.maybe(c.UInt32),c.maybe(c.Buffer)),arguments),c.Null(r)&&(r=y.DEFAULT_SEQUENCE),this.ins.push({hash:e,index:t,script:n||f,sequence:r,witness:h})-1}addOutput(e,t){return u(c.tuple(c.Buffer,c.Satoshi),arguments),this.outs.push({script:e,value:t})-1}hasWitnesses(){return this.ins.some(e=>0!==e.witness.length)}weight(){return 3*this.byteLength(!1)+this.byteLength(!0)}virtualSize(){return Math.ceil(this.weight()/4)}byteLength(e=!0){const t=e&&this.hasWitnesses();return(t?10:8)+o.varuint.encodingLength(this.ins.length)+o.varuint.encodingLength(this.outs.length)+this.ins.reduce((e,t)=>e+40+l(t.script),0)+this.outs.reduce((e,t)=>e+8+l(t.script),0)+(t?this.ins.reduce((e,t)=>e+function(e){const t=e.length;return o.varuint.encodingLength(t)+e.reduce((e,t)=>e+l(t),0)}(t.witness),0):0)}clone(){const e=new y;return e.version=this.version,e.locktime=this.locktime,e.ins=this.ins.map(e=>({hash:e.hash,index:e.index,script:e.script,sequence:e.sequence,witness:e.witness})),e.outs=this.outs.map(e=>({script:e.script,value:e.value})),e}hashForSignature(e,t,r){if(u(c.tuple(c.UInt32,c.Buffer,c.Number),arguments),e>=this.ins.length)return p;const o=a.compile(a.decompile(t).filter(e=>e!==s.OPS.OP_CODESEPARATOR)),l=this.clone();if((31&r)===y.SIGHASH_NONE)l.outs=[],l.ins.forEach((t,r)=>{r!==e&&(t.sequence=0)});else if((31&r)===y.SIGHASH_SINGLE){if(e>=this.outs.length)return p;l.outs.length=e+1;for(let t=0;t<e;t++)l.outs[t]=g;l.ins.forEach((t,r)=>{r!==e&&(t.sequence=0)})}r&y.SIGHASH_ANYONECANPAY?(l.ins=[l.ins[e]],l.ins[0].script=o):(l.ins.forEach(e=>{e.script=f}),l.ins[e].script=o);const h=n.allocUnsafe(l.byteLength(!1)+4);return h.writeInt32LE(r,h.length-4),l.__toBuffer(h,0,!1),i.hash256(h)}hashForWitnessV1(e,t,r,a,s,h){if(u(c.tuple(c.UInt32,u.arrayOf(c.Buffer),u.arrayOf(c.Satoshi),c.UInt32),arguments),r.length!==this.ins.length||t.length!==this.ins.length)throw new Error("Must supply prevout script and value for all inputs");const d=a===y.SIGHASH_DEFAULT?y.SIGHASH_ALL:a&y.SIGHASH_OUTPUT_MASK,p=(a&y.SIGHASH_INPUT_MASK)===y.SIGHASH_ANYONECANPAY,b=d===y.SIGHASH_NONE,g=d===y.SIGHASH_SINGLE;let m=f,v=f,w=f,_=f,S=f;if(!p){let e=o.BufferWriter.withCapacity(36*this.ins.length);this.ins.forEach(t=>{e.writeSlice(t.hash),e.writeUInt32(t.index)}),m=i.sha256(e.end()),e=o.BufferWriter.withCapacity(8*this.ins.length),r.forEach(t=>e.writeUInt64(t)),v=i.sha256(e.end()),e=o.BufferWriter.withCapacity(t.map(l).reduce((e,t)=>e+t)),t.forEach(t=>e.writeVarSlice(t)),w=i.sha256(e.end()),e=o.BufferWriter.withCapacity(4*this.ins.length),this.ins.forEach(t=>e.writeUInt32(t.sequence)),_=i.sha256(e.end())}if(b||g){if(g&&e<this.outs.length){const t=this.outs[e],r=o.BufferWriter.withCapacity(8+l(t.script));r.writeUInt64(t.value),r.writeVarSlice(t.script),S=i.sha256(r.end())}}else{const e=this.outs.map(e=>8+l(e.script)).reduce((e,t)=>e+t),t=o.BufferWriter.withCapacity(e);this.outs.forEach(e=>{t.writeUInt64(e.value),t.writeVarSlice(e.script)}),S=i.sha256(t.end())}const E=(s?2:0)+(h?1:0),k=174-(p?49:0)-(b?32:0)+(h?32:0)+(s?37:0),A=o.BufferWriter.withCapacity(k);if(A.writeUInt8(a),A.writeInt32(this.version),A.writeUInt32(this.locktime),A.writeSlice(m),A.writeSlice(v),A.writeSlice(w),A.writeSlice(_),b||g||A.writeSlice(S),A.writeUInt8(E),p){const n=this.ins[e];A.writeSlice(n.hash),A.writeUInt32(n.index),A.writeUInt64(r[e]),A.writeVarSlice(t[e]),A.writeUInt32(n.sequence)}else A.writeUInt32(e);if(h){const e=o.BufferWriter.withCapacity(l(h));e.writeVarSlice(h),A.writeSlice(i.sha256(e.end()))}return g&&A.writeSlice(S),s&&(A.writeSlice(s),A.writeUInt8(0),A.writeUInt32(4294967295)),i.taggedHash("TapSighash",n.concat([n.from([0]),A.end()]))}hashForWitnessV0(e,t,r,a){u(c.tuple(c.UInt32,c.Buffer,c.Satoshi,c.UInt32),arguments);let s,f=n.from([]),h=d,p=d,b=d;if(a&y.SIGHASH_ANYONECANPAY||(f=n.allocUnsafe(36*this.ins.length),s=new o.BufferWriter(f,0),this.ins.forEach(e=>{s.writeSlice(e.hash),s.writeUInt32(e.index)}),p=i.hash256(f)),a&y.SIGHASH_ANYONECANPAY||(31&a)===y.SIGHASH_SINGLE||(31&a)===y.SIGHASH_NONE||(f=n.allocUnsafe(4*this.ins.length),s=new o.BufferWriter(f,0),this.ins.forEach(e=>{s.writeUInt32(e.sequence)}),b=i.hash256(f)),(31&a)!==y.SIGHASH_SINGLE&&(31&a)!==y.SIGHASH_NONE){const e=this.outs.reduce((e,t)=>e+8+l(t.script),0);f=n.allocUnsafe(e),s=new o.BufferWriter(f,0),this.outs.forEach(e=>{s.writeUInt64(e.value),s.writeVarSlice(e.script)}),h=i.hash256(f)}else if((31&a)===y.SIGHASH_SINGLE&&e<this.outs.length){const t=this.outs[e];f=n.allocUnsafe(8+l(t.script)),s=new o.BufferWriter(f,0),s.writeUInt64(t.value),s.writeVarSlice(t.script),h=i.hash256(f)}f=n.allocUnsafe(156+l(t)),s=new o.BufferWriter(f,0);const g=this.ins[e];return s.writeInt32(this.version),s.writeSlice(p),s.writeSlice(b),s.writeSlice(g.hash),s.writeUInt32(g.index),s.writeVarSlice(t),s.writeUInt64(r),s.writeUInt32(g.sequence),s.writeSlice(h),s.writeUInt32(this.locktime),s.writeUInt32(a),i.hash256(f)}getHash(e){return e&&this.isCoinbase()?n.alloc(32,0):i.hash256(this.__toBuffer(void 0,void 0,e))}getId(){return(0,o.reverseBuffer)(this.getHash(!1)).toString("hex")}toBuffer(e,t){return this.__toBuffer(e,t,!0)}toHex(){return this.toBuffer(void 0,void 0).toString("hex")}setInputScript(e,t){u(c.tuple(c.Number,c.Buffer),arguments),this.ins[e].script=t}setWitness(e,t){u(c.tuple(c.Number,[c.Buffer]),arguments),this.ins[e].witness=t}__toBuffer(e,t,r=!1){e||(e=n.allocUnsafe(this.byteLength(r)));const i=new o.BufferWriter(e,t||0);i.writeInt32(this.version);const a=r&&this.hasWitnesses();return a&&(i.writeUInt8(y.ADVANCED_TRANSACTION_MARKER),i.writeUInt8(y.ADVANCED_TRANSACTION_FLAG)),i.writeVarInt(this.ins.length),this.ins.forEach(e=>{i.writeSlice(e.hash),i.writeUInt32(e.index),i.writeVarSlice(e.script),i.writeUInt32(e.sequence)}),i.writeVarInt(this.outs.length),this.outs.forEach(e=>{void 0!==e.value?i.writeUInt64(e.value):i.writeSlice(e.valueBuffer),i.writeVarSlice(e.script)}),a&&this.ins.forEach(e=>{i.writeVector(e.witness)}),i.writeUInt32(this.locktime),void 0!==t?e.slice(t,i.offset):e}}t.Transaction=y,y.DEFAULT_SEQUENCE=4294967295,y.SIGHASH_DEFAULT=0,y.SIGHASH_ALL=1,y.SIGHASH_NONE=2,y.SIGHASH_SINGLE=3,y.SIGHASH_ANYONECANPAY=128,y.SIGHASH_OUTPUT_MASK=3,y.SIGHASH_INPUT_MASK=128,y.ADVANCED_TRANSACTION_MARKER=0,y.ADVANCED_TRANSACTION_FLAG=1},1838:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.oneOf=t.Null=t.BufferN=t.Function=t.UInt32=t.UInt8=t.tuple=t.maybe=t.Hex=t.Buffer=t.String=t.Boolean=t.Array=t.Number=t.Hash256bit=t.Hash160bit=t.Buffer256bit=t.isTaptree=t.isTapleaf=t.TAPLEAF_VERSION_MASK=t.Network=t.ECPoint=t.Satoshi=t.Signer=t.BIP32Path=t.UInt31=t.isPoint=t.typeforce=void 0;const n=r(8764);t.typeforce=r(2401);const o=n.Buffer.alloc(32,0),i=n.Buffer.from("fffffffffffffffffffffffffffffffffffffffffffffffffffffffefffffc2f","hex");t.isPoint=function(e){if(!n.Buffer.isBuffer(e))return!1;if(e.length<33)return!1;const t=e[0],r=e.slice(1,33);if(0===r.compare(o))return!1;if(r.compare(i)>=0)return!1;if((2===t||3===t)&&33===e.length)return!0;const a=e.slice(33);return 0!==a.compare(o)&&!(a.compare(i)>=0)&&4===t&&65===e.length};const a=Math.pow(2,31)-1;function s(e){return t.typeforce.String(e)&&!!e.match(/^(m\/)?(\d+'?\/)*\d+'?$/)}function c(e){return!(!e||!("output"in e)||!n.Buffer.isBuffer(e.output)||void 0!==e.version&&(e.version&t.TAPLEAF_VERSION_MASK)!==e.version)}t.UInt31=function(e){return t.typeforce.UInt32(e)&&e<=a},t.BIP32Path=s,s.toJSON=()=>"BIP32 derivation path",t.Signer=function(e){return(t.typeforce.Buffer(e.publicKey)||"function"==typeof e.getPublicKey)&&"function"==typeof e.sign},t.Satoshi=function(e){return t.typeforce.UInt53(e)&&e<=21e14},t.ECPoint=t.typeforce.quacksLike("Point"),t.Network=t.typeforce.compile({messagePrefix:t.typeforce.oneOf(t.typeforce.Buffer,t.typeforce.String),bip32:{public:t.typeforce.UInt32,private:t.typeforce.UInt32},pubKeyHash:t.typeforce.UInt8,scriptHash:t.typeforce.UInt8,wif:t.typeforce.UInt8}),t.TAPLEAF_VERSION_MASK=254,t.isTapleaf=c,t.isTaptree=function e(r){return(0,t.Array)(r)?2===r.length&&r.every(t=>e(t)):c(r)},t.Buffer256bit=t.typeforce.BufferN(32),t.Hash160bit=t.typeforce.BufferN(20),t.Hash256bit=t.typeforce.BufferN(32),t.Number=t.typeforce.Number,t.Array=t.typeforce.Array,t.Boolean=t.typeforce.Boolean,t.String=t.typeforce.String,t.Buffer=t.typeforce.Buffer,t.Hex=t.typeforce.Hex,t.maybe=t.typeforce.maybe,t.tuple=t.typeforce.tuple,t.UInt8=t.typeforce.UInt8,t.UInt32=t.typeforce.UInt32,t.Function=t.typeforce.Function,t.BufferN=t.typeforce.BufferN,t.Null=t.typeforce.Null,t.oneOf=t.typeforce.oneOf},7191:(e,t,r)=>{const n=r(8162);e.exports=n("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz")},3310:(e,t,r)=>{"use strict";var n=r(7191);e.exports=function(e){function t(t){var r=t.slice(0,-4),n=t.slice(-4),o=e(r);if(!(n[0]^o[0]|n[1]^o[1]|n[2]^o[2]|n[3]^o[3]))return r}return{encode:function(t){var r=Uint8Array.from(t),o=e(r),i=r.length+4,a=new Uint8Array(i);return a.set(r,0),a.set(o.subarray(0,4),r.length),n.encode(a,i)},decode:function(e){var r=t(n.decode(e));if(!r)throw new Error("Invalid checksum");return r},decodeUnsafe:function(e){var r=n.decodeUnsafe(e);if(r)return t(r)}}}},8334:(e,t,r)=>{"use strict";var{sha256:n}=r(2710),o=r(3310);e.exports=o(function(e){return n(n(e))})},5654:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SHA512_IV=t.SHA384_IV=t.SHA224_IV=t.SHA256_IV=t.HashMD=void 0,t.setBigUint64=o,t.Chi=function(e,t,r){return e&t^~e&r},t.Maj=function(e,t,r){return e&t^e&r^t&r};const n=r(2078);function o(e,t,r,n){if("function"==typeof e.setBigUint64)return e.setBigUint64(t,r,n);const o=BigInt(32),i=BigInt(4294967295),a=Number(r>>o&i),s=Number(r&i),c=n?4:0,u=n?0:4;e.setUint32(t+c,a,n),e.setUint32(t+u,s,n)}class i extends n.Hash{constructor(e,t,r,o){super(),this.finished=!1,this.length=0,this.pos=0,this.destroyed=!1,this.blockLen=e,this.outputLen=t,this.padOffset=r,this.isLE=o,this.buffer=new Uint8Array(e),this.view=(0,n.createView)(this.buffer)}update(e){(0,n.aexists)(this),e=(0,n.toBytes)(e),(0,n.abytes)(e);const{view:t,buffer:r,blockLen:o}=this,i=e.length;for(let a=0;a<i;){const s=Math.min(o-this.pos,i-a);if(s===o){const t=(0,n.createView)(e);for(;o<=i-a;a+=o)this.process(t,a);continue}r.set(e.subarray(a,a+s),this.pos),this.pos+=s,a+=s,this.pos===o&&(this.process(t,0),this.pos=0)}return this.length+=e.length,this.roundClean(),this}digestInto(e){(0,n.aexists)(this),(0,n.aoutput)(e,this),this.finished=!0;const{buffer:t,view:r,blockLen:i,isLE:a}=this;let{pos:s}=this;t[s++]=128,(0,n.clean)(this.buffer.subarray(s)),this.padOffset>i-s&&(this.process(r,0),s=0);for(let e=s;e<i;e++)t[e]=0;o(r,i-8,BigInt(8*this.length),a),this.process(r,0);const c=(0,n.createView)(e),u=this.outputLen;if(u%4)throw new Error("_sha2: outputLen should be aligned to 32bit");const l=u/4,f=this.get();if(l>f.length)throw new Error("_sha2: outputLen bigger than state");for(let e=0;e<l;e++)c.setUint32(4*e,f[e],a)}digest(){const{buffer:e,outputLen:t}=this;this.digestInto(e);const r=e.slice(0,t);return this.destroy(),r}_cloneInto(e){e||(e=new this.constructor),e.set(...this.get());const{blockLen:t,buffer:r,length:n,finished:o,destroyed:i,pos:a}=this;return e.destroyed=i,e.finished=o,e.length=n,e.pos=a,n%t&&e.buffer.set(r),e}clone(){return this._cloneInto()}}t.HashMD=i,t.SHA256_IV=Uint32Array.from([1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225]),t.SHA224_IV=Uint32Array.from([3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428]),t.SHA384_IV=Uint32Array.from([3418070365,3238371032,1654270250,914150663,2438529370,812702999,355462360,4144912697,1731405415,4290775857,2394180231,1750603025,3675008525,1694076839,1203062813,3204075428]),t.SHA512_IV=Uint32Array.from([1779033703,4089235720,3144134277,2227873595,1013904242,4271175723,2773480762,1595750129,1359893119,2917565137,2600822924,725511199,528734635,4215389547,1541459225,327033209])},8461:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.toBig=t.shrSL=t.shrSH=t.rotrSL=t.rotrSH=t.rotrBL=t.rotrBH=t.rotr32L=t.rotr32H=t.rotlSL=t.rotlSH=t.rotlBL=t.rotlBH=t.add5L=t.add5H=t.add4L=t.add4H=t.add3L=t.add3H=void 0,t.add=v,t.fromBig=o,t.split=i;const r=BigInt(2**32-1),n=BigInt(32);function o(e,t=!1){return t?{h:Number(e&r),l:Number(e>>n&r)}:{h:0|Number(e>>n&r),l:0|Number(e&r)}}function i(e,t=!1){const r=e.length;let n=new Uint32Array(r),i=new Uint32Array(r);for(let a=0;a<r;a++){const{h:r,l:s}=o(e[a],t);[n[a],i[a]]=[r,s]}return[n,i]}const a=(e,t)=>BigInt(e>>>0)<<n|BigInt(t>>>0);t.toBig=a;const s=(e,t,r)=>e>>>r;t.shrSH=s;const c=(e,t,r)=>e<<32-r|t>>>r;t.shrSL=c;const u=(e,t,r)=>e>>>r|t<<32-r;t.rotrSH=u;const l=(e,t,r)=>e<<32-r|t>>>r;t.rotrSL=l;const f=(e,t,r)=>e<<64-r|t>>>r-32;t.rotrBH=f;const h=(e,t,r)=>e>>>r-32|t<<64-r;t.rotrBL=h;const d=(e,t)=>t;t.rotr32H=d;const p=(e,t)=>e;t.rotr32L=p;const b=(e,t,r)=>e<<r|t>>>32-r;t.rotlSH=b;const g=(e,t,r)=>t<<r|e>>>32-r;t.rotlSL=g;const y=(e,t,r)=>t<<r-32|e>>>64-r;t.rotlBH=y;const m=(e,t,r)=>e<<r-32|t>>>64-r;function v(e,t,r,n){const o=(t>>>0)+(n>>>0);return{h:e+r+(o/2**32|0)|0,l:0|o}}t.rotlBL=m;const w=(e,t,r)=>(e>>>0)+(t>>>0)+(r>>>0);t.add3L=w;const _=(e,t,r,n)=>t+r+n+(e/2**32|0)|0;t.add3H=_;const S=(e,t,r,n)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0);t.add4L=S;const E=(e,t,r,n,o)=>t+r+n+o+(e/2**32|0)|0;t.add4H=E;const k=(e,t,r,n,o)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0)+(o>>>0);t.add5L=k;const A=(e,t,r,n,o,i)=>t+r+n+o+i+(e/2**32|0)|0;t.add5H=A;const x={fromBig:o,split:i,toBig:a,shrSH:s,shrSL:c,rotrSH:u,rotrSL:l,rotrBH:f,rotrBL:h,rotr32H:d,rotr32L:p,rotlSH:b,rotlSL:g,rotlBH:y,rotlBL:m,add:v,add3L:w,add3H:_,add4L:S,add4H:E,add5H:A,add5L:k};t.default=x},9433:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.crypto=void 0,t.crypto="object"==typeof globalThis&&"crypto"in globalThis?globalThis.crypto:void 0},8059:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha512_224=t.sha512_256=t.sha384=t.sha512=t.sha224=t.sha256=t.SHA512_256=t.SHA512_224=t.SHA384=t.SHA512=t.SHA224=t.SHA256=void 0;const n=r(5654),o=r(8461),i=r(2078),a=Uint32Array.from([1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298]),s=new Uint32Array(64);class c extends n.HashMD{constructor(e=32){super(64,e,8,!1),this.A=0|n.SHA256_IV[0],this.B=0|n.SHA256_IV[1],this.C=0|n.SHA256_IV[2],this.D=0|n.SHA256_IV[3],this.E=0|n.SHA256_IV[4],this.F=0|n.SHA256_IV[5],this.G=0|n.SHA256_IV[6],this.H=0|n.SHA256_IV[7]}get(){const{A:e,B:t,C:r,D:n,E:o,F:i,G:a,H:s}=this;return[e,t,r,n,o,i,a,s]}set(e,t,r,n,o,i,a,s){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n,this.E=0|o,this.F=0|i,this.G=0|a,this.H=0|s}process(e,t){for(let r=0;r<16;r++,t+=4)s[r]=e.getUint32(t,!1);for(let e=16;e<64;e++){const t=s[e-15],r=s[e-2],n=(0,i.rotr)(t,7)^(0,i.rotr)(t,18)^t>>>3,o=(0,i.rotr)(r,17)^(0,i.rotr)(r,19)^r>>>10;s[e]=o+s[e-7]+n+s[e-16]|0}let{A:r,B:o,C:c,D:u,E:l,F:f,G:h,H:d}=this;for(let e=0;e<64;e++){const t=d+((0,i.rotr)(l,6)^(0,i.rotr)(l,11)^(0,i.rotr)(l,25))+(0,n.Chi)(l,f,h)+a[e]+s[e]|0,p=((0,i.rotr)(r,2)^(0,i.rotr)(r,13)^(0,i.rotr)(r,22))+(0,n.Maj)(r,o,c)|0;d=h,h=f,f=l,l=u+t|0,u=c,c=o,o=r,r=t+p|0}r=r+this.A|0,o=o+this.B|0,c=c+this.C|0,u=u+this.D|0,l=l+this.E|0,f=f+this.F|0,h=h+this.G|0,d=d+this.H|0,this.set(r,o,c,u,l,f,h,d)}roundClean(){(0,i.clean)(s)}destroy(){this.set(0,0,0,0,0,0,0,0),(0,i.clean)(this.buffer)}}t.SHA256=c;class u extends c{constructor(){super(28),this.A=0|n.SHA224_IV[0],this.B=0|n.SHA224_IV[1],this.C=0|n.SHA224_IV[2],this.D=0|n.SHA224_IV[3],this.E=0|n.SHA224_IV[4],this.F=0|n.SHA224_IV[5],this.G=0|n.SHA224_IV[6],this.H=0|n.SHA224_IV[7]}}t.SHA224=u;const l=(()=>o.split(["0x428a2f98d728ae22","0x7137449123ef65cd","0xb5c0fbcfec4d3b2f","0xe9b5dba58189dbbc","0x3956c25bf348b538","0x59f111f1b605d019","0x923f82a4af194f9b","0xab1c5ed5da6d8118","0xd807aa98a3030242","0x12835b0145706fbe","0x243185be4ee4b28c","0x550c7dc3d5ffb4e2","0x72be5d74f27b896f","0x80deb1fe3b1696b1","0x9bdc06a725c71235","0xc19bf174cf692694","0xe49b69c19ef14ad2","0xefbe4786384f25e3","0x0fc19dc68b8cd5b5","0x240ca1cc77ac9c65","0x2de92c6f592b0275","0x4a7484aa6ea6e483","0x5cb0a9dcbd41fbd4","0x76f988da831153b5","0x983e5152ee66dfab","0xa831c66d2db43210","0xb00327c898fb213f","0xbf597fc7beef0ee4","0xc6e00bf33da88fc2","0xd5a79147930aa725","0x06ca6351e003826f","0x142929670a0e6e70","0x27b70a8546d22ffc","0x2e1b21385c26c926","0x4d2c6dfc5ac42aed","0x53380d139d95b3df","0x650a73548baf63de","0x766a0abb3c77b2a8","0x81c2c92e47edaee6","0x92722c851482353b","0xa2bfe8a14cf10364","0xa81a664bbc423001","0xc24b8b70d0f89791","0xc76c51a30654be30","0xd192e819d6ef5218","0xd69906245565a910","0xf40e35855771202a","0x106aa07032bbd1b8","0x19a4c116b8d2d0c8","0x1e376c085141ab53","0x2748774cdf8eeb99","0x34b0bcb5e19b48a8","0x391c0cb3c5c95a63","0x4ed8aa4ae3418acb","0x5b9cca4f7763e373","0x682e6ff3d6b2b8a3","0x748f82ee5defb2fc","0x78a5636f43172f60","0x84c87814a1f0ab72","0x8cc702081a6439ec","0x90befffa23631e28","0xa4506cebde82bde9","0xbef9a3f7b2c67915","0xc67178f2e372532b","0xca273eceea26619c","0xd186b8c721c0c207","0xeada7dd6cde0eb1e","0xf57d4f7fee6ed178","0x06f067aa72176fba","0x0a637dc5a2c898a6","0x113f9804bef90dae","0x1b710b35131c471b","0x28db77f523047d84","0x32caab7b40c72493","0x3c9ebe0a15c9bebc","0x431d67c49c100d4c","0x4cc5d4becb3e42b6","0x597f299cfc657e2a","0x5fcb6fab3ad6faec","0x6c44198c4a475817"].map(e=>BigInt(e))))(),f=(()=>l[0])(),h=(()=>l[1])(),d=new Uint32Array(80),p=new Uint32Array(80);class b extends n.HashMD{constructor(e=64){super(128,e,16,!1),this.Ah=0|n.SHA512_IV[0],this.Al=0|n.SHA512_IV[1],this.Bh=0|n.SHA512_IV[2],this.Bl=0|n.SHA512_IV[3],this.Ch=0|n.SHA512_IV[4],this.Cl=0|n.SHA512_IV[5],this.Dh=0|n.SHA512_IV[6],this.Dl=0|n.SHA512_IV[7],this.Eh=0|n.SHA512_IV[8],this.El=0|n.SHA512_IV[9],this.Fh=0|n.SHA512_IV[10],this.Fl=0|n.SHA512_IV[11],this.Gh=0|n.SHA512_IV[12],this.Gl=0|n.SHA512_IV[13],this.Hh=0|n.SHA512_IV[14],this.Hl=0|n.SHA512_IV[15]}get(){const{Ah:e,Al:t,Bh:r,Bl:n,Ch:o,Cl:i,Dh:a,Dl:s,Eh:c,El:u,Fh:l,Fl:f,Gh:h,Gl:d,Hh:p,Hl:b}=this;return[e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b]}set(e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b){this.Ah=0|e,this.Al=0|t,this.Bh=0|r,this.Bl=0|n,this.Ch=0|o,this.Cl=0|i,this.Dh=0|a,this.Dl=0|s,this.Eh=0|c,this.El=0|u,this.Fh=0|l,this.Fl=0|f,this.Gh=0|h,this.Gl=0|d,this.Hh=0|p,this.Hl=0|b}process(e,t){for(let r=0;r<16;r++,t+=4)d[r]=e.getUint32(t),p[r]=e.getUint32(t+=4);for(let e=16;e<80;e++){const t=0|d[e-15],r=0|p[e-15],n=o.rotrSH(t,r,1)^o.rotrSH(t,r,8)^o.shrSH(t,r,7),i=o.rotrSL(t,r,1)^o.rotrSL(t,r,8)^o.shrSL(t,r,7),a=0|d[e-2],s=0|p[e-2],c=o.rotrSH(a,s,19)^o.rotrBH(a,s,61)^o.shrSH(a,s,6),u=o.rotrSL(a,s,19)^o.rotrBL(a,s,61)^o.shrSL(a,s,6),l=o.add4L(i,u,p[e-7],p[e-16]),f=o.add4H(l,n,c,d[e-7],d[e-16]);d[e]=0|f,p[e]=0|l}let{Ah:r,Al:n,Bh:i,Bl:a,Ch:s,Cl:c,Dh:u,Dl:l,Eh:b,El:g,Fh:y,Fl:m,Gh:v,Gl:w,Hh:_,Hl:S}=this;for(let e=0;e<80;e++){const t=o.rotrSH(b,g,14)^o.rotrSH(b,g,18)^o.rotrBH(b,g,41),E=o.rotrSL(b,g,14)^o.rotrSL(b,g,18)^o.rotrBL(b,g,41),k=b&y^~b&v,A=g&m^~g&w,x=o.add5L(S,E,A,h[e],p[e]),I=o.add5H(x,_,t,k,f[e],d[e]),B=0|x,T=o.rotrSH(r,n,28)^o.rotrBH(r,n,34)^o.rotrBH(r,n,39),H=o.rotrSL(r,n,28)^o.rotrBL(r,n,34)^o.rotrBL(r,n,39),O=r&i^r&s^i&s,P=n&a^n&c^a&c;_=0|v,S=0|w,v=0|y,w=0|m,y=0|b,m=0|g,({h:b,l:g}=o.add(0|u,0|l,0|I,0|B)),u=0|s,l=0|c,s=0|i,c=0|a,i=0|r,a=0|n;const L=o.add3L(B,H,P);r=o.add3H(L,I,T,O),n=0|L}({h:r,l:n}=o.add(0|this.Ah,0|this.Al,0|r,0|n)),({h:i,l:a}=o.add(0|this.Bh,0|this.Bl,0|i,0|a)),({h:s,l:c}=o.add(0|this.Ch,0|this.Cl,0|s,0|c)),({h:u,l}=o.add(0|this.Dh,0|this.Dl,0|u,0|l)),({h:b,l:g}=o.add(0|this.Eh,0|this.El,0|b,0|g)),({h:y,l:m}=o.add(0|this.Fh,0|this.Fl,0|y,0|m)),({h:v,l:w}=o.add(0|this.Gh,0|this.Gl,0|v,0|w)),({h:_,l:S}=o.add(0|this.Hh,0|this.Hl,0|_,0|S)),this.set(r,n,i,a,s,c,u,l,b,g,y,m,v,w,_,S)}roundClean(){(0,i.clean)(d,p)}destroy(){(0,i.clean)(this.buffer),this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)}}t.SHA512=b;class g extends b{constructor(){super(48),this.Ah=0|n.SHA384_IV[0],this.Al=0|n.SHA384_IV[1],this.Bh=0|n.SHA384_IV[2],this.Bl=0|n.SHA384_IV[3],this.Ch=0|n.SHA384_IV[4],this.Cl=0|n.SHA384_IV[5],this.Dh=0|n.SHA384_IV[6],this.Dl=0|n.SHA384_IV[7],this.Eh=0|n.SHA384_IV[8],this.El=0|n.SHA384_IV[9],this.Fh=0|n.SHA384_IV[10],this.Fl=0|n.SHA384_IV[11],this.Gh=0|n.SHA384_IV[12],this.Gl=0|n.SHA384_IV[13],this.Hh=0|n.SHA384_IV[14],this.Hl=0|n.SHA384_IV[15]}}t.SHA384=g;const y=Uint32Array.from([2352822216,424955298,1944164710,2312950998,502970286,855612546,1738396948,1479516111,258812777,2077511080,2011393907,79989058,1067287976,1780299464,286451373,2446758561]),m=Uint32Array.from([573645204,4230739756,2673172387,3360449730,596883563,1867755857,2520282905,1497426621,2519219938,2827943907,3193839141,1401305490,721525244,746961066,246885852,2177182882]);class v extends b{constructor(){super(28),this.Ah=0|y[0],this.Al=0|y[1],this.Bh=0|y[2],this.Bl=0|y[3],this.Ch=0|y[4],this.Cl=0|y[5],this.Dh=0|y[6],this.Dl=0|y[7],this.Eh=0|y[8],this.El=0|y[9],this.Fh=0|y[10],this.Fl=0|y[11],this.Gh=0|y[12],this.Gl=0|y[13],this.Hh=0|y[14],this.Hl=0|y[15]}}t.SHA512_224=v;class w extends b{constructor(){super(32),this.Ah=0|m[0],this.Al=0|m[1],this.Bh=0|m[2],this.Bl=0|m[3],this.Ch=0|m[4],this.Cl=0|m[5],this.Dh=0|m[6],this.Dl=0|m[7],this.Eh=0|m[8],this.El=0|m[9],this.Fh=0|m[10],this.Fl=0|m[11],this.Gh=0|m[12],this.Gl=0|m[13],this.Hh=0|m[14],this.Hl=0|m[15]}}t.SHA512_256=w,t.sha256=(0,i.createHasher)(()=>new c),t.sha224=(0,i.createHasher)(()=>new u),t.sha512=(0,i.createHasher)(()=>new b),t.sha384=(0,i.createHasher)(()=>new g),t.sha512_256=(0,i.createHasher)(()=>new w),t.sha512_224=(0,i.createHasher)(()=>new v)},2710:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sha224=t.SHA224=t.sha256=t.SHA256=void 0;const n=r(8059);t.SHA256=n.SHA256,t.sha256=n.sha256,t.SHA224=n.SHA224,t.sha224=n.sha224},2078:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.wrapXOFConstructorWithOpts=t.wrapConstructorWithOpts=t.wrapConstructor=t.Hash=t.nextTick=t.swap32IfBE=t.byteSwapIfBE=t.swap8IfBE=t.isLE=void 0,t.isBytes=o,t.anumber=i,t.abytes=a,t.ahash=function(e){if("function"!=typeof e||"function"!=typeof e.create)throw new Error("Hash should be wrapped by utils.createHasher");i(e.outputLen),i(e.blockLen)},t.aexists=function(e,t=!0){if(e.destroyed)throw new Error("Hash instance has been destroyed");if(t&&e.finished)throw new Error("Hash#digest() has already been called")},t.aoutput=function(e,t){a(e);const r=t.outputLen;if(e.length<r)throw new Error("digestInto() expects output buffer of length at least "+r)},t.u8=function(e){return new Uint8Array(e.buffer,e.byteOffset,e.byteLength)},t.u32=function(e){return new Uint32Array(e.buffer,e.byteOffset,Math.floor(e.byteLength/4))},t.clean=function(...e){for(let t=0;t<e.length;t++)e[t].fill(0)},t.createView=function(e){return new DataView(e.buffer,e.byteOffset,e.byteLength)},t.rotr=function(e,t){return e<<32-t|e>>>t},t.rotl=function(e,t){return e<<t|e>>>32-t>>>0},t.byteSwap=s,t.byteSwap32=c,t.bytesToHex=function(e){if(a(e),u)return e.toHex();let t="";for(let r=0;r<e.length;r++)t+=l[e[r]];return t},t.hexToBytes=function(e){if("string"!=typeof e)throw new Error("hex string expected, got "+typeof e);if(u)return Uint8Array.fromHex(e);const t=e.length,r=t/2;if(t%2)throw new Error("hex string expected, got unpadded hex of length "+t);const n=new Uint8Array(r);for(let t=0,o=0;t<r;t++,o+=2){const r=h(e.charCodeAt(o)),i=h(e.charCodeAt(o+1));if(void 0===r||void 0===i){const t=e[o]+e[o+1];throw new Error('hex string expected, got non-hex character "'+t+'" at index '+o)}n[t]=16*r+i}return n},t.asyncLoop=async function(e,r,n){let o=Date.now();for(let i=0;i<e;i++){n(i);const e=Date.now()-o;e>=0&&e<r||(await(0,t.nextTick)(),o+=e)}},t.utf8ToBytes=d,t.bytesToUtf8=function(e){return(new TextDecoder).decode(e)},t.toBytes=p,t.kdfInputToBytes=function(e){return"string"==typeof e&&(e=d(e)),a(e),e},t.concatBytes=function(...e){let t=0;for(let r=0;r<e.length;r++){const n=e[r];a(n),t+=n.length}const r=new Uint8Array(t);for(let t=0,n=0;t<e.length;t++){const o=e[t];r.set(o,n),n+=o.length}return r},t.checkOpts=function(e,t){if(void 0!==t&&"[object Object]"!=={}.toString.call(t))throw new Error("options should be object or undefined");return Object.assign(e,t)},t.createHasher=b,t.createOptHasher=g,t.createXOFer=y,t.randomBytes=function(e=32){if(n.crypto&&"function"==typeof n.crypto.getRandomValues)return n.crypto.getRandomValues(new Uint8Array(e));if(n.crypto&&"function"==typeof n.crypto.randomBytes)return Uint8Array.from(n.crypto.randomBytes(e));throw new Error("crypto.getRandomValues must be defined")};const n=r(9433);function o(e){return e instanceof Uint8Array||ArrayBuffer.isView(e)&&"Uint8Array"===e.constructor.name}function i(e){if(!Number.isSafeInteger(e)||e<0)throw new Error("positive integer expected, got "+e)}function a(e,...t){if(!o(e))throw new Error("Uint8Array expected");if(t.length>0&&!t.includes(e.length))throw new Error("Uint8Array expected of length "+t+", got length="+e.length)}function s(e){return e<<24&4278190080|e<<8&16711680|e>>>8&65280|e>>>24&255}function c(e){for(let t=0;t<e.length;t++)e[t]=s(e[t]);return e}t.isLE=68===new Uint8Array(new Uint32Array([287454020]).buffer)[0],t.swap8IfBE=t.isLE?e=>e:e=>s(e),t.byteSwapIfBE=t.swap8IfBE,t.swap32IfBE=t.isLE?e=>e:c;const u=(()=>"function"==typeof Uint8Array.from([]).toHex&&"function"==typeof Uint8Array.fromHex)(),l=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0")),f={_0:48,_9:57,A:65,F:70,a:97,f:102};function h(e){return e>=f._0&&e<=f._9?e-f._0:e>=f.A&&e<=f.F?e-(f.A-10):e>=f.a&&e<=f.f?e-(f.a-10):void 0}function d(e){if("string"!=typeof e)throw new Error("string expected");return new Uint8Array((new TextEncoder).encode(e))}function p(e){return"string"==typeof e&&(e=d(e)),a(e),e}function b(e){const t=t=>e().update(p(t)).digest(),r=e();return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=()=>e(),t}function g(e){const t=(t,r)=>e(r).update(p(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t}function y(e){const t=(t,r)=>e(r).update(p(t)).digest(),r=e({});return t.outputLen=r.outputLen,t.blockLen=r.blockLen,t.create=t=>e(t),t}t.nextTick=async()=>{},t.Hash=class{},t.wrapConstructor=b,t.wrapConstructorWithOpts=g,t.wrapXOFConstructorWithOpts=y},8764:(e,t,r)=>{"use strict";const n=r(9742),o=r(645),i="function"==typeof Symbol&&"function"==typeof Symbol.for?Symbol.for("nodejs.util.inspect.custom"):null;t.Buffer=c,t.SlowBuffer=function(e){return+e!=e&&(e=0),c.alloc(+e)},t.INSPECT_MAX_BYTES=50;const a=2147483647;function s(e){if(e>a)throw new RangeError('The value "'+e+'" is invalid for option "size"');const t=new Uint8Array(e);return Object.setPrototypeOf(t,c.prototype),t}function c(e,t,r){if("number"==typeof e){if("string"==typeof t)throw new TypeError('The "string" argument must be of type string. Received type number');return f(e)}return u(e,t,r)}function u(e,t,r){if("string"==typeof e)return function(e,t){if("string"==typeof t&&""!==t||(t="utf8"),!c.isEncoding(t))throw new TypeError("Unknown encoding: "+t);const r=0|b(e,t);let n=s(r);const o=n.write(e,t);return o!==r&&(n=n.slice(0,o)),n}(e,t);if(ArrayBuffer.isView(e))return function(e){if(X(e,Uint8Array)){const t=new Uint8Array(e);return d(t.buffer,t.byteOffset,t.byteLength)}return h(e)}(e);if(null==e)throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type "+typeof e);if(X(e,ArrayBuffer)||e&&X(e.buffer,ArrayBuffer))return d(e,t,r);if("undefined"!=typeof SharedArrayBuffer&&(X(e,SharedArrayBuffer)||e&&X(e.buffer,SharedArrayBuffer)))return d(e,t,r);if("number"==typeof e)throw new TypeError('The "value" argument must not be of type number. Received type number');const n=e.valueOf&&e.valueOf();if(null!=n&&n!==e)return c.from(n,t,r);const o=function(e){if(c.isBuffer(e)){const t=0|p(e.length),r=s(t);return 0===r.length||e.copy(r,0,0,t),r}return void 0!==e.length?"number"!=typeof e.length||Y(e.length)?s(0):h(e):"Buffer"===e.type&&Array.isArray(e.data)?h(e.data):void 0}(e);if(o)return o;if("undefined"!=typeof Symbol&&null!=Symbol.toPrimitive&&"function"==typeof e[Symbol.toPrimitive])return c.from(e[Symbol.toPrimitive]("string"),t,r);throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type "+typeof e)}function l(e){if("number"!=typeof e)throw new TypeError('"size" argument must be of type number');if(e<0)throw new RangeError('The value "'+e+'" is invalid for option "size"')}function f(e){return l(e),s(e<0?0:0|p(e))}function h(e){const t=e.length<0?0:0|p(e.length),r=s(t);for(let n=0;n<t;n+=1)r[n]=255&e[n];return r}function d(e,t,r){if(t<0||e.byteLength<t)throw new RangeError('"offset" is outside of buffer bounds');if(e.byteLength<t+(r||0))throw new RangeError('"length" is outside of buffer bounds');let n;return n=void 0===t&&void 0===r?new Uint8Array(e):void 0===r?new Uint8Array(e,t):new Uint8Array(e,t,r),Object.setPrototypeOf(n,c.prototype),n}function p(e){if(e>=a)throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+a.toString(16)+" bytes");return 0|e}function b(e,t){if(c.isBuffer(e))return e.length;if(ArrayBuffer.isView(e)||X(e,ArrayBuffer))return e.byteLength;if("string"!=typeof e)throw new TypeError('The "string" argument must be one of type string, Buffer, or ArrayBuffer. Received type '+typeof e);const r=e.length,n=arguments.length>2&&!0===arguments[2];if(!n&&0===r)return 0;let o=!1;for(;;)switch(t){case"ascii":case"latin1":case"binary":return r;case"utf8":case"utf-8":return G(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*r;case"hex":return r>>>1;case"base64":return W(e).length;default:if(o)return n?-1:G(e).length;t=(""+t).toLowerCase(),o=!0}}function g(e,t,r){let n=!1;if((void 0===t||t<0)&&(t=0),t>this.length)return"";if((void 0===r||r>this.length)&&(r=this.length),r<=0)return"";if((r>>>=0)<=(t>>>=0))return"";for(e||(e="utf8");;)switch(e){case"hex":return H(this,t,r);case"utf8":case"utf-8":return x(this,t,r);case"ascii":return B(this,t,r);case"latin1":case"binary":return T(this,t,r);case"base64":return A(this,t,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return O(this,t,r);default:if(n)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),n=!0}}function y(e,t,r){const n=e[t];e[t]=e[r],e[r]=n}function m(e,t,r,n,o){if(0===e.length)return-1;if("string"==typeof r?(n=r,r=0):r>2147483647?r=2147483647:r<-2147483648&&(r=-2147483648),Y(r=+r)&&(r=o?0:e.length-1),r<0&&(r=e.length+r),r>=e.length){if(o)return-1;r=e.length-1}else if(r<0){if(!o)return-1;r=0}if("string"==typeof t&&(t=c.from(t,n)),c.isBuffer(t))return 0===t.length?-1:v(e,t,r,n,o);if("number"==typeof t)return t&=255,"function"==typeof Uint8Array.prototype.indexOf?o?Uint8Array.prototype.indexOf.call(e,t,r):Uint8Array.prototype.lastIndexOf.call(e,t,r):v(e,[t],r,n,o);throw new TypeError("val must be string, number or Buffer")}function v(e,t,r,n,o){let i,a=1,s=e.length,c=t.length;if(void 0!==n&&("ucs2"===(n=String(n).toLowerCase())||"ucs-2"===n||"utf16le"===n||"utf-16le"===n)){if(e.length<2||t.length<2)return-1;a=2,s/=2,c/=2,r/=2}function u(e,t){return 1===a?e[t]:e.readUInt16BE(t*a)}if(o){let n=-1;for(i=r;i<s;i++)if(u(e,i)===u(t,-1===n?0:i-n)){if(-1===n&&(n=i),i-n+1===c)return n*a}else-1!==n&&(i-=i-n),n=-1}else for(r+c>s&&(r=s-c),i=r;i>=0;i--){let r=!0;for(let n=0;n<c;n++)if(u(e,i+n)!==u(t,n)){r=!1;break}if(r)return i}return-1}function w(e,t,r,n){r=Number(r)||0;const o=e.length-r;n?(n=Number(n))>o&&(n=o):n=o;const i=t.length;let a;for(n>i/2&&(n=i/2),a=0;a<n;++a){const n=parseInt(t.substr(2*a,2),16);if(Y(n))return a;e[r+a]=n}return a}function _(e,t,r,n){return $(G(t,e.length-r),e,r,n)}function S(e,t,r,n){return $(function(e){const t=[];for(let r=0;r<e.length;++r)t.push(255&e.charCodeAt(r));return t}(t),e,r,n)}function E(e,t,r,n){return $(W(t),e,r,n)}function k(e,t,r,n){return $(function(e,t){let r,n,o;const i=[];for(let a=0;a<e.length&&!((t-=2)<0);++a)r=e.charCodeAt(a),n=r>>8,o=r%256,i.push(o),i.push(n);return i}(t,e.length-r),e,r,n)}function A(e,t,r){return 0===t&&r===e.length?n.fromByteArray(e):n.fromByteArray(e.slice(t,r))}function x(e,t,r){r=Math.min(e.length,r);const n=[];let o=t;for(;o<r;){const t=e[o];let i=null,a=t>239?4:t>223?3:t>191?2:1;if(o+a<=r){let r,n,s,c;switch(a){case 1:t<128&&(i=t);break;case 2:r=e[o+1],128==(192&r)&&(c=(31&t)<<6|63&r,c>127&&(i=c));break;case 3:r=e[o+1],n=e[o+2],128==(192&r)&&128==(192&n)&&(c=(15&t)<<12|(63&r)<<6|63&n,c>2047&&(c<55296||c>57343)&&(i=c));break;case 4:r=e[o+1],n=e[o+2],s=e[o+3],128==(192&r)&&128==(192&n)&&128==(192&s)&&(c=(15&t)<<18|(63&r)<<12|(63&n)<<6|63&s,c>65535&&c<1114112&&(i=c))}}null===i?(i=65533,a=1):i>65535&&(i-=65536,n.push(i>>>10&1023|55296),i=56320|1023&i),n.push(i),o+=a}return function(e){const t=e.length;if(t<=I)return String.fromCharCode.apply(String,e);let r="",n=0;for(;n<t;)r+=String.fromCharCode.apply(String,e.slice(n,n+=I));return r}(n)}t.kMaxLength=a,c.TYPED_ARRAY_SUPPORT=function(){try{const e=new Uint8Array(1),t={foo:function(){return 42}};return Object.setPrototypeOf(t,Uint8Array.prototype),Object.setPrototypeOf(e,t),42===e.foo()}catch(e){return!1}}(),c.TYPED_ARRAY_SUPPORT||"undefined"==typeof console||"function"!=typeof console.error||console.error("This browser lacks typed array (Uint8Array) support which is required by `buffer` v5.x. Use `buffer` v4.x if you require old browser support."),Object.defineProperty(c.prototype,"parent",{enumerable:!0,get:function(){if(c.isBuffer(this))return this.buffer}}),Object.defineProperty(c.prototype,"offset",{enumerable:!0,get:function(){if(c.isBuffer(this))return this.byteOffset}}),c.poolSize=8192,c.from=function(e,t,r){return u(e,t,r)},Object.setPrototypeOf(c.prototype,Uint8Array.prototype),Object.setPrototypeOf(c,Uint8Array),c.alloc=function(e,t,r){return function(e,t,r){return l(e),e<=0?s(e):void 0!==t?"string"==typeof r?s(e).fill(t,r):s(e).fill(t):s(e)}(e,t,r)},c.allocUnsafe=function(e){return f(e)},c.allocUnsafeSlow=function(e){return f(e)},c.isBuffer=function(e){return null!=e&&!0===e._isBuffer&&e!==c.prototype},c.compare=function(e,t){if(X(e,Uint8Array)&&(e=c.from(e,e.offset,e.byteLength)),X(t,Uint8Array)&&(t=c.from(t,t.offset,t.byteLength)),!c.isBuffer(e)||!c.isBuffer(t))throw new TypeError('The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array');if(e===t)return 0;let r=e.length,n=t.length;for(let o=0,i=Math.min(r,n);o<i;++o)if(e[o]!==t[o]){r=e[o],n=t[o];break}return r<n?-1:n<r?1:0},c.isEncoding=function(e){switch(String(e).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},c.concat=function(e,t){if(!Array.isArray(e))throw new TypeError('"list" argument must be an Array of Buffers');if(0===e.length)return c.alloc(0);let r;if(void 0===t)for(t=0,r=0;r<e.length;++r)t+=e[r].length;const n=c.allocUnsafe(t);let o=0;for(r=0;r<e.length;++r){let t=e[r];if(X(t,Uint8Array))o+t.length>n.length?(c.isBuffer(t)||(t=c.from(t)),t.copy(n,o)):Uint8Array.prototype.set.call(n,t,o);else{if(!c.isBuffer(t))throw new TypeError('"list" argument must be an Array of Buffers');t.copy(n,o)}o+=t.length}return n},c.byteLength=b,c.prototype._isBuffer=!0,c.prototype.swap16=function(){const e=this.length;if(e%2!=0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(let t=0;t<e;t+=2)y(this,t,t+1);return this},c.prototype.swap32=function(){const e=this.length;if(e%4!=0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(let t=0;t<e;t+=4)y(this,t,t+3),y(this,t+1,t+2);return this},c.prototype.swap64=function(){const e=this.length;if(e%8!=0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(let t=0;t<e;t+=8)y(this,t,t+7),y(this,t+1,t+6),y(this,t+2,t+5),y(this,t+3,t+4);return this},c.prototype.toString=function(){const e=this.length;return 0===e?"":0===arguments.length?x(this,0,e):g.apply(this,arguments)},c.prototype.toLocaleString=c.prototype.toString,c.prototype.equals=function(e){if(!c.isBuffer(e))throw new TypeError("Argument must be a Buffer");return this===e||0===c.compare(this,e)},c.prototype.inspect=function(){let e="";const r=t.INSPECT_MAX_BYTES;return e=this.toString("hex",0,r).replace(/(.{2})/g,"$1 ").trim(),this.length>r&&(e+=" ... "),"<Buffer "+e+">"},i&&(c.prototype[i]=c.prototype.inspect),c.prototype.compare=function(e,t,r,n,o){if(X(e,Uint8Array)&&(e=c.from(e,e.offset,e.byteLength)),!c.isBuffer(e))throw new TypeError('The "target" argument must be one of type Buffer or Uint8Array. Received type '+typeof e);if(void 0===t&&(t=0),void 0===r&&(r=e?e.length:0),void 0===n&&(n=0),void 0===o&&(o=this.length),t<0||r>e.length||n<0||o>this.length)throw new RangeError("out of range index");if(n>=o&&t>=r)return 0;if(n>=o)return-1;if(t>=r)return 1;if(this===e)return 0;let i=(o>>>=0)-(n>>>=0),a=(r>>>=0)-(t>>>=0);const s=Math.min(i,a),u=this.slice(n,o),l=e.slice(t,r);for(let e=0;e<s;++e)if(u[e]!==l[e]){i=u[e],a=l[e];break}return i<a?-1:a<i?1:0},c.prototype.includes=function(e,t,r){return-1!==this.indexOf(e,t,r)},c.prototype.indexOf=function(e,t,r){return m(this,e,t,r,!0)},c.prototype.lastIndexOf=function(e,t,r){return m(this,e,t,r,!1)},c.prototype.write=function(e,t,r,n){if(void 0===t)n="utf8",r=this.length,t=0;else if(void 0===r&&"string"==typeof t)n=t,r=this.length,t=0;else{if(!isFinite(t))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");t>>>=0,isFinite(r)?(r>>>=0,void 0===n&&(n="utf8")):(n=r,r=void 0)}const o=this.length-t;if((void 0===r||r>o)&&(r=o),e.length>0&&(r<0||t<0)||t>this.length)throw new RangeError("Attempt to write outside buffer bounds");n||(n="utf8");let i=!1;for(;;)switch(n){case"hex":return w(this,e,t,r);case"utf8":case"utf-8":return _(this,e,t,r);case"ascii":case"latin1":case"binary":return S(this,e,t,r);case"base64":return E(this,e,t,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return k(this,e,t,r);default:if(i)throw new TypeError("Unknown encoding: "+n);n=(""+n).toLowerCase(),i=!0}},c.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};const I=4096;function B(e,t,r){let n="";r=Math.min(e.length,r);for(let o=t;o<r;++o)n+=String.fromCharCode(127&e[o]);return n}function T(e,t,r){let n="";r=Math.min(e.length,r);for(let o=t;o<r;++o)n+=String.fromCharCode(e[o]);return n}function H(e,t,r){const n=e.length;(!t||t<0)&&(t=0),(!r||r<0||r>n)&&(r=n);let o="";for(let n=t;n<r;++n)o+=Z[e[n]];return o}function O(e,t,r){const n=e.slice(t,r);let o="";for(let e=0;e<n.length-1;e+=2)o+=String.fromCharCode(n[e]+256*n[e+1]);return o}function P(e,t,r){if(e%1!=0||e<0)throw new RangeError("offset is not uint");if(e+t>r)throw new RangeError("Trying to access beyond buffer length")}function L(e,t,r,n,o,i){if(!c.isBuffer(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>o||t<i)throw new RangeError('"value" argument is out of bounds');if(r+n>e.length)throw new RangeError("Index out of range")}function U(e,t,r,n,o){D(t,n,o,e,r,7);let i=Number(t&BigInt(4294967295));e[r++]=i,i>>=8,e[r++]=i,i>>=8,e[r++]=i,i>>=8,e[r++]=i;let a=Number(t>>BigInt(32)&BigInt(4294967295));return e[r++]=a,a>>=8,e[r++]=a,a>>=8,e[r++]=a,a>>=8,e[r++]=a,r}function j(e,t,r,n,o){D(t,n,o,e,r,7);let i=Number(t&BigInt(4294967295));e[r+7]=i,i>>=8,e[r+6]=i,i>>=8,e[r+5]=i,i>>=8,e[r+4]=i;let a=Number(t>>BigInt(32)&BigInt(4294967295));return e[r+3]=a,a>>=8,e[r+2]=a,a>>=8,e[r+1]=a,a>>=8,e[r]=a,r+8}function C(e,t,r,n,o,i){if(r+n>e.length)throw new RangeError("Index out of range");if(r<0)throw new RangeError("Index out of range")}function R(e,t,r,n,i){return t=+t,r>>>=0,i||C(e,0,r,4),o.write(e,t,r,n,23,4),r+4}function z(e,t,r,n,i){return t=+t,r>>>=0,i||C(e,0,r,8),o.write(e,t,r,n,52,8),r+8}c.prototype.slice=function(e,t){const r=this.length;(e=~~e)<0?(e+=r)<0&&(e=0):e>r&&(e=r),(t=void 0===t?r:~~t)<0?(t+=r)<0&&(t=0):t>r&&(t=r),t<e&&(t=e);const n=this.subarray(e,t);return Object.setPrototypeOf(n,c.prototype),n},c.prototype.readUintLE=c.prototype.readUIntLE=function(e,t,r){e>>>=0,t>>>=0,r||P(e,t,this.length);let n=this[e],o=1,i=0;for(;++i<t&&(o*=256);)n+=this[e+i]*o;return n},c.prototype.readUintBE=c.prototype.readUIntBE=function(e,t,r){e>>>=0,t>>>=0,r||P(e,t,this.length);let n=this[e+--t],o=1;for(;t>0&&(o*=256);)n+=this[e+--t]*o;return n},c.prototype.readUint8=c.prototype.readUInt8=function(e,t){return e>>>=0,t||P(e,1,this.length),this[e]},c.prototype.readUint16LE=c.prototype.readUInt16LE=function(e,t){return e>>>=0,t||P(e,2,this.length),this[e]|this[e+1]<<8},c.prototype.readUint16BE=c.prototype.readUInt16BE=function(e,t){return e>>>=0,t||P(e,2,this.length),this[e]<<8|this[e+1]},c.prototype.readUint32LE=c.prototype.readUInt32LE=function(e,t){return e>>>=0,t||P(e,4,this.length),(this[e]|this[e+1]<<8|this[e+2]<<16)+16777216*this[e+3]},c.prototype.readUint32BE=c.prototype.readUInt32BE=function(e,t){return e>>>=0,t||P(e,4,this.length),16777216*this[e]+(this[e+1]<<16|this[e+2]<<8|this[e+3])},c.prototype.readBigUInt64LE=J(function(e){F(e>>>=0,"offset");const t=this[e],r=this[e+7];void 0!==t&&void 0!==r||q(e,this.length-8);const n=t+256*this[++e]+65536*this[++e]+this[++e]*2**24,o=this[++e]+256*this[++e]+65536*this[++e]+r*2**24;return BigInt(n)+(BigInt(o)<<BigInt(32))}),c.prototype.readBigUInt64BE=J(function(e){F(e>>>=0,"offset");const t=this[e],r=this[e+7];void 0!==t&&void 0!==r||q(e,this.length-8);const n=t*2**24+65536*this[++e]+256*this[++e]+this[++e],o=this[++e]*2**24+65536*this[++e]+256*this[++e]+r;return(BigInt(n)<<BigInt(32))+BigInt(o)}),c.prototype.readIntLE=function(e,t,r){e>>>=0,t>>>=0,r||P(e,t,this.length);let n=this[e],o=1,i=0;for(;++i<t&&(o*=256);)n+=this[e+i]*o;return o*=128,n>=o&&(n-=Math.pow(2,8*t)),n},c.prototype.readIntBE=function(e,t,r){e>>>=0,t>>>=0,r||P(e,t,this.length);let n=t,o=1,i=this[e+--n];for(;n>0&&(o*=256);)i+=this[e+--n]*o;return o*=128,i>=o&&(i-=Math.pow(2,8*t)),i},c.prototype.readInt8=function(e,t){return e>>>=0,t||P(e,1,this.length),128&this[e]?-1*(255-this[e]+1):this[e]},c.prototype.readInt16LE=function(e,t){e>>>=0,t||P(e,2,this.length);const r=this[e]|this[e+1]<<8;return 32768&r?4294901760|r:r},c.prototype.readInt16BE=function(e,t){e>>>=0,t||P(e,2,this.length);const r=this[e+1]|this[e]<<8;return 32768&r?4294901760|r:r},c.prototype.readInt32LE=function(e,t){return e>>>=0,t||P(e,4,this.length),this[e]|this[e+1]<<8|this[e+2]<<16|this[e+3]<<24},c.prototype.readInt32BE=function(e,t){return e>>>=0,t||P(e,4,this.length),this[e]<<24|this[e+1]<<16|this[e+2]<<8|this[e+3]},c.prototype.readBigInt64LE=J(function(e){F(e>>>=0,"offset");const t=this[e],r=this[e+7];void 0!==t&&void 0!==r||q(e,this.length-8);const n=this[e+4]+256*this[e+5]+65536*this[e+6]+(r<<24);return(BigInt(n)<<BigInt(32))+BigInt(t+256*this[++e]+65536*this[++e]+this[++e]*2**24)}),c.prototype.readBigInt64BE=J(function(e){F(e>>>=0,"offset");const t=this[e],r=this[e+7];void 0!==t&&void 0!==r||q(e,this.length-8);const n=(t<<24)+65536*this[++e]+256*this[++e]+this[++e];return(BigInt(n)<<BigInt(32))+BigInt(this[++e]*2**24+65536*this[++e]+256*this[++e]+r)}),c.prototype.readFloatLE=function(e,t){return e>>>=0,t||P(e,4,this.length),o.read(this,e,!0,23,4)},c.prototype.readFloatBE=function(e,t){return e>>>=0,t||P(e,4,this.length),o.read(this,e,!1,23,4)},c.prototype.readDoubleLE=function(e,t){return e>>>=0,t||P(e,8,this.length),o.read(this,e,!0,52,8)},c.prototype.readDoubleBE=function(e,t){return e>>>=0,t||P(e,8,this.length),o.read(this,e,!1,52,8)},c.prototype.writeUintLE=c.prototype.writeUIntLE=function(e,t,r,n){e=+e,t>>>=0,r>>>=0,n||L(this,e,t,r,Math.pow(2,8*r)-1,0);let o=1,i=0;for(this[t]=255&e;++i<r&&(o*=256);)this[t+i]=e/o&255;return t+r},c.prototype.writeUintBE=c.prototype.writeUIntBE=function(e,t,r,n){e=+e,t>>>=0,r>>>=0,n||L(this,e,t,r,Math.pow(2,8*r)-1,0);let o=r-1,i=1;for(this[t+o]=255&e;--o>=0&&(i*=256);)this[t+o]=e/i&255;return t+r},c.prototype.writeUint8=c.prototype.writeUInt8=function(e,t,r){return e=+e,t>>>=0,r||L(this,e,t,1,255,0),this[t]=255&e,t+1},c.prototype.writeUint16LE=c.prototype.writeUInt16LE=function(e,t,r){return e=+e,t>>>=0,r||L(this,e,t,2,65535,0),this[t]=255&e,this[t+1]=e>>>8,t+2},c.prototype.writeUint16BE=c.prototype.writeUInt16BE=function(e,t,r){return e=+e,t>>>=0,r||L(this,e,t,2,65535,0),this[t]=e>>>8,this[t+1]=255&e,t+2},c.prototype.writeUint32LE=c.prototype.writeUInt32LE=function(e,t,r){return e=+e,t>>>=0,r||L(this,e,t,4,4294967295,0),this[t+3]=e>>>24,this[t+2]=e>>>16,this[t+1]=e>>>8,this[t]=255&e,t+4},c.prototype.writeUint32BE=c.prototype.writeUInt32BE=function(e,t,r){return e=+e,t>>>=0,r||L(this,e,t,4,4294967295,0),this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e,t+4},c.prototype.writeBigUInt64LE=J(function(e,t=0){return U(this,e,t,BigInt(0),BigInt("0xffffffffffffffff"))}),c.prototype.writeBigUInt64BE=J(function(e,t=0){return j(this,e,t,BigInt(0),BigInt("0xffffffffffffffff"))}),c.prototype.writeIntLE=function(e,t,r,n){if(e=+e,t>>>=0,!n){const n=Math.pow(2,8*r-1);L(this,e,t,r,n-1,-n)}let o=0,i=1,a=0;for(this[t]=255&e;++o<r&&(i*=256);)e<0&&0===a&&0!==this[t+o-1]&&(a=1),this[t+o]=(e/i|0)-a&255;return t+r},c.prototype.writeIntBE=function(e,t,r,n){if(e=+e,t>>>=0,!n){const n=Math.pow(2,8*r-1);L(this,e,t,r,n-1,-n)}let o=r-1,i=1,a=0;for(this[t+o]=255&e;--o>=0&&(i*=256);)e<0&&0===a&&0!==this[t+o+1]&&(a=1),this[t+o]=(e/i|0)-a&255;return t+r},c.prototype.writeInt8=function(e,t,r){return e=+e,t>>>=0,r||L(this,e,t,1,127,-128),e<0&&(e=255+e+1),this[t]=255&e,t+1},c.prototype.writeInt16LE=function(e,t,r){return e=+e,t>>>=0,r||L(this,e,t,2,32767,-32768),this[t]=255&e,this[t+1]=e>>>8,t+2},c.prototype.writeInt16BE=function(e,t,r){return e=+e,t>>>=0,r||L(this,e,t,2,32767,-32768),this[t]=e>>>8,this[t+1]=255&e,t+2},c.prototype.writeInt32LE=function(e,t,r){return e=+e,t>>>=0,r||L(this,e,t,4,2147483647,-2147483648),this[t]=255&e,this[t+1]=e>>>8,this[t+2]=e>>>16,this[t+3]=e>>>24,t+4},c.prototype.writeInt32BE=function(e,t,r){return e=+e,t>>>=0,r||L(this,e,t,4,2147483647,-2147483648),e<0&&(e=4294967295+e+1),this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e,t+4},c.prototype.writeBigInt64LE=J(function(e,t=0){return U(this,e,t,-BigInt("0x8000000000000000"),BigInt("0x7fffffffffffffff"))}),c.prototype.writeBigInt64BE=J(function(e,t=0){return j(this,e,t,-BigInt("0x8000000000000000"),BigInt("0x7fffffffffffffff"))}),c.prototype.writeFloatLE=function(e,t,r){return R(this,e,t,!0,r)},c.prototype.writeFloatBE=function(e,t,r){return R(this,e,t,!1,r)},c.prototype.writeDoubleLE=function(e,t,r){return z(this,e,t,!0,r)},c.prototype.writeDoubleBE=function(e,t,r){return z(this,e,t,!1,r)},c.prototype.copy=function(e,t,r,n){if(!c.isBuffer(e))throw new TypeError("argument should be a Buffer");if(r||(r=0),n||0===n||(n=this.length),t>=e.length&&(t=e.length),t||(t=0),n>0&&n<r&&(n=r),n===r)return 0;if(0===e.length||0===this.length)return 0;if(t<0)throw new RangeError("targetStart out of bounds");if(r<0||r>=this.length)throw new RangeError("Index out of range");if(n<0)throw new RangeError("sourceEnd out of bounds");n>this.length&&(n=this.length),e.length-t<n-r&&(n=e.length-t+r);const o=n-r;return this===e&&"function"==typeof Uint8Array.prototype.copyWithin?this.copyWithin(t,r,n):Uint8Array.prototype.set.call(e,this.subarray(r,n),t),o},c.prototype.fill=function(e,t,r,n){if("string"==typeof e){if("string"==typeof t?(n=t,t=0,r=this.length):"string"==typeof r&&(n=r,r=this.length),void 0!==n&&"string"!=typeof n)throw new TypeError("encoding must be a string");if("string"==typeof n&&!c.isEncoding(n))throw new TypeError("Unknown encoding: "+n);if(1===e.length){const t=e.charCodeAt(0);("utf8"===n&&t<128||"latin1"===n)&&(e=t)}}else"number"==typeof e?e&=255:"boolean"==typeof e&&(e=Number(e));if(t<0||this.length<t||this.length<r)throw new RangeError("Out of range index");if(r<=t)return this;let o;if(t>>>=0,r=void 0===r?this.length:r>>>0,e||(e=0),"number"==typeof e)for(o=t;o<r;++o)this[o]=e;else{const i=c.isBuffer(e)?e:c.from(e,n),a=i.length;if(0===a)throw new TypeError('The value "'+e+'" is invalid for argument "value"');for(o=0;o<r-t;++o)this[o+t]=i[o%a]}return this};const N={};function M(e,t,r){N[e]=class extends r{constructor(){super(),Object.defineProperty(this,"message",{value:t.apply(this,arguments),writable:!0,configurable:!0}),this.name=`${this.name} [${e}]`,this.stack,delete this.name}get code(){return e}set code(e){Object.defineProperty(this,"code",{configurable:!0,enumerable:!0,value:e,writable:!0})}toString(){return`${this.name} [${e}]: ${this.message}`}}}function V(e){let t="",r=e.length;const n="-"===e[0]?1:0;for(;r>=n+4;r-=3)t=`_${e.slice(r-3,r)}${t}`;return`${e.slice(0,r)}${t}`}function D(e,t,r,n,o,i){if(e>r||e<t){const n="bigint"==typeof t?"n":"";let o;throw o=i>3?0===t||t===BigInt(0)?`>= 0${n} and < 2${n} ** ${8*(i+1)}${n}`:`>= -(2${n} ** ${8*(i+1)-1}${n}) and < 2 ** ${8*(i+1)-1}${n}`:`>= ${t}${n} and <= ${r}${n}`,new N.ERR_OUT_OF_RANGE("value",o,e)}!function(e,t,r){F(t,"offset"),void 0!==e[t]&&void 0!==e[t+r]||q(t,e.length-(r+1))}(n,o,i)}function F(e,t){if("number"!=typeof e)throw new N.ERR_INVALID_ARG_TYPE(t,"number",e)}function q(e,t,r){if(Math.floor(e)!==e)throw F(e,r),new N.ERR_OUT_OF_RANGE(r||"offset","an integer",e);if(t<0)throw new N.ERR_BUFFER_OUT_OF_BOUNDS;throw new N.ERR_OUT_OF_RANGE(r||"offset",`>= ${r?1:0} and <= ${t}`,e)}M("ERR_BUFFER_OUT_OF_BOUNDS",function(e){return e?`${e} is outside of buffer bounds`:"Attempt to access memory outside buffer bounds"},RangeError),M("ERR_INVALID_ARG_TYPE",function(e,t){return`The "${e}" argument must be of type number. Received type ${typeof t}`},TypeError),M("ERR_OUT_OF_RANGE",function(e,t,r){let n=`The value of "${e}" is out of range.`,o=r;return Number.isInteger(r)&&Math.abs(r)>2**32?o=V(String(r)):"bigint"==typeof r&&(o=String(r),(r>BigInt(2)**BigInt(32)||r<-(BigInt(2)**BigInt(32)))&&(o=V(o)),o+="n"),n+=` It must be ${t}. Received ${o}`,n},RangeError);const K=/[^+/0-9A-Za-z-_]/g;function G(e,t){let r;t=t||1/0;const n=e.length;let o=null;const i=[];for(let a=0;a<n;++a){if(r=e.charCodeAt(a),r>55295&&r<57344){if(!o){if(r>56319){(t-=3)>-1&&i.push(239,191,189);continue}if(a+1===n){(t-=3)>-1&&i.push(239,191,189);continue}o=r;continue}if(r<56320){(t-=3)>-1&&i.push(239,191,189),o=r;continue}r=65536+(o-55296<<10|r-56320)}else o&&(t-=3)>-1&&i.push(239,191,189);if(o=null,r<128){if((t-=1)<0)break;i.push(r)}else if(r<2048){if((t-=2)<0)break;i.push(r>>6|192,63&r|128)}else if(r<65536){if((t-=3)<0)break;i.push(r>>12|224,r>>6&63|128,63&r|128)}else{if(!(r<1114112))throw new Error("Invalid code point");if((t-=4)<0)break;i.push(r>>18|240,r>>12&63|128,r>>6&63|128,63&r|128)}}return i}function W(e){return n.toByteArray(function(e){if((e=(e=e.split("=")[0]).trim().replace(K,"")).length<2)return"";for(;e.length%4!=0;)e+="=";return e}(e))}function $(e,t,r,n){let o;for(o=0;o<n&&!(o+r>=t.length||o>=e.length);++o)t[o+r]=e[o];return o}function X(e,t){return e instanceof t||null!=e&&null!=e.constructor&&null!=e.constructor.name&&e.constructor.name===t.name}function Y(e){return e!=e}const Z=function(){const e="0123456789abcdef",t=new Array(256);for(let r=0;r<16;++r){const n=16*r;for(let o=0;o<16;++o)t[n+o]=e[r]+e[o]}return t}();function J(e){return"undefined"==typeof BigInt?Q:e}function Q(){throw new Error("BigInt not supported")}},5116:(e,t,r)=>{"use strict";var n=r(8612),o=r(1768),i=r(8928),a=r(9770);e.exports=a||n.call(i,o)},3192:(e,t,r)=>{"use strict";var n=r(8612),o=r(1768),i=r(5116);e.exports=function(){return i(n,o,arguments)}},1768:e=>{"use strict";e.exports=Function.prototype.apply},8928:e=>{"use strict";e.exports=Function.prototype.call},319:(e,t,r)=>{"use strict";var n=r(8612),o=r(4453),i=r(8928),a=r(5116);e.exports=function(e){if(e.length<1||"function"!=typeof e[0])throw new o("a function is required");return a(n,i,e)}},9770:e=>{"use strict";e.exports="undefined"!=typeof Reflect&&Reflect&&Reflect.apply},5559:(e,t,r)=>{"use strict";var n=r(7771),o=r(4429),i=r(319),a=r(3192);e.exports=function(e){var t=i(arguments),r=e.length-(arguments.length-1);return n(t,1+(r>0?r:0),!0)},o?o(e.exports,"apply",{value:a}):e.exports.apply=a},7379:(e,t,r)=>{"use strict";var n=r(210),o=r(319),i=o([n("%String.prototype.indexOf%")]);e.exports=function(e,t){var r=n(e,!!t);return"function"==typeof r&&i(e,".prototype.")>-1?o([r]):r}},1027:(e,t,r)=>{"use strict";var n=r(9509).Buffer,o=r(2830).Transform,i=r(2553).s,a=r(5717),s=r(5309);function c(e){o.call(this),this.hashMode="string"==typeof e,this.hashMode?this[e]=this._finalOrDigest:this.final=this._finalOrDigest,this._final&&(this.__final=this._final,this._final=null),this._decoder=null,this._encoding=null}a(c,o),c.prototype.update=function(e,t,r){var n=s(e,t),o=this._update(n);return this.hashMode?this:(r&&(o=this._toString(o,r)),o)},c.prototype.setAutoPadding=function(){},c.prototype.getAuthTag=function(){throw new Error("trying to get auth tag in unsupported state")},c.prototype.setAuthTag=function(){throw new Error("trying to set auth tag in unsupported state")},c.prototype.setAAD=function(){throw new Error("trying to set aad in unsupported state")},c.prototype._transform=function(e,t,r){var n;try{this.hashMode?this._update(e):this.push(this._update(e))}catch(e){n=e}finally{r(n)}},c.prototype._flush=function(e){var t;try{this.push(this.__final())}catch(e){t=e}e(t)},c.prototype._finalOrDigest=function(e){var t=this.__final()||n.alloc(0);return e&&(t=this._toString(t,e,!0)),t},c.prototype._toString=function(e,t,r){if(this._decoder||(this._decoder=new i(t),this._encoding=t),this._encoding!==t)throw new Error("can’t switch encodings");var n=this._decoder.write(e);return r&&(n+=this._decoder.end()),n},e.exports=c},6497:(e,t,r)=>{function n(e){return Object.prototype.toString.call(e)}t.isArray=function(e){return Array.isArray?Array.isArray(e):"[object Array]"===n(e)},t.isBoolean=function(e){return"boolean"==typeof e},t.isNull=function(e){return null===e},t.isNullOrUndefined=function(e){return null==e},t.isNumber=function(e){return"number"==typeof e},t.isString=function(e){return"string"==typeof e},t.isSymbol=function(e){return"symbol"==typeof e},t.isUndefined=function(e){return void 0===e},t.isRegExp=function(e){return"[object RegExp]"===n(e)},t.isObject=function(e){return"object"==typeof e&&null!==e},t.isDate=function(e){return"[object Date]"===n(e)},t.isError=function(e){return"[object Error]"===n(e)||e instanceof Error},t.isFunction=function(e){return"function"==typeof e},t.isPrimitive=function(e){return null===e||"boolean"==typeof e||"number"==typeof e||"string"==typeof e||"symbol"==typeof e||void 0===e},t.isBuffer=r(8764).Buffer.isBuffer},3482:(e,t,r)=>{"use strict";var n=r(5717),o=r(2318),i=r(9785),a=r(9072),s=r(1027);function c(e){s.call(this,"digest"),this._hash=e}n(c,s),c.prototype._update=function(e){this._hash.update(e)},c.prototype._final=function(){return this._hash.digest()},e.exports=function(e){return"md5"===(e=e.toLowerCase())?new o:"rmd160"===e||"ripemd160"===e?new i:new c(a(e))}},2296:(e,t,r)=>{"use strict";var n=r(4429),o=r(3464),i=r(4453),a=r(7296);e.exports=function(e,t,r){if(!e||"object"!=typeof e&&"function"!=typeof e)throw new i("`obj` must be an object or a function`");if("string"!=typeof t&&"symbol"!=typeof t)throw new i("`property` must be a string or a symbol`");if(arguments.length>3&&"boolean"!=typeof arguments[3]&&null!==arguments[3])throw new i("`nonEnumerable`, if provided, must be a boolean or null");if(arguments.length>4&&"boolean"!=typeof arguments[4]&&null!==arguments[4])throw new i("`nonWritable`, if provided, must be a boolean or null");if(arguments.length>5&&"boolean"!=typeof arguments[5]&&null!==arguments[5])throw new i("`nonConfigurable`, if provided, must be a boolean or null");if(arguments.length>6&&"boolean"!=typeof arguments[6])throw new i("`loose`, if provided, must be a boolean");var s=arguments.length>3?arguments[3]:null,c=arguments.length>4?arguments[4]:null,u=arguments.length>5?arguments[5]:null,l=arguments.length>6&&arguments[6],f=!!a&&a(e,t);if(n)n(e,t,{configurable:null===u&&f?f.configurable:!u,enumerable:null===s&&f?f.enumerable:!s,value:r,writable:null===c&&f?f.writable:!c});else{if(!l&&(s||c||u))throw new o("This environment does not support defining a property as non-configurable, non-writable, or non-enumerable.");e[t]=r}}},6504:(e,t,r)=>{"use strict";var n,o=r(319),i=r(7296);try{n=[].__proto__===Array.prototype}catch(e){if(!e||"object"!=typeof e||!("code"in e)||"ERR_PROTO_ACCESS"!==e.code)throw e}var a=!!n&&i&&i(Object.prototype,"__proto__"),s=Object,c=s.getPrototypeOf;e.exports=a&&"function"==typeof a.get?o([a.get]):"function"==typeof c&&function(e){return c(null==e?e:s(e))}},4429:e=>{"use strict";var t=Object.defineProperty||!1;if(t)try{t({},"a",{value:1})}catch(e){t=!1}e.exports=t},3981:e=>{"use strict";e.exports=EvalError},1648:e=>{"use strict";e.exports=Error},4726:e=>{"use strict";e.exports=RangeError},6712:e=>{"use strict";e.exports=ReferenceError},3464:e=>{"use strict";e.exports=SyntaxError},4453:e=>{"use strict";e.exports=TypeError},3915:e=>{"use strict";e.exports=URIError},8892:e=>{"use strict";e.exports=Object},7187:e=>{"use strict";var t,r="object"==typeof Reflect?Reflect:null,n=r&&"function"==typeof r.apply?r.apply:function(e,t,r){return Function.prototype.apply.call(e,t,r)};t=r&&"function"==typeof r.ownKeys?r.ownKeys:Object.getOwnPropertySymbols?function(e){return Object.getOwnPropertyNames(e).concat(Object.getOwnPropertySymbols(e))}:function(e){return Object.getOwnPropertyNames(e)};var o=Number.isNaN||function(e){return e!=e};function i(){i.init.call(this)}e.exports=i,e.exports.once=function(e,t){return new Promise(function(r,n){function o(r){e.removeListener(t,i),n(r)}function i(){"function"==typeof e.removeListener&&e.removeListener("error",o),r([].slice.call(arguments))}b(e,t,i,{once:!0}),"error"!==t&&function(e,t){"function"==typeof e.on&&b(e,"error",t,{once:!0})}(e,o)})},i.EventEmitter=i,i.prototype._events=void 0,i.prototype._eventsCount=0,i.prototype._maxListeners=void 0;var a=10;function s(e){if("function"!=typeof e)throw new TypeError('The "listener" argument must be of type Function. Received type '+typeof e)}function c(e){return void 0===e._maxListeners?i.defaultMaxListeners:e._maxListeners}function u(e,t,r,n){var o,i,a,u;if(s(r),void 0===(i=e._events)?(i=e._events=Object.create(null),e._eventsCount=0):(void 0!==i.newListener&&(e.emit("newListener",t,r.listener?r.listener:r),i=e._events),a=i[t]),void 0===a)a=i[t]=r,++e._eventsCount;else if("function"==typeof a?a=i[t]=n?[r,a]:[a,r]:n?a.unshift(r):a.push(r),(o=c(e))>0&&a.length>o&&!a.warned){a.warned=!0;var l=new Error("Possible EventEmitter memory leak detected. "+a.length+" "+String(t)+" listeners added. Use emitter.setMaxListeners() to increase limit");l.name="MaxListenersExceededWarning",l.emitter=e,l.type=t,l.count=a.length,u=l,console&&console.warn&&console.warn(u)}return e}function l(){if(!this.fired)return this.target.removeListener(this.type,this.wrapFn),this.fired=!0,0===arguments.length?this.listener.call(this.target):this.listener.apply(this.target,arguments)}function f(e,t,r){var n={fired:!1,wrapFn:void 0,target:e,type:t,listener:r},o=l.bind(n);return o.listener=r,n.wrapFn=o,o}function h(e,t,r){var n=e._events;if(void 0===n)return[];var o=n[t];return void 0===o?[]:"function"==typeof o?r?[o.listener||o]:[o]:r?function(e){for(var t=new Array(e.length),r=0;r<t.length;++r)t[r]=e[r].listener||e[r];return t}(o):p(o,o.length)}function d(e){var t=this._events;if(void 0!==t){var r=t[e];if("function"==typeof r)return 1;if(void 0!==r)return r.length}return 0}function p(e,t){for(var r=new Array(t),n=0;n<t;++n)r[n]=e[n];return r}function b(e,t,r,n){if("function"==typeof e.on)n.once?e.once(t,r):e.on(t,r);else{if("function"!=typeof e.addEventListener)throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type '+typeof e);e.addEventListener(t,function o(i){n.once&&e.removeEventListener(t,o),r(i)})}}Object.defineProperty(i,"defaultMaxListeners",{enumerable:!0,get:function(){return a},set:function(e){if("number"!=typeof e||e<0||o(e))throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received '+e+".");a=e}}),i.init=function(){void 0!==this._events&&this._events!==Object.getPrototypeOf(this)._events||(this._events=Object.create(null),this._eventsCount=0),this._maxListeners=this._maxListeners||void 0},i.prototype.setMaxListeners=function(e){if("number"!=typeof e||e<0||o(e))throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received '+e+".");return this._maxListeners=e,this},i.prototype.getMaxListeners=function(){return c(this)},i.prototype.emit=function(e){for(var t=[],r=1;r<arguments.length;r++)t.push(arguments[r]);var o="error"===e,i=this._events;if(void 0!==i)o=o&&void 0===i.error;else if(!o)return!1;if(o){var a;if(t.length>0&&(a=t[0]),a instanceof Error)throw a;var s=new Error("Unhandled error."+(a?" ("+a.message+")":""));throw s.context=a,s}var c=i[e];if(void 0===c)return!1;if("function"==typeof c)n(c,this,t);else{var u=c.length,l=p(c,u);for(r=0;r<u;++r)n(l[r],this,t)}return!0},i.prototype.addListener=function(e,t){return u(this,e,t,!1)},i.prototype.on=i.prototype.addListener,i.prototype.prependListener=function(e,t){return u(this,e,t,!0)},i.prototype.once=function(e,t){return s(t),this.on(e,f(this,e,t)),this},i.prototype.prependOnceListener=function(e,t){return s(t),this.prependListener(e,f(this,e,t)),this},i.prototype.removeListener=function(e,t){var r,n,o,i,a;if(s(t),void 0===(n=this._events))return this;if(void 0===(r=n[e]))return this;if(r===t||r.listener===t)0===--this._eventsCount?this._events=Object.create(null):(delete n[e],n.removeListener&&this.emit("removeListener",e,r.listener||t));else if("function"!=typeof r){for(o=-1,i=r.length-1;i>=0;i--)if(r[i]===t||r[i].listener===t){a=r[i].listener,o=i;break}if(o<0)return this;0===o?r.shift():function(e,t){for(;t+1<e.length;t++)e[t]=e[t+1];e.pop()}(r,o),1===r.length&&(n[e]=r[0]),void 0!==n.removeListener&&this.emit("removeListener",e,a||t)}return this},i.prototype.off=i.prototype.removeListener,i.prototype.removeAllListeners=function(e){var t,r,n;if(void 0===(r=this._events))return this;if(void 0===r.removeListener)return 0===arguments.length?(this._events=Object.create(null),this._eventsCount=0):void 0!==r[e]&&(0===--this._eventsCount?this._events=Object.create(null):delete r[e]),this;if(0===arguments.length){var o,i=Object.keys(r);for(n=0;n<i.length;++n)"removeListener"!==(o=i[n])&&this.removeAllListeners(o);return this.removeAllListeners("removeListener"),this._events=Object.create(null),this._eventsCount=0,this}if("function"==typeof(t=r[e]))this.removeListener(e,t);else if(void 0!==t)for(n=t.length-1;n>=0;n--)this.removeListener(e,t[n]);return this},i.prototype.listeners=function(e){return h(this,e,!0)},i.prototype.rawListeners=function(e){return h(this,e,!1)},i.listenerCount=function(e,t){return"function"==typeof e.listenerCount?e.listenerCount(t):d.call(e,t)},i.prototype.listenerCount=d,i.prototype.eventNames=function(){return this._eventsCount>0?t(this._events):[]}},4029:(e,t,r)=>{"use strict";var n=r(5320),o=Object.prototype.toString,i=Object.prototype.hasOwnProperty;e.exports=function(e,t,r){if(!n(t))throw new TypeError("iterator must be a function");var a,s;arguments.length>=3&&(a=r),s=e,"[object Array]"===o.call(s)?function(e,t,r){for(var n=0,o=e.length;n<o;n++)i.call(e,n)&&(null==r?t(e[n],n,e):t.call(r,e[n],n,e))}(e,t,a):"string"==typeof e?function(e,t,r){for(var n=0,o=e.length;n<o;n++)null==r?t(e.charAt(n),n,e):t.call(r,e.charAt(n),n,e)}(e,t,a):function(e,t,r){for(var n in e)i.call(e,n)&&(null==r?t(e[n],n,e):t.call(r,e[n],n,e))}(e,t,a)}},7648:e=>{"use strict";var t=Object.prototype.toString,r=Math.max,n=function(e,t){for(var r=[],n=0;n<e.length;n+=1)r[n]=e[n];for(var o=0;o<t.length;o+=1)r[o+e.length]=t[o];return r};e.exports=function(e){var o=this;if("function"!=typeof o||"[object Function]"!==t.apply(o))throw new TypeError("Function.prototype.bind called on incompatible "+o);for(var i,a=function(e){for(var t=[],r=1,n=0;r<e.length;r+=1,n+=1)t[n]=e[r];return t}(arguments),s=r(0,o.length-a.length),c=[],u=0;u<s;u++)c[u]="$"+u;if(i=Function("binder","return function ("+function(e){for(var t="",r=0;r<e.length;r+=1)t+=e[r],r+1<e.length&&(t+=",");return t}(c)+"){ return binder.apply(this,arguments); }")(function(){if(this instanceof i){var t=o.apply(this,n(a,arguments));return Object(t)===t?t:this}return o.apply(e,n(a,arguments))}),o.prototype){var l=function(){};l.prototype=o.prototype,i.prototype=new l,l.prototype=null}return i}},8612:(e,t,r)=>{"use strict";var n=r(7648);e.exports=Function.prototype.bind||n},210:(e,t,r)=>{"use strict";var n,o=r(8892),i=r(1648),a=r(3981),s=r(4726),c=r(6712),u=r(3464),l=r(4453),f=r(3915),h=r(9738),d=r(6329),p=r(2264),b=r(5730),g=r(707),y=r(3862),m=r(9550),v=Function,w=function(e){try{return v('"use strict"; return ('+e+").constructor;")()}catch(e){}},_=r(7296),S=r(4429),E=function(){throw new l},k=_?function(){try{return E}catch(e){try{return _(arguments,"callee").get}catch(e){return E}}}():E,A=r(1405)(),x=r(1618),I=r(8899),B=r(443),T=r(1768),H=r(8928),O={},P="undefined"!=typeof Uint8Array&&x?x(Uint8Array):n,L={__proto__:null,"%AggregateError%":"undefined"==typeof AggregateError?n:AggregateError,"%Array%":Array,"%ArrayBuffer%":"undefined"==typeof ArrayBuffer?n:ArrayBuffer,"%ArrayIteratorPrototype%":A&&x?x([][Symbol.iterator]()):n,"%AsyncFromSyncIteratorPrototype%":n,"%AsyncFunction%":O,"%AsyncGenerator%":O,"%AsyncGeneratorFunction%":O,"%AsyncIteratorPrototype%":O,"%Atomics%":"undefined"==typeof Atomics?n:Atomics,"%BigInt%":"undefined"==typeof BigInt?n:BigInt,"%BigInt64Array%":"undefined"==typeof BigInt64Array?n:BigInt64Array,"%BigUint64Array%":"undefined"==typeof BigUint64Array?n:BigUint64Array,"%Boolean%":Boolean,"%DataView%":"undefined"==typeof DataView?n:DataView,"%Date%":Date,"%decodeURI%":decodeURI,"%decodeURIComponent%":decodeURIComponent,"%encodeURI%":encodeURI,"%encodeURIComponent%":encodeURIComponent,"%Error%":i,"%eval%":eval,"%EvalError%":a,"%Float16Array%":"undefined"==typeof Float16Array?n:Float16Array,"%Float32Array%":"undefined"==typeof Float32Array?n:Float32Array,"%Float64Array%":"undefined"==typeof Float64Array?n:Float64Array,"%FinalizationRegistry%":"undefined"==typeof FinalizationRegistry?n:FinalizationRegistry,"%Function%":v,"%GeneratorFunction%":O,"%Int8Array%":"undefined"==typeof Int8Array?n:Int8Array,"%Int16Array%":"undefined"==typeof Int16Array?n:Int16Array,"%Int32Array%":"undefined"==typeof Int32Array?n:Int32Array,"%isFinite%":isFinite,"%isNaN%":isNaN,"%IteratorPrototype%":A&&x?x(x([][Symbol.iterator]())):n,"%JSON%":"object"==typeof JSON?JSON:n,"%Map%":"undefined"==typeof Map?n:Map,"%MapIteratorPrototype%":"undefined"!=typeof Map&&A&&x?x((new Map)[Symbol.iterator]()):n,"%Math%":Math,"%Number%":Number,"%Object%":o,"%Object.getOwnPropertyDescriptor%":_,"%parseFloat%":parseFloat,"%parseInt%":parseInt,"%Promise%":"undefined"==typeof Promise?n:Promise,"%Proxy%":"undefined"==typeof Proxy?n:Proxy,"%RangeError%":s,"%ReferenceError%":c,"%Reflect%":"undefined"==typeof Reflect?n:Reflect,"%RegExp%":RegExp,"%Set%":"undefined"==typeof Set?n:Set,"%SetIteratorPrototype%":"undefined"!=typeof Set&&A&&x?x((new Set)[Symbol.iterator]()):n,"%SharedArrayBuffer%":"undefined"==typeof SharedArrayBuffer?n:SharedArrayBuffer,"%String%":String,"%StringIteratorPrototype%":A&&x?x(""[Symbol.iterator]()):n,"%Symbol%":A?Symbol:n,"%SyntaxError%":u,"%ThrowTypeError%":k,"%TypedArray%":P,"%TypeError%":l,"%Uint8Array%":"undefined"==typeof Uint8Array?n:Uint8Array,"%Uint8ClampedArray%":"undefined"==typeof Uint8ClampedArray?n:Uint8ClampedArray,"%Uint16Array%":"undefined"==typeof Uint16Array?n:Uint16Array,"%Uint32Array%":"undefined"==typeof Uint32Array?n:Uint32Array,"%URIError%":f,"%WeakMap%":"undefined"==typeof WeakMap?n:WeakMap,"%WeakRef%":"undefined"==typeof WeakRef?n:WeakRef,"%WeakSet%":"undefined"==typeof WeakSet?n:WeakSet,"%Function.prototype.call%":H,"%Function.prototype.apply%":T,"%Object.defineProperty%":S,"%Object.getPrototypeOf%":I,"%Math.abs%":h,"%Math.floor%":d,"%Math.max%":p,"%Math.min%":b,"%Math.pow%":g,"%Math.round%":y,"%Math.sign%":m,"%Reflect.getPrototypeOf%":B};if(x)try{null.error}catch(e){var U=x(x(e));L["%Error.prototype%"]=U}var j=function e(t){var r;if("%AsyncFunction%"===t)r=w("async function () {}");else if("%GeneratorFunction%"===t)r=w("function* () {}");else if("%AsyncGeneratorFunction%"===t)r=w("async function* () {}");else if("%AsyncGenerator%"===t){var n=e("%AsyncGeneratorFunction%");n&&(r=n.prototype)}else if("%AsyncIteratorPrototype%"===t){var o=e("%AsyncGenerator%");o&&x&&(r=x(o.prototype))}return L[t]=r,r},C={__proto__:null,"%ArrayBufferPrototype%":["ArrayBuffer","prototype"],"%ArrayPrototype%":["Array","prototype"],"%ArrayProto_entries%":["Array","prototype","entries"],"%ArrayProto_forEach%":["Array","prototype","forEach"],"%ArrayProto_keys%":["Array","prototype","keys"],"%ArrayProto_values%":["Array","prototype","values"],"%AsyncFunctionPrototype%":["AsyncFunction","prototype"],"%AsyncGenerator%":["AsyncGeneratorFunction","prototype"],"%AsyncGeneratorPrototype%":["AsyncGeneratorFunction","prototype","prototype"],"%BooleanPrototype%":["Boolean","prototype"],"%DataViewPrototype%":["DataView","prototype"],"%DatePrototype%":["Date","prototype"],"%ErrorPrototype%":["Error","prototype"],"%EvalErrorPrototype%":["EvalError","prototype"],"%Float32ArrayPrototype%":["Float32Array","prototype"],"%Float64ArrayPrototype%":["Float64Array","prototype"],"%FunctionPrototype%":["Function","prototype"],"%Generator%":["GeneratorFunction","prototype"],"%GeneratorPrototype%":["GeneratorFunction","prototype","prototype"],"%Int8ArrayPrototype%":["Int8Array","prototype"],"%Int16ArrayPrototype%":["Int16Array","prototype"],"%Int32ArrayPrototype%":["Int32Array","prototype"],"%JSONParse%":["JSON","parse"],"%JSONStringify%":["JSON","stringify"],"%MapPrototype%":["Map","prototype"],"%NumberPrototype%":["Number","prototype"],"%ObjectPrototype%":["Object","prototype"],"%ObjProto_toString%":["Object","prototype","toString"],"%ObjProto_valueOf%":["Object","prototype","valueOf"],"%PromisePrototype%":["Promise","prototype"],"%PromiseProto_then%":["Promise","prototype","then"],"%Promise_all%":["Promise","all"],"%Promise_reject%":["Promise","reject"],"%Promise_resolve%":["Promise","resolve"],"%RangeErrorPrototype%":["RangeError","prototype"],"%ReferenceErrorPrototype%":["ReferenceError","prototype"],"%RegExpPrototype%":["RegExp","prototype"],"%SetPrototype%":["Set","prototype"],"%SharedArrayBufferPrototype%":["SharedArrayBuffer","prototype"],"%StringPrototype%":["String","prototype"],"%SymbolPrototype%":["Symbol","prototype"],"%SyntaxErrorPrototype%":["SyntaxError","prototype"],"%TypedArrayPrototype%":["TypedArray","prototype"],"%TypeErrorPrototype%":["TypeError","prototype"],"%Uint8ArrayPrototype%":["Uint8Array","prototype"],"%Uint8ClampedArrayPrototype%":["Uint8ClampedArray","prototype"],"%Uint16ArrayPrototype%":["Uint16Array","prototype"],"%Uint32ArrayPrototype%":["Uint32Array","prototype"],"%URIErrorPrototype%":["URIError","prototype"],"%WeakMapPrototype%":["WeakMap","prototype"],"%WeakSetPrototype%":["WeakSet","prototype"]},R=r(8612),z=r(8824),N=R.call(H,Array.prototype.concat),M=R.call(T,Array.prototype.splice),V=R.call(H,String.prototype.replace),D=R.call(H,String.prototype.slice),F=R.call(H,RegExp.prototype.exec),q=/[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g,K=/\\(\\)?/g,G=function(e,t){var r,n=e;if(z(C,n)&&(n="%"+(r=C[n])[0]+"%"),z(L,n)){var o=L[n];if(o===O&&(o=j(n)),void 0===o&&!t)throw new l("intrinsic "+e+" exists, but is not available. Please file an issue!");return{alias:r,name:n,value:o}}throw new u("intrinsic "+e+" does not exist!")};e.exports=function(e,t){if("string"!=typeof e||0===e.length)throw new l("intrinsic name must be a non-empty string");if(arguments.length>1&&"boolean"!=typeof t)throw new l('"allowMissing" argument must be a boolean');if(null===F(/^%?[^%]*%?$/,e))throw new u("`%` may not be present anywhere but at the beginning and end of the intrinsic name");var r=function(e){var t=D(e,0,1),r=D(e,-1);if("%"===t&&"%"!==r)throw new u("invalid intrinsic syntax, expected closing `%`");if("%"===r&&"%"!==t)throw new u("invalid intrinsic syntax, expected opening `%`");var n=[];return V(e,q,function(e,t,r,o){n[n.length]=r?V(o,K,"$1"):t||e}),n}(e),n=r.length>0?r[0]:"",o=G("%"+n+"%",t),i=o.name,a=o.value,s=!1,c=o.alias;c&&(n=c[0],M(r,N([0,1],c)));for(var f=1,h=!0;f<r.length;f+=1){var d=r[f],p=D(d,0,1),b=D(d,-1);if(('"'===p||"'"===p||"`"===p||'"'===b||"'"===b||"`"===b)&&p!==b)throw new u("property names with quotes must have matching quotes");if("constructor"!==d&&h||(s=!0),z(L,i="%"+(n+="."+d)+"%"))a=L[i];else if(null!=a){if(!(d in a)){if(!t)throw new l("base intrinsic for "+e+" exists, but the property is not available.");return}if(_&&f+1>=r.length){var g=_(a,d);a=(h=!!g)&&"get"in g&&!("originalValue"in g.get)?g.get:a[d]}else h=z(a,d),a=a[d];h&&!s&&(L[i]=a)}}return a}},8899:(e,t,r)=>{"use strict";var n=r(8892);e.exports=n.getPrototypeOf||null},443:e=>{"use strict";e.exports="undefined"!=typeof Reflect&&Reflect.getPrototypeOf||null},1618:(e,t,r)=>{"use strict";var n=r(443),o=r(8899),i=r(6504);e.exports=n?function(e){return n(e)}:o?function(e){if(!e||"object"!=typeof e&&"function"!=typeof e)throw new TypeError("getProto: not an object");return o(e)}:i?function(e){return i(e)}:null},690:e=>{"use strict";e.exports=Object.getOwnPropertyDescriptor},7296:(e,t,r)=>{"use strict";var n=r(690);if(n)try{n([],"length")}catch(e){n=null}e.exports=n},1044:(e,t,r)=>{"use strict";var n=r(4429),o=function(){return!!n};o.hasArrayLengthDefineBug=function(){if(!n)return null;try{return 1!==n([],"length",{value:1}).length}catch(e){return!0}},e.exports=o},1405:(e,t,r)=>{"use strict";var n="undefined"!=typeof Symbol&&Symbol,o=r(5419);e.exports=function(){return"function"==typeof n&&"function"==typeof Symbol&&"symbol"==typeof n("foo")&&"symbol"==typeof Symbol("bar")&&o()}},5419:e=>{"use strict";e.exports=function(){if("function"!=typeof Symbol||"function"!=typeof Object.getOwnPropertySymbols)return!1;if("symbol"==typeof Symbol.iterator)return!0;var e={},t=Symbol("test"),r=Object(t);if("string"==typeof t)return!1;if("[object Symbol]"!==Object.prototype.toString.call(t))return!1;if("[object Symbol]"!==Object.prototype.toString.call(r))return!1;for(var n in e[t]=42,e)return!1;if("function"==typeof Object.keys&&0!==Object.keys(e).length)return!1;if("function"==typeof Object.getOwnPropertyNames&&0!==Object.getOwnPropertyNames(e).length)return!1;var o=Object.getOwnPropertySymbols(e);if(1!==o.length||o[0]!==t)return!1;if(!Object.prototype.propertyIsEnumerable.call(e,t))return!1;if("function"==typeof Object.getOwnPropertyDescriptor){var i=Object.getOwnPropertyDescriptor(e,t);if(42!==i.value||!0!==i.enumerable)return!1}return!0}},6410:(e,t,r)=>{"use strict";var n=r(5419);e.exports=function(){return n()&&!!Symbol.toStringTag}},3349:(e,t,r)=>{"use strict";var n=r(9509).Buffer,o=r(37),i=r(8473).Transform;function a(e){i.call(this),this._block=n.allocUnsafe(e),this._blockSize=e,this._blockOffset=0,this._length=[0,0,0,0],this._finalized=!1}r(5717)(a,i),a.prototype._transform=function(e,t,r){var n=null;try{this.update(e,t)}catch(e){n=e}r(n)},a.prototype._flush=function(e){var t=null;try{this.push(this.digest())}catch(e){t=e}e(t)},a.prototype.update=function(e,t){if(this._finalized)throw new Error("Digest already called");for(var r=o(e,t),n=this._block,i=0;this._blockOffset+r.length-i>=this._blockSize;){for(var a=this._blockOffset;a<this._blockSize;)n[a]=r[i],a+=1,i+=1;this._update(),this._blockOffset=0}for(;i<r.length;)n[this._blockOffset]=r[i],this._blockOffset+=1,i+=1;for(var s=0,c=8*r.length;c>0;++s)this._length[s]+=c,(c=this._length[s]/4294967296|0)>0&&(this._length[s]-=4294967296*c);return this},a.prototype._update=function(){throw new Error("_update is not implemented")},a.prototype.digest=function(e){if(this._finalized)throw new Error("Digest already called");this._finalized=!0;var t=this._digest();void 0!==e&&(t=t.toString(e)),this._block.fill(0),this._blockOffset=0;for(var r=0;r<4;++r)this._length[r]=0;return t},a.prototype._digest=function(){throw new Error("_digest is not implemented")},e.exports=a},37:(e,t,r)=>{"use strict";var n=r(9509).Buffer,o=r(5309),i="undefined"!=typeof Uint8Array,a=i&&"undefined"!=typeof ArrayBuffer&&ArrayBuffer.isView;e.exports=function(e,t){if("string"==typeof e||n.isBuffer(e)||i&&e instanceof Uint8Array||a&&a(e))return o(e,t);throw new TypeError('The "data" argument must be a string, a Buffer, a Uint8Array, or a DataView')}},8824:(e,t,r)=>{"use strict";var n=Function.prototype.call,o=Object.prototype.hasOwnProperty,i=r(8612);e.exports=i.call(n,o)},645:(e,t)=>{t.read=function(e,t,r,n,o){var i,a,s=8*o-n-1,c=(1<<s)-1,u=c>>1,l=-7,f=r?o-1:0,h=r?-1:1,d=e[t+f];for(f+=h,i=d&(1<<-l)-1,d>>=-l,l+=s;l>0;i=256*i+e[t+f],f+=h,l-=8);for(a=i&(1<<-l)-1,i>>=-l,l+=n;l>0;a=256*a+e[t+f],f+=h,l-=8);if(0===i)i=1-u;else{if(i===c)return a?NaN:1/0*(d?-1:1);a+=Math.pow(2,n),i-=u}return(d?-1:1)*a*Math.pow(2,i-n)},t.write=function(e,t,r,n,o,i){var a,s,c,u=8*i-o-1,l=(1<<u)-1,f=l>>1,h=23===o?Math.pow(2,-24)-Math.pow(2,-77):0,d=n?0:i-1,p=n?1:-1,b=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(s=isNaN(t)?1:0,a=l):(a=Math.floor(Math.log(t)/Math.LN2),t*(c=Math.pow(2,-a))<1&&(a--,c*=2),(t+=a+f>=1?h/c:h*Math.pow(2,1-f))*c>=2&&(a++,c/=2),a+f>=l?(s=0,a=l):a+f>=1?(s=(t*c-1)*Math.pow(2,o),a+=f):(s=t*Math.pow(2,f-1)*Math.pow(2,o),a=0));o>=8;e[r+d]=255&s,d+=p,s/=256,o-=8);for(a=a<<o|s,u+=o;u>0;e[r+d]=255&a,d+=p,a/=256,u-=8);e[r+d-p]|=128*b}},5717:e=>{"function"==typeof Object.create?e.exports=function(e,t){t&&(e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}))}:e.exports=function(e,t){if(t){e.super_=t;var r=function(){};r.prototype=t.prototype,e.prototype=new r,e.prototype.constructor=e}}},5320:e=>{"use strict";var t,r,n=Function.prototype.toString,o="object"==typeof Reflect&&null!==Reflect&&Reflect.apply;if("function"==typeof o&&"function"==typeof Object.defineProperty)try{t=Object.defineProperty({},"length",{get:function(){throw r}}),r={},o(function(){throw 42},null,t)}catch(e){e!==r&&(o=null)}else o=null;var i=/^\s*class\b/,a=function(e){try{var t=n.call(e);return i.test(t)}catch(e){return!1}},s=function(e){try{return!a(e)&&(n.call(e),!0)}catch(e){return!1}},c=Object.prototype.toString,u="function"==typeof Symbol&&!!Symbol.toStringTag,l=!(0 in[,]),f=function(){return!1};if("object"==typeof document){var h=document.all;c.call(h)===c.call(document.all)&&(f=function(e){if((l||!e)&&(void 0===e||"object"==typeof e))try{var t=c.call(e);return("[object HTMLAllCollection]"===t||"[object HTML document.all class]"===t||"[object HTMLCollection]"===t||"[object Object]"===t)&&null==e("")}catch(e){}return!1})}e.exports=o?function(e){if(f(e))return!0;if(!e)return!1;if("function"!=typeof e&&"object"!=typeof e)return!1;try{o(e,null,t)}catch(e){if(e!==r)return!1}return!a(e)&&s(e)}:function(e){if(f(e))return!0;if(!e)return!1;if("function"!=typeof e&&"object"!=typeof e)return!1;if(u)return s(e);if(a(e))return!1;var t=c.call(e);return!("[object Function]"!==t&&"[object GeneratorFunction]"!==t&&!/^\[object HTML/.test(t))&&s(e)}},5692:(e,t,r)=>{"use strict";var n=r(6430);e.exports=function(e){return!!n(e)}},5826:e=>{var t={}.toString;e.exports=Array.isArray||function(e){return"[object Array]"==t.call(e)}},9738:e=>{"use strict";e.exports=Math.abs},6329:e=>{"use strict";e.exports=Math.floor},3678:e=>{"use strict";e.exports=Number.isNaN||function(e){return e!=e}},2264:e=>{"use strict";e.exports=Math.max},5730:e=>{"use strict";e.exports=Math.min},707:e=>{"use strict";e.exports=Math.pow},3862:e=>{"use strict";e.exports=Math.round},9550:(e,t,r)=>{"use strict";var n=r(3678);e.exports=function(e){return n(e)||0===e?e:e<0?-1:1}},2318:(e,t,r)=>{"use strict";var n=r(5717),o=r(3349),i=r(9509).Buffer,a=new Array(16);function s(){o.call(this,64),this._a=1732584193,this._b=4023233417,this._c=2562383102,this._d=271733878}function c(e,t){return e<<t|e>>>32-t}function u(e,t,r,n,o,i,a){return c(e+(t&r|~t&n)+o+i|0,a)+t|0}function l(e,t,r,n,o,i,a){return c(e+(t&n|r&~n)+o+i|0,a)+t|0}function f(e,t,r,n,o,i,a){return c(e+(t^r^n)+o+i|0,a)+t|0}function h(e,t,r,n,o,i,a){return c(e+(r^(t|~n))+o+i|0,a)+t|0}n(s,o),s.prototype._update=function(){for(var e=a,t=0;t<16;++t)e[t]=this._block.readInt32LE(4*t);var r=this._a,n=this._b,o=this._c,i=this._d;r=u(r,n,o,i,e[0],3614090360,7),i=u(i,r,n,o,e[1],3905402710,12),o=u(o,i,r,n,e[2],606105819,17),n=u(n,o,i,r,e[3],3250441966,22),r=u(r,n,o,i,e[4],4118548399,7),i=u(i,r,n,o,e[5],1200080426,12),o=u(o,i,r,n,e[6],2821735955,17),n=u(n,o,i,r,e[7],4249261313,22),r=u(r,n,o,i,e[8],1770035416,7),i=u(i,r,n,o,e[9],2336552879,12),o=u(o,i,r,n,e[10],4294925233,17),n=u(n,o,i,r,e[11],2304563134,22),r=u(r,n,o,i,e[12],1804603682,7),i=u(i,r,n,o,e[13],4254626195,12),o=u(o,i,r,n,e[14],2792965006,17),r=l(r,n=u(n,o,i,r,e[15],1236535329,22),o,i,e[1],4129170786,5),i=l(i,r,n,o,e[6],3225465664,9),o=l(o,i,r,n,e[11],643717713,14),n=l(n,o,i,r,e[0],3921069994,20),r=l(r,n,o,i,e[5],3593408605,5),i=l(i,r,n,o,e[10],38016083,9),o=l(o,i,r,n,e[15],3634488961,14),n=l(n,o,i,r,e[4],3889429448,20),r=l(r,n,o,i,e[9],568446438,5),i=l(i,r,n,o,e[14],3275163606,9),o=l(o,i,r,n,e[3],4107603335,14),n=l(n,o,i,r,e[8],1163531501,20),r=l(r,n,o,i,e[13],2850285829,5),i=l(i,r,n,o,e[2],4243563512,9),o=l(o,i,r,n,e[7],1735328473,14),r=f(r,n=l(n,o,i,r,e[12],2368359562,20),o,i,e[5],4294588738,4),i=f(i,r,n,o,e[8],2272392833,11),o=f(o,i,r,n,e[11],1839030562,16),n=f(n,o,i,r,e[14],4259657740,23),r=f(r,n,o,i,e[1],2763975236,4),i=f(i,r,n,o,e[4],1272893353,11),o=f(o,i,r,n,e[7],4139469664,16),n=f(n,o,i,r,e[10],3200236656,23),r=f(r,n,o,i,e[13],681279174,4),i=f(i,r,n,o,e[0],3936430074,11),o=f(o,i,r,n,e[3],3572445317,16),n=f(n,o,i,r,e[6],76029189,23),r=f(r,n,o,i,e[9],3654602809,4),i=f(i,r,n,o,e[12],3873151461,11),o=f(o,i,r,n,e[15],530742520,16),r=h(r,n=f(n,o,i,r,e[2],3299628645,23),o,i,e[0],4096336452,6),i=h(i,r,n,o,e[7],1126891415,10),o=h(o,i,r,n,e[14],2878612391,15),n=h(n,o,i,r,e[5],4237533241,21),r=h(r,n,o,i,e[12],1700485571,6),i=h(i,r,n,o,e[3],2399980690,10),o=h(o,i,r,n,e[10],4293915773,15),n=h(n,o,i,r,e[1],2240044497,21),r=h(r,n,o,i,e[8],1873313359,6),i=h(i,r,n,o,e[15],4264355552,10),o=h(o,i,r,n,e[6],2734768916,15),n=h(n,o,i,r,e[13],1309151649,21),r=h(r,n,o,i,e[4],4149444226,6),i=h(i,r,n,o,e[11],3174756917,10),o=h(o,i,r,n,e[2],718787259,15),n=h(n,o,i,r,e[9],3951481745,21),this._a=this._a+r|0,this._b=this._b+n|0,this._c=this._c+o|0,this._d=this._d+i|0},s.prototype._digest=function(){this._block[this._blockOffset++]=128,this._blockOffset>56&&(this._block.fill(0,this._blockOffset,64),this._update(),this._blockOffset=0),this._block.fill(0,this._blockOffset,56),this._block.writeUInt32LE(this._length[0],56),this._block.writeUInt32LE(this._length[1],60),this._update();var e=i.allocUnsafe(16);return e.writeInt32LE(this._a,0),e.writeInt32LE(this._b,4),e.writeInt32LE(this._c,8),e.writeInt32LE(this._d,12),e},e.exports=s},9908:e=>{"use strict";e.exports=["Float16Array","Float32Array","Float64Array","Int8Array","Int16Array","Int32Array","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","BigInt64Array","BigUint64Array"]},8212:(e,t,r)=>{"use strict";var n=r(4155);void 0===n||!n.version||0===n.version.indexOf("v0.")||0===n.version.indexOf("v1.")&&0!==n.version.indexOf("v1.8.")?e.exports={nextTick:function(e,t,r,o){if("function"!=typeof e)throw new TypeError('"callback" argument must be a function');var i,a,s=arguments.length;switch(s){case 0:case 1:return n.nextTick(e);case 2:return n.nextTick(function(){e.call(null,t)});case 3:return n.nextTick(function(){e.call(null,t,r)});case 4:return n.nextTick(function(){e.call(null,t,r,o)});default:for(i=new Array(s-1),a=0;a<i.length;)i[a++]=arguments[a];return n.nextTick(function(){e.apply(null,i)})}}}:e.exports=n},4155:e=>{var t,r,n=e.exports={};function o(){throw new Error("setTimeout has not been defined")}function i(){throw new Error("clearTimeout has not been defined")}function a(e){if(t===setTimeout)return setTimeout(e,0);if((t===o||!t)&&setTimeout)return t=setTimeout,setTimeout(e,0);try{return t(e,0)}catch(r){try{return t.call(null,e,0)}catch(r){return t.call(this,e,0)}}}!function(){try{t="function"==typeof setTimeout?setTimeout:o}catch(e){t=o}try{r="function"==typeof clearTimeout?clearTimeout:i}catch(e){r=i}}();var s,c=[],u=!1,l=-1;function f(){u&&s&&(u=!1,s.length?c=s.concat(c):l=-1,c.length&&h())}function h(){if(!u){var e=a(f);u=!0;for(var t=c.length;t;){for(s=c,c=[];++l<t;)s&&s[l].run();l=-1,t=c.length}s=null,u=!1,function(e){if(r===clearTimeout)return clearTimeout(e);if((r===i||!r)&&clearTimeout)return r=clearTimeout,clearTimeout(e);try{return r(e)}catch(t){try{return r.call(null,e)}catch(t){return r.call(this,e)}}}(e)}}function d(e,t){this.fun=e,this.array=t}function p(){}n.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var r=1;r<arguments.length;r++)t[r-1]=arguments[r];c.push(new d(e,t)),1!==c.length||u||a(h)},d.prototype.run=function(){this.fun.apply(null,this.array)},n.title="browser",n.browser=!0,n.env={},n.argv=[],n.version="",n.versions={},n.on=p,n.addListener=p,n.once=p,n.off=p,n.removeListener=p,n.removeAllListeners=p,n.emit=p,n.prependListener=p,n.prependOnceListener=p,n.listeners=function(e){return[]},n.binding=function(e){throw new Error("process.binding is not supported")},n.cwd=function(){return"/"},n.chdir=function(e){throw new Error("process.chdir is not supported")},n.umask=function(){return 0}},6753:(e,t,r)=>{"use strict";var n=r(8212),o=Object.keys||function(e){var t=[];for(var r in e)t.push(r);return t};e.exports=f;var i=Object.create(r(6497));i.inherits=r(5717);var a=r(9481),s=r(4229);i.inherits(f,a);for(var c=o(s.prototype),u=0;u<c.length;u++){var l=c[u];f.prototype[l]||(f.prototype[l]=s.prototype[l])}function f(e){if(!(this instanceof f))return new f(e);a.call(this,e),s.call(this,e),e&&!1===e.readable&&(this.readable=!1),e&&!1===e.writable&&(this.writable=!1),this.allowHalfOpen=!0,e&&!1===e.allowHalfOpen&&(this.allowHalfOpen=!1),this.once("end",h)}function h(){this.allowHalfOpen||this._writableState.ended||n.nextTick(d,this)}function d(e){e.end()}Object.defineProperty(f.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),Object.defineProperty(f.prototype,"destroyed",{get:function(){return void 0!==this._readableState&&void 0!==this._writableState&&this._readableState.destroyed&&this._writableState.destroyed},set:function(e){void 0!==this._readableState&&void 0!==this._writableState&&(this._readableState.destroyed=e,this._writableState.destroyed=e)}}),f.prototype._destroy=function(e,t){this.push(null),this.end(),n.nextTick(t,e)}},2725:(e,t,r)=>{"use strict";e.exports=i;var n=r(4605),o=Object.create(r(6497));function i(e){if(!(this instanceof i))return new i(e);n.call(this,e)}o.inherits=r(5717),o.inherits(i,n),i.prototype._transform=function(e,t,r){r(null,e)}},9481:(e,t,r)=>{"use strict";var n=r(4155),o=r(8212);e.exports=v;var i,a=r(5826);v.ReadableState=m,r(7187).EventEmitter;var s=function(e,t){return e.listeners(t).length},c=r(2503),u=r(3545).Buffer,l=(void 0!==r.g?r.g:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){},f=Object.create(r(6497));f.inherits=r(5717);var h=r(4616),d=void 0;d=h&&h.debuglog?h.debuglog("stream"):function(){};var p,b=r(5057),g=r(1195);f.inherits(v,c);var y=["error","close","destroy","pause","resume"];function m(e,t){e=e||{};var n=t instanceof(i=i||r(6753));this.objectMode=!!e.objectMode,n&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var o=e.highWaterMark,a=e.readableHighWaterMark,s=this.objectMode?16:16384;this.highWaterMark=o||0===o?o:n&&(a||0===a)?a:s,this.highWaterMark=Math.floor(this.highWaterMark),this.buffer=new b,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.destroyed=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(p||(p=r(2553).s),this.decoder=new p(e.encoding),this.encoding=e.encoding)}function v(e){if(i=i||r(6753),!(this instanceof v))return new v(e);this._readableState=new m(e,this),this.readable=!0,e&&("function"==typeof e.read&&(this._read=e.read),"function"==typeof e.destroy&&(this._destroy=e.destroy)),c.call(this)}function w(e,t,r,n,o){var i,a=e._readableState;return null===t?(a.reading=!1,function(e,t){if(!t.ended){if(t.decoder){var r=t.decoder.end();r&&r.length&&(t.buffer.push(r),t.length+=t.objectMode?1:r.length)}t.ended=!0,k(e)}}(e,a)):(o||(i=function(e,t){var r,n;return n=t,u.isBuffer(n)||n instanceof l||"string"==typeof t||void 0===t||e.objectMode||(r=new TypeError("Invalid non-string/buffer chunk")),r}(a,t)),i?e.emit("error",i):a.objectMode||t&&t.length>0?("string"==typeof t||a.objectMode||Object.getPrototypeOf(t)===u.prototype||(t=function(e){return u.from(e)}(t)),n?a.endEmitted?e.emit("error",new Error("stream.unshift() after end event")):_(e,a,t,!0):a.ended?e.emit("error",new Error("stream.push() after EOF")):(a.reading=!1,a.decoder&&!r?(t=a.decoder.write(t),a.objectMode||0!==t.length?_(e,a,t,!1):x(e,a)):_(e,a,t,!1))):n||(a.reading=!1)),function(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||0===e.length)}(a)}function _(e,t,r,n){t.flowing&&0===t.length&&!t.sync?(e.emit("data",r),e.read(0)):(t.length+=t.objectMode?1:r.length,n?t.buffer.unshift(r):t.buffer.push(r),t.needReadable&&k(e)),x(e,t)}Object.defineProperty(v.prototype,"destroyed",{get:function(){return void 0!==this._readableState&&this._readableState.destroyed},set:function(e){this._readableState&&(this._readableState.destroyed=e)}}),v.prototype.destroy=g.destroy,v.prototype._undestroy=g.undestroy,v.prototype._destroy=function(e,t){this.push(null),t(e)},v.prototype.push=function(e,t){var r,n=this._readableState;return n.objectMode?r=!0:"string"==typeof e&&((t=t||n.defaultEncoding)!==n.encoding&&(e=u.from(e,t),t=""),r=!0),w(this,e,t,!1,r)},v.prototype.unshift=function(e){return w(this,e,null,!0,!1)},v.prototype.isPaused=function(){return!1===this._readableState.flowing},v.prototype.setEncoding=function(e){return p||(p=r(2553).s),this._readableState.decoder=new p(e),this._readableState.encoding=e,this};var S=8388608;function E(e,t){return e<=0||0===t.length&&t.ended?0:t.objectMode?1:e!=e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=function(e){return e>=S?e=S:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function k(e){var t=e._readableState;t.needReadable=!1,t.emittedReadable||(d("emitReadable",t.flowing),t.emittedReadable=!0,t.sync?o.nextTick(A,e):A(e))}function A(e){d("emit readable"),e.emit("readable"),H(e)}function x(e,t){t.readingMore||(t.readingMore=!0,o.nextTick(I,e,t))}function I(e,t){for(var r=t.length;!t.reading&&!t.flowing&&!t.ended&&t.length<t.highWaterMark&&(d("maybeReadMore read 0"),e.read(0),r!==t.length);)r=t.length;t.readingMore=!1}function B(e){d("readable nexttick read 0"),e.read(0)}function T(e,t){t.reading||(d("resume read 0"),e.read(0)),t.resumeScheduled=!1,t.awaitDrain=0,e.emit("resume"),H(e),t.flowing&&!t.reading&&e.read(0)}function H(e){var t=e._readableState;for(d("flow",t.flowing);t.flowing&&null!==e.read(););}function O(e,t){return 0===t.length?null:(t.objectMode?r=t.buffer.shift():!e||e>=t.length?(r=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.head.data:t.buffer.concat(t.length),t.buffer.clear()):r=function(e,t,r){var n;return e<t.head.data.length?(n=t.head.data.slice(0,e),t.head.data=t.head.data.slice(e)):n=e===t.head.data.length?t.shift():r?function(e,t){var r=t.head,n=1,o=r.data;for(e-=o.length;r=r.next;){var i=r.data,a=e>i.length?i.length:e;if(a===i.length?o+=i:o+=i.slice(0,e),0===(e-=a)){a===i.length?(++n,r.next?t.head=r.next:t.head=t.tail=null):(t.head=r,r.data=i.slice(a));break}++n}return t.length-=n,o}(e,t):function(e,t){var r=u.allocUnsafe(e),n=t.head,o=1;for(n.data.copy(r),e-=n.data.length;n=n.next;){var i=n.data,a=e>i.length?i.length:e;if(i.copy(r,r.length-e,0,a),0===(e-=a)){a===i.length?(++o,n.next?t.head=n.next:t.head=t.tail=null):(t.head=n,n.data=i.slice(a));break}++o}return t.length-=o,r}(e,t),n}(e,t.buffer,t.decoder),r);var r}function P(e){var t=e._readableState;if(t.length>0)throw new Error('"endReadable()" called on non-empty stream');t.endEmitted||(t.ended=!0,o.nextTick(L,t,e))}function L(e,t){e.endEmitted||0!==e.length||(e.endEmitted=!0,t.readable=!1,t.emit("end"))}function U(e,t){for(var r=0,n=e.length;r<n;r++)if(e[r]===t)return r;return-1}v.prototype.read=function(e){d("read",e),e=parseInt(e,10);var t=this._readableState,r=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&(t.length>=t.highWaterMark||t.ended))return d("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?P(this):k(this),null;if(0===(e=E(e,t))&&t.ended)return 0===t.length&&P(this),null;var n,o=t.needReadable;return d("need readable",o),(0===t.length||t.length-e<t.highWaterMark)&&d("length less than watermark",o=!0),t.ended||t.reading?d("reading or ended",o=!1):o&&(d("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=E(r,t))),null===(n=e>0?O(e,t):null)?(t.needReadable=!0,e=0):t.length-=e,0===t.length&&(t.ended||(t.needReadable=!0),r!==e&&t.ended&&P(this)),null!==n&&this.emit("data",n),n},v.prototype._read=function(e){this.emit("error",new Error("_read() is not implemented"))},v.prototype.pipe=function(e,t){var r=this,i=this._readableState;switch(i.pipesCount){case 0:i.pipes=e;break;case 1:i.pipes=[i.pipes,e];break;default:i.pipes.push(e)}i.pipesCount+=1,d("pipe count=%d opts=%j",i.pipesCount,t);var c=t&&!1===t.end||e===n.stdout||e===n.stderr?m:u;function u(){d("onend"),e.end()}i.endEmitted?o.nextTick(c):r.once("end",c),e.on("unpipe",function t(n,o){d("onunpipe"),n===r&&o&&!1===o.hasUnpiped&&(o.hasUnpiped=!0,d("cleanup"),e.removeListener("close",g),e.removeListener("finish",y),e.removeListener("drain",l),e.removeListener("error",b),e.removeListener("unpipe",t),r.removeListener("end",u),r.removeListener("end",m),r.removeListener("data",p),f=!0,!i.awaitDrain||e._writableState&&!e._writableState.needDrain||l())});var l=function(e){return function(){var t=e._readableState;d("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&s(e,"data")&&(t.flowing=!0,H(e))}}(r);e.on("drain",l);var f=!1,h=!1;function p(t){d("ondata"),h=!1,!1!==e.write(t)||h||((1===i.pipesCount&&i.pipes===e||i.pipesCount>1&&-1!==U(i.pipes,e))&&!f&&(d("false write response, pause",i.awaitDrain),i.awaitDrain++,h=!0),r.pause())}function b(t){d("onerror",t),m(),e.removeListener("error",b),0===s(e,"error")&&e.emit("error",t)}function g(){e.removeListener("finish",y),m()}function y(){d("onfinish"),e.removeListener("close",g),m()}function m(){d("unpipe"),r.unpipe(e)}return r.on("data",p),function(e,t,r){if("function"==typeof e.prependListener)return e.prependListener(t,r);e._events&&e._events[t]?a(e._events[t])?e._events[t].unshift(r):e._events[t]=[r,e._events[t]]:e.on(t,r)}(e,"error",b),e.once("close",g),e.once("finish",y),e.emit("pipe",r),i.flowing||(d("pipe resume"),r.resume()),e},v.prototype.unpipe=function(e){var t=this._readableState,r={hasUnpiped:!1};if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes||(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this,r)),this;if(!e){var n=t.pipes,o=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var i=0;i<o;i++)n[i].emit("unpipe",this,{hasUnpiped:!1});return this}var a=U(t.pipes,e);return-1===a||(t.pipes.splice(a,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this,r)),this},v.prototype.on=function(e,t){var r=c.prototype.on.call(this,e,t);if("data"===e)!1!==this._readableState.flowing&&this.resume();else if("readable"===e){var n=this._readableState;n.endEmitted||n.readableListening||(n.readableListening=n.needReadable=!0,n.emittedReadable=!1,n.reading?n.length&&k(this):o.nextTick(B,this))}return r},v.prototype.addListener=v.prototype.on,v.prototype.resume=function(){var e=this._readableState;return e.flowing||(d("resume"),e.flowing=!0,function(e,t){t.resumeScheduled||(t.resumeScheduled=!0,o.nextTick(T,e,t))}(this,e)),this},v.prototype.pause=function(){return d("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(d("pause"),this._readableState.flowing=!1,this.emit("pause")),this},v.prototype.wrap=function(e){var t=this,r=this._readableState,n=!1;for(var o in e.on("end",function(){if(d("wrapped end"),r.decoder&&!r.ended){var e=r.decoder.end();e&&e.length&&t.push(e)}t.push(null)}),e.on("data",function(o){d("wrapped data"),r.decoder&&(o=r.decoder.write(o)),r.objectMode&&null==o||(r.objectMode||o&&o.length)&&(t.push(o)||(n=!0,e.pause()))}),e)void 0===this[o]&&"function"==typeof e[o]&&(this[o]=function(t){return function(){return e[t].apply(e,arguments)}}(o));for(var i=0;i<y.length;i++)e.on(y[i],this.emit.bind(this,y[i]));return this._read=function(t){d("wrapped _read",t),n&&(n=!1,e.resume())},this},Object.defineProperty(v.prototype,"readableHighWaterMark",{enumerable:!1,get:function(){return this._readableState.highWaterMark}}),v._fromList=O},4605:(e,t,r)=>{"use strict";e.exports=a;var n=r(6753),o=Object.create(r(6497));function i(e,t){var r=this._transformState;r.transforming=!1;var n=r.writecb;if(!n)return this.emit("error",new Error("write callback called multiple times"));r.writechunk=null,r.writecb=null,null!=t&&this.push(t),n(e);var o=this._readableState;o.reading=!1,(o.needReadable||o.length<o.highWaterMark)&&this._read(o.highWaterMark)}function a(e){if(!(this instanceof a))return new a(e);n.call(this,e),this._transformState={afterTransform:i.bind(this),needTransform:!1,transforming:!1,writecb:null,writechunk:null,writeencoding:null},this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.on("prefinish",s)}function s(){var e=this;"function"==typeof this._flush?this._flush(function(t,r){c(e,t,r)}):c(this,null,null)}function c(e,t,r){if(t)return e.emit("error",t);if(null!=r&&e.push(r),e._writableState.length)throw new Error("Calling transform done when ws.length != 0");if(e._transformState.transforming)throw new Error("Calling transform done when still transforming");return e.push(null)}o.inherits=r(5717),o.inherits(a,n),a.prototype.push=function(e,t){return this._transformState.needTransform=!1,n.prototype.push.call(this,e,t)},a.prototype._transform=function(e,t,r){throw new Error("_transform() is not implemented")},a.prototype._write=function(e,t,r){var n=this._transformState;if(n.writecb=r,n.writechunk=e,n.writeencoding=t,!n.transforming){var o=this._readableState;(n.needTransform||o.needReadable||o.length<o.highWaterMark)&&this._read(o.highWaterMark)}},a.prototype._read=function(e){var t=this._transformState;null!==t.writechunk&&t.writecb&&!t.transforming?(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform)):t.needTransform=!0},a.prototype._destroy=function(e,t){var r=this;n.prototype._destroy.call(this,e,function(e){t(e),r.emit("close")})}},4229:(e,t,r)=>{"use strict";var n=r(4155),o=r(8212);function i(e){var t=this;this.next=null,this.entry=null,this.finish=function(){!function(e,t){var r=e.entry;for(e.entry=null;r;){var n=r.callback;t.pendingcb--,n(undefined),r=r.next}t.corkedRequestsFree.next=e}(t,e)}}e.exports=y;var a,s=!n.browser&&["v0.10","v0.9."].indexOf(n.version.slice(0,5))>-1?setImmediate:o.nextTick;y.WritableState=g;var c=Object.create(r(6497));c.inherits=r(5717);var u,l={deprecate:r(4927)},f=r(2503),h=r(3545).Buffer,d=(void 0!==r.g?r.g:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){},p=r(1195);function b(){}function g(e,t){a=a||r(6753),e=e||{};var n=t instanceof a;this.objectMode=!!e.objectMode,n&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var c=e.highWaterMark,u=e.writableHighWaterMark,l=this.objectMode?16:16384;this.highWaterMark=c||0===c?c:n&&(u||0===u)?u:l,this.highWaterMark=Math.floor(this.highWaterMark),this.finalCalled=!1,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1,this.destroyed=!1;var f=!1===e.decodeStrings;this.decodeStrings=!f,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,t){var r=e._writableState,n=r.sync,i=r.writecb;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(r),t)!function(e,t,r,n,i){--t.pendingcb,r?(o.nextTick(i,n),o.nextTick(E,e,t),e._writableState.errorEmitted=!0,e.emit("error",n)):(i(n),e._writableState.errorEmitted=!0,e.emit("error",n),E(e,t))}(e,r,n,t,i);else{var a=_(r);a||r.corked||r.bufferProcessing||!r.bufferedRequest||w(e,r),n?s(v,e,r,a,i):v(e,r,a,i)}}(t,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new i(this)}function y(e){if(a=a||r(6753),!(u.call(y,this)||this instanceof a))return new y(e);this._writableState=new g(e,this),this.writable=!0,e&&("function"==typeof e.write&&(this._write=e.write),"function"==typeof e.writev&&(this._writev=e.writev),"function"==typeof e.destroy&&(this._destroy=e.destroy),"function"==typeof e.final&&(this._final=e.final)),f.call(this)}function m(e,t,r,n,o,i,a){t.writelen=n,t.writecb=a,t.writing=!0,t.sync=!0,r?e._writev(o,t.onwrite):e._write(o,i,t.onwrite),t.sync=!1}function v(e,t,r,n){r||function(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}(e,t),t.pendingcb--,n(),E(e,t)}function w(e,t){t.bufferProcessing=!0;var r=t.bufferedRequest;if(e._writev&&r&&r.next){var n=t.bufferedRequestCount,o=new Array(n),a=t.corkedRequestsFree;a.entry=r;for(var s=0,c=!0;r;)o[s]=r,r.isBuf||(c=!1),r=r.next,s+=1;o.allBuffers=c,m(e,t,!0,t.length,o,"",a.finish),t.pendingcb++,t.lastBufferedRequest=null,a.next?(t.corkedRequestsFree=a.next,a.next=null):t.corkedRequestsFree=new i(t),t.bufferedRequestCount=0}else{for(;r;){var u=r.chunk,l=r.encoding,f=r.callback;if(m(e,t,!1,t.objectMode?1:u.length,u,l,f),r=r.next,t.bufferedRequestCount--,t.writing)break}null===r&&(t.lastBufferedRequest=null)}t.bufferedRequest=r,t.bufferProcessing=!1}function _(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function S(e,t){e._final(function(r){t.pendingcb--,r&&e.emit("error",r),t.prefinished=!0,e.emit("prefinish"),E(e,t)})}function E(e,t){var r=_(t);return r&&(function(e,t){t.prefinished||t.finalCalled||("function"==typeof e._final?(t.pendingcb++,t.finalCalled=!0,o.nextTick(S,e,t)):(t.prefinished=!0,e.emit("prefinish")))}(e,t),0===t.pendingcb&&(t.finished=!0,e.emit("finish"))),r}c.inherits(y,f),g.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},function(){try{Object.defineProperty(g.prototype,"buffer",{get:l.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.","DEP0003")})}catch(e){}}(),"function"==typeof Symbol&&Symbol.hasInstance&&"function"==typeof Function.prototype[Symbol.hasInstance]?(u=Function.prototype[Symbol.hasInstance],Object.defineProperty(y,Symbol.hasInstance,{value:function(e){return!!u.call(this,e)||this===y&&e&&e._writableState instanceof g}})):u=function(e){return e instanceof this},y.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe, not readable"))},y.prototype.write=function(e,t,r){var n,i=this._writableState,a=!1,s=!i.objectMode&&(n=e,h.isBuffer(n)||n instanceof d);return s&&!h.isBuffer(e)&&(e=function(e){return h.from(e)}(e)),"function"==typeof t&&(r=t,t=null),s?t="buffer":t||(t=i.defaultEncoding),"function"!=typeof r&&(r=b),i.ended?function(e,t){var r=new Error("write after end");e.emit("error",r),o.nextTick(t,r)}(this,r):(s||function(e,t,r,n){var i=!0,a=!1;return null===r?a=new TypeError("May not write null values to stream"):"string"==typeof r||void 0===r||t.objectMode||(a=new TypeError("Invalid non-string/buffer chunk")),a&&(e.emit("error",a),o.nextTick(n,a),i=!1),i}(this,i,e,r))&&(i.pendingcb++,a=function(e,t,r,n,o,i){if(!r){var a=function(e,t,r){return e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=h.from(t,r)),t}(t,n,o);n!==a&&(r=!0,o="buffer",n=a)}var s=t.objectMode?1:n.length;t.length+=s;var c=t.length<t.highWaterMark;if(c||(t.needDrain=!0),t.writing||t.corked){var u=t.lastBufferedRequest;t.lastBufferedRequest={chunk:n,encoding:o,isBuf:r,callback:i,next:null},u?u.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else m(e,t,!1,s,n,o,i);return c}(this,i,s,e,t,r)),a},y.prototype.cork=function(){this._writableState.corked++},y.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.bufferProcessing||!e.bufferedRequest||w(this,e))},y.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new TypeError("Unknown encoding: "+e);return this._writableState.defaultEncoding=e,this},Object.defineProperty(y.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),y.prototype._write=function(e,t,r){r(new Error("_write() is not implemented"))},y.prototype._writev=null,y.prototype.end=function(e,t,r){var n=this._writableState;"function"==typeof e?(r=e,e=null,t=null):"function"==typeof t&&(r=t,t=null),null!=e&&this.write(e,t),n.corked&&(n.corked=1,this.uncork()),n.ending||function(e,t,r){t.ending=!0,E(e,t),r&&(t.finished?o.nextTick(r):e.once("finish",r)),t.ended=!0,e.writable=!1}(this,n,r)},Object.defineProperty(y.prototype,"destroyed",{get:function(){return void 0!==this._writableState&&this._writableState.destroyed},set:function(e){this._writableState&&(this._writableState.destroyed=e)}}),y.prototype.destroy=p.destroy,y.prototype._undestroy=p.undestroy,y.prototype._destroy=function(e,t){this.end(),t(e)}},5057:(e,t,r)=>{"use strict";var n=r(3545).Buffer,o=r(2361);function i(e,t,r){e.copy(t,r)}e.exports=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.head=null,this.tail=null,this.length=0}return e.prototype.push=function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length},e.prototype.unshift=function(e){var t={data:e,next:this.head};0===this.length&&(this.tail=t),this.head=t,++this.length},e.prototype.shift=function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}},e.prototype.clear=function(){this.head=this.tail=null,this.length=0},e.prototype.join=function(e){if(0===this.length)return"";for(var t=this.head,r=""+t.data;t=t.next;)r+=e+t.data;return r},e.prototype.concat=function(e){if(0===this.length)return n.alloc(0);for(var t=n.allocUnsafe(e>>>0),r=this.head,o=0;r;)i(r.data,t,o),o+=r.data.length,r=r.next;return t},e}(),o&&o.inspect&&o.inspect.custom&&(e.exports.prototype[o.inspect.custom]=function(){var e=o.inspect({length:this.length});return this.constructor.name+" "+e})},1195:(e,t,r)=>{"use strict";var n=r(8212);function o(e,t){e.emit("error",t)}e.exports={destroy:function(e,t){var r=this,i=this._readableState&&this._readableState.destroyed,a=this._writableState&&this._writableState.destroyed;return i||a?(t?t(e):e&&(this._writableState?this._writableState.errorEmitted||(this._writableState.errorEmitted=!0,n.nextTick(o,this,e)):n.nextTick(o,this,e)),this):(this._readableState&&(this._readableState.destroyed=!0),this._writableState&&(this._writableState.destroyed=!0),this._destroy(e||null,function(e){!t&&e?r._writableState?r._writableState.errorEmitted||(r._writableState.errorEmitted=!0,n.nextTick(o,r,e)):n.nextTick(o,r,e):t&&t(e)}),this)},undestroy:function(){this._readableState&&(this._readableState.destroyed=!1,this._readableState.reading=!1,this._readableState.ended=!1,this._readableState.endEmitted=!1),this._writableState&&(this._writableState.destroyed=!1,this._writableState.ended=!1,this._writableState.ending=!1,this._writableState.finalCalled=!1,this._writableState.prefinished=!1,this._writableState.finished=!1,this._writableState.errorEmitted=!1)}}},2503:(e,t,r)=>{e.exports=r(7187).EventEmitter},3545:(e,t,r)=>{var n=r(8764),o=n.Buffer;function i(e,t){for(var r in e)t[r]=e[r]}function a(e,t,r){return o(e,t,r)}o.from&&o.alloc&&o.allocUnsafe&&o.allocUnsafeSlow?e.exports=n:(i(n,t),t.Buffer=a),i(o,a),a.from=function(e,t,r){if("number"==typeof e)throw new TypeError("Argument must not be a number");return o(e,t,r)},a.alloc=function(e,t,r){if("number"!=typeof e)throw new TypeError("Argument must be a number");var n=o(e);return void 0!==t?"string"==typeof r?n.fill(t,r):n.fill(t):n.fill(0),n},a.allocUnsafe=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return o(e)},a.allocUnsafeSlow=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return n.SlowBuffer(e)}},8473:(e,t,r)=>{(t=e.exports=r(9481)).Stream=t,t.Readable=t,t.Writable=r(4229),t.Duplex=r(6753),t.Transform=r(4605),t.PassThrough=r(2725)},9785:(e,t,r)=>{"use strict";var n=r(8764).Buffer,o=r(5717),i=r(3349),a=new Array(16),s=[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,7,4,13,1,10,6,15,3,12,0,9,5,2,14,11,8,3,10,14,4,9,15,8,1,2,7,0,6,13,11,5,12,1,9,11,10,0,8,12,4,13,3,7,15,14,5,6,2,4,0,5,9,7,12,2,10,14,1,3,8,11,6,15,13],c=[5,14,7,0,9,2,11,4,13,6,15,8,1,10,3,12,6,11,3,7,0,13,5,10,14,15,8,12,4,9,1,2,15,5,1,3,7,14,6,9,11,8,12,2,10,0,4,13,8,6,4,1,3,11,15,0,5,12,2,13,9,7,10,14,12,15,10,4,1,5,8,7,6,2,13,14,0,3,9,11],u=[11,14,15,12,5,8,7,9,11,13,14,15,6,7,9,8,7,6,8,13,11,9,7,15,7,12,15,9,11,7,13,12,11,13,6,7,14,9,13,15,14,8,13,6,5,12,7,5,11,12,14,15,14,15,9,8,9,14,5,6,8,6,5,12,9,15,5,11,6,8,13,12,5,12,13,14,11,8,5,6],l=[8,9,9,11,13,15,15,5,7,7,8,11,14,14,12,6,9,13,15,7,12,8,9,11,7,7,12,7,6,15,13,11,9,7,15,11,8,6,6,14,12,13,5,14,13,13,7,5,15,5,8,11,14,14,6,14,6,9,12,9,12,5,15,8,8,5,12,9,12,5,14,6,8,13,6,5,15,13,11,11],f=[0,1518500249,1859775393,2400959708,2840853838],h=[1352829926,1548603684,1836072691,2053994217,0];function d(e,t){return e<<t|e>>>32-t}function p(e,t,r,n,o,i,a,s){return d(e+(t^r^n)+i+a|0,s)+o|0}function b(e,t,r,n,o,i,a,s){return d(e+(t&r|~t&n)+i+a|0,s)+o|0}function g(e,t,r,n,o,i,a,s){return d(e+((t|~r)^n)+i+a|0,s)+o|0}function y(e,t,r,n,o,i,a,s){return d(e+(t&n|r&~n)+i+a|0,s)+o|0}function m(e,t,r,n,o,i,a,s){return d(e+(t^(r|~n))+i+a|0,s)+o|0}function v(){i.call(this,64),this._a=1732584193,this._b=4023233417,this._c=2562383102,this._d=271733878,this._e=3285377520}o(v,i),v.prototype._update=function(){for(var e=a,t=0;t<16;++t)e[t]=this._block.readInt32LE(4*t);for(var r=0|this._a,n=0|this._b,o=0|this._c,i=0|this._d,v=0|this._e,w=0|this._a,_=0|this._b,S=0|this._c,E=0|this._d,k=0|this._e,A=0;A<80;A+=1){var x,I;A<16?(x=p(r,n,o,i,v,e[s[A]],f[0],u[A]),I=m(w,_,S,E,k,e[c[A]],h[0],l[A])):A<32?(x=b(r,n,o,i,v,e[s[A]],f[1],u[A]),I=y(w,_,S,E,k,e[c[A]],h[1],l[A])):A<48?(x=g(r,n,o,i,v,e[s[A]],f[2],u[A]),I=g(w,_,S,E,k,e[c[A]],h[2],l[A])):A<64?(x=y(r,n,o,i,v,e[s[A]],f[3],u[A]),I=b(w,_,S,E,k,e[c[A]],h[3],l[A])):(x=m(r,n,o,i,v,e[s[A]],f[4],u[A]),I=p(w,_,S,E,k,e[c[A]],h[4],l[A])),r=v,v=i,i=d(o,10),o=n,n=x,w=k,k=E,E=d(S,10),S=_,_=I}var B=this._b+o+E|0;this._b=this._c+i+k|0,this._c=this._d+v+w|0,this._d=this._e+r+_|0,this._e=this._a+n+S|0,this._a=B},v.prototype._digest=function(){this._block[this._blockOffset]=128,this._blockOffset+=1,this._blockOffset>56&&(this._block.fill(0,this._blockOffset,64),this._update(),this._blockOffset=0),this._block.fill(0,this._blockOffset,56),this._block.writeUInt32LE(this._length[0],56),this._block.writeUInt32LE(this._length[1],60),this._update();var e=n.alloc?n.alloc(20):new n(20);return e.writeInt32LE(this._a,0),e.writeInt32LE(this._b,4),e.writeInt32LE(this._c,8),e.writeInt32LE(this._d,12),e.writeInt32LE(this._e,16),e},e.exports=v},9509:(e,t,r)=>{var n=r(8764),o=n.Buffer;function i(e,t){for(var r in e)t[r]=e[r]}function a(e,t,r){return o(e,t,r)}o.from&&o.alloc&&o.allocUnsafe&&o.allocUnsafeSlow?e.exports=n:(i(n,t),t.Buffer=a),a.prototype=Object.create(o.prototype),i(o,a),a.from=function(e,t,r){if("number"==typeof e)throw new TypeError("Argument must not be a number");return o(e,t,r)},a.alloc=function(e,t,r){if("number"!=typeof e)throw new TypeError("Argument must be a number");var n=o(e);return void 0!==t?"string"==typeof r?n.fill(t,r):n.fill(t):n.fill(0),n},a.allocUnsafe=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return o(e)},a.allocUnsafeSlow=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return n.SlowBuffer(e)}},7771:(e,t,r)=>{"use strict";var n=r(210),o=r(2296),i=r(1044)(),a=r(7296),s=r(4453),c=n("%Math.floor%");e.exports=function(e,t){if("function"!=typeof e)throw new s("`fn` is not a function");if("number"!=typeof t||t<0||t>4294967295||c(t)!==t)throw new s("`length` must be a positive 32-bit integer");var r=arguments.length>2&&!!arguments[2],n=!0,u=!0;if("length"in e&&a){var l=a(e,"length");l&&!l.configurable&&(n=!1),l&&!l.writable&&(u=!1)}return(n||u||!r)&&(i?o(e,"length",t,!0,!0):o(e,"length",t)),e}},4189:(e,t,r)=>{"use strict";var n=r(9509).Buffer,o=r(5309);function i(e,t){this._block=n.alloc(e),this._finalSize=t,this._blockSize=e,this._len=0}i.prototype.update=function(e,t){e=o(e,t||"utf8");for(var r=this._block,n=this._blockSize,i=e.length,a=this._len,s=0;s<i;){for(var c=a%n,u=Math.min(i-s,n-c),l=0;l<u;l++)r[c+l]=e[s+l];s+=u,(a+=u)%n===0&&this._update(r)}return this._len+=i,this},i.prototype.digest=function(e){var t=this._len%this._blockSize;this._block[t]=128,this._block.fill(0,t+1),t>=this._finalSize&&(this._update(this._block),this._block.fill(0));var r=8*this._len;if(r<=4294967295)this._block.writeUInt32BE(r,this._blockSize-4);else{var n=(4294967295&r)>>>0,o=(r-n)/4294967296;this._block.writeUInt32BE(o,this._blockSize-8),this._block.writeUInt32BE(n,this._blockSize-4)}this._update(this._block);var i=this._hash();return e?i.toString(e):i},i.prototype._update=function(){throw new Error("_update must be implemented by subclass")},e.exports=i},9072:(e,t,r)=>{"use strict";e.exports=function(t){var r=t.toLowerCase(),n=e.exports[r];if(!n)throw new Error(r+" is not supported (we accept pull requests)");return new n},e.exports.sha=r(4448),e.exports.sha1=r(8336),e.exports.sha224=r(8432),e.exports.sha256=r(7499),e.exports.sha384=r(1686),e.exports.sha512=r(7816)},4448:(e,t,r)=>{"use strict";var n=r(5717),o=r(4189),i=r(9509).Buffer,a=[1518500249,1859775393,-1894007588,-899497514],s=new Array(80);function c(){this.init(),this._w=s,o.call(this,64,56)}function u(e){return e<<5|e>>>27}function l(e){return e<<30|e>>>2}function f(e,t,r,n){return 0===e?t&r|~t&n:2===e?t&r|t&n|r&n:t^r^n}n(c,o),c.prototype.init=function(){return this._a=1732584193,this._b=4023233417,this._c=2562383102,this._d=271733878,this._e=3285377520,this},c.prototype._update=function(e){for(var t=this._w,r=0|this._a,n=0|this._b,o=0|this._c,i=0|this._d,s=0|this._e,c=0;c<16;++c)t[c]=e.readInt32BE(4*c);for(;c<80;++c)t[c]=t[c-3]^t[c-8]^t[c-14]^t[c-16];for(var h=0;h<80;++h){var d=~~(h/20),p=u(r)+f(d,n,o,i)+s+t[h]+a[d]|0;s=i,i=o,o=l(n),n=r,r=p}this._a=r+this._a|0,this._b=n+this._b|0,this._c=o+this._c|0,this._d=i+this._d|0,this._e=s+this._e|0},c.prototype._hash=function(){var e=i.allocUnsafe(20);return e.writeInt32BE(0|this._a,0),e.writeInt32BE(0|this._b,4),e.writeInt32BE(0|this._c,8),e.writeInt32BE(0|this._d,12),e.writeInt32BE(0|this._e,16),e},e.exports=c},8336:(e,t,r)=>{"use strict";var n=r(5717),o=r(4189),i=r(9509).Buffer,a=[1518500249,1859775393,-1894007588,-899497514],s=new Array(80);function c(){this.init(),this._w=s,o.call(this,64,56)}function u(e){return e<<1|e>>>31}function l(e){return e<<5|e>>>27}function f(e){return e<<30|e>>>2}function h(e,t,r,n){return 0===e?t&r|~t&n:2===e?t&r|t&n|r&n:t^r^n}n(c,o),c.prototype.init=function(){return this._a=1732584193,this._b=4023233417,this._c=2562383102,this._d=271733878,this._e=3285377520,this},c.prototype._update=function(e){for(var t=this._w,r=0|this._a,n=0|this._b,o=0|this._c,i=0|this._d,s=0|this._e,c=0;c<16;++c)t[c]=e.readInt32BE(4*c);for(;c<80;++c)t[c]=u(t[c-3]^t[c-8]^t[c-14]^t[c-16]);for(var d=0;d<80;++d){var p=~~(d/20),b=l(r)+h(p,n,o,i)+s+t[d]+a[p]|0;s=i,i=o,o=f(n),n=r,r=b}this._a=r+this._a|0,this._b=n+this._b|0,this._c=o+this._c|0,this._d=i+this._d|0,this._e=s+this._e|0},c.prototype._hash=function(){var e=i.allocUnsafe(20);return e.writeInt32BE(0|this._a,0),e.writeInt32BE(0|this._b,4),e.writeInt32BE(0|this._c,8),e.writeInt32BE(0|this._d,12),e.writeInt32BE(0|this._e,16),e},e.exports=c},8432:(e,t,r)=>{"use strict";var n=r(5717),o=r(7499),i=r(4189),a=r(9509).Buffer,s=new Array(64);function c(){this.init(),this._w=s,i.call(this,64,56)}n(c,o),c.prototype.init=function(){return this._a=3238371032,this._b=914150663,this._c=812702999,this._d=4144912697,this._e=4290775857,this._f=1750603025,this._g=1694076839,this._h=3204075428,this},c.prototype._hash=function(){var e=a.allocUnsafe(28);return e.writeInt32BE(this._a,0),e.writeInt32BE(this._b,4),e.writeInt32BE(this._c,8),e.writeInt32BE(this._d,12),e.writeInt32BE(this._e,16),e.writeInt32BE(this._f,20),e.writeInt32BE(this._g,24),e},e.exports=c},7499:(e,t,r)=>{"use strict";var n=r(5717),o=r(4189),i=r(9509).Buffer,a=[1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298],s=new Array(64);function c(){this.init(),this._w=s,o.call(this,64,56)}function u(e,t,r){return r^e&(t^r)}function l(e,t,r){return e&t|r&(e|t)}function f(e){return(e>>>2|e<<30)^(e>>>13|e<<19)^(e>>>22|e<<10)}function h(e){return(e>>>6|e<<26)^(e>>>11|e<<21)^(e>>>25|e<<7)}function d(e){return(e>>>7|e<<25)^(e>>>18|e<<14)^e>>>3}function p(e){return(e>>>17|e<<15)^(e>>>19|e<<13)^e>>>10}n(c,o),c.prototype.init=function(){return this._a=1779033703,this._b=3144134277,this._c=1013904242,this._d=2773480762,this._e=1359893119,this._f=2600822924,this._g=528734635,this._h=1541459225,this},c.prototype._update=function(e){for(var t=this._w,r=0|this._a,n=0|this._b,o=0|this._c,i=0|this._d,s=0|this._e,c=0|this._f,b=0|this._g,g=0|this._h,y=0;y<16;++y)t[y]=e.readInt32BE(4*y);for(;y<64;++y)t[y]=p(t[y-2])+t[y-7]+d(t[y-15])+t[y-16]|0;for(var m=0;m<64;++m){var v=g+h(s)+u(s,c,b)+a[m]+t[m]|0,w=f(r)+l(r,n,o)|0;g=b,b=c,c=s,s=i+v|0,i=o,o=n,n=r,r=v+w|0}this._a=r+this._a|0,this._b=n+this._b|0,this._c=o+this._c|0,this._d=i+this._d|0,this._e=s+this._e|0,this._f=c+this._f|0,this._g=b+this._g|0,this._h=g+this._h|0},c.prototype._hash=function(){var e=i.allocUnsafe(32);return e.writeInt32BE(this._a,0),e.writeInt32BE(this._b,4),e.writeInt32BE(this._c,8),e.writeInt32BE(this._d,12),e.writeInt32BE(this._e,16),e.writeInt32BE(this._f,20),e.writeInt32BE(this._g,24),e.writeInt32BE(this._h,28),e},e.exports=c},1686:(e,t,r)=>{"use strict";var n=r(5717),o=r(7816),i=r(4189),a=r(9509).Buffer,s=new Array(160);function c(){this.init(),this._w=s,i.call(this,128,112)}n(c,o),c.prototype.init=function(){return this._ah=3418070365,this._bh=1654270250,this._ch=2438529370,this._dh=355462360,this._eh=1731405415,this._fh=2394180231,this._gh=3675008525,this._hh=1203062813,this._al=3238371032,this._bl=914150663,this._cl=812702999,this._dl=4144912697,this._el=4290775857,this._fl=1750603025,this._gl=1694076839,this._hl=3204075428,this},c.prototype._hash=function(){var e=a.allocUnsafe(48);function t(t,r,n){e.writeInt32BE(t,n),e.writeInt32BE(r,n+4)}return t(this._ah,this._al,0),t(this._bh,this._bl,8),t(this._ch,this._cl,16),t(this._dh,this._dl,24),t(this._eh,this._el,32),t(this._fh,this._fl,40),e},e.exports=c},7816:(e,t,r)=>{"use strict";var n=r(5717),o=r(4189),i=r(9509).Buffer,a=[1116352408,3609767458,1899447441,602891725,3049323471,3964484399,3921009573,2173295548,961987163,4081628472,1508970993,3053834265,2453635748,2937671579,2870763221,3664609560,3624381080,2734883394,310598401,1164996542,607225278,1323610764,1426881987,3590304994,1925078388,4068182383,2162078206,991336113,2614888103,633803317,3248222580,3479774868,3835390401,2666613458,4022224774,944711139,264347078,2341262773,604807628,2007800933,770255983,1495990901,1249150122,1856431235,1555081692,3175218132,1996064986,2198950837,2554220882,3999719339,2821834349,766784016,2952996808,2566594879,3210313671,3203337956,3336571891,1034457026,3584528711,2466948901,113926993,3758326383,338241895,168717936,666307205,1188179964,773529912,1546045734,1294757372,1522805485,1396182291,2643833823,1695183700,2343527390,1986661051,1014477480,2177026350,1206759142,2456956037,344077627,2730485921,1290863460,2820302411,3158454273,3259730800,3505952657,3345764771,106217008,3516065817,3606008344,3600352804,1432725776,4094571909,1467031594,275423344,851169720,430227734,3100823752,506948616,1363258195,659060556,3750685593,883997877,3785050280,958139571,3318307427,1322822218,3812723403,1537002063,2003034995,1747873779,3602036899,1955562222,1575990012,2024104815,1125592928,2227730452,2716904306,2361852424,442776044,2428436474,593698344,2756734187,3733110249,3204031479,2999351573,3329325298,3815920427,3391569614,3928383900,3515267271,566280711,3940187606,3454069534,4118630271,4000239992,116418474,1914138554,174292421,2731055270,289380356,3203993006,460393269,320620315,685471733,587496836,852142971,1086792851,1017036298,365543100,1126000580,2618297676,1288033470,3409855158,1501505948,4234509866,1607167915,987167468,1816402316,1246189591],s=new Array(160);function c(){this.init(),this._w=s,o.call(this,128,112)}function u(e,t,r){return r^e&(t^r)}function l(e,t,r){return e&t|r&(e|t)}function f(e,t){return(e>>>28|t<<4)^(t>>>2|e<<30)^(t>>>7|e<<25)}function h(e,t){return(e>>>14|t<<18)^(e>>>18|t<<14)^(t>>>9|e<<23)}function d(e,t){return(e>>>1|t<<31)^(e>>>8|t<<24)^e>>>7}function p(e,t){return(e>>>1|t<<31)^(e>>>8|t<<24)^(e>>>7|t<<25)}function b(e,t){return(e>>>19|t<<13)^(t>>>29|e<<3)^e>>>6}function g(e,t){return(e>>>19|t<<13)^(t>>>29|e<<3)^(e>>>6|t<<26)}function y(e,t){return e>>>0<t>>>0?1:0}n(c,o),c.prototype.init=function(){return this._ah=1779033703,this._bh=3144134277,this._ch=1013904242,this._dh=2773480762,this._eh=1359893119,this._fh=2600822924,this._gh=528734635,this._hh=1541459225,this._al=4089235720,this._bl=2227873595,this._cl=4271175723,this._dl=1595750129,this._el=2917565137,this._fl=725511199,this._gl=4215389547,this._hl=327033209,this},c.prototype._update=function(e){for(var t=this._w,r=0|this._ah,n=0|this._bh,o=0|this._ch,i=0|this._dh,s=0|this._eh,c=0|this._fh,m=0|this._gh,v=0|this._hh,w=0|this._al,_=0|this._bl,S=0|this._cl,E=0|this._dl,k=0|this._el,A=0|this._fl,x=0|this._gl,I=0|this._hl,B=0;B<32;B+=2)t[B]=e.readInt32BE(4*B),t[B+1]=e.readInt32BE(4*B+4);for(;B<160;B+=2){var T=t[B-30],H=t[B-30+1],O=d(T,H),P=p(H,T),L=b(T=t[B-4],H=t[B-4+1]),U=g(H,T),j=t[B-14],C=t[B-14+1],R=t[B-32],z=t[B-32+1],N=P+C|0,M=O+j+y(N,P)|0;M=(M=M+L+y(N=N+U|0,U)|0)+R+y(N=N+z|0,z)|0,t[B]=M,t[B+1]=N}for(var V=0;V<160;V+=2){M=t[V],N=t[V+1];var D=l(r,n,o),F=l(w,_,S),q=f(r,w),K=f(w,r),G=h(s,k),W=h(k,s),$=a[V],X=a[V+1],Y=u(s,c,m),Z=u(k,A,x),J=I+W|0,Q=v+G+y(J,I)|0;Q=(Q=(Q=Q+Y+y(J=J+Z|0,Z)|0)+$+y(J=J+X|0,X)|0)+M+y(J=J+N|0,N)|0;var ee=K+F|0,te=q+D+y(ee,K)|0;v=m,I=x,m=c,x=A,c=s,A=k,s=i+Q+y(k=E+J|0,E)|0,i=o,E=S,o=n,S=_,n=r,_=w,r=Q+te+y(w=J+ee|0,J)|0}this._al=this._al+w|0,this._bl=this._bl+_|0,this._cl=this._cl+S|0,this._dl=this._dl+E|0,this._el=this._el+k|0,this._fl=this._fl+A|0,this._gl=this._gl+x|0,this._hl=this._hl+I|0,this._ah=this._ah+r+y(this._al,w)|0,this._bh=this._bh+n+y(this._bl,_)|0,this._ch=this._ch+o+y(this._cl,S)|0,this._dh=this._dh+i+y(this._dl,E)|0,this._eh=this._eh+s+y(this._el,k)|0,this._fh=this._fh+c+y(this._fl,A)|0,this._gh=this._gh+m+y(this._gl,x)|0,this._hh=this._hh+v+y(this._hl,I)|0},c.prototype._hash=function(){var e=i.allocUnsafe(64);function t(t,r,n){e.writeInt32BE(t,n),e.writeInt32BE(r,n+4)}return t(this._ah,this._al,0),t(this._bh,this._bl,8),t(this._ch,this._cl,16),t(this._dh,this._dl,24),t(this._eh,this._el,32),t(this._fh,this._fl,40),t(this._gh,this._gl,48),t(this._hh,this._hl,56),e},e.exports=c},2830:(e,t,r)=>{e.exports=o;var n=r(7187).EventEmitter;function o(){n.call(this)}r(5717)(o,n),o.Readable=r(6577),o.Writable=r(323),o.Duplex=r(8656),o.Transform=r(4473),o.PassThrough=r(2366),o.finished=r(1086),o.pipeline=r(6472),o.Stream=o,o.prototype.pipe=function(e,t){var r=this;function o(t){e.writable&&!1===e.write(t)&&r.pause&&r.pause()}function i(){r.readable&&r.resume&&r.resume()}r.on("data",o),e.on("drain",i),e._isStdio||t&&!1===t.end||(r.on("end",s),r.on("close",c));var a=!1;function s(){a||(a=!0,e.end())}function c(){a||(a=!0,"function"==typeof e.destroy&&e.destroy())}function u(e){if(l(),0===n.listenerCount(this,"error"))throw e}function l(){r.removeListener("data",o),e.removeListener("drain",i),r.removeListener("end",s),r.removeListener("close",c),r.removeListener("error",u),e.removeListener("error",u),r.removeListener("end",l),r.removeListener("close",l),e.removeListener("close",l)}return r.on("error",u),e.on("error",u),r.on("end",l),r.on("close",l),e.on("close",l),e.emit("pipe",r),e}},8106:e=>{"use strict";var t={};function r(e,r,n){n||(n=Error);var o=function(e){var t,n;function o(t,n,o){return e.call(this,function(e,t,n){return"string"==typeof r?r:r(e,t,n)}(t,n,o))||this}return n=e,(t=o).prototype=Object.create(n.prototype),t.prototype.constructor=t,t.__proto__=n,o}(n);o.prototype.name=n.name,o.prototype.code=e,t[e]=o}function n(e,t){if(Array.isArray(e)){var r=e.length;return e=e.map(function(e){return String(e)}),r>2?"one of ".concat(t," ").concat(e.slice(0,r-1).join(", "),", or ")+e[r-1]:2===r?"one of ".concat(t," ").concat(e[0]," or ").concat(e[1]):"of ".concat(t," ").concat(e[0])}return"of ".concat(t," ").concat(String(e))}r("ERR_INVALID_OPT_VALUE",function(e,t){return'The value "'+t+'" is invalid for option "'+e+'"'},TypeError),r("ERR_INVALID_ARG_TYPE",function(e,t,r){var o,i,a,s,c;if("string"==typeof t&&(i="not ",t.substr(0,4)===i)?(o="must not be",t=t.replace(/^not /,"")):o="must be",function(e,t,r){return(void 0===r||r>e.length)&&(r=e.length),e.substring(r-9,r)===t}(e," argument"))a="The ".concat(e," ").concat(o," ").concat(n(t,"type"));else{var u=("number"!=typeof c&&(c=0),c+1>(s=e).length||-1===s.indexOf(".",c)?"argument":"property");a='The "'.concat(e,'" ').concat(u," ").concat(o," ").concat(n(t,"type"))}return a+". Received type ".concat(typeof r)},TypeError),r("ERR_STREAM_PUSH_AFTER_EOF","stream.push() after EOF"),r("ERR_METHOD_NOT_IMPLEMENTED",function(e){return"The "+e+" method is not implemented"}),r("ERR_STREAM_PREMATURE_CLOSE","Premature close"),r("ERR_STREAM_DESTROYED",function(e){return"Cannot call "+e+" after a stream was destroyed"}),r("ERR_MULTIPLE_CALLBACK","Callback called multiple times"),r("ERR_STREAM_CANNOT_PIPE","Cannot pipe, not readable"),r("ERR_STREAM_WRITE_AFTER_END","write after end"),r("ERR_STREAM_NULL_VALUES","May not write null values to stream",TypeError),r("ERR_UNKNOWN_ENCODING",function(e){return"Unknown encoding: "+e},TypeError),r("ERR_STREAM_UNSHIFT_AFTER_END_EVENT","stream.unshift() after end event"),e.exports.q=t},8656:(e,t,r)=>{"use strict";var n=r(4155),o=Object.keys||function(e){var t=[];for(var r in e)t.push(r);return t};e.exports=l;var i=r(6577),a=r(323);r(5717)(l,i);for(var s=o(a.prototype),c=0;c<s.length;c++){var u=s[c];l.prototype[u]||(l.prototype[u]=a.prototype[u])}function l(e){if(!(this instanceof l))return new l(e);i.call(this,e),a.call(this,e),this.allowHalfOpen=!0,e&&(!1===e.readable&&(this.readable=!1),!1===e.writable&&(this.writable=!1),!1===e.allowHalfOpen&&(this.allowHalfOpen=!1,this.once("end",f)))}function f(){this._writableState.ended||n.nextTick(h,this)}function h(e){e.end()}Object.defineProperty(l.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),Object.defineProperty(l.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(l.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(l.prototype,"destroyed",{enumerable:!1,get:function(){return void 0!==this._readableState&&void 0!==this._writableState&&this._readableState.destroyed&&this._writableState.destroyed},set:function(e){void 0!==this._readableState&&void 0!==this._writableState&&(this._readableState.destroyed=e,this._writableState.destroyed=e)}})},2366:(e,t,r)=>{"use strict";e.exports=o;var n=r(4473);function o(e){if(!(this instanceof o))return new o(e);n.call(this,e)}r(5717)(o,n),o.prototype._transform=function(e,t,r){r(null,e)}},6577:(e,t,r)=>{"use strict";var n,o=r(4155);e.exports=A,A.ReadableState=k,r(7187).EventEmitter;var i,a=function(e,t){return e.listeners(t).length},s=r(3194),c=r(8764).Buffer,u=(void 0!==r.g?r.g:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){},l=r(964);i=l&&l.debuglog?l.debuglog("stream"):function(){};var f,h,d,p=r(9686),b=r(1029),g=r(94).getHighWaterMark,y=r(8106).q,m=y.ERR_INVALID_ARG_TYPE,v=y.ERR_STREAM_PUSH_AFTER_EOF,w=y.ERR_METHOD_NOT_IMPLEMENTED,_=y.ERR_STREAM_UNSHIFT_AFTER_END_EVENT;r(5717)(A,s);var S=b.errorOrDestroy,E=["error","close","destroy","pause","resume"];function k(e,t,o){n=n||r(8656),e=e||{},"boolean"!=typeof o&&(o=t instanceof n),this.objectMode=!!e.objectMode,o&&(this.objectMode=this.objectMode||!!e.readableObjectMode),this.highWaterMark=g(this,e,"readableHighWaterMark",o),this.buffer=new p,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.paused=!0,this.emitClose=!1!==e.emitClose,this.autoDestroy=!!e.autoDestroy,this.destroyed=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(f||(f=r(2553).s),this.decoder=new f(e.encoding),this.encoding=e.encoding)}function A(e){if(n=n||r(8656),!(this instanceof A))return new A(e);var t=this instanceof n;this._readableState=new k(e,this,t),this.readable=!0,e&&("function"==typeof e.read&&(this._read=e.read),"function"==typeof e.destroy&&(this._destroy=e.destroy)),s.call(this)}function x(e,t,r,n,o){i("readableAddChunk",t);var a,s=e._readableState;if(null===t)s.reading=!1,function(e,t){if(i("onEofChunk"),!t.ended){if(t.decoder){var r=t.decoder.end();r&&r.length&&(t.buffer.push(r),t.length+=t.objectMode?1:r.length)}t.ended=!0,t.sync?H(e):(t.needReadable=!1,t.emittedReadable||(t.emittedReadable=!0,O(e)))}}(e,s);else if(o||(a=function(e,t){var r,n;return n=t,c.isBuffer(n)||n instanceof u||"string"==typeof t||void 0===t||e.objectMode||(r=new m("chunk",["string","Buffer","Uint8Array"],t)),r}(s,t)),a)S(e,a);else if(s.objectMode||t&&t.length>0)if("string"==typeof t||s.objectMode||Object.getPrototypeOf(t)===c.prototype||(t=function(e){return c.from(e)}(t)),n)s.endEmitted?S(e,new _):I(e,s,t,!0);else if(s.ended)S(e,new v);else{if(s.destroyed)return!1;s.reading=!1,s.decoder&&!r?(t=s.decoder.write(t),s.objectMode||0!==t.length?I(e,s,t,!1):P(e,s)):I(e,s,t,!1)}else n||(s.reading=!1,P(e,s));return!s.ended&&(s.length<s.highWaterMark||0===s.length)}function I(e,t,r,n){t.flowing&&0===t.length&&!t.sync?(t.awaitDrain=0,e.emit("data",r)):(t.length+=t.objectMode?1:r.length,n?t.buffer.unshift(r):t.buffer.push(r),t.needReadable&&H(e)),P(e,t)}Object.defineProperty(A.prototype,"destroyed",{enumerable:!1,get:function(){return void 0!==this._readableState&&this._readableState.destroyed},set:function(e){this._readableState&&(this._readableState.destroyed=e)}}),A.prototype.destroy=b.destroy,A.prototype._undestroy=b.undestroy,A.prototype._destroy=function(e,t){t(e)},A.prototype.push=function(e,t){var r,n=this._readableState;return n.objectMode?r=!0:"string"==typeof e&&((t=t||n.defaultEncoding)!==n.encoding&&(e=c.from(e,t),t=""),r=!0),x(this,e,t,!1,r)},A.prototype.unshift=function(e){return x(this,e,null,!0,!1)},A.prototype.isPaused=function(){return!1===this._readableState.flowing},A.prototype.setEncoding=function(e){f||(f=r(2553).s);var t=new f(e);this._readableState.decoder=t,this._readableState.encoding=this._readableState.decoder.encoding;for(var n=this._readableState.buffer.head,o="";null!==n;)o+=t.write(n.data),n=n.next;return this._readableState.buffer.clear(),""!==o&&this._readableState.buffer.push(o),this._readableState.length=o.length,this};var B=1073741824;function T(e,t){return e<=0||0===t.length&&t.ended?0:t.objectMode?1:e!=e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=function(e){return e>=B?e=B:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function H(e){var t=e._readableState;i("emitReadable",t.needReadable,t.emittedReadable),t.needReadable=!1,t.emittedReadable||(i("emitReadable",t.flowing),t.emittedReadable=!0,o.nextTick(O,e))}function O(e){var t=e._readableState;i("emitReadable_",t.destroyed,t.length,t.ended),t.destroyed||!t.length&&!t.ended||(e.emit("readable"),t.emittedReadable=!1),t.needReadable=!t.flowing&&!t.ended&&t.length<=t.highWaterMark,R(e)}function P(e,t){t.readingMore||(t.readingMore=!0,o.nextTick(L,e,t))}function L(e,t){for(;!t.reading&&!t.ended&&(t.length<t.highWaterMark||t.flowing&&0===t.length);){var r=t.length;if(i("maybeReadMore read 0"),e.read(0),r===t.length)break}t.readingMore=!1}function U(e){var t=e._readableState;t.readableListening=e.listenerCount("readable")>0,t.resumeScheduled&&!t.paused?t.flowing=!0:e.listenerCount("data")>0&&e.resume()}function j(e){i("readable nexttick read 0"),e.read(0)}function C(e,t){i("resume",t.reading),t.reading||e.read(0),t.resumeScheduled=!1,e.emit("resume"),R(e),t.flowing&&!t.reading&&e.read(0)}function R(e){var t=e._readableState;for(i("flow",t.flowing);t.flowing&&null!==e.read(););}function z(e,t){return 0===t.length?null:(t.objectMode?r=t.buffer.shift():!e||e>=t.length?(r=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.first():t.buffer.concat(t.length),t.buffer.clear()):r=t.buffer.consume(e,t.decoder),r);var r}function N(e){var t=e._readableState;i("endReadable",t.endEmitted),t.endEmitted||(t.ended=!0,o.nextTick(M,t,e))}function M(e,t){if(i("endReadableNT",e.endEmitted,e.length),!e.endEmitted&&0===e.length&&(e.endEmitted=!0,t.readable=!1,t.emit("end"),e.autoDestroy)){var r=t._writableState;(!r||r.autoDestroy&&r.finished)&&t.destroy()}}function V(e,t){for(var r=0,n=e.length;r<n;r++)if(e[r]===t)return r;return-1}A.prototype.read=function(e){i("read",e),e=parseInt(e,10);var t=this._readableState,r=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&((0!==t.highWaterMark?t.length>=t.highWaterMark:t.length>0)||t.ended))return i("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?N(this):H(this),null;if(0===(e=T(e,t))&&t.ended)return 0===t.length&&N(this),null;var n,o=t.needReadable;return i("need readable",o),(0===t.length||t.length-e<t.highWaterMark)&&i("length less than watermark",o=!0),t.ended||t.reading?i("reading or ended",o=!1):o&&(i("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=T(r,t))),null===(n=e>0?z(e,t):null)?(t.needReadable=t.length<=t.highWaterMark,e=0):(t.length-=e,t.awaitDrain=0),0===t.length&&(t.ended||(t.needReadable=!0),r!==e&&t.ended&&N(this)),null!==n&&this.emit("data",n),n},A.prototype._read=function(e){S(this,new w("_read()"))},A.prototype.pipe=function(e,t){var r=this,n=this._readableState;switch(n.pipesCount){case 0:n.pipes=e;break;case 1:n.pipes=[n.pipes,e];break;default:n.pipes.push(e)}n.pipesCount+=1,i("pipe count=%d opts=%j",n.pipesCount,t);var s=t&&!1===t.end||e===o.stdout||e===o.stderr?b:c;function c(){i("onend"),e.end()}n.endEmitted?o.nextTick(s):r.once("end",s),e.on("unpipe",function t(o,a){i("onunpipe"),o===r&&a&&!1===a.hasUnpiped&&(a.hasUnpiped=!0,i("cleanup"),e.removeListener("close",d),e.removeListener("finish",p),e.removeListener("drain",u),e.removeListener("error",h),e.removeListener("unpipe",t),r.removeListener("end",c),r.removeListener("end",b),r.removeListener("data",f),l=!0,!n.awaitDrain||e._writableState&&!e._writableState.needDrain||u())});var u=function(e){return function(){var t=e._readableState;i("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&a(e,"data")&&(t.flowing=!0,R(e))}}(r);e.on("drain",u);var l=!1;function f(t){i("ondata");var o=e.write(t);i("dest.write",o),!1===o&&((1===n.pipesCount&&n.pipes===e||n.pipesCount>1&&-1!==V(n.pipes,e))&&!l&&(i("false write response, pause",n.awaitDrain),n.awaitDrain++),r.pause())}function h(t){i("onerror",t),b(),e.removeListener("error",h),0===a(e,"error")&&S(e,t)}function d(){e.removeListener("finish",p),b()}function p(){i("onfinish"),e.removeListener("close",d),b()}function b(){i("unpipe"),r.unpipe(e)}return r.on("data",f),function(e,t,r){if("function"==typeof e.prependListener)return e.prependListener(t,r);e._events&&e._events[t]?Array.isArray(e._events[t])?e._events[t].unshift(r):e._events[t]=[r,e._events[t]]:e.on(t,r)}(e,"error",h),e.once("close",d),e.once("finish",p),e.emit("pipe",r),n.flowing||(i("pipe resume"),r.resume()),e},A.prototype.unpipe=function(e){var t=this._readableState,r={hasUnpiped:!1};if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes||(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this,r)),this;if(!e){var n=t.pipes,o=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var i=0;i<o;i++)n[i].emit("unpipe",this,{hasUnpiped:!1});return this}var a=V(t.pipes,e);return-1===a||(t.pipes.splice(a,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this,r)),this},A.prototype.on=function(e,t){var r=s.prototype.on.call(this,e,t),n=this._readableState;return"data"===e?(n.readableListening=this.listenerCount("readable")>0,!1!==n.flowing&&this.resume()):"readable"===e&&(n.endEmitted||n.readableListening||(n.readableListening=n.needReadable=!0,n.flowing=!1,n.emittedReadable=!1,i("on readable",n.length,n.reading),n.length?H(this):n.reading||o.nextTick(j,this))),r},A.prototype.addListener=A.prototype.on,A.prototype.removeListener=function(e,t){var r=s.prototype.removeListener.call(this,e,t);return"readable"===e&&o.nextTick(U,this),r},A.prototype.removeAllListeners=function(e){var t=s.prototype.removeAllListeners.apply(this,arguments);return"readable"!==e&&void 0!==e||o.nextTick(U,this),t},A.prototype.resume=function(){var e=this._readableState;return e.flowing||(i("resume"),e.flowing=!e.readableListening,function(e,t){t.resumeScheduled||(t.resumeScheduled=!0,o.nextTick(C,e,t))}(this,e)),e.paused=!1,this},A.prototype.pause=function(){return i("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(i("pause"),this._readableState.flowing=!1,this.emit("pause")),this._readableState.paused=!0,this},A.prototype.wrap=function(e){var t=this,r=this._readableState,n=!1;for(var o in e.on("end",function(){if(i("wrapped end"),r.decoder&&!r.ended){var e=r.decoder.end();e&&e.length&&t.push(e)}t.push(null)}),e.on("data",function(o){i("wrapped data"),r.decoder&&(o=r.decoder.write(o)),r.objectMode&&null==o||(r.objectMode||o&&o.length)&&(t.push(o)||(n=!0,e.pause()))}),e)void 0===this[o]&&"function"==typeof e[o]&&(this[o]=function(t){return function(){return e[t].apply(e,arguments)}}(o));for(var a=0;a<E.length;a++)e.on(E[a],this.emit.bind(this,E[a]));return this._read=function(t){i("wrapped _read",t),n&&(n=!1,e.resume())},this},"function"==typeof Symbol&&(A.prototype[Symbol.asyncIterator]=function(){return void 0===h&&(h=r(828)),h(this)}),Object.defineProperty(A.prototype,"readableHighWaterMark",{enumerable:!1,get:function(){return this._readableState.highWaterMark}}),Object.defineProperty(A.prototype,"readableBuffer",{enumerable:!1,get:function(){return this._readableState&&this._readableState.buffer}}),Object.defineProperty(A.prototype,"readableFlowing",{enumerable:!1,get:function(){return this._readableState.flowing},set:function(e){this._readableState&&(this._readableState.flowing=e)}}),A._fromList=z,Object.defineProperty(A.prototype,"readableLength",{enumerable:!1,get:function(){return this._readableState.length}}),"function"==typeof Symbol&&(A.from=function(e,t){return void 0===d&&(d=r(1265)),d(A,e,t)})},4473:(e,t,r)=>{"use strict";e.exports=l;var n=r(8106).q,o=n.ERR_METHOD_NOT_IMPLEMENTED,i=n.ERR_MULTIPLE_CALLBACK,a=n.ERR_TRANSFORM_ALREADY_TRANSFORMING,s=n.ERR_TRANSFORM_WITH_LENGTH_0,c=r(8656);function u(e,t){var r=this._transformState;r.transforming=!1;var n=r.writecb;if(null===n)return this.emit("error",new i);r.writechunk=null,r.writecb=null,null!=t&&this.push(t),n(e);var o=this._readableState;o.reading=!1,(o.needReadable||o.length<o.highWaterMark)&&this._read(o.highWaterMark)}function l(e){if(!(this instanceof l))return new l(e);c.call(this,e),this._transformState={afterTransform:u.bind(this),needTransform:!1,transforming:!1,writecb:null,writechunk:null,writeencoding:null},this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.on("prefinish",f)}function f(){var e=this;"function"!=typeof this._flush||this._readableState.destroyed?h(this,null,null):this._flush(function(t,r){h(e,t,r)})}function h(e,t,r){if(t)return e.emit("error",t);if(null!=r&&e.push(r),e._writableState.length)throw new s;if(e._transformState.transforming)throw new a;return e.push(null)}r(5717)(l,c),l.prototype.push=function(e,t){return this._transformState.needTransform=!1,c.prototype.push.call(this,e,t)},l.prototype._transform=function(e,t,r){r(new o("_transform()"))},l.prototype._write=function(e,t,r){var n=this._transformState;if(n.writecb=r,n.writechunk=e,n.writeencoding=t,!n.transforming){var o=this._readableState;(n.needTransform||o.needReadable||o.length<o.highWaterMark)&&this._read(o.highWaterMark)}},l.prototype._read=function(e){var t=this._transformState;null===t.writechunk||t.transforming?t.needTransform=!0:(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform))},l.prototype._destroy=function(e,t){c.prototype._destroy.call(this,e,function(e){t(e)})}},323:(e,t,r)=>{"use strict";var n,o=r(4155);function i(e){var t=this;this.next=null,this.entry=null,this.finish=function(){!function(e,t){var r=e.entry;for(e.entry=null;r;){var n=r.callback;t.pendingcb--,n(undefined),r=r.next}t.corkedRequestsFree.next=e}(t,e)}}e.exports=A,A.WritableState=k;var a,s={deprecate:r(4927)},c=r(3194),u=r(8764).Buffer,l=(void 0!==r.g?r.g:"undefined"!=typeof window?window:"undefined"!=typeof self?self:{}).Uint8Array||function(){},f=r(1029),h=r(94).getHighWaterMark,d=r(8106).q,p=d.ERR_INVALID_ARG_TYPE,b=d.ERR_METHOD_NOT_IMPLEMENTED,g=d.ERR_MULTIPLE_CALLBACK,y=d.ERR_STREAM_CANNOT_PIPE,m=d.ERR_STREAM_DESTROYED,v=d.ERR_STREAM_NULL_VALUES,w=d.ERR_STREAM_WRITE_AFTER_END,_=d.ERR_UNKNOWN_ENCODING,S=f.errorOrDestroy;function E(){}function k(e,t,a){n=n||r(8656),e=e||{},"boolean"!=typeof a&&(a=t instanceof n),this.objectMode=!!e.objectMode,a&&(this.objectMode=this.objectMode||!!e.writableObjectMode),this.highWaterMark=h(this,e,"writableHighWaterMark",a),this.finalCalled=!1,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1,this.destroyed=!1;var s=!1===e.decodeStrings;this.decodeStrings=!s,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,t){var r=e._writableState,n=r.sync,i=r.writecb;if("function"!=typeof i)throw new g;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(r),t)!function(e,t,r,n,i){--t.pendingcb,r?(o.nextTick(i,n),o.nextTick(O,e,t),e._writableState.errorEmitted=!0,S(e,n)):(i(n),e._writableState.errorEmitted=!0,S(e,n),O(e,t))}(e,r,n,t,i);else{var a=T(r)||e.destroyed;a||r.corked||r.bufferProcessing||!r.bufferedRequest||B(e,r),n?o.nextTick(I,e,r,a,i):I(e,r,a,i)}}(t,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.emitClose=!1!==e.emitClose,this.autoDestroy=!!e.autoDestroy,this.bufferedRequestCount=0,this.corkedRequestsFree=new i(this)}function A(e){var t=this instanceof(n=n||r(8656));if(!t&&!a.call(A,this))return new A(e);this._writableState=new k(e,this,t),this.writable=!0,e&&("function"==typeof e.write&&(this._write=e.write),"function"==typeof e.writev&&(this._writev=e.writev),"function"==typeof e.destroy&&(this._destroy=e.destroy),"function"==typeof e.final&&(this._final=e.final)),c.call(this)}function x(e,t,r,n,o,i,a){t.writelen=n,t.writecb=a,t.writing=!0,t.sync=!0,t.destroyed?t.onwrite(new m("write")):r?e._writev(o,t.onwrite):e._write(o,i,t.onwrite),t.sync=!1}function I(e,t,r,n){r||function(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}(e,t),t.pendingcb--,n(),O(e,t)}function B(e,t){t.bufferProcessing=!0;var r=t.bufferedRequest;if(e._writev&&r&&r.next){var n=t.bufferedRequestCount,o=new Array(n),a=t.corkedRequestsFree;a.entry=r;for(var s=0,c=!0;r;)o[s]=r,r.isBuf||(c=!1),r=r.next,s+=1;o.allBuffers=c,x(e,t,!0,t.length,o,"",a.finish),t.pendingcb++,t.lastBufferedRequest=null,a.next?(t.corkedRequestsFree=a.next,a.next=null):t.corkedRequestsFree=new i(t),t.bufferedRequestCount=0}else{for(;r;){var u=r.chunk,l=r.encoding,f=r.callback;if(x(e,t,!1,t.objectMode?1:u.length,u,l,f),r=r.next,t.bufferedRequestCount--,t.writing)break}null===r&&(t.lastBufferedRequest=null)}t.bufferedRequest=r,t.bufferProcessing=!1}function T(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function H(e,t){e._final(function(r){t.pendingcb--,r&&S(e,r),t.prefinished=!0,e.emit("prefinish"),O(e,t)})}function O(e,t){var r=T(t);if(r&&(function(e,t){t.prefinished||t.finalCalled||("function"!=typeof e._final||t.destroyed?(t.prefinished=!0,e.emit("prefinish")):(t.pendingcb++,t.finalCalled=!0,o.nextTick(H,e,t)))}(e,t),0===t.pendingcb&&(t.finished=!0,e.emit("finish"),t.autoDestroy))){var n=e._readableState;(!n||n.autoDestroy&&n.endEmitted)&&e.destroy()}return r}r(5717)(A,c),k.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},function(){try{Object.defineProperty(k.prototype,"buffer",{get:s.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.","DEP0003")})}catch(e){}}(),"function"==typeof Symbol&&Symbol.hasInstance&&"function"==typeof Function.prototype[Symbol.hasInstance]?(a=Function.prototype[Symbol.hasInstance],Object.defineProperty(A,Symbol.hasInstance,{value:function(e){return!!a.call(this,e)||this===A&&e&&e._writableState instanceof k}})):a=function(e){return e instanceof this},A.prototype.pipe=function(){S(this,new y)},A.prototype.write=function(e,t,r){var n,i=this._writableState,a=!1,s=!i.objectMode&&(n=e,u.isBuffer(n)||n instanceof l);return s&&!u.isBuffer(e)&&(e=function(e){return u.from(e)}(e)),"function"==typeof t&&(r=t,t=null),s?t="buffer":t||(t=i.defaultEncoding),"function"!=typeof r&&(r=E),i.ending?function(e,t){var r=new w;S(e,r),o.nextTick(t,r)}(this,r):(s||function(e,t,r,n){var i;return null===r?i=new v:"string"==typeof r||t.objectMode||(i=new p("chunk",["string","Buffer"],r)),!i||(S(e,i),o.nextTick(n,i),!1)}(this,i,e,r))&&(i.pendingcb++,a=function(e,t,r,n,o,i){if(!r){var a=function(e,t,r){return e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=u.from(t,r)),t}(t,n,o);n!==a&&(r=!0,o="buffer",n=a)}var s=t.objectMode?1:n.length;t.length+=s;var c=t.length<t.highWaterMark;if(c||(t.needDrain=!0),t.writing||t.corked){var l=t.lastBufferedRequest;t.lastBufferedRequest={chunk:n,encoding:o,isBuf:r,callback:i,next:null},l?l.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else x(e,t,!1,s,n,o,i);return c}(this,i,s,e,t,r)),a},A.prototype.cork=function(){this._writableState.corked++},A.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.bufferProcessing||!e.bufferedRequest||B(this,e))},A.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new _(e);return this._writableState.defaultEncoding=e,this},Object.defineProperty(A.prototype,"writableBuffer",{enumerable:!1,get:function(){return this._writableState&&this._writableState.getBuffer()}}),Object.defineProperty(A.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),A.prototype._write=function(e,t,r){r(new b("_write()"))},A.prototype._writev=null,A.prototype.end=function(e,t,r){var n=this._writableState;return"function"==typeof e?(r=e,e=null,t=null):"function"==typeof t&&(r=t,t=null),null!=e&&this.write(e,t),n.corked&&(n.corked=1,this.uncork()),n.ending||function(e,t,r){t.ending=!0,O(e,t),r&&(t.finished?o.nextTick(r):e.once("finish",r)),t.ended=!0,e.writable=!1}(this,n,r),this},Object.defineProperty(A.prototype,"writableLength",{enumerable:!1,get:function(){return this._writableState.length}}),Object.defineProperty(A.prototype,"destroyed",{enumerable:!1,get:function(){return void 0!==this._writableState&&this._writableState.destroyed},set:function(e){this._writableState&&(this._writableState.destroyed=e)}}),A.prototype.destroy=f.destroy,A.prototype._undestroy=f.undestroy,A.prototype._destroy=function(e,t){t(e)}},828:(e,t,r)=>{"use strict";var n,o=r(4155);function i(e,t,r){return(t=function(e){var t=function(e){if("object"!=typeof e||null===e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var r=t.call(e,"string");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==typeof t?t:String(t)}(t))in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}var a=r(1086),s=Symbol("lastResolve"),c=Symbol("lastReject"),u=Symbol("error"),l=Symbol("ended"),f=Symbol("lastPromise"),h=Symbol("handlePromise"),d=Symbol("stream");function p(e,t){return{value:e,done:t}}function b(e){var t=e[s];if(null!==t){var r=e[d].read();null!==r&&(e[f]=null,e[s]=null,e[c]=null,t(p(r,!1)))}}function g(e){o.nextTick(b,e)}var y=Object.getPrototypeOf(function(){}),m=Object.setPrototypeOf((i(n={get stream(){return this[d]},next:function(){var e=this,t=this[u];if(null!==t)return Promise.reject(t);if(this[l])return Promise.resolve(p(void 0,!0));if(this[d].destroyed)return new Promise(function(t,r){o.nextTick(function(){e[u]?r(e[u]):t(p(void 0,!0))})});var r,n=this[f];if(n)r=new Promise(function(e,t){return function(r,n){e.then(function(){t[l]?r(p(void 0,!0)):t[h](r,n)},n)}}(n,this));else{var i=this[d].read();if(null!==i)return Promise.resolve(p(i,!1));r=new Promise(this[h])}return this[f]=r,r}},Symbol.asyncIterator,function(){return this}),i(n,"return",function(){var e=this;return new Promise(function(t,r){e[d].destroy(null,function(e){e?r(e):t(p(void 0,!0))})})}),n),y);e.exports=function(e){var t,r=Object.create(m,(i(t={},d,{value:e,writable:!0}),i(t,s,{value:null,writable:!0}),i(t,c,{value:null,writable:!0}),i(t,u,{value:null,writable:!0}),i(t,l,{value:e._readableState.endEmitted,writable:!0}),i(t,h,{value:function(e,t){var n=r[d].read();n?(r[f]=null,r[s]=null,r[c]=null,e(p(n,!1))):(r[s]=e,r[c]=t)},writable:!0}),t));return r[f]=null,a(e,function(e){if(e&&"ERR_STREAM_PREMATURE_CLOSE"!==e.code){var t=r[c];return null!==t&&(r[f]=null,r[s]=null,r[c]=null,t(e)),void(r[u]=e)}var n=r[s];null!==n&&(r[f]=null,r[s]=null,r[c]=null,n(p(void 0,!0))),r[l]=!0}),e.on("readable",g.bind(null,r)),r}},9686:(e,t,r)=>{"use strict";function n(e,t){var r=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),r.push.apply(r,n)}return r}function o(e){for(var t=1;t<arguments.length;t++){var r=null!=arguments[t]?arguments[t]:{};t%2?n(Object(r),!0).forEach(function(t){i(e,t,r[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(r)):n(Object(r)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(r,t))})}return e}function i(e,t,r){return(t=s(t))in e?Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}):e[t]=r,e}function a(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,s(n.key),n)}}function s(e){var t=function(e){if("object"!=typeof e||null===e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var r=t.call(e,"string");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==typeof t?t:String(t)}var c=r(8764).Buffer,u=r(9862).inspect,l=u&&u.custom||"inspect";function f(e,t,r){c.prototype.copy.call(e,t,r)}e.exports=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.head=null,this.tail=null,this.length=0}var t,r;return t=e,(r=[{key:"push",value:function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length}},{key:"unshift",value:function(e){var t={data:e,next:this.head};0===this.length&&(this.tail=t),this.head=t,++this.length}},{key:"shift",value:function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}}},{key:"clear",value:function(){this.head=this.tail=null,this.length=0}},{key:"join",value:function(e){if(0===this.length)return"";for(var t=this.head,r=""+t.data;t=t.next;)r+=e+t.data;return r}},{key:"concat",value:function(e){if(0===this.length)return c.alloc(0);for(var t=c.allocUnsafe(e>>>0),r=this.head,n=0;r;)f(r.data,t,n),n+=r.data.length,r=r.next;return t}},{key:"consume",value:function(e,t){var r;return e<this.head.data.length?(r=this.head.data.slice(0,e),this.head.data=this.head.data.slice(e)):r=e===this.head.data.length?this.shift():t?this._getString(e):this._getBuffer(e),r}},{key:"first",value:function(){return this.head.data}},{key:"_getString",value:function(e){var t=this.head,r=1,n=t.data;for(e-=n.length;t=t.next;){var o=t.data,i=e>o.length?o.length:e;if(i===o.length?n+=o:n+=o.slice(0,e),0===(e-=i)){i===o.length?(++r,t.next?this.head=t.next:this.head=this.tail=null):(this.head=t,t.data=o.slice(i));break}++r}return this.length-=r,n}},{key:"_getBuffer",value:function(e){var t=c.allocUnsafe(e),r=this.head,n=1;for(r.data.copy(t),e-=r.data.length;r=r.next;){var o=r.data,i=e>o.length?o.length:e;if(o.copy(t,t.length-e,0,i),0===(e-=i)){i===o.length?(++n,r.next?this.head=r.next:this.head=this.tail=null):(this.head=r,r.data=o.slice(i));break}++n}return this.length-=n,t}},{key:l,value:function(e,t){return u(this,o(o({},t),{},{depth:0,customInspect:!1}))}}])&&a(t.prototype,r),Object.defineProperty(t,"prototype",{writable:!1}),e}()},1029:(e,t,r)=>{"use strict";var n=r(4155);function o(e,t){a(e,t),i(e)}function i(e){e._writableState&&!e._writableState.emitClose||e._readableState&&!e._readableState.emitClose||e.emit("close")}function a(e,t){e.emit("error",t)}e.exports={destroy:function(e,t){var r=this,s=this._readableState&&this._readableState.destroyed,c=this._writableState&&this._writableState.destroyed;return s||c?(t?t(e):e&&(this._writableState?this._writableState.errorEmitted||(this._writableState.errorEmitted=!0,n.nextTick(a,this,e)):n.nextTick(a,this,e)),this):(this._readableState&&(this._readableState.destroyed=!0),this._writableState&&(this._writableState.destroyed=!0),this._destroy(e||null,function(e){!t&&e?r._writableState?r._writableState.errorEmitted?n.nextTick(i,r):(r._writableState.errorEmitted=!0,n.nextTick(o,r,e)):n.nextTick(o,r,e):t?(n.nextTick(i,r),t(e)):n.nextTick(i,r)}),this)},undestroy:function(){this._readableState&&(this._readableState.destroyed=!1,this._readableState.reading=!1,this._readableState.ended=!1,this._readableState.endEmitted=!1),this._writableState&&(this._writableState.destroyed=!1,this._writableState.ended=!1,this._writableState.ending=!1,this._writableState.finalCalled=!1,this._writableState.prefinished=!1,this._writableState.finished=!1,this._writableState.errorEmitted=!1)},errorOrDestroy:function(e,t){var r=e._readableState,n=e._writableState;r&&r.autoDestroy||n&&n.autoDestroy?e.destroy(t):e.emit("error",t)}}},1086:(e,t,r)=>{"use strict";var n=r(8106).q.ERR_STREAM_PREMATURE_CLOSE;function o(){}e.exports=function e(t,r,i){if("function"==typeof r)return e(t,null,r);r||(r={}),i=function(e){var t=!1;return function(){if(!t){t=!0;for(var r=arguments.length,n=new Array(r),o=0;o<r;o++)n[o]=arguments[o];e.apply(this,n)}}}(i||o);var a=r.readable||!1!==r.readable&&t.readable,s=r.writable||!1!==r.writable&&t.writable,c=function(){t.writable||l()},u=t._writableState&&t._writableState.finished,l=function(){s=!1,u=!0,a||i.call(t)},f=t._readableState&&t._readableState.endEmitted,h=function(){a=!1,f=!0,s||i.call(t)},d=function(e){i.call(t,e)},p=function(){var e;return a&&!f?(t._readableState&&t._readableState.ended||(e=new n),i.call(t,e)):s&&!u?(t._writableState&&t._writableState.ended||(e=new n),i.call(t,e)):void 0},b=function(){t.req.on("finish",l)};return function(e){return e.setHeader&&"function"==typeof e.abort}(t)?(t.on("complete",l),t.on("abort",p),t.req?b():t.on("request",b)):s&&!t._writableState&&(t.on("end",c),t.on("close",c)),t.on("end",h),t.on("finish",l),!1!==r.error&&t.on("error",d),t.on("close",p),function(){t.removeListener("complete",l),t.removeListener("abort",p),t.removeListener("request",b),t.req&&t.req.removeListener("finish",l),t.removeListener("end",c),t.removeListener("close",c),t.removeListener("finish",l),t.removeListener("end",h),t.removeListener("error",d),t.removeListener("close",p)}}},1265:e=>{e.exports=function(){throw new Error("Readable.from is not available in the browser")}},6472:(e,t,r)=>{"use strict";var n,o=r(8106).q,i=o.ERR_MISSING_ARGS,a=o.ERR_STREAM_DESTROYED;function s(e){if(e)throw e}function c(e){e()}function u(e,t){return e.pipe(t)}e.exports=function(){for(var e=arguments.length,t=new Array(e),o=0;o<e;o++)t[o]=arguments[o];var l,f=function(e){return e.length?"function"!=typeof e[e.length-1]?s:e.pop():s}(t);if(Array.isArray(t[0])&&(t=t[0]),t.length<2)throw new i("streams");var h=t.map(function(e,o){var i=o<t.length-1;return function(e,t,o,i){i=function(e){var t=!1;return function(){t||(t=!0,e.apply(void 0,arguments))}}(i);var s=!1;e.on("close",function(){s=!0}),void 0===n&&(n=r(1086)),n(e,{readable:t,writable:o},function(e){if(e)return i(e);s=!0,i()});var c=!1;return function(t){if(!s&&!c)return c=!0,function(e){return e.setHeader&&"function"==typeof e.abort}(e)?e.abort():"function"==typeof e.destroy?e.destroy():void i(t||new a("pipe"))}}(e,i,o>0,function(e){l||(l=e),e&&h.forEach(c),i||(h.forEach(c),f(l))})});return t.reduce(u)}},94:(e,t,r)=>{"use strict";var n=r(8106).q.ERR_INVALID_OPT_VALUE;e.exports={getHighWaterMark:function(e,t,r,o){var i=function(e,t,r){return null!=e.highWaterMark?e.highWaterMark:t?e[r]:null}(t,o,r);if(null!=i){if(!isFinite(i)||Math.floor(i)!==i||i<0)throw new n(o?r:"highWaterMark",i);return Math.floor(i)}return e.objectMode?16:16384}}},3194:(e,t,r)=>{e.exports=r(7187).EventEmitter},2553:(e,t,r)=>{"use strict";var n=r(396).Buffer,o=n.isEncoding||function(e){switch((e=""+e)&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};function i(e){var t;switch(this.encoding=function(e){var t=function(e){if(!e)return"utf8";for(var t;;)switch(e){case"utf8":case"utf-8":return"utf8";case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return"utf16le";case"latin1":case"binary":return"latin1";case"base64":case"ascii":case"hex":return e;default:if(t)return;e=(""+e).toLowerCase(),t=!0}}(e);if("string"!=typeof t&&(n.isEncoding===o||!o(e)))throw new Error("Unknown encoding: "+e);return t||e}(e),this.encoding){case"utf16le":this.text=c,this.end=u,t=4;break;case"utf8":this.fillLast=s,t=4;break;case"base64":this.text=l,this.end=f,t=3;break;default:return this.write=h,void(this.end=d)}this.lastNeed=0,this.lastTotal=0,this.lastChar=n.allocUnsafe(t)}function a(e){return e<=127?0:e>>5==6?2:e>>4==14?3:e>>3==30?4:e>>6==2?-1:-2}function s(e){var t=this.lastTotal-this.lastNeed,r=function(e,t){if(128!=(192&t[0]))return e.lastNeed=0,"�";if(e.lastNeed>1&&t.length>1){if(128!=(192&t[1]))return e.lastNeed=1,"�";if(e.lastNeed>2&&t.length>2&&128!=(192&t[2]))return e.lastNeed=2,"�"}}(this,e);return void 0!==r?r:this.lastNeed<=e.length?(e.copy(this.lastChar,t,0,this.lastNeed),this.lastChar.toString(this.encoding,0,this.lastTotal)):(e.copy(this.lastChar,t,0,e.length),void(this.lastNeed-=e.length))}function c(e,t){if((e.length-t)%2==0){var r=e.toString("utf16le",t);if(r){var n=r.charCodeAt(r.length-1);if(n>=55296&&n<=56319)return this.lastNeed=2,this.lastTotal=4,this.lastChar[0]=e[e.length-2],this.lastChar[1]=e[e.length-1],r.slice(0,-1)}return r}return this.lastNeed=1,this.lastTotal=2,this.lastChar[0]=e[e.length-1],e.toString("utf16le",t,e.length-1)}function u(e){var t=e&&e.length?this.write(e):"";if(this.lastNeed){var r=this.lastTotal-this.lastNeed;return t+this.lastChar.toString("utf16le",0,r)}return t}function l(e,t){var r=(e.length-t)%3;return 0===r?e.toString("base64",t):(this.lastNeed=3-r,this.lastTotal=3,1===r?this.lastChar[0]=e[e.length-1]:(this.lastChar[0]=e[e.length-2],this.lastChar[1]=e[e.length-1]),e.toString("base64",t,e.length-r))}function f(e){var t=e&&e.length?this.write(e):"";return this.lastNeed?t+this.lastChar.toString("base64",0,3-this.lastNeed):t}function h(e){return e.toString(this.encoding)}function d(e){return e&&e.length?this.write(e):""}t.s=i,i.prototype.write=function(e){if(0===e.length)return"";var t,r;if(this.lastNeed){if(void 0===(t=this.fillLast(e)))return"";r=this.lastNeed,this.lastNeed=0}else r=0;return r<e.length?t?t+this.text(e,r):this.text(e,r):t||""},i.prototype.end=function(e){var t=e&&e.length?this.write(e):"";return this.lastNeed?t+"�":t},i.prototype.text=function(e,t){var r=function(e,t,r){var n=t.length-1;if(n<r)return 0;var o=a(t[n]);return o>=0?(o>0&&(e.lastNeed=o-1),o):--n<r||-2===o?0:(o=a(t[n]))>=0?(o>0&&(e.lastNeed=o-2),o):--n<r||-2===o?0:(o=a(t[n]))>=0?(o>0&&(2===o?o=0:e.lastNeed=o-3),o):0}(this,e,t);if(!this.lastNeed)return e.toString("utf8",t);this.lastTotal=r;var n=e.length-(r-this.lastNeed);return e.copy(this.lastChar,0,n),e.toString("utf8",t,n)},i.prototype.fillLast=function(e){if(this.lastNeed<=e.length)return e.copy(this.lastChar,this.lastTotal-this.lastNeed,0,this.lastNeed),this.lastChar.toString(this.encoding,0,this.lastTotal);e.copy(this.lastChar,this.lastTotal-this.lastNeed,0,e.length),this.lastNeed-=e.length}},396:(e,t,r)=>{var n=r(8764),o=n.Buffer;function i(e,t){for(var r in e)t[r]=e[r]}function a(e,t,r){return o(e,t,r)}o.from&&o.alloc&&o.allocUnsafe&&o.allocUnsafeSlow?e.exports=n:(i(n,t),t.Buffer=a),i(o,a),a.from=function(e,t,r){if("number"==typeof e)throw new TypeError("Argument must not be a number");return o(e,t,r)},a.alloc=function(e,t,r){if("number"!=typeof e)throw new TypeError("Argument must be a number");var n=o(e);return void 0!==t?"string"==typeof r?n.fill(t,r):n.fill(t):n.fill(0),n},a.allocUnsafe=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return o(e)},a.allocUnsafeSlow=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return n.SlowBuffer(e)}},5309:(e,t,r)=>{"use strict";var n=r(9509).Buffer,o=r(4707),i=r(1040),a=ArrayBuffer.isView||function(e){try{return i(e),!0}catch(e){return!1}},s="undefined"!=typeof Uint8Array,c="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,u=c&&(n.prototype instanceof Uint8Array||n.TYPED_ARRAY_SUPPORT);e.exports=function(e,t){if(n.isBuffer(e))return e.constructor&&!("isBuffer"in e)?n.from(e):e;if("string"==typeof e)return n.from(e,t);if(c&&a(e)){if(0===e.byteLength)return n.alloc(0);if(u){var r=n.from(e.buffer,e.byteOffset,e.byteLength);if(r.byteLength===e.byteLength)return r}var i=e instanceof Uint8Array?e:new Uint8Array(e.buffer,e.byteOffset,e.byteLength),l=n.from(i);if(l.length===e.byteLength)return l}if(s&&e instanceof Uint8Array)return n.from(e);var f=o(e);if(f)for(var h=0;h<e.length;h+=1){var d=e[h];if("number"!=typeof d||d<0||d>255||~~d!==d)throw new RangeError("Array items must be numbers in the range 0-255.")}if(f||n.isBuffer(e)&&e.constructor&&"function"==typeof e.constructor.isBuffer&&e.constructor.isBuffer(e))return n.from(e);throw new TypeError('The "data" argument must be a string, an Array, a Buffer, a Uint8Array, or a DataView.')}},4707:e=>{var t={}.toString;e.exports=Array.isArray||function(e){return"[object Array]"==t.call(e)}},1040:(e,t,r)=>{"use strict";var n=r(4453),o=r(7379)("TypedArray.prototype.buffer",!0),i=r(5692);e.exports=o||function(e){if(!i(e))throw new n("Not a Typed Array");return e.buffer}},6647:(e,t,r)=>{var n=r(247);function o(e){return e.name||e.toString().match(/function (.*?)\s*\(/)[1]}function i(e){return n.Nil(e)?"":o(e.constructor)}function a(e,t){Error.captureStackTrace&&Error.captureStackTrace(e,t)}function s(e){return n.Function(e)?e.toJSON?e.toJSON():o(e):n.Array(e)?"Array":e&&n.Object(e)?"Object":void 0!==e?e:""}function c(e,t,r){var o=function(e){return n.Function(e)?"":n.String(e)?JSON.stringify(e):e&&n.Object(e)?"":e}(t);return"Expected "+s(e)+", got"+(""!==r?" "+r:"")+(""!==o?" "+o:"")}function u(e,t,r){r=r||i(t),this.message=c(e,t,r),a(this,u),this.__type=e,this.__value=t,this.__valueTypeName=r}function l(e,t,r,n,o){e?(o=o||i(n),this.message=function(e,t,r,n,o){var i='" of type ';return"key"===t&&(i='" with key type '),c('property "'+s(r)+i+s(e),n,o)}(e,r,t,n,o)):this.message='Unexpected property "'+t+'"',a(this,u),this.__label=r,this.__property=t,this.__type=e,this.__value=n,this.__valueTypeName=o}u.prototype=Object.create(Error.prototype),u.prototype.constructor=u,l.prototype=Object.create(Error.prototype),l.prototype.constructor=u,e.exports={TfTypeError:u,TfPropertyTypeError:l,tfCustomError:function(e,t){return new u(e,{},t)},tfSubError:function(e,t,r){return e instanceof l?(t=t+"."+e.__property,e=new l(e.__type,t,e.__label,e.__value,e.__valueTypeName)):e instanceof u&&(e=new l(e.__type,t,r,e.__value,e.__valueTypeName)),a(e),e},tfJSON:s,getValueTypeName:i}},4307:(e,t,r)=>{var n=r(8764).Buffer,o=r(247),i=r(6647);function a(e){return n.isBuffer(e)}function s(e){return"string"==typeof e&&/^([0-9a-f]{2})+$/i.test(e)}function c(e,t){var r=e.toJSON();function n(n){if(!e(n))return!1;if(n.length===t)return!0;throw i.tfCustomError(r+"(Length: "+t+")",r+"(Length: "+n.length+")")}return n.toJSON=function(){return r},n}var u=c.bind(null,o.Array),l=c.bind(null,a),f=c.bind(null,s),h=c.bind(null,o.String),d=Math.pow(2,53)-1,p={ArrayN:u,Buffer:a,BufferN:l,Finite:function(e){return"number"==typeof e&&isFinite(e)},Hex:s,HexN:f,Int8:function(e){return e<<24>>24===e},Int16:function(e){return e<<16>>16===e},Int32:function(e){return(0|e)===e},Int53:function(e){return"number"==typeof e&&e>=-d&&e<=d&&Math.floor(e)===e},Range:function(e,t,r){function n(n,o){return r(n,o)&&n>e&&n<t}return r=r||o.Number,n.toJSON=function(){return`${r.toJSON()} between [${e}, ${t}]`},n},StringN:h,UInt8:function(e){return(255&e)===e},UInt16:function(e){return(65535&e)===e},UInt32:function(e){return e>>>0===e},UInt53:function(e){return"number"==typeof e&&e>=0&&e<=d&&Math.floor(e)===e}};for(var b in p)p[b].toJSON=function(e){return e}.bind(null,b);e.exports=p},2401:(e,t,r)=>{var n=r(6647),o=r(247),i=n.tfJSON,a=n.TfTypeError,s=n.TfPropertyTypeError,c=n.tfSubError,u=n.getValueTypeName,l={arrayOf:function(e,t){function r(r,n){return!!o.Array(r)&&!o.Nil(r)&&!(void 0!==t.minLength&&r.length<t.minLength)&&!(void 0!==t.maxLength&&r.length>t.maxLength)&&(void 0===t.length||r.length===t.length)&&r.every(function(t,r){try{return h(e,t,n)}catch(e){throw c(e,r)}})}return e=f(e),t=t||{},r.toJSON=function(){var r="["+i(e)+"]";return void 0!==t.length?r+="{"+t.length+"}":void 0===t.minLength&&void 0===t.maxLength||(r+="{"+(void 0===t.minLength?0:t.minLength)+","+(void 0===t.maxLength?1/0:t.maxLength)+"}"),r},r},maybe:function e(t){function r(r,n){return o.Nil(r)||t(r,n,e)}return t=f(t),r.toJSON=function(){return"?"+i(t)},r},map:function(e,t){function r(r,n){if(!o.Object(r))return!1;if(o.Nil(r))return!1;for(var i in r){try{t&&h(t,i,n)}catch(e){throw c(e,i,"key")}try{var a=r[i];h(e,a,n)}catch(e){throw c(e,i)}}return!0}return e=f(e),t&&(t=f(t)),r.toJSON=t?function(){return"{"+i(t)+": "+i(e)+"}"}:function(){return"{"+i(e)+"}"},r},object:function(e){var t={};for(var r in e)t[r]=f(e[r]);function n(e,r){if(!o.Object(e))return!1;if(o.Nil(e))return!1;var n;try{for(n in t)h(t[n],e[n],r)}catch(e){throw c(e,n)}if(r)for(n in e)if(!t[n])throw new s(void 0,n);return!0}return n.toJSON=function(){return i(t)},n},anyOf:function(){var e=[].slice.call(arguments).map(f);function t(t,r){return e.some(function(e){try{return h(e,t,r)}catch(e){return!1}})}return t.toJSON=function(){return e.map(i).join("|")},t},allOf:function(){var e=[].slice.call(arguments).map(f);function t(t,r){return e.every(function(e){try{return h(e,t,r)}catch(e){return!1}})}return t.toJSON=function(){return e.map(i).join(" & ")},t},quacksLike:function(e){function t(t){return e===u(t)}return t.toJSON=function(){return e},t},tuple:function(){var e=[].slice.call(arguments).map(f);function t(t,r){return!o.Nil(t)&&!o.Nil(t.length)&&(!r||t.length===e.length)&&e.every(function(e,n){try{return h(e,t[n],r)}catch(e){throw c(e,n)}})}return t.toJSON=function(){return"("+e.map(i).join(", ")+")"},t},value:function(e){function t(t){return t===e}return t.toJSON=function(){return e},t}};function f(e){if(o.String(e))return"?"===e[0]?l.maybe(e.slice(1)):o[e]||l.quacksLike(e);if(e&&o.Object(e)){if(o.Array(e)){if(1!==e.length)throw new TypeError("Expected compile() parameter of type Array of length 1");return l.arrayOf(e[0])}return l.object(e)}return o.Function(e)?e:l.value(e)}function h(e,t,r,n){if(o.Function(e)){if(e(t,r))return!0;throw new a(n||e,t)}return h(f(e),t,r)}for(var d in l.oneOf=l.anyOf,o)h[d]=o[d];for(d in l)h[d]=l[d];var p=r(4307);for(d in p)h[d]=p[d];h.compile=f,h.TfTypeError=a,h.TfPropertyTypeError=s,e.exports=h},247:e=>{var t={Array:function(e){return null!=e&&e.constructor===Array},Boolean:function(e){return"boolean"==typeof e},Function:function(e){return"function"==typeof e},Nil:function(e){return null==e},Number:function(e){return"number"==typeof e},Object:function(e){return"object"==typeof e},String:function(e){return"string"==typeof e},"":function(){return!0}};for(var r in t.Null=t.Nil,t)t[r].toJSON=function(e){return e}.bind(null,r);e.exports=t},4927:(e,t,r)=>{function n(e){try{if(!r.g.localStorage)return!1}catch(e){return!1}var t=r.g.localStorage[e];return null!=t&&"true"===String(t).toLowerCase()}e.exports=function(e,t){if(n("noDeprecation"))return e;var r=!1;return function(){if(!r){if(n("throwDeprecation"))throw new Error(t);n("traceDeprecation")?console.trace(t):console.warn(t),r=!0}return e.apply(this,arguments)}}},7795:(e,t,r)=>{"use strict";var n=r(9509).Buffer;function o(e){if(e<0||e>9007199254740991||e%1!=0)throw new RangeError("value out of range")}function i(e){return o(e),e<253?1:e<=65535?3:e<=4294967295?5:9}e.exports={encode:function e(t,r,a){if(o(t),r||(r=n.allocUnsafe(i(t))),!n.isBuffer(r))throw new TypeError("buffer must be a Buffer instance");return a||(a=0),t<253?(r.writeUInt8(t,a),e.bytes=1):t<=65535?(r.writeUInt8(253,a),r.writeUInt16LE(t,a+1),e.bytes=3):t<=4294967295?(r.writeUInt8(254,a),r.writeUInt32LE(t,a+1),e.bytes=5):(r.writeUInt8(255,a),r.writeUInt32LE(t>>>0,a+1),r.writeUInt32LE(t/4294967296|0,a+5),e.bytes=9),r},decode:function e(t,r){if(!n.isBuffer(t))throw new TypeError("buffer must be a Buffer instance");r||(r=0);var i=t.readUInt8(r);if(i<253)return e.bytes=1,i;if(253===i)return e.bytes=3,t.readUInt16LE(r+1);if(254===i)return e.bytes=5,t.readUInt32LE(r+1);e.bytes=9;var a=t.readUInt32LE(r+1),s=4294967296*t.readUInt32LE(r+5)+a;return o(s),s},encodingLength:i}},6430:(e,t,r)=>{"use strict";var n=r(4029),o=r(3083),i=r(5559),a=r(7379),s=r(7296),c=r(1618),u=a("Object.prototype.toString"),l=r(6410)(),f="undefined"==typeof globalThis?r.g:globalThis,h=o(),d=a("String.prototype.slice"),p=a("Array.prototype.indexOf",!0)||function(e,t){for(var r=0;r<e.length;r+=1)if(e[r]===t)return r;return-1},b={__proto__:null};n(h,l&&s&&c?function(e){var t=new f[e];if(Symbol.toStringTag in t&&c){var r=c(t),n=s(r,Symbol.toStringTag);if(!n&&r){var o=c(r);n=s(o,Symbol.toStringTag)}b["$"+e]=i(n.get)}}:function(e){var t=new f[e],r=t.slice||t.set;r&&(b["$"+e]=i(r))}),e.exports=function(e){if(!e||"object"!=typeof e)return!1;if(!l){var t=d(u(e),8,-1);return p(h,t)>-1?t:"Object"===t&&function(e){var t=!1;return n(b,function(r,n){if(!t)try{r(e),t=d(n,1)}catch(e){}}),t}(e)}return s?function(e){var t=!1;return n(b,function(r,n){if(!t)try{"$"+r(e)===n&&(t=d(n,1))}catch(e){}}),t}(e):null}},7174:(e,t,r)=>{var n=r(8764).Buffer,o=r(2255);function i(e,t){if(void 0!==t&&e[0]!==t)throw new Error("Invalid network version");if(33===e.length)return{version:e[0],privateKey:e.slice(1,33),compressed:!1};if(34!==e.length)throw new Error("Invalid WIF length");if(1!==e[33])throw new Error("Invalid compression flag");return{version:e[0],privateKey:e.slice(1,33),compressed:!0}}function a(e,t,r){var o=new n(r?34:33);return o.writeUInt8(e,0),t.copy(o,1),r&&(o[33]=1),o}e.exports={decode:function(e,t){return i(o.decode(e),t)},decodeRaw:i,encode:function(e,t,r){return"number"==typeof e?o.encode(a(e,t,r)):o.encode(a(e.version,e.privateKey,e.compressed))},encodeRaw:a}},4405:(e,t,r)=>{"use strict";var n=r(9509).Buffer;e.exports=function(e){if(e.length>=255)throw new TypeError("Alphabet too long");for(var t=new Uint8Array(256),r=0;r<t.length;r++)t[r]=255;for(var o=0;o<e.length;o++){var i=e.charAt(o),a=i.charCodeAt(0);if(255!==t[a])throw new TypeError(i+" is ambiguous");t[a]=o}var s=e.length,c=e.charAt(0),u=Math.log(s)/Math.log(256),l=Math.log(256)/Math.log(s);function f(e){if("string"!=typeof e)throw new TypeError("Expected String");if(0===e.length)return n.alloc(0);for(var r=0,o=0,i=0;e[r]===c;)o++,r++;for(var a=(e.length-r)*u+1>>>0,l=new Uint8Array(a);r<e.length;){var f=e.charCodeAt(r);if(f>255)return;var h=t[f];if(255===h)return;for(var d=0,p=a-1;(0!==h||d<i)&&-1!==p;p--,d++)h+=s*l[p]>>>0,l[p]=h%256>>>0,h=h/256>>>0;if(0!==h)throw new Error("Non-zero carry");i=d,r++}for(var b=a-i;b!==a&&0===l[b];)b++;var g=n.allocUnsafe(o+(a-b));g.fill(0,0,o);for(var y=o;b!==a;)g[y++]=l[b++];return g}return{encode:function(t){if((Array.isArray(t)||t instanceof Uint8Array)&&(t=n.from(t)),!n.isBuffer(t))throw new TypeError("Expected Buffer");if(0===t.length)return"";for(var r=0,o=0,i=0,a=t.length;i!==a&&0===t[i];)i++,r++;for(var u=(a-i)*l+1>>>0,f=new Uint8Array(u);i!==a;){for(var h=t[i],d=0,p=u-1;(0!==h||d<o)&&-1!==p;p--,d++)h+=256*f[p]>>>0,f[p]=h%s>>>0,h=h/s>>>0;if(0!==h)throw new Error("Non-zero carry");o=d,i++}for(var b=u-o;b!==u&&0===f[b];)b++;for(var g=c.repeat(r);b<u;++b)g+=e.charAt(f[b]);return g},decodeUnsafe:f,decode:function(e){var t=f(e);if(t)return t;throw new Error("Non-base"+s+" character")}}}},6626:(e,t,r)=>{var n=r(4405);e.exports=n("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz")},8589:(e,t,r)=>{"use strict";var n=r(6626),o=r(9509).Buffer;e.exports=function(e){function t(t){var r=t.slice(0,-4),n=t.slice(-4),o=e(r);if(!(n[0]^o[0]|n[1]^o[1]|n[2]^o[2]|n[3]^o[3]))return r}return{encode:function(t){var r=e(t);return n.encode(o.concat([t,r],t.length+4))},decode:function(e){var r=t(n.decode(e));if(!r)throw new Error("Invalid checksum");return r},decodeUnsafe:function(e){var r=n.decodeUnsafe(e);if(r)return t(r)}}}},2255:(e,t,r)=>{"use strict";var n=r(3482),o=r(8589);e.exports=o(function(e){var t=n("sha256").update(e).digest();return n("sha256").update(t).digest()})},6862:(e,t,r)=>{var n=r(8764).Buffer;const o=r(7656),i=r(2153),{BIP32Factory:a}=r(7786),s=r(7235),{schnorr:c,getPublicKey:u,getSharedSecret:l}=r(335),{sha256:f}=r(8039),{hmac:h}=r(555),d=a(s);o.initEccLib(s);const p=r(335);p.hashes=p.hashes||{},p.hashes.hmacSha256=(e,...t)=>{const r=t.reduce((e,t)=>new Uint8Array([...e,...t]),new Uint8Array);return h(f,e,r)},p.hashes.sha256=(...e)=>{const t=e.reduce((e,t)=>new Uint8Array([...e,...t]),new Uint8Array);return f(t)};const b=o.networks.bitcoin,g=128;async function y(e,t,r={}){try{console.log("🔐 ═══════════════════════════════════════════════════════════════"),console.log("   SIGNING PSBT 100% LOCALLY - MNEMONIC NEVER LEAVES DEVICE!"),console.log("═══════════════════════════════════════════════════════════════");const a=r.inputsToSign||null,c=!1!==r.autoFinalize;let u=x(r.sighashType);console.log("   📋 Options:"),console.log(`      inputsToSign: ${a?JSON.stringify(a):"ALL"}`),console.log(`      sighashType: 0x${u.toString(16)} (${I(u)})`),console.log(`      autoFinalize: ${c}`);const l=await i.mnemonicToSeed(e);console.log("   ✅ Seed derived from mnemonic");const f=d.fromSeed(l,b),h="m/86'/0'/0'/0/0",p=f.derivePath(h);console.log("   ✅ Key derived:",h);const g=n.from(p.publicKey.subarray(1,33)),y=o.crypto.taggedHash("TapTweak",g);let w=s.privateAdd(p.privateKey,y);if(!w)throw new Error("Failed to tweak private key");2===s.pointFromScalar(w)[0]||(console.log("   ⚙️  Negating private key for even Y..."),w=s.privateNegate(w));const _=s.pointFromScalar(w),S=n.from(_.subarray(1,33));console.log("   ✅ Taproot key ready (tweaked)"),console.log(`      Internal pubkey: ${g.toString("hex").substring(0,16)}...`),console.log(`      Tweaked pubkey: ${S.toString("hex").substring(0,16)}...`);const E=o.Psbt.fromBase64(t,{network:b});console.log(`   ✅ PSBT loaded, ${E.data.inputs.length} inputs, ${E.txOutputs.length} outputs`);const k=a?a.map(e=>{if("number"==typeof e)return{index:e,sighashType:u};const t=e.sighashTypes?.[0]||e.sighashType||u;return{index:e.index,sighashType:x(t)}}):Array.from({length:E.data.inputs.length},(e,t)=>({index:t,sighashType:u})),A=k.map(e=>e.index);console.log(`   🎯 Will sign inputs: [${A.join(", ")}]`),console.log("   🎯 Input sighashTypes:",k.map(e=>`[${e.index}]: 0x${e.sighashType.toString(16)}`));for(const e of k){const t=e.index,r=e.sighashType,n=E.data.inputs[t];n.tapKeySig||n.tapScriptSig?console.log(`   ⏭️  Input ${t}: Already signed, skipping`):n.witnessUtxo?(console.log(`\n   🔏 Signing input ${t}...`),console.log(`      Value: ${n.witnessUtxo.value} sats`),console.log(`      SighashType: 0x${r.toString(16)} (${I(r)})`),n.tapInternalKey||E.updateInput(t,{tapInternalKey:g}),n.tapLeafScript&&n.tapLeafScript.length>0?(console.log("      📜 Script-path spend detected"),await m(E,t,p.privateKey,g,r)):(console.log("      🔑 Key-path spend"),await v(E,t,w,r))):console.log(`   ⏭️  Input ${t}: No witnessUtxo, skipping (not ours?)`)}let B=null;if(c){console.log("\n   🔧 Finalizing all inputs...");for(const e of A)try{E.finalizeInput(e),console.log(`      ✅ Input ${e} finalized`)}catch(t){console.log(`      ⚠️  Input ${e} finalization skipped:`,t.message)}try{E.data.inputs.every((e,t)=>!A.includes(t)||e.finalScriptWitness)&&(B=E.extractTransaction().toHex(),console.log(`   ✅ Transaction extracted: ${B.length/2} bytes`))}catch(e){console.log("   ⚠️  Could not extract TX (partial signing?):",e.message)}}else console.log("\n   ⏸️  autoFinalize=false - Returning PSBT without finalizing");e=null;const T=E.toBase64();return console.log("\n🎉 ═══════════════════════════════════════════════════════════════"),console.log("   PSBT SIGNED 100% LOCALLY - SUCCESS!"),console.log(`   Signed PSBT: ${T.length} chars`),console.log("═══════════════════════════════════════════════════════════════\n"),{signedPsbt:T,txHex:B}}catch(t){throw console.error("❌ Error signing PSBT locally:",t),e=null,t}}async function m(e,t,r,i,a){console.log(`      🔨 Script-path signing input ${t}`);const u=e.data.inputs[t].tapLeafScript[0],l=u.leafVersion||192,h=function(e,t=192){const r=e.length;let i;r<253?i=n.from([r]):r<65536?(i=n.alloc(3),i[0]=253,i.writeUInt16LE(r,1)):(i=n.alloc(5),i[0]=254,i.writeUInt32LE(r,1));const a=n.concat([n.from([t]),i,e]);return o.crypto.taggedHash("TapLeaf",a)}(u.script,l);console.log(`      🌿 Leaf hash: ${n.from(h).toString("hex").substring(0,16)}...`);const d=[];for(let t=0;t<e.data.inputs.length;t++){const r=e.data.inputs[t],o=e.txInputs[t];d.push({txid:n.from(o.hash).reverse().toString("hex"),vout:o.index,value:r.witnessUtxo?.value||0,scriptPubKey:r.witnessUtxo?.script||n.alloc(0)})}const p=function(e,t,r,i,a){const s=e.__CACHE.__TX,c=[],u=31&i,l=0!==(i&g);c.push(n.from([0])),c.push(n.from([i]));const h=n.allocUnsafe(4);h.writeUInt32LE(s.version),c.push(h);const d=n.allocUnsafe(4);if(d.writeUInt32LE(s.locktime),c.push(d),l||(c.push(w(s)),c.push(_(r)),c.push(S(r)),2!==u&&3!==u&&c.push(E(s))),0!==u&&1!==u||c.push(k(s)),c.push(n.from([2])),l){const e=r[t],o=s.ins[t],i=n.alloc(36);n.from(e.txid,"hex").reverse().copy(i,0),i.writeUInt32LE(e.vout,32),c.push(i);const a=n.allocUnsafe(8);a.writeBigUInt64LE(BigInt(e.value)),c.push(a);const u=e.scriptPubKey,l=n.from([u.length]);c.push(n.concat([l,u]));const f=n.allocUnsafe(4);f.writeUInt32LE(o.sequence),c.push(f)}else{const e=n.allocUnsafe(4);e.writeUInt32LE(t),c.push(e)}if(3===u&&t<s.outs.length){const e=s.outs[t],r=n.allocUnsafe(8);r.writeBigUInt64LE(BigInt(e.value));const o=n.from([e.script.length]),i=n.concat([r,o,e.script]);c.push(f(i))}c.push(a),c.push(n.from([0]));const p=n.allocUnsafe(4);p.writeUInt32LE(4294967295),c.push(p);const b=n.concat(c);return o.crypto.taggedHash("TapSighash",b)}(e,t,d,a,h);console.log(`      Sighash: ${n.from(p).toString("hex").substring(0,32)}...`);let b=n.from(r);3===s.pointFromScalar(b)[0]&&(b=s.privateNegate(b));const y=c.sign(new Uint8Array(p),new Uint8Array(b));let m;console.log(`      Signature: ${n.from(y).toString("hex").substring(0,32)}...`),m=0===a?n.from(y):n.concat([n.from(y),n.from([a])]),e.updateInput(t,{tapScriptSig:[{pubkey:i,signature:m,leafHash:n.from(h)}]}),console.log(`      ✅ Input ${t} signed with tapScriptSig (script-path)`)}async function v(e,t,r,i){console.log(`      🔨 Manual signing input ${t}`),console.log(`      📌 sighashType received: ${i} (type: ${typeof i})`),console.log(`      📌 sighashType hex: 0x${i?.toString(16)||"undefined"}`),console.log("      📌 SIGHASH_DEFAULT: 0, SIGHASH_ALL: 1");const a=[];for(let t=0;t<e.data.inputs.length;t++){const r=e.data.inputs[t],o=e.txInputs[t];a.push({txid:n.from(o.hash).reverse().toString("hex"),vout:o.index,value:r.witnessUtxo?.value||0,scriptPubKey:r.witnessUtxo?.script||n.alloc(0)})}const s=function(e,t,r,i){const a=e.__CACHE.__TX,s=[],c=31&i,u=0!==(i&g);s.push(n.from([0])),s.push(n.from([i]));const l=n.allocUnsafe(4);l.writeUInt32LE(a.version),s.push(l);const f=n.allocUnsafe(4);if(f.writeUInt32LE(a.locktime),s.push(f),u||s.push(w(a)),u||s.push(_(r)),u||s.push(S(r)),u||2===c||3===c||s.push(E(a)),2!==c&&3!==c&&s.push(k(e)),s.push(n.from([0])),u){const e=a.ins[t];s.push(n.from(e.hash));const o=n.allocUnsafe(4);o.writeUInt32LE(e.index),s.push(o);const i=n.allocUnsafe(8);i.writeBigUInt64LE(BigInt(r[t].value)),s.push(i);let c=r[t].scriptPubKey;"string"==typeof c?c=n.from(c,"hex"):c instanceof n||(c=n.from(c)),s.push(A(c.length)),s.push(c);const u=n.allocUnsafe(4);u.writeUInt32LE(e.sequence),s.push(u)}else{const e=n.allocUnsafe(4);e.writeUInt32LE(t),s.push(e)}3===c&&(t<e.txOutputs.length?s.push(function(e,t){const r=e.txOutputs[t],i=n.allocUnsafe(8);i.writeBigUInt64LE(BigInt(r.value));const a=A(r.script.length);return o.crypto.sha256(n.concat([i,a,r.script]))}(e,t)):s.push(n.alloc(32,0)));const h=n.concat(s),d=o.crypto.sha256(n.from("TapSighash","utf8")),p=n.concat([d,d,h]);return o.crypto.sha256(p)}(e,t,a,i);console.log(`      Sighash: ${s.toString("hex").substring(0,32)}...`);const u=c.sign(new Uint8Array(s),new Uint8Array(r));if(!u)throw new Error(`Failed to create Schnorr signature for input ${t}`);let l;console.log(`      Signature: ${n.from(u).toString("hex").substring(0,32)}...`),l=0===i?n.from(u):n.concat([n.from(u),n.from([i])]),e.updateInput(t,{tapKeySig:l}),console.log(`      ✅ Input ${t} signed manually`),console.log(`      📝 Final signature: ${l.length} bytes (last byte: 0x${l[l.length-1]?.toString(16)||"??"})`)}function w(e){const t=[];for(const r of e.ins){t.push(n.from(r.hash));const e=n.allocUnsafe(4);e.writeUInt32LE(r.index),t.push(e)}return o.crypto.sha256(n.concat(t))}function _(e){const t=[];for(const r of e){const e=n.allocUnsafe(8);e.writeBigUInt64LE(BigInt(r.value)),t.push(e)}return o.crypto.sha256(n.concat(t))}function S(e){const t=[];for(const r of e){let e=r.scriptPubKey;"string"==typeof e?e=n.from(e,"hex"):e instanceof n||(e=n.from(e)),t.push(A(e.length)),t.push(e)}return o.crypto.sha256(n.concat(t))}function E(e){const t=[];for(const r of e.ins){const e=n.allocUnsafe(4);e.writeUInt32LE(r.sequence),t.push(e)}return o.crypto.sha256(n.concat(t))}function k(e){const t=[];for(const r of e.txOutputs){const e=n.allocUnsafe(8);e.writeBigUInt64LE(BigInt(r.value)),t.push(e),t.push(A(r.script.length)),t.push(r.script)}return o.crypto.sha256(n.concat(t))}function A(e){if(e<253){const t=n.allocUnsafe(1);return t.writeUInt8(e),t}if(e<=65535){const t=n.allocUnsafe(3);return t.writeUInt8(253),t.writeUInt16LE(e,1),t}if(e<=4294967295){const t=n.allocUnsafe(5);return t.writeUInt8(254),t.writeUInt32LE(e,1),t}{const t=n.allocUnsafe(9);return t.writeUInt8(255),t.writeBigUInt64LE(BigInt(e),1),t}}function x(e){if(null==e)return 0;if("number"==typeof e)return e;const t=String(e).toUpperCase();return"DEFAULT"===t?0:"ALL"===t?1:"NONE"===t?2:"SINGLE"===t?3:"NONE|ANYONECANPAY"===t?130:"SINGLE|ANYONECANPAY"===t?131:"ALL|ANYONECANPAY"===t?129:t.startsWith("0X")?parseInt(t,16):0}function I(e){const t=0!==(e&g);let r="";switch(31&e){case 0:r="DEFAULT";break;case 1:r="ALL";break;case 2:r="NONE";break;case 3:r="SINGLE";break;default:r="UNKNOWN"}return t&&(r+="|ANYONECANPAY"),r}async function B(e){try{console.log("🔑 KrayChat: Deriving public key...");const t=await i.mnemonicToSeed(e),r=d.fromSeed(t,b),o="m/86'/0'/0'/0/0",a=r.derivePath(o),s=n.from(a.publicKey).toString("hex");return console.log("✅ KrayChat: Public key derived (66 chars)"),s}catch(e){throw console.error("❌ Error deriving chat public key:",e),e}}function T(e,t){try{let r;r="string"==typeof t?new Uint8Array(n.from(t,"hex")):new Uint8Array(t);const o=new Uint8Array(e),i=l(o,r).slice(1,33);return f(i)}catch(e){throw console.error("❌ ECDH shared secret derivation failed:",e),e}}async function H(e,t,r){try{console.log("🔐 KrayChat: Encrypting message...");const n=await i.mnemonicToSeed(t),o=T(d.fromSeed(n,b).derivePath("m/86'/0'/0'/0/0").privateKey,r),a=crypto.getRandomValues(new Uint8Array(12)),s=(new TextEncoder).encode(e),c=await crypto.subtle.importKey("raw",o,{name:"AES-GCM"},!1,["encrypt"]),u=await crypto.subtle.encrypt({name:"AES-GCM",iv:a},c,s),l=new Uint8Array(u),f=l.slice(0,-16),h=l.slice(-16),p=JSON.stringify({nonce:Array.from(a).map(e=>e.toString(16).padStart(2,"0")).join(""),ciphertext:Array.from(f).map(e=>e.toString(16).padStart(2,"0")).join(""),tag:Array.from(h).map(e=>e.toString(16).padStart(2,"0")).join("")});return console.log("✅ KrayChat: Message encrypted (mobile-compatible format)"),p}catch(e){throw console.error("❌ Error encrypting chat message:",e),e}}async function O(e,t,r){try{console.log("🔓 KrayChat: Decrypting message...");const n=await i.mnemonicToSeed(t),o=T(d.fromSeed(n,b).derivePath("m/86'/0'/0'/0/0").privateKey,r);let a,s,c;try{const t=JSON.parse(e);t.nonce&&t.ciphertext&&t.tag&&(a=new Uint8Array(t.nonce.match(/.{2}/g).map(e=>parseInt(e,16))),s=new Uint8Array(t.ciphertext.match(/.{2}/g).map(e=>parseInt(e,16))),c=new Uint8Array(t.tag.match(/.{2}/g).map(e=>parseInt(e,16))))}catch(t){const r=new Uint8Array(atob(e).split("").map(e=>e.charCodeAt(0)));a=r.slice(0,12);const n=r.slice(12);s=n.slice(0,-16),c=n.slice(-16)}const u=new Uint8Array(s.length+c.length);u.set(s),u.set(c,s.length);const l=await crypto.subtle.importKey("raw",o,{name:"AES-GCM"},!1,["decrypt"]),f=await crypto.subtle.decrypt({name:"AES-GCM",iv:a},l,u),h=(new TextDecoder).decode(f);return console.log("✅ KrayChat: Message decrypted"),h}catch(e){throw console.error("❌ Error decrypting chat message:",e),e}}async function P(e){try{console.log("🔐 KrayChat: Deriving private key (mnemonic will be discarded)...");const t=await i.mnemonicToSeed(e),r=d.fromSeed(t,b),o="m/86'/0'/0'/0/0",a=r.derivePath(o),s=new Uint8Array(a.privateKey),c=n.from(a.publicKey).toString("hex");return console.log("✅ KrayChat: Private key derived"),console.log("   🔐 Mnemonic should now be discarded by caller!"),{privateKey:s,publicKey:c}}catch(e){throw console.error("❌ Error deriving chat private key:",e),e}}async function L(e,t,r){try{console.log("🔐 KrayChat: Encrypting with session key...");const n=T(t,r),o=crypto.getRandomValues(new Uint8Array(12)),i=(new TextEncoder).encode(e),a=await crypto.subtle.importKey("raw",n,{name:"AES-GCM"},!1,["encrypt"]),s=await crypto.subtle.encrypt({name:"AES-GCM",iv:o},a,i),c=new Uint8Array(s),u=c.slice(0,-16),l=c.slice(-16),f=JSON.stringify({nonce:Array.from(o).map(e=>e.toString(16).padStart(2,"0")).join(""),ciphertext:Array.from(u).map(e=>e.toString(16).padStart(2,"0")).join(""),tag:Array.from(l).map(e=>e.toString(16).padStart(2,"0")).join("")});return console.log("✅ KrayChat: Encrypted with session key (mobile-compatible)"),f}catch(e){throw console.error("❌ Error encrypting with private key:",e),e}}async function U(e,t,r){try{console.log("🔓 KrayChat: Decrypting with session key...");const n=T(t,r);let o,i,a;try{const t=JSON.parse(e);t.nonce&&t.ciphertext&&t.tag&&(o=new Uint8Array(t.nonce.match(/.{2}/g).map(e=>parseInt(e,16))),i=new Uint8Array(t.ciphertext.match(/.{2}/g).map(e=>parseInt(e,16))),a=new Uint8Array(t.tag.match(/.{2}/g).map(e=>parseInt(e,16))))}catch(t){const r=new Uint8Array(atob(e).split("").map(e=>e.charCodeAt(0)));o=r.slice(0,12);const n=r.slice(12);i=n.slice(0,-16),a=n.slice(-16)}const s=new Uint8Array(i.length+a.length);s.set(i),s.set(a,i.length);const c=await crypto.subtle.importKey("raw",n,{name:"AES-GCM"},!1,["decrypt"]),u=await crypto.subtle.decrypt({name:"AES-GCM",iv:o},c,s),l=(new TextDecoder).decode(u);return console.log("✅ KrayChat: Decrypted with session key"),l}catch(e){throw console.error("❌ Error decrypting with private key:",e),e}}async function j(e,t){try{console.log("🔐 [LOCAL SIGNER] Signing message locally..."),console.log("   Message:",e.substring(0,50)+"...");const r=await i.mnemonicToSeed(t),a=d.fromSeed(r,b).derivePath("m/86'/0'/0'/0/0");if(!a.privateKey)throw new Error("Failed to derive private key");const s=a.publicKey.slice(1,33),{address:u}=o.payments.p2tr({internalPubkey:s,network:b}),l=(new TextEncoder).encode(e),h=f(l),p=c.sign(new Uint8Array(h),new Uint8Array(a.privateKey)),g=n.from(p).toString("hex"),y=n.from(s).toString("hex");return console.log("✅ [LOCAL SIGNER] Message signed successfully"),console.log("   Signature length:",g.length,"chars (",g.length/2,"bytes)"),console.log("   Pubkey:",y.substring(0,16)+"..."),console.log("   Address:",u),t=null,{success:!0,signature:g,pubkey:y,address:u}}catch(e){throw console.error("❌ [LOCAL SIGNER] Error signing message:",e),new Error(`Message signing failed: ${e.message}`)}}e.exports={signPsbtTaprootLocal:y,signMessageLocal:j,SIGHASH_DEFAULT:0,SIGHASH_ALL:1,SIGHASH_NONE:2,SIGHASH_SINGLE:3,SIGHASH_ANYONECANPAY:g,getChatPublicKey:B,encryptChatMessage:H,decryptChatMessage:O,deriveSharedSecret:T,deriveChatPrivateKey:P,encryptWithPrivateKey:L,decryptWithPrivateKey:U},"undefined"!=typeof window&&(window.TaprootSigner={signPsbtTaprootLocal:y,signMessageLocal:j,SIGHASH_DEFAULT:0,SIGHASH_ALL:1,SIGHASH_NONE:2,SIGHASH_SINGLE:3,SIGHASH_ANYONECANPAY:g,getChatPublicKey:B,encryptChatMessage:H,decryptChatMessage:O,deriveSharedSecret:T,deriveChatPrivateKey:P,encryptWithPrivateKey:L,decryptWithPrivateKey:U}),"undefined"!=typeof self&&"undefined"==typeof window&&(self.TaprootSigner={signPsbtTaprootLocal:y,signMessageLocal:j,SIGHASH_DEFAULT:0,SIGHASH_ALL:1,SIGHASH_NONE:2,SIGHASH_SINGLE:3,SIGHASH_ANYONECANPAY:g,getChatPublicKey:B,encryptChatMessage:H,decryptChatMessage:O,deriveSharedSecret:T,deriveChatPrivateKey:P,encryptWithPrivateKey:L,decryptWithPrivateKey:U})},2361:()=>{},4616:()=>{},9862:()=>{},964:()=>{},3083:(e,t,r)=>{"use strict";var n=r(9908),o="undefined"==typeof globalThis?r.g:globalThis;e.exports=function(){for(var e=[],t=0;t<n.length;t++)"function"==typeof o[n[t]]&&(e[e.length]=n[t]);return e}},555:(e,t,r)=>{"use strict";r.r(t),r.d(t,{_HMAC:()=>o,hmac:()=>i});var n=r(8497);class o{oHash;iHash;blockLen;outputLen;finished=!1;destroyed=!1;constructor(e,t){if((0,n.z3)(e),(0,n.gk)(t,void 0,"key"),this.iHash=e.create(),"function"!=typeof this.iHash.update)throw new Error("Expected instance of class which extends utils.Hash");this.blockLen=this.iHash.blockLen,this.outputLen=this.iHash.outputLen;const r=this.blockLen,o=new Uint8Array(r);o.set(t.length>r?e.create().update(t).digest():t);for(let e=0;e<o.length;e++)o[e]^=54;this.iHash.update(o),this.oHash=e.create();for(let e=0;e<o.length;e++)o[e]^=106;this.oHash.update(o),(0,n.ru)(o)}update(e){return(0,n.$h)(this),this.iHash.update(e),this}digestInto(e){(0,n.$h)(this),(0,n.gk)(e,this.outputLen,"output"),this.finished=!0,this.iHash.digestInto(e),this.oHash.update(e),this.oHash.digestInto(e),this.destroy()}digest(){const e=new Uint8Array(this.oHash.outputLen);return this.digestInto(e),e}_cloneInto(e){e||=Object.create(Object.getPrototypeOf(this),{});const{oHash:t,iHash:r,finished:n,destroyed:o,blockLen:i,outputLen:a}=this;return e.finished=n,e.destroyed=o,e.blockLen=i,e.outputLen=a,e.oHash=t._cloneInto(e.oHash),e.iHash=r._cloneInto(e.iHash),e}clone(){return this._cloneInto()}destroy(){this.destroyed=!0,this.oHash.destroy(),this.iHash.destroy()}}const i=(e,t,r)=>new o(e,t).update(r).digest();i.create=(e,t)=>new o(e,t)},8039:(e,t,r)=>{"use strict";r.r(t),r.d(t,{_SHA224:()=>O,_SHA256:()=>H,_SHA384:()=>N,_SHA512:()=>z,_SHA512_224:()=>D,_SHA512_256:()=>F,sha224:()=>K,sha256:()=>q,sha384:()=>W,sha512:()=>G,sha512_224:()=>X,sha512_256:()=>$});var n=r(8497);function o(e,t,r){return e&t^~e&r}function i(e,t,r){return e&t^e&r^t&r}class a{blockLen;outputLen;padOffset;isLE;buffer;view;finished=!1;length=0;pos=0;destroyed=!1;constructor(e,t,r,o){this.blockLen=e,this.outputLen=t,this.padOffset=r,this.isLE=o,this.buffer=new Uint8Array(e),this.view=(0,n.GL)(this.buffer)}update(e){(0,n.$h)(this),(0,n.gk)(e);const{view:t,buffer:r,blockLen:o}=this,i=e.length;for(let a=0;a<i;){const s=Math.min(o-this.pos,i-a);if(s===o){const t=(0,n.GL)(e);for(;o<=i-a;a+=o)this.process(t,a);continue}r.set(e.subarray(a,a+s),this.pos),this.pos+=s,a+=s,this.pos===o&&(this.process(t,0),this.pos=0)}return this.length+=e.length,this.roundClean(),this}digestInto(e){(0,n.$h)(this),(0,n.eB)(e,this),this.finished=!0;const{buffer:t,view:r,blockLen:o,isLE:i}=this;let{pos:a}=this;t[a++]=128,(0,n.ru)(this.buffer.subarray(a)),this.padOffset>o-a&&(this.process(r,0),a=0);for(let e=a;e<o;e++)t[e]=0;r.setBigUint64(o-8,BigInt(8*this.length),i),this.process(r,0);const s=(0,n.GL)(e),c=this.outputLen;if(c%4)throw new Error("_sha2: outputLen must be aligned to 32bit");const u=c/4,l=this.get();if(u>l.length)throw new Error("_sha2: outputLen bigger than state");for(let e=0;e<u;e++)s.setUint32(4*e,l[e],i)}digest(){const{buffer:e,outputLen:t}=this;this.digestInto(e);const r=e.slice(0,t);return this.destroy(),r}_cloneInto(e){e||=new this.constructor,e.set(...this.get());const{blockLen:t,buffer:r,length:n,finished:o,destroyed:i,pos:a}=this;return e.destroyed=i,e.finished=o,e.length=n,e.pos=a,n%t&&e.buffer.set(r),e}clone(){return this._cloneInto()}}const s=Uint32Array.from([1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225]),c=Uint32Array.from([3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428]),u=Uint32Array.from([3418070365,3238371032,1654270250,914150663,2438529370,812702999,355462360,4144912697,1731405415,4290775857,2394180231,1750603025,3675008525,1694076839,1203062813,3204075428]),l=Uint32Array.from([1779033703,4089235720,3144134277,2227873595,1013904242,4271175723,2773480762,1595750129,1359893119,2917565137,2600822924,725511199,528734635,4215389547,1541459225,327033209]),f=BigInt(2**32-1),h=BigInt(32);function d(e,t=!1){return t?{h:Number(e&f),l:Number(e>>h&f)}:{h:0|Number(e>>h&f),l:0|Number(e&f)}}const p=(e,t,r)=>e>>>r,b=(e,t,r)=>e<<32-r|t>>>r,g=(e,t,r)=>e>>>r|t<<32-r,y=(e,t,r)=>e<<32-r|t>>>r,m=(e,t,r)=>e<<64-r|t>>>r-32,v=(e,t,r)=>e>>>r-32|t<<64-r;function w(e,t,r,n){const o=(t>>>0)+(n>>>0);return{h:e+r+(o/2**32|0)|0,l:0|o}}const _=(e,t,r)=>(e>>>0)+(t>>>0)+(r>>>0),S=(e,t,r,n)=>t+r+n+(e/2**32|0)|0,E=(e,t,r,n)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0),k=(e,t,r,n,o)=>t+r+n+o+(e/2**32|0)|0,A=(e,t,r,n,o)=>(e>>>0)+(t>>>0)+(r>>>0)+(n>>>0)+(o>>>0),x=(e,t,r,n,o,i)=>t+r+n+o+i+(e/2**32|0)|0,I=Uint32Array.from([1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298]),B=new Uint32Array(64);class T extends a{constructor(e){super(64,e,8,!1)}get(){const{A:e,B:t,C:r,D:n,E:o,F:i,G:a,H:s}=this;return[e,t,r,n,o,i,a,s]}set(e,t,r,n,o,i,a,s){this.A=0|e,this.B=0|t,this.C=0|r,this.D=0|n,this.E=0|o,this.F=0|i,this.G=0|a,this.H=0|s}process(e,t){for(let r=0;r<16;r++,t+=4)B[r]=e.getUint32(t,!1);for(let e=16;e<64;e++){const t=B[e-15],r=B[e-2],o=(0,n.np)(t,7)^(0,n.np)(t,18)^t>>>3,i=(0,n.np)(r,17)^(0,n.np)(r,19)^r>>>10;B[e]=i+B[e-7]+o+B[e-16]|0}let{A:r,B:a,C:s,D:c,E:u,F:l,G:f,H:h}=this;for(let e=0;e<64;e++){const t=h+((0,n.np)(u,6)^(0,n.np)(u,11)^(0,n.np)(u,25))+o(u,l,f)+I[e]+B[e]|0,d=((0,n.np)(r,2)^(0,n.np)(r,13)^(0,n.np)(r,22))+i(r,a,s)|0;h=f,f=l,l=u,u=c+t|0,c=s,s=a,a=r,r=t+d|0}r=r+this.A|0,a=a+this.B|0,s=s+this.C|0,c=c+this.D|0,u=u+this.E|0,l=l+this.F|0,f=f+this.G|0,h=h+this.H|0,this.set(r,a,s,c,u,l,f,h)}roundClean(){(0,n.ru)(B)}destroy(){this.set(0,0,0,0,0,0,0,0),(0,n.ru)(this.buffer)}}class H extends T{A=0|s[0];B=0|s[1];C=0|s[2];D=0|s[3];E=0|s[4];F=0|s[5];G=0|s[6];H=0|s[7];constructor(){super(32)}}class O extends T{A=0|c[0];B=0|c[1];C=0|c[2];D=0|c[3];E=0|c[4];F=0|c[5];G=0|c[6];H=0|c[7];constructor(){super(28)}}const P=(()=>function(e,t=!1){const r=e.length;let n=new Uint32Array(r),o=new Uint32Array(r);for(let i=0;i<r;i++){const{h:r,l:a}=d(e[i],t);[n[i],o[i]]=[r,a]}return[n,o]}(["0x428a2f98d728ae22","0x7137449123ef65cd","0xb5c0fbcfec4d3b2f","0xe9b5dba58189dbbc","0x3956c25bf348b538","0x59f111f1b605d019","0x923f82a4af194f9b","0xab1c5ed5da6d8118","0xd807aa98a3030242","0x12835b0145706fbe","0x243185be4ee4b28c","0x550c7dc3d5ffb4e2","0x72be5d74f27b896f","0x80deb1fe3b1696b1","0x9bdc06a725c71235","0xc19bf174cf692694","0xe49b69c19ef14ad2","0xefbe4786384f25e3","0x0fc19dc68b8cd5b5","0x240ca1cc77ac9c65","0x2de92c6f592b0275","0x4a7484aa6ea6e483","0x5cb0a9dcbd41fbd4","0x76f988da831153b5","0x983e5152ee66dfab","0xa831c66d2db43210","0xb00327c898fb213f","0xbf597fc7beef0ee4","0xc6e00bf33da88fc2","0xd5a79147930aa725","0x06ca6351e003826f","0x142929670a0e6e70","0x27b70a8546d22ffc","0x2e1b21385c26c926","0x4d2c6dfc5ac42aed","0x53380d139d95b3df","0x650a73548baf63de","0x766a0abb3c77b2a8","0x81c2c92e47edaee6","0x92722c851482353b","0xa2bfe8a14cf10364","0xa81a664bbc423001","0xc24b8b70d0f89791","0xc76c51a30654be30","0xd192e819d6ef5218","0xd69906245565a910","0xf40e35855771202a","0x106aa07032bbd1b8","0x19a4c116b8d2d0c8","0x1e376c085141ab53","0x2748774cdf8eeb99","0x34b0bcb5e19b48a8","0x391c0cb3c5c95a63","0x4ed8aa4ae3418acb","0x5b9cca4f7763e373","0x682e6ff3d6b2b8a3","0x748f82ee5defb2fc","0x78a5636f43172f60","0x84c87814a1f0ab72","0x8cc702081a6439ec","0x90befffa23631e28","0xa4506cebde82bde9","0xbef9a3f7b2c67915","0xc67178f2e372532b","0xca273eceea26619c","0xd186b8c721c0c207","0xeada7dd6cde0eb1e","0xf57d4f7fee6ed178","0x06f067aa72176fba","0x0a637dc5a2c898a6","0x113f9804bef90dae","0x1b710b35131c471b","0x28db77f523047d84","0x32caab7b40c72493","0x3c9ebe0a15c9bebc","0x431d67c49c100d4c","0x4cc5d4becb3e42b6","0x597f299cfc657e2a","0x5fcb6fab3ad6faec","0x6c44198c4a475817"].map(e=>BigInt(e))))(),L=(()=>P[0])(),U=(()=>P[1])(),j=new Uint32Array(80),C=new Uint32Array(80);class R extends a{constructor(e){super(128,e,16,!1)}get(){const{Ah:e,Al:t,Bh:r,Bl:n,Ch:o,Cl:i,Dh:a,Dl:s,Eh:c,El:u,Fh:l,Fl:f,Gh:h,Gl:d,Hh:p,Hl:b}=this;return[e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b]}set(e,t,r,n,o,i,a,s,c,u,l,f,h,d,p,b){this.Ah=0|e,this.Al=0|t,this.Bh=0|r,this.Bl=0|n,this.Ch=0|o,this.Cl=0|i,this.Dh=0|a,this.Dl=0|s,this.Eh=0|c,this.El=0|u,this.Fh=0|l,this.Fl=0|f,this.Gh=0|h,this.Gl=0|d,this.Hh=0|p,this.Hl=0|b}process(e,t){for(let r=0;r<16;r++,t+=4)j[r]=e.getUint32(t),C[r]=e.getUint32(t+=4);for(let e=16;e<80;e++){const t=0|j[e-15],r=0|C[e-15],n=g(t,r,1)^g(t,r,8)^p(t,0,7),o=y(t,r,1)^y(t,r,8)^b(t,r,7),i=0|j[e-2],a=0|C[e-2],s=g(i,a,19)^m(i,a,61)^p(i,0,6),c=y(i,a,19)^v(i,a,61)^b(i,a,6),u=E(o,c,C[e-7],C[e-16]),l=k(u,n,s,j[e-7],j[e-16]);j[e]=0|l,C[e]=0|u}let{Ah:r,Al:n,Bh:o,Bl:i,Ch:a,Cl:s,Dh:c,Dl:u,Eh:l,El:f,Fh:h,Fl:d,Gh:I,Gl:B,Hh:T,Hl:H}=this;for(let e=0;e<80;e++){const t=g(l,f,14)^g(l,f,18)^m(l,f,41),p=y(l,f,14)^y(l,f,18)^v(l,f,41),b=l&h^~l&I,E=A(H,p,f&d^~f&B,U[e],C[e]),k=x(E,T,t,b,L[e],j[e]),O=0|E,P=g(r,n,28)^m(r,n,34)^m(r,n,39),R=y(r,n,28)^v(r,n,34)^v(r,n,39),z=r&o^r&a^o&a,N=n&i^n&s^i&s;T=0|I,H=0|B,I=0|h,B=0|d,h=0|l,d=0|f,({h:l,l:f}=w(0|c,0|u,0|k,0|O)),c=0|a,u=0|s,a=0|o,s=0|i,o=0|r,i=0|n;const M=_(O,R,N);r=S(M,k,P,z),n=0|M}({h:r,l:n}=w(0|this.Ah,0|this.Al,0|r,0|n)),({h:o,l:i}=w(0|this.Bh,0|this.Bl,0|o,0|i)),({h:a,l:s}=w(0|this.Ch,0|this.Cl,0|a,0|s)),({h:c,l:u}=w(0|this.Dh,0|this.Dl,0|c,0|u)),({h:l,l:f}=w(0|this.Eh,0|this.El,0|l,0|f)),({h,l:d}=w(0|this.Fh,0|this.Fl,0|h,0|d)),({h:I,l:B}=w(0|this.Gh,0|this.Gl,0|I,0|B)),({h:T,l:H}=w(0|this.Hh,0|this.Hl,0|T,0|H)),this.set(r,n,o,i,a,s,c,u,l,f,h,d,I,B,T,H)}roundClean(){(0,n.ru)(j,C)}destroy(){(0,n.ru)(this.buffer),this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)}}class z extends R{Ah=0|l[0];Al=0|l[1];Bh=0|l[2];Bl=0|l[3];Ch=0|l[4];Cl=0|l[5];Dh=0|l[6];Dl=0|l[7];Eh=0|l[8];El=0|l[9];Fh=0|l[10];Fl=0|l[11];Gh=0|l[12];Gl=0|l[13];Hh=0|l[14];Hl=0|l[15];constructor(){super(64)}}class N extends R{Ah=0|u[0];Al=0|u[1];Bh=0|u[2];Bl=0|u[3];Ch=0|u[4];Cl=0|u[5];Dh=0|u[6];Dl=0|u[7];Eh=0|u[8];El=0|u[9];Fh=0|u[10];Fl=0|u[11];Gh=0|u[12];Gl=0|u[13];Hh=0|u[14];Hl=0|u[15];constructor(){super(48)}}const M=Uint32Array.from([2352822216,424955298,1944164710,2312950998,502970286,855612546,1738396948,1479516111,258812777,2077511080,2011393907,79989058,1067287976,1780299464,286451373,2446758561]),V=Uint32Array.from([573645204,4230739756,2673172387,3360449730,596883563,1867755857,2520282905,1497426621,2519219938,2827943907,3193839141,1401305490,721525244,746961066,246885852,2177182882]);class D extends R{Ah=0|M[0];Al=0|M[1];Bh=0|M[2];Bl=0|M[3];Ch=0|M[4];Cl=0|M[5];Dh=0|M[6];Dl=0|M[7];Eh=0|M[8];El=0|M[9];Fh=0|M[10];Fl=0|M[11];Gh=0|M[12];Gl=0|M[13];Hh=0|M[14];Hl=0|M[15];constructor(){super(28)}}class F extends R{Ah=0|V[0];Al=0|V[1];Bh=0|V[2];Bl=0|V[3];Ch=0|V[4];Cl=0|V[5];Dh=0|V[6];Dl=0|V[7];Eh=0|V[8];El=0|V[9];Fh=0|V[10];Fl=0|V[11];Gh=0|V[12];Gl=0|V[13];Hh=0|V[14];Hl=0|V[15];constructor(){super(32)}}const q=(0,n.V1)(()=>new H,(0,n.dO)(1)),K=(0,n.V1)(()=>new O,(0,n.dO)(4)),G=(0,n.V1)(()=>new z,(0,n.dO)(3)),W=(0,n.V1)(()=>new N,(0,n.dO)(2)),$=(0,n.V1)(()=>new F,(0,n.dO)(6)),X=(0,n.V1)(()=>new D,(0,n.dO)(5))},8497:(e,t,r)=>{"use strict";function n(e,t=""){if(!Number.isSafeInteger(e)||e<0)throw new Error(`${t&&`"${t}" `}expected integer >= 0, got ${e}`)}function o(e,t,r=""){const n=(o=e)instanceof Uint8Array||ArrayBuffer.isView(o)&&"Uint8Array"===o.constructor.name;var o;const i=e?.length,a=void 0!==t;if(!n||a&&i!==t)throw new Error((r&&`"${r}" `)+"expected Uint8Array"+(a?` of length ${t}`:"")+", got "+(n?`length=${i}`:"type="+typeof e));return e}function i(e){if("function"!=typeof e||"function"!=typeof e.create)throw new Error("Hash must wrapped by utils.createHasher");n(e.outputLen),n(e.blockLen)}function a(e,t=!0){if(e.destroyed)throw new Error("Hash instance has been destroyed");if(t&&e.finished)throw new Error("Hash#digest() has already been called")}function s(e,t){o(e,void 0,"digestInto() output");const r=t.outputLen;if(e.length<r)throw new Error('"digestInto() output" expected to be of length >='+r)}function c(...e){for(let t=0;t<e.length;t++)e[t].fill(0)}function u(e){return new DataView(e.buffer,e.byteOffset,e.byteLength)}function l(e,t){return e<<32-t|e>>>t}function f(e,t={}){const r=(t,r)=>e(r).update(t).digest(),n=e(void 0);return r.outputLen=n.outputLen,r.blockLen=n.blockLen,r.create=t=>e(t),Object.assign(r,t),Object.freeze(r)}r.d(t,{$h:()=>a,GL:()=>u,V1:()=>f,dO:()=>h,eB:()=>s,gk:()=>o,np:()=>l,ru:()=>c,z3:()=>i});const h=e=>({oid:Uint8Array.from([6,9,96,134,72,1,101,3,4,2,e])})},335:(e,t,r)=>{"use strict";r.r(t),r.d(t,{Point:()=>N,Signature:()=>J,etc:()=>Te,getPublicKey:()=>X,getSharedSecret:()=>Ae,hash:()=>T,hashes:()=>se,keygen:()=>Be,recoverPublicKey:()=>Ee,recoverPublicKeyAsync:()=>ke,schnorr:()=>Xe,sign:()=>me,signAsync:()=>ve,utils:()=>He,verify:()=>we,verifyAsync:()=>_e});const n={p:0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffefffffc2fn,n:0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141n,h:1n,a:0n,b:7n,Gx:0x79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798n,Gy:0x483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8n},{p:o,n:i,Gx:a,Gy:s,b:c}=n,u=32,l=64,f={publicKey:33,publicKeyUncompressed:65,signature:l,seed:48},h=(e="")=>{const t=new Error(e);throw((...e)=>{"captureStackTrace"in Error&&"function"==typeof Error.captureStackTrace&&Error.captureStackTrace(...e)})(t,h),t},d=(e,t,r="")=>{const n=(o=e)instanceof Uint8Array||ArrayBuffer.isView(o)&&"Uint8Array"===o.constructor.name;var o;const i=e?.length,a=void 0!==t;return(!n||a&&i!==t)&&h((r&&`"${r}" `)+"expected Uint8Array"+(a?` of length ${t}`:"")+", got "+(n?`length=${i}`:"type="+typeof e)),e},p=e=>new Uint8Array(e),b=(e,t)=>e.toString(16).padStart(t,"0"),g=e=>Array.from(d(e)).map(e=>b(e,2)).join(""),y=e=>e>=48&&e<=57?e-48:e>=65&&e<=70?e-55:e>=97&&e<=102?e-87:void 0,m=e=>{const t="hex invalid";if("string"!=typeof e)return h(t);const r=e.length,n=r/2;if(r%2)return h(t);const o=p(n);for(let r=0,i=0;r<n;r++,i+=2){const n=y(e.charCodeAt(i)),a=y(e.charCodeAt(i+1));if(void 0===n||void 0===a)return h(t);o[r]=16*n+a}return o},v=()=>globalThis?.crypto,w=()=>v()?.subtle??h("crypto.subtle must be defined, consider polyfill"),_=(...e)=>{const t=p(e.reduce((e,t)=>e+d(t).length,0));let r=0;return e.forEach(e=>{t.set(e,r),r+=e.length}),t},S=(e=u)=>v().getRandomValues(p(e)),E=BigInt,k=(e,t,r,n="bad number: out of range")=>(e=>"bigint"==typeof e)(e)&&t<=e&&e<r?e:h(n),A=(e,t=o)=>{const r=e%t;return r>=0n?r:t+r},x=e=>A(e,i),I=(e,t)=>{(0n===e||t<=0n)&&h("no inverse n="+e+" mod="+t);let r=A(e,t),n=t,o=0n,i=1n,a=1n,s=0n;for(;0n!==r;){const e=n/r,t=n%r,c=o-a*e,u=i-s*e;n=r,r=t,o=a,i=s,a=c,s=u}return 1n===n?A(o,t):h("no inverse")},B=e=>{const t=se[e];return"function"!=typeof t&&h("hashes."+e+" not set"),t},T=e=>B("sha256")(e),H=e=>e instanceof N?e:h("Point expected"),O=e=>A(A(e*e)*e+c),P=e=>k(e,0n,o),L=e=>k(e,1n,o),U=e=>k(e,1n,i),j=e=>0n==(1n&e),C=e=>Uint8Array.of(e),R=e=>C(j(e)?2:3),z=e=>{const t=O(L(e));let r=1n;for(let e=t,n=(o+1n)/4n;n>0n;n>>=1n)1n&n&&(r=r*e%o),e=e*e%o;return A(r*r)===t?r:h("sqrt invalid")};class N{static BASE;static ZERO;X;Y;Z;constructor(e,t,r){this.X=P(e),this.Y=L(t),this.Z=P(r),Object.freeze(this)}static CURVE(){return n}static fromAffine(e){const{x:t,y:r}=e;return 0n===t&&0n===r?V:new N(t,r,1n)}static fromBytes(e){d(e);const{publicKey:t,publicKeyUncompressed:r}=f;let n;const o=e.length,i=e[0],a=e.subarray(1),s=q(a,0,u);if(o===t&&(2===i||3===i)){let e=z(s);const t=j(e);j(E(i))!==t&&(e=A(-e)),n=new N(s,e,1n)}return o===r&&4===i&&(n=new N(s,q(a,u,l),1n)),n?n.assertValidity():h("bad point: not on curve")}static fromHex(e){return N.fromBytes(m(e))}get x(){return this.toAffine().x}get y(){return this.toAffine().y}equals(e){const{X:t,Y:r,Z:n}=this,{X:o,Y:i,Z:a}=H(e),s=A(t*a),c=A(o*n),u=A(r*a),l=A(i*n);return s===c&&u===l}is0(){return this.equals(V)}negate(){return new N(this.X,A(-this.Y),this.Z)}double(){return this.add(this)}add(e){const{X:t,Y:r,Z:n}=this,{X:o,Y:i,Z:a}=H(e);let s=0n,u=0n,l=0n;const f=A(3n*c);let h=A(t*o),d=A(r*i),p=A(n*a),b=A(t+r),g=A(o+i);b=A(b*g),g=A(h+d),b=A(b-g),g=A(t+n);let y=A(o+a);return g=A(g*y),y=A(h+p),g=A(g-y),y=A(r+n),s=A(i+a),y=A(y*s),s=A(d+p),y=A(y-s),l=A(0n*g),s=A(f*p),l=A(s+l),s=A(d-l),l=A(d+l),u=A(s*l),d=A(h+h),d=A(d+h),p=A(0n*p),g=A(f*g),d=A(d+p),p=A(h-p),p=A(0n*p),g=A(g+p),h=A(d*g),u=A(u+h),h=A(y*g),s=A(b*s),s=A(s-h),h=A(b*d),l=A(y*l),l=A(l+h),new N(s,u,l)}subtract(e){return this.add(H(e).negate())}multiply(e,t=!0){if(!t&&0n===e)return V;if(U(e),1n===e)return this;if(this.equals(M))return Qe(e).p;let r=V,n=M;for(let o=this;e>0n;o=o.double(),e>>=1n)1n&e?r=r.add(o):t&&(n=n.add(o));return r}multiplyUnsafe(e){return this.multiply(e,!1)}toAffine(){const{X:e,Y:t,Z:r}=this;if(this.equals(V))return{x:0n,y:0n};if(1n===r)return{x:e,y:t};const n=I(r,o);return 1n!==A(r*n)&&h("inverse invalid"),{x:A(e*n),y:A(t*n)}}assertValidity(){const{x:e,y:t}=this.toAffine();return L(e),L(t),A(t*t)===O(e)?this:h("bad point: not on curve")}toBytes(e=!0){const{x:t,y:r}=this.assertValidity().toAffine(),n=G(t);return e?_(R(r),n):_(C(4),n,G(r))}toHex(e){return g(this.toBytes(e))}}const M=new N(a,s,1n),V=new N(0n,1n,0n);N.BASE=M,N.ZERO=V;const D=(e,t,r)=>M.multiply(t,!1).add(e.multiply(r,!1)).assertValidity(),F=e=>E("0x"+(g(e)||"0")),q=(e,t,r)=>F(e.subarray(t,r)),K=2n**256n,G=e=>m(b(k(e,0n,K),l)),W=e=>{const t=F(d(e,u,"secret key"));return k(t,1n,i,"invalid secret key: outside of range")},$=e=>e>i>>1n,X=(e,t=!0)=>M.multiply(W(e)).toBytes(t),Y=e=>{[0,1,2,3].includes(e)||h("recovery id must be valid and present")},Z=(e,t=te)=>{(e=>{null==e||oe.includes(e)||h(`Signature format must be one of: ${oe.join(", ")}`),e===ne&&h('Signature format "der" is not supported: switch to noble-curves')})(t);const r=f.signature,n=r+1;let o=`Signature format "${t}" expects Uint8Array with length `;t===te&&e.length!==r&&h(o+r),t===re&&e.length!==n&&h(o+n)};class J{r;s;recovery;constructor(e,t,r){this.r=U(e),this.s=U(t),null!=r&&(this.recovery=r),Object.freeze(this)}static fromBytes(e,t=te){let r;Z(e,t),t===re&&(r=e[0],e=e.subarray(1));const n=q(e,0,u),o=q(e,u,l);return new J(n,o,r)}addRecoveryBit(e){return new J(this.r,this.s,e)}hasHighS(){return $(this.s)}toBytes(e=te){const{r:t,s:r,recovery:n}=this,o=_(G(t),G(r));return e===re?(Y(n),_(Uint8Array.of(n),o)):o}}const Q=e=>{const t=8*e.length-256;t>1024&&h("msg invalid");const r=F(e);return t>0?r>>E(t):r},ee=e=>x(Q(d(e))),te="compact",re="recovered",ne="der",oe=[te,re,ne],ie={lowS:!0,prehash:!0,format:te,extraEntropy:!1},ae="SHA-256",se={hmacSha256Async:async(e,t)=>{const r=w(),n="HMAC",o=await r.importKey("raw",e,{name:n,hash:{name:ae}},!1,["sign"]);return p(await r.sign(n,o,t))},hmacSha256:void 0,sha256Async:async e=>p(await w().digest(ae,e)),sha256:void 0},ce=(e,t,r)=>(d(e,void 0,"message"),t.prehash?r?se.sha256Async(e):B("sha256")(e):e),ue=p(0),le=C(0),fe=C(1),he="drbg: tried max amount of iterations",de=(e,t)=>{let r=p(u),n=p(u),o=0;const i=()=>{r.fill(1),n.fill(0)},a=(...e)=>B("hmacSha256")(n,_(r,...e)),s=(e=ue)=>{n=a(le,e),r=a(),0!==e.length&&(n=a(fe,e),r=a())},c=()=>(o++>=1e3&&h(he),r=a(),r);let l;for(i(),s(e);!(l=t(c()));)s();return i(),l},pe=async(e,t)=>{let r=p(u),n=p(u),o=0;const i=()=>{r.fill(1),n.fill(0)},a=(...e)=>se.hmacSha256Async(n,_(r,...e)),s=async(e=ue)=>{n=await a(le,e),r=await a(),0!==e.length&&(n=await a(fe,e),r=await a())},c=async()=>(o++>=1e3&&h(he),r=await a(),r);let l;for(i(),await s(e);!(l=t(await c()));)await s();return i(),l},be=(e,t,r,n)=>{let{lowS:o,extraEntropy:a}=r;const s=G,c=ee(e),l=s(c),f=W(t),h=[s(f),l];if(null!=a&&!1!==a){const e=!0===a?S(u):a;h.push(d(e,void 0,"extraEntropy"))}const p=_(...h),b=c;return n(p,e=>{const t=Q(e);if(!(1n<=t&&t<i))return;const n=I(t,i),a=M.multiply(t).toAffine(),s=x(a.x);if(0n===s)return;const c=x(n*x(b+s*f));if(0n===c)return;let u=(a.x===s?0:2)|Number(1n&a.y),l=c;return o&&$(c)&&(l=x(-c),u^=1),new J(s,l,u).toBytes(r.format)})},ge=(e,t,r,n={})=>{const{lowS:o,format:a}=n;e instanceof J&&h("Signature must be in Uint8Array, use .toBytes()"),Z(e,a),d(r,void 0,"publicKey");try{const{r:n,s}=J.fromBytes(e,a),c=ee(t),u=N.fromBytes(r);if(o&&$(s))return!1;const l=I(s,i),f=x(c*l),h=x(n*l),d=D(u,f,h).toAffine();return x(d.x)===n}catch(e){return!1}},ye=e=>{const t={};return Object.keys(ie).forEach(r=>{t[r]=e[r]??ie[r]}),t},me=(e,t,r={})=>(r=ye(r),e=ce(e,r,!1),be(e,t,r,de)),ve=async(e,t,r={})=>(r=ye(r),e=await ce(e,r,!0),be(e,t,r,pe)),we=(e,t,r,n={})=>(n=ye(n),t=ce(t,n,!1),ge(e,t,r,n)),_e=async(e,t,r,n={})=>(n=ye(n),t=await ce(t,n,!0),ge(e,t,r,n)),Se=(e,t)=>{const r=J.fromBytes(e,"recovered"),{r:n,s:o,recovery:a}=r;Y(a);const s=ee(d(t,u)),c=2===a||3===a?n+i:n;L(c);const l=R(E(a)),f=_(l,G(c)),h=N.fromBytes(f),p=I(c,i),b=x(-s*p),g=x(o*p);return D(h,b,g).toBytes()},Ee=(e,t,r={})=>(t=ce(t,ye(r),!1),Se(e,t)),ke=async(e,t,r={})=>(t=await ce(t,ye(r),!0),Se(e,t)),Ae=(e,t,r=!0)=>N.fromBytes(t).multiply(W(e)).toBytes(r),xe=(e=S(f.seed))=>{d(e),(e.length<f.seed||e.length>1024)&&h("expected 40-1024b");const t=A(F(e),i-1n);return G(t+1n)},Ie=e=>t=>{const r=xe(t);return{secretKey:r,publicKey:e(r)}},Be=Ie(X),Te={hexToBytes:m,bytesToHex:g,concatBytes:_,bytesToNumberBE:F,numberToBytesBE:G,mod:A,invert:I,randomBytes:S,secretKeyToScalar:W,abytes:d},He={isValidSecretKey:e=>{try{return!!W(e)}catch(e){return!1}},isValidPublicKey:(e,t)=>{const{publicKey:r,publicKeyUncompressed:n}=f;try{const o=e.length;return!(!0===t&&o!==r||!1===t&&o!==n||!N.fromBytes(e))}catch(e){return!1}},randomSecretKey:xe},Oe=e=>Uint8Array.from("BIP0340/"+e,e=>e.charCodeAt(0)),Pe="nonce",Le="challenge",Ue=(e,...t)=>{const r=B("sha256"),n=r(Oe(e));return r(_(n,n,...t))},je=async(e,...t)=>{const r=se.sha256Async,n=await r(Oe(e));return await r(_(n,n,...t))},Ce=e=>{const t=W(e),r=M.multiply(t),{x:n,y:o}=r.assertValidity().toAffine();return{d:j(o)?t:x(-t),px:G(n)}},Re=e=>x(F(e)),ze=(...e)=>Re(Ue(Le,...e)),Ne=async(...e)=>Re(await je(Le,...e)),Me=e=>Ce(e).px,Ve=Ie(Me),De=(e,t,r)=>{const{px:n,d:o}=Ce(t);return{m:d(e),px:n,d:o,a:d(r,u)}},Fe=e=>{const t=Re(e);0n===t&&h("sign failed: k is zero");const{px:r,d:n}=Ce(G(t));return{rx:r,k:n}},qe=(e,t,r,n)=>_(t,G(x(e+r*n))),Ke="invalid signature produced",Ge=(e,t,r,n)=>{const a=d(e,l,"signature"),s=d(t,void 0,"message"),c=d(r,u,"publicKey");try{const e=F(c),t=z(e),r=j(t)?t:A(-t),d=new N(e,r,1n).assertValidity(),p=G(d.toAffine().x),b=q(a,0,u);k(b,1n,o);const g=q(a,u,l);k(g,1n,i);return f=n(_(G(b),p,s)),h=e=>{const{x:t,y:r}=D(d,g,x(-e)).toAffine();return!(!j(r)||t!==b)},f instanceof Promise?f.then(h):h(f)}catch(e){return!1}var f,h},We=(e,t,r)=>Ge(e,t,r,ze),$e=async(e,t,r)=>Ge(e,t,r,Ne),Xe={keygen:Ve,getPublicKey:Me,sign:(e,t,r=S(u))=>{const{m:n,px:o,d:i,a}=De(e,t,r),s=Ue("aux",a),c=G(i^F(s)),l=Ue(Pe,c,o,n),{rx:f,k:d}=Fe(l),p=ze(f,o,n),b=qe(d,f,p,i);return We(b,n,o)||h(Ke),b},verify:We,signAsync:async(e,t,r=S(u))=>{const{m:n,px:o,d:i,a}=De(e,t,r),s=await je("aux",a),c=G(i^F(s)),l=await je(Pe,c,o,n),{rx:f,k:d}=Fe(l),p=await Ne(f,o,n),b=qe(d,f,p,i);return await $e(b,n,o)||h(Ke),b},verifyAsync:$e},Ye=Math.ceil(32)+1;let Ze;const Je=(e,t)=>{const r=t.negate();return e?r:t},Qe=e=>{const t=Ze||(Ze=(()=>{const e=[];let t=M,r=t;for(let n=0;n<Ye;n++){r=t,e.push(r);for(let n=1;n<128;n++)r=r.add(t),e.push(r);t=r.double()}return e})());let r=V,n=M;const o=E(255),i=E(8);for(let a=0;a<Ye;a++){let s=Number(e&o);e>>=i,s>128&&(s-=256,e+=1n);const c=128*a,u=c,l=c+Math.abs(s)-1,f=a%2!=0,h=s<0;0===s?n=n.add(Je(f,t[u])):r=r.add(Je(h,t[l]))}return 0n!==e&&h("invalid wnaf"),{p:r,f:n}}},6996:e=>{"use strict";e.exports=JSON.parse('["的","一","是","在","不","了","有","和","人","这","中","大","为","上","个","国","我","以","要","他","时","来","用","们","生","到","作","地","于","出","就","分","对","成","会","可","主","发","年","动","同","工","也","能","下","过","子","说","产","种","面","而","方","后","多","定","行","学","法","所","民","得","经","十","三","之","进","着","等","部","度","家","电","力","里","如","水","化","高","自","二","理","起","小","物","现","实","加","量","都","两","体","制","机","当","使","点","从","业","本","去","把","性","好","应","开","它","合","还","因","由","其","些","然","前","外","天","政","四","日","那","社","义","事","平","形","相","全","表","间","样","与","关","各","重","新","线","内","数","正","心","反","你","明","看","原","又","么","利","比","或","但","质","气","第","向","道","命","此","变","条","只","没","结","解","问","意","建","月","公","无","系","军","很","情","者","最","立","代","想","已","通","并","提","直","题","党","程","展","五","果","料","象","员","革","位","入","常","文","总","次","品","式","活","设","及","管","特","件","长","求","老","头","基","资","边","流","路","级","少","图","山","统","接","知","较","将","组","见","计","别","她","手","角","期","根","论","运","农","指","几","九","区","强","放","决","西","被","干","做","必","战","先","回","则","任","取","据","处","队","南","给","色","光","门","即","保","治","北","造","百","规","热","领","七","海","口","东","导","器","压","志","世","金","增","争","济","阶","油","思","术","极","交","受","联","什","认","六","共","权","收","证","改","清","美","再","采","转","更","单","风","切","打","白","教","速","花","带","安","场","身","车","例","真","务","具","万","每","目","至","达","走","积","示","议","声","报","斗","完","类","八","离","华","名","确","才","科","张","信","马","节","话","米","整","空","元","况","今","集","温","传","土","许","步","群","广","石","记","需","段","研","界","拉","林","律","叫","且","究","观","越","织","装","影","算","低","持","音","众","书","布","复","容","儿","须","际","商","非","验","连","断","深","难","近","矿","千","周","委","素","技","备","半","办","青","省","列","习","响","约","支","般","史","感","劳","便","团","往","酸","历","市","克","何","除","消","构","府","称","太","准","精","值","号","率","族","维","划","选","标","写","存","候","毛","亲","快","效","斯","院","查","江","型","眼","王","按","格","养","易","置","派","层","片","始","却","专","状","育","厂","京","识","适","属","圆","包","火","住","调","满","县","局","照","参","红","细","引","听","该","铁","价","严","首","底","液","官","德","随","病","苏","失","尔","死","讲","配","女","黄","推","显","谈","罪","神","艺","呢","席","含","企","望","密","批","营","项","防","举","球","英","氧","势","告","李","台","落","木","帮","轮","破","亚","师","围","注","远","字","材","排","供","河","态","封","另","施","减","树","溶","怎","止","案","言","士","均","武","固","叶","鱼","波","视","仅","费","紧","爱","左","章","早","朝","害","续","轻","服","试","食","充","兵","源","判","护","司","足","某","练","差","致","板","田","降","黑","犯","负","击","范","继","兴","似","余","坚","曲","输","修","故","城","夫","够","送","笔","船","占","右","财","吃","富","春","职","觉","汉","画","功","巴","跟","虽","杂","飞","检","吸","助","升","阳","互","初","创","抗","考","投","坏","策","古","径","换","未","跑","留","钢","曾","端","责","站","简","述","钱","副","尽","帝","射","草","冲","承","独","令","限","阿","宣","环","双","请","超","微","让","控","州","良","轴","找","否","纪","益","依","优","顶","础","载","倒","房","突","坐","粉","敌","略","客","袁","冷","胜","绝","析","块","剂","测","丝","协","诉","念","陈","仍","罗","盐","友","洋","错","苦","夜","刑","移","频","逐","靠","混","母","短","皮","终","聚","汽","村","云","哪","既","距","卫","停","烈","央","察","烧","迅","境","若","印","洲","刻","括","激","孔","搞","甚","室","待","核","校","散","侵","吧","甲","游","久","菜","味","旧","模","湖","货","损","预","阻","毫","普","稳","乙","妈","植","息","扩","银","语","挥","酒","守","拿","序","纸","医","缺","雨","吗","针","刘","啊","急","唱","误","训","愿","审","附","获","茶","鲜","粮","斤","孩","脱","硫","肥","善","龙","演","父","渐","血","欢","械","掌","歌","沙","刚","攻","谓","盾","讨","晚","粒","乱","燃","矛","乎","杀","药","宁","鲁","贵","钟","煤","读","班","伯","香","介","迫","句","丰","培","握","兰","担","弦","蛋","沉","假","穿","执","答","乐","谁","顺","烟","缩","征","脸","喜","松","脚","困","异","免","背","星","福","买","染","井","概","慢","怕","磁","倍","祖","皇","促","静","补","评","翻","肉","践","尼","衣","宽","扬","棉","希","伤","操","垂","秋","宜","氢","套","督","振","架","亮","末","宪","庆","编","牛","触","映","雷","销","诗","座","居","抓","裂","胞","呼","娘","景","威","绿","晶","厚","盟","衡","鸡","孙","延","危","胶","屋","乡","临","陆","顾","掉","呀","灯","岁","措","束","耐","剧","玉","赵","跳","哥","季","课","凯","胡","额","款","绍","卷","齐","伟","蒸","殖","永","宗","苗","川","炉","岩","弱","零","杨","奏","沿","露","杆","探","滑","镇","饭","浓","航","怀","赶","库","夺","伊","灵","税","途","灭","赛","归","召","鼓","播","盘","裁","险","康","唯","录","菌","纯","借","糖","盖","横","符","私","努","堂","域","枪","润","幅","哈","竟","熟","虫","泽","脑","壤","碳","欧","遍","侧","寨","敢","彻","虑","斜","薄","庭","纳","弹","饲","伸","折","麦","湿","暗","荷","瓦","塞","床","筑","恶","户","访","塔","奇","透","梁","刀","旋","迹","卡","氯","遇","份","毒","泥","退","洗","摆","灰","彩","卖","耗","夏","择","忙","铜","献","硬","予","繁","圈","雪","函","亦","抽","篇","阵","阴","丁","尺","追","堆","雄","迎","泛","爸","楼","避","谋","吨","野","猪","旗","累","偏","典","馆","索","秦","脂","潮","爷","豆","忽","托","惊","塑","遗","愈","朱","替","纤","粗","倾","尚","痛","楚","谢","奋","购","磨","君","池","旁","碎","骨","监","捕","弟","暴","割","贯","殊","释","词","亡","壁","顿","宝","午","尘","闻","揭","炮","残","冬","桥","妇","警","综","招","吴","付","浮","遭","徐","您","摇","谷","赞","箱","隔","订","男","吹","园","纷","唐","败","宋","玻","巨","耕","坦","荣","闭","湾","键","凡","驻","锅","救","恩","剥","凝","碱","齿","截","炼","麻","纺","禁","废","盛","版","缓","净","睛","昌","婚","涉","筒","嘴","插","岸","朗","庄","街","藏","姑","贸","腐","奴","啦","惯","乘","伙","恢","匀","纱","扎","辩","耳","彪","臣","亿","璃","抵","脉","秀","萨","俄","网","舞","店","喷","纵","寸","汗","挂","洪","贺","闪","柬","爆","烯","津","稻","墙","软","勇","像","滚","厘","蒙","芳","肯","坡","柱","荡","腿","仪","旅","尾","轧","冰","贡","登","黎","削","钻","勒","逃","障","氨","郭","峰","币","港","伏","轨","亩","毕","擦","莫","刺","浪","秘","援","株","健","售","股","岛","甘","泡","睡","童","铸","汤","阀","休","汇","舍","牧","绕","炸","哲","磷","绩","朋","淡","尖","启","陷","柴","呈","徒","颜","泪","稍","忘","泵","蓝","拖","洞","授","镜","辛","壮","锋","贫","虚","弯","摩","泰","幼","廷","尊","窗","纲","弄","隶","疑","氏","宫","姐","震","瑞","怪","尤","琴","循","描","膜","违","夹","腰","缘","珠","穷","森","枝","竹","沟","催","绳","忆","邦","剩","幸","浆","栏","拥","牙","贮","礼","滤","钠","纹","罢","拍","咱","喊","袖","埃","勤","罚","焦","潜","伍","墨","欲","缝","姓","刊","饱","仿","奖","铝","鬼","丽","跨","默","挖","链","扫","喝","袋","炭","污","幕","诸","弧","励","梅","奶","洁","灾","舟","鉴","苯","讼","抱","毁","懂","寒","智","埔","寄","届","跃","渡","挑","丹","艰","贝","碰","拔","爹","戴","码","梦","芽","熔","赤","渔","哭","敬","颗","奔","铅","仲","虎","稀","妹","乏","珍","申","桌","遵","允","隆","螺","仓","魏","锐","晓","氮","兼","隐","碍","赫","拨","忠","肃","缸","牵","抢","博","巧","壳","兄","杜","讯","诚","碧","祥","柯","页","巡","矩","悲","灌","龄","伦","票","寻","桂","铺","圣","恐","恰","郑","趣","抬","荒","腾","贴","柔","滴","猛","阔","辆","妻","填","撤","储","签","闹","扰","紫","砂","递","戏","吊","陶","伐","喂","疗","瓶","婆","抚","臂","摸","忍","虾","蜡","邻","胸","巩","挤","偶","弃","槽","劲","乳","邓","吉","仁","烂","砖","租","乌","舰","伴","瓜","浅","丙","暂","燥","橡","柳","迷","暖","牌","秧","胆","详","簧","踏","瓷","谱","呆","宾","糊","洛","辉","愤","竞","隙","怒","粘","乃","绪","肩","籍","敏","涂","熙","皆","侦","悬","掘","享","纠","醒","狂","锁","淀","恨","牲","霸","爬","赏","逆","玩","陵","祝","秒","浙","貌","役","彼","悉","鸭","趋","凤","晨","畜","辈","秩","卵","署","梯","炎","滩","棋","驱","筛","峡","冒","啥","寿","译","浸","泉","帽","迟","硅","疆","贷","漏","稿","冠","嫩","胁","芯","牢","叛","蚀","奥","鸣","岭","羊","凭","串","塘","绘","酵","融","盆","锡","庙","筹","冻","辅","摄","袭","筋","拒","僚","旱","钾","鸟","漆","沈","眉","疏","添","棒","穗","硝","韩","逼","扭","侨","凉","挺","碗","栽","炒","杯","患","馏","劝","豪","辽","勃","鸿","旦","吏","拜","狗","埋","辊","掩","饮","搬","骂","辞","勾","扣","估","蒋","绒","雾","丈","朵","姆","拟","宇","辑","陕","雕","偿","蓄","崇","剪","倡","厅","咬","驶","薯","刷","斥","番","赋","奉","佛","浇","漫","曼","扇","钙","桃","扶","仔","返","俗","亏","腔","鞋","棱","覆","框","悄","叔","撞","骗","勘","旺","沸","孤","吐","孟","渠","屈","疾","妙","惜","仰","狠","胀","谐","抛","霉","桑","岗","嘛","衰","盗","渗","脏","赖","涌","甜","曹","阅","肌","哩","厉","烃","纬","毅","昨","伪","症","煮","叹","钉","搭","茎","笼","酷","偷","弓","锥","恒","杰","坑","鼻","翼","纶","叙","狱","逮","罐","络","棚","抑","膨","蔬","寺","骤","穆","冶","枯","册","尸","凸","绅","坯","牺","焰","轰","欣","晋","瘦","御","锭","锦","丧","旬","锻","垄","搜","扑","邀","亭","酯","迈","舒","脆","酶","闲","忧","酚","顽","羽","涨","卸","仗","陪","辟","惩","杭","姚","肚","捉","飘","漂","昆","欺","吾","郎","烷","汁","呵","饰","萧","雅","邮","迁","燕","撒","姻","赴","宴","烦","债","帐","斑","铃","旨","醇","董","饼","雏","姿","拌","傅","腹","妥","揉","贤","拆","歪","葡","胺","丢","浩","徽","昂","垫","挡","览","贪","慰","缴","汪","慌","冯","诺","姜","谊","凶","劣","诬","耀","昏","躺","盈","骑","乔","溪","丛","卢","抹","闷","咨","刮","驾","缆","悟","摘","铒","掷","颇","幻","柄","惠","惨","佳","仇","腊","窝","涤","剑","瞧","堡","泼","葱","罩","霍","捞","胎","苍","滨","俩","捅","湘","砍","霞","邵","萄","疯","淮","遂","熊","粪","烘","宿","档","戈","驳","嫂","裕","徙","箭","捐","肠","撑","晒","辨","殿","莲","摊","搅","酱","屏","疫","哀","蔡","堵","沫","皱","畅","叠","阁","莱","敲","辖","钩","痕","坝","巷","饿","祸","丘","玄","溜","曰","逻","彭","尝","卿","妨","艇","吞","韦","怨","矮","歇"]')},4262:e=>{"use strict";e.exports=JSON.parse('["的","一","是","在","不","了","有","和","人","這","中","大","為","上","個","國","我","以","要","他","時","來","用","們","生","到","作","地","於","出","就","分","對","成","會","可","主","發","年","動","同","工","也","能","下","過","子","說","產","種","面","而","方","後","多","定","行","學","法","所","民","得","經","十","三","之","進","著","等","部","度","家","電","力","裡","如","水","化","高","自","二","理","起","小","物","現","實","加","量","都","兩","體","制","機","當","使","點","從","業","本","去","把","性","好","應","開","它","合","還","因","由","其","些","然","前","外","天","政","四","日","那","社","義","事","平","形","相","全","表","間","樣","與","關","各","重","新","線","內","數","正","心","反","你","明","看","原","又","麼","利","比","或","但","質","氣","第","向","道","命","此","變","條","只","沒","結","解","問","意","建","月","公","無","系","軍","很","情","者","最","立","代","想","已","通","並","提","直","題","黨","程","展","五","果","料","象","員","革","位","入","常","文","總","次","品","式","活","設","及","管","特","件","長","求","老","頭","基","資","邊","流","路","級","少","圖","山","統","接","知","較","將","組","見","計","別","她","手","角","期","根","論","運","農","指","幾","九","區","強","放","決","西","被","幹","做","必","戰","先","回","則","任","取","據","處","隊","南","給","色","光","門","即","保","治","北","造","百","規","熱","領","七","海","口","東","導","器","壓","志","世","金","增","爭","濟","階","油","思","術","極","交","受","聯","什","認","六","共","權","收","證","改","清","美","再","採","轉","更","單","風","切","打","白","教","速","花","帶","安","場","身","車","例","真","務","具","萬","每","目","至","達","走","積","示","議","聲","報","鬥","完","類","八","離","華","名","確","才","科","張","信","馬","節","話","米","整","空","元","況","今","集","溫","傳","土","許","步","群","廣","石","記","需","段","研","界","拉","林","律","叫","且","究","觀","越","織","裝","影","算","低","持","音","眾","書","布","复","容","兒","須","際","商","非","驗","連","斷","深","難","近","礦","千","週","委","素","技","備","半","辦","青","省","列","習","響","約","支","般","史","感","勞","便","團","往","酸","歷","市","克","何","除","消","構","府","稱","太","準","精","值","號","率","族","維","劃","選","標","寫","存","候","毛","親","快","效","斯","院","查","江","型","眼","王","按","格","養","易","置","派","層","片","始","卻","專","狀","育","廠","京","識","適","屬","圓","包","火","住","調","滿","縣","局","照","參","紅","細","引","聽","該","鐵","價","嚴","首","底","液","官","德","隨","病","蘇","失","爾","死","講","配","女","黃","推","顯","談","罪","神","藝","呢","席","含","企","望","密","批","營","項","防","舉","球","英","氧","勢","告","李","台","落","木","幫","輪","破","亞","師","圍","注","遠","字","材","排","供","河","態","封","另","施","減","樹","溶","怎","止","案","言","士","均","武","固","葉","魚","波","視","僅","費","緊","愛","左","章","早","朝","害","續","輕","服","試","食","充","兵","源","判","護","司","足","某","練","差","致","板","田","降","黑","犯","負","擊","范","繼","興","似","餘","堅","曲","輸","修","故","城","夫","夠","送","筆","船","佔","右","財","吃","富","春","職","覺","漢","畫","功","巴","跟","雖","雜","飛","檢","吸","助","昇","陽","互","初","創","抗","考","投","壞","策","古","徑","換","未","跑","留","鋼","曾","端","責","站","簡","述","錢","副","盡","帝","射","草","衝","承","獨","令","限","阿","宣","環","雙","請","超","微","讓","控","州","良","軸","找","否","紀","益","依","優","頂","礎","載","倒","房","突","坐","粉","敵","略","客","袁","冷","勝","絕","析","塊","劑","測","絲","協","訴","念","陳","仍","羅","鹽","友","洋","錯","苦","夜","刑","移","頻","逐","靠","混","母","短","皮","終","聚","汽","村","雲","哪","既","距","衛","停","烈","央","察","燒","迅","境","若","印","洲","刻","括","激","孔","搞","甚","室","待","核","校","散","侵","吧","甲","遊","久","菜","味","舊","模","湖","貨","損","預","阻","毫","普","穩","乙","媽","植","息","擴","銀","語","揮","酒","守","拿","序","紙","醫","缺","雨","嗎","針","劉","啊","急","唱","誤","訓","願","審","附","獲","茶","鮮","糧","斤","孩","脫","硫","肥","善","龍","演","父","漸","血","歡","械","掌","歌","沙","剛","攻","謂","盾","討","晚","粒","亂","燃","矛","乎","殺","藥","寧","魯","貴","鐘","煤","讀","班","伯","香","介","迫","句","豐","培","握","蘭","擔","弦","蛋","沉","假","穿","執","答","樂","誰","順","煙","縮","徵","臉","喜","松","腳","困","異","免","背","星","福","買","染","井","概","慢","怕","磁","倍","祖","皇","促","靜","補","評","翻","肉","踐","尼","衣","寬","揚","棉","希","傷","操","垂","秋","宜","氫","套","督","振","架","亮","末","憲","慶","編","牛","觸","映","雷","銷","詩","座","居","抓","裂","胞","呼","娘","景","威","綠","晶","厚","盟","衡","雞","孫","延","危","膠","屋","鄉","臨","陸","顧","掉","呀","燈","歲","措","束","耐","劇","玉","趙","跳","哥","季","課","凱","胡","額","款","紹","卷","齊","偉","蒸","殖","永","宗","苗","川","爐","岩","弱","零","楊","奏","沿","露","桿","探","滑","鎮","飯","濃","航","懷","趕","庫","奪","伊","靈","稅","途","滅","賽","歸","召","鼓","播","盤","裁","險","康","唯","錄","菌","純","借","糖","蓋","橫","符","私","努","堂","域","槍","潤","幅","哈","竟","熟","蟲","澤","腦","壤","碳","歐","遍","側","寨","敢","徹","慮","斜","薄","庭","納","彈","飼","伸","折","麥","濕","暗","荷","瓦","塞","床","築","惡","戶","訪","塔","奇","透","梁","刀","旋","跡","卡","氯","遇","份","毒","泥","退","洗","擺","灰","彩","賣","耗","夏","擇","忙","銅","獻","硬","予","繁","圈","雪","函","亦","抽","篇","陣","陰","丁","尺","追","堆","雄","迎","泛","爸","樓","避","謀","噸","野","豬","旗","累","偏","典","館","索","秦","脂","潮","爺","豆","忽","托","驚","塑","遺","愈","朱","替","纖","粗","傾","尚","痛","楚","謝","奮","購","磨","君","池","旁","碎","骨","監","捕","弟","暴","割","貫","殊","釋","詞","亡","壁","頓","寶","午","塵","聞","揭","炮","殘","冬","橋","婦","警","綜","招","吳","付","浮","遭","徐","您","搖","谷","贊","箱","隔","訂","男","吹","園","紛","唐","敗","宋","玻","巨","耕","坦","榮","閉","灣","鍵","凡","駐","鍋","救","恩","剝","凝","鹼","齒","截","煉","麻","紡","禁","廢","盛","版","緩","淨","睛","昌","婚","涉","筒","嘴","插","岸","朗","莊","街","藏","姑","貿","腐","奴","啦","慣","乘","夥","恢","勻","紗","扎","辯","耳","彪","臣","億","璃","抵","脈","秀","薩","俄","網","舞","店","噴","縱","寸","汗","掛","洪","賀","閃","柬","爆","烯","津","稻","牆","軟","勇","像","滾","厘","蒙","芳","肯","坡","柱","盪","腿","儀","旅","尾","軋","冰","貢","登","黎","削","鑽","勒","逃","障","氨","郭","峰","幣","港","伏","軌","畝","畢","擦","莫","刺","浪","秘","援","株","健","售","股","島","甘","泡","睡","童","鑄","湯","閥","休","匯","舍","牧","繞","炸","哲","磷","績","朋","淡","尖","啟","陷","柴","呈","徒","顏","淚","稍","忘","泵","藍","拖","洞","授","鏡","辛","壯","鋒","貧","虛","彎","摩","泰","幼","廷","尊","窗","綱","弄","隸","疑","氏","宮","姐","震","瑞","怪","尤","琴","循","描","膜","違","夾","腰","緣","珠","窮","森","枝","竹","溝","催","繩","憶","邦","剩","幸","漿","欄","擁","牙","貯","禮","濾","鈉","紋","罷","拍","咱","喊","袖","埃","勤","罰","焦","潛","伍","墨","欲","縫","姓","刊","飽","仿","獎","鋁","鬼","麗","跨","默","挖","鏈","掃","喝","袋","炭","污","幕","諸","弧","勵","梅","奶","潔","災","舟","鑑","苯","訟","抱","毀","懂","寒","智","埔","寄","屆","躍","渡","挑","丹","艱","貝","碰","拔","爹","戴","碼","夢","芽","熔","赤","漁","哭","敬","顆","奔","鉛","仲","虎","稀","妹","乏","珍","申","桌","遵","允","隆","螺","倉","魏","銳","曉","氮","兼","隱","礙","赫","撥","忠","肅","缸","牽","搶","博","巧","殼","兄","杜","訊","誠","碧","祥","柯","頁","巡","矩","悲","灌","齡","倫","票","尋","桂","鋪","聖","恐","恰","鄭","趣","抬","荒","騰","貼","柔","滴","猛","闊","輛","妻","填","撤","儲","簽","鬧","擾","紫","砂","遞","戲","吊","陶","伐","餵","療","瓶","婆","撫","臂","摸","忍","蝦","蠟","鄰","胸","鞏","擠","偶","棄","槽","勁","乳","鄧","吉","仁","爛","磚","租","烏","艦","伴","瓜","淺","丙","暫","燥","橡","柳","迷","暖","牌","秧","膽","詳","簧","踏","瓷","譜","呆","賓","糊","洛","輝","憤","競","隙","怒","粘","乃","緒","肩","籍","敏","塗","熙","皆","偵","懸","掘","享","糾","醒","狂","鎖","淀","恨","牲","霸","爬","賞","逆","玩","陵","祝","秒","浙","貌","役","彼","悉","鴨","趨","鳳","晨","畜","輩","秩","卵","署","梯","炎","灘","棋","驅","篩","峽","冒","啥","壽","譯","浸","泉","帽","遲","矽","疆","貸","漏","稿","冠","嫩","脅","芯","牢","叛","蝕","奧","鳴","嶺","羊","憑","串","塘","繪","酵","融","盆","錫","廟","籌","凍","輔","攝","襲","筋","拒","僚","旱","鉀","鳥","漆","沈","眉","疏","添","棒","穗","硝","韓","逼","扭","僑","涼","挺","碗","栽","炒","杯","患","餾","勸","豪","遼","勃","鴻","旦","吏","拜","狗","埋","輥","掩","飲","搬","罵","辭","勾","扣","估","蔣","絨","霧","丈","朵","姆","擬","宇","輯","陝","雕","償","蓄","崇","剪","倡","廳","咬","駛","薯","刷","斥","番","賦","奉","佛","澆","漫","曼","扇","鈣","桃","扶","仔","返","俗","虧","腔","鞋","棱","覆","框","悄","叔","撞","騙","勘","旺","沸","孤","吐","孟","渠","屈","疾","妙","惜","仰","狠","脹","諧","拋","黴","桑","崗","嘛","衰","盜","滲","臟","賴","湧","甜","曹","閱","肌","哩","厲","烴","緯","毅","昨","偽","症","煮","嘆","釘","搭","莖","籠","酷","偷","弓","錐","恆","傑","坑","鼻","翼","綸","敘","獄","逮","罐","絡","棚","抑","膨","蔬","寺","驟","穆","冶","枯","冊","屍","凸","紳","坯","犧","焰","轟","欣","晉","瘦","禦","錠","錦","喪","旬","鍛","壟","搜","撲","邀","亭","酯","邁","舒","脆","酶","閒","憂","酚","頑","羽","漲","卸","仗","陪","闢","懲","杭","姚","肚","捉","飄","漂","昆","欺","吾","郎","烷","汁","呵","飾","蕭","雅","郵","遷","燕","撒","姻","赴","宴","煩","債","帳","斑","鈴","旨","醇","董","餅","雛","姿","拌","傅","腹","妥","揉","賢","拆","歪","葡","胺","丟","浩","徽","昂","墊","擋","覽","貪","慰","繳","汪","慌","馮","諾","姜","誼","兇","劣","誣","耀","昏","躺","盈","騎","喬","溪","叢","盧","抹","悶","諮","刮","駕","纜","悟","摘","鉺","擲","頗","幻","柄","惠","慘","佳","仇","臘","窩","滌","劍","瞧","堡","潑","蔥","罩","霍","撈","胎","蒼","濱","倆","捅","湘","砍","霞","邵","萄","瘋","淮","遂","熊","糞","烘","宿","檔","戈","駁","嫂","裕","徙","箭","捐","腸","撐","曬","辨","殿","蓮","攤","攪","醬","屏","疫","哀","蔡","堵","沫","皺","暢","疊","閣","萊","敲","轄","鉤","痕","壩","巷","餓","禍","丘","玄","溜","曰","邏","彭","嘗","卿","妨","艇","吞","韋","怨","矮","歇"]')},32:e=>{"use strict";e.exports=JSON.parse('["abdikace","abeceda","adresa","agrese","akce","aktovka","alej","alkohol","amputace","ananas","andulka","anekdota","anketa","antika","anulovat","archa","arogance","asfalt","asistent","aspirace","astma","astronom","atlas","atletika","atol","autobus","azyl","babka","bachor","bacil","baculka","badatel","bageta","bagr","bahno","bakterie","balada","baletka","balkon","balonek","balvan","balza","bambus","bankomat","barbar","baret","barman","baroko","barva","baterka","batoh","bavlna","bazalka","bazilika","bazuka","bedna","beran","beseda","bestie","beton","bezinka","bezmoc","beztak","bicykl","bidlo","biftek","bikiny","bilance","biograf","biolog","bitva","bizon","blahobyt","blatouch","blecha","bledule","blesk","blikat","blizna","blokovat","bloudit","blud","bobek","bobr","bodlina","bodnout","bohatost","bojkot","bojovat","bokorys","bolest","borec","borovice","bota","boubel","bouchat","bouda","boule","bourat","boxer","bradavka","brambora","branka","bratr","brepta","briketa","brko","brloh","bronz","broskev","brunetka","brusinka","brzda","brzy","bublina","bubnovat","buchta","buditel","budka","budova","bufet","bujarost","bukvice","buldok","bulva","bunda","bunkr","burza","butik","buvol","buzola","bydlet","bylina","bytovka","bzukot","capart","carevna","cedr","cedule","cejch","cejn","cela","celer","celkem","celnice","cenina","cennost","cenovka","centrum","cenzor","cestopis","cetka","chalupa","chapadlo","charita","chata","chechtat","chemie","chichot","chirurg","chlad","chleba","chlubit","chmel","chmura","chobot","chochol","chodba","cholera","chomout","chopit","choroba","chov","chrapot","chrlit","chrt","chrup","chtivost","chudina","chutnat","chvat","chvilka","chvost","chyba","chystat","chytit","cibule","cigareta","cihelna","cihla","cinkot","cirkus","cisterna","citace","citrus","cizinec","cizost","clona","cokoliv","couvat","ctitel","ctnost","cudnost","cuketa","cukr","cupot","cvaknout","cval","cvik","cvrkot","cyklista","daleko","dareba","datel","datum","dcera","debata","dechovka","decibel","deficit","deflace","dekl","dekret","demokrat","deprese","derby","deska","detektiv","dikobraz","diktovat","dioda","diplom","disk","displej","divadlo","divoch","dlaha","dlouho","dluhopis","dnes","dobro","dobytek","docent","dochutit","dodnes","dohled","dohoda","dohra","dojem","dojnice","doklad","dokola","doktor","dokument","dolar","doleva","dolina","doma","dominant","domluvit","domov","donutit","dopad","dopis","doplnit","doposud","doprovod","dopustit","dorazit","dorost","dort","dosah","doslov","dostatek","dosud","dosyta","dotaz","dotek","dotknout","doufat","doutnat","dovozce","dozadu","doznat","dozorce","drahota","drak","dramatik","dravec","draze","drdol","drobnost","drogerie","drozd","drsnost","drtit","drzost","duben","duchovno","dudek","duha","duhovka","dusit","dusno","dutost","dvojice","dvorec","dynamit","ekolog","ekonomie","elektron","elipsa","email","emise","emoce","empatie","epizoda","epocha","epopej","epos","esej","esence","eskorta","eskymo","etiketa","euforie","evoluce","exekuce","exkurze","expedice","exploze","export","extrakt","facka","fajfka","fakulta","fanatik","fantazie","farmacie","favorit","fazole","federace","fejeton","fenka","fialka","figurant","filozof","filtr","finance","finta","fixace","fjord","flanel","flirt","flotila","fond","fosfor","fotbal","fotka","foton","frakce","freska","fronta","fukar","funkce","fyzika","galeje","garant","genetika","geolog","gilotina","glazura","glejt","golem","golfista","gotika","graf","gramofon","granule","grep","gril","grog","groteska","guma","hadice","hadr","hala","halenka","hanba","hanopis","harfa","harpuna","havran","hebkost","hejkal","hejno","hejtman","hektar","helma","hematom","herec","herna","heslo","hezky","historik","hladovka","hlasivky","hlava","hledat","hlen","hlodavec","hloh","hloupost","hltat","hlubina","hluchota","hmat","hmota","hmyz","hnis","hnojivo","hnout","hoblina","hoboj","hoch","hodiny","hodlat","hodnota","hodovat","hojnost","hokej","holinka","holka","holub","homole","honitba","honorace","horal","horda","horizont","horko","horlivec","hormon","hornina","horoskop","horstvo","hospoda","hostina","hotovost","houba","houf","houpat","houska","hovor","hradba","hranice","hravost","hrazda","hrbolek","hrdina","hrdlo","hrdost","hrnek","hrobka","hromada","hrot","hrouda","hrozen","hrstka","hrubost","hryzat","hubenost","hubnout","hudba","hukot","humr","husita","hustota","hvozd","hybnost","hydrant","hygiena","hymna","hysterik","idylka","ihned","ikona","iluze","imunita","infekce","inflace","inkaso","inovace","inspekce","internet","invalida","investor","inzerce","ironie","jablko","jachta","jahoda","jakmile","jakost","jalovec","jantar","jarmark","jaro","jasan","jasno","jatka","javor","jazyk","jedinec","jedle","jednatel","jehlan","jekot","jelen","jelito","jemnost","jenom","jepice","jeseter","jevit","jezdec","jezero","jinak","jindy","jinoch","jiskra","jistota","jitrnice","jizva","jmenovat","jogurt","jurta","kabaret","kabel","kabinet","kachna","kadet","kadidlo","kahan","kajak","kajuta","kakao","kaktus","kalamita","kalhoty","kalibr","kalnost","kamera","kamkoliv","kamna","kanibal","kanoe","kantor","kapalina","kapela","kapitola","kapka","kaple","kapota","kapr","kapusta","kapybara","karamel","karotka","karton","kasa","katalog","katedra","kauce","kauza","kavalec","kazajka","kazeta","kazivost","kdekoliv","kdesi","kedluben","kemp","keramika","kino","klacek","kladivo","klam","klapot","klasika","klaun","klec","klenba","klepat","klesnout","klid","klima","klisna","klobouk","klokan","klopa","kloub","klubovna","klusat","kluzkost","kmen","kmitat","kmotr","kniha","knot","koalice","koberec","kobka","kobliha","kobyla","kocour","kohout","kojenec","kokos","koktejl","kolaps","koleda","kolize","kolo","komando","kometa","komik","komnata","komora","kompas","komunita","konat","koncept","kondice","konec","konfese","kongres","konina","konkurs","kontakt","konzerva","kopanec","kopie","kopnout","koprovka","korbel","korektor","kormidlo","koroptev","korpus","koruna","koryto","korzet","kosatec","kostka","kotel","kotleta","kotoul","koukat","koupelna","kousek","kouzlo","kovboj","koza","kozoroh","krabice","krach","krajina","kralovat","krasopis","kravata","kredit","krejcar","kresba","kreveta","kriket","kritik","krize","krkavec","krmelec","krmivo","krocan","krok","kronika","kropit","kroupa","krovka","krtek","kruhadlo","krupice","krutost","krvinka","krychle","krypta","krystal","kryt","kudlanka","kufr","kujnost","kukla","kulajda","kulich","kulka","kulomet","kultura","kuna","kupodivu","kurt","kurzor","kutil","kvalita","kvasinka","kvestor","kynolog","kyselina","kytara","kytice","kytka","kytovec","kyvadlo","labrador","lachtan","ladnost","laik","lakomec","lamela","lampa","lanovka","lasice","laso","lastura","latinka","lavina","lebka","leckdy","leden","lednice","ledovka","ledvina","legenda","legie","legrace","lehce","lehkost","lehnout","lektvar","lenochod","lentilka","lepenka","lepidlo","letadlo","letec","letmo","letokruh","levhart","levitace","levobok","libra","lichotka","lidojed","lidskost","lihovina","lijavec","lilek","limetka","linie","linka","linoleum","listopad","litina","litovat","lobista","lodivod","logika","logoped","lokalita","loket","lomcovat","lopata","lopuch","lord","losos","lotr","loudal","louh","louka","louskat","lovec","lstivost","lucerna","lucifer","lump","lusk","lustrace","lvice","lyra","lyrika","lysina","madam","madlo","magistr","mahagon","majetek","majitel","majorita","makak","makovice","makrela","malba","malina","malovat","malvice","maminka","mandle","manko","marnost","masakr","maskot","masopust","matice","matrika","maturita","mazanec","mazivo","mazlit","mazurka","mdloba","mechanik","meditace","medovina","melasa","meloun","mentolka","metla","metoda","metr","mezera","migrace","mihnout","mihule","mikina","mikrofon","milenec","milimetr","milost","mimika","mincovna","minibar","minomet","minulost","miska","mistr","mixovat","mladost","mlha","mlhovina","mlok","mlsat","mluvit","mnich","mnohem","mobil","mocnost","modelka","modlitba","mohyla","mokro","molekula","momentka","monarcha","monokl","monstrum","montovat","monzun","mosaz","moskyt","most","motivace","motorka","motyka","moucha","moudrost","mozaika","mozek","mozol","mramor","mravenec","mrkev","mrtvola","mrzet","mrzutost","mstitel","mudrc","muflon","mulat","mumie","munice","muset","mutace","muzeum","muzikant","myslivec","mzda","nabourat","nachytat","nadace","nadbytek","nadhoz","nadobro","nadpis","nahlas","nahnat","nahodile","nahradit","naivita","najednou","najisto","najmout","naklonit","nakonec","nakrmit","nalevo","namazat","namluvit","nanometr","naoko","naopak","naostro","napadat","napevno","naplnit","napnout","naposled","naprosto","narodit","naruby","narychlo","nasadit","nasekat","naslepo","nastat","natolik","navenek","navrch","navzdory","nazvat","nebe","nechat","necky","nedaleko","nedbat","neduh","negace","nehet","nehoda","nejen","nejprve","neklid","nelibost","nemilost","nemoc","neochota","neonka","nepokoj","nerost","nerv","nesmysl","nesoulad","netvor","neuron","nevina","nezvykle","nicota","nijak","nikam","nikdy","nikl","nikterak","nitro","nocleh","nohavice","nominace","nora","norek","nositel","nosnost","nouze","noviny","novota","nozdra","nuda","nudle","nuget","nutit","nutnost","nutrie","nymfa","obal","obarvit","obava","obdiv","obec","obehnat","obejmout","obezita","obhajoba","obilnice","objasnit","objekt","obklopit","oblast","oblek","obliba","obloha","obluda","obnos","obohatit","obojek","obout","obrazec","obrna","obruba","obrys","obsah","obsluha","obstarat","obuv","obvaz","obvinit","obvod","obvykle","obyvatel","obzor","ocas","ocel","ocenit","ochladit","ochota","ochrana","ocitnout","odboj","odbyt","odchod","odcizit","odebrat","odeslat","odevzdat","odezva","odhadce","odhodit","odjet","odjinud","odkaz","odkoupit","odliv","odluka","odmlka","odolnost","odpad","odpis","odplout","odpor","odpustit","odpykat","odrazka","odsoudit","odstup","odsun","odtok","odtud","odvaha","odveta","odvolat","odvracet","odznak","ofina","ofsajd","ohlas","ohnisko","ohrada","ohrozit","ohryzek","okap","okenice","oklika","okno","okouzlit","okovy","okrasa","okres","okrsek","okruh","okupant","okurka","okusit","olejnina","olizovat","omak","omeleta","omezit","omladina","omlouvat","omluva","omyl","onehdy","opakovat","opasek","operace","opice","opilost","opisovat","opora","opozice","opravdu","oproti","orbital","orchestr","orgie","orlice","orloj","ortel","osada","oschnout","osika","osivo","oslava","oslepit","oslnit","oslovit","osnova","osoba","osolit","ospalec","osten","ostraha","ostuda","ostych","osvojit","oteplit","otisk","otop","otrhat","otrlost","otrok","otruby","otvor","ovanout","ovar","oves","ovlivnit","ovoce","oxid","ozdoba","pachatel","pacient","padouch","pahorek","pakt","palanda","palec","palivo","paluba","pamflet","pamlsek","panenka","panika","panna","panovat","panstvo","pantofle","paprika","parketa","parodie","parta","paruka","paryba","paseka","pasivita","pastelka","patent","patrona","pavouk","pazneht","pazourek","pecka","pedagog","pejsek","peklo","peloton","penalta","pendrek","penze","periskop","pero","pestrost","petarda","petice","petrolej","pevnina","pexeso","pianista","piha","pijavice","pikle","piknik","pilina","pilnost","pilulka","pinzeta","pipeta","pisatel","pistole","pitevna","pivnice","pivovar","placenta","plakat","plamen","planeta","plastika","platit","plavidlo","plaz","plech","plemeno","plenta","ples","pletivo","plevel","plivat","plnit","plno","plocha","plodina","plomba","plout","pluk","plyn","pobavit","pobyt","pochod","pocit","poctivec","podat","podcenit","podepsat","podhled","podivit","podklad","podmanit","podnik","podoba","podpora","podraz","podstata","podvod","podzim","poezie","pohanka","pohnutka","pohovor","pohroma","pohyb","pointa","pojistka","pojmout","pokazit","pokles","pokoj","pokrok","pokuta","pokyn","poledne","polibek","polknout","poloha","polynom","pomalu","pominout","pomlka","pomoc","pomsta","pomyslet","ponechat","ponorka","ponurost","popadat","popel","popisek","poplach","poprosit","popsat","popud","poradce","porce","porod","porucha","poryv","posadit","posed","posila","poskok","poslanec","posoudit","pospolu","postava","posudek","posyp","potah","potkan","potlesk","potomek","potrava","potupa","potvora","poukaz","pouto","pouzdro","povaha","povidla","povlak","povoz","povrch","povstat","povyk","povzdech","pozdrav","pozemek","poznatek","pozor","pozvat","pracovat","prahory","praktika","prales","praotec","praporek","prase","pravda","princip","prkno","probudit","procento","prodej","profese","prohra","projekt","prolomit","promile","pronikat","propad","prorok","prosba","proton","proutek","provaz","prskavka","prsten","prudkost","prut","prvek","prvohory","psanec","psovod","pstruh","ptactvo","puberta","puch","pudl","pukavec","puklina","pukrle","pult","pumpa","punc","pupen","pusa","pusinka","pustina","putovat","putyka","pyramida","pysk","pytel","racek","rachot","radiace","radnice","radon","raft","ragby","raketa","rakovina","rameno","rampouch","rande","rarach","rarita","rasovna","rastr","ratolest","razance","razidlo","reagovat","reakce","recept","redaktor","referent","reflex","rejnok","reklama","rekord","rekrut","rektor","reputace","revize","revma","revolver","rezerva","riskovat","riziko","robotika","rodokmen","rohovka","rokle","rokoko","romaneto","ropovod","ropucha","rorejs","rosol","rostlina","rotmistr","rotoped","rotunda","roubenka","roucho","roup","roura","rovina","rovnice","rozbor","rozchod","rozdat","rozeznat","rozhodce","rozinka","rozjezd","rozkaz","rozloha","rozmar","rozpad","rozruch","rozsah","roztok","rozum","rozvod","rubrika","ruchadlo","rukavice","rukopis","ryba","rybolov","rychlost","rydlo","rypadlo","rytina","ryzost","sadista","sahat","sako","samec","samizdat","samota","sanitka","sardinka","sasanka","satelit","sazba","sazenice","sbor","schovat","sebranka","secese","sedadlo","sediment","sedlo","sehnat","sejmout","sekera","sekta","sekunda","sekvoje","semeno","seno","servis","sesadit","seshora","seskok","seslat","sestra","sesuv","sesypat","setba","setina","setkat","setnout","setrvat","sever","seznam","shoda","shrnout","sifon","silnice","sirka","sirotek","sirup","situace","skafandr","skalisko","skanzen","skaut","skeptik","skica","skladba","sklenice","sklo","skluz","skoba","skokan","skoro","skripta","skrz","skupina","skvost","skvrna","slabika","sladidlo","slanina","slast","slavnost","sledovat","slepec","sleva","slezina","slib","slina","sliznice","slon","sloupek","slovo","sluch","sluha","slunce","slupka","slza","smaragd","smetana","smilstvo","smlouva","smog","smrad","smrk","smrtka","smutek","smysl","snad","snaha","snob","sobota","socha","sodovka","sokol","sopka","sotva","souboj","soucit","soudce","souhlas","soulad","soumrak","souprava","soused","soutok","souviset","spalovna","spasitel","spis","splav","spodek","spojenec","spolu","sponzor","spornost","spousta","sprcha","spustit","sranda","sraz","srdce","srna","srnec","srovnat","srpen","srst","srub","stanice","starosta","statika","stavba","stehno","stezka","stodola","stolek","stopa","storno","stoupat","strach","stres","strhnout","strom","struna","studna","stupnice","stvol","styk","subjekt","subtropy","suchar","sudost","sukno","sundat","sunout","surikata","surovina","svah","svalstvo","svetr","svatba","svazek","svisle","svitek","svoboda","svodidlo","svorka","svrab","sykavka","sykot","synek","synovec","sypat","sypkost","syrovost","sysel","sytost","tabletka","tabule","tahoun","tajemno","tajfun","tajga","tajit","tajnost","taktika","tamhle","tampon","tancovat","tanec","tanker","tapeta","tavenina","tazatel","technika","tehdy","tekutina","telefon","temnota","tendence","tenista","tenor","teplota","tepna","teprve","terapie","termoska","textil","ticho","tiskopis","titulek","tkadlec","tkanina","tlapka","tleskat","tlukot","tlupa","tmel","toaleta","topinka","topol","torzo","touha","toulec","tradice","traktor","tramp","trasa","traverza","trefit","trest","trezor","trhavina","trhlina","trochu","trojice","troska","trouba","trpce","trpitel","trpkost","trubec","truchlit","truhlice","trus","trvat","tudy","tuhnout","tuhost","tundra","turista","turnaj","tuzemsko","tvaroh","tvorba","tvrdost","tvrz","tygr","tykev","ubohost","uboze","ubrat","ubrousek","ubrus","ubytovna","ucho","uctivost","udivit","uhradit","ujednat","ujistit","ujmout","ukazatel","uklidnit","uklonit","ukotvit","ukrojit","ulice","ulita","ulovit","umyvadlo","unavit","uniforma","uniknout","upadnout","uplatnit","uplynout","upoutat","upravit","uran","urazit","usednout","usilovat","usmrtit","usnadnit","usnout","usoudit","ustlat","ustrnout","utahovat","utkat","utlumit","utonout","utopenec","utrousit","uvalit","uvolnit","uvozovka","uzdravit","uzel","uzenina","uzlina","uznat","vagon","valcha","valoun","vana","vandal","vanilka","varan","varhany","varovat","vcelku","vchod","vdova","vedro","vegetace","vejce","velbloud","veletrh","velitel","velmoc","velryba","venkov","veranda","verze","veselka","veskrze","vesnice","vespodu","vesta","veterina","veverka","vibrace","vichr","videohra","vidina","vidle","vila","vinice","viset","vitalita","vize","vizitka","vjezd","vklad","vkus","vlajka","vlak","vlasec","vlevo","vlhkost","vliv","vlnovka","vloupat","vnucovat","vnuk","voda","vodivost","vodoznak","vodstvo","vojensky","vojna","vojsko","volant","volba","volit","volno","voskovka","vozidlo","vozovna","vpravo","vrabec","vracet","vrah","vrata","vrba","vrcholek","vrhat","vrstva","vrtule","vsadit","vstoupit","vstup","vtip","vybavit","vybrat","vychovat","vydat","vydra","vyfotit","vyhledat","vyhnout","vyhodit","vyhradit","vyhubit","vyjasnit","vyjet","vyjmout","vyklopit","vykonat","vylekat","vymazat","vymezit","vymizet","vymyslet","vynechat","vynikat","vynutit","vypadat","vyplatit","vypravit","vypustit","vyrazit","vyrovnat","vyrvat","vyslovit","vysoko","vystavit","vysunout","vysypat","vytasit","vytesat","vytratit","vyvinout","vyvolat","vyvrhel","vyzdobit","vyznat","vzadu","vzbudit","vzchopit","vzdor","vzduch","vzdychat","vzestup","vzhledem","vzkaz","vzlykat","vznik","vzorek","vzpoura","vztah","vztek","xylofon","zabrat","zabydlet","zachovat","zadarmo","zadusit","zafoukat","zahltit","zahodit","zahrada","zahynout","zajatec","zajet","zajistit","zaklepat","zakoupit","zalepit","zamezit","zamotat","zamyslet","zanechat","zanikat","zaplatit","zapojit","zapsat","zarazit","zastavit","zasunout","zatajit","zatemnit","zatknout","zaujmout","zavalit","zavelet","zavinit","zavolat","zavrtat","zazvonit","zbavit","zbrusu","zbudovat","zbytek","zdaleka","zdarma","zdatnost","zdivo","zdobit","zdroj","zdvih","zdymadlo","zelenina","zeman","zemina","zeptat","zezadu","zezdola","zhatit","zhltnout","zhluboka","zhotovit","zhruba","zima","zimnice","zjemnit","zklamat","zkoumat","zkratka","zkumavka","zlato","zlehka","zloba","zlom","zlost","zlozvyk","zmapovat","zmar","zmatek","zmije","zmizet","zmocnit","zmodrat","zmrzlina","zmutovat","znak","znalost","znamenat","znovu","zobrazit","zotavit","zoubek","zoufale","zplodit","zpomalit","zprava","zprostit","zprudka","zprvu","zrada","zranit","zrcadlo","zrnitost","zrno","zrovna","zrychlit","zrzavost","zticha","ztratit","zubovina","zubr","zvednout","zvenku","zvesela","zvon","zvrat","zvukovod","zvyk"]')},4573:e=>{"use strict";e.exports=JSON.parse('["abandon","ability","able","about","above","absent","absorb","abstract","absurd","abuse","access","accident","account","accuse","achieve","acid","acoustic","acquire","across","act","action","actor","actress","actual","adapt","add","addict","address","adjust","admit","adult","advance","advice","aerobic","affair","afford","afraid","again","age","agent","agree","ahead","aim","air","airport","aisle","alarm","album","alcohol","alert","alien","all","alley","allow","almost","alone","alpha","already","also","alter","always","amateur","amazing","among","amount","amused","analyst","anchor","ancient","anger","angle","angry","animal","ankle","announce","annual","another","answer","antenna","antique","anxiety","any","apart","apology","appear","apple","approve","april","arch","arctic","area","arena","argue","arm","armed","armor","army","around","arrange","arrest","arrive","arrow","art","artefact","artist","artwork","ask","aspect","assault","asset","assist","assume","asthma","athlete","atom","attack","attend","attitude","attract","auction","audit","august","aunt","author","auto","autumn","average","avocado","avoid","awake","aware","away","awesome","awful","awkward","axis","baby","bachelor","bacon","badge","bag","balance","balcony","ball","bamboo","banana","banner","bar","barely","bargain","barrel","base","basic","basket","battle","beach","bean","beauty","because","become","beef","before","begin","behave","behind","believe","below","belt","bench","benefit","best","betray","better","between","beyond","bicycle","bid","bike","bind","biology","bird","birth","bitter","black","blade","blame","blanket","blast","bleak","bless","blind","blood","blossom","blouse","blue","blur","blush","board","boat","body","boil","bomb","bone","bonus","book","boost","border","boring","borrow","boss","bottom","bounce","box","boy","bracket","brain","brand","brass","brave","bread","breeze","brick","bridge","brief","bright","bring","brisk","broccoli","broken","bronze","broom","brother","brown","brush","bubble","buddy","budget","buffalo","build","bulb","bulk","bullet","bundle","bunker","burden","burger","burst","bus","business","busy","butter","buyer","buzz","cabbage","cabin","cable","cactus","cage","cake","call","calm","camera","camp","can","canal","cancel","candy","cannon","canoe","canvas","canyon","capable","capital","captain","car","carbon","card","cargo","carpet","carry","cart","case","cash","casino","castle","casual","cat","catalog","catch","category","cattle","caught","cause","caution","cave","ceiling","celery","cement","census","century","cereal","certain","chair","chalk","champion","change","chaos","chapter","charge","chase","chat","cheap","check","cheese","chef","cherry","chest","chicken","chief","child","chimney","choice","choose","chronic","chuckle","chunk","churn","cigar","cinnamon","circle","citizen","city","civil","claim","clap","clarify","claw","clay","clean","clerk","clever","click","client","cliff","climb","clinic","clip","clock","clog","close","cloth","cloud","clown","club","clump","cluster","clutch","coach","coast","coconut","code","coffee","coil","coin","collect","color","column","combine","come","comfort","comic","common","company","concert","conduct","confirm","congress","connect","consider","control","convince","cook","cool","copper","copy","coral","core","corn","correct","cost","cotton","couch","country","couple","course","cousin","cover","coyote","crack","cradle","craft","cram","crane","crash","crater","crawl","crazy","cream","credit","creek","crew","cricket","crime","crisp","critic","crop","cross","crouch","crowd","crucial","cruel","cruise","crumble","crunch","crush","cry","crystal","cube","culture","cup","cupboard","curious","current","curtain","curve","cushion","custom","cute","cycle","dad","damage","damp","dance","danger","daring","dash","daughter","dawn","day","deal","debate","debris","decade","december","decide","decline","decorate","decrease","deer","defense","define","defy","degree","delay","deliver","demand","demise","denial","dentist","deny","depart","depend","deposit","depth","deputy","derive","describe","desert","design","desk","despair","destroy","detail","detect","develop","device","devote","diagram","dial","diamond","diary","dice","diesel","diet","differ","digital","dignity","dilemma","dinner","dinosaur","direct","dirt","disagree","discover","disease","dish","dismiss","disorder","display","distance","divert","divide","divorce","dizzy","doctor","document","dog","doll","dolphin","domain","donate","donkey","donor","door","dose","double","dove","draft","dragon","drama","drastic","draw","dream","dress","drift","drill","drink","drip","drive","drop","drum","dry","duck","dumb","dune","during","dust","dutch","duty","dwarf","dynamic","eager","eagle","early","earn","earth","easily","east","easy","echo","ecology","economy","edge","edit","educate","effort","egg","eight","either","elbow","elder","electric","elegant","element","elephant","elevator","elite","else","embark","embody","embrace","emerge","emotion","employ","empower","empty","enable","enact","end","endless","endorse","enemy","energy","enforce","engage","engine","enhance","enjoy","enlist","enough","enrich","enroll","ensure","enter","entire","entry","envelope","episode","equal","equip","era","erase","erode","erosion","error","erupt","escape","essay","essence","estate","eternal","ethics","evidence","evil","evoke","evolve","exact","example","excess","exchange","excite","exclude","excuse","execute","exercise","exhaust","exhibit","exile","exist","exit","exotic","expand","expect","expire","explain","expose","express","extend","extra","eye","eyebrow","fabric","face","faculty","fade","faint","faith","fall","false","fame","family","famous","fan","fancy","fantasy","farm","fashion","fat","fatal","father","fatigue","fault","favorite","feature","february","federal","fee","feed","feel","female","fence","festival","fetch","fever","few","fiber","fiction","field","figure","file","film","filter","final","find","fine","finger","finish","fire","firm","first","fiscal","fish","fit","fitness","fix","flag","flame","flash","flat","flavor","flee","flight","flip","float","flock","floor","flower","fluid","flush","fly","foam","focus","fog","foil","fold","follow","food","foot","force","forest","forget","fork","fortune","forum","forward","fossil","foster","found","fox","fragile","frame","frequent","fresh","friend","fringe","frog","front","frost","frown","frozen","fruit","fuel","fun","funny","furnace","fury","future","gadget","gain","galaxy","gallery","game","gap","garage","garbage","garden","garlic","garment","gas","gasp","gate","gather","gauge","gaze","general","genius","genre","gentle","genuine","gesture","ghost","giant","gift","giggle","ginger","giraffe","girl","give","glad","glance","glare","glass","glide","glimpse","globe","gloom","glory","glove","glow","glue","goat","goddess","gold","good","goose","gorilla","gospel","gossip","govern","gown","grab","grace","grain","grant","grape","grass","gravity","great","green","grid","grief","grit","grocery","group","grow","grunt","guard","guess","guide","guilt","guitar","gun","gym","habit","hair","half","hammer","hamster","hand","happy","harbor","hard","harsh","harvest","hat","have","hawk","hazard","head","health","heart","heavy","hedgehog","height","hello","helmet","help","hen","hero","hidden","high","hill","hint","hip","hire","history","hobby","hockey","hold","hole","holiday","hollow","home","honey","hood","hope","horn","horror","horse","hospital","host","hotel","hour","hover","hub","huge","human","humble","humor","hundred","hungry","hunt","hurdle","hurry","hurt","husband","hybrid","ice","icon","idea","identify","idle","ignore","ill","illegal","illness","image","imitate","immense","immune","impact","impose","improve","impulse","inch","include","income","increase","index","indicate","indoor","industry","infant","inflict","inform","inhale","inherit","initial","inject","injury","inmate","inner","innocent","input","inquiry","insane","insect","inside","inspire","install","intact","interest","into","invest","invite","involve","iron","island","isolate","issue","item","ivory","jacket","jaguar","jar","jazz","jealous","jeans","jelly","jewel","job","join","joke","journey","joy","judge","juice","jump","jungle","junior","junk","just","kangaroo","keen","keep","ketchup","key","kick","kid","kidney","kind","kingdom","kiss","kit","kitchen","kite","kitten","kiwi","knee","knife","knock","know","lab","label","labor","ladder","lady","lake","lamp","language","laptop","large","later","latin","laugh","laundry","lava","law","lawn","lawsuit","layer","lazy","leader","leaf","learn","leave","lecture","left","leg","legal","legend","leisure","lemon","lend","length","lens","leopard","lesson","letter","level","liar","liberty","library","license","life","lift","light","like","limb","limit","link","lion","liquid","list","little","live","lizard","load","loan","lobster","local","lock","logic","lonely","long","loop","lottery","loud","lounge","love","loyal","lucky","luggage","lumber","lunar","lunch","luxury","lyrics","machine","mad","magic","magnet","maid","mail","main","major","make","mammal","man","manage","mandate","mango","mansion","manual","maple","marble","march","margin","marine","market","marriage","mask","mass","master","match","material","math","matrix","matter","maximum","maze","meadow","mean","measure","meat","mechanic","medal","media","melody","melt","member","memory","mention","menu","mercy","merge","merit","merry","mesh","message","metal","method","middle","midnight","milk","million","mimic","mind","minimum","minor","minute","miracle","mirror","misery","miss","mistake","mix","mixed","mixture","mobile","model","modify","mom","moment","monitor","monkey","monster","month","moon","moral","more","morning","mosquito","mother","motion","motor","mountain","mouse","move","movie","much","muffin","mule","multiply","muscle","museum","mushroom","music","must","mutual","myself","mystery","myth","naive","name","napkin","narrow","nasty","nation","nature","near","neck","need","negative","neglect","neither","nephew","nerve","nest","net","network","neutral","never","news","next","nice","night","noble","noise","nominee","noodle","normal","north","nose","notable","note","nothing","notice","novel","now","nuclear","number","nurse","nut","oak","obey","object","oblige","obscure","observe","obtain","obvious","occur","ocean","october","odor","off","offer","office","often","oil","okay","old","olive","olympic","omit","once","one","onion","online","only","open","opera","opinion","oppose","option","orange","orbit","orchard","order","ordinary","organ","orient","original","orphan","ostrich","other","outdoor","outer","output","outside","oval","oven","over","own","owner","oxygen","oyster","ozone","pact","paddle","page","pair","palace","palm","panda","panel","panic","panther","paper","parade","parent","park","parrot","party","pass","patch","path","patient","patrol","pattern","pause","pave","payment","peace","peanut","pear","peasant","pelican","pen","penalty","pencil","people","pepper","perfect","permit","person","pet","phone","photo","phrase","physical","piano","picnic","picture","piece","pig","pigeon","pill","pilot","pink","pioneer","pipe","pistol","pitch","pizza","place","planet","plastic","plate","play","please","pledge","pluck","plug","plunge","poem","poet","point","polar","pole","police","pond","pony","pool","popular","portion","position","possible","post","potato","pottery","poverty","powder","power","practice","praise","predict","prefer","prepare","present","pretty","prevent","price","pride","primary","print","priority","prison","private","prize","problem","process","produce","profit","program","project","promote","proof","property","prosper","protect","proud","provide","public","pudding","pull","pulp","pulse","pumpkin","punch","pupil","puppy","purchase","purity","purpose","purse","push","put","puzzle","pyramid","quality","quantum","quarter","question","quick","quit","quiz","quote","rabbit","raccoon","race","rack","radar","radio","rail","rain","raise","rally","ramp","ranch","random","range","rapid","rare","rate","rather","raven","raw","razor","ready","real","reason","rebel","rebuild","recall","receive","recipe","record","recycle","reduce","reflect","reform","refuse","region","regret","regular","reject","relax","release","relief","rely","remain","remember","remind","remove","render","renew","rent","reopen","repair","repeat","replace","report","require","rescue","resemble","resist","resource","response","result","retire","retreat","return","reunion","reveal","review","reward","rhythm","rib","ribbon","rice","rich","ride","ridge","rifle","right","rigid","ring","riot","ripple","risk","ritual","rival","river","road","roast","robot","robust","rocket","romance","roof","rookie","room","rose","rotate","rough","round","route","royal","rubber","rude","rug","rule","run","runway","rural","sad","saddle","sadness","safe","sail","salad","salmon","salon","salt","salute","same","sample","sand","satisfy","satoshi","sauce","sausage","save","say","scale","scan","scare","scatter","scene","scheme","school","science","scissors","scorpion","scout","scrap","screen","script","scrub","sea","search","season","seat","second","secret","section","security","seed","seek","segment","select","sell","seminar","senior","sense","sentence","series","service","session","settle","setup","seven","shadow","shaft","shallow","share","shed","shell","sheriff","shield","shift","shine","ship","shiver","shock","shoe","shoot","shop","short","shoulder","shove","shrimp","shrug","shuffle","shy","sibling","sick","side","siege","sight","sign","silent","silk","silly","silver","similar","simple","since","sing","siren","sister","situate","six","size","skate","sketch","ski","skill","skin","skirt","skull","slab","slam","sleep","slender","slice","slide","slight","slim","slogan","slot","slow","slush","small","smart","smile","smoke","smooth","snack","snake","snap","sniff","snow","soap","soccer","social","sock","soda","soft","solar","soldier","solid","solution","solve","someone","song","soon","sorry","sort","soul","sound","soup","source","south","space","spare","spatial","spawn","speak","special","speed","spell","spend","sphere","spice","spider","spike","spin","spirit","split","spoil","sponsor","spoon","sport","spot","spray","spread","spring","spy","square","squeeze","squirrel","stable","stadium","staff","stage","stairs","stamp","stand","start","state","stay","steak","steel","stem","step","stereo","stick","still","sting","stock","stomach","stone","stool","story","stove","strategy","street","strike","strong","struggle","student","stuff","stumble","style","subject","submit","subway","success","such","sudden","suffer","sugar","suggest","suit","summer","sun","sunny","sunset","super","supply","supreme","sure","surface","surge","surprise","surround","survey","suspect","sustain","swallow","swamp","swap","swarm","swear","sweet","swift","swim","swing","switch","sword","symbol","symptom","syrup","system","table","tackle","tag","tail","talent","talk","tank","tape","target","task","taste","tattoo","taxi","teach","team","tell","ten","tenant","tennis","tent","term","test","text","thank","that","theme","then","theory","there","they","thing","this","thought","three","thrive","throw","thumb","thunder","ticket","tide","tiger","tilt","timber","time","tiny","tip","tired","tissue","title","toast","tobacco","today","toddler","toe","together","toilet","token","tomato","tomorrow","tone","tongue","tonight","tool","tooth","top","topic","topple","torch","tornado","tortoise","toss","total","tourist","toward","tower","town","toy","track","trade","traffic","tragic","train","transfer","trap","trash","travel","tray","treat","tree","trend","trial","tribe","trick","trigger","trim","trip","trophy","trouble","truck","true","truly","trumpet","trust","truth","try","tube","tuition","tumble","tuna","tunnel","turkey","turn","turtle","twelve","twenty","twice","twin","twist","two","type","typical","ugly","umbrella","unable","unaware","uncle","uncover","under","undo","unfair","unfold","unhappy","uniform","unique","unit","universe","unknown","unlock","until","unusual","unveil","update","upgrade","uphold","upon","upper","upset","urban","urge","usage","use","used","useful","useless","usual","utility","vacant","vacuum","vague","valid","valley","valve","van","vanish","vapor","various","vast","vault","vehicle","velvet","vendor","venture","venue","verb","verify","version","very","vessel","veteran","viable","vibrant","vicious","victory","video","view","village","vintage","violin","virtual","virus","visa","visit","visual","vital","vivid","vocal","voice","void","volcano","volume","vote","voyage","wage","wagon","wait","walk","wall","walnut","want","warfare","warm","warrior","wash","wasp","waste","water","wave","way","wealth","weapon","wear","weasel","weather","web","wedding","weekend","weird","welcome","west","wet","whale","what","wheat","wheel","when","where","whip","whisper","wide","width","wife","wild","will","win","window","wine","wing","wink","winner","winter","wire","wisdom","wise","wish","witness","wolf","woman","wonder","wood","wool","word","work","world","worry","worth","wrap","wreck","wrestle","wrist","write","wrong","yard","year","yellow","you","young","youth","zebra","zero","zone","zoo"]')},1848:e=>{"use strict";e.exports=JSON.parse('["abaisser","abandon","abdiquer","abeille","abolir","aborder","aboutir","aboyer","abrasif","abreuver","abriter","abroger","abrupt","absence","absolu","absurde","abusif","abyssal","académie","acajou","acarien","accabler","accepter","acclamer","accolade","accroche","accuser","acerbe","achat","acheter","aciduler","acier","acompte","acquérir","acronyme","acteur","actif","actuel","adepte","adéquat","adhésif","adjectif","adjuger","admettre","admirer","adopter","adorer","adoucir","adresse","adroit","adulte","adverbe","aérer","aéronef","affaire","affecter","affiche","affreux","affubler","agacer","agencer","agile","agiter","agrafer","agréable","agrume","aider","aiguille","ailier","aimable","aisance","ajouter","ajuster","alarmer","alchimie","alerte","algèbre","algue","aliéner","aliment","alléger","alliage","allouer","allumer","alourdir","alpaga","altesse","alvéole","amateur","ambigu","ambre","aménager","amertume","amidon","amiral","amorcer","amour","amovible","amphibie","ampleur","amusant","analyse","anaphore","anarchie","anatomie","ancien","anéantir","angle","angoisse","anguleux","animal","annexer","annonce","annuel","anodin","anomalie","anonyme","anormal","antenne","antidote","anxieux","apaiser","apéritif","aplanir","apologie","appareil","appeler","apporter","appuyer","aquarium","aqueduc","arbitre","arbuste","ardeur","ardoise","argent","arlequin","armature","armement","armoire","armure","arpenter","arracher","arriver","arroser","arsenic","artériel","article","aspect","asphalte","aspirer","assaut","asservir","assiette","associer","assurer","asticot","astre","astuce","atelier","atome","atrium","atroce","attaque","attentif","attirer","attraper","aubaine","auberge","audace","audible","augurer","aurore","automne","autruche","avaler","avancer","avarice","avenir","averse","aveugle","aviateur","avide","avion","aviser","avoine","avouer","avril","axial","axiome","badge","bafouer","bagage","baguette","baignade","balancer","balcon","baleine","balisage","bambin","bancaire","bandage","banlieue","bannière","banquier","barbier","baril","baron","barque","barrage","bassin","bastion","bataille","bateau","batterie","baudrier","bavarder","belette","bélier","belote","bénéfice","berceau","berger","berline","bermuda","besace","besogne","bétail","beurre","biberon","bicycle","bidule","bijou","bilan","bilingue","billard","binaire","biologie","biopsie","biotype","biscuit","bison","bistouri","bitume","bizarre","blafard","blague","blanchir","blessant","blinder","blond","bloquer","blouson","bobard","bobine","boire","boiser","bolide","bonbon","bondir","bonheur","bonifier","bonus","bordure","borne","botte","boucle","boueux","bougie","boulon","bouquin","bourse","boussole","boutique","boxeur","branche","brasier","brave","brebis","brèche","breuvage","bricoler","brigade","brillant","brioche","brique","brochure","broder","bronzer","brousse","broyeur","brume","brusque","brutal","bruyant","buffle","buisson","bulletin","bureau","burin","bustier","butiner","butoir","buvable","buvette","cabanon","cabine","cachette","cadeau","cadre","caféine","caillou","caisson","calculer","calepin","calibre","calmer","calomnie","calvaire","camarade","caméra","camion","campagne","canal","caneton","canon","cantine","canular","capable","caporal","caprice","capsule","capter","capuche","carabine","carbone","caresser","caribou","carnage","carotte","carreau","carton","cascade","casier","casque","cassure","causer","caution","cavalier","caverne","caviar","cédille","ceinture","céleste","cellule","cendrier","censurer","central","cercle","cérébral","cerise","cerner","cerveau","cesser","chagrin","chaise","chaleur","chambre","chance","chapitre","charbon","chasseur","chaton","chausson","chavirer","chemise","chenille","chéquier","chercher","cheval","chien","chiffre","chignon","chimère","chiot","chlorure","chocolat","choisir","chose","chouette","chrome","chute","cigare","cigogne","cimenter","cinéma","cintrer","circuler","cirer","cirque","citerne","citoyen","citron","civil","clairon","clameur","claquer","classe","clavier","client","cligner","climat","clivage","cloche","clonage","cloporte","cobalt","cobra","cocasse","cocotier","coder","codifier","coffre","cogner","cohésion","coiffer","coincer","colère","colibri","colline","colmater","colonel","combat","comédie","commande","compact","concert","conduire","confier","congeler","connoter","consonne","contact","convexe","copain","copie","corail","corbeau","cordage","corniche","corpus","correct","cortège","cosmique","costume","coton","coude","coupure","courage","couteau","couvrir","coyote","crabe","crainte","cravate","crayon","créature","créditer","crémeux","creuser","crevette","cribler","crier","cristal","critère","croire","croquer","crotale","crucial","cruel","crypter","cubique","cueillir","cuillère","cuisine","cuivre","culminer","cultiver","cumuler","cupide","curatif","curseur","cyanure","cycle","cylindre","cynique","daigner","damier","danger","danseur","dauphin","débattre","débiter","déborder","débrider","débutant","décaler","décembre","déchirer","décider","déclarer","décorer","décrire","décupler","dédale","déductif","déesse","défensif","défiler","défrayer","dégager","dégivrer","déglutir","dégrafer","déjeuner","délice","déloger","demander","demeurer","démolir","dénicher","dénouer","dentelle","dénuder","départ","dépenser","déphaser","déplacer","déposer","déranger","dérober","désastre","descente","désert","désigner","désobéir","dessiner","destrier","détacher","détester","détourer","détresse","devancer","devenir","deviner","devoir","diable","dialogue","diamant","dicter","différer","digérer","digital","digne","diluer","dimanche","diminuer","dioxyde","directif","diriger","discuter","disposer","dissiper","distance","divertir","diviser","docile","docteur","dogme","doigt","domaine","domicile","dompter","donateur","donjon","donner","dopamine","dortoir","dorure","dosage","doseur","dossier","dotation","douanier","double","douceur","douter","doyen","dragon","draper","dresser","dribbler","droiture","duperie","duplexe","durable","durcir","dynastie","éblouir","écarter","écharpe","échelle","éclairer","éclipse","éclore","écluse","école","économie","écorce","écouter","écraser","écrémer","écrivain","écrou","écume","écureuil","édifier","éduquer","effacer","effectif","effigie","effort","effrayer","effusion","égaliser","égarer","éjecter","élaborer","élargir","électron","élégant","éléphant","élève","éligible","élitisme","éloge","élucider","éluder","emballer","embellir","embryon","émeraude","émission","emmener","émotion","émouvoir","empereur","employer","emporter","emprise","émulsion","encadrer","enchère","enclave","encoche","endiguer","endosser","endroit","enduire","énergie","enfance","enfermer","enfouir","engager","engin","englober","énigme","enjamber","enjeu","enlever","ennemi","ennuyeux","enrichir","enrobage","enseigne","entasser","entendre","entier","entourer","entraver","énumérer","envahir","enviable","envoyer","enzyme","éolien","épaissir","épargne","épatant","épaule","épicerie","épidémie","épier","épilogue","épine","épisode","épitaphe","époque","épreuve","éprouver","épuisant","équerre","équipe","ériger","érosion","erreur","éruption","escalier","espadon","espèce","espiègle","espoir","esprit","esquiver","essayer","essence","essieu","essorer","estime","estomac","estrade","étagère","étaler","étanche","étatique","éteindre","étendoir","éternel","éthanol","éthique","ethnie","étirer","étoffer","étoile","étonnant","étourdir","étrange","étroit","étude","euphorie","évaluer","évasion","éventail","évidence","éviter","évolutif","évoquer","exact","exagérer","exaucer","exceller","excitant","exclusif","excuse","exécuter","exemple","exercer","exhaler","exhorter","exigence","exiler","exister","exotique","expédier","explorer","exposer","exprimer","exquis","extensif","extraire","exulter","fable","fabuleux","facette","facile","facture","faiblir","falaise","fameux","famille","farceur","farfelu","farine","farouche","fasciner","fatal","fatigue","faucon","fautif","faveur","favori","fébrile","féconder","fédérer","félin","femme","fémur","fendoir","féodal","fermer","féroce","ferveur","festival","feuille","feutre","février","fiasco","ficeler","fictif","fidèle","figure","filature","filetage","filière","filleul","filmer","filou","filtrer","financer","finir","fiole","firme","fissure","fixer","flairer","flamme","flasque","flatteur","fléau","flèche","fleur","flexion","flocon","flore","fluctuer","fluide","fluvial","folie","fonderie","fongible","fontaine","forcer","forgeron","formuler","fortune","fossile","foudre","fougère","fouiller","foulure","fourmi","fragile","fraise","franchir","frapper","frayeur","frégate","freiner","frelon","frémir","frénésie","frère","friable","friction","frisson","frivole","froid","fromage","frontal","frotter","fruit","fugitif","fuite","fureur","furieux","furtif","fusion","futur","gagner","galaxie","galerie","gambader","garantir","gardien","garnir","garrigue","gazelle","gazon","géant","gélatine","gélule","gendarme","général","génie","genou","gentil","géologie","géomètre","géranium","germe","gestuel","geyser","gibier","gicler","girafe","givre","glace","glaive","glisser","globe","gloire","glorieux","golfeur","gomme","gonfler","gorge","gorille","goudron","gouffre","goulot","goupille","gourmand","goutte","graduel","graffiti","graine","grand","grappin","gratuit","gravir","grenat","griffure","griller","grimper","grogner","gronder","grotte","groupe","gruger","grutier","gruyère","guépard","guerrier","guide","guimauve","guitare","gustatif","gymnaste","gyrostat","habitude","hachoir","halte","hameau","hangar","hanneton","haricot","harmonie","harpon","hasard","hélium","hématome","herbe","hérisson","hermine","héron","hésiter","heureux","hiberner","hibou","hilarant","histoire","hiver","homard","hommage","homogène","honneur","honorer","honteux","horde","horizon","horloge","hormone","horrible","houleux","housse","hublot","huileux","humain","humble","humide","humour","hurler","hydromel","hygiène","hymne","hypnose","idylle","ignorer","iguane","illicite","illusion","image","imbiber","imiter","immense","immobile","immuable","impact","impérial","implorer","imposer","imprimer","imputer","incarner","incendie","incident","incliner","incolore","indexer","indice","inductif","inédit","ineptie","inexact","infini","infliger","informer","infusion","ingérer","inhaler","inhiber","injecter","injure","innocent","inoculer","inonder","inscrire","insecte","insigne","insolite","inspirer","instinct","insulter","intact","intense","intime","intrigue","intuitif","inutile","invasion","inventer","inviter","invoquer","ironique","irradier","irréel","irriter","isoler","ivoire","ivresse","jaguar","jaillir","jambe","janvier","jardin","jauger","jaune","javelot","jetable","jeton","jeudi","jeunesse","joindre","joncher","jongler","joueur","jouissif","journal","jovial","joyau","joyeux","jubiler","jugement","junior","jupon","juriste","justice","juteux","juvénile","kayak","kimono","kiosque","label","labial","labourer","lacérer","lactose","lagune","laine","laisser","laitier","lambeau","lamelle","lampe","lanceur","langage","lanterne","lapin","largeur","larme","laurier","lavabo","lavoir","lecture","légal","léger","légume","lessive","lettre","levier","lexique","lézard","liasse","libérer","libre","licence","licorne","liège","lièvre","ligature","ligoter","ligue","limer","limite","limonade","limpide","linéaire","lingot","lionceau","liquide","lisière","lister","lithium","litige","littoral","livreur","logique","lointain","loisir","lombric","loterie","louer","lourd","loutre","louve","loyal","lubie","lucide","lucratif","lueur","lugubre","luisant","lumière","lunaire","lundi","luron","lutter","luxueux","machine","magasin","magenta","magique","maigre","maillon","maintien","mairie","maison","majorer","malaxer","maléfice","malheur","malice","mallette","mammouth","mandater","maniable","manquant","manteau","manuel","marathon","marbre","marchand","mardi","maritime","marqueur","marron","marteler","mascotte","massif","matériel","matière","matraque","maudire","maussade","mauve","maximal","méchant","méconnu","médaille","médecin","méditer","méduse","meilleur","mélange","mélodie","membre","mémoire","menacer","mener","menhir","mensonge","mentor","mercredi","mérite","merle","messager","mesure","métal","météore","méthode","métier","meuble","miauler","microbe","miette","mignon","migrer","milieu","million","mimique","mince","minéral","minimal","minorer","minute","miracle","miroiter","missile","mixte","mobile","moderne","moelleux","mondial","moniteur","monnaie","monotone","monstre","montagne","monument","moqueur","morceau","morsure","mortier","moteur","motif","mouche","moufle","moulin","mousson","mouton","mouvant","multiple","munition","muraille","murène","murmure","muscle","muséum","musicien","mutation","muter","mutuel","myriade","myrtille","mystère","mythique","nageur","nappe","narquois","narrer","natation","nation","nature","naufrage","nautique","navire","nébuleux","nectar","néfaste","négation","négliger","négocier","neige","nerveux","nettoyer","neurone","neutron","neveu","niche","nickel","nitrate","niveau","noble","nocif","nocturne","noirceur","noisette","nomade","nombreux","nommer","normatif","notable","notifier","notoire","nourrir","nouveau","novateur","novembre","novice","nuage","nuancer","nuire","nuisible","numéro","nuptial","nuque","nutritif","obéir","objectif","obliger","obscur","observer","obstacle","obtenir","obturer","occasion","occuper","océan","octobre","octroyer","octupler","oculaire","odeur","odorant","offenser","officier","offrir","ogive","oiseau","oisillon","olfactif","olivier","ombrage","omettre","onctueux","onduler","onéreux","onirique","opale","opaque","opérer","opinion","opportun","opprimer","opter","optique","orageux","orange","orbite","ordonner","oreille","organe","orgueil","orifice","ornement","orque","ortie","osciller","osmose","ossature","otarie","ouragan","ourson","outil","outrager","ouvrage","ovation","oxyde","oxygène","ozone","paisible","palace","palmarès","palourde","palper","panache","panda","pangolin","paniquer","panneau","panorama","pantalon","papaye","papier","papoter","papyrus","paradoxe","parcelle","paresse","parfumer","parler","parole","parrain","parsemer","partager","parure","parvenir","passion","pastèque","paternel","patience","patron","pavillon","pavoiser","payer","paysage","peigne","peintre","pelage","pélican","pelle","pelouse","peluche","pendule","pénétrer","pénible","pensif","pénurie","pépite","péplum","perdrix","perforer","période","permuter","perplexe","persil","perte","peser","pétale","petit","pétrir","peuple","pharaon","phobie","phoque","photon","phrase","physique","piano","pictural","pièce","pierre","pieuvre","pilote","pinceau","pipette","piquer","pirogue","piscine","piston","pivoter","pixel","pizza","placard","plafond","plaisir","planer","plaque","plastron","plateau","pleurer","plexus","pliage","plomb","plonger","pluie","plumage","pochette","poésie","poète","pointe","poirier","poisson","poivre","polaire","policier","pollen","polygone","pommade","pompier","ponctuel","pondérer","poney","portique","position","posséder","posture","potager","poteau","potion","pouce","poulain","poumon","pourpre","poussin","pouvoir","prairie","pratique","précieux","prédire","préfixe","prélude","prénom","présence","prétexte","prévoir","primitif","prince","prison","priver","problème","procéder","prodige","profond","progrès","proie","projeter","prologue","promener","propre","prospère","protéger","prouesse","proverbe","prudence","pruneau","psychose","public","puceron","puiser","pulpe","pulsar","punaise","punitif","pupitre","purifier","puzzle","pyramide","quasar","querelle","question","quiétude","quitter","quotient","racine","raconter","radieux","ragondin","raideur","raisin","ralentir","rallonge","ramasser","rapide","rasage","ratisser","ravager","ravin","rayonner","réactif","réagir","réaliser","réanimer","recevoir","réciter","réclamer","récolter","recruter","reculer","recycler","rédiger","redouter","refaire","réflexe","réformer","refrain","refuge","régalien","région","réglage","régulier","réitérer","rejeter","rejouer","relatif","relever","relief","remarque","remède","remise","remonter","remplir","remuer","renard","renfort","renifler","renoncer","rentrer","renvoi","replier","reporter","reprise","reptile","requin","réserve","résineux","résoudre","respect","rester","résultat","rétablir","retenir","réticule","retomber","retracer","réunion","réussir","revanche","revivre","révolte","révulsif","richesse","rideau","rieur","rigide","rigoler","rincer","riposter","risible","risque","rituel","rival","rivière","rocheux","romance","rompre","ronce","rondin","roseau","rosier","rotatif","rotor","rotule","rouge","rouille","rouleau","routine","royaume","ruban","rubis","ruche","ruelle","rugueux","ruiner","ruisseau","ruser","rustique","rythme","sabler","saboter","sabre","sacoche","safari","sagesse","saisir","salade","salive","salon","saluer","samedi","sanction","sanglier","sarcasme","sardine","saturer","saugrenu","saumon","sauter","sauvage","savant","savonner","scalpel","scandale","scélérat","scénario","sceptre","schéma","science","scinder","score","scrutin","sculpter","séance","sécable","sécher","secouer","sécréter","sédatif","séduire","seigneur","séjour","sélectif","semaine","sembler","semence","séminal","sénateur","sensible","sentence","séparer","séquence","serein","sergent","sérieux","serrure","sérum","service","sésame","sévir","sevrage","sextuple","sidéral","siècle","siéger","siffler","sigle","signal","silence","silicium","simple","sincère","sinistre","siphon","sirop","sismique","situer","skier","social","socle","sodium","soigneux","soldat","soleil","solitude","soluble","sombre","sommeil","somnoler","sonde","songeur","sonnette","sonore","sorcier","sortir","sosie","sottise","soucieux","soudure","souffle","soulever","soupape","source","soutirer","souvenir","spacieux","spatial","spécial","sphère","spiral","stable","station","sternum","stimulus","stipuler","strict","studieux","stupeur","styliste","sublime","substrat","subtil","subvenir","succès","sucre","suffixe","suggérer","suiveur","sulfate","superbe","supplier","surface","suricate","surmener","surprise","sursaut","survie","suspect","syllabe","symbole","symétrie","synapse","syntaxe","système","tabac","tablier","tactile","tailler","talent","talisman","talonner","tambour","tamiser","tangible","tapis","taquiner","tarder","tarif","tartine","tasse","tatami","tatouage","taupe","taureau","taxer","témoin","temporel","tenaille","tendre","teneur","tenir","tension","terminer","terne","terrible","tétine","texte","thème","théorie","thérapie","thorax","tibia","tiède","timide","tirelire","tiroir","tissu","titane","titre","tituber","toboggan","tolérant","tomate","tonique","tonneau","toponyme","torche","tordre","tornade","torpille","torrent","torse","tortue","totem","toucher","tournage","tousser","toxine","traction","trafic","tragique","trahir","train","trancher","travail","trèfle","tremper","trésor","treuil","triage","tribunal","tricoter","trilogie","triomphe","tripler","triturer","trivial","trombone","tronc","tropical","troupeau","tuile","tulipe","tumulte","tunnel","turbine","tuteur","tutoyer","tuyau","tympan","typhon","typique","tyran","ubuesque","ultime","ultrason","unanime","unifier","union","unique","unitaire","univers","uranium","urbain","urticant","usage","usine","usuel","usure","utile","utopie","vacarme","vaccin","vagabond","vague","vaillant","vaincre","vaisseau","valable","valise","vallon","valve","vampire","vanille","vapeur","varier","vaseux","vassal","vaste","vecteur","vedette","végétal","véhicule","veinard","véloce","vendredi","vénérer","venger","venimeux","ventouse","verdure","vérin","vernir","verrou","verser","vertu","veston","vétéran","vétuste","vexant","vexer","viaduc","viande","victoire","vidange","vidéo","vignette","vigueur","vilain","village","vinaigre","violon","vipère","virement","virtuose","virus","visage","viseur","vision","visqueux","visuel","vital","vitesse","viticole","vitrine","vivace","vivipare","vocation","voguer","voile","voisin","voiture","volaille","volcan","voltiger","volume","vorace","vortex","voter","vouloir","voyage","voyelle","wagon","xénon","yacht","zèbre","zénith","zeste","zoologie"]')},2841:e=>{"use strict";e.exports=JSON.parse('["abaco","abbaglio","abbinato","abete","abisso","abolire","abrasivo","abrogato","accadere","accenno","accusato","acetone","achille","acido","acqua","acre","acrilico","acrobata","acuto","adagio","addebito","addome","adeguato","aderire","adipe","adottare","adulare","affabile","affetto","affisso","affranto","aforisma","afoso","africano","agave","agente","agevole","aggancio","agire","agitare","agonismo","agricolo","agrumeto","aguzzo","alabarda","alato","albatro","alberato","albo","albume","alce","alcolico","alettone","alfa","algebra","aliante","alibi","alimento","allagato","allegro","allievo","allodola","allusivo","almeno","alogeno","alpaca","alpestre","altalena","alterno","alticcio","altrove","alunno","alveolo","alzare","amalgama","amanita","amarena","ambito","ambrato","ameba","america","ametista","amico","ammasso","ammenda","ammirare","ammonito","amore","ampio","ampliare","amuleto","anacardo","anagrafe","analista","anarchia","anatra","anca","ancella","ancora","andare","andrea","anello","angelo","angolare","angusto","anima","annegare","annidato","anno","annuncio","anonimo","anticipo","anzi","apatico","apertura","apode","apparire","appetito","appoggio","approdo","appunto","aprile","arabica","arachide","aragosta","araldica","arancio","aratura","arazzo","arbitro","archivio","ardito","arenile","argento","argine","arguto","aria","armonia","arnese","arredato","arringa","arrosto","arsenico","arso","artefice","arzillo","asciutto","ascolto","asepsi","asettico","asfalto","asino","asola","aspirato","aspro","assaggio","asse","assoluto","assurdo","asta","astenuto","astice","astratto","atavico","ateismo","atomico","atono","attesa","attivare","attorno","attrito","attuale","ausilio","austria","autista","autonomo","autunno","avanzato","avere","avvenire","avviso","avvolgere","azione","azoto","azzimo","azzurro","babele","baccano","bacino","baco","badessa","badilata","bagnato","baita","balcone","baldo","balena","ballata","balzano","bambino","bandire","baraonda","barbaro","barca","baritono","barlume","barocco","basilico","basso","batosta","battuto","baule","bava","bavosa","becco","beffa","belgio","belva","benda","benevole","benigno","benzina","bere","berlina","beta","bibita","bici","bidone","bifido","biga","bilancia","bimbo","binocolo","biologo","bipede","bipolare","birbante","birra","biscotto","bisesto","bisnonno","bisonte","bisturi","bizzarro","blando","blatta","bollito","bonifico","bordo","bosco","botanico","bottino","bozzolo","braccio","bradipo","brama","branca","bravura","bretella","brevetto","brezza","briglia","brillante","brindare","broccolo","brodo","bronzina","brullo","bruno","bubbone","buca","budino","buffone","buio","bulbo","buono","burlone","burrasca","bussola","busta","cadetto","caduco","calamaro","calcolo","calesse","calibro","calmo","caloria","cambusa","camerata","camicia","cammino","camola","campale","canapa","candela","cane","canino","canotto","cantina","capace","capello","capitolo","capogiro","cappero","capra","capsula","carapace","carcassa","cardo","carisma","carovana","carretto","cartolina","casaccio","cascata","caserma","caso","cassone","castello","casuale","catasta","catena","catrame","cauto","cavillo","cedibile","cedrata","cefalo","celebre","cellulare","cena","cenone","centesimo","ceramica","cercare","certo","cerume","cervello","cesoia","cespo","ceto","chela","chiaro","chicca","chiedere","chimera","china","chirurgo","chitarra","ciao","ciclismo","cifrare","cigno","cilindro","ciottolo","circa","cirrosi","citrico","cittadino","ciuffo","civetta","civile","classico","clinica","cloro","cocco","codardo","codice","coerente","cognome","collare","colmato","colore","colposo","coltivato","colza","coma","cometa","commando","comodo","computer","comune","conciso","condurre","conferma","congelare","coniuge","connesso","conoscere","consumo","continuo","convegno","coperto","copione","coppia","copricapo","corazza","cordata","coricato","cornice","corolla","corpo","corredo","corsia","cortese","cosmico","costante","cottura","covato","cratere","cravatta","creato","credere","cremoso","crescita","creta","criceto","crinale","crisi","critico","croce","cronaca","crostata","cruciale","crusca","cucire","cuculo","cugino","cullato","cupola","curatore","cursore","curvo","cuscino","custode","dado","daino","dalmata","damerino","daniela","dannoso","danzare","datato","davanti","davvero","debutto","decennio","deciso","declino","decollo","decreto","dedicato","definito","deforme","degno","delegare","delfino","delirio","delta","demenza","denotato","dentro","deposito","derapata","derivare","deroga","descritto","deserto","desiderio","desumere","detersivo","devoto","diametro","dicembre","diedro","difeso","diffuso","digerire","digitale","diluvio","dinamico","dinnanzi","dipinto","diploma","dipolo","diradare","dire","dirotto","dirupo","disagio","discreto","disfare","disgelo","disposto","distanza","disumano","dito","divano","divelto","dividere","divorato","doblone","docente","doganale","dogma","dolce","domato","domenica","dominare","dondolo","dono","dormire","dote","dottore","dovuto","dozzina","drago","druido","dubbio","dubitare","ducale","duna","duomo","duplice","duraturo","ebano","eccesso","ecco","eclissi","economia","edera","edicola","edile","editoria","educare","egemonia","egli","egoismo","egregio","elaborato","elargire","elegante","elencato","eletto","elevare","elfico","elica","elmo","elsa","eluso","emanato","emblema","emesso","emiro","emotivo","emozione","empirico","emulo","endemico","enduro","energia","enfasi","enoteca","entrare","enzima","epatite","epilogo","episodio","epocale","eppure","equatore","erario","erba","erboso","erede","eremita","erigere","ermetico","eroe","erosivo","errante","esagono","esame","esanime","esaudire","esca","esempio","esercito","esibito","esigente","esistere","esito","esofago","esortato","esoso","espanso","espresso","essenza","esso","esteso","estimare","estonia","estroso","esultare","etilico","etnico","etrusco","etto","euclideo","europa","evaso","evidenza","evitato","evoluto","evviva","fabbrica","faccenda","fachiro","falco","famiglia","fanale","fanfara","fango","fantasma","fare","farfalla","farinoso","farmaco","fascia","fastoso","fasullo","faticare","fato","favoloso","febbre","fecola","fede","fegato","felpa","feltro","femmina","fendere","fenomeno","fermento","ferro","fertile","fessura","festivo","fetta","feudo","fiaba","fiducia","fifa","figurato","filo","finanza","finestra","finire","fiore","fiscale","fisico","fiume","flacone","flamenco","flebo","flemma","florido","fluente","fluoro","fobico","focaccia","focoso","foderato","foglio","folata","folclore","folgore","fondente","fonetico","fonia","fontana","forbito","forchetta","foresta","formica","fornaio","foro","fortezza","forzare","fosfato","fosso","fracasso","frana","frassino","fratello","freccetta","frenata","fresco","frigo","frollino","fronde","frugale","frutta","fucilata","fucsia","fuggente","fulmine","fulvo","fumante","fumetto","fumoso","fune","funzione","fuoco","furbo","furgone","furore","fuso","futile","gabbiano","gaffe","galateo","gallina","galoppo","gambero","gamma","garanzia","garbo","garofano","garzone","gasdotto","gasolio","gastrico","gatto","gaudio","gazebo","gazzella","geco","gelatina","gelso","gemello","gemmato","gene","genitore","gennaio","genotipo","gergo","ghepardo","ghiaccio","ghisa","giallo","gilda","ginepro","giocare","gioiello","giorno","giove","girato","girone","gittata","giudizio","giurato","giusto","globulo","glutine","gnomo","gobba","golf","gomito","gommone","gonfio","gonna","governo","gracile","grado","grafico","grammo","grande","grattare","gravoso","grazia","greca","gregge","grifone","grigio","grinza","grotta","gruppo","guadagno","guaio","guanto","guardare","gufo","guidare","ibernato","icona","identico","idillio","idolo","idra","idrico","idrogeno","igiene","ignaro","ignorato","ilare","illeso","illogico","illudere","imballo","imbevuto","imbocco","imbuto","immane","immerso","immolato","impacco","impeto","impiego","importo","impronta","inalare","inarcare","inattivo","incanto","incendio","inchino","incisivo","incluso","incontro","incrocio","incubo","indagine","india","indole","inedito","infatti","infilare","inflitto","ingaggio","ingegno","inglese","ingordo","ingrosso","innesco","inodore","inoltrare","inondato","insano","insetto","insieme","insonnia","insulina","intasato","intero","intonaco","intuito","inumidire","invalido","invece","invito","iperbole","ipnotico","ipotesi","ippica","iride","irlanda","ironico","irrigato","irrorare","isolato","isotopo","isterico","istituto","istrice","italia","iterare","labbro","labirinto","lacca","lacerato","lacrima","lacuna","laddove","lago","lampo","lancetta","lanterna","lardoso","larga","laringe","lastra","latenza","latino","lattuga","lavagna","lavoro","legale","leggero","lembo","lentezza","lenza","leone","lepre","lesivo","lessato","lesto","letterale","leva","levigato","libero","lido","lievito","lilla","limatura","limitare","limpido","lineare","lingua","liquido","lira","lirica","lisca","lite","litigio","livrea","locanda","lode","logica","lombare","londra","longevo","loquace","lorenzo","loto","lotteria","luce","lucidato","lumaca","luminoso","lungo","lupo","luppolo","lusinga","lusso","lutto","macabro","macchina","macero","macinato","madama","magico","maglia","magnete","magro","maiolica","malafede","malgrado","malinteso","malsano","malto","malumore","mana","mancia","mandorla","mangiare","manifesto","mannaro","manovra","mansarda","mantide","manubrio","mappa","maratona","marcire","maretta","marmo","marsupio","maschera","massaia","mastino","materasso","matricola","mattone","maturo","mazurca","meandro","meccanico","mecenate","medesimo","meditare","mega","melassa","melis","melodia","meninge","meno","mensola","mercurio","merenda","merlo","meschino","mese","messere","mestolo","metallo","metodo","mettere","miagolare","mica","micelio","michele","microbo","midollo","miele","migliore","milano","milite","mimosa","minerale","mini","minore","mirino","mirtillo","miscela","missiva","misto","misurare","mitezza","mitigare","mitra","mittente","mnemonico","modello","modifica","modulo","mogano","mogio","mole","molosso","monastero","monco","mondina","monetario","monile","monotono","monsone","montato","monviso","mora","mordere","morsicato","mostro","motivato","motosega","motto","movenza","movimento","mozzo","mucca","mucosa","muffa","mughetto","mugnaio","mulatto","mulinello","multiplo","mummia","munto","muovere","murale","musa","muscolo","musica","mutevole","muto","nababbo","nafta","nanometro","narciso","narice","narrato","nascere","nastrare","naturale","nautica","naviglio","nebulosa","necrosi","negativo","negozio","nemmeno","neofita","neretto","nervo","nessuno","nettuno","neutrale","neve","nevrotico","nicchia","ninfa","nitido","nobile","nocivo","nodo","nome","nomina","nordico","normale","norvegese","nostrano","notare","notizia","notturno","novella","nucleo","nulla","numero","nuovo","nutrire","nuvola","nuziale","oasi","obbedire","obbligo","obelisco","oblio","obolo","obsoleto","occasione","occhio","occidente","occorrere","occultare","ocra","oculato","odierno","odorare","offerta","offrire","offuscato","oggetto","oggi","ognuno","olandese","olfatto","oliato","oliva","ologramma","oltre","omaggio","ombelico","ombra","omega","omissione","ondoso","onere","onice","onnivoro","onorevole","onta","operato","opinione","opposto","oracolo","orafo","ordine","orecchino","orefice","orfano","organico","origine","orizzonte","orma","ormeggio","ornativo","orologio","orrendo","orribile","ortensia","ortica","orzata","orzo","osare","oscurare","osmosi","ospedale","ospite","ossa","ossidare","ostacolo","oste","otite","otre","ottagono","ottimo","ottobre","ovale","ovest","ovino","oviparo","ovocito","ovunque","ovviare","ozio","pacchetto","pace","pacifico","padella","padrone","paese","paga","pagina","palazzina","palesare","pallido","palo","palude","pandoro","pannello","paolo","paonazzo","paprica","parabola","parcella","parere","pargolo","pari","parlato","parola","partire","parvenza","parziale","passivo","pasticca","patacca","patologia","pattume","pavone","peccato","pedalare","pedonale","peggio","peloso","penare","pendice","penisola","pennuto","penombra","pensare","pentola","pepe","pepita","perbene","percorso","perdonato","perforare","pergamena","periodo","permesso","perno","perplesso","persuaso","pertugio","pervaso","pesatore","pesista","peso","pestifero","petalo","pettine","petulante","pezzo","piacere","pianta","piattino","piccino","picozza","piega","pietra","piffero","pigiama","pigolio","pigro","pila","pilifero","pillola","pilota","pimpante","pineta","pinna","pinolo","pioggia","piombo","piramide","piretico","pirite","pirolisi","pitone","pizzico","placebo","planare","plasma","platano","plenario","pochezza","poderoso","podismo","poesia","poggiare","polenta","poligono","pollice","polmonite","polpetta","polso","poltrona","polvere","pomice","pomodoro","ponte","popoloso","porfido","poroso","porpora","porre","portata","posa","positivo","possesso","postulato","potassio","potere","pranzo","prassi","pratica","precluso","predica","prefisso","pregiato","prelievo","premere","prenotare","preparato","presenza","pretesto","prevalso","prima","principe","privato","problema","procura","produrre","profumo","progetto","prolunga","promessa","pronome","proposta","proroga","proteso","prova","prudente","prugna","prurito","psiche","pubblico","pudica","pugilato","pugno","pulce","pulito","pulsante","puntare","pupazzo","pupilla","puro","quadro","qualcosa","quasi","querela","quota","raccolto","raddoppio","radicale","radunato","raffica","ragazzo","ragione","ragno","ramarro","ramingo","ramo","randagio","rantolare","rapato","rapina","rappreso","rasatura","raschiato","rasente","rassegna","rastrello","rata","ravveduto","reale","recepire","recinto","recluta","recondito","recupero","reddito","redimere","regalato","registro","regola","regresso","relazione","remare","remoto","renna","replica","reprimere","reputare","resa","residente","responso","restauro","rete","retina","retorica","rettifica","revocato","riassunto","ribadire","ribelle","ribrezzo","ricarica","ricco","ricevere","riciclato","ricordo","ricreduto","ridicolo","ridurre","rifasare","riflesso","riforma","rifugio","rigare","rigettato","righello","rilassato","rilevato","rimanere","rimbalzo","rimedio","rimorchio","rinascita","rincaro","rinforzo","rinnovo","rinomato","rinsavito","rintocco","rinuncia","rinvenire","riparato","ripetuto","ripieno","riportare","ripresa","ripulire","risata","rischio","riserva","risibile","riso","rispetto","ristoro","risultato","risvolto","ritardo","ritegno","ritmico","ritrovo","riunione","riva","riverso","rivincita","rivolto","rizoma","roba","robotico","robusto","roccia","roco","rodaggio","rodere","roditore","rogito","rollio","romantico","rompere","ronzio","rosolare","rospo","rotante","rotondo","rotula","rovescio","rubizzo","rubrica","ruga","rullino","rumine","rumoroso","ruolo","rupe","russare","rustico","sabato","sabbiare","sabotato","sagoma","salasso","saldatura","salgemma","salivare","salmone","salone","saltare","saluto","salvo","sapere","sapido","saporito","saraceno","sarcasmo","sarto","sassoso","satellite","satira","satollo","saturno","savana","savio","saziato","sbadiglio","sbalzo","sbancato","sbarra","sbattere","sbavare","sbendare","sbirciare","sbloccato","sbocciato","sbrinare","sbruffone","sbuffare","scabroso","scadenza","scala","scambiare","scandalo","scapola","scarso","scatenare","scavato","scelto","scenico","scettro","scheda","schiena","sciarpa","scienza","scindere","scippo","sciroppo","scivolo","sclerare","scodella","scolpito","scomparto","sconforto","scoprire","scorta","scossone","scozzese","scriba","scrollare","scrutinio","scuderia","scultore","scuola","scuro","scusare","sdebitare","sdoganare","seccatura","secondo","sedano","seggiola","segnalato","segregato","seguito","selciato","selettivo","sella","selvaggio","semaforo","sembrare","seme","seminato","sempre","senso","sentire","sepolto","sequenza","serata","serbato","sereno","serio","serpente","serraglio","servire","sestina","setola","settimana","sfacelo","sfaldare","sfamato","sfarzoso","sfaticato","sfera","sfida","sfilato","sfinge","sfocato","sfoderare","sfogo","sfoltire","sforzato","sfratto","sfruttato","sfuggito","sfumare","sfuso","sgabello","sgarbato","sgonfiare","sgorbio","sgrassato","sguardo","sibilo","siccome","sierra","sigla","signore","silenzio","sillaba","simbolo","simpatico","simulato","sinfonia","singolo","sinistro","sino","sintesi","sinusoide","sipario","sisma","sistole","situato","slitta","slogatura","sloveno","smarrito","smemorato","smentito","smeraldo","smilzo","smontare","smottato","smussato","snellire","snervato","snodo","sobbalzo","sobrio","soccorso","sociale","sodale","soffitto","sogno","soldato","solenne","solido","sollazzo","solo","solubile","solvente","somatico","somma","sonda","sonetto","sonnifero","sopire","soppeso","sopra","sorgere","sorpasso","sorriso","sorso","sorteggio","sorvolato","sospiro","sosta","sottile","spada","spalla","spargere","spatola","spavento","spazzola","specie","spedire","spegnere","spelatura","speranza","spessore","spettrale","spezzato","spia","spigoloso","spillato","spinoso","spirale","splendido","sportivo","sposo","spranga","sprecare","spronato","spruzzo","spuntino","squillo","sradicare","srotolato","stabile","stacco","staffa","stagnare","stampato","stantio","starnuto","stasera","statuto","stelo","steppa","sterzo","stiletto","stima","stirpe","stivale","stizzoso","stonato","storico","strappo","stregato","stridulo","strozzare","strutto","stuccare","stufo","stupendo","subentro","succoso","sudore","suggerito","sugo","sultano","suonare","superbo","supporto","surgelato","surrogato","sussurro","sutura","svagare","svedese","sveglio","svelare","svenuto","svezia","sviluppo","svista","svizzera","svolta","svuotare","tabacco","tabulato","tacciare","taciturno","tale","talismano","tampone","tannino","tara","tardivo","targato","tariffa","tarpare","tartaruga","tasto","tattico","taverna","tavolata","tazza","teca","tecnico","telefono","temerario","tempo","temuto","tendone","tenero","tensione","tentacolo","teorema","terme","terrazzo","terzetto","tesi","tesserato","testato","tetro","tettoia","tifare","tigella","timbro","tinto","tipico","tipografo","tiraggio","tiro","titanio","titolo","titubante","tizio","tizzone","toccare","tollerare","tolto","tombola","tomo","tonfo","tonsilla","topazio","topologia","toppa","torba","tornare","torrone","tortora","toscano","tossire","tostatura","totano","trabocco","trachea","trafila","tragedia","tralcio","tramonto","transito","trapano","trarre","trasloco","trattato","trave","treccia","tremolio","trespolo","tributo","tricheco","trifoglio","trillo","trincea","trio","tristezza","triturato","trivella","tromba","trono","troppo","trottola","trovare","truccato","tubatura","tuffato","tulipano","tumulto","tunisia","turbare","turchino","tuta","tutela","ubicato","uccello","uccisore","udire","uditivo","uffa","ufficio","uguale","ulisse","ultimato","umano","umile","umorismo","uncinetto","ungere","ungherese","unicorno","unificato","unisono","unitario","unte","uovo","upupa","uragano","urgenza","urlo","usanza","usato","uscito","usignolo","usuraio","utensile","utilizzo","utopia","vacante","vaccinato","vagabondo","vagliato","valanga","valgo","valico","valletta","valoroso","valutare","valvola","vampata","vangare","vanitoso","vano","vantaggio","vanvera","vapore","varano","varcato","variante","vasca","vedetta","vedova","veduto","vegetale","veicolo","velcro","velina","velluto","veloce","venato","vendemmia","vento","verace","verbale","vergogna","verifica","vero","verruca","verticale","vescica","vessillo","vestale","veterano","vetrina","vetusto","viandante","vibrante","vicenda","vichingo","vicinanza","vidimare","vigilia","vigneto","vigore","vile","villano","vimini","vincitore","viola","vipera","virgola","virologo","virulento","viscoso","visione","vispo","vissuto","visura","vita","vitello","vittima","vivanda","vivido","viziare","voce","voga","volatile","volere","volpe","voragine","vulcano","zampogna","zanna","zappato","zattera","zavorra","zefiro","zelante","zelo","zenzero","zerbino","zibetto","zinco","zircone","zitto","zolla","zotico","zucchero","zufolo","zulu","zuppa"]')},4472:e=>{"use strict";e.exports=JSON.parse('["あいこくしん","あいさつ","あいだ","あおぞら","あかちゃん","あきる","あけがた","あける","あこがれる","あさい","あさひ","あしあと","あじわう","あずかる","あずき","あそぶ","あたえる","あたためる","あたりまえ","あたる","あつい","あつかう","あっしゅく","あつまり","あつめる","あてな","あてはまる","あひる","あぶら","あぶる","あふれる","あまい","あまど","あまやかす","あまり","あみもの","あめりか","あやまる","あゆむ","あらいぐま","あらし","あらすじ","あらためる","あらゆる","あらわす","ありがとう","あわせる","あわてる","あんい","あんがい","あんこ","あんぜん","あんてい","あんない","あんまり","いいだす","いおん","いがい","いがく","いきおい","いきなり","いきもの","いきる","いくじ","いくぶん","いけばな","いけん","いこう","いこく","いこつ","いさましい","いさん","いしき","いじゅう","いじょう","いじわる","いずみ","いずれ","いせい","いせえび","いせかい","いせき","いぜん","いそうろう","いそがしい","いだい","いだく","いたずら","いたみ","いたりあ","いちおう","いちじ","いちど","いちば","いちぶ","いちりゅう","いつか","いっしゅん","いっせい","いっそう","いったん","いっち","いってい","いっぽう","いてざ","いてん","いどう","いとこ","いない","いなか","いねむり","いのち","いのる","いはつ","いばる","いはん","いびき","いひん","いふく","いへん","いほう","いみん","いもうと","いもたれ","いもり","いやがる","いやす","いよかん","いよく","いらい","いらすと","いりぐち","いりょう","いれい","いれもの","いれる","いろえんぴつ","いわい","いわう","いわかん","いわば","いわゆる","いんげんまめ","いんさつ","いんしょう","いんよう","うえき","うえる","うおざ","うがい","うかぶ","うかべる","うきわ","うくらいな","うくれれ","うけたまわる","うけつけ","うけとる","うけもつ","うける","うごかす","うごく","うこん","うさぎ","うしなう","うしろがみ","うすい","うすぎ","うすぐらい","うすめる","うせつ","うちあわせ","うちがわ","うちき","うちゅう","うっかり","うつくしい","うったえる","うつる","うどん","うなぎ","うなじ","うなずく","うなる","うねる","うのう","うぶげ","うぶごえ","うまれる","うめる","うもう","うやまう","うよく","うらがえす","うらぐち","うらない","うりあげ","うりきれ","うるさい","うれしい","うれゆき","うれる","うろこ","うわき","うわさ","うんこう","うんちん","うんてん","うんどう","えいえん","えいが","えいきょう","えいご","えいせい","えいぶん","えいよう","えいわ","えおり","えがお","えがく","えきたい","えくせる","えしゃく","えすて","えつらん","えのぐ","えほうまき","えほん","えまき","えもじ","えもの","えらい","えらぶ","えりあ","えんえん","えんかい","えんぎ","えんげき","えんしゅう","えんぜつ","えんそく","えんちょう","えんとつ","おいかける","おいこす","おいしい","おいつく","おうえん","おうさま","おうじ","おうせつ","おうたい","おうふく","おうべい","おうよう","おえる","おおい","おおう","おおどおり","おおや","おおよそ","おかえり","おかず","おがむ","おかわり","おぎなう","おきる","おくさま","おくじょう","おくりがな","おくる","おくれる","おこす","おこなう","おこる","おさえる","おさない","おさめる","おしいれ","おしえる","おじぎ","おじさん","おしゃれ","おそらく","おそわる","おたがい","おたく","おだやか","おちつく","おっと","おつり","おでかけ","おとしもの","おとなしい","おどり","おどろかす","おばさん","おまいり","おめでとう","おもいで","おもう","おもたい","おもちゃ","おやつ","おやゆび","およぼす","おらんだ","おろす","おんがく","おんけい","おんしゃ","おんせん","おんだん","おんちゅう","おんどけい","かあつ","かいが","がいき","がいけん","がいこう","かいさつ","かいしゃ","かいすいよく","かいぜん","かいぞうど","かいつう","かいてん","かいとう","かいふく","がいへき","かいほう","かいよう","がいらい","かいわ","かえる","かおり","かかえる","かがく","かがし","かがみ","かくご","かくとく","かざる","がぞう","かたい","かたち","がちょう","がっきゅう","がっこう","がっさん","がっしょう","かなざわし","かのう","がはく","かぶか","かほう","かほご","かまう","かまぼこ","かめれおん","かゆい","かようび","からい","かるい","かろう","かわく","かわら","がんか","かんけい","かんこう","かんしゃ","かんそう","かんたん","かんち","がんばる","きあい","きあつ","きいろ","ぎいん","きうい","きうん","きえる","きおう","きおく","きおち","きおん","きかい","きかく","きかんしゃ","ききて","きくばり","きくらげ","きけんせい","きこう","きこえる","きこく","きさい","きさく","きさま","きさらぎ","ぎじかがく","ぎしき","ぎじたいけん","ぎじにってい","ぎじゅつしゃ","きすう","きせい","きせき","きせつ","きそう","きぞく","きぞん","きたえる","きちょう","きつえん","ぎっちり","きつつき","きつね","きてい","きどう","きどく","きない","きなが","きなこ","きぬごし","きねん","きのう","きのした","きはく","きびしい","きひん","きふく","きぶん","きぼう","きほん","きまる","きみつ","きむずかしい","きめる","きもだめし","きもち","きもの","きゃく","きやく","ぎゅうにく","きよう","きょうりゅう","きらい","きらく","きりん","きれい","きれつ","きろく","ぎろん","きわめる","ぎんいろ","きんかくじ","きんじょ","きんようび","ぐあい","くいず","くうかん","くうき","くうぐん","くうこう","ぐうせい","くうそう","ぐうたら","くうふく","くうぼ","くかん","くきょう","くげん","ぐこう","くさい","くさき","くさばな","くさる","くしゃみ","くしょう","くすのき","くすりゆび","くせげ","くせん","ぐたいてき","くださる","くたびれる","くちこみ","くちさき","くつした","ぐっすり","くつろぐ","くとうてん","くどく","くなん","くねくね","くのう","くふう","くみあわせ","くみたてる","くめる","くやくしょ","くらす","くらべる","くるま","くれる","くろう","くわしい","ぐんかん","ぐんしょく","ぐんたい","ぐんて","けあな","けいかく","けいけん","けいこ","けいさつ","げいじゅつ","けいたい","げいのうじん","けいれき","けいろ","けおとす","けおりもの","げきか","げきげん","げきだん","げきちん","げきとつ","げきは","げきやく","げこう","げこくじょう","げざい","けさき","げざん","けしき","けしごむ","けしょう","げすと","けたば","けちゃっぷ","けちらす","けつあつ","けつい","けつえき","けっこん","けつじょ","けっせき","けってい","けつまつ","げつようび","げつれい","けつろん","げどく","けとばす","けとる","けなげ","けなす","けなみ","けぬき","げねつ","けねん","けはい","げひん","けぶかい","げぼく","けまり","けみかる","けむし","けむり","けもの","けらい","けろけろ","けわしい","けんい","けんえつ","けんお","けんか","げんき","けんげん","けんこう","けんさく","けんしゅう","けんすう","げんそう","けんちく","けんてい","けんとう","けんない","けんにん","げんぶつ","けんま","けんみん","けんめい","けんらん","けんり","こあくま","こいぬ","こいびと","ごうい","こうえん","こうおん","こうかん","ごうきゅう","ごうけい","こうこう","こうさい","こうじ","こうすい","ごうせい","こうそく","こうたい","こうちゃ","こうつう","こうてい","こうどう","こうない","こうはい","ごうほう","ごうまん","こうもく","こうりつ","こえる","こおり","ごかい","ごがつ","ごかん","こくご","こくさい","こくとう","こくない","こくはく","こぐま","こけい","こける","ここのか","こころ","こさめ","こしつ","こすう","こせい","こせき","こぜん","こそだて","こたい","こたえる","こたつ","こちょう","こっか","こつこつ","こつばん","こつぶ","こてい","こてん","ことがら","ことし","ことば","ことり","こなごな","こねこね","このまま","このみ","このよ","ごはん","こひつじ","こふう","こふん","こぼれる","ごまあぶら","こまかい","ごますり","こまつな","こまる","こむぎこ","こもじ","こもち","こもの","こもん","こやく","こやま","こゆう","こゆび","こよい","こよう","こりる","これくしょん","ころっけ","こわもて","こわれる","こんいん","こんかい","こんき","こんしゅう","こんすい","こんだて","こんとん","こんなん","こんびに","こんぽん","こんまけ","こんや","こんれい","こんわく","ざいえき","さいかい","さいきん","ざいげん","ざいこ","さいしょ","さいせい","ざいたく","ざいちゅう","さいてき","ざいりょう","さうな","さかいし","さがす","さかな","さかみち","さがる","さぎょう","さくし","さくひん","さくら","さこく","さこつ","さずかる","ざせき","さたん","さつえい","ざつおん","ざっか","ざつがく","さっきょく","ざっし","さつじん","ざっそう","さつたば","さつまいも","さてい","さといも","さとう","さとおや","さとし","さとる","さのう","さばく","さびしい","さべつ","さほう","さほど","さます","さみしい","さみだれ","さむけ","さめる","さやえんどう","さゆう","さよう","さよく","さらだ","ざるそば","さわやか","さわる","さんいん","さんか","さんきゃく","さんこう","さんさい","ざんしょ","さんすう","さんせい","さんそ","さんち","さんま","さんみ","さんらん","しあい","しあげ","しあさって","しあわせ","しいく","しいん","しうち","しえい","しおけ","しかい","しかく","じかん","しごと","しすう","じだい","したうけ","したぎ","したて","したみ","しちょう","しちりん","しっかり","しつじ","しつもん","してい","してき","してつ","じてん","じどう","しなぎれ","しなもの","しなん","しねま","しねん","しのぐ","しのぶ","しはい","しばかり","しはつ","しはらい","しはん","しひょう","しふく","じぶん","しへい","しほう","しほん","しまう","しまる","しみん","しむける","じむしょ","しめい","しめる","しもん","しゃいん","しゃうん","しゃおん","じゃがいも","しやくしょ","しゃくほう","しゃけん","しゃこ","しゃざい","しゃしん","しゃせん","しゃそう","しゃたい","しゃちょう","しゃっきん","じゃま","しゃりん","しゃれい","じゆう","じゅうしょ","しゅくはく","じゅしん","しゅっせき","しゅみ","しゅらば","じゅんばん","しょうかい","しょくたく","しょっけん","しょどう","しょもつ","しらせる","しらべる","しんか","しんこう","じんじゃ","しんせいじ","しんちく","しんりん","すあげ","すあし","すあな","ずあん","すいえい","すいか","すいとう","ずいぶん","すいようび","すうがく","すうじつ","すうせん","すおどり","すきま","すくう","すくない","すける","すごい","すこし","ずさん","すずしい","すすむ","すすめる","すっかり","ずっしり","ずっと","すてき","すてる","すねる","すのこ","すはだ","すばらしい","ずひょう","ずぶぬれ","すぶり","すふれ","すべて","すべる","ずほう","すぼん","すまい","すめし","すもう","すやき","すらすら","するめ","すれちがう","すろっと","すわる","すんぜん","すんぽう","せあぶら","せいかつ","せいげん","せいじ","せいよう","せおう","せかいかん","せきにん","せきむ","せきゆ","せきらんうん","せけん","せこう","せすじ","せたい","せたけ","せっかく","せっきゃく","ぜっく","せっけん","せっこつ","せっさたくま","せつぞく","せつだん","せつでん","せっぱん","せつび","せつぶん","せつめい","せつりつ","せなか","せのび","せはば","せびろ","せぼね","せまい","せまる","せめる","せもたれ","せりふ","ぜんあく","せんい","せんえい","せんか","せんきょ","せんく","せんげん","ぜんご","せんさい","せんしゅ","せんすい","せんせい","せんぞ","せんたく","せんちょう","せんてい","せんとう","せんぬき","せんねん","せんぱい","ぜんぶ","ぜんぽう","せんむ","せんめんじょ","せんもん","せんやく","せんゆう","せんよう","ぜんら","ぜんりゃく","せんれい","せんろ","そあく","そいとげる","そいね","そうがんきょう","そうき","そうご","そうしん","そうだん","そうなん","そうび","そうめん","そうり","そえもの","そえん","そがい","そげき","そこう","そこそこ","そざい","そしな","そせい","そせん","そそぐ","そだてる","そつう","そつえん","そっかん","そつぎょう","そっけつ","そっこう","そっせん","そっと","そとがわ","そとづら","そなえる","そなた","そふぼ","そぼく","そぼろ","そまつ","そまる","そむく","そむりえ","そめる","そもそも","そよかぜ","そらまめ","そろう","そんかい","そんけい","そんざい","そんしつ","そんぞく","そんちょう","ぞんび","ぞんぶん","そんみん","たあい","たいいん","たいうん","たいえき","たいおう","だいがく","たいき","たいぐう","たいけん","たいこ","たいざい","だいじょうぶ","だいすき","たいせつ","たいそう","だいたい","たいちょう","たいてい","だいどころ","たいない","たいねつ","たいのう","たいはん","だいひょう","たいふう","たいへん","たいほ","たいまつばな","たいみんぐ","たいむ","たいめん","たいやき","たいよう","たいら","たいりょく","たいる","たいわん","たうえ","たえる","たおす","たおる","たおれる","たかい","たかね","たきび","たくさん","たこく","たこやき","たさい","たしざん","だじゃれ","たすける","たずさわる","たそがれ","たたかう","たたく","ただしい","たたみ","たちばな","だっかい","だっきゃく","だっこ","だっしゅつ","だったい","たてる","たとえる","たなばた","たにん","たぬき","たのしみ","たはつ","たぶん","たべる","たぼう","たまご","たまる","だむる","ためいき","ためす","ためる","たもつ","たやすい","たよる","たらす","たりきほんがん","たりょう","たりる","たると","たれる","たれんと","たろっと","たわむれる","だんあつ","たんい","たんおん","たんか","たんき","たんけん","たんご","たんさん","たんじょうび","だんせい","たんそく","たんたい","だんち","たんてい","たんとう","だんな","たんにん","だんねつ","たんのう","たんぴん","だんぼう","たんまつ","たんめい","だんれつ","だんろ","だんわ","ちあい","ちあん","ちいき","ちいさい","ちえん","ちかい","ちから","ちきゅう","ちきん","ちけいず","ちけん","ちこく","ちさい","ちしき","ちしりょう","ちせい","ちそう","ちたい","ちたん","ちちおや","ちつじょ","ちてき","ちてん","ちぬき","ちぬり","ちのう","ちひょう","ちへいせん","ちほう","ちまた","ちみつ","ちみどろ","ちめいど","ちゃんこなべ","ちゅうい","ちゆりょく","ちょうし","ちょさくけん","ちらし","ちらみ","ちりがみ","ちりょう","ちるど","ちわわ","ちんたい","ちんもく","ついか","ついたち","つうか","つうじょう","つうはん","つうわ","つかう","つかれる","つくね","つくる","つけね","つける","つごう","つたえる","つづく","つつじ","つつむ","つとめる","つながる","つなみ","つねづね","つのる","つぶす","つまらない","つまる","つみき","つめたい","つもり","つもる","つよい","つるぼ","つるみく","つわもの","つわり","てあし","てあて","てあみ","ていおん","ていか","ていき","ていけい","ていこく","ていさつ","ていし","ていせい","ていたい","ていど","ていねい","ていひょう","ていへん","ていぼう","てうち","ておくれ","てきとう","てくび","でこぼこ","てさぎょう","てさげ","てすり","てそう","てちがい","てちょう","てつがく","てつづき","でっぱ","てつぼう","てつや","でぬかえ","てぬき","てぬぐい","てのひら","てはい","てぶくろ","てふだ","てほどき","てほん","てまえ","てまきずし","てみじか","てみやげ","てらす","てれび","てわけ","てわたし","でんあつ","てんいん","てんかい","てんき","てんぐ","てんけん","てんごく","てんさい","てんし","てんすう","でんち","てんてき","てんとう","てんない","てんぷら","てんぼうだい","てんめつ","てんらんかい","でんりょく","でんわ","どあい","といれ","どうかん","とうきゅう","どうぐ","とうし","とうむぎ","とおい","とおか","とおく","とおす","とおる","とかい","とかす","ときおり","ときどき","とくい","とくしゅう","とくてん","とくに","とくべつ","とけい","とける","とこや","とさか","としょかん","とそう","とたん","とちゅう","とっきゅう","とっくん","とつぜん","とつにゅう","とどける","ととのえる","とない","となえる","となり","とのさま","とばす","どぶがわ","とほう","とまる","とめる","ともだち","ともる","どようび","とらえる","とんかつ","どんぶり","ないかく","ないこう","ないしょ","ないす","ないせん","ないそう","なおす","ながい","なくす","なげる","なこうど","なさけ","なたでここ","なっとう","なつやすみ","ななおし","なにごと","なにもの","なにわ","なのか","なふだ","なまいき","なまえ","なまみ","なみだ","なめらか","なめる","なやむ","ならう","ならび","ならぶ","なれる","なわとび","なわばり","にあう","にいがた","にうけ","におい","にかい","にがて","にきび","にくしみ","にくまん","にげる","にさんかたんそ","にしき","にせもの","にちじょう","にちようび","にっか","にっき","にっけい","にっこう","にっさん","にっしょく","にっすう","にっせき","にってい","になう","にほん","にまめ","にもつ","にやり","にゅういん","にりんしゃ","にわとり","にんい","にんか","にんき","にんげん","にんしき","にんずう","にんそう","にんたい","にんち","にんてい","にんにく","にんぷ","にんまり","にんむ","にんめい","にんよう","ぬいくぎ","ぬかす","ぬぐいとる","ぬぐう","ぬくもり","ぬすむ","ぬまえび","ぬめり","ぬらす","ぬんちゃく","ねあげ","ねいき","ねいる","ねいろ","ねぐせ","ねくたい","ねくら","ねこぜ","ねこむ","ねさげ","ねすごす","ねそべる","ねだん","ねつい","ねっしん","ねつぞう","ねったいぎょ","ねぶそく","ねふだ","ねぼう","ねほりはほり","ねまき","ねまわし","ねみみ","ねむい","ねむたい","ねもと","ねらう","ねわざ","ねんいり","ねんおし","ねんかん","ねんきん","ねんぐ","ねんざ","ねんし","ねんちゃく","ねんど","ねんぴ","ねんぶつ","ねんまつ","ねんりょう","ねんれい","のいず","のおづま","のがす","のきなみ","のこぎり","のこす","のこる","のせる","のぞく","のぞむ","のたまう","のちほど","のっく","のばす","のはら","のべる","のぼる","のみもの","のやま","のらいぬ","のらねこ","のりもの","のりゆき","のれん","のんき","ばあい","はあく","ばあさん","ばいか","ばいく","はいけん","はいご","はいしん","はいすい","はいせん","はいそう","はいち","ばいばい","はいれつ","はえる","はおる","はかい","ばかり","はかる","はくしゅ","はけん","はこぶ","はさみ","はさん","はしご","ばしょ","はしる","はせる","ぱそこん","はそん","はたん","はちみつ","はつおん","はっかく","はづき","はっきり","はっくつ","はっけん","はっこう","はっさん","はっしん","はったつ","はっちゅう","はってん","はっぴょう","はっぽう","はなす","はなび","はにかむ","はぶらし","はみがき","はむかう","はめつ","はやい","はやし","はらう","はろうぃん","はわい","はんい","はんえい","はんおん","はんかく","はんきょう","ばんぐみ","はんこ","はんしゃ","はんすう","はんだん","ぱんち","ぱんつ","はんてい","はんとし","はんのう","はんぱ","はんぶん","はんぺん","はんぼうき","はんめい","はんらん","はんろん","ひいき","ひうん","ひえる","ひかく","ひかり","ひかる","ひかん","ひくい","ひけつ","ひこうき","ひこく","ひさい","ひさしぶり","ひさん","びじゅつかん","ひしょ","ひそか","ひそむ","ひたむき","ひだり","ひたる","ひつぎ","ひっこし","ひっし","ひつじゅひん","ひっす","ひつぜん","ぴったり","ぴっちり","ひつよう","ひてい","ひとごみ","ひなまつり","ひなん","ひねる","ひはん","ひびく","ひひょう","ひほう","ひまわり","ひまん","ひみつ","ひめい","ひめじし","ひやけ","ひやす","ひよう","びょうき","ひらがな","ひらく","ひりつ","ひりょう","ひるま","ひるやすみ","ひれい","ひろい","ひろう","ひろき","ひろゆき","ひんかく","ひんけつ","ひんこん","ひんしゅ","ひんそう","ぴんち","ひんぱん","びんぼう","ふあん","ふいうち","ふうけい","ふうせん","ぷうたろう","ふうとう","ふうふ","ふえる","ふおん","ふかい","ふきん","ふくざつ","ふくぶくろ","ふこう","ふさい","ふしぎ","ふじみ","ふすま","ふせい","ふせぐ","ふそく","ぶたにく","ふたん","ふちょう","ふつう","ふつか","ふっかつ","ふっき","ふっこく","ぶどう","ふとる","ふとん","ふのう","ふはい","ふひょう","ふへん","ふまん","ふみん","ふめつ","ふめん","ふよう","ふりこ","ふりる","ふるい","ふんいき","ぶんがく","ぶんぐ","ふんしつ","ぶんせき","ふんそう","ぶんぽう","へいあん","へいおん","へいがい","へいき","へいげん","へいこう","へいさ","へいしゃ","へいせつ","へいそ","へいたく","へいてん","へいねつ","へいわ","へきが","へこむ","べにいろ","べにしょうが","へらす","へんかん","べんきょう","べんごし","へんさい","へんたい","べんり","ほあん","ほいく","ぼうぎょ","ほうこく","ほうそう","ほうほう","ほうもん","ほうりつ","ほえる","ほおん","ほかん","ほきょう","ぼきん","ほくろ","ほけつ","ほけん","ほこう","ほこる","ほしい","ほしつ","ほしゅ","ほしょう","ほせい","ほそい","ほそく","ほたて","ほたる","ぽちぶくろ","ほっきょく","ほっさ","ほったん","ほとんど","ほめる","ほんい","ほんき","ほんけ","ほんしつ","ほんやく","まいにち","まかい","まかせる","まがる","まける","まこと","まさつ","まじめ","ますく","まぜる","まつり","まとめ","まなぶ","まぬけ","まねく","まほう","まもる","まゆげ","まよう","まろやか","まわす","まわり","まわる","まんが","まんきつ","まんぞく","まんなか","みいら","みうち","みえる","みがく","みかた","みかん","みけん","みこん","みじかい","みすい","みすえる","みせる","みっか","みつかる","みつける","みてい","みとめる","みなと","みなみかさい","みねらる","みのう","みのがす","みほん","みもと","みやげ","みらい","みりょく","みわく","みんか","みんぞく","むいか","むえき","むえん","むかい","むかう","むかえ","むかし","むぎちゃ","むける","むげん","むさぼる","むしあつい","むしば","むじゅん","むしろ","むすう","むすこ","むすぶ","むすめ","むせる","むせん","むちゅう","むなしい","むのう","むやみ","むよう","むらさき","むりょう","むろん","めいあん","めいうん","めいえん","めいかく","めいきょく","めいさい","めいし","めいそう","めいぶつ","めいれい","めいわく","めぐまれる","めざす","めした","めずらしい","めだつ","めまい","めやす","めんきょ","めんせき","めんどう","もうしあげる","もうどうけん","もえる","もくし","もくてき","もくようび","もちろん","もどる","もらう","もんく","もんだい","やおや","やける","やさい","やさしい","やすい","やすたろう","やすみ","やせる","やそう","やたい","やちん","やっと","やっぱり","やぶる","やめる","ややこしい","やよい","やわらかい","ゆうき","ゆうびんきょく","ゆうべ","ゆうめい","ゆけつ","ゆしゅつ","ゆせん","ゆそう","ゆたか","ゆちゃく","ゆでる","ゆにゅう","ゆびわ","ゆらい","ゆれる","ようい","ようか","ようきゅう","ようじ","ようす","ようちえん","よかぜ","よかん","よきん","よくせい","よくぼう","よけい","よごれる","よさん","よしゅう","よそう","よそく","よっか","よてい","よどがわく","よねつ","よやく","よゆう","よろこぶ","よろしい","らいう","らくがき","らくご","らくさつ","らくだ","らしんばん","らせん","らぞく","らたい","らっか","られつ","りえき","りかい","りきさく","りきせつ","りくぐん","りくつ","りけん","りこう","りせい","りそう","りそく","りてん","りねん","りゆう","りゅうがく","りよう","りょうり","りょかん","りょくちゃ","りょこう","りりく","りれき","りろん","りんご","るいけい","るいさい","るいじ","るいせき","るすばん","るりがわら","れいかん","れいぎ","れいせい","れいぞうこ","れいとう","れいぼう","れきし","れきだい","れんあい","れんけい","れんこん","れんさい","れんしゅう","れんぞく","れんらく","ろうか","ろうご","ろうじん","ろうそく","ろくが","ろこつ","ろじうら","ろしゅつ","ろせん","ろてん","ろめん","ろれつ","ろんぎ","ろんぱ","ろんぶん","ろんり","わかす","わかめ","わかやま","わかれる","わしつ","わじまし","わすれもの","わらう","われる"]')},8013:e=>{"use strict";e.exports=JSON.parse('["가격","가끔","가난","가능","가득","가르침","가뭄","가방","가상","가슴","가운데","가을","가이드","가입","가장","가정","가족","가죽","각오","각자","간격","간부","간섭","간장","간접","간판","갈등","갈비","갈색","갈증","감각","감기","감소","감수성","감자","감정","갑자기","강남","강당","강도","강력히","강변","강북","강사","강수량","강아지","강원도","강의","강제","강조","같이","개구리","개나리","개방","개별","개선","개성","개인","객관적","거실","거액","거울","거짓","거품","걱정","건강","건물","건설","건조","건축","걸음","검사","검토","게시판","게임","겨울","견해","결과","결국","결론","결석","결승","결심","결정","결혼","경계","경고","경기","경력","경복궁","경비","경상도","경영","경우","경쟁","경제","경주","경찰","경치","경향","경험","계곡","계단","계란","계산","계속","계약","계절","계층","계획","고객","고구려","고궁","고급","고등학생","고무신","고민","고양이","고장","고전","고집","고춧가루","고통","고향","곡식","골목","골짜기","골프","공간","공개","공격","공군","공급","공기","공동","공무원","공부","공사","공식","공업","공연","공원","공장","공짜","공책","공통","공포","공항","공휴일","과목","과일","과장","과정","과학","관객","관계","관광","관념","관람","관련","관리","관습","관심","관점","관찰","광경","광고","광장","광주","괴로움","굉장히","교과서","교문","교복","교실","교양","교육","교장","교직","교통","교환","교훈","구경","구름","구멍","구별","구분","구석","구성","구속","구역","구입","구청","구체적","국가","국기","국내","국립","국물","국민","국수","국어","국왕","국적","국제","국회","군대","군사","군인","궁극적","권리","권위","권투","귀국","귀신","규정","규칙","균형","그날","그냥","그늘","그러나","그룹","그릇","그림","그제서야","그토록","극복","극히","근거","근교","근래","근로","근무","근본","근원","근육","근처","글씨","글자","금강산","금고","금년","금메달","금액","금연","금요일","금지","긍정적","기간","기관","기념","기능","기독교","기둥","기록","기름","기법","기본","기분","기쁨","기숙사","기술","기억","기업","기온","기운","기원","기적","기준","기침","기혼","기획","긴급","긴장","길이","김밥","김치","김포공항","깍두기","깜빡","깨달음","깨소금","껍질","꼭대기","꽃잎","나들이","나란히","나머지","나물","나침반","나흘","낙엽","난방","날개","날씨","날짜","남녀","남대문","남매","남산","남자","남편","남학생","낭비","낱말","내년","내용","내일","냄비","냄새","냇물","냉동","냉면","냉방","냉장고","넥타이","넷째","노동","노란색","노력","노인","녹음","녹차","녹화","논리","논문","논쟁","놀이","농구","농담","농민","농부","농업","농장","농촌","높이","눈동자","눈물","눈썹","뉴욕","느낌","늑대","능동적","능력","다방","다양성","다음","다이어트","다행","단계","단골","단독","단맛","단순","단어","단위","단점","단체","단추","단편","단풍","달걀","달러","달력","달리","닭고기","담당","담배","담요","담임","답변","답장","당근","당분간","당연히","당장","대규모","대낮","대단히","대답","대도시","대략","대량","대륙","대문","대부분","대신","대응","대장","대전","대접","대중","대책","대출","대충","대통령","대학","대한민국","대합실","대형","덩어리","데이트","도대체","도덕","도둑","도망","도서관","도심","도움","도입","도자기","도저히","도전","도중","도착","독감","독립","독서","독일","독창적","동화책","뒷모습","뒷산","딸아이","마누라","마늘","마당","마라톤","마련","마무리","마사지","마약","마요네즈","마을","마음","마이크","마중","마지막","마찬가지","마찰","마흔","막걸리","막내","막상","만남","만두","만세","만약","만일","만점","만족","만화","많이","말기","말씀","말투","맘대로","망원경","매년","매달","매력","매번","매스컴","매일","매장","맥주","먹이","먼저","먼지","멀리","메일","며느리","며칠","면담","멸치","명단","명령","명예","명의","명절","명칭","명함","모금","모니터","모델","모든","모범","모습","모양","모임","모조리","모집","모퉁이","목걸이","목록","목사","목소리","목숨","목적","목표","몰래","몸매","몸무게","몸살","몸속","몸짓","몸통","몹시","무관심","무궁화","무더위","무덤","무릎","무슨","무엇","무역","무용","무조건","무지개","무척","문구","문득","문법","문서","문제","문학","문화","물가","물건","물결","물고기","물론","물리학","물음","물질","물체","미국","미디어","미사일","미술","미역","미용실","미움","미인","미팅","미혼","민간","민족","민주","믿음","밀가루","밀리미터","밑바닥","바가지","바구니","바나나","바늘","바닥","바닷가","바람","바이러스","바탕","박물관","박사","박수","반대","반드시","반말","반발","반성","반응","반장","반죽","반지","반찬","받침","발가락","발걸음","발견","발달","발레","발목","발바닥","발생","발음","발자국","발전","발톱","발표","밤하늘","밥그릇","밥맛","밥상","밥솥","방금","방면","방문","방바닥","방법","방송","방식","방안","방울","방지","방학","방해","방향","배경","배꼽","배달","배드민턴","백두산","백색","백성","백인","백제","백화점","버릇","버섯","버튼","번개","번역","번지","번호","벌금","벌레","벌써","범위","범인","범죄","법률","법원","법적","법칙","베이징","벨트","변경","변동","변명","변신","변호사","변화","별도","별명","별일","병실","병아리","병원","보관","보너스","보라색","보람","보름","보상","보안","보자기","보장","보전","보존","보통","보편적","보험","복도","복사","복숭아","복습","볶음","본격적","본래","본부","본사","본성","본인","본질","볼펜","봉사","봉지","봉투","부근","부끄러움","부담","부동산","부문","부분","부산","부상","부엌","부인","부작용","부장","부정","부족","부지런히","부친","부탁","부품","부회장","북부","북한","분노","분량","분리","분명","분석","분야","분위기","분필","분홍색","불고기","불과","불교","불꽃","불만","불법","불빛","불안","불이익","불행","브랜드","비극","비난","비닐","비둘기","비디오","비로소","비만","비명","비밀","비바람","비빔밥","비상","비용","비율","비중","비타민","비판","빌딩","빗물","빗방울","빗줄기","빛깔","빨간색","빨래","빨리","사건","사계절","사나이","사냥","사람","사랑","사립","사모님","사물","사방","사상","사생활","사설","사슴","사실","사업","사용","사월","사장","사전","사진","사촌","사춘기","사탕","사투리","사흘","산길","산부인과","산업","산책","살림","살인","살짝","삼계탕","삼국","삼십","삼월","삼촌","상관","상금","상대","상류","상반기","상상","상식","상업","상인","상자","상점","상처","상추","상태","상표","상품","상황","새벽","색깔","색연필","생각","생명","생물","생방송","생산","생선","생신","생일","생활","서랍","서른","서명","서민","서비스","서양","서울","서적","서점","서쪽","서클","석사","석유","선거","선물","선배","선생","선수","선원","선장","선전","선택","선풍기","설거지","설날","설렁탕","설명","설문","설사","설악산","설치","설탕","섭씨","성공","성당","성명","성별","성인","성장","성적","성질","성함","세금","세미나","세상","세월","세종대왕","세탁","센터","센티미터","셋째","소규모","소극적","소금","소나기","소년","소득","소망","소문","소설","소속","소아과","소용","소원","소음","소중히","소지품","소질","소풍","소형","속담","속도","속옷","손가락","손길","손녀","손님","손등","손목","손뼉","손실","손질","손톱","손해","솔직히","솜씨","송아지","송이","송편","쇠고기","쇼핑","수건","수년","수단","수돗물","수동적","수면","수명","수박","수상","수석","수술","수시로","수업","수염","수영","수입","수준","수집","수출","수컷","수필","수학","수험생","수화기","숙녀","숙소","숙제","순간","순서","순수","순식간","순위","숟가락","술병","술집","숫자","스님","스물","스스로","스승","스웨터","스위치","스케이트","스튜디오","스트레스","스포츠","슬쩍","슬픔","습관","습기","승객","승리","승부","승용차","승진","시각","시간","시골","시금치","시나리오","시댁","시리즈","시멘트","시민","시부모","시선","시설","시스템","시아버지","시어머니","시월","시인","시일","시작","시장","시절","시점","시중","시즌","시집","시청","시합","시험","식구","식기","식당","식량","식료품","식물","식빵","식사","식생활","식초","식탁","식품","신고","신규","신념","신문","신발","신비","신사","신세","신용","신제품","신청","신체","신화","실감","실내","실력","실례","실망","실수","실습","실시","실장","실정","실질적","실천","실체","실컷","실태","실패","실험","실현","심리","심부름","심사","심장","심정","심판","쌍둥이","씨름","씨앗","아가씨","아나운서","아드님","아들","아쉬움","아스팔트","아시아","아울러","아저씨","아줌마","아직","아침","아파트","아프리카","아픔","아홉","아흔","악기","악몽","악수","안개","안경","안과","안내","안녕","안동","안방","안부","안주","알루미늄","알코올","암시","암컷","압력","앞날","앞문","애인","애정","액수","앨범","야간","야단","야옹","약간","약국","약속","약수","약점","약품","약혼녀","양념","양력","양말","양배추","양주","양파","어둠","어려움","어른","어젯밤","어쨌든","어쩌다가","어쩐지","언니","언덕","언론","언어","얼굴","얼른","얼음","얼핏","엄마","업무","업종","업체","엉덩이","엉망","엉터리","엊그제","에너지","에어컨","엔진","여건","여고생","여관","여군","여권","여대생","여덟","여동생","여든","여론","여름","여섯","여성","여왕","여인","여전히","여직원","여학생","여행","역사","역시","역할","연결","연구","연극","연기","연락","연설","연세","연속","연습","연애","연예인","연인","연장","연주","연출","연필","연합","연휴","열기","열매","열쇠","열심히","열정","열차","열흘","염려","엽서","영국","영남","영상","영양","영역","영웅","영원히","영하","영향","영혼","영화","옆구리","옆방","옆집","예감","예금","예방","예산","예상","예선","예술","예습","예식장","예약","예전","예절","예정","예컨대","옛날","오늘","오락","오랫동안","오렌지","오로지","오른발","오븐","오십","오염","오월","오전","오직","오징어","오페라","오피스텔","오히려","옥상","옥수수","온갖","온라인","온몸","온종일","온통","올가을","올림픽","올해","옷차림","와이셔츠","와인","완성","완전","왕비","왕자","왜냐하면","왠지","외갓집","외국","외로움","외삼촌","외출","외침","외할머니","왼발","왼손","왼쪽","요금","요일","요즘","요청","용기","용서","용어","우산","우선","우승","우연히","우정","우체국","우편","운동","운명","운반","운전","운행","울산","울음","움직임","웃어른","웃음","워낙","원고","원래","원서","원숭이","원인","원장","원피스","월급","월드컵","월세","월요일","웨이터","위반","위법","위성","위원","위험","위협","윗사람","유난히","유럽","유명","유물","유산","유적","유치원","유학","유행","유형","육군","육상","육십","육체","은행","음력","음료","음반","음성","음식","음악","음주","의견","의논","의문","의복","의식","의심","의외로","의욕","의원","의학","이것","이곳","이념","이놈","이달","이대로","이동","이렇게","이력서","이론적","이름","이민","이발소","이별","이불","이빨","이상","이성","이슬","이야기","이용","이웃","이월","이윽고","이익","이전","이중","이튿날","이틀","이혼","인간","인격","인공","인구","인근","인기","인도","인류","인물","인생","인쇄","인연","인원","인재","인종","인천","인체","인터넷","인하","인형","일곱","일기","일단","일대","일등","일반","일본","일부","일상","일생","일손","일요일","일월","일정","일종","일주일","일찍","일체","일치","일행","일회용","임금","임무","입대","입력","입맛","입사","입술","입시","입원","입장","입학","자가용","자격","자극","자동","자랑","자부심","자식","자신","자연","자원","자율","자전거","자정","자존심","자판","작가","작년","작성","작업","작용","작은딸","작품","잔디","잔뜩","잔치","잘못","잠깐","잠수함","잠시","잠옷","잠자리","잡지","장관","장군","장기간","장래","장례","장르","장마","장면","장모","장미","장비","장사","장소","장식","장애인","장인","장점","장차","장학금","재능","재빨리","재산","재생","재작년","재정","재채기","재판","재학","재활용","저것","저고리","저곳","저녁","저런","저렇게","저번","저울","저절로","저축","적극","적당히","적성","적용","적응","전개","전공","전기","전달","전라도","전망","전문","전반","전부","전세","전시","전용","전자","전쟁","전주","전철","전체","전통","전혀","전후","절대","절망","절반","절약","절차","점검","점수","점심","점원","점점","점차","접근","접시","접촉","젓가락","정거장","정도","정류장","정리","정말","정면","정문","정반대","정보","정부","정비","정상","정성","정오","정원","정장","정지","정치","정확히","제공","제과점","제대로","제목","제발","제법","제삿날","제안","제일","제작","제주도","제출","제품","제한","조각","조건","조금","조깅","조명","조미료","조상","조선","조용히","조절","조정","조직","존댓말","존재","졸업","졸음","종교","종로","종류","종소리","종업원","종종","종합","좌석","죄인","주관적","주름","주말","주머니","주먹","주문","주민","주방","주변","주식","주인","주일","주장","주전자","주택","준비","줄거리","줄기","줄무늬","중간","중계방송","중국","중년","중단","중독","중반","중부","중세","중소기업","중순","중앙","중요","중학교","즉석","즉시","즐거움","증가","증거","증권","증상","증세","지각","지갑","지경","지극히","지금","지급","지능","지름길","지리산","지방","지붕","지식","지역","지우개","지원","지적","지점","지진","지출","직선","직업","직원","직장","진급","진동","진로","진료","진리","진짜","진찰","진출","진통","진행","질문","질병","질서","짐작","집단","집안","집중","짜증","찌꺼기","차남","차라리","차량","차림","차별","차선","차츰","착각","찬물","찬성","참가","참기름","참새","참석","참여","참외","참조","찻잔","창가","창고","창구","창문","창밖","창작","창조","채널","채점","책가방","책방","책상","책임","챔피언","처벌","처음","천국","천둥","천장","천재","천천히","철도","철저히","철학","첫날","첫째","청년","청바지","청소","청춘","체계","체력","체온","체육","체중","체험","초등학생","초반","초밥","초상화","초순","초여름","초원","초저녁","초점","초청","초콜릿","촛불","총각","총리","총장","촬영","최근","최상","최선","최신","최악","최종","추석","추억","추진","추천","추측","축구","축소","축제","축하","출근","출발","출산","출신","출연","출입","출장","출판","충격","충고","충돌","충분히","충청도","취업","취직","취향","치약","친구","친척","칠십","칠월","칠판","침대","침묵","침실","칫솔","칭찬","카메라","카운터","칼국수","캐릭터","캠퍼스","캠페인","커튼","컨디션","컬러","컴퓨터","코끼리","코미디","콘서트","콜라","콤플렉스","콩나물","쾌감","쿠데타","크림","큰길","큰딸","큰소리","큰아들","큰어머니","큰일","큰절","클래식","클럽","킬로","타입","타자기","탁구","탁자","탄생","태권도","태양","태풍","택시","탤런트","터널","터미널","테니스","테스트","테이블","텔레비전","토론","토마토","토요일","통계","통과","통로","통신","통역","통일","통장","통제","통증","통합","통화","퇴근","퇴원","퇴직금","튀김","트럭","특급","특별","특성","특수","특징","특히","튼튼히","티셔츠","파란색","파일","파출소","판결","판단","판매","판사","팔십","팔월","팝송","패션","팩스","팩시밀리","팬티","퍼센트","페인트","편견","편의","편지","편히","평가","평균","평생","평소","평양","평일","평화","포스터","포인트","포장","포함","표면","표정","표준","표현","품목","품질","풍경","풍속","풍습","프랑스","프린터","플라스틱","피곤","피망","피아노","필름","필수","필요","필자","필통","핑계","하느님","하늘","하드웨어","하룻밤","하반기","하숙집","하순","하여튼","하지만","하천","하품","하필","학과","학교","학급","학기","학년","학력","학번","학부모","학비","학생","학술","학습","학용품","학원","학위","학자","학점","한계","한글","한꺼번에","한낮","한눈","한동안","한때","한라산","한마디","한문","한번","한복","한식","한여름","한쪽","할머니","할아버지","할인","함께","함부로","합격","합리적","항공","항구","항상","항의","해결","해군","해답","해당","해물","해석","해설","해수욕장","해안","핵심","핸드백","햄버거","햇볕","햇살","행동","행복","행사","행운","행위","향기","향상","향수","허락","허용","헬기","현관","현금","현대","현상","현실","현장","현재","현지","혈액","협력","형부","형사","형수","형식","형제","형태","형편","혜택","호기심","호남","호랑이","호박","호텔","호흡","혹시","홀로","홈페이지","홍보","홍수","홍차","화면","화분","화살","화요일","화장","화학","확보","확인","확장","확정","환갑","환경","환영","환율","환자","활기","활동","활발히","활용","활짝","회견","회관","회복","회색","회원","회장","회전","횟수","횡단보도","효율적","후반","후춧가루","훈련","훨씬","휴식","휴일","흉내","흐름","흑백","흑인","흔적","흔히","흥미","흥분","희곡","희망","희생","흰색","힘껏"]')},1945:e=>{"use strict";e.exports=JSON.parse('["abacate","abaixo","abalar","abater","abduzir","abelha","aberto","abismo","abotoar","abranger","abreviar","abrigar","abrupto","absinto","absoluto","absurdo","abutre","acabado","acalmar","acampar","acanhar","acaso","aceitar","acelerar","acenar","acervo","acessar","acetona","achatar","acidez","acima","acionado","acirrar","aclamar","aclive","acolhida","acomodar","acoplar","acordar","acumular","acusador","adaptar","adega","adentro","adepto","adequar","aderente","adesivo","adeus","adiante","aditivo","adjetivo","adjunto","admirar","adorar","adquirir","adubo","adverso","advogado","aeronave","afastar","aferir","afetivo","afinador","afivelar","aflito","afluente","afrontar","agachar","agarrar","agasalho","agenciar","agilizar","agiota","agitado","agora","agradar","agreste","agrupar","aguardar","agulha","ajoelhar","ajudar","ajustar","alameda","alarme","alastrar","alavanca","albergue","albino","alcatra","aldeia","alecrim","alegria","alertar","alface","alfinete","algum","alheio","aliar","alicate","alienar","alinhar","aliviar","almofada","alocar","alpiste","alterar","altitude","alucinar","alugar","aluno","alusivo","alvo","amaciar","amador","amarelo","amassar","ambas","ambiente","ameixa","amenizar","amido","amistoso","amizade","amolador","amontoar","amoroso","amostra","amparar","ampliar","ampola","anagrama","analisar","anarquia","anatomia","andaime","anel","anexo","angular","animar","anjo","anomalia","anotado","ansioso","anterior","anuidade","anunciar","anzol","apagador","apalpar","apanhado","apego","apelido","apertada","apesar","apetite","apito","aplauso","aplicada","apoio","apontar","aposta","aprendiz","aprovar","aquecer","arame","aranha","arara","arcada","ardente","areia","arejar","arenito","aresta","argiloso","argola","arma","arquivo","arraial","arrebate","arriscar","arroba","arrumar","arsenal","arterial","artigo","arvoredo","asfaltar","asilado","aspirar","assador","assinar","assoalho","assunto","astral","atacado","atadura","atalho","atarefar","atear","atender","aterro","ateu","atingir","atirador","ativo","atoleiro","atracar","atrevido","atriz","atual","atum","auditor","aumentar","aura","aurora","autismo","autoria","autuar","avaliar","avante","avaria","avental","avesso","aviador","avisar","avulso","axila","azarar","azedo","azeite","azulejo","babar","babosa","bacalhau","bacharel","bacia","bagagem","baiano","bailar","baioneta","bairro","baixista","bajular","baleia","baliza","balsa","banal","bandeira","banho","banir","banquete","barato","barbado","baronesa","barraca","barulho","baseado","bastante","batata","batedor","batida","batom","batucar","baunilha","beber","beijo","beirada","beisebol","beldade","beleza","belga","beliscar","bendito","bengala","benzer","berimbau","berlinda","berro","besouro","bexiga","bezerro","bico","bicudo","bienal","bifocal","bifurcar","bigorna","bilhete","bimestre","bimotor","biologia","biombo","biosfera","bipolar","birrento","biscoito","bisneto","bispo","bissexto","bitola","bizarro","blindado","bloco","bloquear","boato","bobagem","bocado","bocejo","bochecha","boicotar","bolada","boletim","bolha","bolo","bombeiro","bonde","boneco","bonita","borbulha","borda","boreal","borracha","bovino","boxeador","branco","brasa","braveza","breu","briga","brilho","brincar","broa","brochura","bronzear","broto","bruxo","bucha","budismo","bufar","bule","buraco","busca","busto","buzina","cabana","cabelo","cabide","cabo","cabrito","cacau","cacetada","cachorro","cacique","cadastro","cadeado","cafezal","caiaque","caipira","caixote","cajado","caju","calafrio","calcular","caldeira","calibrar","calmante","calota","camada","cambista","camisa","camomila","campanha","camuflar","canavial","cancelar","caneta","canguru","canhoto","canivete","canoa","cansado","cantar","canudo","capacho","capela","capinar","capotar","capricho","captador","capuz","caracol","carbono","cardeal","careca","carimbar","carneiro","carpete","carreira","cartaz","carvalho","casaco","casca","casebre","castelo","casulo","catarata","cativar","caule","causador","cautelar","cavalo","caverna","cebola","cedilha","cegonha","celebrar","celular","cenoura","censo","centeio","cercar","cerrado","certeiro","cerveja","cetim","cevada","chacota","chaleira","chamado","chapada","charme","chatice","chave","chefe","chegada","cheiro","cheque","chicote","chifre","chinelo","chocalho","chover","chumbo","chutar","chuva","cicatriz","ciclone","cidade","cidreira","ciente","cigana","cimento","cinto","cinza","ciranda","circuito","cirurgia","citar","clareza","clero","clicar","clone","clube","coado","coagir","cobaia","cobertor","cobrar","cocada","coelho","coentro","coeso","cogumelo","coibir","coifa","coiote","colar","coleira","colher","colidir","colmeia","colono","coluna","comando","combinar","comentar","comitiva","comover","complexo","comum","concha","condor","conectar","confuso","congelar","conhecer","conjugar","consumir","contrato","convite","cooperar","copeiro","copiador","copo","coquetel","coragem","cordial","corneta","coronha","corporal","correio","cortejo","coruja","corvo","cosseno","costela","cotonete","couro","couve","covil","cozinha","cratera","cravo","creche","credor","creme","crer","crespo","criada","criminal","crioulo","crise","criticar","crosta","crua","cruzeiro","cubano","cueca","cuidado","cujo","culatra","culminar","culpar","cultura","cumprir","cunhado","cupido","curativo","curral","cursar","curto","cuspir","custear","cutelo","damasco","datar","debater","debitar","deboche","debulhar","decalque","decimal","declive","decote","decretar","dedal","dedicado","deduzir","defesa","defumar","degelo","degrau","degustar","deitado","deixar","delator","delegado","delinear","delonga","demanda","demitir","demolido","dentista","depenado","depilar","depois","depressa","depurar","deriva","derramar","desafio","desbotar","descanso","desenho","desfiado","desgaste","desigual","deslize","desmamar","desova","despesa","destaque","desviar","detalhar","detentor","detonar","detrito","deusa","dever","devido","devotado","dezena","diagrama","dialeto","didata","difuso","digitar","dilatado","diluente","diminuir","dinastia","dinheiro","diocese","direto","discreta","disfarce","disparo","disquete","dissipar","distante","ditador","diurno","diverso","divisor","divulgar","dizer","dobrador","dolorido","domador","dominado","donativo","donzela","dormente","dorsal","dosagem","dourado","doutor","drenagem","drible","drogaria","duelar","duende","dueto","duplo","duquesa","durante","duvidoso","eclodir","ecoar","ecologia","edificar","edital","educado","efeito","efetivar","ejetar","elaborar","eleger","eleitor","elenco","elevador","eliminar","elogiar","embargo","embolado","embrulho","embutido","emenda","emergir","emissor","empatia","empenho","empinado","empolgar","emprego","empurrar","emulador","encaixe","encenado","enchente","encontro","endeusar","endossar","enfaixar","enfeite","enfim","engajado","engenho","englobar","engomado","engraxar","enguia","enjoar","enlatar","enquanto","enraizar","enrolado","enrugar","ensaio","enseada","ensino","ensopado","entanto","enteado","entidade","entortar","entrada","entulho","envergar","enviado","envolver","enxame","enxerto","enxofre","enxuto","epiderme","equipar","ereto","erguido","errata","erva","ervilha","esbanjar","esbelto","escama","escola","escrita","escuta","esfinge","esfolar","esfregar","esfumado","esgrima","esmalte","espanto","espelho","espiga","esponja","espreita","espumar","esquerda","estaca","esteira","esticar","estofado","estrela","estudo","esvaziar","etanol","etiqueta","euforia","europeu","evacuar","evaporar","evasivo","eventual","evidente","evoluir","exagero","exalar","examinar","exato","exausto","excesso","excitar","exclamar","executar","exemplo","exibir","exigente","exonerar","expandir","expelir","expirar","explanar","exposto","expresso","expulsar","externo","extinto","extrato","fabricar","fabuloso","faceta","facial","fada","fadiga","faixa","falar","falta","familiar","fandango","fanfarra","fantoche","fardado","farelo","farinha","farofa","farpa","fartura","fatia","fator","favorita","faxina","fazenda","fechado","feijoada","feirante","felino","feminino","fenda","feno","fera","feriado","ferrugem","ferver","festejar","fetal","feudal","fiapo","fibrose","ficar","ficheiro","figurado","fileira","filho","filme","filtrar","firmeza","fisgada","fissura","fita","fivela","fixador","fixo","flacidez","flamingo","flanela","flechada","flora","flutuar","fluxo","focal","focinho","fofocar","fogo","foguete","foice","folgado","folheto","forjar","formiga","forno","forte","fosco","fossa","fragata","fralda","frango","frasco","fraterno","freira","frente","fretar","frieza","friso","fritura","fronha","frustrar","fruteira","fugir","fulano","fuligem","fundar","fungo","funil","furador","furioso","futebol","gabarito","gabinete","gado","gaiato","gaiola","gaivota","galega","galho","galinha","galocha","ganhar","garagem","garfo","gargalo","garimpo","garoupa","garrafa","gasoduto","gasto","gata","gatilho","gaveta","gazela","gelado","geleia","gelo","gemada","gemer","gemido","generoso","gengiva","genial","genoma","genro","geologia","gerador","germinar","gesso","gestor","ginasta","gincana","gingado","girafa","girino","glacial","glicose","global","glorioso","goela","goiaba","golfe","golpear","gordura","gorjeta","gorro","gostoso","goteira","governar","gracejo","gradual","grafite","gralha","grampo","granada","gratuito","graveto","graxa","grego","grelhar","greve","grilo","grisalho","gritaria","grosso","grotesco","grudado","grunhido","gruta","guache","guarani","guaxinim","guerrear","guiar","guincho","guisado","gula","guloso","guru","habitar","harmonia","haste","haver","hectare","herdar","heresia","hesitar","hiato","hibernar","hidratar","hiena","hino","hipismo","hipnose","hipoteca","hoje","holofote","homem","honesto","honrado","hormonal","hospedar","humorado","iate","ideia","idoso","ignorado","igreja","iguana","ileso","ilha","iludido","iluminar","ilustrar","imagem","imediato","imenso","imersivo","iminente","imitador","imortal","impacto","impedir","implante","impor","imprensa","impune","imunizar","inalador","inapto","inativo","incenso","inchar","incidir","incluir","incolor","indeciso","indireto","indutor","ineficaz","inerente","infantil","infestar","infinito","inflamar","informal","infrator","ingerir","inibido","inicial","inimigo","injetar","inocente","inodoro","inovador","inox","inquieto","inscrito","inseto","insistir","inspetor","instalar","insulto","intacto","integral","intimar","intocado","intriga","invasor","inverno","invicto","invocar","iogurte","iraniano","ironizar","irreal","irritado","isca","isento","isolado","isqueiro","italiano","janeiro","jangada","janta","jararaca","jardim","jarro","jasmim","jato","javali","jazida","jejum","joaninha","joelhada","jogador","joia","jornal","jorrar","jovem","juba","judeu","judoca","juiz","julgador","julho","jurado","jurista","juro","justa","labareda","laboral","lacre","lactante","ladrilho","lagarta","lagoa","laje","lamber","lamentar","laminar","lampejo","lanche","lapidar","lapso","laranja","lareira","largura","lasanha","lastro","lateral","latido","lavanda","lavoura","lavrador","laxante","lazer","lealdade","lebre","legado","legendar","legista","leigo","leiloar","leitura","lembrete","leme","lenhador","lentilha","leoa","lesma","leste","letivo","letreiro","levar","leveza","levitar","liberal","libido","liderar","ligar","ligeiro","limitar","limoeiro","limpador","linda","linear","linhagem","liquidez","listagem","lisura","litoral","livro","lixa","lixeira","locador","locutor","lojista","lombo","lona","longe","lontra","lorde","lotado","loteria","loucura","lousa","louvar","luar","lucidez","lucro","luneta","lustre","lutador","luva","macaco","macete","machado","macio","madeira","madrinha","magnata","magreza","maior","mais","malandro","malha","malote","maluco","mamilo","mamoeiro","mamute","manada","mancha","mandato","manequim","manhoso","manivela","manobrar","mansa","manter","manusear","mapeado","maquinar","marcador","maresia","marfim","margem","marinho","marmita","maroto","marquise","marreco","martelo","marujo","mascote","masmorra","massagem","mastigar","matagal","materno","matinal","matutar","maxilar","medalha","medida","medusa","megafone","meiga","melancia","melhor","membro","memorial","menino","menos","mensagem","mental","merecer","mergulho","mesada","mesclar","mesmo","mesquita","mestre","metade","meteoro","metragem","mexer","mexicano","micro","migalha","migrar","milagre","milenar","milhar","mimado","minerar","minhoca","ministro","minoria","miolo","mirante","mirtilo","misturar","mocidade","moderno","modular","moeda","moer","moinho","moita","moldura","moleza","molho","molinete","molusco","montanha","moqueca","morango","morcego","mordomo","morena","mosaico","mosquete","mostarda","motel","motim","moto","motriz","muda","muito","mulata","mulher","multar","mundial","munido","muralha","murcho","muscular","museu","musical","nacional","nadador","naja","namoro","narina","narrado","nascer","nativa","natureza","navalha","navegar","navio","neblina","nebuloso","negativa","negociar","negrito","nervoso","neta","neural","nevasca","nevoeiro","ninar","ninho","nitidez","nivelar","nobreza","noite","noiva","nomear","nominal","nordeste","nortear","notar","noticiar","noturno","novelo","novilho","novo","nublado","nudez","numeral","nupcial","nutrir","nuvem","obcecado","obedecer","objetivo","obrigado","obscuro","obstetra","obter","obturar","ocidente","ocioso","ocorrer","oculista","ocupado","ofegante","ofensiva","oferenda","oficina","ofuscado","ogiva","olaria","oleoso","olhar","oliveira","ombro","omelete","omisso","omitir","ondulado","oneroso","ontem","opcional","operador","oponente","oportuno","oposto","orar","orbitar","ordem","ordinal","orfanato","orgasmo","orgulho","oriental","origem","oriundo","orla","ortodoxo","orvalho","oscilar","ossada","osso","ostentar","otimismo","ousadia","outono","outubro","ouvido","ovelha","ovular","oxidar","oxigenar","pacato","paciente","pacote","pactuar","padaria","padrinho","pagar","pagode","painel","pairar","paisagem","palavra","palestra","palheta","palito","palmada","palpitar","pancada","panela","panfleto","panqueca","pantanal","papagaio","papelada","papiro","parafina","parcial","pardal","parede","partida","pasmo","passado","pastel","patamar","patente","patinar","patrono","paulada","pausar","peculiar","pedalar","pedestre","pediatra","pedra","pegada","peitoral","peixe","pele","pelicano","penca","pendurar","peneira","penhasco","pensador","pente","perceber","perfeito","pergunta","perito","permitir","perna","perplexo","persiana","pertence","peruca","pescado","pesquisa","pessoa","petiscar","piada","picado","piedade","pigmento","pilastra","pilhado","pilotar","pimenta","pincel","pinguim","pinha","pinote","pintar","pioneiro","pipoca","piquete","piranha","pires","pirueta","piscar","pistola","pitanga","pivete","planta","plaqueta","platina","plebeu","plumagem","pluvial","pneu","poda","poeira","poetisa","polegada","policiar","poluente","polvilho","pomar","pomba","ponderar","pontaria","populoso","porta","possuir","postal","pote","poupar","pouso","povoar","praia","prancha","prato","praxe","prece","predador","prefeito","premiar","prensar","preparar","presilha","pretexto","prevenir","prezar","primata","princesa","prisma","privado","processo","produto","profeta","proibido","projeto","prometer","propagar","prosa","protetor","provador","publicar","pudim","pular","pulmonar","pulseira","punhal","punir","pupilo","pureza","puxador","quadra","quantia","quarto","quase","quebrar","queda","queijo","quente","querido","quimono","quina","quiosque","rabanada","rabisco","rachar","racionar","radial","raiar","rainha","raio","raiva","rajada","ralado","ramal","ranger","ranhura","rapadura","rapel","rapidez","raposa","raquete","raridade","rasante","rascunho","rasgar","raspador","rasteira","rasurar","ratazana","ratoeira","realeza","reanimar","reaver","rebaixar","rebelde","rebolar","recado","recente","recheio","recibo","recordar","recrutar","recuar","rede","redimir","redonda","reduzida","reenvio","refinar","refletir","refogar","refresco","refugiar","regalia","regime","regra","reinado","reitor","rejeitar","relativo","remador","remendo","remorso","renovado","reparo","repelir","repleto","repolho","represa","repudiar","requerer","resenha","resfriar","resgatar","residir","resolver","respeito","ressaca","restante","resumir","retalho","reter","retirar","retomada","retratar","revelar","revisor","revolta","riacho","rica","rigidez","rigoroso","rimar","ringue","risada","risco","risonho","robalo","rochedo","rodada","rodeio","rodovia","roedor","roleta","romano","roncar","rosado","roseira","rosto","rota","roteiro","rotina","rotular","rouco","roupa","roxo","rubro","rugido","rugoso","ruivo","rumo","rupestre","russo","sabor","saciar","sacola","sacudir","sadio","safira","saga","sagrada","saibro","salada","saleiro","salgado","saliva","salpicar","salsicha","saltar","salvador","sambar","samurai","sanar","sanfona","sangue","sanidade","sapato","sarda","sargento","sarjeta","saturar","saudade","saxofone","sazonal","secar","secular","seda","sedento","sediado","sedoso","sedutor","segmento","segredo","segundo","seiva","seleto","selvagem","semanal","semente","senador","senhor","sensual","sentado","separado","sereia","seringa","serra","servo","setembro","setor","sigilo","silhueta","silicone","simetria","simpatia","simular","sinal","sincero","singular","sinopse","sintonia","sirene","siri","situado","soberano","sobra","socorro","sogro","soja","solda","soletrar","solteiro","sombrio","sonata","sondar","sonegar","sonhador","sono","soprano","soquete","sorrir","sorteio","sossego","sotaque","soterrar","sovado","sozinho","suavizar","subida","submerso","subsolo","subtrair","sucata","sucesso","suco","sudeste","sufixo","sugador","sugerir","sujeito","sulfato","sumir","suor","superior","suplicar","suposto","suprimir","surdina","surfista","surpresa","surreal","surtir","suspiro","sustento","tabela","tablete","tabuada","tacho","tagarela","talher","talo","talvez","tamanho","tamborim","tampa","tangente","tanto","tapar","tapioca","tardio","tarefa","tarja","tarraxa","tatuagem","taurino","taxativo","taxista","teatral","tecer","tecido","teclado","tedioso","teia","teimar","telefone","telhado","tempero","tenente","tensor","tentar","termal","terno","terreno","tese","tesoura","testado","teto","textura","texugo","tiara","tigela","tijolo","timbrar","timidez","tingido","tinteiro","tiragem","titular","toalha","tocha","tolerar","tolice","tomada","tomilho","tonel","tontura","topete","tora","torcido","torneio","torque","torrada","torto","tostar","touca","toupeira","toxina","trabalho","tracejar","tradutor","trafegar","trajeto","trama","trancar","trapo","traseiro","tratador","travar","treino","tremer","trepidar","trevo","triagem","tribo","triciclo","tridente","trilogia","trindade","triplo","triturar","triunfal","trocar","trombeta","trova","trunfo","truque","tubular","tucano","tudo","tulipa","tupi","turbo","turma","turquesa","tutelar","tutorial","uivar","umbigo","unha","unidade","uniforme","urologia","urso","urtiga","urubu","usado","usina","usufruir","vacina","vadiar","vagaroso","vaidoso","vala","valente","validade","valores","vantagem","vaqueiro","varanda","vareta","varrer","vascular","vasilha","vassoura","vazar","vazio","veado","vedar","vegetar","veicular","veleiro","velhice","veludo","vencedor","vendaval","venerar","ventre","verbal","verdade","vereador","vergonha","vermelho","verniz","versar","vertente","vespa","vestido","vetorial","viaduto","viagem","viajar","viatura","vibrador","videira","vidraria","viela","viga","vigente","vigiar","vigorar","vilarejo","vinco","vinheta","vinil","violeta","virada","virtude","visitar","visto","vitral","viveiro","vizinho","voador","voar","vogal","volante","voleibol","voltagem","volumoso","vontade","vulto","vuvuzela","xadrez","xarope","xeque","xeretar","xerife","xingar","zangado","zarpar","zebu","zelador","zombar","zoologia","zumbido"]')},659:e=>{"use strict";e.exports=JSON.parse('["ábaco","abdomen","abeja","abierto","abogado","abono","aborto","abrazo","abrir","abuelo","abuso","acabar","academia","acceso","acción","aceite","acelga","acento","aceptar","ácido","aclarar","acné","acoger","acoso","activo","acto","actriz","actuar","acudir","acuerdo","acusar","adicto","admitir","adoptar","adorno","aduana","adulto","aéreo","afectar","afición","afinar","afirmar","ágil","agitar","agonía","agosto","agotar","agregar","agrio","agua","agudo","águila","aguja","ahogo","ahorro","aire","aislar","ajedrez","ajeno","ajuste","alacrán","alambre","alarma","alba","álbum","alcalde","aldea","alegre","alejar","alerta","aleta","alfiler","alga","algodón","aliado","aliento","alivio","alma","almeja","almíbar","altar","alteza","altivo","alto","altura","alumno","alzar","amable","amante","amapola","amargo","amasar","ámbar","ámbito","ameno","amigo","amistad","amor","amparo","amplio","ancho","anciano","ancla","andar","andén","anemia","ángulo","anillo","ánimo","anís","anotar","antena","antiguo","antojo","anual","anular","anuncio","añadir","añejo","año","apagar","aparato","apetito","apio","aplicar","apodo","aporte","apoyo","aprender","aprobar","apuesta","apuro","arado","araña","arar","árbitro","árbol","arbusto","archivo","arco","arder","ardilla","arduo","área","árido","aries","armonía","arnés","aroma","arpa","arpón","arreglo","arroz","arruga","arte","artista","asa","asado","asalto","ascenso","asegurar","aseo","asesor","asiento","asilo","asistir","asno","asombro","áspero","astilla","astro","astuto","asumir","asunto","atajo","ataque","atar","atento","ateo","ático","atleta","átomo","atraer","atroz","atún","audaz","audio","auge","aula","aumento","ausente","autor","aval","avance","avaro","ave","avellana","avena","avestruz","avión","aviso","ayer","ayuda","ayuno","azafrán","azar","azote","azúcar","azufre","azul","baba","babor","bache","bahía","baile","bajar","balanza","balcón","balde","bambú","banco","banda","baño","barba","barco","barniz","barro","báscula","bastón","basura","batalla","batería","batir","batuta","baúl","bazar","bebé","bebida","bello","besar","beso","bestia","bicho","bien","bingo","blanco","bloque","blusa","boa","bobina","bobo","boca","bocina","boda","bodega","boina","bola","bolero","bolsa","bomba","bondad","bonito","bono","bonsái","borde","borrar","bosque","bote","botín","bóveda","bozal","bravo","brazo","brecha","breve","brillo","brinco","brisa","broca","broma","bronce","brote","bruja","brusco","bruto","buceo","bucle","bueno","buey","bufanda","bufón","búho","buitre","bulto","burbuja","burla","burro","buscar","butaca","buzón","caballo","cabeza","cabina","cabra","cacao","cadáver","cadena","caer","café","caída","caimán","caja","cajón","cal","calamar","calcio","caldo","calidad","calle","calma","calor","calvo","cama","cambio","camello","camino","campo","cáncer","candil","canela","canguro","canica","canto","caña","cañón","caoba","caos","capaz","capitán","capote","captar","capucha","cara","carbón","cárcel","careta","carga","cariño","carne","carpeta","carro","carta","casa","casco","casero","caspa","castor","catorce","catre","caudal","causa","cazo","cebolla","ceder","cedro","celda","célebre","celoso","célula","cemento","ceniza","centro","cerca","cerdo","cereza","cero","cerrar","certeza","césped","cetro","chacal","chaleco","champú","chancla","chapa","charla","chico","chiste","chivo","choque","choza","chuleta","chupar","ciclón","ciego","cielo","cien","cierto","cifra","cigarro","cima","cinco","cine","cinta","ciprés","circo","ciruela","cisne","cita","ciudad","clamor","clan","claro","clase","clave","cliente","clima","clínica","cobre","cocción","cochino","cocina","coco","código","codo","cofre","coger","cohete","cojín","cojo","cola","colcha","colegio","colgar","colina","collar","colmo","columna","combate","comer","comida","cómodo","compra","conde","conejo","conga","conocer","consejo","contar","copa","copia","corazón","corbata","corcho","cordón","corona","correr","coser","cosmos","costa","cráneo","cráter","crear","crecer","creído","crema","cría","crimen","cripta","crisis","cromo","crónica","croqueta","crudo","cruz","cuadro","cuarto","cuatro","cubo","cubrir","cuchara","cuello","cuento","cuerda","cuesta","cueva","cuidar","culebra","culpa","culto","cumbre","cumplir","cuna","cuneta","cuota","cupón","cúpula","curar","curioso","curso","curva","cutis","dama","danza","dar","dardo","dátil","deber","débil","década","decir","dedo","defensa","definir","dejar","delfín","delgado","delito","demora","denso","dental","deporte","derecho","derrota","desayuno","deseo","desfile","desnudo","destino","desvío","detalle","detener","deuda","día","diablo","diadema","diamante","diana","diario","dibujo","dictar","diente","dieta","diez","difícil","digno","dilema","diluir","dinero","directo","dirigir","disco","diseño","disfraz","diva","divino","doble","doce","dolor","domingo","don","donar","dorado","dormir","dorso","dos","dosis","dragón","droga","ducha","duda","duelo","dueño","dulce","dúo","duque","durar","dureza","duro","ébano","ebrio","echar","eco","ecuador","edad","edición","edificio","editor","educar","efecto","eficaz","eje","ejemplo","elefante","elegir","elemento","elevar","elipse","élite","elixir","elogio","eludir","embudo","emitir","emoción","empate","empeño","empleo","empresa","enano","encargo","enchufe","encía","enemigo","enero","enfado","enfermo","engaño","enigma","enlace","enorme","enredo","ensayo","enseñar","entero","entrar","envase","envío","época","equipo","erizo","escala","escena","escolar","escribir","escudo","esencia","esfera","esfuerzo","espada","espejo","espía","esposa","espuma","esquí","estar","este","estilo","estufa","etapa","eterno","ética","etnia","evadir","evaluar","evento","evitar","exacto","examen","exceso","excusa","exento","exigir","exilio","existir","éxito","experto","explicar","exponer","extremo","fábrica","fábula","fachada","fácil","factor","faena","faja","falda","fallo","falso","faltar","fama","familia","famoso","faraón","farmacia","farol","farsa","fase","fatiga","fauna","favor","fax","febrero","fecha","feliz","feo","feria","feroz","fértil","fervor","festín","fiable","fianza","fiar","fibra","ficción","ficha","fideo","fiebre","fiel","fiera","fiesta","figura","fijar","fijo","fila","filete","filial","filtro","fin","finca","fingir","finito","firma","flaco","flauta","flecha","flor","flota","fluir","flujo","flúor","fobia","foca","fogata","fogón","folio","folleto","fondo","forma","forro","fortuna","forzar","fosa","foto","fracaso","frágil","franja","frase","fraude","freír","freno","fresa","frío","frito","fruta","fuego","fuente","fuerza","fuga","fumar","función","funda","furgón","furia","fusil","fútbol","futuro","gacela","gafas","gaita","gajo","gala","galería","gallo","gamba","ganar","gancho","ganga","ganso","garaje","garza","gasolina","gastar","gato","gavilán","gemelo","gemir","gen","género","genio","gente","geranio","gerente","germen","gesto","gigante","gimnasio","girar","giro","glaciar","globo","gloria","gol","golfo","goloso","golpe","goma","gordo","gorila","gorra","gota","goteo","gozar","grada","gráfico","grano","grasa","gratis","grave","grieta","grillo","gripe","gris","grito","grosor","grúa","grueso","grumo","grupo","guante","guapo","guardia","guerra","guía","guiño","guion","guiso","guitarra","gusano","gustar","haber","hábil","hablar","hacer","hacha","hada","hallar","hamaca","harina","haz","hazaña","hebilla","hebra","hecho","helado","helio","hembra","herir","hermano","héroe","hervir","hielo","hierro","hígado","higiene","hijo","himno","historia","hocico","hogar","hoguera","hoja","hombre","hongo","honor","honra","hora","hormiga","horno","hostil","hoyo","hueco","huelga","huerta","hueso","huevo","huida","huir","humano","húmedo","humilde","humo","hundir","huracán","hurto","icono","ideal","idioma","ídolo","iglesia","iglú","igual","ilegal","ilusión","imagen","imán","imitar","impar","imperio","imponer","impulso","incapaz","índice","inerte","infiel","informe","ingenio","inicio","inmenso","inmune","innato","insecto","instante","interés","íntimo","intuir","inútil","invierno","ira","iris","ironía","isla","islote","jabalí","jabón","jamón","jarabe","jardín","jarra","jaula","jazmín","jefe","jeringa","jinete","jornada","joroba","joven","joya","juerga","jueves","juez","jugador","jugo","juguete","juicio","junco","jungla","junio","juntar","júpiter","jurar","justo","juvenil","juzgar","kilo","koala","labio","lacio","lacra","lado","ladrón","lagarto","lágrima","laguna","laico","lamer","lámina","lámpara","lana","lancha","langosta","lanza","lápiz","largo","larva","lástima","lata","látex","latir","laurel","lavar","lazo","leal","lección","leche","lector","leer","legión","legumbre","lejano","lengua","lento","leña","león","leopardo","lesión","letal","letra","leve","leyenda","libertad","libro","licor","líder","lidiar","lienzo","liga","ligero","lima","límite","limón","limpio","lince","lindo","línea","lingote","lino","linterna","líquido","liso","lista","litera","litio","litro","llaga","llama","llanto","llave","llegar","llenar","llevar","llorar","llover","lluvia","lobo","loción","loco","locura","lógica","logro","lombriz","lomo","lonja","lote","lucha","lucir","lugar","lujo","luna","lunes","lupa","lustro","luto","luz","maceta","macho","madera","madre","maduro","maestro","mafia","magia","mago","maíz","maldad","maleta","malla","malo","mamá","mambo","mamut","manco","mando","manejar","manga","maniquí","manjar","mano","manso","manta","mañana","mapa","máquina","mar","marco","marea","marfil","margen","marido","mármol","marrón","martes","marzo","masa","máscara","masivo","matar","materia","matiz","matriz","máximo","mayor","mazorca","mecha","medalla","medio","médula","mejilla","mejor","melena","melón","memoria","menor","mensaje","mente","menú","mercado","merengue","mérito","mes","mesón","meta","meter","método","metro","mezcla","miedo","miel","miembro","miga","mil","milagro","militar","millón","mimo","mina","minero","mínimo","minuto","miope","mirar","misa","miseria","misil","mismo","mitad","mito","mochila","moción","moda","modelo","moho","mojar","molde","moler","molino","momento","momia","monarca","moneda","monja","monto","moño","morada","morder","moreno","morir","morro","morsa","mortal","mosca","mostrar","motivo","mover","móvil","mozo","mucho","mudar","mueble","muela","muerte","muestra","mugre","mujer","mula","muleta","multa","mundo","muñeca","mural","muro","músculo","museo","musgo","música","muslo","nácar","nación","nadar","naipe","naranja","nariz","narrar","nasal","natal","nativo","natural","náusea","naval","nave","navidad","necio","néctar","negar","negocio","negro","neón","nervio","neto","neutro","nevar","nevera","nicho","nido","niebla","nieto","niñez","niño","nítido","nivel","nobleza","noche","nómina","noria","norma","norte","nota","noticia","novato","novela","novio","nube","nuca","núcleo","nudillo","nudo","nuera","nueve","nuez","nulo","número","nutria","oasis","obeso","obispo","objeto","obra","obrero","observar","obtener","obvio","oca","ocaso","océano","ochenta","ocho","ocio","ocre","octavo","octubre","oculto","ocupar","ocurrir","odiar","odio","odisea","oeste","ofensa","oferta","oficio","ofrecer","ogro","oído","oír","ojo","ola","oleada","olfato","olivo","olla","olmo","olor","olvido","ombligo","onda","onza","opaco","opción","ópera","opinar","oponer","optar","óptica","opuesto","oración","orador","oral","órbita","orca","orden","oreja","órgano","orgía","orgullo","oriente","origen","orilla","oro","orquesta","oruga","osadía","oscuro","osezno","oso","ostra","otoño","otro","oveja","óvulo","óxido","oxígeno","oyente","ozono","pacto","padre","paella","página","pago","país","pájaro","palabra","palco","paleta","pálido","palma","paloma","palpar","pan","panal","pánico","pantera","pañuelo","papá","papel","papilla","paquete","parar","parcela","pared","parir","paro","párpado","parque","párrafo","parte","pasar","paseo","pasión","paso","pasta","pata","patio","patria","pausa","pauta","pavo","payaso","peatón","pecado","pecera","pecho","pedal","pedir","pegar","peine","pelar","peldaño","pelea","peligro","pellejo","pelo","peluca","pena","pensar","peñón","peón","peor","pepino","pequeño","pera","percha","perder","pereza","perfil","perico","perla","permiso","perro","persona","pesa","pesca","pésimo","pestaña","pétalo","petróleo","pez","pezuña","picar","pichón","pie","piedra","pierna","pieza","pijama","pilar","piloto","pimienta","pino","pintor","pinza","piña","piojo","pipa","pirata","pisar","piscina","piso","pista","pitón","pizca","placa","plan","plata","playa","plaza","pleito","pleno","plomo","pluma","plural","pobre","poco","poder","podio","poema","poesía","poeta","polen","policía","pollo","polvo","pomada","pomelo","pomo","pompa","poner","porción","portal","posada","poseer","posible","poste","potencia","potro","pozo","prado","precoz","pregunta","premio","prensa","preso","previo","primo","príncipe","prisión","privar","proa","probar","proceso","producto","proeza","profesor","programa","prole","promesa","pronto","propio","próximo","prueba","público","puchero","pudor","pueblo","puerta","puesto","pulga","pulir","pulmón","pulpo","pulso","puma","punto","puñal","puño","pupa","pupila","puré","quedar","queja","quemar","querer","queso","quieto","química","quince","quitar","rábano","rabia","rabo","ración","radical","raíz","rama","rampa","rancho","rango","rapaz","rápido","rapto","rasgo","raspa","rato","rayo","raza","razón","reacción","realidad","rebaño","rebote","recaer","receta","rechazo","recoger","recreo","recto","recurso","red","redondo","reducir","reflejo","reforma","refrán","refugio","regalo","regir","regla","regreso","rehén","reino","reír","reja","relato","relevo","relieve","relleno","reloj","remar","remedio","remo","rencor","rendir","renta","reparto","repetir","reposo","reptil","res","rescate","resina","respeto","resto","resumen","retiro","retorno","retrato","reunir","revés","revista","rey","rezar","rico","riego","rienda","riesgo","rifa","rígido","rigor","rincón","riñón","río","riqueza","risa","ritmo","rito","rizo","roble","roce","rociar","rodar","rodeo","rodilla","roer","rojizo","rojo","romero","romper","ron","ronco","ronda","ropa","ropero","rosa","rosca","rostro","rotar","rubí","rubor","rudo","rueda","rugir","ruido","ruina","ruleta","rulo","rumbo","rumor","ruptura","ruta","rutina","sábado","saber","sabio","sable","sacar","sagaz","sagrado","sala","saldo","salero","salir","salmón","salón","salsa","salto","salud","salvar","samba","sanción","sandía","sanear","sangre","sanidad","sano","santo","sapo","saque","sardina","sartén","sastre","satán","sauna","saxofón","sección","seco","secreto","secta","sed","seguir","seis","sello","selva","semana","semilla","senda","sensor","señal","señor","separar","sepia","sequía","ser","serie","sermón","servir","sesenta","sesión","seta","setenta","severo","sexo","sexto","sidra","siesta","siete","siglo","signo","sílaba","silbar","silencio","silla","símbolo","simio","sirena","sistema","sitio","situar","sobre","socio","sodio","sol","solapa","soldado","soledad","sólido","soltar","solución","sombra","sondeo","sonido","sonoro","sonrisa","sopa","soplar","soporte","sordo","sorpresa","sorteo","sostén","sótano","suave","subir","suceso","sudor","suegra","suelo","sueño","suerte","sufrir","sujeto","sultán","sumar","superar","suplir","suponer","supremo","sur","surco","sureño","surgir","susto","sutil","tabaco","tabique","tabla","tabú","taco","tacto","tajo","talar","talco","talento","talla","talón","tamaño","tambor","tango","tanque","tapa","tapete","tapia","tapón","taquilla","tarde","tarea","tarifa","tarjeta","tarot","tarro","tarta","tatuaje","tauro","taza","tazón","teatro","techo","tecla","técnica","tejado","tejer","tejido","tela","teléfono","tema","temor","templo","tenaz","tender","tener","tenis","tenso","teoría","terapia","terco","término","ternura","terror","tesis","tesoro","testigo","tetera","texto","tez","tibio","tiburón","tiempo","tienda","tierra","tieso","tigre","tijera","tilde","timbre","tímido","timo","tinta","tío","típico","tipo","tira","tirón","titán","títere","título","tiza","toalla","tobillo","tocar","tocino","todo","toga","toldo","tomar","tono","tonto","topar","tope","toque","tórax","torero","tormenta","torneo","toro","torpedo","torre","torso","tortuga","tos","tosco","toser","tóxico","trabajo","tractor","traer","tráfico","trago","traje","tramo","trance","trato","trauma","trazar","trébol","tregua","treinta","tren","trepar","tres","tribu","trigo","tripa","triste","triunfo","trofeo","trompa","tronco","tropa","trote","trozo","truco","trueno","trufa","tubería","tubo","tuerto","tumba","tumor","túnel","túnica","turbina","turismo","turno","tutor","ubicar","úlcera","umbral","unidad","unir","universo","uno","untar","uña","urbano","urbe","urgente","urna","usar","usuario","útil","utopía","uva","vaca","vacío","vacuna","vagar","vago","vaina","vajilla","vale","válido","valle","valor","válvula","vampiro","vara","variar","varón","vaso","vecino","vector","vehículo","veinte","vejez","vela","velero","veloz","vena","vencer","venda","veneno","vengar","venir","venta","venus","ver","verano","verbo","verde","vereda","verja","verso","verter","vía","viaje","vibrar","vicio","víctima","vida","vídeo","vidrio","viejo","viernes","vigor","vil","villa","vinagre","vino","viñedo","violín","viral","virgo","virtud","visor","víspera","vista","vitamina","viudo","vivaz","vivero","vivir","vivo","volcán","volumen","volver","voraz","votar","voto","voz","vuelo","vulgar","yacer","yate","yegua","yema","yerno","yeso","yodo","yoga","yogur","zafiro","zanja","zapato","zarza","zona","zorro","zumo","zurdo"]')}},t={};function r(n){var o=t[n];if(void 0!==o)return o.exports;var i=t[n]={exports:{}};return e[n](i,i.exports,r),i.exports}return r.d=(e,t)=>{for(var n in t)r.o(t,n)&&!r.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},r.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),r.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),r.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},r(6862)})());